  PROGRAM testw
! ------------------------------------------------------
! This is a test program for the Fortran 90 
! module Parabolw.
! ------------------------------------------------------
! 1)First, we compare the values obtained from 
!   the routine parab with 15(non-scaled)+15(scaled)
!   pre-computed values of the functions W(a,x), 
!   W'(a,x), W(a,-x), W'(a,-x).
!   Relative errors are shown.
! 2)Second, we test the Wronskian relation:
!   W[W(a,x),W(a,-x)]=W(a,x)*W'(a,-x)+W'(a,x)*W(a,-x)=-1 
!   for several values of (a,x).
! ------------------------------------------------------ 
  USE Parabolw
  USE someconstants
  IMPLICIT NONE
  REAL(r8) a,x,wmax,wrons
  REAL(r8) x1(15),a1(15),x2(15),a2(15)
  REAL(r8) w(15),wp(15),wm(15),wmp(15)
  REAL(r8) ws(15),wps(15),wms(15),wmps(15)
  REAL(r8) err1,err2,err3,err4
  REAL(r8)waxx(2),wamx(2)
  INTEGER i,j,ierr1,mode
  DATA x1/1.0_r8,3.0_r8,5.0_r8,6.0_r8,7.0_r8,8.0_r8,&
          9.0_r8,10.0_r8,11.0_r8,13.0_r8,15.0_r8,&
          17.0_r8,19.0_r8,21.0_r8,23.0_r8/
  DATA a1/-90.0_r8,-60.0_r8,-45.0_r8,-30.0_r8,-21.0_r8,&
          -17.0_r8,-11.0_r8,-3.0_r8,-1.0_r8,1.0_r8,7.0_r8,&
          11.0_r8,17.0_r8,21.0_r8,30.0_r8/
  DATA x2/10.0_r8,30.0_r8,50.0_r8,70.0_r8,90.0_r8,110.0_r8,&
          130.0_r8,150.0_r8,170.0_r8,190.0_r8,210.0_r8,230.0_r8,&
          350.0_r8,450.0_r8,500.0_r8/
  DATA a2/60.0_r8,70.0_r8,110.0_r8,150.0_r8,170.0_r8,210.0_r8,&
          240.0_r8,300.0_r8,380.0_r8,500.0_r8,530.0_r8,700.0_r8,&
          900.0_r8,1000.0_r8,10000.0_r8/
  DATA w/-0.21369573855412_r8,0.20260490873938_r8,&
         -0.32265903323409_r8,-0.31470411390593_r8,&
         -0.15326581829014_r8,0.32357198306539_r8,&
          0.37580820102786_r8,0.17242944200845_r8,&
         -0.33060016681999_r8,-0.38396860502046e-01_r8,&
         -0.35307096543219e-05_r8,0.69905323261452e-08_r8,&
          0.55436821189744e-12_r8,0.10858707972112e-14_r8,&
          0.67006144811916e-21_r8/
  DATA wp/0.23194867554135e+01_r8,0.23084419618475e+01_r8,&
          0.13542651163218e+01_r8,0.15495932113862e+01_r8,&
          0.22367917093459e+01_r8,-0.15229112920186e+01_r8,&
         -0.10982162438000e+01_r8,-0.21193147535417e+01_r8,&
         -0.13776387485606e+01_r8,-0.27758236338597_r8,&
          0.19461725829112e-04_r8,0.28865110776569e-07_r8,&
         -0.22178005809990e-11_r8,0.18770816733292e-15_r8,&
         -0.36680768464591e-20_r8/
  DATA wm/-0.24412720333909_r8,-0.29274214044587_r8,&
         -0.18862533714743_r8,-0.24716847695830_r8,&
         -0.38721098892286_r8,0.26339457451235_r8,&
          0.19402714597201_r8,0.39905167436437_r8,&
          0.26001159125670_r8,0.20119795948721e+01_r8,&
         -0.19570981657829e+05_r8,-0.75789529716316e+07_r8,&
          0.80427105085275e+11_r8,-0.20861228417152e+13_r8,&
          0.61614836941816e+20_r8/
  DATA wmp/0.20297558957124e+01_r8,-0.16002660597466e+01_r8,&
          0.23075482449197e+01_r8,0.19605381015807e+01_r8,&
          0.87357815136730_r8,-0.18508197852769e+01_r8,&
         -0.20939304528297e+01_r8,-0.89476540257262_r8,&
          0.19413116544473e+01_r8,0.11498595020484e+02_r8,&
          0.17535141129798e+06_r8,-0.11175582151041e+09_r8,&
         -0.14820992653991e+13_r8,-.92055926015492e+15_r8,&
         -0.11551060658510e+22_r8/
  DATA ws/0.29155477269945_r8,-0.15419566533392_r8,&
          0.12255051827831_r8,0.10633082226566_r8,&
          0.89218908127351e-01_r8,-0.81180223489943e-01_r8,&
         -0.88116911067751e-01_r8,-0.76120603683229e-03_r8,&
          0.22574800236582e-01_r8,0.73552812407508e-01_r8,&
         -0.33398719956926e-01_r8,0.61035377706511e-01_r8,&
         -0.13643863514780e-02_r8,-0.45393635029182e-01_r8,&
          0.54934274519249e-02_r8/
  DATA wps/-0.17141922145758e+01_r8,0.15973473611920e+01_r8,&
          0.18990941070130e+01_r8,0.20581108337978e+01_r8,&
          0.26011948833249e+01_r8,-0.28239251418823e+01_r8,&
         -0.78801672553701_r8,0.60401362418101e+01_r8,&
         -0.61546535588516e+01_r8,0.21210382496961_r8,&
          0.62862309123132e+01_r8,-0.30493979795835e+01_r8,&
         -0.92816661436668e+01_r8,0.30211373968877e+01_r8,&
         -0.10629214448077e+02_r8/
  DATA wms/0.28991970792408_r8,-0.25600303594958_r8,&
         -0.16749916264174_r8,-0.12559636530919_r8,&
         -0.12081510788442_r8,0.10646453181454_r8,&
          0.24977516311484e-01_r8,-0.16554525228908_r8,&
          0.14877910266275_r8,-0.45988650844936e-02_r8,&
         -0.12272225660192_r8,0.54492318041818e-01_r8,&
          0.10767009617140_r8,-0.27123318009806e-01_r8,&
          0.92779332980844e-01_r8/
  DATA wmps/-0.17253083843117e+01_r8,0.38332739431344e+01_r8,&
          -0.55642631045337e+01_r8,-0.69736012952002e+01_r8,&
          -0.76859981133583e+01_r8,0.86148091471666e+01_r8,&
           0.11125189109619e+02_r8,0.11051145822045_r8,&
          -0.37349684351739e+01_r8,-0.13582411473135e+02_r8,&
           0.68427639506816e+01_r8,-0.13661441393382e+02_r8,&
           0.47062452648893_r8,0.20224349273697e+02_r8,&
          -0.25172942608454e+01_r8/
  open(unit=1,file='testf.dat',status='unknown') 
! ------------------------------------------------
! We check the values of the unscaled functions
! ------------------------------------------------
  write(1,*)'ERR means relative error'
  write(1,*)'********************************************'
  write(1,*)'Test of the values of the unscaled functions'
  write(1,*)'********************************************'
  write(1,30)'x','a','ERR(Wax)','ERR(Waxp)','ERR(Wamx)','ERR(Wamxp)'
  DO i=1,15
    x=x1(i)
    a=a1(i) 
    ierr1=0
    mode=0
    CALL parabw(a,x,mode,waxx,wamx,ierr1)
    err1=abs(1.0_r8-waxx(1)/w(i))
    err2=abs(1.0_r8-waxx(2)/wp(i))
    err3=abs(1.0_r8-wamx(1)/wm(i))
    err4=abs(1.0_r8-wamx(2)/wmp(i))
    write(1,31)int(x),int(a),err1,err2,err3,err4
  ENDDO
! ------------------------------------------------
! We check the values of the scaled functions
! ------------------------------------------------
  write(1,*)'********************************************'
  write(1,*)'Test of the values of the scaled functions'
  write(1,*)'********************************************'
  write(1,30)'x','a','ERR(Wax)','ERR(Waxp)','ERR(Wamx)','ERR(Wamxp)'
  DO i=1,15
    x=x2(i)
    a=a2(i) 
    ierr1=0
    mode=1
    CALL parabw(a,x,mode,waxx,wamx,ierr1)
    err1=abs(1.0_r8-waxx(1)/ws(i))
    err2=abs(1.0_r8-waxx(2)/wps(i))
    err3=abs(1.0_r8-wamx(1)/wms(i))
    err4=abs(1.0_r8-wamx(2)/wmps(i))
    write(1,31)int(x),int(a),err1,err2,err3,err4   
  ENDDO 
 ! ---------------------------------------------------------
 !  Test of the Wronskian relation
 ! ---------------------------------------------------------
 ! We test the relation for 0<x<=1000,  -1000<a<=1000        
 ! ---------------------------------------------------------
 ! This is a Wronskian test for the scaled functions       
  mode=1
 ! ---------------------------------------------------------
  write(1,*)' '
  write(1,*)'--------------------------------------------------'
  write(1,*)'Test of the Wronskian relation for W(a,x), W(a,-x)' 
  write(1,*)'--------------------------------------------------'
  wmax=0.0_r8
  DO i=1,100,1
    DO j=-100,100,20
      x=i*0.95_r8
      a=j*0.9_r8
      ierr1=0
      CALL parabw(a,x,mode,waxx,wamx,ierr1)    
      IF (ierr1==0) THEN
        wrons=abs(1.d0+waxx(1)*wamx(2)+waxx(2)*wamx(1));   
        IF (wrons>wmax) THEN
          wmax=wrons
        ENDIF
      ENDIF
    ENDDO
  ENDDO
  write(1,*)' '
  write(1,*)'Maximum value of the Wronskian check =',wmax
 30 format(3x,a1,3x,a1,8x,a9,8x,a9,8x,a9,8x,a10)
 31 format(i4,1x,i5,d16.9,1x,d16.9,1x,d16.9,1x,d16.9)    
  END PROGRAM testw

     


