
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00902_zeta_all_x : public TestCaseReal
    {
    public:
      TestCase_case_00902_zeta_all_x() { }
      virtual ~TestCase_case_00902_zeta_all_x() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00902_zeta_all_x");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::riemann_zeta((ef::pi() * k) / 2);
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-0.5"),
           e_float("2.3690846911023631843575714737220845826771250675561325595805850979689646847901737279205525247720364151864613383678295270822495906695509317269145979451864572587787137202920407685038080445505510658459229517782511824220089180311631977355667520437947601215599357817395730936098078506020463300085068000943026132359504788266425506555272117352316050644640601526872667055395662612349208166636538817785794995958"),
           e_float("1.1762417383825827588721504519380520911697389900216558349605083462304087237681586183357208373255718311389456600814530083686969752901158193791439440633774525959356512432924761830245287225253682480509935601329034182957720362068427149543106043103832048353670452264557887145779766360000205618741908519172397946696783614673659892050530221732641770393665550622256501968284091715061280143774641994151736796336"),
           e_float("1.0462215446234359232003852167924580759866918756316371822102302799942815111872200940576534162917186093945337873576726525497496482268803843430178639940197862116880952936841511399986530398828280496716033184776820048732526254229313840197394669806150636993064056413365659481514958783807625294621609089073850750900996094797963750790274063402595584583188020839057773816853027295339886854614037099368781964968"),
           e_float("1.0140728601500397882265887323317847726639716333774749781201007301950868222603292523032711725834723068910606017177679556802992672111289250711773664976266636709553038007376235021074036536620970347165629571391917449773790556122192265289054382129209205739556689721804693490173681743499278431006691412447538372331723192781024400700029287595454515589040815622377095677535319310314454147557577273996185364477"),
           e_float("1.0045243121369520561256342084075031459673975503177771617369816095600370264756569479671559306314546264811952718631926694069193817461877518252164821135222662793183444752616854712157490334656729489907241683960724467730858888573053997272546711308072580858858412601899000854931180011366761879411557473104638282726108693401568779587941725888796792198262618890723461572624856886394453564092762615482425396672"),
           e_float("1.0014892838852106112387308506281858011036774177714544633189403339805298473115531178886714143436846642669070365810329966716137914358888955369281793743482281061882029361546283463876250176019218748953933157987071582670498646074360430839700980688594016414153450355452166458454852571009721100200819238284647791876877146085446254753946213389281405506225274314872606663892129729345902008120996665927540333948"),
           e_float("1.0004957179450844964033744246212238554866459626011464318339675630145694048408430006504887401094985350871284970640869428183205748951968255531771166374326596823919413842332571972011576468586684366888473338989848892702340567285145467369387700041089346890853803979020329588948869902434470416892181302844509091431476291038570479766311976756466511442635111653680736796117394658316021198695361660850058913281"),
           e_float("1.0001659104855369653841636229904648609158323669105546563250754559443440431060134613707911467345330946150888515800543120166062857184844835221910384229428738120248953598552632994535969469099217227322583781986004882403125264302640025528257729202326519876678823047966172467588451308122511383467920831383310118471407759584236444641869671144482126023314615145251356459660393919810456003349698687086727527419"),
           e_float("1.0000556825031017534035894953151605746332500444431815130985098237388928632045425364612641957578187433636701208593828758396375249254042687979306864613068599935830214414240553012351858997557877763685297729145691875243825683496815296548145277091659362942841367695192725911815753857546026960604447159133214698118659874524874363074977285887793581110915653253169183028706813771226875699624760716641393299895"),
           e_float("1.0000187147447851932066420615195107179754380692332584596308618048115377921779248827449512747727267673976741435879770614014360911329360734549513981354843699821108446510106038819251141756718591187275068793415374679049996626550788651016612145793903218565732276211308032366058633717003227323039542239905169312067553413680618625439192048674429825278190931299414684772442435791542796504329450490879215573469"),
           e_float("1.0000062946468115166190789713551719035721616860408479757407844533988471907222398431346814503270593831131364060827027523758672194489944124930886107796982283114704820827517006183617209497559465954158936670877400212904697070198148233917500064138552123493020012014740681019800064906428904020007641081720027886142552700105977822652554212822570466136320870677110269065705607916216535289881061679852511094389"),
           e_float("1.0000021180069233343710932950677439672246001429796291853182656054429182533704700199285977666102188126738609456640395769673366426116629791214828810640238620692761902104311612850392850051070062092994645599453703973225376180442825860541937192619223235169801759192927182885763576885928580871832283348789589647703711769970312492282955327772258093686638977830736801522251333402722403158927589870168646157104"),
           e_float("1.0000007128068891176168643001939036935406201484151777581959923722876201323679758407123393828624064004142128904985471308443813251302249749600095044586308951853297994601157261886808131562595739774862490323695694389068635129554713613419904454049018441286664341794405198878398065401197783159594470421767288881863821384508734787584027508993327326701572709489441423595724301201517542608461283406408763298179"),
           e_float("1.0000002399180904308545076336893684727161025552391417564798671329737857469067369912519314180860221402094446167708012244911702143994546817818440669040602242292427147289378001142821042759901245490350710521020199812462230347294510958994294779665692070745690412930852652922133737882961299476280002753758469895578735408227540598899077416519789891792019410313390810440227997670196055847403020840952124484821"),
           e_float("1.0000000807567207318341170130707814580896865538282896849936816409364311336414786982129685926975109348158683776584470537791411040468290443824328459678641378932099120778755380174905155013843739411339831283514743790459357111001105583684412833798395040266261606915383167870032802653018355711307978722223502633996142063044626064401855691879976732925834828782731120648376285201069655902764924336469528883354"),
           e_float("1.0000000271836222313448484644834598950790939153865636478411689055062560558635311173061824098603750654450377622868608417988319464731788606944111833446655980936139563026626514400456922878842418718424427309434487464901792923398125329408046144239607167039296611090725644523760898649877749275909182395094324418813696945469555610254208423680717542226388009989094301512155858402652863283319709468560848122653"),
           e_float("1.0000000091504579519262556759736671741348937311467671417838470625451404826484534335861051851062979959569501559009677003916768823390990702315613862545527423004767599326925982088689933783573837796176100482412127627807745972370716237909627768235127697512907281868205300926629823388120101222208522674635297771474519154983460870172033017824526562800693686906684117213773717756464290250733182865509129417137"),
           e_float("1.0000000030802215492679805323498876637058632401037369881247595496654391631232779374462092326598548583281865708227304764715158993216571170296159561533148528675820796477024177329909473198772782915013125819195826352080766904047574260485075420983730798543628800438199834064242004334982934613059036611882547195729084683766946268739190149953964254843870810470213514229820547633901452248921319537605969678812"),
           e_float("1.0000000010368668618034816753290213947007097971598441045912079321229336840395999178144205785964538569451176134189646610865299107482884042952057131538242660744295485827261532568131880410092756826692196171137992483276272595586752113541296407064867035971768032664572775112694877709146573899127613943528792680993504698352873410423525435983830641024991640742343417119691351114625591465560294728602984227375"),
           e_float("1.0000000003490318400979521846598672855280898436548951085341220824718495600793220303994386730997144901357821775436365744750190070458245887463927621501113473750197283069263128140631992537927089544228681688954927094352768778785541736850687980318773559097824903674297672875668210875855768961104345448356600082249835694354729571170651520982767653562441670393669297391136874134972255154322846987876515187314"),
           e_float("1.0000000001174918208543807150631986825583620570171177102963237216911087235758228798669586178439286564665485724100475034266763588570900553063314343356721909835068391202701333959560256142031549591099309439841251160610828781921388071074783132430432002773770701500962217826828510883829336180068363008164205052270624727443685659051134608991033247401913976824294896909063118549387091594538671124569289270043"),
           e_float("1.0000000000395503658444422739896602073046569895388102621996027986575893131775954785441550780523496437453003616787813460654261844568182304132606630245947683395402736901309330120288421206740651501444286086442323687738967412222984864451836140784670980076053977754186336660215762458678355446612623853218982205882812906700066672277058454123460349810833784626645049861100280754318820695344915868623570462152"),
           e_float("1.0000000000133135393289453876374464057226146459733367057106036009731700240944326526183963839657428478590811098228147196860807578129401162543562118990062713546673107405468576391005034979412910213898776910819261584239259275823198400370394453119275836207415644252050591947224635709503260022605136641169124756284804579340101831199997708353313961719489456180183981896570988921995637593343230852435132018806"),
           e_float("1.0000000000044816364653763593618364392297198773534352021124914961714832328713939109204705495244642203916523839968658327849500513982619614993791294124318165486812431227989580906508120653662499369561255476497079570622600098068135534530564472366816230895012654547893556319197336953164147548775089315677582632002049123987818251201068509311040477460566638979220104703028143026113149105503962248961176518912"),
           e_float("1.0000000000015086196727123401745719639415325572241826950747598463575162311342565239045710666215126885907594838512263301647167092421936389806942985445122754593433242359839614134231529901649473554068807845177970123659577639031397714178533390011729698204007655775328304944738034830463419296117280596959007675379810263369323023464219105007193234107341734332731203972682416639445871633950868821014103289982"),
           e_float("1.0000000000005078353522395359273677140730955538152787037825452666472495480150537336891235997845890033405421067693018198125914324108037394729230795362249457278352888444188019643830338193127903308054441305129840642577462568588218123704464071078552559672835171363159612801843754864629589281249465679401409789906198563838278326189525079004499580761980705385015966117036782904823829317283314373497646176158"),
           e_float("1.0000000000001709488193797253999665531796729573478921785977620665622133622658132659663414215432605817526569697822164536890638704970634806739198720161841525786824339020817805991183772292466254038067557838761901765169150038185052354587671001566347760269776120417294592015859664106113189906606948323499769257537546791561623924204389739278994984469448581514929733032382807134603791258095599859844757152185"),
           e_float("1.0000000000000575452243242431110349955056509254335336699667575475928286598624491550338303912623486966935572063028496859582071439160411718101323427918044784403817161203990743397649699679353815556838778770368829891692938535838891941519238041495959882017484594484391877207973892803717992729426783986839915177545986258130874620002480496256557202644555576678674820527440285580232723402761271869340076649515"),
           e_float("1.0000000000000193710192298530257694205301266671544537768397659131818843827290655429881181451867368768556206394673742110811168818255623188039187672482634788402911756522565785805156223167537627589840724265989896997842406962346191653718758208678423779046505478214222286551115068564042973721526621671932122916141380819685953673977871809230961335181330917306080793408893538734459786670986676821073078996357"),
           e_float("1.0000000000000065207216047553624448753535736799473671551932295721482289041484794542016342546878844045168276697185590204445767463445315059962630905769571711585827434655804661326333513089039770074224059008345739892706777935384344932465642005481129274767647355177207836890548046794319770750539798088974616147791133042815217829745364820947752502365644633750663096831555041850376528266579076673425245314923"),
           e_float("1.0000000000000021950218433004913772479883595014779448277636054096013318667267513673070330476871380869212636341604686872055804602627023279601911033796269814222803846468250597480820497952155205007344620745489309145091583718228233759626535743114613922576897416869365743678858958336166041487439547410738078456974878935216829274187006215946630060895951850803070475832890508646632343966798421861026103381206"),
           e_float("1.0000000000000007388938203456865561262705379170948124080783381579763264074023986257852396960205763289720100278472828113779864901565848914915896300812130994132687258635869873422012073089379307538245147440569942918960453749202089137221915835342666371082957533617761540843216802099447476076147751392555125269085203796546637928080714979159467369388337141472677693293731893604468261227384873803127163416597"),
           e_float("1.0000000000000002487283120821673553935216922356653144701266781388450474742190231840047894008527059680435434309806881207551504782554837128067393634662737399046094290268043431065551866320448493195704697052080530307124880955527256820448036107122840178460469617940673459037363219388268966283109782824785228778274596810959967720954556439616132650973647146989163563932571270220519714364284469036014559690284"),
           e_float("1.0000000000000000837275553632782911543624232370310733310400507260398416374985913918121941154347428064945512243287693315526302791772642367051516860928791904938904109971112660846077918752628701767776394187864438237538790128189810682906594816470811630402640901372729561968512130462550854297287768545513873111436787502515814294745415090941130711710167456226570656048126031140270781556083095432612633476495"),
           e_float("1.0000000000000000281845820830953336285018560802401642318044451799999827962347171304904328612861166128684433872931269287095407166044677705562982813359199274317764893988915309678500992134850351656107074754096964261470738036959782508119837469859916881967728363366327284295693221261633977583701589490107901309530783976922218692388123775637532156193394080431187885835832026298136526376057707594979718756393"),
           e_float("1.0000000000000000094875655191598869280314678697757948015435565978395517644120271514333713498486629591815961111521491838962774980107994529766545827202749238650655232267183291738902031798223630156517176980152074166944460271547047337848033727852485251666104436628706142617970149728964891232564209141261260171170848394805649943395809103510817013493347811199883323476911616204766873030892872785048269143756"),
           e_float("1.0000000000000000031937283731626838593569040495828469234872789594235008626455472098180097162058468713593991927671501535130535309053491676904031450464039819648096114614923795005209530621109400988632574507075572948254376358908584140357567526307934477627143604596847984437758334822823646108103218819025112549215189501290063588106329900544789387096997325577966911906639802550251932780846908966117700013765"),
           e_float("1.0000000000000000010750809468662344391348081528451111206828762864023792711858450837682912117815117957819665817441580378969766595301666751519210436429025167081689067365122766617049099616670408501682646082733232858485633376225703655779542928589697719450577548487285176383565011938778646018282465675561141858685721356996957924881705705881564559997072745876974818110169054707711583945371969592248953033814"),
           e_float("1.0000000000000000003618964756183031389235164985557776493395807609839801605800338747614166569209908433282795127930421198406402946309501515714874620003647908840612398700868884318186529597203910016338981527291775382727083870807735114424175648774383618631122980070538553372986662112323585597691856183594368713015230968529704536177712643311636232617801280617996431428466936598942132827160978589155915368256"),
           e_float("1.000000000000000000121822509688789923079814553483976499046305049415546585242527761372619178188474753193483082865108798891048044419157494732452607481564697396246897202153848223806188372242423625894910074889218295545926186903215607358250221682938304412621501300231452601857585582823771857070739833340018674206565287946786858918592713338530513117863873681406949394404448217838851218366205185438116760802"),
           e_float("1.0000000000000000000410082022533475331952961851412633857860836918249594741936612581262062849951862594111961259301484621032198552967023400229192578580822496669882005528599736973446094646099461869664766027823985783620786651623455338157228506983091745397995255163526597102871245579257619067630289021552217275340588817724845115519693742335711196263446903021578920993928170378363266387359519222121172704906"),
           e_float("1.0000000000000000000138042850730190153442232445047774023828228932195548207745417280021331267791705332809635398530147275770725780473818982113916803594731406969586932699021758321574736205954103365219061849956778188264405439995950960506673198808628847192213807405928267309288020230534478812428894264691316751821135875023523198529776382812766080205254186498687024188769893921323249756933709071566575053482"),
           e_float("1.0000000000000000000046468334602942300116331447833504062115000340815119614320715903455713911827908051865402543668570657146727173966503982088792993311591330715008172918238297488196746365509283264288614298939048840599081650533715953468618277959040975465077899888535667449379155501258036664014647013934520469890991276374467637867658656721011725716030046730747525214481839440423977788513668273609206668217"),
           e_float("1.0000000000000000000015642288675946027294852323911113632368105442966696380276249356227766240251811960569362705104008286066486020724881638844530756464954118653726770236651257389148394660610744752898669313680317375225450189632836057234061370739880434755412907338447736085839805653744381940195344052928172378269766736552802673058625537306010924425001372651091269895935381139617472389832237025682591819818"),
           e_float("1.0000000000000000000005265546895803875335308925710371655692175843055020562310561360685255380694523736810271641822029657532378045856842614644021882436236935111204685098857838114236506911662690922964322635578961119774525722255591899602539339251830453495493496682184000098199366378231143954950467137814767987160171440392469665791565398986821199531005944156880653563698549595281203945445686503523912044893"),
           e_float("1.0000000000000000000001772501753822616173577327555199420844954546948516276224695658034153538819499448864967186267166587836707542591295383471599891009890065452044541775834048199770412723633590921045650100406754519964874822598561150935645385832498749252849939791718128154495689515379279315330209311879114949058414024757793274566505315787304574589182786166889730426354076032328613729500849509965310282036"),
           e_float("1.0000000000000000000000596664036893902873742606886117337877582642889799403278874886718269609597173541819154963299563247883640379486807378081678611498595960545840206724399529553801018813701878980233999086339544640064077329260262492335416810297424470830967149729694429852756478647697817648200488001795098968284581974476555550308758019865420116159414304964896446417506666658515888362836848277356824518863"),
           e_float("1.0000000000000000000000200850561729921568498726368643287549794699474339214286190799591412837100712500119948768529502990053062242471186387611037679019763406897675110758040262981786314900335625396397291810637767347970777493029557591795063822049310926300189178358496599742711647723481908781194777559013436818706114080215682364408729713743908883473490390951332995865794504987185834916752948921983449971384"),
           e_float("1.0000000000000000000000067610825611732391577434082370666226099835516310498536867152896555587173252180596357164396375513840093356860657666173976045550570846835581070406577112631155844153022736059874442574499847618718134935040926978402912231601438345482465538507228068516614721420285659425023133458976146781989439525122932211655607679031334953064006193248069283614852222997837968447595183494271487194847"),
           e_float("1.0000000000000000000000022759327634079240666331125006824671037639190078792107918111949940165956348409264818896625744233604501882295854744416574738521379770027023598277956567335752314041269209865733599863616008228138168540862792539516724813459709228111703540118338460240249486835251014700343768155162139840526010949269991013094493599314327249733337222706919976581612983377642374469994718553635574496041"),
           e_float("1.0000000000000000000000007661302604556285398517301356893031354396901936323844790713856552943512348150632528471176757506697834714836642824555840187032837342864669937150030295425343420989512450308526942389916669880918872942273089907756481895869578216029205407258044541380238789554016532302777698251191534080581603115686831248893866092414919384830483904587483332693823546510320757886199252026692252347322"),
           e_float("1.0000000000000000000000002578967118109933698099010002662740661474029722779784181312401216286959178307874289293778875171726279496336152150857933307035580651910977583016346212639926621452181656740842557889891036244048432841628081664307391246023218492649602037821339743578627431070163510082615277862369678048487758576534583644059667611289925281431584814071633962753487587707466023545481986864685375438249"),
           e_float("1.0000000000000000000000000868138453679767418521000639342552290288692897050255417208529010469796184164100045937562792182279682957245717192415865433414928930736069209960290879933096978925362971109378086146259330831864238812544070219410229394544930481303127110801493189768707606878024560335851823710781689062393527532224135790390526306406815437762468976586119222661853661548280311525550450445927799902579"),
           e_float("1.0000000000000000000000000292234968590775146387255342915024354211692143638363879376348869812075270157187459508011701850497471620789848526497485726469697225037746050416990760700539849535537970321687025491431779938525724914070060925871705939204807593913975576020509538057034005284226608308269902548976276458386872818825324492508550368291518456749888797077059130264073853117661922782547022702347511590286"),
           e_float("1.0000000000000000000000000098372876475246629256963816410140633849671875857309874935966027381382070603695505674946564277865787065829713892162453982039611811110066451524785763214231940556307173483829442451799448470612795412707346498696012656053759368441299101543329251697945869385633883123960648035543518824841222656788852493068043724988332910182079939010757572714218522783920274574680369148260062890875"),
           e_float("1.000000000000000000000000003311452723361598019152306385048373379375235196056437848003736851269828427611361384564976217487522968519284732034672817111247865522995300037242676005812456068916149692103024010349167837077342638945682013524317644294984057449587314930331672985381514235675512091262381174871271245844481734574302320725478412820223609039683179265063458513730607517259546691497300672156968899662"),
           e_float("1.0000000000000000000000000011147096163054892218372774119056388101788610378802243466704338752463755425105799074249410790823107408213922115054450178824082410617372788044351106427117027635725549914665998325287237846104084588861750206909164251160256980635292982220989605922278705081211935776845494407822621495937946927761369760272295962687606366026393006287789550700184001232582618968782205675417800278767"),
           e_float("1.0000000000000000000000000003752363788610991322871712598327223246765952068256866784335655219997118082081591513340963092771721305595961943020997861413137858321952546814526928639576397372365686977065723234972290933031477095962814300950015281814307594229437412628139607213302456418595718592876870730608875727027422394956141594335097709495868319380642481267495540958842587569694123239574785925812567862904"),
           e_float("1.0000000000000000000000000001263130217602815246219010726873285890314422707558073006942285292239370297783265582118291418352528450686504367497381065059417252006082268727524151582410396758708706941059409839667657787491596172284191918905628733599963674214557590572828746281202413304521207490171902165198622650511832206811899400418865160415552174671337163508914192775981928184893222701823706809841345859127"),
           e_float("1.0000000000000000000000000000425198098186513860066231344022936064619410011891206842660602961388762936927001394563914302008643278863946912365264417067404340091122268180295800866741146989298292670586340592065397890478362916404642037047748808487527236277649567413045502567836392680898231375424752236952488488389768675538032182372794031014266218102956563211582423265400255918558162665197587286518023917853"),
           e_float("1.0000000000000000000000000000143131262463612313246350410596600190098267284056734505753109927017699400454135657498420407302733410905711395578423015184195566418027661411209148756599569283477398156954701316040667391541186558381227680854458177940858328080519250019985036695828661889310521088232221208375182385031579520076434189554878879072668028374764096222660126100345150499462321247836950215762656182175"),
           e_float("1.0000000000000000000000000000048181208669096662012774268184299878043131415194256605168380471669830245390011164727062042655505050439550513236668123703308624024502869332602907553194051692786438991336473723485351448314664335616088473310075499051041328200235270825753349947962442150935876615986404654803388874650252605066128374396625552831134479017530731593899884099907203771011079260923578087659952542866"),
           e_float("1.0000000000000000000000000000016218880689361647276046705911604045157052548982734230118952884171169373369649484048287057525214298172088771459188855276426139878452682076799629043108622375718998186681619742623634743679242953722910874584930222966154898700815855814421188130652030471328316246522900858644282658002684693623515150331348391980278590141311471772693872139175218315440825822612493012966304815886"),
           e_float("1.0000000000000000000000000000005459640762073062458010200137211661650312032212567313183503005015421302066582342864967506523131031105664704330711772164052096412881546666773859722609385239196161046581773207789400675064857118861848872025626694297809304089532404844621981883856755857344244678392261900919224013353004846514568983804292306044798101725160908872231596032378023515030943744448392457976713871811"),
           e_float("1.0000000000000000000000000000001837838123468119499987330380919512127984904228648009079851500224387106974706127630858368435078635611087834517179571231496179646223144651931817502650065995925661520987609836980948894962101550076453033877164890035930233333712949316192899903685686819688674069605919455881458681895740340884306230131451623021458590127121107941732567238300910564747571638239477674570366664841"),
           e_float("1.0000000000000000000000000000000618657731390792594894916355198131961147023558022917300049380787193176074147723548861817543554443503699615811708405259816579483484960231710639400351364613678727869439988503218968356151627926412131480250589519222288939807489790699888059884526100149716796839550903345018198802282835918081855445576660729921487455129448004203598355019850615935364906357201721800420054881521"),
           e_float("1.0000000000000000000000000000000208254134965571317518054201048095594993905753240679617855731722571548586246402793785883294956907645002670523290133665279196391708023904489058401805498503456741717965614251144063429654890366204140780590269570205856105452762970225838116937975934709798459704860875676646896103659365518698517281909176370764318652173140112730136843614898369994870705837385228560608434525939"),
           e_float("1.000000000000000000000000000000007010303521586905859836653755305993999609419107454155341915646304477288618415935931355299940187288153054936535414619657631844993040799777681348138708498799848544780734604045374179466705721457341104595482837096855100753418997273892648781465220270845703619704077802924798881905409273409792493879341633260693973578985542659171810526191588439609095099936329422266427674938"),
           e_float("1.0000000000000000000000000000000023598261553317221968923909914124077232158269749085310040464710413273354883984868954026944101128105172346175590800832061630871849047520753979539972066307111926487671976628102912618645518135000811825553932260641744071183975431175123650327131510607202081794055147012947022253075924601124424646002024693821770481050454976186023251550587649700967976254627327051548603061347"),
           e_float("1.0000000000000000000000000000000007943706668676602453310992061399125206067171512273374033652651224868794036818940890703856375967459304002106698301156145985996503230272181896257371737267178451174885109696757995800602234319713438387714964404519737885865120277504776093675472134121033675322321231768943611354326839544870124734488349355869992850076268416156236812842013825133123904012713779669535897529876"),
           e_float("1.0000000000000000000000000000000002674030690583085418558379561005895838124744923615216855999402121632197832219848185438619545605141500440039039071866277582772335299763639303594048377206604834949976452059740241448860900572466242979047949402252561459619067108363085589230454370317259641365981035810986564607963190884267393700728197171028767225119751768753149928177970063879500969183005129633261797788928"),
           e_float("1.0000000000000000000000000000000000900138994605083327652829591713420770010896306904704191509655860747243213716219203829442528947378057396934423940935075869466652223416235988926294291027819767083765247563852512285156254437725233527314904487337744826423517187172872073267974295256846282179397828026962497688213042915703565325443449928583345419588197027426855636252119158939034664405746936054556385573727"),
           e_float("1.0000000000000000000000000000000000303007071856744930152502287594640435657780430968321538575574147506558037985748870097383996813853953713763862238368294433462025788865179015556157500620255337759700731695503517791957754041532245930416679854707439526022232430171725566270585601770129107729302683778954827267056294294563137448999369358895648896312851851135398347906947927622709530459845585641978933789836"),
           e_float("1.0000000000000000000000000000000000101999009203550496988359646555001901457156880587221846372874965954426419015509325698684047924263685076097317696236659644723508818720870497720000721719437524971685849048693647382263679523500216840292186178641860487049858964668824735645934268670301660953208775467844506189999022224587726453866600358823060025521286251233997805472693719141432361482730450029594975763797"),
           e_float("1.000000000000000000000000000000000003433516523147243732795760146617388616680783285206288377672485206360481041657050078842364535909632893207173784895949376216922533161434257438044403330881166931805764614536718969211972652618944398252520401404016022350791695734753170207944250248568137042691634915601339749647327330669597275864030840453081539011307198486471407017268247074628724202540376129985584438464"),
           e_float("1.0000000000000000000000000000000000011557990422435173033123927920623423756756296214307615281577234207158967481063150345747151669518547023075497650694091855829365013651728072570292929325193651253982433101557321182363736752048520463691329024023339896675185541273492371476609379602785393526216444269082578511281970758802733037998273213507654598760479575036487339793789289175130810895676848288927845378531"),
           e_float("1.0000000000000000000000000000000000003890680056569350810586673272066770777448539808492803307346132628067660617436179311018315423714909833961617152668566643082821295138309078352968215671628526495403337684691921528748971741423133643602556449810439559580935138738678973029508483579167787542285290488467685595106659706878455706994480973145701476857370571259936308298514773147232259444956473171488949940394"),
           e_float("1.0000000000000000000000000000000000001309690590606767747743089934703393902570596992838453475931639521730337584942821390924079161389635329002034176479322115693900425619001669845273764962371001453470191461123351651032409903526062932000728331635334262468767894969467384494641963218873416482327912110832090041943994961895588035762634135553316442096000183719872328762951268655917496353128306224317342112337"),
           e_float("1.0000000000000000000000000000000000000440871369062502436745573314846924912340578474176441665631604239854063762872882606955107969455547295894376698858625321477004339952530923686571532566552331927779841471549174055814508477442992563331442029955526872453742829454969366339354603009311889391116295447148773812786346767497674731101322868733431569126466747734926783990416627171547637532686969589461068595347"),
           e_float("1.0000000000000000000000000000000000000148407238666192527776636772239882374120176415145559927743437089692468897552374180662901560415876936188215470347504698844698774571064448541639321877684008656165487118615767643074365580630470386002466868535897526647321742838844104903623833231585945713123898205665506746829515138600169979900558336423899974046596031817209030987237772377042314157716940128394586956425"),
           e_float("1.0000000000000000000000000000000000000049957221162623927241801773222753036611708975962750784197552235182098517835485592475867634707892660344568574093547715244851657950200536308620494074580383607447045909590748767220462406242596226512947223582916481718854088415691011005105673498476652269700828961565184876231081101104475233985374739781463516035353839244886518620641442507296400637407043944674781101022"),
           e_float("1.0000000000000000000000000000000000000016816726520361105454519921571651022314720646460868028608197396230568329606538498291432974529375218344811248279843391024884731398921582834618003840728774276970701066227718442705249606892624946155008306142044255177719642707290763056784363499789251980362963113534924213806370971377476051313704128102974749204039366168876855039717493083970199185459039246631971962722"),
           e_float("1.0000000000000000000000000000000000000005660889142332807298079699211653731716849860165775392219336276239561158249613766200281847077569707734308338301994912758647254211934317372563183746413959435035786541056077898437914680037791265686697971421323772614538828054943711799323348164018411869418620766643545831333253944545088965029691010955803320537259340103318489003700912436914836710578449492545921462144"),
           e_float("1.0000000000000000000000000000000000000001905582863762557651328328197940826787793001563790034612005505208690684823402351028390712399815844956946788538672175961412209236992538185468810361381851696300020579753983458736034264635563226077398814651919868639682755190682962311886567123869911701910411006468170798137813202232037011328555033269587327325535921564184736541460306553641475183606453086283228960523"),
           e_float("1.0000000000000000000000000000000000000000641462137725082317739260421504893906628551064918870572520446156933304549330508276584784015571642133418172417496127213629391909240970931923608276898197813810034808009214433539798326601757926161760522139516987265412354412682960713339346431644214365913364047283679412457646262944738426636847940749127280251818423858211814063688526437314154994363431451219255532775"),
           e_float("1.0000000000000000000000000000000000000000215930612076549166157484080958953869113742776258975111034566678206670785371837337828269206657600488367966019280929074676043335789105216866436037728496560470358631326005779767938944017556490112516511832233291655037598805585827648299690278920246555307475924023012070919720289107000583477298865616504694574566219397249392190639336290794022510975459979678577357609"),
           e_float("1.0000000000000000000000000000000000000000072687110414825656513314887395996265924536622418171201944270169507398295718244616131470855200375759629706595565620322289442846602724133103451547516712463750117664913724315755586768637359557485719591082460454232193529024662181873222370719948629394187835970160661112052567431265024284160653741196078153696655169031839766726468965815674252351915586950353296715446"),
           e_float("1.0000000000000000000000000000000000000000024468119502129889199599364945422290290094066896909845196270073610858766305103213291111081201492688051942489770675708853022951882651181966202194075681017009585898660507692806106195615700906223702541182373642227316961364890994337101735235313524345231477897043930411962838060062397732205406073323808685311628594768207794936437962780204849767900320709365110829816"),
           e_float("1.000000000000000000000000000000000000000000823652045808106843855563224425694987114312276391629346976603940076300612067537343553958276926649968714960295062261863565045726066509261133778460759377830404423566386540722411281644524295170402950941916872344370552905790262728490983206499122907775246574640369759363653853045146224186347235294019986292263765336197567317071060880206414988985369652354409746374"),
           e_float("1.0000000000000000000000000000000000000000002772598411189002328458953527461938924685312835657274089924824783374171926635835125718206874097135610019263432076363652284415658967819647922730752783712996335676734843867866561430822097098592042185640921872776836039540208626681216705166743333066148478520947572609855545121064500714624992778492855384864562863760146842979456238765431600381308623297157768092043"),
           e_float("1.0000000000000000000000000000000000000000000933319110764250506178142073712819821501643849107945345354842761498721944033577010201826508568051707589927329906550871182622498459602180951881882872838065005929270864043245891702198613909422329894341741354132535520740122139198313844660933774926736037620907503169224926136297660537282650748836716353958310480209114436341803362719315960339961162725810654091769"),
           e_float("1.0000000000000000000000000000000000000000000314176246730306325235797880549053680611820148470246254423243024498724369050094630216894388075752964056694983972422636912998372357627913194271517164026414114417295126145076572174567926640454466140550550769586387438510602626567772078349960151033012055309264719499596893228786883062591107500747473955115543104438939779187368782412897405224065473366318655348969"),
           e_float("1.0000000000000000000000000000000000000000000105758805183701955405352924540398328439337283460492361510430309800985785411350472346320904136791826990876391579845830330383330265739692618821085674465575114497203167213857214872190166615672762991669578215687053686494511425934420977145053221171091174065776851504521427270932663512161422645276573803469515847260566003233148947707310856530731633745646117686937"),
           e_float("1.0000000000000000000000000000000000000000000035600797292245754783920550101522393372034972400799517810648740388471585897619557564407143638443730439485422748161092145566460533489517865987206044887356599767816068638844280965831962183241507399117935218129294680138794131918220638876570955760115978296360689280598200903864665384109699450575825720557114724134613740335237808307616482660515432132617289859446"),
           e_float("1.0000000000000000000000000000000000000000000011984030697416473200530853804511442566461939166875532585490692553149182926169226201381562206256740091046359177296555342451365960215468973517307036125245381770413045470691455304639989155549519491605099930520158102392239006144258100426125788122933043835133396313215768239549289869033576575069693936299558014263037195142683179934490546063913242905388088790572"),
           e_float("1.0000000000000000000000000000000000000000000004034094814722077066142622836873705924882104006021144161887741506805107386452892442860414724794294752740060128235906712743115046902703183096439443484269160606016588411128113859924091341465888303589746766854156014519315006245950772308073344199025549828768713937123742288449818260715122015841846304076232350052752626554434523381547225907626865145837351740236"),
           e_float("1.00000000000000000000000000000000000000000000013579672303139121651705095574103304483312732318662037914100680804201371581903458927732293308893815396478729463506144476511916460471751053021362880894832112460967764040668851551185138690862279698684964773932804032213902679618966101460959180829880424799056939946732524141616546146443590004276579832226538740804425658216847307437433230865026345920786295655"),
           e_float("1.0000000000000000000000000000000000000000000000457122373989983316296814627896739550516203146088053189137746294599935635595830727118014620745929402093314949491484782238997032552834194241257861792445820638853587647776702234302793504547515411567845196184445003279428187236577272069153867536107543916329726111577271908786847835108334734065202142680334504975021816643865278836847122806081630020268848203227"),
           e_float("1.0000000000000000000000000000000000000000000000153877693170794773668727188044272291315228168351808063705986485763515565936534140475531813297148081433094705796897027241095578261582841064203686709725973573510819361396649305359618637763002832174985212869946783366238886013937600730534671014844515256122584900374171244974767321428604935869900378274585027838072095766378402230468501034722669950860775339629"),
           e_float("1.0000000000000000000000000000000000000000000000051798699435534764953016158896156637371514472531774072472397161064187853765539691423935749251344635209551182736217636086768632304250996262258167980547679036102189654100749153496992686963683334121346765981122913189936818217575657228066666267254361504943927523987016106612999435756814945533192247546147325192166360899196381745615583736726619623608928262514"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00902_zeta_all_x(const bool b_write_output)
    {
      return TestCase_case_00902_zeta_all_x().execute(b_write_output);
    }
  }
}
