
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00583_airy_bi_small_x : public TestCaseReal
    {
    public:
      TestCase_case_00583_airy_bi_small_x() { }
      virtual ~TestCase_case_00583_airy_bi_small_x() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00583_airy_bi_small_x");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::airy_b(((e_float(k) / 5) - 10) * ef::euler_gamma());
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-0.30063465305806681602183039977950071662774277990087946030285176692399000749509301866780404193931007562741248742815033818054487076820674871989791320361474586690801092132882440898842800226743844055065351122762339615885555287611353097070108011416692881007195767433160385071128466480848785493969172054832395617101977902323695702095549223951776703796416609075943589619421437560886270149312209237543563249061"),
           e_float("-0.34686708328383815579020205609456110721317560805333074546498720049105684195873122527406562462866156471139586036293492659758331923962295619498310613446674933979081238655515456711197821091101761177176270043332387906609204223328665327717339486395767289252523178906418134872490797395888503247007419692558654880393710642911228868143445515186347308970285295053730896726063780438170366364345811356385638390983"),
           e_float("-0.36712242891768920317564904422657520198371730226065286044873322985208456024784125564254837827639037774438474176531982887363087911832233132520399987466862070139164149926805159624206243730491417683159658611647705890026006867606982238282129802387723146659426672614202743482024674554598420900642646871167757150741341962493373759281780289044494908884831003373522053159450437725459896689578936438407590528566"),
           e_float("-0.36043426359966159562765827292762855844273636324420490650325250210355625751041737800142431544738977013646783995296203844678826165059803466690894810272984799792391061389277064486086513610248550315994257916179214034600187519322217438948849270787465311754206973478267591840557007977861476977249431486404714172787919414418578711498331554457868813108378165635298258966010455573224844736163325681013160331137"),
           e_float("-0.32783446838929474891967770298388695282400860644558963593884208804270987300102095159792797281111526204934273543815502454379197935148123291284107963662346418145938731224500522045914313727723734176197142022661103319658220238028319501192272405198447423081420077200139119904264380617214894895325827996076430366354239890777252603867112955688559474641644564824877989960545828165662102311175275484688378112397"),
           e_float("-0.27215826434239476616646913538500694895762803148021067291289068524002201572769439171931095193905910323338455699884922318815344065483277267466316835798428626149821419175146955666023854572042277247978721206182631464180958373994797301219298611727500333337976236299274420112925950405573313791299128004356078206192641038749444759986083898963492060206302450417369073835456313173450894829564506908084801419565"),
           e_float("-0.19773125950691291865767921840888329862469089659213400843577829751940222495017208870073878259380473770613220706165926985971330669847663864173300037079774088941128990986344767439248870452693803456860734326989966078168596708857742406566600422799209731320483436085928801192030447569877206004535229459137322106914899308178659841334873019722722825796545846627471791884429187612083270333693125102269939223862"),
           e_float("-0.10997326928348978770463267077235855110986112197992967790328626957271635179957886953143189424754916294507174701399235019126357359494114664323153355534597914663028355343757268415908531877245971985246977267044390641651580023962216831770411627783390613498624052829136115054946371175617908252487326377358846947100849624894521929492221873298739594873974734023291847257109710450009913971519110824289459736838"),
           e_float("-0.014956307908347597624834993629675519130636114333669174865138165341183599675152594111701492772786603860229760496035400766191471375594541894232665655032109855841584606198130813354308767659971283032101468572191597929574059256954837898007929446670317782817491461291798598172484720211799149070963611551654450455749830363395277683591934637972335162915926113989930269812284268575730156505107067885698792253369"),
           e_float("0.081046504867202037250807106488392736394889350737832830182420297545744524099239456412626850915952755180103451316447873908254916846123199419874924275538874962330523826753353163443764287522037953077818628285871217992277826392358092796551552838351207848022283252490290490173205352747183230842387463074877770661780677095595104130091753927034358868413090873754980951834893278834211569725948960744293258819518"),
           e_float("0.17198782927021150494870321514847684119813567223780241267052676291185027078292994300895194538169226190161704509279432376484569128320252928723392035674607112048532949567546961275704682433855676136435283920207476691256153841397928937823951527894247068999893616074177046632601228816562053197449385421580761273397139481740788521113033286943663932762940523223358424682485125287681211356583076116121343109786"),
           e_float("0.2524210819966379075698346244982543389858218255473221610450060967740458669257111451734648491282607304113483718452299131222533268669233722295875995096906035263761204702919383223058729222534668147716165724221253297968980408033177100458126314154144389458635265983168458554259042886773813980341862614555212977634954854089552212647107763734574202286302483630815531009880243672194502933207756052568251257806"),
           e_float("0.31780279508323839361639191318064068792881677592646937736536236621156101721739747659376659165242866941090787134411821138627485695886036195189600303502241465924581097153503461740335374543822943146110108255373998323402098832193089622257009992827958785265726602283997029456938468371545295248254648096203616153458114569814545871490203724203839069562092980843240040398316642709974142224623723886924334339403"),
           e_float("0.36470929778974859284715608254411026909524328408262657012382583888386873957249867489639260333941148535907684954746968146545519769022050107641416208639861649591813262241020093793197883624749736073936534518690754669667873074021927046236299719836889433168327567169349775331838230500790703503709787539197749748106257573086529304963335160174541407366042787519948690072591805129412694496733146581203307702293"),
           e_float("0.39096228174334797801776574773474478526880957848138281658710335258090431519058483679764854285505913359782059764119828434972355734087326049376104491612690019430585410237973390976620361203183072487067894838827304355308147150511632084723181662557704574162568562254184796294270208334261309657574584390982496663466302308881115203947576418267643474613222194589009847909669066788103828976035124802007223680622"),
           e_float("0.39566481939852384050475490595258788732187743929346744419562864067576403226075531447696484797810413497533887505782034064514498084213145173979125031109266042742083063488845982730490842178382833844528194996677239827333034764713154164759954046271341850406761789521527915605485815683876912735939137040238782594182169127036266739654898136667888001248633738029359329760505363684347023165856593706742303840893"),
           e_float("0.37915536256757210788553249381049232212991201932421683183710446132488542213583195077046218120870904468502918925693737692693665180997629085245119578365990277626509379816821997290428390613796641999427739139782443910875934433025533041395983734735534602609666827868189221793418644138396834999810246428285223253287389479818791065485991916331385972450265740513060231322900725673138595911499692779490170088211"),
           e_float("0.34289185898546376554128512908180355764475497342546352049162340068982616143369468423999133784855066339040145413447715223979164896691104054708174572412214814215895526361802202949673782984323902289029678058671624564645621990711168315909085621296278119302546991649043771647915229450168418118997007519171700521256970068898987781121036756625222684784750668272070365586120932294154851906418040755798788644952"),
           e_float("0.2892812479570962945037808979375964008932273934672760249236926104922678316024682207260921667565593103411246117381167203639226820541116106988901174927084148717115105143437958679708040958341347561659574906679220881426500215020386044924202144825281370655918538488325564286495423353544968581619272079873224035079105709348498989767893533542947958634724473486937074512026969659500241935566449164269865175022"),
           e_float("0.22147122483533453675128561470172946990913048160282904484436198783451001878392286949623627932353956354514158656321921076064002812568905523487577066151245327793933421081756428300218742901629780362633138546965044344255398077306457303761905670670391357042965640168255859858445809830219827176303768715183642939740836344155619335777749233879576871939915877428130379854125392770830584627276675571279214472937"),
           e_float("0.14312140620632269514022875246820765806843629295202892934204483970366964353951020849833819659409973835763754180362903014314455687625830761492794982702283439397561414728803976493190128674799090917670612022799971037002414433936852506407513546693985968908879140068272398272136423717983001325991242213626808558024788039396682516641958042741172127748560952103027083495457688374466660936515455791692300794586"),
           e_float("0.058170077409171711460784401087498610004437462695036712292977636610443349457267774821285213476227783404903060202469311727503406924125052913249925973328119268307654724915597277642735121181960567108980804619978716648608813723904723891382266370339244166076277142378520897282782276481053538907734240783242659435496771328508295967741926108872371955150304638016722701411101989691530904151323541326714725333898"),
           e_float("-0.029389187788373336297922999445436519358724545844893978087178347475345368728208446025425052233242365646426439722809802618404828852772172857631328861276450867827505166833142297990474397613330101649916389594398087525990543431614914076039140086649806401083556413794282277313454877817041944497260888463549926122096455682838309329312457962766071159006997904306317923591731345730843375578964113888335233320415"),
           e_float("-0.11570930041288082304386629271020205455386643435027041278745530392200841944074370351472578951863499570277142627257728709476786030011711059804089494350021454649943185158539632654865574425599229097673262042841365500416106278083502792735401787083349712822342519694547385623959832920488188672702507732426145368995584504552805739577095916180104742509461878827461294000552196694926675069051526527809940527098"),
           e_float("-0.19726102518422306506863655232626883037195998618569871002695199775207608305122923471994790559120168498869974126626405743947965102171642462111983634937415931438357199634546022732099629211984972043486488720536979439916508728702922889716305339009743163113563341117244314514004754200525172027484669244066992697520275799875498388828552332242122170552039909296081802969277527664737119919510660535762249216387"),
           e_float("-0.27096820781492770537675635466538164890601032302072281916498428011696157570706135136713459034913409149890588144757947861815981779126748998876376516773499997365996043185208576822752322857611411092170583955229414815400855302719545910489224444145892339605944536756893521151544201255092081532413020323648112104792045718990835581399377974610361605650880641226573402697483094814298549930316597977941330251577"),
           e_float("-0.33430408048031856650107049848226574979955377871399349406748745392279566457703522870547110413039962863618159021088510678787012506693297520389202575959398134260425216393948781796624794722165628674832942548242864335145245723491407555118239970621071925501044855215345610407265244431706960881563750793203160582437079712398739917424592890308819770806366533565157008566055399309629175550517555705893160611559"),
           e_float("-0.38534853996623556969705832666350833073151171459062903710925689747801338417361175862050604520343394352645980216922944556409988793207055867522639420124627290121515550988945301557494296812158301377158209716133292026473533741925199117801659622443173759124518352828772450865994922345861724890058765748165400363378652581134819569087017293528481729759230279732850318822540278434158745072286410248070469513424"),
           e_float("-0.4228085565573670093578694709537625692671593015414277740705307169994603754222423009689476853597079088384465527923315906842905752136458265632794499408601538916375001145898383115580483989292939327080008810238691200416739245160172113151954698000270568358272889740281445356979114778482517200723508599218643854053736208670007315317540795087341908278824333631624121565509056409762235850906883195010960892975"),
           e_float("-0.44600564587017030740081108049808318804652410969726384989259009184556778366654302472291120497272897454181538926676651558806555799438393659493826861829139380933757123617061443876880264675865301592992842685496462148900881454795624304352263040416608625070484219721233928174252584840859214341694646436996203924353081092293804441940393682441783496365871893088189170992235971188767352853543123068295559896221"),
           e_float("-0.45483558924948521816062097043929987382183328771824115818382121163760615274880163043712429071425347488286413039565143394588135529184425375434108317407593645721769561687166560580384472406156507124596766908826042986437755383302346405455439956144850100438353825641773515075992295306758338719558756677774133333794120236554099950153729048908924130419835234864772452945268052826469162488227038331905375515046"),
           e_float("-0.449706330173424338503763489662375792828621310450454964650589434699162723115432488737017688160307990059657547802916654579259458861580155883647308875731297563370981358185021726319136430838197877289687733544050512216853032206121428958218711720198734005761055353790932145669951157239326195740591054705099326306370438699742561218053146949946629918940486821813518940105647211848243450954489653630885773308"),
           e_float("-0.43146024573265451220029015752585626063911359197261761138022537917128992149502765595988368906201027654790620698739974323302747045866966809281231212522844022792525713412491792054678100529396382596163500854726229392499604587818122484551360069628940439796744227462515124438359371700016788678205501418462274714314020707436994277985738083123315228751953496486509080027351539692320343815376898108331441950704"),
           e_float("-0.40128685835520841408736474164195229039365585711548067122092183430966733203357487425314226083093049221462367741951307308680644831391709013019572243907783351775769274799050108903290751502553760950560049443428506959107672537173782652130933178006017168775105928837824831283082301085925710388130645361361496782272049673627839372540773668160243911179700995257449971618495925426777491535450604190307389428746"),
           e_float("-0.36063159265369926475787857815645052153333421800692862101885910315067679387290836911510475137760222416338447060244706068806235888812379371160204191446837421910920597793285699680145801149348596962027201657620646733448989391584359980606349307134695252511602492225209807822833889235463113725555833281220748485265191424685088155441397875264972486451677996946371384439315595593782278916255320019673882246698"),
           e_float("-0.31110548097652221861953638093956780651569487474417442947045344608442870003768444083956610642990826968761249022917855417876704388129478461324321853033703081549129586116309643844479826685584485297662130034689202719239417904513650061358527415847545105895508213731480393462746594277470746817856414500498587940798521781087219496440675485756810054072279799427859469846588443658379533290378171942716869040854"),
           e_float("-0.25439986365718816950131096770742776511687598515848929781690932489385928771646793630098443431063851498885645385261787986058550062901356803220776556750345662833897617959465759597107006099527953653767245080976145237812738028517960608848663361722987114906988343713466772764379064760437922882409225090408784784677117414836770197035803977574437335110346348749529550220234845156345162788297411980721843029496"),
           e_float("-0.1922091945714205712076401489445563085198096890751447932164134014265670957594926551109628689146677779401537429294596385950274011624309298314497074390275491405192656112873952572742088989458367988658019116808662465923405470054499210389794540892568782446532200773561043211548940017275457336303661928782118385175857240385395015484055965393135343284267036506211930184548810103159979646137288377672623353285"),
           e_float("-0.12616411773317992549576254477528183508662320971985101024709074467431559173310247675877030273481485018208000648229037903003576992093949595157751276479998159314124739580733556781737906306801897472385597119733726670147828118020130473721371575982304588941821883698327410459458357579222071823411685978363845818295188901606038262812080168604652770534653468838322540786055313036503319863804160396905993550341"),
           e_float("-0.057776081929244242430552866057864509677105201082735100750841265703877248209911973478446016066231421816818716597545385836073757858795120426219002668572379754281715702433906491946896630790222607035868373925864536825144193264467995888825126591598886688818606702339608398503867934353705446699159012012167778092434139127802324472962084273668250637180145962906467597509954835575662016805825087816236637069615"),
           e_float("0.011606050319917824374386158883502929048563099586634305529980270953917637080303710685805622615518458251190235797225110873135197327394891033590138852097712507026719322078417957017759215149718731108390539534553457922493975351905891927590062690068731186308888386737094708114210318524840941032356491730092854240207601412977128024276137854147931841728808714806417232756986676241041233067947886280457981765132"),
           e_float("0.080827637728532315614279634972901019764198394987767642614052786664789495353966619265014934763874856576383554456492083862655314383421582538759413329294597262845482110400185767821249838437312465809549399169695202191589132628731485132287506607607885803760608156492783294075649744013909526012150182517835933132664010288620642532035726468262850196008009148086529195335369552814677541216754843570090472615705"),
           e_float("0.14894894040593675776860976437614785965153613769683819226437929127693461626730715328750576229494547864107988072256909236107285494086923856197265591649074777788810787922662235536698405285342795609133280404252235593170504881030455252980791407443230055073717187659630596844475357857490766651855908403155901283621131710223779501655419319656203162441648329688215732940564778175048996100302382395747257221878"),
           e_float("0.21525607378000185928749334962559690925719825611272430932259177916510416991619366453426317516995676694642177776172563999378738180690705497190355395948544635283909406814401567886441721082666525868376305232593247745539624390988710046409876534868450268776560231520983913332306389928495745466561751793916852536646779874901512974689941342766660339073899522292037448670363160698454640972463456597871527619506"),
           e_float("0.27926376154516924553416789664303469103320405275379468875811426464336119868411367054683902758940990986003503317754298839444503032451145430496636109726343540357578769885888879001242540277377272922019981194077583288207999780611215851982597837192784915853494933856881777027233869497955990922588316615815799520080122125133144453883346856214131487494026649502668149329924947758737112346964475076715235558256"),
           e_float("0.34071159117659364580040302691311424566611928607065738834806144839012173742940485895634881750176807864489570749168305510464862366170938033739813263922033205419992835186501767995803905648152887627198170530714589326455199994412762127997526145333200614815690521290653951420623270864658885085028863193485435413447498762649943618765681867289435254912672390528137234869905857178605204122340731027283414860301"),
           e_float("0.39955555266169083920321592547511482505346174775180840749500988397552320209404909073015580040953729769555528925861750838991216281074959535669733793079556228498155741438619220634564078621856424530023342430939171017603404132681982130923984756939976386626848017190717349632541614800089330429084845162318150160711435771592799669213931995521935208625100042007710290644299308888684381567840929538518039564627"),
           e_float("0.45595663739532014750779745740507395204128192452540999006169593290245580655475652399410551361927788152709556900590603861783010487270893417684337047387569880976273676544188771470246922387217447320627718258827981885276773593978907742802939656736397728351869397261945261253079545123970880890711185887243546425258692920923217875823332951263044846540102235111265736793726902096977484617361887851623190926323"),
           e_float("0.51026821148924649892840086949477538886881916244414421588460067031392714663956670197100756556115083687584255446385902546931817451879367748689450813672245523972393882385267649006439622880834531517311126804975790854921590561958544154085240942339539134754231214219064444660590339264344515744758369899826246291798259878948065351679158220528407404767377464943757265392911781753158042321532512051940598101827"),
           e_float("0.56302377804588769712583477309950077333334245079776708069721967199833372081371257118762771434159063972720929755354951191660862577528021502672261587882438354877436123147124946771770268908867982037875876784911831527101276778164893893897485155888182524372392209266584144218688093618104012623802672301724248244503625469769578292541559483682707756405009644939998334610663903121174401584269830077317982319668"),
           e_float("0.61492662744600073515092236909361355359472818864859650504087875301429651930552064052938734334526756924072843878224251672452355422728763910973718872692673455473870004698171619027440924698520317669563833811715078155362237702623642389825635273553444264082537800229647338071520057858811495142038507122998497808312423456238304158255174750087687599184018001976154238260533667621699049808099680856756238060817"),
           e_float("0.66684276325448924234404548472705073375316372907290526539709931877987113887216686417409458103773770906264575415893990187382585712328498658653856315169752498635630809032768881485633396192949496783465289131784371308695378571003551980050150460178887231511020037045542349095534967701798109406926072967796456484792943091375313185161519854463049367255496186564361848241370977815497224471741277792593734063536"),
           e_float("0.71979840224706371147317776500843488957537501068273526840938123174668806128260106812481620407626152834917922655626994228535201101119618706345409021200462218761294294837218948172239208795869219419055856188241442955240121056168767570875570714365615954904387315517427075990921135933596912667446378342800443906992521291566703053197032388682178721114749722266916037585903727621839620009543853183085031975539"),
           e_float("0.77498329714301622985768815369917398121776220978505143449584055056856507324062296994912986265384521039088547065856779859307968033186161640626266769171577679822355670768031101434770562161710394632762943143340781596230541795268654006148759502532948220313134184257558665787644549227102657887700023980195986173056202377854067224289500813962762181844820555371796797756731245240772794067009715926959964272621"),
           e_float("0.83376113570611253045062327897894166061245361534950700321847615199887327421682039075700587929037258028297153321535753126179738108573864832258420661592113722688102778481466805349146357909680381474983826615779496676055691210553796820218829613902243033963513069541272969404379284917545361499132210818165706314617344753706212488667783392940087030415819454196462560217537063869621835168243073865429441953131"),
           e_float("0.89768834542605017098583752518809228859509891000089078481845088608178257095319431520088702462204577005504066412195655464873810636877961889693623502196731004126434486865661100623342816199399831411170200769711114259345762404735797491815726136974804376365163869114657212349398164985660579280598700872689524928485422817137558217477071581084167389908730773144836667232323911727140668417112022257331551341084"),
           e_float("0.96854279513122687234456785372106470751158919310018347678889396905928435634995713839920220301982693436092106267208135791835795893334143620775980315438256382968032548955329060181292677060138781748937835286526688859857568169395172461622073782594946040561060146583418799087645676468266161742212884550938553051826081874801302897313968723308076102908154195617229203678959133785851147653234350328771529762662"),
           e_float("1.0483641515935689114399340146511706084670132030508348578030558165194672271036969062443650978216752810289647269655050673369558664689646826971853883089688321107796418261408870029976891124154686680505308009201191487465999290774916048099761836525257629327828944664349750350506857465574863471064729046495965413913111649604802317521412443199885048806309246869819351913429468909757720655971261207117398259009"),
           e_float("1.1395080418517366346607181513660361967588310211049979536367433278342573814324670605603865233747906436153405792992610287063868692673788490501055232667625101969451035174311360435919045810555075425077878431224012029778633337799642594468991231805350184224789626190961659613058974654365090001497899806387645723033946987219062125901267849063826713928789658571867085594174873621840169583268332074486853231377"),
           e_float("1.2447167172634131879295585201041655641147850654750112678816494747232149102609270416838402683667737185124761480320453425084459096424680038872312255015359684019911353798383626095516523255073872818719800756074498074493265365359176293348012009907256850411428206863438395543998701188562061857223720211294275057037071251929973435395501890169808154255158110731746709635927180718593314150662645314680128481882"),
           e_float("1.3672096474613656117506123491542995274340739103301842989309918611572047877856079107769598570880354714887819385593759164774822796354650510103200667746435482755887691759168006343180451143321078609134215592808555427179504453119328183971797087040732528717374576965013409854421593071137041629851840384597727266468283513134719468787972909367910934982666325718904832388949973507958228642187778432435990829679"),
           e_float("1.510798436180716771854108560621439079535883985125736350713405334736446802228108407022232966466244784640101115387679602704837788456022985315171774846144074726803727631394847275273459689245744930468532213730942044336000980935767936657796382634315932706390635950213413506416556806209943279119933861849506414843209056589886523001408399449126113793850738393112235800352538297655339702160813969210353585152"),
           e_float("1.6800317052381361020381006643342898096668091987476579615368873414405536268133488520625898277667301588010526905015017066172287102596881678649877382053966383698161121165689397764147505653917718853928295234848381719431401617414720037442145330211394698404884931812005632672972631138423104624920056392053112880363964460599662935431260571743217949020048284922125072525074562325298089249275706559273118849297"),
           e_float("1.8803772154921605114909001250098961335136453296859104268638452721006457058279798596791854706646482886522739101201603880786338541983606185019448656735867836517083045162484815683706058694679112654929241496196586392499843606315151561372867861887670778144056310466371913291826044224909920412108763330103923943793603713382810724927561773189931949685216376978751276035238302254794270538780297878728675883192"),
           e_float("2.1184505869990286398754757487785770949033705811803941506103960995211498548265114756033357150001228924042058813250829009064887091981030633004291919834146253169948374850289768654452934750491624321724518993293607641597852231841778908647687542709677699627571352254076950050249554404325541734161495193869666490315665914041171466048028811838883916654842994547821611099192657968816314534497801332449381260954"),
           e_float("2.4023026802170682540690176247031437359827557335148083293581159734948009033643270709783444662078340892926099561722255839274779157763673097102843197660965105472690277256693899469069324930202608426260014296521698835239419764325905704531073762248705799771716700525124755268724689986969588316994050422016611287128159287160189208990523586242010585060124705272252762700619541346693463001169548766152244764804"),
           e_float("2.7417811846776709380455064420389107629823534358934639125768634413675365434104988317935196444354046141097074923903368048635302882718603694278360433368165994220020656295171886508380818816125276480505099061570045249985799278577664102938110164991757720846636450527064570535983120645252123599070056209727069071281780483039042892792281478501513066972474284733769686446122685654414276692345743648190384612287"),
           e_float("3.1489864667829893122520388767586310469628281236117169144283513629135256880730612200007362791377567750657789408966021960816437769612325879684795438557217205212347904186550393801662525472676821664040755367095828760090948004012290798977239924753457010755326889877931376914310339839102694019932086479899002274464704072912095725759213336788897658773361526728593928838287396415047103817232843537097123924415"),
           e_float("3.638847565510327605765506539208737773599199220224293979235754836167713958600734582251266796020313789490419716860001831796765464008424249765372367633338154158504401450488660336148849240872211728186806167397836258900138362348795662768918788691032516190000074479580770261902368949838452384884206444116658568010814058967172689154042240010365076466999346112442463450467462348214879240548346674963200310386"),
           e_float("4.2298518049477736435163303945988365719924081536339277181238527305271089303720871779604166073437966348343003865736334966322965041665033889746156528866304496635755612676717966370143174228980665115688723307790152985451731145041946309620312164088727206119247309584252534477267477587784447731479898861543729894392110383558516755971869803538423273375902549092519503286078492629900462117873711066941489549519"),
           e_float("4.9449713595948436219145554190225251620421634932460090062993525580130804015215130687464861757351004135358220366605317720696701955792671661455387818308032817919472381594217888034405616674848365210417186064480530385853214203548401019472009198816834958815714190773590490857636495227814713653923127847390639179413010927005199027544294594739684608360763227589770617239168880085722479469507058696163000207656"),
           e_float("5.8128429826403984205795625809167540238048942023100143875607403817796810262918701530051582530032596587322551180191698252596901832147434597006330597187967681979909859739020068177791119036283228378449949540982571885879185963689862225344240024481902176914356000964545496091004134991779619257828652231918689973402346130713458260258080297651979304402994218528039530511419068031234619340393521017268557504642"),
           e_float("6.8692739448423637164022145307884190939950759906369732815305594969474219423505219736940577670581666517792030601695057223423273427411027154257892273341796398161612173573977204992680799812510860665648681573090484044449770692296833649662969394773420238677846591499994768081644081604035744888116017185959827055067483167639187477037227081298021616436306365774371542952598138950337259923932998430072549288179"),
           e_float("8.1591693027184447791105618174174499290779255557716120012952844367771501018596080556017281518364352360154056107851482210674762392970188996495314585176376818345990062260178732331453532640317782589313488813728597699422990259822356026279447453634462522342516267480147701549218193133808380081646977920679012318439694439357125409586376566157476521052715518867374572523556512245121163977285619576594261373623"),
           e_float("9.7390046114684541671717903003790088754322628437883419966808963596809818020629294090635484828070586337689561782557982190501413942589256819567291771090832885254242028810651037053497413653779286360521690922283495476772911286510385417480126598106208178117607083280137191060309440800770872451009568075588043365475294528953447852765199939589020040768143558495540213235887366593395249165904372909936336140451"),
           e_float("11.680006377857970873238333229738820150140761656419487587895925117031722638082247815662062164802910218741123385410161611302362553475138767875356392319580614234563991195370142498582542145699089015372610031432376585818290186514485068689194735871802874195837510511934949883716817676142480206669161962124079648136032369200494301633633173354546151107130415370997631238501092605492227638106621336176884579203"),
           e_float("14.072252929081117610627308280333766330326537728243903280912338651245086931993468586188827889581198854384377850581544706749156722819719486705727965650870692671738078179115344928161458282329498118540111630882910932473130904335205024951598048220138677597904222725216979488489931377911874689904655350912099990598942654062285672366198733154395950240896536413594895481378100331352834184216397961165489824593"),
           e_float("17.029974997756770802831616810118531626207074526803887854113531136283002431435081808760381739424402333958504062860773162359850308415950093460041954370943001714898696663387261694931061535390836362559520202908618095735076409348209010011704535614099783762295607533156325088901529782729967986354759650099544047722440763169534768488577297846415273958422822269199870239038620988655524280115480921297565199926"),
           e_float("20.698423616039245900206940634485413313669526867427156335324618630751364697756564913201557991586937355410336495065752066007930283706860470325604564457347523972039642473865983843177177841357246007499757958748328148873002039873270103388139042442880284421033241617860523002550926722771762824148299228611960981709576314551456601402956102599522631349162036925893246140412285477721350690085160818405581180447"),
           e_float("25.262790169199793217630643140342840465184560675504128323644918661424732162577557577153479186446381596367757927912869678772476055005490388461454316228269037033220413302517857833776212492939903256063255417943804822503536066774870213204158814890052229862313126415338985384823906926349445709967172718361170438203042307897563563949953000363269642318672441307446390714953218614706249122590956107593145965892"),
           e_float("30.959819511637298983123017025631324600419148589842728845607284917996044487160269393671903284074507588440108593145062358151250430255473961598149182508749964100034772205966302703521359737662474613927680401823857095138313667977426093129920309017203730879623118682415925521176265776283842685114546784083575739798164780054184839013569184594981897904862136994625470854542136079537276942453970986895081449165"),
           e_float("38.09296516843635824818087302236360480094539892470475561042623557814564699223343107635179815581770221084143779024045049351037021586547959481347288803792382246612418218461715690727407469718416503427973234108287690232197139828507837468881302955308593365949693818605071359024235503249334959747229164107487117961563063164975427877658419322244711487601282890062350112521196952040988056217033632473618909916"),
           e_float("47.052213787507443529775733594726088971082769918963174905135360835227534624173723475637676295504149644480992761385449417924501400974252918144149468872478444967474518982761632137940780271235571144752155488050185263496638286853983779411449671330700781012081773615059400756659528130095046498206757506056707237053605245023229995178769640371052324924361622213338370588491944361191768878262147768237250557847"),
           e_float("58.340078506406199670340628718905368337348720201698233789700114334380708116209223403084324370085753473374427794071738039584810207422899671645907541112205913563801546616516737288363468953629924289089727427835363688437723615651767085970479379732182925835158986901819666208058612464345275143511502308717419080915819449601595271174624088569318702738470475666875071634072938912314967248851042896515683229065"),
           e_float("72.60576080343340215738895848943260609748033288329423311653006609490392326670897459278158037004573453331353619830223953879628452493432562309164626304144253015799144816697846727663347748883928911499363285283009934173942606744998698881808206330408456954718820018427491716290036954996062868669114660457499152991203042626513702836416459676618038850320283346591263437460378740998675935324518252732063606852"),
           e_float("90.690152685926690552220010308320771268563374857189910094472637099886474087772651507735162195169582719128060386200331506557889721741360555555873145702935380162155768558000928194919741986059770271878189548099635726833603994722460317827927714661654586823714515562969736121924979041429430601509283466962069885227013167615836962039767745359229565578012463251370688709301626717474355565589309055446388837948"),
           e_float("113.68525704353931635654473878681821879671294833576697235731164187208070842261100999184495947883311929349830020484109743794725846912067695119594112164455959881022870531731969018570083010950152006639562570968590052504057859431975555805349563931381166292799499358306465344235727986603236860091195771270493779802478191959372546654115842426558419774839377223644028713919063756465319484282158616095392776548"),
           e_float("143.01282741877078167950735813431420097859732690662796981020841448818989017324781059970218172586652218108488165345421187411604774767266142586792980829121304709448058721748171687836880842436660186133663696304545383117709438733069786903243641689318250868718471227415830914807860941519952657172534944011998894417297968321324259380168327763745576608095353066234404441393570410413682437949101372517444246676"),
           e_float("180.52868396189212898351138345637239102087989379085213398525655421551390686315869772101204272036661583963124115560635658489877462668621397887254171449703393958496464560283992545416888112684772548253577279523162107410671902422044945407644238758990375880625463177856789047229573860936520609603721768989745900780404433117578350438136726016981328403328406713818749568231735046030210280496059724400708397912"),
           e_float("228.66140715808253235303309229726242577253392172791212527870813401745964813268468839587247866754733439140747195022903302818699888880702046688434195635955280312738829143367231219062504954449555234953430865546181529451304031071507503118998128030983308357398104972528574383096075011529161467721129528666537701477246990190961782937226896102166998715636598926677660378418001106839492354263314494061078344487"),
           e_float("290.59716106000218985175752285896155052955873761870515621197620374251352057670681996867298855264154587788141894217875923649959544862259771847279807257482677945680279233917034550130229100644613004085350616410908539527664592639318322570617198471013384727205188804787425625451246761872546786698653352446721758308972169116755591739311379972855247012272259438988615010992071324840821999455558578552190221502"),
           e_float("370.52655062015705970225384698774270249511197123793911161641669122669050185174668900528669017692961223171043335885065902529618094607300979556287667878486985442568444383439678461817497617695643804491995490480632393999865743362973276459617931734262847489717435115697052011919879571021465639398247573063961187960702011305986362999791798758155983229241004997902619476735543892554265878145215636027973313459"),
           e_float("473.97508349943856888651584362077584951899311175745990803177988444263250615378612962039447108825892532417807196363426695019563610391454480425497825758229406290496752505965110526920575395300888042397382152530405395254931018351545569736285430616554581869558327856928965407263424866335479235490736533038538714101445371472212668151375044062376739101815773730927638315389290633665562028014095883186730170267"),
           e_float("608.24655233570972956804641142993314037264274715958656236964558563361270748051385201195468830921569918828578478521558875207465023166851944440115564825032624285313654804721068570479446875058771868695317079861696107642908311876700586258137781407548838004344045968787628907710323625684311258135952086013892026392479255332104898311570231500840788033248217509033931461738106738007416511126377838558109756898"),
           e_float("783.01926385800172334687476405013136406140247412191197715772296760890377229701013258623652066101923851821081332704698467096101501708655875699457082440171669276212306106380567190455628292812170451404618954504664453509423296642807775841565432440026624259551266971350967809154752431240194291766401694890975981553635997394911767202557116624492610072443351313178316724543336337170157255585229043492882665489"),
           e_float("1011.1496054241921752273767001254263226501421666224967124532619124054435056779806145695248885622034543282695189902047336398230265861168581531836294339032891833349152077348657207163270603968746281632427926005333472629499698953582777226407304523043965905818203552583206368284351988080927496142816142620632164464730845442694651710368334291385326588750310537022219289206842334862299865247696609882278447319"),
           e_float("1309.7574712096752434215142266733476054416851429583815703421956383197590562896649005689619030972515781029539173525329624023007657222601849518444097325221794585456451274108046336103306671139521151892594221425693310837616502276176988471710805920172540616823323852880324558751300512474240624043889445639494764432865604721350914258804339504268916950384393966718645038612023298989731430905729778659297846887"),
           e_float("1701.6956773389425278976016854849291573163795403879579994406290391827461803826449420207630125999215691906956187069034890620242804837675368469675055666576953040145057285420277237322620189309441385624246384938657818770399402285513652010505106869205147997377597102240419329212404362616128036824313186222589443739364191121891560818694468128861625724631959154815836796687843633608664329536510417676614319271"),
           e_float("2217.5436188948078325933337161989936591552341206080722977050920127138553198496828268446904124322566970174276830528061360450814899722994322523760492688104265459688241236222138178259995714052051558779105527928628349728510838351209984350387318691877566884614869411740970437012034269538056411417685462856794781467525794618796666567787598800954854945726636389792059148995647856041435407309975542983519393424"),
           e_float("2898.3181734612981697139785085507615406774822969151798777722955908600681034658385130296451324096141512606001386194150619404489798755969755757610210257758783544528877093928471701806121776362028363832298774952848108879196262975252132713787680301757259365007830139408339053794074769154051013369024296238923499805797352506435554298802937840757516713938571584986913688241519201897098216404381272198871334655"),
           e_float("3799.1679940735396870470309814981065787494011851212710547016147712490816526313259492366488991526621527203929955080965503528307472118385421379210607447352524873703891340664226297223521647611187462328634377591338917158155340457853526512774961434984756775791813503712000040171927062733966188024215059735958983837443703212284614822578199723925363039166727056839706303557666019144427986993774576611923699354"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00583_airy_bi_small_x(const bool b_write_output)
    {
      return TestCase_case_00583_airy_bi_small_x().execute(b_write_output);
    }
  }
}
