
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00486_bessel_iv_at_v_301_3 : public TestCaseReal
    {
    public:
      TestCase_case_00486_bessel_iv_at_v_301_3() { }
      virtual ~TestCase_case_00486_bessel_iv_at_v_301_3() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00486_bessel_iv_at_v_301_3");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_i(100 + ef::third(), ef::euler_gamma() + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("1.6354536931982785970864119196011087594484678578862145562114440123692745572111511947715439113017381218129813382341242631321952938741197333420912759288583148739298780068983124642858148651067302022134471221108110511083572527933382931961378472802037563639285731220139690753625698248168270814350871777820088135839928984589253500306594281302783314736571191098845421998776030690689223834752637478145289805225e-213"),
           e_float("1.1411099766982525509822179306775767729573333737065675820247791606422233309700209072473790065616666857534818804665116075386576262803618885923870930767309042714569303815127902025900029291553000705004843551868308784299410966317699815643104902863176804699017247908835037238136028606535629967595272763586740600760629122011436557971802346600005013644842443264578080181075615514531127896998095179959768880196e-86"),
           e_float("2.4370883029797997402924391091253841450505283796916479595319509043560565331140475840764652878611156574299326315044115681376620919273909670762688688814714862707687949273498157396157363730644429489028837876568268189056740071872563237841577283393147156597538037495549209044551003420501056029379255604942737120276270375599241994259109605471623242639035724574560772496190572427275500129250334596264990339956e-57"),
           e_float("1.5302159982359585488905835756312208457427450619504722826879046189973281312313375102078621618197268019985866732541249204504236570827409357077729275501536645392976220129287900159358724811194172270052141758844169121795912218605950859317531230061784306258365245476268914767264995554186455604895238277241212838703225427753121893121215576283977229765213448632028583834791307197517359222430310606485844844863e-39"),
           e_float("1.7955369389575751783290767403047787471477404384511011142678184448719598865415696636189388827574921734397625571767571145308054709013008976060319999669816615407623718353947344137837026233805334994299517853084115379344819401390277169113498129943360019510700098623069063518045209346927658783848345366553002796725751940169615669366379155471659837259014397909630372138058731418142801678743730350116023935821e-26"),
           e_float("6.0954620274352545242690720074684210688104208503309406014776022735239274557170803241159286537097443096010526773569063896892517332684673866749164755783205788726068799117715388208202457468192447530489663976517419949364270010577171984138582335544460534938532906006813478141160320578914991094410985813563291865653077890573853521802229457708648932726752580002211085809369757916345510259518983122410797098549e-16"),
           e_float("5.7473063524062069989596230382932350277855955858581018257696366457745549955617766309836861450979220558046573860684038406034384312457901520234526248318971765334958164204220842957804145725409986540603464613261944182309256401762951226705377045565641106142070462443358536973266449344380694340054931901562524023175505218394771746584273542245745522743454337100636284218321166164102104616356095625891193395115e-7"),
           e_float("50.13637126404334099381386463463412825809056773719106421854874472634313260005868939498650573126316433713010234503111150583229542005045347878559623590012899696847389822366769936394360357206242079941331669509895628607656458961379088250825486666721694976054901247231946523531324925803277602833384916399632294903303160089368081595030359360697898889572412047154603790331960319144714163642930150322529197316"),
           e_float("8.240687095312131540900444545052790458260735299753484593651333403763230337977100615148033487368431655497462714148237702841138031210929357282098588393426177133046517583399393599981952566443223151928651659642295205898187050761550352271632993439481487542973798200361122242057531955399738252255095809516014696339515117578951103614662094181771417399810174805601209495734355127849481904523616594080594418473e8"),
           e_float("4.0089026910041355332039133411985520056974900664343311791220834100462371118891549574300608475816546965712309724338206340310711094890122931117952506314764820039530319880361996243946463051621542187544654302186804906205137386877925288047655769966435761262704637668577045339600436391847955110661733323489070787040495333762794895573746841804235410257361636243750474247798557446682689875998148019509990318537e15"),
           e_float("7.807466664461574057249787079053488601227512051342956422182857021014146267186167666284038669735740087264324737377804281259289169864557075875416285043872800367800326756471363591683030597273326120893551097381738017677071941118625848519819336331498811135581671557552943628533974623222878260551116074047981881368325968971509047080783068063121044201646503728354191119918232931997369532153855013109670995146e21"),
           e_float("7.5107802009008105655179377548646431753916174950569103337110359622792572534925171778806954570260653804987318995152797456664274470292670249038549112947493750719606647235219714580519595025939457603772286779558361921637394202941877350374479580846560045989920099147747932983171954039733972812584543932462455284897241265536285075943005010313443271240925711173034286962659242308112514972034606550943564965086e27"),
           e_float("4.1502582495683175430096622825857628616336504551123327927999497824294429203209349777939901007266308928917744324681974675633373581709112578835228678947111563864049488139154974059934923864955518552916540143961397117469765393237898720693640837703706206174231086974657107991771190097977564813499323967768265066238044133392480078785964058529516218910446420549982619275051005908349736858373421197126068637169e33"),
           e_float("1.4721202050061688934407217015432831433389859676591824813276383030377394660886647300968378197157698371194223004984549567249068512871397016232831747971714345703263680457667747572798003767326957767437441718389719716761765843767400866159823643764028712594787133907393469268716607324715607919204479708769141501007439700144719975864104280099257879257895332926759527548599404945730219737842620967425285754873e39"),
           e_float("3.6442549705006427455858580509170070295134719650785458095452415755295696354712446241276639067883979088433407951173138500388825126180026625560281529101210291374077612347811895942807628861178021498527405087992947020818586918145525653763015962430838407852831683814672680007994124684521436845047852747259257856380222903988088089691124322699696398835222045432726085208892772571939844122576397226938310393933e44"),
           e_float("6.7128768092885369166820433690112683281362166098045655432510604221632721335345307559378746423222423314813227455347065402316750935165750095188582213505670549394887672527435172834739415839879289598836385752116436570857743708588155276306662236819565215022500482232404821542470987262786134612816975115964532614067926267647316231467215454104787725134734802674125240154065003479450822917887064093975474541275e49"),
           e_float("9.6721195757102951992597380978343525204045821058268214417857053365994422288799639348809382809786546620365957789738260382262045962801033307162732542795550345264552445994408342471946545637796789246645920262285304763247053167070028100080691193464617954664401488490244145385148441658265289504656968281279228968872592087207441569406085841152021429848201716193486889306551487316095651746257423189976827436325e54"),
           e_float("1.1338843076069950321186880050622598959585145195394407376727510638482585387430733162457931978814739808091806524870530138171169375652266998974204579988658501333468766088906284710620140655622341955724857997732901107021418913332394542994623107256434022782039780966471211579395869397607416157457459247207727411179820757532596726539847490665433970231219796566806282646452675003608471790279817356888814038105e60"),
           e_float("1.1161982825205435600260068832906890796379884967593301509063492337371910930258691700949319895202164085166581277512767807176064780915181192188530917042174289810869060715219816560756359316476765095436612875669559496283226928353572141609087956886904634360228538127528937606249889295701860174909433977622604734880023726312382407028205196092695994489773839511949146462886682512775026908645406591507104515236e65"),
           e_float("9.4648016929925118398297675891272731600968762008835346237882064148914488817890824877761348420595746195027701922261964303565339089270549850688849314250524498058040759374670677633099010317947191929847246841412942194473641990806918876808910098569550524349411861021098411475596706317137811660991797528074949184828742229307576936119356171477810618805672318556716475945881398091478136731686654527165699179519e69"),
           e_float("7.0586898504848063938029050981318810499756318717642757911866222578840915346925191794577824623168295227556373239390441398488886190383994916556874120396329679061968321203680149292115991256353848398329672010418235454836287604430226126972431449832766965854131879234943891790849838969024620469644510906256848850030252997447782273343808011212104143172212307525928085561667585485024728125460994893002462138198e74"),
           e_float("4.7101655181046602257657409010396921855873244877792130336199938873491487406121785633011180483332194287725316768281987253256338825312012964580878937791529939082990223817566480363460899971934036218167185778846459434456756259073099876200633867753548500634955429989132484019206184235491346454552712634968713407201565305888451895260532884626369085715534144489515862598969823623004825540348520439507222928121e79"),
           e_float("2.8526443552725268835281211626662800297808766880409484924391703163519963294174221436765866355249075319138757069523204800137603249840183947951904117477898861115343805681564043870897989029635682549996615226437445206673825427399331221593377404771227232193767231880333593971049524149403113170872152910518259934533092062106079009047565658758368118125961444842248023923496404649912566772088079394241915913075e84"),
           e_float("1.5869128070428205481283093313345264869050961974606609869956264174572666399007445004281626312629945806339953309549049247771234944053030411633516247303846250498321237410961669893944360456224121697747625821263225480667128835236916964621709398831749623064185825912942446727083630040236833846001339534569229053465585415283399921654872237883354967684358457980041346220162024795544059821385482158986361114261e89"),
           e_float("8.1909781550886175715103580247607490606647344517326863744516776581434659018646438468041560709423986556179945363456457437956332550194091951242217128953025108621655221380365210228106238399381845917184563548501834439073378511096455278267048379265675517047382262929996321952045965265455905711013231112701863871588393503195074604904260220787781167402103734962889421034929846895594634720852724080851342964073e93"),
           e_float("3.956569724355512036778284265393118514376000380180412552265487341913892892223222009378257309449219866842041475495868233062239431685670348250552911999127730106716084595204234751414068169978367817395854536980078243982899258438535782188419360928472460242656196877888080025457491888850956664283191686692586544974317283499247654784946684521821038706314907083207258858945509869441617480313986359740453066565e98"),
           e_float("1.8017057314484602184962524350066642720625510423737290986420299242645312336657216417373469815130545937519968467481345591920497796181976935624867312424674207485226267156610765265345544174708452485556784176083084969276273103022517172405055492745292605879201452542885239655720038025972261340577166547526744932933372936725338884785617451185443829010283422754125998891178211566778386013046140337348127067991e103"),
           e_float("7.7833261523587492882440916485878029597404117669057349835729728792364275390946144814103764496019744847346946450812779532971188061087152099942933637684982417510220824521274306835682952070302590410841599424934260513991897477038578137097925786877405441851239158985302265355412719151661371577315513189874300133097768182149597712106614255456012307019129717998553888149564455232805027704984904113773557596395e107"),
           e_float("3.2071946592756113315488836684703527130822530152285537140626496552172061825969296676683869643523895239933606636753454208157101686050840720871509135881970576365852386084813008654850415661326201878444154451206710015770890997707417653263260816713427971837107860488992039496985037042607079464881221639377765850472637974603767683726944658205767817550510983621681384770102239455455713007922734117977529322996e112"),
           e_float("1.2665293100000241729300565319958080755847417085974604707693501753893453085607023880540448325826235018759623672354505301272388149085113819934763228039063006306089955146743480155291119852113363031711111579146209454142459099719575390267684018853682753669783163424767373067582632660979043455083540930428208344660633327347016959255883636170804783400423290763440366523317254560103962015076970551349248549281e117"),
           e_float("4.8130912647945508624383211874927200647388845002303698225012990504416571705513451397966700950295703855855774510586157736022661979782187565467116959263358098253387901193982758904031916515343490039569834603310748709556377396568078686948123561995423333848802901184373399256083353956466514079967922163949789496236618102384592136199034150787673045066102278649796797206662993978878774047967655024373155932428e121"),
           e_float("1.7665225945733819273104683296046564130920660725802221035099014637551986317642215689650862869955916646968140850120530146559234854888527508193063753703368744714074617325099310345539220906227775026046973664971784692946065904928017949521350733164926807729592495705064047924220815302779954431894999340396798483360795860377428367428710431848501235193505121866918441921328612281905025152688574503794925065494e126"),
           e_float("6.2817288312165361176154105615544152767552035529576176049833080561037436346848116128964618081945777986090311191863686714458807410975093410299941535003544647380204344246687824570102569550727488840953967942486505087286899433342573775961160475471903390104943881799494586782995605919651216561068731032656339746235867204556761062232043293295678157971719232400498446742971646213133997934973866932349210315348e130"),
           e_float("2.1703081222605364865314155554669033647258545679674895621949879401063365284547182311874169422530702808870712566466700222670737724195417115120631787612280779654110027539002930648902416202141669957059704850723511300119743810911515374660690020033174297392362214857503427076542349014409454016759418671976529537815513208427118545489187478946446681902648255967641474839545002077748490482289873609515045938578e135"),
           e_float("7.3033922347485116596456718481865780499205748780607352986701703131312758227041830126030394051297067775721752950740699108894678847276617553138199110013487901103582976373187431891208608641049465565808060910631649163064952620425079124059061456044062067779299112298076624175722062799385755303501668818218373911769761035795970618652198593211255473085703067407252898257329840031076770736492668038603819158016e139"),
           e_float("2.3990990085753683451232241238748938549268722412474622538482591841221957799145588579973414903740710352839325516807139674133331308302071232868171577908528763271294803963223052614106048555391787277027872193745265263559996375802195667211427148061231314901798910439969103429269340677372279723821749416543879361042467848774124412536383068245289942141169231129556860546190032115428345948040139085607517266495e144"),
           e_float("7.7081087140749371593617145128104855461715729773276791656709297383685358911602360548722736633575976314445564074317460611798755837269683980217071675053702264582192195163479475984606988092102552703535522626439289187747148918387509599585095048492521367227485148670909433154103809099565261422419363715275565799008205026335039809535641051342541914746082337984812199755735192658123398491236589274802544249331e148"),
           e_float("2.4265509418660584638351767613225259905573670651256270712243361346327870654917253938913158934932378192929281732600046218302269641882706697021683098827525590972971833692086901218448436731978542400558157566950955395017687458608148417009575516554883211891877545119438451477269211231579706319415369772374597638717995498429425276770684092177246001389599003030785173392075907425641682354296582384761677013438e153"),
           e_float("7.4965284221229839731241594271853085753769210347895804770293607708687009186782487582105824274911106876143957167689626467274110839386457284575002539771817766584299539824023733920640204062088448902065752800034818279438117008192002305938700196976922918737588391110837005683701424298901458554781367471765405530552712432382897872317815163792191066855795875898329844048647272536897717631354479278206096998263e157"),
           e_float("2.2760335988118245456038421592639215372801068308050268965959835555668412654290265455401034553660119031663718842361901860215097166110619782035438683155475217966205047915501694242867331450923356758780772543019281091306870135571382597089816101905363179029705474725341949346495844180813271135243258570875925799799016127340756826327459515260673020199856849421412160074848124448577629501969557434274582149057e162"),
           e_float("6.7999061227727615292820867211877172910983706144325690496973368385718091903105714533867954517376141477115548289278473790244380699834376149713297017307035712847961438988152327477241687884083127814760141875510888249102241771839704544647391510178535212895657162059591290504701390554835726434339905165396170255388255695717540234902907539127387424996384803305150481471535227677314218916194040975590661519709e166"),
           e_float("2.0014177461754922688396444402631685471572862322540410601869179349330742209046770465967476377332664030410338085218642575900810424935227845498289397225321694974368062013071736714088066864803633540793337123073980788621032696377399828470066922279657075535691763954646717265440784990958731724616598601280850045352123968938699960679501920162176685136204794857404493352532959158665567072856361802930066585464e171"),
           e_float("5.8095283639854152492316220782400006751841466027134927439892331867020183613034072401467469526467580399971204912473617042814927779286658273980504693060772015506336741675456498809097723709612092217960829283932145018244484240848579491715272137203363356308918835007972775121801553904828935881065799204969173800732274679593809390567056992362890031370724163697940389767132887098683809932341533484956436390512e175"),
           e_float("1.6646704691061731732385775182249327246647682242702498672461073846672128822261508221424220556972322117503946086825790144004928406600364381375261688597152690926768680145607280299762328405639444358198803379971103840848649446994051643084466565528826227648137513718583306492634330294362090283176863617536309024310899874615988161013237121386723033722935180350542660426022246186687676159201560481004453850605e180"),
           e_float("4.7127976133451254375881610396180087501186412956293607691921145375186279787954964981438144350552207082051826987347262630514672848692465486393540145972104993757623505142558002954639843042909809621485022411275704884462162364702763823648888223838446897002658389865035254307487080900928289882165507729280964030225841176231160936291287956780424365846266779767525736455019588992976691612874176209403414415714e184"),
           e_float("1.3192836374800435625416810191850789461259663102695775705398604333001327604042631769547637979758413400210905417896137588118670117643026125779486913612086769724963484554033892808519380006777020654088908402200647326187258477777736750285237696449918664914224857107136348273550831804467585418026876936706943656220951744374148114216290143028468112133168497106099334164972291959100075742877959754863902413741e189"),
           e_float("3.6544549999854818939995955370728603427704064097540496682202567734682531519701042434667293230659826547229600554615189961573836406085260730596671567083486717265348658095098282643933303914311078416872187474199872875338145449040417585962721947708549382931864346527320965659124554109495585076754215681016871441950602321045955069074058176942517268065627353643465443920273031840787569352427084001612889780808e193"),
           e_float("1.0023555739792170873356724935798640240307635794776467082763475959336248788100643610085952491843867329335007409397081657827796022143718494706773984159472503511530147816992957828096519891672622751195242903590255612265857786516735791901613162133323187760797971313641575742419743956242443647522122678772813054261561964360861753902440421452196726112737519916884381214379656310762653476701249019160503191409e198"),
           e_float("2.7239658368374933700927296694000724623770655008573687155977172219000487179154101251983034241953254980728580196367195307904393554318463861112782940758086058061686124461480588313983517994976889082179359153022430376871326696505246172076420711589864965130021576408006525936644644762002497239305467990825110226268649584078377200510011950822840120426367529221815441804983730341112448815357166987532329039735e202"),
           e_float("7.3384892075404340472316779520918964645383092180488681076785113562175880352076886456046298608650767232524155516064189172909238454051001965384230702872957251904916822713631684723526780721772258308944361473509718164435132507570349810960769047163229310958942933156877630682454716038145710094748291850046494059972843315767322871326003464027265777515328537980758213709094131904565456805153536284639878849839e206"),
           e_float("1.9609296711043693651387229634874471927055637938865849775237934171797002375223025597164095076354396120987831541254915436086330564782205363247424384162523190406688075667451647209429915976876972063730483951113980972853633685137972344835202583394123752463608965197923004728824324750087698688575123004771809161926414258387686459420239659218119395962172038253940534984036352211961979154040448790985999163654e211"),
           e_float("5.1996664504579963570388658264528769323658148207879463401676055515295060358000082034183149696045269872582918486974737728552312931227392098989097566138854131585923964118408830348706690448955578776130564092659715656511984324652527259981415256741731798820808389750516504504331429799086105526873670201104227178318435456324831137814469423814082111112837800719397447383179624611653944474631414033217280947055e215"),
           e_float("1.3687969306847064699502497401296530473061187621163136718572756821903280174511620467334413932883799704738534965232279114581863264441261949499469333873975741174754160478146516873810323004360777600054995436767495991133321049249377108596142674903714673439032558850090221580633997826051895927496290713822649155470360350868622311116217386588820322435365052693261677460282040017488864820409807224762866480273e220"),
           e_float("3.5787409569704172061965812106832444598575446939670770654813540755132501770253122335769089120875617542756595598504612481923834476981799565949410581601436547632577444620317627685210205097654551315485560702431326847958887859284071617615989352899559191190123893948610346633754414183854115607075714343570463228817907521930416267454936235389010136278495066443445111239131042934459362329991697486102999884403e224"),
           e_float("9.2963789982339286203204276039184189184011869056963396588147822376025714119782116264340333595520423275212190789026836676581678094037091991845784161456154861602336771960470658681623777745352648503502129586329347599624316091997814358534094134454263692112693815530517091013736182011324134649760406210220170124386405441815200572378609481566336503186253294796525193979719213836882981485119000842128382941145e228"),
           e_float("2.4001724877305732468229094283373238376980517475914979497746376079920503424510868753085744273270652049222863943908224225018091527659106222681228137887087392944324351127628280008237989225957875300884312265537463338266166034412512067735484297625835724474441426569459053640540008636477247887956224407927182063211688099876846499733828420403464781799277916031551251479170688525218234171606178031030159303369e233"),
           e_float("6.161097894932602852551886795971825116233947047949418924363705782084485947090363614202240614594020346121732677884103291746627659416612726037525929475505073297249807475933613071564381018109091301517412697038276933635259939646449061284834918489036376165490623059417186193638287751597419957326558633437701816819910650204396829762733087079931542638724245593122289700397971905918948113143351687335456832745e237"),
           e_float("1.5728701250692933779160309039563020088260465242894753059063165784605227383629375253317652303172680497490451460932407509998425054334362409818401481537993796829351248493546893542087611456153179126965095048849171153644979702132558270324748087241990117476844814570569758229679899018831067844312780856860141222946196777368851109136758327285108946026867387747046252481424645489734130847416020909347276565157e242"),
           e_float("3.994567424197332796536500024944692962341625941604940936648294723532460658919800930673927079119696704762606197842802265546841256982723837636085433871128227828512281143247448795998956892173752599704105011929512239134503501215868516473422469505126479602489799381120989108583990202894527662184746514916002363605070901385820562279209462350191800647610995434377915766221841035668036832370570244000361431945e246"),
           e_float("1.009493552632342869847422136269582611084138190072034746970547049946327451289112920921634979738375001787107921048250586342930571476720126189366864618125029728972057985868779760940254250031342490427285926243369571690850170374476193621604238886648454488419921889145482977332322123086370583769984858010771821056349871662797144803034818088660586330956870497351058582015133128723093427099846145533850614487e251"),
           e_float("2.5392263221159109210889879348442681199744071157172018070982048497673522362892935519543618167870971773804295240293155784457808211904632238256884213305990564380883958258284346810643841351891553168819886051071542787060955351705659980860028899259005826742236774880066857786479826153221310107246576700517092385387374600538978875836423279199593134156337970460831720901877031836136201510470588131264162958037e255"),
           e_float("6.3586296203566340727618535195358039229532331016536676981476861813896519393136332571231446689190909318353245213803034855660267176902505237301672937011484002330722628701023113492671153655056346993890099633512108699360923896200223022588262715693252369627342266531780280679850829261816109429361574399065863618053225765318085391801421650806613772412425490864647679817632440344163814277865223852094576513879e259"),
           e_float("1.5855635958214455221712130593106715506183241516702280343812266559953349473316606863172280659524702360829091175384428709297225699574220994308590525653405217091316039384043836316016332043632166607287208181222227571162658405593388199794787385968286249829841466485753899917827451615365454777005117133039577156620261589482678963704716116372799665159806491457045749157043988597711911220093689514531995213418e264"),
           e_float("3.937763860660507636205545872921732265232051989203442079952336693179283930563962563291830869993743145737410777849214621720418985319978692614355001259393996036340142464646656827960696371172998108293585042973202321576286046389172112630692277155968944135304284643683377623337991647438096331215782031814799472523263388468710093975986637867950850290283292839611600430453888612296119504527022572946469766083e268"),
           e_float("9.741905738112747950330925922522086653463465955367046385180339075679341958224424849664071230566244133324127301263099310919316707946585078401091335285026608254572727796713956144716986320168204555309669432951416418060266431706314749600133658609461151809189438539839004005917483785980977351510051822259906453295136386727280733515548894408571369274131869248447439016672008061588104724990512158255276983054e272"),
           e_float("2.4012853419320659654939701692495956059270557766266412197963885414535623419611370816306728062376025603044386254597138838053049011134837939956666496309685584683450550329380916731309613566526738930099149319282146449563202716480665973763546828115664183657826683977882221544860536872443677168034553561483481136819835486619993731634926411001323090696004804459517184749279065795756469211682046694936505047156e277"),
           e_float("5.8982324617986097310263642328316121582189842719669100999779165033481659176914023126353611765148771876938769643946056041271029872478537612228052104522152767267134829423740540330048914500363211784241092210483566261769895207144745937671794705157815581694244592406074720613584955253687947663730053877289484853212794511660206008192924915944902192654824488736731555135704172036528960012348725610785535494935e281"),
           e_float("1.4439316111014522135976963707420375600401596177462832100015819773658483412681826270852981485043904053296322723592709690222236199820628106792352879436324961284041933006820593126836846889139762011659841726150876041090888953450871304858782458767069840118068429901657200122583978349517165017090842279112006602282021743473026212716241668498700748210340343545966378812959369556697789625930768355288995145888e286"),
           e_float("3.5235654105313602766024078730095190366018579461990220503820475005259688625622702923121774919965509565866099857095424982880361421536365409341058492002615914190553099721205628708805503679099922890600440806933736052044220047285508863671103597645953042844377382535222706091702194375185700672407635882269810716443556270311622063272665564445518588357932090660524541176946702798799220944990022320897320176691e290"),
           e_float("8.5721479844822292561676069480820625375144488749433599340773958815212856059007307990167647967915562304342937530502373619021950589798047374786964784828049288793323386054708487724076692215914138510172734860599933572087616202574259776431973860669924922002860925991965038709708896644314585182686018243253263110713314647486153041592915930754667317711273567353815906353916030631728509495556413131767750958625e294"),
           e_float("2.0793412517939555090504088048938819016437644960229640475229759348354393855043591486026964515145918460087937957569143564556568960030869156039967975938359993171816427506499709122583325755502901724782518861032028021432077690001285879666322339385322836756596228273592921504762699520901753154655635709997055384632326901348900415136660128190204220333301399993405960307005654784176547126126643915996370504168e299"),
           e_float("5.0297295684825003216752411419391309690329670677966146389328597668461456207546440614979074784880629054045897757045628648093010900166545190010503472899712341886534660644018497810665304095762180482240466219264429935219109357447733787858163660857474424573246333852568045148905700805373262410184294343983495073820185538636015728599513057044713688306464111762995440929448727088021469036885869078129036992191e303"),
           e_float("1.2133811226172454139181173090108446043003697398213626809020143966533872430750938661454382158694728118816585760737972637811804315060112962554618343392412577155630411358024373743157418883661149017002268253501669127417575043809992188699629375952695598708131166866632653594418312478517229786919506432980965423813798782513700668351504971560751052772552625272043110248230233696860966300735655016623575834199e308"),
           e_float("2.9196564834990261320537659355092516606218976855781195419850481390655911090248719391504163553651990027154212834746208049713937128738649008524088047819847078543159344083397722387553948134175646522735837306364392468130335734169804409463647737522554107677765295061555638849021332754707452565955838173489390453154213271040505671679097404510148138263398438203854387870353523185187163144782300981026777574061e312"),
           e_float("7.0079951815525112054168520973485800826167696187901217777054183209894966610394159328021329907065510410197018004231758628703734242425009364160654578518055839134073163839287365154962305633182822787257189957597288552515017309119060992908903495313719448798499502972052408314029007125273991788817426646923772619657146652328951027410843507343048740209323276260127126151862212682825305153801749975100559433057e316"),
           e_float("1.6781335130181216118075794554595729022725449629317811267134587486762872501107348800564170955603427228880522868484021298247789708043813185621676925541928232208915836910365331583078085934353885335395502482302904334113187033552330166792505457517347594696808531630493332240975087391154768747475623765143573508849535780448944780674812227328214372455885484892679845221052952696274877098569548584460138814254e321"),
           e_float("4.0093207320855804445050645453121940338734743449475140382328027791982966348571266400115223421146402946454439493677073835575876360046245428890730987301918066953784795778427564083044450295542460472738997454496689978958507773794995513023329998060800813393633498504938147095445999193665728131990592657503463408160469118292166301421976401169352004374134256097701239633570503501148881401739024292524860680599e325"),
           e_float("9.5579649834190374639709233379858681953319702556407991755476074332651744566722447494907121659365482475023311156334006033060667529308218024329793545635482504637007449653713890844242846647037681786144119150598164806795475581432870683745368605414936197903828356502375010996642037545723244546586671093942244663015122841167479263079190128963774207573115152415503455153687632796968399010003801097496502767052e329"),
           e_float("2.273773512093801088305012726322205970545119054498420694510810915627294306256897625150847293526041506458552071817993702958615547885230083147876880631145122239521544283238804033950182833832127652402265940348691812638280152215279230727965265990555227398143732475325694733066610098460868117304617474396570696405197058222109141646635918870931680181924108779120414100824785911164399138607871480017187794019e334"),
           e_float("5.3982255705575540589929986075295667133488394111366708742889409741745624970169891454729511556534847251039654626153001067057873244438565242980180562639342528967354979101199578587810303242151175422596909201498341921094670034153695203279962121853921973110849364416087130012417428116435641280709717475674613224264524233020917600937456089767600195860176070606069172785199254689218268908576042126346016253327e338"),
           e_float("1.279116465948600202159444662554813671067510176707814507338466501801696353294233452468359733582007034965640362777935450170419369846918106138943868771023252729989333914258581571427162955642888152027429083726483381993367420498230507639190949580857831577053458010273645271021717189427690121812108894310061110162167706312396443137676704355667545053506763860381514544173299340350997922799171648892374823798e343"),
           e_float("3.02521279417931790320512301009557545204692220663374195197746034019858842549508992756632240137596069563069796295120625430010338537380878804368643993262540038869575958835911307854052118734366358278245007189798777347040702439218006484335565764767613689619246850209351003776893888434823314699827530309095629279129177236938678820681097732128936263731240996365041036049358838403761576871518495409281231698e347"),
           e_float("7.141978633418352242356228961913042323771812443178673909924643608823294072577298862028244723883425290737894415534502982404546974185464681161281436216374550368081182287120971803876581395890262530650758562876273967365305688237632498872126334967447640535380501277455547870384463651720909261890453436882786359674589740990739498380309833809802851536888665521012524582898119270604988183307482601406841938942e351"),
           e_float("1.6831642552624190318854491709926297501295680661400670083233201770123751042774254574453443129431944778304628396157099031357960188763406966308771215060504084685948878482264115478681582452127535416861232442992174170439944301621138796952116585020059033433652737734115669334526245978805310492423465690759975930835240704169157756897034088622260500041477277407314708804783420277862129444836585921084166852692e356"),
           e_float("3.96010756525323044118967374659293156894607827504145096653845223053371316012265142999074298558757086910573444577505753461902720609068169858402086012769354326135427687261158036368947647651302319854074370763495674282945442951647601560479147552485492378714948372531020308521711089947881710567122289695926754230538724558895404193825413825080539901833483113700188521021804613325881811924927520084416475796e360"),
           e_float("9.3022050658925989705688911547643089098203613016912600592708260377152044321335121788889129547817798554665942964126604741641712005223835296972599672347071462762606868698258772144344415685984228287378876639012226936504344612560457221901137180057009676963407860921453276106836141314436170946057894248869590302107724798303593300072172920784711641956325691377796683005486753886655865678947748400604841048512e364"),
           e_float("2.1816646131447318647905438343584853901686271597695900343206101808419174916116736784601383757254757356986754379919788277472919502596399368383311054013482202219014699869453750442898152323912223378732534032332409902256004114296196662955625815633201463995591957876762906333808022989915937875538340497419634949929389396273604120701191391731395746505405900174799267394744215223081420222364093701732808630845e369"),
           e_float("5.1090104018893705430386032194423567160212043008621822266682244901612582959939775179138679697932488919835509807165871146816695382949432119201707179904410960345596632352117960693036055529581803694203915558766364258279049987936853705127365005969037259876713554737263402208631303731280136410878087123155695628454564677336518812200608164174169440614730174567680805566740308301278900653418023290599197623863e373"),
           e_float("1.1946888345352183968406790501945196577080883245093916720998697080357340024949814346991417203195652141415086746410993555666285877448850529729676413385143296120181523931328107072485769543867014676695070155902267787687620429193124308247254355819796390773217110518286946250948198553403845296406617073910780043078474585632367461637309835739254764558322061807355601852033245591338905045966417447399505286909e378"),
           e_float("2.7897386885672221313195710954711739665534470192915842831566102746153242439423787124437015544611454475919661430783647008827707792940373473983981482894835010949107581713698071389122521745293136972364807275466991095747121643175031591885539137429498298064282048342599800708721795193850917421196547904453257742218775738269754304967601534204950845400620714591994682900917024233224651246150749023104311800514e382"),
           e_float("6.5055418633181936579593525619671057791731013864620281826101661327595867789668396403961761724805647365984162348140540798601090449125908964099440889289291081001999751198344964968643298080550622090803140311114848318729672703229874364211116534567458318862727539300872688980554989057450653701411889271860028258799811674205818181324040442470988920454345580151569878038431352486921235603827435404632711538782e386"),
           e_float("1.5150755153796368135802850425854341154093719677414184382606809531777980776721334319303682154243593587227256427974725965004881170623611350469316456109079913799575132348561989940167655494326223719389269968475191266261223293635485809697053917908097833365020757064520900675230291675983920154411049108055674099183687473437571957914171674657118904438542899798452930882654832352759002054733612181153395546569e391"),
           e_float("3.5239903052668446946719302479993626033225367868998340410666998255829901375817837149526204913515197612121643879339077233864326907378570483411211172142318996451837342688701334748857152409073570346537342833281062963301842830416985595670874038457007903084557772744505653862403416393961503437489918414686219145188052485235845994042480989507254431395141445635702426931546520635641768975701701353483078892629e395"),
           e_float("8.1865837728981594173510264009707839860365533131407766083224351158619645200713365744575323086154642317403975229746606438199851754221449410741545577951213724766818134908294346388032055317768965861559639559760993299430284810306151799333652141910220989472671887803243443795874320022210690370238084402010686768201391690716188149228054973156984878743509871867086754436829728834661222069533260683259225613517e399"),
           e_float("1.8995708140166170126211628158128983645737008258359448691218764518871039818810865494111883218044207784561829538891888565313537203220028750375891684002624037653485116612573341570085890308560800517164815473318089069890474123519875260924260099461176315514141421939565121404982086057959376596822826895033113923548549902980730032726511857610930250966404813441039421768696427117833643739788555743642813185577e404"),
           e_float("4.4026027981576705080912324502464563415955993192563010399414964252326897017972631230164601228156215252877388990111699993056324625969473735611842259390502260385715974765582984147800324619686098787584303291550838064902945605462217850596299511995821972962820320748238130479448276504084835446673249850179808430283112518603023499911431812485567815864639396702250293541320897771827420592439585121376352104098e408"),
           e_float("1.0192495764615919206991017598339071596258333149196472341681198057771746530337718668555813161853620449604568546801524761380711484645722772227908484541417100227217794771816332886126547233820677726492610242595079069509253855840547261783021659717657180993387074207170325644273755738619863797460448600337168551119167069650156630860535484652125278528567479809209391144818142863783836700618930498951738509958e413"),
           e_float("2.3571309852335423204975936864755705536634268517416350138036314735110938386868647740201394257448032154331947625280658939704830142760968110608249128442448748361567849825258885954400932735565686970596937942259176546964419147444681993525299061130749417408030039209727327138851125841075535953967972521609709900721293571348605244464758457623953526765185849471524383239487293570493728333054787750190836205758e417"),
           e_float("5.445447091766937989428969728325997838887631508703071147285537511668091372741259969780778243245645013784538707495411769219400802310363922675004937353013812382667809093789157825254888519409597342438094030487835055586115836151429661993944614067543298294177373409012324840883107787928288379591227008717224007274704699850069579525963346585042050971369838819803217248064678106997353487865669607359578168643e421"),
           e_float("1.2567356506185336112922635081694949995256707152926530520359778676000636041065413526816781378791037344210696327179335819508426390688894592123974627881040159423863746076306375235528622008321641044335890890799906280214519754932830225479423066575480114477085976527523941563518649958885811509641543218476896888766106651366981730789411371478459006399749623031440947489929822625787901004800953618934663603414e426"),
           e_float("2.8975320795638392719618845597249164906369599245278785148303111086162654178906620618838398709483637285119797186746735890774516362374342863125755050533254533499302973577720443447584695064932157517801681582343304644845803894892760034984288212428756715408757850290945512384012773877788229463999954726517917030080942267167208769347327213594764003516666879997912982371734152991499806586489004384281756818611e430"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00486_bessel_iv_at_v_301_3(const bool b_write_output)
    {
      return TestCase_case_00486_bessel_iv_at_v_301_3().execute(b_write_output);
    }
  }
}
