
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00483_bessel_kv_at_v_1_3 : public TestCaseReal
    {
    public:
      TestCase_case_00483_bessel_kv_at_v_1_3() { }
      virtual ~TestCase_case_00483_bessel_kv_at_v_1_3() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00483_bessel_kv_at_v_1_3");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_k(ef::third(), ef::euler_gamma() + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("0.85886011401269266808508355903589418960072462269900994352311899080757504102196938966308509469644754620926034812266347067254673851184250975636284892898417177353381812067069584084131821851129216248996303338449998852118254548473632009897334598159968525098758772263484284785876629177522996264773034191797885915185896515116739240139853108492025715659395239992203908448961607281555089375153815460148380067583"),
           e_float("9.7615741233230514594530462631488389054596559985057642774347708327287366430595819823037356153898874800920553295920918012487641907907292102679931452339989647503689065062067765604606056185300756465227808179066864836473318262671102463261067571510159303408137241982323855097887043346275244873662761639879222307308228825938974377084558589184020492802553701835916625958751528617923606178463248145955003735411e-6"),
           e_float("3.1868653507721173856090816125527484480296402858570624409721149932750255851656575737272874749875049630226558462416107801975415720642279493927534623474668221893170102796251619276941878062781634092066729980724473822798406437540867141316727442547208859552968797156683633612250814769404580219350118117739049767321631183573754971878040398032287414709965915285678847201907926302017518352666839361847584170583e-10"),
           e_float("1.1881580523994944755180054539387555727424668330349569572538960965386248415319474776214249852028901537159034437775163228878634247663399261676145210049117951371108207180982466783781980549913906620649255500739760306405748045884156245954440299517114978525406757879651721003432448541219164941502918453949827406327346395572935239307661090836769005784985668817666198207704665515149734276063893237281170968867e-14"),
           e_float("4.6851515186974292243503868454192237859637824307330723773616076289431216238556204369602697836213884208912692398881852976199076262866768735139864564079174207420750992774364457085797107778196732642474740354480470646918031490600240429352526902222864265221191448683626139942966307003783981178324764591106193221740812670875523691743940240595965846277609371399304551588609263779212136528991816069358281637959e-19"),
           e_float("1.9058393206402517523700553052762257162093869354022137074865195898495542678744091432735673503538745469544936373060075340082239076908803118449354700906657909112131507201262356177925327673010986781688428945184044278044754131798048076378718766036352654467705227244641959341563701801781546310728562869547153962929243703669113295057037525584138697307550411863728753873281707437514119202414571944950575199112e-23"),
           e_float("7.9078963420695514039577662469701299165145876819268214668873888717206238004246290610688166174220885167613175682358100874844794703159744900512186211751094566129365067429178626949798931366624967511429057150361884564289102789505711964517803176120018456615354941923135998659838201925059011281402777926487536182947760050321079411293212606612323174785809179690476326509479084378933850857345256745101608925433e-28"),
           e_float("3.3266570185168465451003710196589601217532871406837664129454537185676175376825596786772955421172237078673752425667149784096180143731184890156139137486511405520170199661013131747956602743772661465912008287478515154227212566162580458528973124413755021277334467984095443858693232082804421916985153771599696845563341012506669435244542594931920654149243811021976943129547944947001399242577922751110119966558e-32"),
           e_float("1.4136492998485928922511855625704107442615702334844800531136783727398870669156692586081678217709029722949552897036794943576648858601923485154498339257330064504568325971664057689262751398824331248483140023250219433971553378935152013638411860802986555711186238015909973330132954276915228273243694331517709115786067087972500240941045790229851623559985301455203361523072707463419862061317194176840477512808e-36"),
           e_float("6.0538876266346041942885747564531480504831305186154870743557723812733919870584057325975134200139029962959627099544742898740846667734231121793571171117346428908051826872145179461397249018843170862889440406661160063068456797769827259489168878233895556659050787343889682069508173552642767794488063212800276152925635010930467044259227929464680077598587328629487294082649536511604112493081266547171204175447e-41"),
           e_float("2.6084467722473150649113472386629256205076413381612359457272238433631303958987062909475491415783910006307542900376546633265148097860977270916603409465625354148715110357346938020180630312544255782221357705076546812324247170794767610937884940421396932500413307377618906000094032571334752691421583296350939335953454234445678940936382263418073960981004154719573685550547602786628200886788524436763118404562e-45"),
           e_float("1.1294863930642577714223319564576791652161443456413815490893947871511731151301204566601303653309766050582408403012889700087962493920272828283714775072242452172789040102687630729022095290656450549493100337449532476101171086727184621643608982395927746000255914101693748028216040644338569577993075933959929103643795941848926811488334524995457056056929438458172796440339735005142044782856272404900327398261e-49"),
           e_float("4.9108742131916537355064180858061154777007159078026632542847315223683241133591402891017422427166284776177125298868197291860467034837084034679179460022812094713668385346988026323515121909327880445549541692024484901826510381749668113069294098349057032205320020569636592253000389133507160572062444536119411486061096132521620772127185197152910011491743528964436461154051154192661389382333988745802517435248e-54"),
           e_float("2.1425547042307005604886462268500842726275926162382256520500601759044536775588550213344694691108466273102990897173129742352073570532929339004234151425707090551718906950677933217980374423271334638525049474289604513001200327139435299607586314135904125242870605880979126907296460922437206397211546099691985699654112021246154042691513959873116479921281723694337841321326902181565448284239827381905579559532e-58"),
           e_float("9.3751806215811151255181253263678595837228468124120466319829275078125117118754460953804903050689190791669870212845133539306214699110519608626625266369377110663822238410853729441326723397510396248420193893633434791969828421436618432217213896116877801178299454884072730901130217006756183974604534243816183184512872494391894194681783840079921992071837339635593039451826324520197498216988314867029900079676e-63"),
           e_float("4.1126979325337744460461353723344798227905481240576741481496402078750396436397527834249267289546873727030776103308227296012408755809997134143056707093707860159820825377511445583840513115441275293415332411185065017809005351338879792366939651335151669811495121652351625345925360730127263905224913921300592801274130899571701825087121596748086760355018789957328502216330668110598961414336239358783254799154e-67"),
           e_float("1.8081400136192814157118278735496270685409800067206071801540393991213891114397814195245182173406854281817813651088871441346480089235565827970428369244705453127525369303850500425601552527579601355279657040321838751576770831361195219194740644129564988081829376576759677096570427337830479596772226671149624071000992606997994700008434425212987580847025514876684998887226460792454841536627548870604510210105e-71"),
           e_float("7.9648872781574618016035618506489732103378021911181836025232011361920960039890536910324089383284601278221874077518474380495624792168043517708897911589756428267693987904322140473609318485077095913231064530251155081235362269250990250785684727589131325933232619892764575807568303600489518440559394252086006527008374583142209786458603164227025523339683837491675113212833934721059127097884674491692120968102e-76"),
           e_float("3.5145812290320668248402378831119442426189295934438426140839405148567657525240330474077360834524237606520660707375339091564215382732020245033164556279660319996140314740898579920109062306006988545106735188272021297533460607403261337116199268687797463213732444253010486469095715700326271801612464658875084223741442835427228045480875346030300889617367670293561789688800893793977790773343799293478689693133e-80"),
           e_float("1.5532217748010171463141088103200747929208597135942969434943238753053763671256682016749486159140741424264118901646655510330639394971344719904080714574235746741258762713252559256575072950717921459684003820207876060503875487295620117735502506602130902631702924971103243326291336006779311988742873424850479126494836616144232856485154348096952233313629055957346035009759013956327235019094479033748766382225e-84"),
           e_float("6.8737097680802134194995855396652326629640078088327728941748626140539926441392998869845129013008570609448759366163578631720033894588079680359337413010994648125959719987166327101772125971917416745263241035696825080683879483742683527505779949606400771523253886358042783757026083385886361416988798772706599716707694061745475955697964186219786013244111368699951277237370835563974760786214562690615955182712e-89"),
           e_float("3.0457102677266017201617241549732879615621638572543678298719826643803292163619364086421718340480783324443420406702690297204650857514833712909022846241298121082330098383691770379634601668966931820698316757884936194210614613979979580048689552850310830347185950256962016269474453709725601321490195081023680806154225130005721728740252119775004351196787933794775917521704511787646384062252906725322012072608e-93"),
           e_float("1.3510629850953071006506268950484609835002686132011953269870613123008309061785712908466504371399252224875033773266863957629531965088053646152570917753494949110642734619506179404051926664710638473559877403582511703987681837315128183210030319187811919415696585476153579943237625587578309874728971298717522754416480580886422979555893563416582220277950590867540231712863728395812134922166055861914278477463e-97"),
           e_float("5.9994136990953391980508448935895548259624597362062918913070018793875475657514103383746270642851242944812563201141570022013743965279504809831611642473917198348685370454523508874848577284857168111765449324790338021067415505271103619675135005156090565437012376960916035872430933201929488135250044616479933241560217073450214617425245271084991830463036712627246208649462054452723393544014395927507022957164e-102"),
           e_float("2.6665538193072860333358678164505257681847007833312385026413161171248167627305394702371529950534698546217554003075932316576205229033986489018084377581106491125773393583026539015279086401759399467534293058667705336183061937976654606268974823606996471001706775831438389391646299653832738668115782577357701771563365949898168394865030323931906132717173140581105678985063548757472735653148488073233797225969e-106"),
           e_float("1.1862247324317469839386944171260602257142498633958190360571613050596183119736296785335945603218292929007202450712417556491072509694499842946133646214251569390037801962902796795314222902076879002089243198709954153194988095146984472880178468383214279005240091541920809945232296312506641703204281212880468629395360578631176273077015292308603740036601438341559085106953077745049445428073312295272042325755e-110"),
           e_float("5.2811600170129988913410768308826944391167462587946714499327143351797132151097521640344941334330746926774716205653787769114572123974403589258109267885596946473894624380866300997489007717302165691093845284249898026617487896184361868429037297989754504495661870270221495847301690844957948539749699148340965518036928823886378824580704836515556246657351011476559997276834678346664739770274150141641558429988e-115"),
           e_float("2.3529428401447482332585968371116689137357423382605539463546207311746337926978308399991668242482011346600358404117090037678332913065542783360233459964810835625569693123481363144307149838838462735622898566455993089904521539116234865889289547760969013628890659838417178087929864591860689549684792617840962766800751212084109487338548967030126264614291684656124833217129852594980839936619575417132864777772e-119"),
           e_float("1.0490348772560816844523046257058426101978232678521939899958301822883643872303233224919459119364978427746607804418984606715446111347294507644042743580404416855072116206424926761811828411062845462962710630573695978819920204054630939208756311849605825708299219191471356742748546640111837839388785825901911824499035600236872288404620200398594859257896585625243038769013645631305099735882980634366533047109e-123"),
           e_float("4.6799823616635990610923695702604254753664309073610994196800138910466047606643226059571194296848374396036158081655846280851954936021922269771137804846881025226771847884294104928295604848125570750149600314666010312200890184585943239876240594428733594675314262949665378416321916421277725104581289255279858160285853398301417635418480073300410293132558043592371961981184265686145492688790895587893514159408e-128"),
           e_float("2.0890824906434249792124696816366089117251860110189480340900745295169032289961036082680775963762613330445421839707263230855864861378861925404421410343632471634621974523445871439965803633736122826617536403394303628112955388413154495714830876434298120231994448747503104742308820373519482063659903985417027852759390685445524593267116293899111423776510845431253243814057770955398688211747828882715520444245e-132"),
           e_float("9.3305495325200045352587019130023091081072139483051495033522163303532382844789965043102883785150276683074741050048220151778379210046533266066284281685764877729674476113344732754623530595337789208175093486888162389324133523681498925628243236171289951528827342193223925731572284717831350599275787275583796383963591134933541845739467285716374036346864980526210253354111415242095259427722856054920595405624e-137"),
           e_float("4.1694991831033001978858484166049162625120810484310463794738550861433054201513168027192518586272087997280723434161657385742453703951328887407346775480716394076645424057784372773847688027881389272651034527997432758219329619147072463138645222605317225897451733867984577020048131472059716991088948166036119868785445094264601092987029650440784405013338551162723357871691826898342958413472505844566592639354e-141"),
           e_float("1.864111041158464032496211491316117361433702314253619673244889804979948588077765004022803310792863212278319223918040360020361000702989929791309488704268775325389221804727882030461374290962365841182346857905637727508455998361632552502332558753025443801192713532154772617579235246539715841910294648087297022724071143398215875142701153785611874527218027185566316450819147117072131027095985433236958049826e-145"),
           e_float("8.3379309449399796102410577888322140676007491064043185851038486401789073414306977117589737851069491215536667378955526904144080651298326798672554221651421913908062690779421163360811825715608512054239385605096453109914099982302278917958705153570554830058820927109724869490609816388987779919419040367647106718998487588280272737271458229127313196850113123878623953199382662872614638735212652631538406911277e-150"),
           e_float("3.731057526577993198245594470614298727975155588777429810748014281719827435754567582191646751365492318401213430686259729075936232461670723085784299284492104669034380076259200457257103925413196035849275093547721461115301709771722620220681597160467963661606890282980639479944140018366198841832460019086281348405345024622912222921328282377320314127174008096489541819827008884107242657090639070721615793871e-154"),
           e_float("1.6702528005421875295648233983735636719063317015045827925259887965164609325042111530177815311447152058660320315629876813098785553576468933588846040537896465429740703478265608191290376293121058890042472623652256634806224843201394590056260504893988537213557890787339540318791171768989086400307157730835853787089341642906681723933311992251575584514062578098980430893581039185305782955378471987413428957255e-158"),
           e_float("7.4799625582325067565541918419958399944761987898921204884506493826782329514004565561794230807691130558794568742080270853546861874602794423543344422969670590549414372749982799957216736461326665740783217838108604036733268305417320355435691198724135846919854458346612490178887976250250606347471870715295041783870810196166080777305562987550695364858562926356135215438928516225488642428982986540350844984563e-163"),
           e_float("3.3510021188627253102467181905083146736406837506642571724833893445845273035282019984151541997348473941993804556522575063847759259450587056960857741592837823653132499012933322342449574490184190300751821299920234729621988588073696965925388239725714141945374748138023319134758878343212625089918900889346611067333303462525349401714329461162533181986373620047277627053887633437605812608292102711957578242296e-167"),
           e_float("1.5017576287764744171736693893092951984841425681253960015822661077648326356086339301820163644891532278789343947039967964406917090377580543617921656766406575718431998248791903926231019501097899909627468627587243451077962713116160738311844138111478050739827738065127434477525210927178141696274177702152242427357245806370630880861280727078377940818853923788329163580867295474182340448713758824078159168316e-171"),
           e_float("6.7323592305558833746570591127908045011514296788874671719419418908685054602251562982531046928266545685643548015693280800646292074511058772079425992911672975276295507035204497365017087863931342227199887886488586757972651054974368907597701685986304423161856708874824099359732697307552182397311940933366743960357694130468155130154458000090244735371143258811233897541916059421909033808088372017960816020902e-176"),
           e_float("3.0190478107356541189818497556814017495499801701867643668321457879207105361096210127156841442486001305333880321008067375311657351645895930770581302942254338917265889211879641943956750213515532880001981309594231274900079666182687051306543944533684601625301588396854572940607263975476033740525847394354243843997035991357475847397555946762720584436322861547578225624721368343921820938870580788626139124058e-180"),
           e_float("1.3542581750048252917407276309894747546532545124226331690414493412864324725365554974234324330239205254980284647536765847550942106440000939727263780909922229662304366419436204539844473831424368528650726830648344565690778716673159585170098737912098837835278890092298971051298567634669511484446729433263578548182699077217234853783188329374879106193996086735715741617932758871513159093594948913993021023499e-184"),
           e_float("6.0765301434918618884470581368318882313463321248559036859409727206626678869622317990989858000500680374389229400319288815077554477691596167233070569001870137642948667036033633687423980657715667422114402064803520157685844722211310472145590402558765963224229543151136134074556218004483975471882511674486716923441078936207408404374293413222957513847803427995337613329811795302514431223216739308656594730814e-189"),
           e_float("2.7272624269464699884518090182754770910351129591869120753546446825302656432380146988514282774943455402381573227884842075223524929747492120233824959029202646557440640265679037718614407934368175325438090453601383729855422947714578459775062282589809258524453107848625262131451594609997311628833689127258936656405740361401843502325560770225999536623481424031607211468299718020555287936637297753592826875228e-193"),
           e_float("1.2243625286533865593897755058001621922858246321578063885863781894732955373682665490522088224590055133383803802038001988582086113263945136274403718438128204590526055498946514830214560473644474680810465918472162977176568411960098220436820450010353371788252980424806588495011259891896956651928163390605765570183164334879147180195295578479769641646679972214695147042378941246878443773397441176091640903043e-197"),
           e_float("5.4979406734404083489688585524812704723629028077451227567438474033286425439053251051755486540040407064661082247873620221612355209976364178145515112406986867605488085674221253901898303861727785562836746191561570936925591496092005327193226026667334849635827115829126418028267197800878413733903883615036831948695371758212429371016431029671906497675061648404567016858195306530087473624871339141597901500498e-202"),
           e_float("2.4694054132154502024645923900684925817654363790473928077319977844538043557389886882307924353318365655623540592927420676141102265442916747229784106732905586673186150372213923081590558578855660738415245804415936468457375516207262144502342070763867127422997663632922445748801414135356267377368923303922865949986008977467227854388452057222353410315711767813799181333271199879927952150566976658248554589423e-206"),
           e_float("1.1093862198761685422646157288649767841218350887987976121788138985182280377489042404888075247539946813533184904031947306511199570257629145136159890866234095186795209528269524107021424058352612707909466415805231591214104044642361342052046254481152549456369073965255517326430723904662508458396933226939150439269609053166167967898307869211482831719063871660284432525833265713992188216702826769093628203105e-210"),
           e_float("4.9850225369171413613478536038054652878415076728662223210497326819259819899024289267167876156244901833973222172859447073710820332439479452707582892448582515202170133564000735908994162841207653675563964850071701411460540205972316092655173136341968409051317844043733208876198179350457337734803637865252036362700947000541796247880790556967390298303949231573839260868775391124158083330336788333431434523798e-215"),
           e_float("2.2404831420735672867811343891773076921554638805313028681489926655083270679204620847017919905460543160253855738885329475345307244520683691309435498155183424010993188431571442274623092918389156644642486544820442719133094544844417518174076566158371056131927091179059981029241889319927151325327140278114537172293295766093961883799211075675688163399352271378691156908755160695621866161566494696713647427649e-219"),
           e_float("1.0071701897225228383647719341030071436251032839100371114012684283748455539883112221706258868244583135178373230246944058766219810163119601183700142259361664339618208521498527806592311484782180367605903707484438847419765630853793083047840277339286873525492774424090849247346399614672087231193495590590556325515484632447952361162003066305486806433687103742346696268150695917319395781601380848575362020042e-223"),
           e_float("4.5284264009695162683391863065908007768712222494447920046782525828573126717381995953369385922585933010803395065751450966527258220943228904339737958382697302416151479248489043885048160946772294859828590439140506905576541622508565058325258194182309050700776868033842815436576738335970159653825144191497255221118173629007442164415106408838051874299274968030730653900747691690071060156543590155096215610139e-228"),
           e_float("2.0364411513156232265085634177479310142820948396007513772152226603149968172037158231131418619564158085415909473793420595323269085612260470426616180418902814280911129605214868351666844726471589409069522616255401905560172289075637869850707114086074414797246331839912588184588007914937724389638789581035140221240847550423862580540938661284743731876719535637374171397144638815342566165234467229691808495855e-232"),
           e_float("9.1595370694306675749311627566234277929960875627358637838712129060336267710298963865416188549569565180973227780006794624639832638123533347880767428128822142831720305341302920603147574403323760534330343847127652464965740238988788069589689122357652075893190334188479139476748513090399873114381762344689992629542399326183741563204951966796935788218773188018157616933939474869390619496592998110969534532802e-237"),
           e_float("4.1204957257990799568050338183348092774760071566873506087583119741711616565825853801699489656212836633387702056157493066475604285063256817347964766499518028711811587877550366532515994725144122806802390183848317018995503398736991872707047243587995002097794222282821580755223145005925739183304349763094539219342965997751863828304102842960875372827057423510877317862473471874371664640640914308833827063482e-241"),
           e_float("1.8539457464803146962233518233680527095592841701022380153446030925254501288373425383246138912465051690692294446051329344955577860075975801172524732056118345424085948006265000365127089024804329270141010716366606978480923125685893756798366947108924811022201472676082967151767899372457571022303765639973098083742235194369764426002684151975727796034104015505504530672294331462132333286444361166323822986829e-245"),
           e_float("8.3428349432302159721651962152596137719848829679791167813584618405592906231346838191805680250688331870151130805399736319077826489516104740751141523105121681066208150298618709469668687823969211081945324325213136199991187757711656979386379091626998043130104039537184254504202158549913989423259309794441749276536821507351556004100018499618856487505965021075133372301847690567576876050018589030192256556529e-250"),
           e_float("3.7548877611351451817407496041395638340587067889665336158447483532746908069973009329855122143893466408751607414056993143043592408491225016039558525873426662140531271558369920136072548171291833667355879083039612850091418675418231514245932042839592657365065764861722812538220797320101974775203767486883755312775521430712357095995918371998950631188124621780836558043799136724065945791287802266538996812894e-254"),
           e_float("1.6902255761487758534917189152959293187748380947661595060368702576873989772372309873922488221484140980621862585224980747876423076929822696652872797777218598967814443411419787755881143866728098838915555536136150558370162183639455148212492214398122844787622251217735395355502123406722013635613585423772160577588422465286871425114013066064914183852904383559799079218767619663533632072082621400192798065105e-258"),
           e_float("7.6094736380529935010602008838171097588486286539422683652655057629963263543466859795413970911398980065471926999277227885126807969565931543491880828245512511692077835900461837316206430908132241843764789112126227013543203124445237037062417724861770221727197328733876549370083051268758488740646493439546035901126986731448485101469117901460050286512767491381657564594944835752692651565311503081095875582885e-263"),
           e_float("3.426294964011771119776898969654040520703914237368390500327886041607119311607094571209817052403052459603122260762546992083133923189355609416501424156762054370814104613318449058690308463474957809012290668476184056824956223887623529911162961888607555408850503726674717198144273009310780847446347591644211337689349576519722980964117531674863810486010617403606530943049894136442353671998855429445724262976e-267"),
           e_float("1.5429544571789141521292623556085850706176053620184703946312196255501223661139721044090787652449048427511096388532587622812514201112025784603561488174806464308920445380842139595433952853904489473984415073034536038718482798983609110836333265550450185136096321356645728120193629990795732287302053269515044982057345289391707691004804464648936456804942545951941321140984850941679045304685839582651780959847e-271"),
           e_float("6.9492483682675976266841693977974534978092265166223364001876242242215291141840225975493536241281721724710880226741272825858443509663625076641811789579563367810947950359321268651195438443099130337300571130559952688516357504651099109714889547311571976559845461278418846750194813051378283151566269952688891224836330794072385632050923667162475565638796974370728771697337361843467895012249389359622000489612e-276"),
           e_float("3.1302365184827871938891953634449363514819826751820663432842193697219913252551647526598016146838271994250604605160400707504090476541727015368837711187858515125526059606308933234660060737964250287474480864226051411240035360316132844311754189456925224736344067559281045846807762396678405904203051387077099221991533187056176709026912700699306016226928746801526576322427799030110241599966649170551070733248e-280"),
           e_float("1.4101631976113073028492078597157800367226835809449323200916875694912717380337525749865221966016548250051057365322275064126395099399226595306145496335996246333915179525785707929787315862537265420437904770104108644245420469447684976378443374077389227702054739199560019098847083812970675237505796752101630708692955695775952153097199396188941013592597368503749827628297285886120034663667742852990358047101e-284"),
           e_float("6.3534978550338498298474143121846265626429099374569538333658183853240547304245195535309595467484643216226742979126961918296653166411700309088193397582463644606463771496419475260081447925280880475991696774653393272946243618140380426756455293432186710825688343571566712729789892224087913228159916958461592484845315828069096355294998713701704547364769083550435250647624230427505636586183266720804633454337e-289"),
           e_float("2.8628997912264904204130600256745836378906159076734221134831004272386787045437777374326774900215166496502873687884714249752545282008108822491125463134170757444137156509021490433240264917513202373791230161563034690576411018263857900484237402971530639930730278463439086897247473718993410742586994822463464008218957800596473078697243580696443322903239378527476351156721862524839998001025234944744806055584e-293"),
           e_float("1.2901722052713948596536494200274694445739932135408351292129850259655332811706377824067073703488717737710956373680391847716407801835246454933672411468120888994840903782493477030088341819439734512024944014575112466417867840644346544934188684528145904137550386382288412490405888990447400675605607288973598194389340285004123366021456666578770449662391000306742922153656136111596107786251013963934779583411e-297"),
           e_float("5.8148174264819546471358968284707930097167138737611910349081093590230748603774823633015464837000874419235650935858227622255180383979523558592207022118425687060304392564088299476742594959964027515599142074916275687628965361518402284410336279272270481305247991157724566393997774328579748104843397734671640766664708164566242751667600801972334948434286253334360081914271484498275183889382453116402730783877e-302"),
           e_float("2.6210180091632001086730903805729911528495815020980683644368735731938198915889726145627997849616329623803971151359375693659265105638055668818333093547140477616043743321814086334674445606192273311668186185183953443967247070250964668046349104166688801008493441026944089093219228992348135338880026703010970582805632837373438008740070887737396181490497157951378591324792038868676320755684689869252662479209e-306"),
           e_float("1.1815392589659696114169093429605300603054578884843003478345426103055965588630231462315058466027342399252674803381080601447939381643375256714535936166870606797158089093077383925960502774238859834775037163830477388634297057759958468131162634251101455941425119708752419066558086599821693745484911186338625947145399997595388605287309839858668716025938487834837756563328187310816086817322385005135510270839e-310"),
           e_float("5.3268357004232741052462680553012414758034670184120115384919973006420028850685889898025910685212469214257261909977139260998846636919631226503304527450054455474942532342009879134724449664485053187514379404753707714817023239667812347741451512744005887231044936351951145815859141444426403269736004009584445969094978502232174207759090152337370712314581450096010296965297665105092902620895272639630677181623e-315"),
           e_float("2.4017746450567377761431515950543778639716627240849251560987028505055541231224950015778736251734529676652072753191130778802463199735968670922511238686872335802613559992316306192831119036469641338127744558007610329417698875312920523384089086401912940492507911113508719591293415358020401558061367431266416281606918113221335157175706069573815506653193304449000104007377830758510473104092713469785138319376e-319"),
           e_float("1.0830185169327442736837710125141125274231976389270729766595025030610251891966557195987651624443902613378090353160162705611988915501296047733180953524670237989447732849364814038777055022518246460664215704425722743566486687456536386185695858695289584714837292530611071759357287949831711208439638382282676886858854499692786128963886102760897298428302082255164559797844853734839089953927656775818124831779e-323"),
           e_float("4.8840386228240479811259886271786993214655974815487134086529662806815860168035309763307510874190255542937320768072946644069181932813006439047624809797080996606012269035913810330255440813203664094464099362338730240194615335346736372058110926300069311136668425131729082828992677932329707831982309722565526375857692619160119705830792802408748083235441187331041238655557274563345388141002363836995270073686e-328"),
           e_float("2.202727790594000872611056152269265152588149007107273280472849027962002719254015179414111245165573873162222197249620798666639732445833935180639681605062207614166196253601769289022590268111503791523536777308579023251204431911841063996711476063016296465354670040831759355611571697205983717352211916057042249392447310475593031226293493125225368118587978086521949210949371750440023270908283478567780051733e-332"),
           e_float("9.9352797409838067435454523213538501806307437346863297468458570422055719624398981595639403579297217808441484326133409954218763043561305452607106780735830999939862731872536476419382551931572577368863369367444190139419541599832099793187789494313370778715762456393583491383111342647204242417867102727143914329397072803231431023524480608087854130345044472223348282721273438412760109318843008633808536823163e-337"),
           e_float("4.4816292719135752957263815511668882907250788665668451963877294761174029286735002094318685376883025084613589394121428039412032539834299808183192044032878199983983342314324961854402866342432379013689014468083600922615010416324521339010703396695595695674598702356779215492193411143413851260238598143460207006370699838435796642537636061143972869872962918797802992224488599434175157242787469202662053510885e-341"),
           e_float("2.0217496912709769705936296615381887946766903356078455932203021405265581669407525548892014124446274875719292413912228651055299419170447763914867448613150294846247990430672548854936051665566690881803015884987829062777072417004367344883074095064510815396718071411921327293962446737374993656646237877411078787446021823073510310887772357567151781835689419686461505805369408120910165774696201823445461561327e-345"),
           e_float("9.1212335558548112907041167865219900992212987328061419061363200658616316837623627079327915522193408402097927338844511566353089264332993665801557383974281430621663424555348948696093707623984018872721125014099929689484638300688630156939420414750789347188997523949007263257207382668024564127133925465354823169776936866561580967330016848493153986818732852077829078908487595083572953169874303197247980533573e-350"),
           e_float("4.1154150209422506231070484561660482051107771569475934556893289775510123164068324123715536369533515799540753687625965773700216153820395766509102564775758326790135509328449902389112891122314340989733111991383462246452520323120212254643267043856948402977846907232512639577617697136992804221081430920078913985782158571397033930781376537683422500563243728337072837278326060360847362435516199959073139513273e-354"),
           e_float("1.8569779257612492370285979453895266033908342227250720936380114756891764274438735982662994156714003870535082819458827964664318051938991958008211945416366481805856904524959763841770983988504595185558080501883851222455283141787712366421000797431419502922473341580622005052919546874194142828687145450929173798428967150501044825288985586304479512603613371342135671061789062225396311512987963220714682335287e-358"),
           e_float("8.3797697264337697567393507483996496278189231337867900799049730175156345823812658978773824843176616728877016674778138180360627280242880080102791819667709306850242940817480978440026441904975357718018414529172442431846120616552669472295956517749073924285531609787746182849542745695280623347190559749313887544531566450925013774274042347390790610286799636327143765040930013055476988817391576498974564169607e-363"),
           e_float("3.7817158748309938119748968821357836439393310967020468459283924848178733185105952186180235556942180291839686604460541774627271562888106706025058592165949216104565620965701149547310714012661210592963783723858280165209041038719333813411275442123112397254695741402055820908415186242944337515526110888215039269202334303002446928143564595455540748728609925706433493427484934744861146911243555278760513257147e-367"),
           e_float("1.7067756306540398616259899597158041556641695486499599335750467767223828872025711603112628339932683096006572823644325024959292250073547823604264687435158780639482619422506094916416913029884402727102388188084012077790267399671348283589822447826091672074530694405267177717265212757738771439982024323293828147623804080097918813695644426517081207715001761369882570746919644007692407627165557596010113718621e-371"),
           e_float("7.7036044720660424598248580790168792367481180626607786469556525130087471493227970901065659700109335305756222290928370051256880928804881509397784989942308634524138776418467071096560394792777858898529879552589677032146761336674394350516311365331750428854995188818155369690386286638941038967692604790319070822277735999180907506349123258510909996034374744550744561824933274891664748972330156402608339110799e-376"),
           e_float("3.4772893713559735338537251255572373098285949034691917015928000993756726280789286500773583298195814176971640605368640505625603319667201840268858868914462243065524133203508459729601253376976717796168639001327665501674723849149876318488426054144597441856777790743415920253811157607109198991505162758021612872193100343388129930208856561921411979748195986870479392460983081337632869009489763675105831034505e-380"),
           e_float("1.5696988255541547283559429310893526098448999942750913750420318504048648691381975078957476374665886644933286416319150507171327174425693438515000318971557528362307695123860598996694827331491024633239339178469238994632536672265056251204565994436933052002761464170147560092581714541830830329044659968002989873712039495285004702079377795637261536553005049032332790332183257829473228170768197995257311196956e-384"),
           e_float("7.0863048328392196712408800675065802967428703498061134299099020967741187369222516012468524919346969634085366025800699383133801399646384184812883077523613336202451590833923582174417637539636360063145075936349249642210748111334234152379217649563486169530879539329922715230525948267239172528060685294193644341019676584806719950519567273910741184340243620747455059250827363087577802480604107312742445999502e-389"),
           e_float("3.1992685702592914734151526652731438495491178857831180488936308701204403926925362860016471464309205730713883081186409210793005525203281338240602011758409464330791993406388787089748112480573064770581502099432129677136226358655771178179179575999184678190879995805710737127364101363971644307581442709326515481369693690418391198900505654080154596040277902585544075777676235101882246547778236222758729065679e-393"),
           e_float("1.4444693659555942381839620321229830140698954468522882833784017595240947188449247018443798415860050218993583257148083481406323099447327738953266247894711962011719763455729328221801808831741983497177290290046072926054046127738458379553691249597351920283068809366982689670809695247668894176798408098945382750178848346652330672684570403993665237331144036136139425505797252113348920393889940204257078225972e-397"),
           e_float("6.5221706068473228555730153682699506340545207638632856254593971766932922041334345233345531111195143915443930552771357671381240606764470091862297580275198431566688137829261861103096360057463012666514133119934496693545323212661772123710061923121191616919266185871242334599669088659677957773466931057336501041478915818064324815843132722406579823549227730352750081268674750401414165025952484997937711238685e-402"),
           e_float("2.9451104788434486705805302955522839621230215536010971755825472129365409949063302975949235709504726984785178378362294850467837176516018175811736678918614918199196249124451426651987545703911893997437208223987899478619247757101192579358068277428362015973121400706975075052160772264288319718469630320798037920844266911267733597466437749251187698723366324674786813206695856436927327351553535744886430094345e-406"),
           e_float("1.3299523968665905580138003540065683042636804964498811686238737299747432887296816239930315531991951614324236255711066130395400507369930255830376511063620823657874273945673964534642241879191628988968743264341562169203755471100334872454221080401442330653542890023328585611210832560506780058299160468518510092325925335833127227380566229823589009060916660100082919596582755873631084728239017338262478138829e-410"),
           e_float("6.0061357149658249557645991990087251110149728432935961253000402098495108561871644661957046405954870078208019931927496636412461623787997551655701797287576789074135211157977045761778798797848470270841344330319353108680024618771188026725516201525144613438267890301760567648039011790901961787679260875945314284095314149253165814596305903394792516890599157473039220834610960512146137229423864622827325020643e-415"),
           e_float("2.7125528710248859815955330954043370371883196822167570445770052693787671653926183167621494563235941640104818404932594497455685196399067158286148823041735030109281907661633058611537232822526765283922353000570992414931355603200974214402059499306240212271559721889823437411107770204932887215770274166718835739432514151702826142673774168410718792892344270811412147318067200357341585382051544606976874211838e-419"),
           e_float("1.2251374359377779359490974951648691021053767814073746815497007301282316300084840110017514940299884295195799485192211043289279062593219868847917107457665085989731336211229230040354931491522993970283640466638131590961889167387228240017070632086847428996372711125624190258819731035237499626604396899379178977702684678323083616975847730541636050345422765563259851819366848203057227939841274968077781282539e-423"),
           e_float("5.5336852738385384921679785978157169246961368170038916428003823689041143412167172698438973993984625826252418399345633549044646910068483809977852224661034518095634467026024254226253189958046555732648628825782752366123698326501322631578850297170585330797576801705069129733303041044917859741600310586354706259373341422430704300415614648501499104914300797464252691710424831637853750892981134019940101380992e-428"),
           e_float("2.4995779104921583643010160417759444321685455616810548040547802469132777736929679978580815171308225959543629670806575816069822003345788456855312134665073495532941064028548442087940475037990491416747816199285853024594609031726447258314752313043651665851598316524830652080921163917298726403479760968508901003974727834731261211596570826914759581660054103509328038930127467393878275008462748732581101909129e-432"),
           e_float("1.1291224062467866012050785744288505419010907730319654963603010095995771165678686969799553204811978932991770720461677539350664118805856946791444785065376428858024014713629867281999066260859089971818086308199961399506374283617746327834593161874001599693254082480493791684817551543262670200426902043739447229527086207254929474716618983842895851136019606079950697448149587730030484377885733490882646143164e-436"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00483_bessel_kv_at_v_1_3(const bool b_write_output)
    {
      return TestCase_case_00483_bessel_kv_at_v_1_3().execute(b_write_output);
    }
  }
}
