
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00454_bessel_yn : public TestCaseReal
    {
    public:
      TestCase_case_00454_bessel_yn() { }
      virtual ~TestCase_case_00454_bessel_yn() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00454_bessel_yn");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        static const e_float pi_over_ten = ef::pi() / 10;
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_y(500 - (5 * k), pi_over_ten + (5 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-6.7666173435343143662393744305730138016673815650303201250123406163683335086647270768345883453362697179263356554581955737856081897196113129254891754533995137471428207024118579685763299566324998867424553735321889753116812900563909979193256013891844851834678969767455313914267389464310629973019263760332897097072851665288700600106573895618441595234327471198734557796015214094878260254431875149322386250384e1532"),
           e_float("-2.160031198964156971939203110092569143132061965396159339812868160374127204332218504459834697964182272678650707670343089311097339154445292012836833522593152306071685439925307507832683261017500621435005414675238866065821052078655807159154020684945682029113077213858464708975804785797551762818914091547025703477693984660819570312017332803145082313065618767111738265218057255164505264010389381189826428891e907"),
           e_float("-7.8422383487170126809324239066874327385679244175306538664299178602179506380190213741840556777803083275544829711643487818954098944881920806540051374683695641597432850207555112443123726625366349614247228640757233931830167451559242843919657518168238829213514934085721150316440342993486660965289236313578448033394942428912642355873023076686670626349600075740358261779216359493877766387693057522153352204369e754"),
           e_float("-6.209335672781970808895796464144643112824251443101485780179373019635843415486248495583550542113435198007548234501320175319971387168882073291526722639176525027541530740098871137372619044503509525923836116649859635894677004037383681385056705677821660133381036876270321705703006192339107392173393828732067119689442190851490429105185385088800326976923377501861133034602906203444601643964610663821191983724e661"),
           e_float("-8.7165509246635119492265924873367864427318325184180315325449398306981243055070941426270943372795585237411497194153010791609911084538663063878933272018184604056738730165391440294854566093649783991313943251572501688018369929856640010535423715170571835244578777485578312312330895840383671047055751189339352347031036878178366583666221348992990103455761233816815994538558620269533801551160075843494859555743e593"),
           e_float("-1.744501057657436453931649273219127363303889094831570702564628374883742517390243538962021357782690792062017783453310347646842482973696395883660593813949393339539282516709277883281111746062549852552317619168451603542540198174473825812108088345030349313855733051753481613869679974652745056446262618167872107438053528179812482020584909454550655179167383958494105331242487994693407440230582411349349295861e540"),
           e_float("-4.5404920839745915796340359862137717021187160962059886153926984281599782760051125315536718032379090434014664287459288844381759324041569673582342223655893418585684966356757880662911939676823312895525730641653413223145664471706303501146865000660858045936218772842980635305169230155242043344381413838671505007444230706101897275150143357276259119564198356651431322454100204515561165186343809408668835107628e495"),
           e_float("-2.8955296944604868722809423689284998179199827243950833521392855167193568612042839267029644241593683598695480650163921567468864135425270635343622837440086472051660165029258499705236180326123875059560407674208173921555015314143966984524564096969685231289934710779249945209791232183924519845999403104743872949488732026619701315052747847128269869694094045292698078721112177542366359321712676456973040166188e457"),
           e_float("-1.0277568162333338724307343849897697465647799828197308046658603897813332919515818284352718743623325048175804041084839699930391176006014077670080365755222928541096813481268815287703330400546013086661458597144250751420131444729414127031016234320894479577956922152196895646794040002811389530698213690410165101064987055237866801459779898890000821020722395337053854484320240324040846529677106104093562705469e424"),
           e_float("-1.7302082669667363750082112740154281656553259618720714089499148480044757758602007798748558489300915811640673665233386283213364585022036729531843335219735751545766291645692893347318543585793760559006790414942714487057798097544285917570761521229951549658337633203161200829376010993367914765157004767879438199588662497268912789545621369888058309535441722210554210162025899960881623658036786035332804343486e394"),
           e_float("-2.5383144209143625385373539221353524524574182973470591138031260169145936268349062176609171567911390272579692792873363044652570282715934990674516019122976979257673280343178677408944284826897539314615408198408405287287144721392997101427429961548395651126318536488369655992562714425670798151148205855977109396299606736787758653174908544007403094495660266690202819380463862712173985218016449228983470220113e367"),
           e_float("-9.6126998166757483999072063107262979322879999046543350007683795700886930264522714903072743972676986064694830788265922457117502673941094763143354064100009018101648552410879689523949354976370680351902838978632066019654697265793444000422300095192957267684787349588738677084604139594192448916731985044593780401151689833823674780307111765957958658697809969444109143584795151939671507538512325969638190142964e342"),
           e_float("-3.805920747453478578051571920428119373742455617625176989901071608489019937745894625893973575264156007947382554004150563580743975093671409994707593711092148445867740255141045402853786035032822877464429741828973558668068629433390367878672988392869564409826953359174722965751967871891193501519738709910531578665366536709867641897203915694326823822928948310625445038088296487460811298650762346223287223985e320"),
           e_float("-7.899881672903333855807758313845106836008934402664531926127670248102727513258029455341891722019857955226962530735485647229748650106101885839258478878637440387583967761048664052994782310547737456474464794559125167970993852132781889561467750203105857575880554654706319345367697720586442360023001193071355837739366795115637499643708696080082383325311240713355826966341293577076418552650696083425692615231e299"),
           e_float("-5.0132843250549106949942091160206577345935710214296948702124452278082077997293566586726832566745980825802898906309004645691422697239345584462198742647789697355842461317865517173160521342529125140803319518074677454496276184600496078312790951288746824111947700593069712731421022815308368718605508630589306575658269207231939714206447214705439528122063238751287782762444481425056466069681421872207343200588e280"),
           e_float("-6.3305217966932897797616876584018595915874134711108460561902072060346926462360160641465992748799398209548659420879319345044222781678552832664857762114917486869732107777409089793789435527186173885790393434278112255718910900554417013397354842079885125535446725992219552981202173901168696550102100645273265188002234458174573667402059301013092568020962424541925271010178068624865852982601020131717234765207e262"),
           e_float("-1.1235064525858025213061607467367767122793184149889656510102873469024080205409427914648400844710439898273424774111913698240281491368534006980498268558513474473799673330376036671274982461764253576684372386236170867514098427349499765565778605005037865228793076821174202899145965988331082819382369734706532601912601575548434957261426492643083640591578840912198053219820794951836720022299209600484089404351e246"),
           e_float("-2.1065347073644996738886657159626787820220234542582937676481314839031064480936564203676852021792561495749350203123598795558674398370934233293410159528725166938188396021417928844261398849359093053539836967029617691476529098134736877855982097957216114667813332875042126460096260538508754017241495641453417631022901538174351519867528839439120812372167225356526316943430688560269614520598108592216112712364e230"),
           e_float("-3.2915966523818079817160947531751732638875182912592905771791831224895485949607245043523442103191229221852780500766002753031372522878357373562531187710495513173336620543546270666979285734078799937227989639885947613410370183009894865568968586135526653959993506042914490089208745628873343515437497900852085566301230449974984108844603650259663424578064623988227751610617522082126236597999371079561125676623e215"),
           e_float("-3.5121667513228797490995137240104081431810011500302950429150384939096724431301356324396310697332661287572924895678896794821174352126585097969951214832879569327188925435337379429374367825738661608750253954047312489885488750204748139723645377508201999680264178067932940876321244064326634920500254317815061518716363781686090870251027267507315383577772975072379574730280743605443624017136436088306686294696e201"),
           e_float("-2.1614163902973844343208404164993264200239575493342564036867760935582552216489630903582482484005382360687904031732466850735187983968474419689174840326818824736348171653605731353813967236834973759857496967458419690636949403503838271016405408437848354042815321029253551743276134362627868133499933211222523604999623151419607273865067294539835720214612207669105766348416078805250193229162374981918010561703e188"),
           e_float("-6.640862726597235255913318919838192008598907674981584516883247530588490381676203671352506142455810576223613807190723653969897713085338452636499510385614388523382167957571847097113919030225207289472777560217152655907760780615101795757948451112321216727595554083199605262655570842378781671495132004872259640893657739369115867052057739017231361628041030502394655360601740892909553804246584925182639263346e175"),
           e_float("-8.9968647671266787846280575285205882230998316628417310691241136893108337345372383317926322139127968040516326553997183888961189374776851181235265454497647938271582248558219370237135047501513172972479626601139867324294815369739744367594310493656765599236929117750646132599162882723260049210694441262318374880058347836849459069871895536336336412338931022059448638631829767297130823859706672851914390961595e163"),
           e_float("-4.8263652843548160321488133964910415627960541931038093440812153569845300024372370466389248568118821104167662749461150300173007495974160181731856911684248789031937585241501531554590863482492055233076151375875138289909634407995184239998939961201475558846223498667794217945659552034996748311967366173107515161764333905434739820883828495278416779229308430864986909874707100323728116578516540188200001587071e152"),
           e_float("-9.3353459613409133591198064214582058860783740403114695291444126159044525789979897279322891320368290512910799189521017228498041972560866827161291665007651500444587502148219918227559806790824387799756987531055561164314283275789227645812205628744468218178246788556914618036697575906519122320509916515698260483542266545768663979962547418940842520710694695900357968255676740765854776071448371594017373131049e141"),
           e_float("-5.9983774859112000167292173900319086055054686631528308863712224740013234450830844293399711574540922951616651472649592684892241921981842021048709104752717553506843257114739197786899207654004901666700229037986157836187950745534739542600634370002419793495923287230877224120439193150060693789857012840619910744976152376532462847580730476138616478278563012747876430804309483827642774330434434197498614121306e131"),
           e_float("-1.1914536640662831054231911821731358713841424863253603829973796957802763803670191292199413025637196946173841554803441909165938604808462603466824132758086871028657242707198717250933657213317034320937561667238071844104219774731563905752155581288153412719036177270953577449147772123153776976767395397768134367151209005815462174085014134043163363179667471767480530203300574146816294495546769037527138062571e122"),
           e_float("-6.8664009299773236496417766772444531394863284479735965360852315347713193717953004146638235338382384844974433741664787524723415961015664277256539065839266257042711694013495150269428417484652246436268978611032649832728738145615513787992790636291829891531643806628425356004068513583618104004375632252843300613599095250207893912983872895933153390243663691474553119161997537383336410910438617954397779195232e112"),
           e_float("-1.0856288645485228654975600556439972640756680549894204894971303080583728368260572945174025118057479441926931865640071866442257102005198276980054743651578301798372073886898236265682887686832290002958975535868005587161498747810533062875213405877270548253876236635526796514827374815949010309171541139757482615560372769673378845839408130692620065023583103143313088839533508359050885302316067861381202105357e104"),
           e_float("-4.4816784089109975196757622144188418589989134745275853001700215826644140221002800103124299264011030455035784920149061417876650807547079599637579513167010155985986693509360944282980361350296176866633707631034615746213705882388325721526702278510282414883137684883055396156456476373679840798557915037709237283850867665101931603252083950891715656141916861792054636833708380595060484269356538566557759917454e95"),
           e_float("-4.6237609061682788121121076714419913741417787222059835899395586536354277915584469013667722078520197819569893011179940018393287801817169049411961382763991876630200230823601329004239252106411958526598858589209937875085860001508266777634616901502151601785610311401741820826611951598424295071063870669072343381970976568990475426322599298062611960429408058996049859947138003960634551862207281887441360091474e87"),
           e_float("-1.1469431945195062423086324108875190759931097151382270075216169980506975288455346472914524729915913914925867396025012078332036043781295922656881162518906436023707353240036443087848891379236647283058568383444544605009576210768280981816186854262421229412088520883017989234775297656615957370973459367060200895227262029177317599844560821299979286864174014865711174029857560386759762309796476719840411996858e80"),
           e_float("-6.6109288991348754162409730933649285003463806599104142118113594983915943680210417535592507338862578512270923589376887827568116287843350976911359184937638175660181070754127913389458868401602995754463948980830940706634201470801287429810449682482891706228958722615954498964713468397311579977430753393404349311357242928060292588817754081115622698066334831360352322665523268195772269531925061441679075441058e72"),
           e_float("-8.5930193823356911366108764277355887493411440312848890324333110686554411855138341522283720684644664490341358041165754735200044587820657355844780822049674180615450462421018716614918172847472275118071756421908982240425698064588621995636998074023840231906889686540384633019243720388911108202229797122581098504310325941281447110844313869290710359698507943944476051779462034246952035962334125684378117063614e65"),
           e_float("-2.4538384591740187476595955729562407835691317516165534476685702312310772989282729511440826882682747899273729321758246826527298946092194118233674225141938945250381739369561408138004737275625057667680441068419516637859557283008038509518472910115594631351165486686319641694015051783374559379969204800072319568125564416802188580495861023056469857062163884104137252863690329028667426999741604226413304434797e59"),
           e_float("-1.5051379792842686522196933454852319286384992912691451758678243222544083759912772642239563129909682221446775027410940189937455382308441347109541090432774507637156075852798438801582652450439623309506824015189157790500854712584964261593508964413652770188489211144281320942670417065733610603156134777848496610575619297624797911394120876737214743663690279550478196852240682139600554445590804740238429568106e53"),
           e_float("-1.9455221008326329785570507838075680741739878397448632785775923146750551886070533821731904450762934858017880297870645302296299507519208942569236380912344464274695634280941162396379433358739899672294136055967347252434812678090626682100063445971722870909040283810095740784054341666891972584804102370577551279062307126271282184039259771683459552980420989958683823171539808718617431748131580488345724177806e47"),
           e_float("-5.2164059715006031079256307276307497557829397980034538680943842020453023446089977312953027354191068010711512220094867711268218661407741320743796014187145437626068161187952351692686113925014641870433802859899619404393064035280674930734408146970755070368840364237063513834196424437215325015826316887931123277259718016345898945364381597573276547227467357343154393498157527672921068274735756330510026851704e41"),
           e_float("-2.8653063244522090468026387534497513573415719902746728020251137224868017898432072958364659436599131535140807152242453946190265316546475119822766777180171296010238761966862930046945731732094357899415432602179781884258194604383066572729934288960951806255921231921509189932126416595392268668970333458264170297798467611001573382030836185114467672679166973019847289136301325204381209546884918048196232898432e36"),
           e_float("-3.1952612461966369891755160300584241364317224828239164672650360803899646547769449883174736484197851467885893262284749347739491487554126854968326111576881180564387231724532100874533189940476619696282897385998327063663157732193633143232807655977165566071590343849878193973991117929919227643215209661635711375745462462706983216782200936361937267504927760105161542224446506468577686631399765735723384771734e31"),
           e_float("-7.194853319736302409616676874954136928458100861775238021180986768620253404620029067577185145798146777799587826426973348563327208057217953534130177266669486803881708326354918425265135700698417034154100965742329925839854750969107535686683805723556478386183787106374762546926426173003358134891392294366702023581664385068932885018448284930300321030902686956416338552560076531809439945340324702821389823455e26"),
           e_float("-3.266611854292398159822252044915802714854447473062569821944826601678359846190036406256383600033357152668787907917044780486735480641149613971607209832547416359133358056614836802407785768468768970798887994855960425786566781907244666221917480139391675994251692901359799086247675616249011429185592423393791242172961361508380555462513903159272832550988841068352515807824538855721720885541899427169380495363e22"),
           e_float("-2.9999254519350142296627186558918796557056227513856623739625448298033911206537675289345041823492010031391760351024930333010941313350725330786256856666874361756818783022068436124247627566304948043064510849755412362111315388181664619828249224648971005309082960740872609766460326688026335430331500709579708850912121964125388002740125780227058471938474636391187758480839805939913292030044248353376996911304e18"),
           e_float("-5.6215002570165961406823533255636760312283094128890745720191033387133148494609576317560613986845651529740436505562778506781294839332298762310780156817653009238490720729308730527322556167287642742995015312731985295410259836916636653119214304494627988528545122455989783939131165199327974900547140166822429633116993457705497470307886931740680375550058344176086094778384624304546534323872725685435986217605e14"),
           e_float("-2.1837271719897694830906277669778799376857296199816680134479540558912247788400559493592732777633439033880450800588570387616005268389797287731379118869672241392810476316947404313849327468456799207389062606831418772213181068688490320105290590878342977726679022540769543103325115123383282974942489996507975989906091026732317389232931149608550083661135718239265363108382672929479726080460727525223225135755e11"),
           e_float("-1.8039700178147502385913311183670481835687733115771670680219045087472769745310641224091361285911926591627040450251577573817488436190656063403722595268427157358171255223869096694713419866226945221530613445332912772954519644834126168917251530740907815214497799637064404001922800398090208334685382726598052902437134085668887911436308206459774053942855122161146971307388600685936517678226593332756515093797e8"),
           e_float("-329793.202018957802338550822301636329100131752376733234522028003342770871108061175167692761020222302322701210717471725659208513803082191789547203839468415315785724518952969450903799253427250055602941904906992955045682687986177972788406871251360861792560816043928089469747393293597087357361550944619151382106508456506332070938731316889512392313707067986977224882300238824458517688805247447629269201471"),
           e_float("-1421.6522222387260595164103569908416419341225012964868530667671684894714919051238353166739124794029370942597975973566590485406912454669141451175937521217440945220505119527888918864056875119444491989752964192912360985799473613607580276550230880838780236149518057940599600409905548099688510809463492228544882876193914779605758016788113563870549415461067925376612683838421105592458799787252172592153189936"),
           e_float("-16.131765932989025448389472543286016247304776719185178821898542700532301498556419876881769527355114516129545840373968183562832606395964258598854255181946402531111957614575824714795830915845073785480947369176674749098194928835015792607323371392880685554056829396158468573681305981366696880765104124382256060010493861113578481549935231539486582309499874514084233785927365706398520247343298876886925966931"),
           e_float("-0.61853814439530667931023157124703536746454434526218293593154122814560619287142512215734712189628970918766284843479919647583038741154902395068178711182437078666979209791489068066961285797605201690110262579534853877323835928657829137420183208116666299324601365483984692010029961075618033096106472571254900628649815717722373925033489745120181645332164179673030487924619766938307817210545583604529714381325"),
           e_float("-0.11732066834928953668214994104234074560516276616768725926735765378789677450440618500601611430589505996570791270324518947868989121218784651135329025223096022657160569794047210084432432458460796883914004345818966371842105346830223891143859706939177030746342722976874106744919579458312240466025396316875699699667276972449420070571609002331956535017664161665294914314531686653572995347293640424963743940956"),
           e_float("0.0849605472882699956270716960782466502142661939063953165874671223015416186272119626643212374498401087855686515380032332384151947466213897848889164550355738544309204115121768459168281591690856948410590855212925636702140195537012100085206799830229046196708388727593310503929708370474721571780107602411317914411908801678474759496366948287131336168511997355894659372393101767786595757491075419885719534832"),
           e_float("-0.07860744864398485302850781693395251027819473447021365011723538091439586294111594871604778600719469428421961571094519507209694662483923002804052052632368590889627688687816325076672048261994548332291756265073405372803985302587155139617505087726251092910927334274181111055436091082032043724856760642777097327236774334429171583273285294959073944408479709965492720994953837018642285939425916948944188042317"),
           e_float("0.034476904460320672070331572891833987641164212843421238124109096585652375678528209682242750485875329122141669757567255615195936943283593109730474319812918974029568212972695749497103624718758571411555863272365132529991377003710783178751028547901757880505607005696491416021233464342263517611574684300688243821118966366630386755075325602202386652992953987845075268426429293496857943224848444797812154085495"),
           e_float("0.066316194024613936744624968755158647417671142787947892655923190230456800791887482468188362321888447232781470737359965070939778578838824389907872784931494691424470152910087598584811563682044300328232154978952273137480766101649657445290495942915199074177784593608190308308359153819424482850500173422628511326908123044950560155462231442146971739713868466178832655282771863853508026479341240622775844491384"),
           e_float("0.046804982600472473555098220531731372562546940221504128115650473985677966890230588108263831666745772775199623644897629103727170293666578453675807144261013300450925550054541665247937531724014730469901389919310581841969465003551120923578706452581722741588184374166432544570395527588351626945811302974932508982262380335045882449606796233136969001665742537200089576931250079815480728311013456065291711227986"),
           e_float("0.041289963770192095444775280850577997260686064559662539681155090534209916468411699574954866759634448355563633804228764408712578793230575955451572661403066172549061238374379313550010038614155244530207354398794360666555155033461213966625154743963232137913559087849989995380546537480436424711849903931217230222155382667617802406780599019459029748153855904084991384860979851332229756661431603775288031113414"),
           e_float("0.052664227535193589425413399104813036840965317684839965886343479520879868364333388836790768092154699563446091493463370284352769274925135130660144696030068587935043872927405689415568243782267785674006231064574554563217192627816943534133596862597989795015178313466101979401808321759224623602428364522310284709594721454797184050021888696876422213611991879870734386589002341026374785933321410936971530805152"),
           e_float("0.052994013771688125932864529439682755987812836647772124267964249463054856943350006459914637559449425100511469449664195673801142155232164038629631899975428953149999928821572645900639573758467343236978549961356039183137666722271182977394413751819272851925437455402468593525139095746660500321148405801038754212471714119519938722792100870704032319686432706897012136861246848394267455943919395973767294992619"),
           e_float("0.0035032469208932147834465417388111875495611890483456221967119403337336175152291356189377635052836173293911727576057813498713974328207541988655577665037473733193072715920701566293256715561942235578024208219052244393348920576209967666075571643794550047637224548614152003601220458053298057783147095151569133559065122341707327850844952878091335379436771055562413548917528475568035621951512499345897027593745"),
           e_float("-0.052805692549840720031216814258228424376696776358081822891105282642851263086811904716944584393242120338804908745732277374353417180445388505143687047136339965739672300788092736155361400188227975967280628850068500686566828148273837862192288650050845866511047886626471256981289213425351595626712052649724372643317372868324455320340681896868498994357851842433732678927964040035622895130348584521761747472207"),
           e_float("0.0051744021354597246120506809719512892400901961985855682551232482382622364968535295932561634392350710461246848961994191074393880851962962912379953818468614026614331090837223146225746828274652234181598478668052363616807095871119443901802806808473410811591784682332210464031916571995716276695542220254293707183670783283596510319411751927738995913906850417994413605578184418861396552338823470041761291684363"),
           e_float("0.041387946772269183234524899903939215589123869138098787520564298951041238142756847700135258779245072439126926643761557859706830616289393376530935242675953117682129237142717483227990383733239171701000163821695356104654232496899204536044238426889881317876187965837949804130979025391003621008511281882873742741753890682060583610145038498485439240165277402009664229330892223432611403908237209320951572953755"),
           e_float("-0.049289593733060194587813382618269302682307603237574269089356886820683771279559445765113677015856706610441272795391377967496879336213257138732209999502193716077874732290492968991233967289174918325558394502815225118405841089486419410854676420632787267357824052477701354695718735428877772344314455253242872576871290343360753477987167805960708946631640547396947913423069556973036526581741063052818962246447"),
           e_float("0.037589353696455052701590777820374983794583833018377572440168800624979502186590980444181478337578518888532369660969036786222001803182562798421349033824062772641297587590360379758996622913394498889152107375017633852068199326602826976788717937623687486087603023209164273100260316298331644934624328809518106746811305096618269749949641356878178855738585972287737631301154314458283642630096604668232754698091"),
           e_float("-0.025917616407618148794167053235813336028433606125674515355962075773739813930110225890998594937497401746974858018606099269271660535994015283792407535411241842477915069448474152723873608360030878723405927712088632484398591752370453562132640402798240263534684931409895577688151107949219091715790483062499946963751587509032028250538654720026976726195690088117682717927749695484232588935599828441345978648822"),
           e_float("0.021798820345640625936080425954465842745504111474963253877508285433967168050948959874700500488851285187902854469830659943450575796117012114166363673909920179271989604898690917223539847114768423263779120450998587582566101423119268692394930476985849473526718788341574469637190692357315788519169243901599661709101346213867516157098444298248426772509578819609506892678609971077771334810258682508041155461368"),
           e_float("-0.025987282041292595520252106954416406447428837143146375454258282757915948712753805337896553744824902886274426427553010074445499502645806213143289482695604094423316617686817295766072727380482841286762978745101825811690862886461809137526497094914677300002791262449890564841770819194543837528624032205370044624667352383816330591787339498692181658519437999906064585452548278429868584513622969555783264565402"),
           e_float("0.035870006941329329898545100363598954459879341091576766414682602091630583897362476127359902119786195730817364472199256826730076767656378919488916412261178478329709612114300194180458556382124238153686594050243630604697064449768660541274349136396796482079174914700096430969943119353567521499242024713785821080296797006502214382688623554352800911567312540381268966342138203792041044580008306904798737955961"),
           e_float("-0.044565821860345133673258152484051086159608025799643864423262360210768893851023272058936924886558295099108628862161371630145424903700965435964674515089311564065749777707187705782599994762043979560121678726905765434654254338132476761488349683935517512276460217190498513737709044387579370304794981782900990867717557536347561656347158489294511883111558135330604069965673339407250151490062794876792426947207"),
           e_float("0.040205143418690777619293038237145778017454767853233432998968783055243659165903450314330157512950454883889758366609952616551304831128080791625452556144398678470132691552425589808050941782885139732933404833987893463727715259102275622887793639351354228443599316501097555038443506535620024413209163606379143323896899853095411850232554770624571650864935156791884026285497596390422962799117654193122116649948"),
           e_float("-0.012988548379713810145364236060669213986638629961060333816309832178003315002368400385182039619033149107371395178422593766834469914792967114669661955522903250257371083566585559587662521918610774009449275551600261845932852778068989394421788954903845056177667452753538456713342058701084642784853801370412155925889453523767252171470654348821712007129103890085086175057403727363383732292306145246932664218752"),
           e_float("-0.02718165877304627125934370884346843264471615355689139193387607453039696417834702989039911216630756844929370466953068257031118735082377411659691037289956092960799522640949072026000895040965647676087837301876000439805420607094273794287859180536053990342057385843657016158433117706221134110023643747438299621238387541049853684482977323209023192359360124813682983095041317599720704687204337793514037993685"),
           e_float("0.042342351491999434537581970097254208931914773582425991662496141456831076885161084859378704929711196918287212138014559818275147192515519621019290908104355137220449918065714722102632751981530502499930148293390837157469750301577355721797046968550404516930633416815250653774088751208912375330542930134939470598583786347262504163562405655209414228018863639909500369714334341526710794553529084671312934794334"),
           e_float("-0.0046520483641945888683883331311711761912447501613786111216762357674407788407798656418894286660423360257361531572855463539215567158376648411395042661272488388603029634991626054479753854180402643399294524554502615898163967494798497864924365748299395339369587932028006157351041970853775031111676770403613647061198006351975672285519843363725140821070616122355513794379920197329605383673251074275843159900512"),
           e_float("-0.040553344105914322433233519348943462606398478403391601460007719443749755115157444892065695717143992973649501408622664792511848625554798084098701725926072512547167099026873061262010782165736235843187879375476288747371577407915825234048449414825137066736968958213584526936417116939622751948877037156953970003633214149714981836367488621486934647073128168039387390843849955488593024639665506797720897499017"),
           e_float("0.0148043429290488782443342030725197089175875487083879833805846436471562141320624411109439751727330125567278394932552115080787173399235395707600197222182608541263751771954750793420383759046211963834951868518553280718782057746456847600992654838454384781207089537069415012726449250767815146870332523418388624252577393738924501297565565803104722926272878226129898574373759279704813758094721067664936085944"),
           e_float("0.039708267800067027396638021772699115366403822596225154066931997810535609356092824593733220903327332325594559395753082479175664384172288218337137481529860729252188447980845009440380613885598797589221076366219486711816520252983632136456974007501856913635484656178775716971968275798024212461775691435823940728589828260555934611295082535215952011943859175915580373797232822075767295159667256752928982440723"),
           e_float("-0.0054107128369128635377221251096545617146795514355117836690455520282162544583086370954033259654762386726530638426972679681324297074410633904847661200273595877287819858903754165270132363559211954812373167519766093705994748834487645448261787018708047391590892474439157923735668982735299751191046950352703496925526037214599527120228226683579230609470570103248386935048959253101748501756313066749075883406735"),
           e_float("-0.040413432648689469438202024965786505434812278209928248480250504918341179609688081656922681400289288064725597736155038275146633353821582872546942703195996508670246102124960184232504572572150784684534901297671484424525822882222156024864308470437248036675307142844277085905206872589682926058511422208822320344392278660991275385121730190440962447633425020313337051889178583513115901436348866284540558708372"),
           e_float("-0.020702224391315423907450415629717176748324378170271521406067969252777429745476536491817291764531229704117557174147215779585699700888075884045978953416833820782058137249216397821385837336261300640630889285583603423077685295563614882400061568622323901966053693425658231807430860852302375522349368491063609346227293933180423986561029527006009859333950285658628558211156952641229255098685021991915505349659"),
           e_float("0.020922074755421578440158667406409840288669279273934063794031746860973344929574356249193696259415865594664023988992273143250770132255703309879624712127518950181396459610512812400406603811270091962204256599919626121065383651627746732823602380642762527150420733027648899967047575191032784912129264525717955193067382748175751181925359163394860784142978863393307628385169150291678450124274045904271718460792"),
           e_float("0.039851676208062148347192046306834091427799052486965839252344655545068209111008866775798690663086836192854325334284451981524548701338351912695657984982680920859388101213285065840372100841813995423627375898706750266149690148824892673041370793346005461907821004765663003507501181967492150063176762010518535101322716490149311002373725256668172707754676759547339467006488615974029726218994194183338487791293"),
           e_float("0.025890974065942709348629082852936291847197280004927602445498309150461587170774431984222120656648234896143018119914237507959798315976736125220121804038845829875032860709553670925718739400863804690065439446412901193999582343613877089998532997019309301795538031102946768445064688261654600397743715274072399114261936301700320775610486517046173052368093579377738697565101415389557714293548614255784276853269"),
           e_float("-0.0035917777623654492858864033582342459258234218517123657690189860671141057522365305612948860864202029745769838773553096719351602855485454004943089173264521810337546857321874306283268347388953391054142659238725587435279692616754640582203246489657658493446464364186391179959574209390264426064502177122643194792583138174561210154910870268413247862975915882750867787035093259073279163541631048962650101229757"),
           e_float("-0.028257034526195352643419392812791737351974087495569973924272143679503873655192938592807222821742680042530978893035157999678588866065919773513717988435640049871105965146707447740556708610557013035563028683193097330779073533888754419649659908649267253035741347935358317663677172486128954576951076724892157104875921129503270400724573512002594556904823244891054174299611045343903239818567685584379468082839"),
           e_float("-0.038424582153330876622723770864553960759975382066260320767579596528701801353787644681581519580364355095744978935513724397241076174593134722567806271073940557977694027739192700314170070439774522405597729683873557900592515576514881143810170441378163410798391835459742518818734831540662646006492393920308310211195758626038429401380447344473946447126546546686833586586626401670483110302168272576754822717329"),
           e_float("-0.03491491654156707078740123453905108631221140635725520860838113417691972354989796713590105967443014845915743378127507999689897277948911993499340956682137628107799023937625316391690456504556324058088813433443162041528845000583658281492339325123267748736224255765626867319997256606624487947112212405468196719896221573383659626839588159519823853355358630355249088502519853409918567825129307001580944031132"),
           e_float("-0.02336992794075283616519355303140584820120884505142469920133717003473534012085103522472673166558018434927868171384876681054645176878732195704642366143022818357148981013241561445474413538098405601574040366065082724432284340790112957007423621628623018350452395027925597392110359602182296357943724103109272462454749779226976962199136680846087916329672693750958250672782055057467975504905709180181110981873"),
           e_float("-0.0094761635955658295512685609428063515126073484206930884035700415830335373606603536037416540536275731467802125090894077801248425089249776248383263473266731581255667208414647108489895571426493574599818465251624248255808727397404448349638528825951427427827927176494019659664886939365374534145144037934473414370951511491687944898464247198256946280292446431448103447348371612946169377546482497386965423148601"),
           e_float("0.0030954295526206681421836399155707447966491776814492312594088006372640439856262837361508725732572619562463708816428811736069291462648749972127297161042222198589744565196743883272651008284180451182390179028847367634183379669959790009116116402194627985036045429176784882178693549062021664720567476451250468054890752842037003912287898133810176431692417901773303543890844724984953855540826569727825726992044"),
           e_float("0.01277213061282955181240503391257638940390116284670464384816973323253931013620593618715871551769474661858551985758274492928297117759945159277244811744838923874757234379949854786467139152355231616279209789951976279507587732498847214209240108584134628667626376832042331562973181766828514868357484288125308161332557912192291356161352691138336798525438378917659497557386832864931022376536327337296288484373"),
           e_float("0.019366748768199456788865826894951023087732243786310018557701522640967371998748212709116739223063471020298753955465797922555839035440418135137210518731809328436071696281581285727489933916465944020986795307507114150651257256836000522274167534987348065296535695863898347792422085278818550885273858401413994760855844824047452691022901552976279361719546086567405468890374954268940832544525874975919954164927"),
           e_float("0.023322315179616794630459867711426076992789457155957334111969464255036354419127068553399996100272124088337343471458803015564250744543134059705748559422244011870061264483236186895914362558700715334759670845447891970431428175769420555541597698544882505104446140946985072592032691990632167821230689960040406543968728333599532156040620086080902749628535595506841670267795449591085900799920940121067303976686"),
           e_float("0.025192059468098623876125946919717346938446028548825159306660069887281927207505751068718541576082055133361902496502068410269012566663802446218014069399751293802979307387457530702593696792675002719942236732069541197039736551837152172175520906302405073446462976497335608033414643815936692585452848864679572999800720226994006461624749843739393308213671443176496921258089150019149161768657537882970331412748"),
           e_float("0.025367299223104285485073298305652893713390209585078473036690262568928146053777334520929360438436341298187348976194699866477514090904014256973515724250312538979760392244094708172920060352408200994666987327654858892913542883141395319998789646710293762207015961044689522953182786530268337636314263396185918744910555925831226974975390473304910034388747740220072738833740440527912673910236370941968834173298"),
           e_float("0.023981191926703436831869769611494658790841991114962507221338162005886913636601930812732787503641857638089039983093445875058633899496217699899812135119284089711449352898056479423865621097053344699039132533305205811513716280750120151122131819079419814168146687837671667159162706079489063898465616911689047588930256857712349132683280397273036229145872793896487542004424272978742514984382100605600612659541"),
           e_float("0.020923209500927502521128982990831898099169341353945754546806737439595275636356385183287149396431301808638751143795516285617339735551351842729014610095085580613109610999185952972290179948450295228090386763346704526098467576335532131747958032635834700819754650232426445672634483747398881369113389024949731345160602505719936183419426452745368309300154363480866344219339608227891688606524637334491227404349"),
           e_float("0.015932916964375270290859012376523998966832907140329132848843089715748254990206558146637191783782842101252703480599094244296042824035174750239082617432364508025870388802122454114788349932810967702711658602154020048732727546376707095820755568172239076956206970311541290000225563209634180814200443226545217513847545406925656054345205513910079111925414004391525106996984825771000952628788746578277652335218"),
           e_float("0.0087690099209841803347601173186511866655976495782938317761914589758880829046232229300079030883845424009053631401390144371964994651817900170907202469651276881820112886942313795769011465448374466740937894771621555958207315422438876899211461945013034052234722073170934342394397329156130519835770478263689403795950326938031471717603571233569636622771410328729749783402720527996051780930265319897092188222613"),
           e_float("-0.00054501218917433058334423928353406497357284459035958584624283105696269649608976296057968300563065528495121148794867195975586385184093547481924595109004983356260572041211297005185788422000759817398938996677345536092428583509558305592409679552462654200436584278287237048035273579790527774673833641197930963989076111289655107315509042446706825278432137206324455750696035418952187790999973764301975891934333"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00454_bessel_yn(const bool b_write_output)
    {
      return TestCase_case_00454_bessel_yn().execute(b_write_output);
    }
  }
}
