
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00101_sin : public TestCaseReal
    {
    public:
      TestCase_case_00101_sin() { }
      virtual ~TestCase_case_00101_sin() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00101_sin");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::sin(ef::euler_gamma() * ((100 * k) - 5000));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-0.86508717968306725270818735916557777730599862881751831435316187689198923993283521790498932671735565487198406771220725516598383731877859238387113868142949869746710189966430151098818077220502499366007854414799684058332411166897077090145203892212195332779437567412064793775991386725873517928401298446944183864288115967332769329141686571538486980106767058872245206155998183801127952563209302584516809804068"),
           e_float("-0.79763858366953481259714957489398094215522640329181266031581650731842869736147648450595884906779088504877531298007549709584387968778149220989565106227234119514920955857261247662051707093671536949960734074547532698822613207712655346154633044042812601716529880175764244503721748663711634053406295594334950958339944104852233364538438677862264102037879639671893945361353871735018017912124896762688051071101"),
           e_float("0.24694751481270393816989455015331965599577990782082974819820952118012926923238759680307705708664260650582713915549160371243741339970969856458066110960284501686263922529370992689985210394245398556897269198908375140963677715274995382713675198405319566885196239063678630261988218491689541221423165343153282194748383394932208400962140245741297801785867823531750497892155090643962052920864620306068640533502"),
           e_float("0.98901354618029602175090175847463473510249349724827992487552201591187355027688868967642510244298626184812677555619430672681773746616625955520405639182509666726561394718194458471759810888548201804764323767747429110609233156664896859247358618600160567275441201363464883016296014653448896069217108492576553919644561112490398174029484186504656523262450502010870102764110481052688040511085868232105814711948"),
           e_float("0.51950049121984044339738214491377557901625353846688754076530639315973808266367537549984077340395292997735469833961726139018356328562746542110713036413300858234570352248446585277165262617881845994831334396201052962253340345385732694479841227791272253515875849614421139763193705915213364104134129815431668002845745090121741132063335533091373430722704456843140034973756911786188684117004466722017726632522"),
           e_float("-0.58642035909386951523768726695456120016000621264121118748335087467285913667949995440747093529938553592801111543797937432739099086039685347738175389472878030459744416755494430838140051041697426054654163206937572434284771573711696435479889701764370159398277764008561691680023659946126461221466012782190610630337123139316903479632261164136029483310671081582686512548571027968589672841130517258821548718323"),
           e_float("-0.97395403906078050869854812754010898778588110998510216999024129038738667688293411233247507547660433481826378554022069634273248636871268889943206657893365085495908990103953837221918076997320773016743323042411543366853067308772133354882422005996025272628299293665330139411017152702226907842064909056524954416279212381635918809975293849765789208374484279614272702262407912547006420026381898882431367705053"),
           e_float("-0.16835709980798731779763364790367408966536862842255885422223099514294148991190930841731427782587704016811168224144233724867667772646548196695213703654087451353235456862964457399533377933177974811857965890770102023474800434793450796708363928962489727300887984685066126963778396606401313473669144644834322766129500826515170674439623002622166198644072962305451561242924295496497673865817996583336572441598"),
           e_float("0.84348366891508115788160933441645221250048198837137321279789763092610185698937735368600669544368356295269809174537295606389343383737539420322987993567260099654804618392548221004269952154930593772246006464043499864133979093900482916664339574929175866269202056532433888199203357312856354292159018595451908698245799015703256761432875415473819767251067057623850803832618933566752146583252515995117479236918"),
           e_float("0.82202496781424117249008335037366444394838277287311909893953311783617946236226559994208529824007840086283951031540156850110406585677216210109663411850204100009480981960066776312830296812837514885788767571642502602406668355250521717143900938155040050319876970346676468728877434985446025106390443319201723689927608809502112038908318173339375177994594042306023859374748187782138324203679569236625767697521"),
           e_float("-0.20644548078966172278108566693593446671066500009311131547131824408615418778824039740776494907158941999700112622969927991803006352755440587105827687343678969660134349201419765578964725001619127224358098018507197217477518476424879393188273937853474771810828977229876872752634362284867524335876537185168202058991502610059394227279455590213187025513498301701182162411129861291651458149809232765920694382718"),
           e_float("-0.98201238933821398742743268689921357999177043645192920595050426161233644052306998773405192706007122833665193511424723001758553674874382453729473736698967318043174263178305116522678701572642644955125046307737685013720369337168716304062292912089093170603176088603092541579085189475146906948455044376044742840712066206800020164347462069250277677754185339937853236236760620498554396625100570743064458561012"),
           e_float("-0.55457689409530213747356287041164249845415987873946462511683197174099773035991522752407571732843646308149750048541683187925931560402799808039721796055589991969835698977651564881904161899499528485305192774993355886674471830577982958725011962505578939702283684004757222629888058039297509802651204034056785648094344956773393289641899074853933663408784777126564054915893792740950321751681666900366149285673"),
           e_float("0.55223631972553454320768877543021740444770413956059533654445613814866273197657606242587941011620967135302125178080188557790223181274132635479848516001166956056684169152368919096181559634794365697929692462933846221564253699877634144325144847224182437654513501600352945517055120350460290761483324902471273182702037419675899405714185903257727806710137118071603904368311406545920382236241507802254402670342"),
           e_float("0.98253910729963647217200550710547625178905758256820276353400539681385849046526414570850258127380376793100401827298985862391604692170961399606758739415403392939490853364686526772514484164160895334184339538751098251139449063960873514450954179656572162689800220524835985551929362412800974236601606988593425142227646314150034874268224737812934754054739495109549178354735648685843025309695149000523043036256"),
           e_float("0.20919424161231759292985627465559155127857466748292444765172341549043455435483356353779261807927572689301399184910446505295185314912207254913673684840121644950196263845525205209069485089301207501133253448764073025457512071224229423661258059212569761388984180893967120131886763302041343297149817612448231084051035085349821477062216670975268069118975416132488618059227673886548754511524393205260913936737"),
           e_float("-0.82042150034016416806875390736702748196355225785028360060677365666061470851725327317484829164156996988612675463903575414696300136809557656769505171924327821177877208936984569326071873868949719900334446867163962763207795935703399610925921076634415348400788763860462929861356452609306026119961919669078311635349472648728526901263549622576885884996291919276608766907523487313088490283878962209939268414829"),
           e_float("-0.84498980323075860897972946021725417020274887656496755152613838764676035268791649188464914202966471633575987923264828416390016799882223646789601058107569902148674040269544868920695600748107986559656481124234185704814218734471348170295455557819067840791831040541198080087226424277346298230729678145499808600603861335243905613388932855271426976928024047466289393683437131604292988966125504076029384924023"),
           e_float("0.16558643533491417205585047942945840817444866977186231320483545168338776228411479964576268852405814440921094618356469443677441509984568603636330335278789316351077745488280059266519036588084571034766067428538242876359850813716345435707699637862360396048950400623443566517903264884891653913736982243815926409161441171926621253221896245282532431364608500284511449412428102071793828094632271947929662322388"),
           e_float("0.9733130134422248664781076439996325547596041902633251431309613137772871577452457011348386026771902539246123917754369011815275465953253766314483807639106238230199709503923447643159359893490066619470146552346442263259964047308322485032089683425930804181966240839058765435955921596502848477098334939721288492487750073064012585262871240814591890531382462762625592433554435697556163942273461885638661645373"),
           e_float("0.58869425301303541994797274551524668431807337246095715070998523760895824155086577422557656235988936714948459396658626194388329584290953541802060334893578288199017940637454710820521526799628794241448315885605593820784070904763717099063196519196389181232206959679228386773967307850125102763819453488563433855077856029436716904341327752651679433491068803177798096114777267163356371922112193539114936367793"),
           e_float("-0.51709728401438414917109716343072272559608361642833403289320143191669289972512815282728235788726767946133258714516539347300398650917111088383730840642462745361559628023336834708274177008810720997864503236483231424256182008792514317978767120858313922250278919795149943234196749501590214648800764097687555634887106709926715156050968991302040120816446887836448112221991715147755412747643904982369941874903"),
           e_float("-0.98942504561778994579633520641173655056014959757317198390962485163668002823254326156828513148058511330328117672273198435854028958189163569498745241605165009769541862169414925124968295274462159200520442455095613008718526467538007940197043090974670359128924585720097669855764038631475310106434490427905711290624710915672501400113806220416195439435490181070678989789478092500957769720727750016650901714876"),
           e_float("-0.24966961848279291797571833930275478107046130070512731730054610018931793329197222379145867877191403438507358664845958042303643850373616999952368954956802652884289978026682268405432675662623924967650629865863280328006489120844535221004915558956531029998007360982378798891060454706118319300864403238959986801161474819341364524976070498799822591253693631124434026399072435454954851787496900161449413279223"),
           e_float("0.79594055595422952691181178601097588849087648705672837252520925001820847496121721128286756288605360935162062680205427201959305734943295649471345888560139726757801278052687627513338719817916945750214503848241201988433673534399927155896112448547784281558455109017382599606935223412144543300644796946427196636388890407359228183542249818866763328733472675174818547133151154516588878300883530746640968325861"),
           e_float("0.86649337624388547603453321055003727682405511135812925957248489739919757880982158700509398511202886625151501180599611933401736555472982930024421765233048287030623272875751902474678241444565197252953357529927172840699144509942108163113181199347462221304945816329094035938388900123384165001280011688853078191968630514719137943065609922040635003116435361117139325021519623335846499222050126246453597170833"),
           e_float("-0.1244410370371604254208240524194278926442108653864928935045533919736466234398227704731948452746209576611285042916086804685407426387667022583034033620993631898331144469445927075361836574325552419453828929182451743365661513957092134365138299104921209789330945195117245194360833974076928889872484098355943802078944073614928420504484518104238232385695964828077489150197654158701678306792352671268317890272"),
           e_float("-0.96293046254479079199525681753175960597403031074325898542927860894499480571620304305496779255522714740449920561168034834326825673596092141778811133613057020474685368838786612124083863539941316962278807332763650117226990808742108594645615178525818371573122469236743437907516188100317299657360446054991401261819129204379540798883211112991870608214671142610787565091372101286504874487369815732318336349301"),
           e_float("-0.62179356795469823415192312397624874675187191101898449037192803173787210412483490820000397097177845254715052331863963593667486830949291665803517410280665438510706842857082320141162218238699592290729367363950604466282373746899578041764378198664733652245195397766367192007717967103668113752808285669458804690643918469292331076180494649617596159416023979394805630825188506001209288256336069204288392918838"),
           e_float("0.48106401879047921636300391903940107974582760756679309056624716720150642739438342683672522048951018737803088677542525404601585084899079521603734609111135623651892724625992491018152917388956983222505917061754711563327272328292684822300781993087528192469722167755578240677892037874808381277754976653429844703376014341933327393380277555990041743102376562190670837062637051362532345331538219172506270246382"),
           e_float("0.99459994598660210790246203022148930567403641332218416710062008621506849496380708626551905127945616727090196117664589091004541642161620912257208486753611501380010498988340379322071716856719164564672927645435101404830980303745361961742256873999110722481713879285794690870477524893138199111938913573011925775303350770468373885738832279778798291949531285037943371526561613622424317208916781257715667313581"),
           e_float("0.28971323531857568215733762332571032238826720017802004073812127963067217035517116389133284725195297132478232737373492302474489345753341693637584844179360668204049858751950419151081083323122754896023020805399882258107804380387112498888463322046038842525866090837069466212429580864869728865250452052787720449604911495690324684990021677192825514006536158108787009532155828922880124667158494830079658512834"),
           e_float("-0.77008317127836149586878227059441350607034119134834670931732901937779794039455678722027323000807268437290639233506821159491390367599326413477276644187223128663850330256445887240546131620117611701853928301285348103306423446252568562902316700603944623091642743103450263900938785484049174821097911777581836743736428447638710800031710950631619240205470844855655792342941803794181628118648640971785223895876"),
           e_float("-0.88649850017673821224561809313855387711494312733345943767846677270453513982665617998145538590166442213419297144115248659615137339374320428869731210388654046137340073163830069184603212007278659182492697000063091326735676965960505375616122884162932165199220730427526058986119610548232796127810029383442287778473786899637739243088842682085531376471601373062369273637834719593554537141683999217223108777744"),
           e_float("0.083080439682369446261941860869339750420290004566040999778829779164510726472983010580067243494180590665495350929857908288257260333087985455133237616981062631238079114106138544790668480770034429554478579438789193350580847656213214727573008763057329069201052276891726438472292117455024152732335694633669865925030242983966039212743857415675412320417462552183844941128084005364683434559113799225166204962233"),
           e_float("0.95088269145580379080881101181112994052817118522049856992220036183689985937794231145980774478416653809589611744235048028615644615194631392655321782728314051357571890517116936363315155374421300181857604455336079096611022607668388384799386418069760723004847858784954833878669474357403336991887563364651104186693715603819443888233612866696932669196365387585172649113432965547015182359279258388342378601416"),
           e_float("0.65381759943134372106091314588882519891954306836908397778723174077695027443392791956504268149479549903097213397297315499069850358516736287190903269479767199733614758880061832597202653797690144333090552903833899073895212983370074179915262608190468586811072275899498782703930003207603330356201921815802020943598313063056751498074179598679039887095914705463376631567774307957063595250839360463815064201881"),
           e_float("-0.44419883729776869434215071043777351144885030313451423935916035359618633896743881816177107613844097597506905160463293878480033961624169222223295759692648326664891288415570974076231512054827602757300757558932537164133079144259056831830919794753959849196109997567447839019812358107684761555967862120024116269901062705630447884553959212830932666828758642780403825798457036759897149148537604844399459548053"),
           e_float("-0.99805485931896998415393032770516446507771859322057899721697973416742915484901238232275785525940419957209526513627987177343779809373389157284465387153256600311648238334663448491831652332368312374266794595524373421505295425580509620840292149779344897042078912546100024102919688347595170844681619630553312369459496674685957338099812389267540391789384661598432484560731964762141424249915228499619880194537"),
           e_float("-0.32925584367246074527751396405706006739637798458722245566584108718687942076934044708484934395776690595227015287405290706639110667384016496689668602236850778364504698270562443122446777121633580240826031233297957129154523055470095490128048296939167974638270094687461177877139544097682449778044363207679045057493400456686353020427908875447286459468112566742417779096833118762203417239243684311231171355257"),
           e_float("0.74289406214691971730748689577071217763372018162585246470580187915854993014301138575550281083980887718816934749714046327786941209573648523055241872433461772076860288459827515491353103487336092666555533666775562550333977874850593623837303036248122754018490021383285853316403824589398140210724484596507930263094598302837215576862656152830461839065227673408330599330179492764472850719715849698041674036671"),
           e_float("0.90497057965861947038086599125811051384385044697380649969790067815919477474459340879746896604169505347120527692320057718967343970641857165915886346383145960515992441520153342687355055159285406653023104853613872396986139584358904781952363737284861566876891343765798384121744173765740395134357707977315982337368931113664139166273039854021692888036428013020429307841621946009361316544995599016861275630769"),
           e_float("-0.041576169205724414854331070120053457632530839733700369568167900754032406936654732772225888568634961935991599374915238690240599985796132138663492274966652919918441321848911576199257910762408333861417879305855108842865299418446579173115561267409572938992011498300648706364387410319460214397723214932915588169565205375812490511157716082500702780952451334934264616069402150160091480447723605317627380573224"),
           e_float("-0.93719053469287541428447587920734971303045432291101939590716959209616543859713365160616776090412883872180361728110905082632348674501130850562014606872006847637794825897919364230003376975014085954809549306630677263098107502639663445116999448134011722873039267927440801790504248068619316004733842223304424897958505882332051426143421784920188133729127262166283872235910357317736650757661074470493571412889"),
           e_float("-0.68471096746912734562470712876063800310010723726902681221146004451735978903661775368964845187095694357185341078508280456672582218780943948231295585200462910309462638043306220829569568223236127599504907044705589687387386319181085952764133248551365406192657503789196736085441072782932910447315642044863129150642662429341110770180104183011207149983149660707056083856793755175252844455169463798794450950564"),
           e_float("0.40656549143420863029908616751057885992068413298024300589949432115120595898702030047373213851768191655418538252805786101555132655463705735655711116154911765012476201409686869641764641591979668818343426771144822241041750152386563094831102053728224980943104700599378495286307562549354472575266695139105050719290255561758911030594734879707560039179536988148731390148863859754525169110234247580451842221669"),
           e_float("0.99978381094521086442978283578205200383899997058493813685797491852361573237867864126930099929206074874924525764484785288016649661565231871317512839959145480453557525203272815558595173449617271532616787029536616206070064038068200899478815974462302016941233137744957010925379020671232973472871426623684133227677308974216593623778540970772162801182795433315750474086424241697242150612379589791040978731667"),
           e_float("0.36822906150398015822020319344162532428677981447045504526401832896397568656416150947456641712465258877489220724479853323760381517310729310497119744108741895595122245701305436253648702833101014863503443210528716577148214088604629263271753365879547676920872334528859185577830585960895038151179369059434978333166167532494557340097007973338568999353459041439303550202850628759030952416080241927287498139623"),
           e_float("-0.7144202473793071622881824775602288526051552507380513260225595579233618296068431093342018128610611262439148937183337715231254167800684731882124998094889468876528172261692144316638297695446478340662483258456439006572000095777092767225185208121633549640410407788341811629709553299018947000385149072176583748965166297086235970966085113896085627672474399917518485166722788989758308777458718519262591124605"),
           e_float("-0.92187767045167441324530701803233328862428889387952715397673074188905541924455439014301496958042559842229652278722386549208881577386402901283648710147036914825018808066251392970466575927695920587735551236320976667968957032620207459743622857456422499005778316090809442840146125918223889417182053059405944140104740509712594294160758554714036208559142846789714294797916313510255933830907372057747524929562"),
           e_float("0"),
           e_float("0.92187767045167441324530701803233328862428889387952715397673074188905541924455439014301496958042559842229652278722386549208881577386402901283648710147036914825018808066251392970466575927695920587735551236320976667968957032620207459743622857456422499005778316090809442840146125918223889417182053059405944140104740509712594294160758554714036208559142846789714294797916313510255933830907372057747524929562"),
           e_float("0.7144202473793071622881824775602288526051552507380513260225595579233618296068431093342018128610611262439148937183337715231254167800684731882124998094889468876528172261692144316638297695446478340662483258456439006572000095777092767225185208121633549640410407788341811629709553299018947000385149072176583748965166297086235970966085113896085627672474399917518485166722788989758308777458718519262591124605"),
           e_float("-0.36822906150398015822020319344162532428677981447045504526401832896397568656416150947456641712465258877489220724479853323760381517310729310497119744108741895595122245701305436253648702833101014863503443210528716577148214088604629263271753365879547676920872334528859185577830585960895038151179369059434978333166167532494557340097007973338568999353459041439303550202850628759030952416080241927287498139623"),
           e_float("-0.99978381094521086442978283578205200383899997058493813685797491852361573237867864126930099929206074874924525764484785288016649661565231871317512839959145480453557525203272815558595173449617271532616787029536616206070064038068200899478815974462302016941233137744957010925379020671232973472871426623684133227677308974216593623778540970772162801182795433315750474086424241697242150612379589791040978731667"),
           e_float("-0.40656549143420863029908616751057885992068413298024300589949432115120595898702030047373213851768191655418538252805786101555132655463705735655711116154911765012476201409686869641764641591979668818343426771144822241041750152386563094831102053728224980943104700599378495286307562549354472575266695139105050719290255561758911030594734879707560039179536988148731390148863859754525169110234247580451842221669"),
           e_float("0.68471096746912734562470712876063800310010723726902681221146004451735978903661775368964845187095694357185341078508280456672582218780943948231295585200462910309462638043306220829569568223236127599504907044705589687387386319181085952764133248551365406192657503789196736085441072782932910447315642044863129150642662429341110770180104183011207149983149660707056083856793755175252844455169463798794450950564"),
           e_float("0.93719053469287541428447587920734971303045432291101939590716959209616543859713365160616776090412883872180361728110905082632348674501130850562014606872006847637794825897919364230003376975014085954809549306630677263098107502639663445116999448134011722873039267927440801790504248068619316004733842223304424897958505882332051426143421784920188133729127262166283872235910357317736650757661074470493571412889"),
           e_float("0.041576169205724414854331070120053457632530839733700369568167900754032406936654732772225888568634961935991599374915238690240599985796132138663492274966652919918441321848911576199257910762408333861417879305855108842865299418446579173115561267409572938992011498300648706364387410319460214397723214932915588169565205375812490511157716082500702780952451334934264616069402150160091480447723605317627380573224"),
           e_float("-0.90497057965861947038086599125811051384385044697380649969790067815919477474459340879746896604169505347120527692320057718967343970641857165915886346383145960515992441520153342687355055159285406653023104853613872396986139584358904781952363737284861566876891343765798384121744173765740395134357707977315982337368931113664139166273039854021692888036428013020429307841621946009361316544995599016861275630769"),
           e_float("-0.74289406214691971730748689577071217763372018162585246470580187915854993014301138575550281083980887718816934749714046327786941209573648523055241872433461772076860288459827515491353103487336092666555533666775562550333977874850593623837303036248122754018490021383285853316403824589398140210724484596507930263094598302837215576862656152830461839065227673408330599330179492764472850719715849698041674036671"),
           e_float("0.32925584367246074527751396405706006739637798458722245566584108718687942076934044708484934395776690595227015287405290706639110667384016496689668602236850778364504698270562443122446777121633580240826031233297957129154523055470095490128048296939167974638270094687461177877139544097682449778044363207679045057493400456686353020427908875447286459468112566742417779096833118762203417239243684311231171355257"),
           e_float("0.99805485931896998415393032770516446507771859322057899721697973416742915484901238232275785525940419957209526513627987177343779809373389157284465387153256600311648238334663448491831652332368312374266794595524373421505295425580509620840292149779344897042078912546100024102919688347595170844681619630553312369459496674685957338099812389267540391789384661598432484560731964762141424249915228499619880194537"),
           e_float("0.44419883729776869434215071043777351144885030313451423935916035359618633896743881816177107613844097597506905160463293878480033961624169222223295759692648326664891288415570974076231512054827602757300757558932537164133079144259056831830919794753959849196109997567447839019812358107684761555967862120024116269901062705630447884553959212830932666828758642780403825798457036759897149148537604844399459548053"),
           e_float("-0.65381759943134372106091314588882519891954306836908397778723174077695027443392791956504268149479549903097213397297315499069850358516736287190903269479767199733614758880061832597202653797690144333090552903833899073895212983370074179915262608190468586811072275899498782703930003207603330356201921815802020943598313063056751498074179598679039887095914705463376631567774307957063595250839360463815064201881"),
           e_float("-0.95088269145580379080881101181112994052817118522049856992220036183689985937794231145980774478416653809589611744235048028615644615194631392655321782728314051357571890517116936363315155374421300181857604455336079096611022607668388384799386418069760723004847858784954833878669474357403336991887563364651104186693715603819443888233612866696932669196365387585172649113432965547015182359279258388342378601416"),
           e_float("-0.083080439682369446261941860869339750420290004566040999778829779164510726472983010580067243494180590665495350929857908288257260333087985455133237616981062631238079114106138544790668480770034429554478579438789193350580847656213214727573008763057329069201052276891726438472292117455024152732335694633669865925030242983966039212743857415675412320417462552183844941128084005364683434559113799225166204962233"),
           e_float("0.88649850017673821224561809313855387711494312733345943767846677270453513982665617998145538590166442213419297144115248659615137339374320428869731210388654046137340073163830069184603212007278659182492697000063091326735676965960505375616122884162932165199220730427526058986119610548232796127810029383442287778473786899637739243088842682085531376471601373062369273637834719593554537141683999217223108777744"),
           e_float("0.77008317127836149586878227059441350607034119134834670931732901937779794039455678722027323000807268437290639233506821159491390367599326413477276644187223128663850330256445887240546131620117611701853928301285348103306423446252568562902316700603944623091642743103450263900938785484049174821097911777581836743736428447638710800031710950631619240205470844855655792342941803794181628118648640971785223895876"),
           e_float("-0.28971323531857568215733762332571032238826720017802004073812127963067217035517116389133284725195297132478232737373492302474489345753341693637584844179360668204049858751950419151081083323122754896023020805399882258107804380387112498888463322046038842525866090837069466212429580864869728865250452052787720449604911495690324684990021677192825514006536158108787009532155828922880124667158494830079658512834"),
           e_float("-0.99459994598660210790246203022148930567403641332218416710062008621506849496380708626551905127945616727090196117664589091004541642161620912257208486753611501380010498988340379322071716856719164564672927645435101404830980303745361961742256873999110722481713879285794690870477524893138199111938913573011925775303350770468373885738832279778798291949531285037943371526561613622424317208916781257715667313581"),
           e_float("-0.48106401879047921636300391903940107974582760756679309056624716720150642739438342683672522048951018737803088677542525404601585084899079521603734609111135623651892724625992491018152917388956983222505917061754711563327272328292684822300781993087528192469722167755578240677892037874808381277754976653429844703376014341933327393380277555990041743102376562190670837062637051362532345331538219172506270246382"),
           e_float("0.62179356795469823415192312397624874675187191101898449037192803173787210412483490820000397097177845254715052331863963593667486830949291665803517410280665438510706842857082320141162218238699592290729367363950604466282373746899578041764378198664733652245195397766367192007717967103668113752808285669458804690643918469292331076180494649617596159416023979394805630825188506001209288256336069204288392918838"),
           e_float("0.96293046254479079199525681753175960597403031074325898542927860894499480571620304305496779255522714740449920561168034834326825673596092141778811133613057020474685368838786612124083863539941316962278807332763650117226990808742108594645615178525818371573122469236743437907516188100317299657360446054991401261819129204379540798883211112991870608214671142610787565091372101286504874487369815732318336349301"),
           e_float("0.1244410370371604254208240524194278926442108653864928935045533919736466234398227704731948452746209576611285042916086804685407426387667022583034033620993631898331144469445927075361836574325552419453828929182451743365661513957092134365138299104921209789330945195117245194360833974076928889872484098355943802078944073614928420504484518104238232385695964828077489150197654158701678306792352671268317890272"),
           e_float("-0.86649337624388547603453321055003727682405511135812925957248489739919757880982158700509398511202886625151501180599611933401736555472982930024421765233048287030623272875751902474678241444565197252953357529927172840699144509942108163113181199347462221304945816329094035938388900123384165001280011688853078191968630514719137943065609922040635003116435361117139325021519623335846499222050126246453597170833"),
           e_float("-0.79594055595422952691181178601097588849087648705672837252520925001820847496121721128286756288605360935162062680205427201959305734943295649471345888560139726757801278052687627513338719817916945750214503848241201988433673534399927155896112448547784281558455109017382599606935223412144543300644796946427196636388890407359228183542249818866763328733472675174818547133151154516588878300883530746640968325861"),
           e_float("0.24966961848279291797571833930275478107046130070512731730054610018931793329197222379145867877191403438507358664845958042303643850373616999952368954956802652884289978026682268405432675662623924967650629865863280328006489120844535221004915558956531029998007360982378798891060454706118319300864403238959986801161474819341364524976070498799822591253693631124434026399072435454954851787496900161449413279223"),
           e_float("0.98942504561778994579633520641173655056014959757317198390962485163668002823254326156828513148058511330328117672273198435854028958189163569498745241605165009769541862169414925124968295274462159200520442455095613008718526467538007940197043090974670359128924585720097669855764038631475310106434490427905711290624710915672501400113806220416195439435490181070678989789478092500957769720727750016650901714876"),
           e_float("0.51709728401438414917109716343072272559608361642833403289320143191669289972512815282728235788726767946133258714516539347300398650917111088383730840642462745361559628023336834708274177008810720997864503236483231424256182008792514317978767120858313922250278919795149943234196749501590214648800764097687555634887106709926715156050968991302040120816446887836448112221991715147755412747643904982369941874903"),
           e_float("-0.58869425301303541994797274551524668431807337246095715070998523760895824155086577422557656235988936714948459396658626194388329584290953541802060334893578288199017940637454710820521526799628794241448315885605593820784070904763717099063196519196389181232206959679228386773967307850125102763819453488563433855077856029436716904341327752651679433491068803177798096114777267163356371922112193539114936367793"),
           e_float("-0.9733130134422248664781076439996325547596041902633251431309613137772871577452457011348386026771902539246123917754369011815275465953253766314483807639106238230199709503923447643159359893490066619470146552346442263259964047308322485032089683425930804181966240839058765435955921596502848477098334939721288492487750073064012585262871240814591890531382462762625592433554435697556163942273461885638661645373"),
           e_float("-0.16558643533491417205585047942945840817444866977186231320483545168338776228411479964576268852405814440921094618356469443677441509984568603636330335278789316351077745488280059266519036588084571034766067428538242876359850813716345435707699637862360396048950400623443566517903264884891653913736982243815926409161441171926621253221896245282532431364608500284511449412428102071793828094632271947929662322388"),
           e_float("0.84498980323075860897972946021725417020274887656496755152613838764676035268791649188464914202966471633575987923264828416390016799882223646789601058107569902148674040269544868920695600748107986559656481124234185704814218734471348170295455557819067840791831040541198080087226424277346298230729678145499808600603861335243905613388932855271426976928024047466289393683437131604292988966125504076029384924023"),
           e_float("0.82042150034016416806875390736702748196355225785028360060677365666061470851725327317484829164156996988612675463903575414696300136809557656769505171924327821177877208936984569326071873868949719900334446867163962763207795935703399610925921076634415348400788763860462929861356452609306026119961919669078311635349472648728526901263549622576885884996291919276608766907523487313088490283878962209939268414829"),
           e_float("-0.20919424161231759292985627465559155127857466748292444765172341549043455435483356353779261807927572689301399184910446505295185314912207254913673684840121644950196263845525205209069485089301207501133253448764073025457512071224229423661258059212569761388984180893967120131886763302041343297149817612448231084051035085349821477062216670975268069118975416132488618059227673886548754511524393205260913936737"),
           e_float("-0.98253910729963647217200550710547625178905758256820276353400539681385849046526414570850258127380376793100401827298985862391604692170961399606758739415403392939490853364686526772514484164160895334184339538751098251139449063960873514450954179656572162689800220524835985551929362412800974236601606988593425142227646314150034874268224737812934754054739495109549178354735648685843025309695149000523043036256"),
           e_float("-0.55223631972553454320768877543021740444770413956059533654445613814866273197657606242587941011620967135302125178080188557790223181274132635479848516001166956056684169152368919096181559634794365697929692462933846221564253699877634144325144847224182437654513501600352945517055120350460290761483324902471273182702037419675899405714185903257727806710137118071603904368311406545920382236241507802254402670342"),
           e_float("0.55457689409530213747356287041164249845415987873946462511683197174099773035991522752407571732843646308149750048541683187925931560402799808039721796055589991969835698977651564881904161899499528485305192774993355886674471830577982958725011962505578939702283684004757222629888058039297509802651204034056785648094344956773393289641899074853933663408784777126564054915893792740950321751681666900366149285673"),
           e_float("0.98201238933821398742743268689921357999177043645192920595050426161233644052306998773405192706007122833665193511424723001758553674874382453729473736698967318043174263178305116522678701572642644955125046307737685013720369337168716304062292912089093170603176088603092541579085189475146906948455044376044742840712066206800020164347462069250277677754185339937853236236760620498554396625100570743064458561012"),
           e_float("0.20644548078966172278108566693593446671066500009311131547131824408615418778824039740776494907158941999700112622969927991803006352755440587105827687343678969660134349201419765578964725001619127224358098018507197217477518476424879393188273937853474771810828977229876872752634362284867524335876537185168202058991502610059394227279455590213187025513498301701182162411129861291651458149809232765920694382718"),
           e_float("-0.82202496781424117249008335037366444394838277287311909893953311783617946236226559994208529824007840086283951031540156850110406585677216210109663411850204100009480981960066776312830296812837514885788767571642502602406668355250521717143900938155040050319876970346676468728877434985446025106390443319201723689927608809502112038908318173339375177994594042306023859374748187782138324203679569236625767697521"),
           e_float("-0.84348366891508115788160933441645221250048198837137321279789763092610185698937735368600669544368356295269809174537295606389343383737539420322987993567260099654804618392548221004269952154930593772246006464043499864133979093900482916664339574929175866269202056532433888199203357312856354292159018595451908698245799015703256761432875415473819767251067057623850803832618933566752146583252515995117479236918"),
           e_float("0.16835709980798731779763364790367408966536862842255885422223099514294148991190930841731427782587704016811168224144233724867667772646548196695213703654087451353235456862964457399533377933177974811857965890770102023474800434793450796708363928962489727300887984685066126963778396606401313473669144644834322766129500826515170674439623002622166198644072962305451561242924295496497673865817996583336572441598"),
           e_float("0.97395403906078050869854812754010898778588110998510216999024129038738667688293411233247507547660433481826378554022069634273248636871268889943206657893365085495908990103953837221918076997320773016743323042411543366853067308772133354882422005996025272628299293665330139411017152702226907842064909056524954416279212381635918809975293849765789208374484279614272702262407912547006420026381898882431367705053"),
           e_float("0.58642035909386951523768726695456120016000621264121118748335087467285913667949995440747093529938553592801111543797937432739099086039685347738175389472878030459744416755494430838140051041697426054654163206937572434284771573711696435479889701764370159398277764008561691680023659946126461221466012782190610630337123139316903479632261164136029483310671081582686512548571027968589672841130517258821548718323"),
           e_float("-0.51950049121984044339738214491377557901625353846688754076530639315973808266367537549984077340395292997735469833961726139018356328562746542110713036413300858234570352248446585277165262617881845994831334396201052962253340345385732694479841227791272253515875849614421139763193705915213364104134129815431668002845745090121741132063335533091373430722704456843140034973756911786188684117004466722017726632522"),
           e_float("-0.98901354618029602175090175847463473510249349724827992487552201591187355027688868967642510244298626184812677555619430672681773746616625955520405639182509666726561394718194458471759810888548201804764323767747429110609233156664896859247358618600160567275441201363464883016296014653448896069217108492576553919644561112490398174029484186504656523262450502010870102764110481052688040511085868232105814711948"),
           e_float("-0.24694751481270393816989455015331965599577990782082974819820952118012926923238759680307705708664260650582713915549160371243741339970969856458066110960284501686263922529370992689985210394245398556897269198908375140963677715274995382713675198405319566885196239063678630261988218491689541221423165343153282194748383394932208400962140245741297801785867823531750497892155090643962052920864620306068640533502"),
           e_float("0.79763858366953481259714957489398094215522640329181266031581650731842869736147648450595884906779088504877531298007549709584387968778149220989565106227234119514920955857261247662051707093671536949960734074547532698822613207712655346154633044042812601716529880175764244503721748663711634053406295594334950958339944104852233364538438677862264102037879639671893945361353871735018017912124896762688051071101"),
           e_float("0.86508717968306725270818735916557777730599862881751831435316187689198923993283521790498932671735565487198406771220725516598383731877859238387113868142949869746710189966430151098818077220502499366007854414799684058332411166897077090145203892212195332779437567412064793775991386725873517928401298446944183864288115967332769329141686571538486980106767058872245206155998183801127952563209302584516809804068"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00101_sin(const bool b_write_output)
    {
      return TestCase_case_00101_sin().execute(b_write_output);
    }
  }
}
