
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02101_z_sin : public TestCaseImag
    {
    public:
      TestCase_case_02101_z_sin() { }
      virtual ~TestCase_case_02101_z_sin() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02101_z_sin");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::half() + (ef::euler_gamma() * ((100 * k) - 5000));
          const e_float y = (ef::one() + (31 * k)) / static_cast<INT32>(3);
          data[static_cast<std::size_t>(k)] = efz::sin(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 101u> a =
        {{
           ef_complex(e_float("-1.05572927962098654867782615000549459305833721463713961147042362205828772843201000231461499490219980702099650272539205986199106929778309192800342055251317281408208991516399927264018078616590113046000502003869327021237605897007131622323375390707928370620115919955215898821205108955488255614743183850553425757382862934840851255153114395804889551011074560209802304363527997896862563003019344670464375621437"), e_float("-0.00864790479454085030745366764380844782778977857949406499533687976378831233980703404128156179859865362765302157586225172465691609116537387728533108718808963606360296703303037755308613994910535667147494999583663487902109485610352304254574713457640237386314796811950264986856344485571650860819640187620677702094053269652075897072622582041134941179615581723681624635868950378381923038776243697476570833406")),
           ef_complex(e_float("-8812.760405311889048415287233040152727317013534110236563589960757843995777292117692935093172250092703458115147907495634898453122352900886452774067791910837272356606776570647298501452515764050901889466411505852273583153555936896768050749315567498406795352218848355455985699869915978064339971505394000415560379950299535698029415099280532618435682420590596472418795523001916066246470814049036965436957663"), e_float("19556.946593686483952854954718746621169867269299343890938991778946147162449358596253397625065453777233921602878471193175407042541118244706739744238588649562924469485304088003248723556118943134638819227908018261303866495121885129413833187942920650584933132483472859830458462750686180125638078882936096344867096335538938140057503368962694041731614527854426736722959527031670363373425087214772966980855347")),
           ef_complex(e_float("4.4925063286897475321084906940883039668153836128720349270482623673657397005105011608084600957986591995039531661216790484520823458168938730042738010710493926992122024865575588252218179579650119554713907136339820031931798248978212502604471476346348239824021132486747470605238814367959461603433162824645252991070042060633248684454051003879618442931274819398335022956951580677139787117965388895960611992629e8"), e_float("4.8269307457943802874819202547214432265200508267534375581028977141229624432090189433487760967676258299745265467890537689116915782486728113998271456613324189230648581960990460997303235555268415412503638601966302697004774995677446849423846325249765024831427720693164485686962080793741381042828871745475484813733064057467404522359931143637724679981391175083174144359471274404218126211547106420656283608975e8")),
           ef_complex(e_float("1.9030160025181949626920715955246407543325209483217393610267783921628075734328465296844357766403268307835842750033819212155503403941937664668577965692510202238403354431097616885049181069111557849468935164004329321882260636801689489151531384177529106571390344363558670824449762796963493644148361497252832054908187016966531742656988809097209417210293984463064084224304374040363733881608972532778199558729e13"), e_float("-6.981752843855086383955997092053349184272424159855405056804746116541064342935935544365868274947383429268235648174934780586740743033494190124764107045898072179085333660675973787617431245490552532508742512959442398851660220611653795834888142286547550590746244127914517926888854403305388567211252584895300137215815403072038194240827201436756596145915190381834433814904901008258974542486388134973558556964e12")),
           ef_complex(e_float("2.881926464350463959867254305646733327173250889995124600604339284082205613239104491463689954705475282397329761735250220057127939726201581025051146327875376225146428649159213516669213209732478456690339809398118201418827686101226466815692868838877039148848402751509508084999299487270373114446499852980217979560786387197688451063304212375168456587456402538917268249047692211664464096185668122813484566685e16"), e_float("-6.2245567785123649171316844138238511180943566096314071521523317143616898926291641653224797505564310043533249158968961088097296695021004033681101828121647374376529736125453030823958756529539121544162203596931642582351701159007575838755725061959749746446127517546347764833881691138930810547188471822372339838074633900701273712690637612280759286467353710126710975646521864635269992065900636251194482617147e17")),
           ef_complex(e_float("-1.7296431658550643901978468307896185659578158307604137899409208831632771824706868063880304606367876967872080852560821565780199414785574787641958540105858638580959942081057651213158616165679749870416275621374367690175998393350081218239875124124150180566311307719102011776247099253181257323060559958046669775826664736060812857945070081945562605924203958247013215824118205859087250858565702574635876112875e22"), e_float("-8.230978642904354172762559252859503000711794603377764514253128270290002528396378412325164690397686110092670989605712246765221680262645987716138987352593697242345017943217855819844352823868733785149410624595530869642338709932662624275838282724901677731854589153623322757628513079353715518962579219885750946157818758923052429407844858484846770923970726439615605771198615626824029926445837696451830619249e21")),
           ef_complex(e_float("-4.3928029095342039443356254014289421636830982635687692696860469504318577278368658677421169772257571336749206572204647096372620710892430798155368327309069145343125104012050538068524575829529590496565350987187476839056726789874258525072916459323436198424503864227141579074986257323591947809559864448851449611549431331864316469013964577526467205566903165368356492449532179950242045869763092317333097242612e26"), e_float("3.9211992490646193340048702220821879947793060506687568126158831177585358704338421215263998763063343519195182186629581287344880562688014398654399761318750073361268008639944720709167051558799301465596491609427763329690893671605290054828042816591148023098316577343664010633619104606320609532425714019639379477135385971929615348633597526584017358430702184345300615089853192327793328666182595574865588911073e26")),
           ef_complex(e_float("5.87983541436738304296070591761132622072550471609875211088171520097324685399980769601469086229426601168452258449985266877443743704418745137479555967879449679250209289112914574997019984213518802069778545109037520912232594520203180156137238743898139977861677561526521562177865816977223539180375701100425757765714946066452005321569082328660010056402396598438823747269533529761823644326640499954126851777e30"), e_float("1.7119387138864305701499275691870009712840300473537869806288487336132506963648418223132927944237838230532531225036134719204714857591449742521679063331745830088114288854476754490666107792021632709767282835950451697823400535970544081123601496359812299809461977083480085466919464064975814721033090256540224157835560495534337612571120419220320254712545398137941082780016990782533935501531858423998172890703e31")),
           ef_complex(e_float("5.5518118424306568991416420297144461985330299300520446401815150874480785912769740932003838246257805589020175298791738749297359640137393083668388822829762735600615527870236045750172962340604506115317792865326030978544586018175387070549946242630347055232856312354351670739919890733349917338267208120346247318637767094523677461151581107253029459706124613987993518220202289887717929951642443855117291576172e35"), e_float("3.728655045415778154268912509657707677831905385639364968112071457524152466717538364784678329491970431242609435562575602115427611835909825644925867263377674543541390333020421702959460964985566396410079818353891732529183219121204164337044750358566722211212655574445067376859846740056886560911465725127345782649689369462901699600954344624758426977645684436754805958793252366823439306051241206868990043878e34")),
           ef_complex(e_float("7.669603761107450009766370818668982401041954698313750072738202664086031005822030270389372144769502488359425942296512738875686702737373632198696628684589759325568369996315778326408134307406470409555336792090848636955406139346894405135653492650898301149723121549767078534910887631281556672971568047207595770113313213909377526870361009073510708213599083939626895563286163909960840249378756400287618860655e39"), e_float("-1.5289090115255216250991754709374343157269757609817792715551633773779280732632907920775867065275773939789109786674572965496638597775135574723496354891463470801271602137624418367714950812424613617520547758706830968076798614776826434513963045963036026913360456048566384949693441432207439668847326729677308113428614727899344351111598127174141988175950102478959784305183315398479964567142848322968931217423e40")),
           ef_complex(e_float("-3.4192079895845537452496676555677622078990838660167177160932335089720829615128196094807153175289588279062091151840194292202709015403481276180447454937823037142180303565745113316656100024119357420001531354678084395290887554613522842116867754264974036454244921052843324941845801266641565803247781556912832305762546910381761087925147231283531907181331995785887442771937682052714253516590649894372498929382e44"), e_float("-3.9946144659859100692520798671982467008179242498996047046323653434285321574510699085530942095415906782645701145832400958259286502513353636761701828160216216940915934457415993973099152557707270450493771989981277881839587263013554776997427767791281008235263429840766806766793173867605651167569794467379176816320557189557593528792025607063347428298272763867633949615055593234325037695757928329522235247182e44")),
           ef_complex(e_float("-1.5393026859977913546754131726089188730088727393703502948105982833111662942624058631840318571990392954438473892145794075253064023561143670803941261445623648252172288196991939603307960098872526193188581585807876814658473509132255636436277116231135033039282893383935313023709910922513202137605065737620720901826986067430937375599459320868139735609512192442099295221498434412468459749522358329534822617256e49"), e_float("4.931542791198041174679761448292208463181840433904458112958244167161530665182230991898440975242527644751794627520276950207881772610599938254861635957416674066687722654070089230483523891571160203841906743231775043151293327425064179038184203388632875090137032248276778840528596888025317570660231983992153137682893640626411157910609464096410966667521339415061608359311654736054660557951867336031586961764e48")),
           ef_complex(e_float("-4.359687738631568849544873683202352642582195477204026105682499750626797219929617410215392656634319615990873824838655916325750550726688454950406406719128502077061983464068883226013166574522219460455969241927712033355191951229934879771359606686721551392184924040290601712707581146873462626372951949882721749046380056796192079139777972666444057036462623241300542223351177937213150953593943503070491279935e52"), e_float("4.9496261565698405772573878831827933384202644063102009258087027698305141834256734224339712033925558607428036752996151266631413805471272352203851520619730653458561389766592282454499625907766672734770351762092140990703989087070508311775890757235000562198210279299141820944927981678193677554996291362605615867728471065948018389034265291935643824497548390605242669642569491395544098470417118174817211057901e53")),
           ef_complex(e_float("1.3507397944355981093606642731561207906078185846068606804593596573383008055681707983897067321825852232876084067351095041731985183906438695916116947716126736794130467175167321308172432572249488148490191350133935904708769245154750312216092633067524807707880408625475933325670046667023583068679321541118252424254946072222399212606990817642658495937454502631388216061766072087801315052172034617940762227513e58"), e_float("7.131148466774308223237125827798522510439777862550548854163995771705669653590532274180228522724906068036163862730456578605152203419450696994066328243773118150500397591516644408116716473324992471367241980145296455342938051348129146847948178977333228620216374241877709268002385019042324267650285174663694654006329132071785783419034465630487972605282972536172265446651368290536634959297611201535154912949e57")),
           ef_complex(e_float("3.6297990129745202149094891793682865363988034233721676372993847043334125785322038235673697043155210301536385758097292590223071848608947302602682918897427837506921106509165088986886618152192540090535014486774951463805962130168378319821676682254776043490033207318006660513352093934441281741934140963764020086310366115378286847977968529386977750121586010400050211336499061882762460800650944990668762765529e62"), e_float("-2.9784332464563669611383263093377559652294880347822835479922309982547900388151649271488909040629288019198188407888213350287823607269967537204266162292034482541156232395811345140334355604637390772452582535633122790200949938748719779470594215940848040815015005756094944019937763898090890922447631551690654660892336599499543461944466847931198971136491109797346343795475989766525576634677812151272732515488e62")),
           ef_complex(e_float("-4.116979366070996498689932569357111451157041905302351380916654001116908840917996127729163572156493302598196372391338097373932312990281228850397630469622359668930804445599500730660676868366444702610272922438432564681847962555931723623905173276860903816606826097047482727092068847533597701872478455468421477748488298065139338881947538118313233339772763941019557568943510992007482164756345320387141727064e66"), e_float("-1.3834158943095175381554579851240253950805422659907110439596784341881395273286955933126987082852661646642341370095250856531348929985698619180613169367951429675233154342291555885886697798874951299956137242590348713088968404512730160087038351272974376695018392309163298251656105138389666584318403153727322661886083610924245251683596858682896182149499073036137448860746083288536041475277012606922212438686e67")),
           ef_complex(e_float("-4.4108348792610681697120843142558007924002885920481144136348614947870711313786679513704489149546331213328911687997580331308976587322516673953496230229490455170505384432807422031369575075101416806132705651423227716636392311250416447313392527526184618361821433863756526465112582986752230861688861147221423950157964446661318315640192275186656327940017586715878916767567353625739599864333586496812496938987e71"), e_float("-4.811252247422723110272600490102197839494450498819362103763402510304076061425361890388177912837048996175156641511666220151748736359223828752145104771359569641239665593816533553617132592356083463761161676504880716709986150040025854643781758465641542839326962469503147926775067279789308823913035892145457296550684873507652167268457699611841403563557011104876072751134024612035963747000531981115172495601e70")),
           ef_complex(e_float("-6.6173450149937179147434009764243997014145370815684383083506104540090424979879419049260890203777622708457827732364663087309366786439559525712274895474908004797836523346879771804847926815067713586364350011057431045598990948080840671185921473984961816496645444696316253234589731086801096621556248016914042423475693443364176267654124067892753508805697398574617006589158431062166179054604747013627179873267e75"), e_float("1.19267355750366819080879717637345260856501134730440213566708344914863769669339713528848441763661808036510852550951985395854524636459436309244580046465380629367315115435629639603995221173002269796305224477263387405010878192921296711079778356542958956876875126630759854642285738471830093988645118509446309721271610884336799418935475961081212764692309885056145379765990967882529790824563205873606625823525e76")),
           ef_complex(e_float("2.591691770325729441123661506845828183504351547766104405201217949297390812589990748425842682297581343724976182727365837373975794232871848768762770336426964570657488169218942098297594527497104085824728657614994603634023895085665671494617470633207953835602782248851819775536820697597061412007996045630371234381702699799129140201407693385015379599726496078802092669660165861545255178540372286455540226832e80"), e_float("3.295914935155821662663601851774911436351822990502324252085066550075265991506797649447579055207673603211846066633712391833304763184597767812182190418205138785694039991781120094009196001485706598904422161731213879012575560966691586996155005470605733691122563854201469160452808390039858956494366688470511754064311071392544879257494571315378951797587924453819329686340597814500898408417108300102068801825e80")),
           ef_complex(e_float("1.24273079172037670050865233703092132135458712072143234372880429524665746283968599024769959985673685867603258154829032577976550749993993147478070329397332773835951253634290245541987213279744234825849247262661890411365145204322707817931610408524210730757636637567455507145599393862724704432754179901641355962907324890477768991014320844245001276477277366693375329455226435201008012803007423177769808467348e85"), e_float("-3.4186968902833247127591327561354874087840794944517081718975776827250034446491964337790916664007207001196842026462539553578003094256527642317391751772668868332266922923650572328665026461207466765361597564689656544925223157226390896681524772637292041558224474230214355656530583602456314788548110610995695044087525530988122047445500224742310878579428032984999485597846909138947262220197578778859325462582e84")),
           ef_complex(e_float("5.114361646037962977814389427190841669599191920163933437564645902973979896001018055670617729515749960864199500166911466139966753409737220328900675566589494592672097598421757229871046581882998050926757070104593707012853468513683517664154720479577749072013771342747689491966666938156637597851071512347261784067284489041075190369430481459324034625242749824897981702957019643435070885697151707442965255943e88"), e_float("-3.9289741149443294743870159692292174970721296600074134632252246942813435524104338256972475144700913301896495943359866904639862796714754339276818175904000280425031220478088534381304832526884121975615659704850065659208671676338207358066365635268791705929350040317561913218236406876791923443956409055204520629879685486063632732313930613781218540128501881531618340825711818897804791306516246369479156090637e89")),
           ef_complex(e_float("-1.05250909719145339278484756220774387549816627530350279557585273099822740103503461373180742291445265218849156707279298358268788225831804653296245811492542591727334536523349211203875618337293262600973906158509089183411219212128791979791767590171229387118628662021415794008719161187093103296910687443661919582453798375276429426301280685635211161154452055064346703057171433506740858704792215878934466120819e94"), e_float("-6.1292828122236368460655928360160736056370162594344444139185265866369696570021997525572471485429709604218479299209924506894933143421908792889625843762148060817637038168751069168852988993468384313361916172269792429297018911921704920113907261524819138198616529563666242895819754398391156085014988783600806523558585949243417302374632013156828289983396665977519447267653342645082275380232111144835058737795e93")),
           ef_complex(e_float("-2.9906490330194265253498419226047320810685268323198186918017778416658957899250790415545135783419683244613474731008326096676243552175959515698557422925133118613159415529228772776235343271896014358114481862718451658800751115370682646489527424718072901186257381524526923863141131387554686136628043552936641166038396102377021280906122059258221636088065935457985609928862813088822928306741767550012606033758e98"), e_float("2.2526158304136817589488551999652436078932475050899332717624307393592655895526305603920247294248148542820514997868744614762205192316334155178243341575998620285643517666440505334884242749300749644373651491192063215819295598161596505991510746990277226882010867248233552122729138420158005849349538603773479408078432155009200879513394550564111777086152949110367541813145408043504631615346198490736072969171e98")),
           ef_complex(e_float("2.8214052445338550078373357979204817629871833008447786061190523433701652302081452240783462881408319625810117457122892614588985075970691794294620373353669464934462918540665549691054274855353931223863148546322285756431232411873012639705577619548455078221311403178413336217335557280802195996456090270748485219635611937724399176098814140199141501665692000254870533369790491421729598486127706166976476313006e102"), e_float("1.11583336183569921111539526150911522952539775009141656415183316498988028036725317520001694047004620309608156492837523276969465865882326921735412386993011805903216061248864935141219958221687766568819590113312906530517363689598782129450659803190642282151957400860390435037232740853399867908467519816424562745896922625044329631946050249276932585743194123203698890138742139536766044669145198851737641473772e103")),
           ef_complex(e_float("3.4982154411805606203234285962632626803753063118778327022971604275790103712124530430894955488631084978439881339835953614234816922334791219669811413404288214800115711431318118786278159592143062758414953567007715194426668431149114657904873580395165707472383120079366754690057307306292983240530321756764804760188592753615695340144182273187221726984042772049846697282299099608173557509340202759244912990898e107"), e_float("5.295503635823844386863061023666378056234377369058537177597886778813584455680870993450325136913057585830944601591007617946275766501261077407099422860111127202963569776418092500567790345494209803425847500084949489013246874837089391227329619013428632742977068026117377398747978260363930697015708874598358535421434129081102310920527880802570020717674228385276099709164590018466854579594285812085760733281e106")),
           ef_complex(e_float("5.667525756906427508202622003545549932361677511102282885345216007887906793187028465187250661480251212072698823008177064614994695618852665965697821386707032372390887224337789311373479277333776836373106005786304597978582111822325275270647898213890122164006516713220832832850104215710085089044262402018378244849667381881038958464878495484463225570492549510027526556725691276914879910412145996809122490286e111"), e_float("-9.2827919922530410931739185652793161201723554166094191763563878309043019793822805216854090358202012075761783449629163232517146484423907583154468921530761874545839514599281269720587707180500858471295714688274160504281352888646500898072500453939654294347734791381307996715874040604646059006213090301640403758192490324436762950130813712408686146543853960766548249290476032704645273239274415540491873798966e111")),
           ef_complex(e_float("-1.9555633906798087991141867540825299167790064654715035552341588481919741998525288530722140506810522025967172905197994332863943658971410313466364572635943145225621028077939754939457059312381154793943206169438526167677873703460068566845166392500087268114002658249135784224272772853046513864580712033913913055451813499358726595638816733880096418949283523714793515747757546392559789229388160422444330007425e116"), e_float("-2.7118178961200312763848673884745433241219759665943428747306808452852049390791203150488053742200076172406071197422603090303845371497406279401710099353791211124247478825163491837969084024686704935156932980008142916289586753950725422560374663111329151450658440468500875642243006044468425371986374045290218599618670377379891480575071628919013432873488982073357314042585930711402638569793274564079543237971e116")),
           ef_complex(e_float("-1.00143280891597958211830183370715781462345264589433218798949872899637213454051561834327300690706066247856090747440321926354740953542229433876254094525406477053829508165087149401313832748817962143016506530798625636499456747207119326162838163760532876087491714890839375223698934175764514844150603637447720574223949865388612627866213216390733428283641378014058135755272916006650215690125672197888566046202e121"), e_float("2.3117162523770669487874196092901174219256366965688785551554560616529536066836002916403376734032313291796991715510822734565117304728510964075438628834101605087892306263693426330075890920186831296028841638275843672131378440780770839442473078807463153898216987314902875132602757938711405551442928074814301353999803757725063109825822630414770142011389044563417148126675581454262593945252751794466939462179e120")),
           ef_complex(e_float("-5.377243743255048757997103989261071657350044290692544806987639127953572947383220065971377745850891820252740990251675169001242325656015763820157075288737640788262303711033855100964180384217371376039080591646759232060681538522539171908853448888868963700828154370872453226374751194619149949153812409481234100104840923075988417019863200264994073414020205883717417879812746908794697741603162626371954277104e124"), e_float("3.1133061758886646441208040272075503959768235383916706668200688791360081766688830752783707771598523563685403208276832378936012987174468891898866910751574041570754028236704222879695724248249332977585258024176224340650560807485503682748406070977413776775353255589333026461756810942263592222827019624223887766582882778321141063320936374462626645277210678753530931675926767175228636705193626309590929118113e125")),
           ef_complex(e_float("8.1822652610169600578545845729792739921820208083536695077479791368038278873053850975885082693320945389641758725514621362774548556929857824781650678913535630495458293018932628697426219900117630694029006102342665495730530493456996276045989493551425054061062321052983555979754021866322130513758467495782600596051460628348262411016856668305550090835185206242688890637396100755462415177493399754949899605528e129"), e_float("5.2322120294960862833539763943341447390952386409695002058566458627128783248796925803074369069054918565048713223427902155562456829947171684319831965778217837488363382487669183993290183968443793341893078745309051743308007725942142265888777594037154511941740022419715461846020904097584110776535268274769872085300104919086670599171671204298825790715335068866465337273228967644497200079533046403750197751231e129")),
           ef_complex(e_float("2.4573674612922406023872116219182421961246581701340473476503191838228901243610155119042350889960393842907984648852237450785031408622836785378604619615490357447685762142134542083930956797443703732402715398342831181664466928853340600087309230335719652768747985400893268892102020193601800444835174546854142950919327060416526204346084282805219498765699051018248695798775757677210923747530288916957619727904e134"), e_float("-1.6955378913571192737000049097891981368335493901915505461733828500640856101386561623882398429652291924859542396981895173231873572198881277013081105313633195924324156964640644552706370413139736262913213720281704716272627909678615442839325338639952095652629261333109176158182209462354688092874888860721594060889632752940500316572294226184319959715892817474118052422399429421657405898728570708346684016092e134")),
           ef_complex(e_float("-1.8779168761661222950365622888392679864007207042928337317079360457314579646755409535224869600682912725188865479900112781112675532575364022689605222454540288863565227323573173007732627553835309530737573609984531081441040893528203612451507013675847061423300234524276605754042992942242989478969901749584478104506246480187481914381360007076812292985848840019996523678030516292501993973690746592733859661011e138"), e_float("-8.9835187759697348067238738460463059890495874212395824939347903972479457807339098175036520200855717524432187788885933282834971356375184817851256074827796765645431009298988527130004755138897798059271301615793358619387442662328220730050727024472387263577106088307451847388012747447098171066202256058028692458776808270145909151212107352598164424200117309830214388146140654004104828401006943619408913504075e138")),
           ef_complex(e_float("-2.7695149291295388778780632447125084936391866006125343650316781954496412432875610494452953388861897951660432731098823729840345872513901803960624527182354596855324448835691855839024195019905223075802403876949946068116233623253052891568951794828697220993276005745329281970474753309022835897831952783453651018630096946280905276100062826071771441582216489191213078761743514444916922794882313988442403824942e143"), e_float("-5.378752752645050089509396164540489507093378504630075661510843695452589909273130812285814530345661740129946278924100846789354523249664633646741491255941384906583897451387344675936758918623141939362741944116932452866294778437905394261875236959319511354219823677259726079954454041331048339825057070391013885638211041777679505624506442337075985195306014961745710531968421726852620975488030343877892967342e142")),
           ef_complex(e_float("-4.8231387060258094191086546779884893830396489358872119487647261955538734524531386507037990056927478651085566870085434663073256354421390769092397595235232314974694189390738027221090839690474204521030637872761005931966442017486847710527947008763209975914774082416812973369999907115676945740626121306058425658714506262779228234033928637494389743838093273051482702116818313016102915894178822450633404131564e147"), e_float("7.2078190464047539004103009758677152865334731337218606363947976883715284815830774577340962373629511362679738860298852403620237982304687300304966678963361772665934590684132034524058483716500423005443422425900698235604283178224383754452387287502423817561156561603812479419290982742340566748095144412341718272743107646530798735196269745311665941968063032620952680294239451334174189619428482944342377490659e147")),
           ef_complex(e_float("1.4681166396750887108471170960437828087533744562183845111593686164322821901629646808338516452899183215612536754631027577526417890744705571425599343657212064919303420438993216786544150374873668500738554291215841937061470742813213293157583729930189374527400019089215426238365577183328828547591493778683605432798787043903790921861759355784295704876928935913124239149456015499545988003337572931673201193461e152"), e_float("2.2253711287992306488190866038872747961019609336589630275951070401478524266731326995882519431957799533481336853383949279682990864072160156985559142601771743137902840127560679340041419238225174522692314617105155475610476460137105750048033401759241484737122928010463938750385978174068184618469729721792111371187981859958635065914988740276094154754474592800033566403910841048734044433114159639981579182373e152")),
           ef_complex(e_float("8.055177894126157579264476833178409361698366847040319815606763459599576335848965236362506163397041402624576686970744060091106814941054939681861051671235949528112760883531121891205855139813476343306413681209353859029724250830308806337771142324716965605300889599729796570036873856547447398281103482109924865113465787430347390857618025107637948293290984679228383586607685875237879668762011764440862083639e156"), e_float("-1.5097685281775285527282376132368089384559664456192135000281283158233732772930645822366711085978881548106174086181901253264862789675546342919872784047084758858443015473442276388341195933540927551778516878846645455228363267518826476584066644106970490282935764552567279221720968055200853960049767580278184976621715795545917565737279306159050960233447297703078348042132308794204756709940474414831843489994e156")),
           ef_complex(e_float("5.316267478252111960930303602939646653966547455166923236131932653119187623780350390505909389509561487020628928487522527330563124748945891147305515337289474758888729394994336064448259042908998384718480217245195374948190725833260304312899123579132815969663663854353227065762721872791303895573817867895263885503378755263326189668104639333398034131729140507722927518686033078959272042791887063055261199638e160"), e_float("-2.4625820135056690340254614179676941108913390390505857408588552563077952477447670988960596392164660579611220145910274849159651400490487459065530365124556723308202373260514492114994751660526432407681585653256191123841957361725004044340568798839486011604643484852935427954510803341207809154155913048715386077988900148777463152602693621702137681923005357805101561319594985094974405201048608413729084095488e161")),
           ef_complex(e_float("-6.3454478443235408631590319058221334504406914860793398728594613838715902400641599473405085097738800964048558491390718205556169900903279295521036976239721042551608715409530888901603353848537351977501902332026112837495403593812580657021190441602344466508818432706206499023451351600166327353048712453535146968344474540343865203546012993346362769011252449256982639856986023215432545884096874497006744308448e165"), e_float("-4.4398332680508629706366156674097468268221886067199660830209229486393715375317956396408028409370179752184355793361151484351606867176186501608474318908046908168218968092196222897813557562437464179960689767674024653890466641810592451272288234753777695131225780270309695718783643031389424551523491645489236698431414737855692841518054778181129082963762725947219211885249776065056135168035834162957899313801e165")),
           ef_complex(e_float("-2.0140267508816144380631568537749147528387266819120456472969739241522142012984748309582991725518364500361716060891005899852317890870127286570184524536314442110548616345074185102059471241297327078748699599675064663768537390237727123016041183185385111453857055337988883522927022389324923518292453923465083030530595095866197671201080312465016854991257531643657898264077349323199300325726337176240771149418e170"), e_float("1.2693869134729956299048173946110485431949985752774854474156795456208975859253241881530475185679597330133889576348041289938741142244758736925280481438189329859251067234817371398965430657993761272604527784376507365220425404243740065110401975377646437688413929535628188574082132040876516308693340224080743418143444145869576721199598662383292961756157458345921294251257140955460062610207352867176772423509e170")),
           ef_complex(e_float("1.1983295823370006650773783590036567156747390522636971917042501600584015159160689269371852302285051463041335445460687658348778900106327081708347053880351654769835770493460863644961058553433423907782327591933041949956307339877447194588578219798551683788533972957625143691802848154448205325377150471782925654733684741444052350102421248785680448476354858779800206748949515320459752837050577669222676892767e174"), e_float("7.2195377847609713651526424906427849642602882979113937477524317769099651980403871678132536209414909201908627044480535101165269613213236758629725792451623620069110156969821441871107581448164208453995921718607405521452999004269158638405085765771876126508604824555679997596266309717492756209596710333279458348185109669072623365108720481389600095795179893827897221503402759364227347828338336009856085681346e174")),
           ef_complex(e_float("2.188674316008087463687673944295625501389447213792050946703852193144878841614821984396906676423285886371833371285774109261461577375823652021346391549237210633018845992500533785532817813750622555272160375848725389085581707842741667389732708593758298099807058815864571899536260714629887243603979163306371590017139284912043563741113274852088216341815268386627922043316638459588454786429985613324642785354e179"), e_float("5.203492925208747113275806294675485525143786609496893380185186198877787288260927535292546880065599405779342154618056101725744791263345263389225744112479751510873938775804576157506777238058595955108727783336256786198260586908861856042912184906008100052411304688468194645725853586888830697482599021760180564071914843031141981751784752400619310562813442087423477900680318790138416760618692795228672787329e178")),
           ef_complex(e_float("4.0816138170059087237735593229642165433255388542317702321934323177448568336987186299930082308838129059125013461042263566819866117554256707253902667001200756379486129650361425937417685752593364431742931234128687780224724231143341379795167842473077356344928581033403009050856816747652926930733325524668197611367071307423295657215333770138250126773870421969987341617383691866743298227612412079592122258413e183"), e_float("-5.582656587482039166680659007242132536619189532753474234854567432580210897843226108479156053807057290367671831936969666516762875550132776228579583051874486357186772682767317743655827252129534258683883655456816306871922459724633996093042903469175753727505554358441316064075548404718813554193617688061540117500955373070752975415200404894351886074715344560991008545205273241037684340224898484721206236335e183")),
           ef_complex(e_float("-1.0958889716675421397022448788105155996230744526070720135008272790655924533591450344048509792377154396264060921453767237271490816904912343147419862561617353907813908525869835841552453903974221176051504882746491956855078196034685771966810823819213427266844552631648109101700737796339942168282835154887911628837485473054896563767009682331747977684533617687789689598951354592155412972249683259113913112795e188"), e_float("-1.8216527568141766056574308076205106944633490605242489785381199587766838175561379812495479000381355514930940931722421894551165464056474903580834705214134675485679594673324102908337722674975097651797434686278048996323311132307256587759817534756912319264249625851572750666394458798101765720139969198641894594636074320514766149397801127455646267300489020982960118829265033219417955084617223837342115387688e188")),
           ef_complex(e_float("-6.4677120515472287445573915569680479913114280915556561415712200387852866583813074316184627166221009260131892885109102466976062045905023808822899687465237190995532086084890299283194875185886403135037403989275369393241236271622610856336534103657252454478267382696963014124129340149584139799618391004954440245591500233091452924630239655728648261589414692889168701892641027093775004195065490061667107368994e192"), e_float("9.357984877421303472766389036415671597611125709567465743129347544731500999679210219338980807160480589744616810241302336340605138765175521504436726334721347920769977179089967912115117116263423711886838402559637786391417074403451347644725510174267597682459152798713235092326519902118276515946108190013282302301094307107685653345308225045644092881459640950164368634954248436496667770214553628373338650064e191")),
           ef_complex(e_float("-5.051952951903833070466129084110975210350014309920919875541396019426843184850282856376963339749139048252317277239187033274324612580391372267433937732457505671384521600187854415755670630912397241469290076626169343164820512895887220108587288248907841624128020533510037955554989145143792883498754348628095395907089927000173338810110930025948844329359744336151987741542113130920942527394611586504459202566e196"), e_float("1.9443442617811246953436725134211298881628404993961819638721923243180120534580308900873099967779782331761209270545875761046288666490197646590443928672054156357995777652628529902234571919286430279228085142445955156771416926936568075838554606557028860181449772318276835739723470533397150410078629995527627573904830605856713094970405154919597386519969338603051147728941565021070607721552352208640793548331e197")),
           ef_complex(e_float("4.9083025846870175185532820663970927257236463290011122376163744906638325625803113985296073310817904321464374908228936349113662229257375074343736898452082491999951605903541341749483240108614503209131317577037397044820151609161453318784218492993781599208232613010825024420427304377932520144444170248861553329821107405037121722446197092316665057738260033067964842403691088465925459025142933656571239500511e201"), e_float("3.7476395684587270902661484587242002796217805879011470902551692310491490571296988974322740320065094321987023582162443049570580020015560847689273530460170758848350176544586046185950522548405206838711807051969281047948849843932243864804528851450613638735805870979646566306096929295477537232560265474538850872446238929530972269323368325143599030558558207410470517842503236136503940210098202289424853073182e201")),
           ef_complex(e_float("1.6466836352947963515847067436339929950499368553987769302192565126139188595944511265768766991618433724720422962237919626132225056050498603496886869325485494935691711075478387104052474196114963799373002191382599190070355189974214808690642824822108480913565901002383226715689415803941985882250788915477971117855824267530654059471817517803885794229118164259590920115746613055520947030845363207996733103163e206"), e_float("-9.445652470577992704406768529473840381253321987289899310390084532581691082152361518920995631957372772892316870234136800576339431016512041160567015943125892012456437648110723264329692586947705799936768051119554971093721321743640834921656046952861796494391607858987504328678981930012259247346895332307163046211960786662140632447011608170632847785020036194291148972315094160842993000433555802173283276721e205")),
           ef_complex(e_float("-7.153751677496726726923971322487036770351390449814112226239485092116889153176064663949795834429586574803182520714605143386094533831139697851661221641243267527491484887528035359888936285664421274282041207886121783322887449857071712492366986344096499249203738664382869366742818204811990663730617455026189285503827984757175417549076759566719097530580191789184632343582305315181856125473051836347748079177e209"), e_float("-5.7916222401815291573496527791590047404532765230901258212751629576406360536312574083876537497665971954450756435529593340837530321391800204806156746573490663495030292667429574684904234436017878981723598509983785805495779956327488513580492981635199417835411708266816112538185073212630013775831405395323489616827177230770858381761926160595187983983000100329000624577917096789741786521160587200068025262994e210")),
           ef_complex(e_float("-1.7264925266899896449314871866176531457985826259658414165543314966615298183253855715095156533131700206325143232091617823211881284320537619296415483986589039601789199936099291057621372620562762987693368121403991703555627420537175222312990085008931092201749615332273868750819746894450973985936179248250281454041052174018141426993221241143276743335084350821995730356035244470652488518256990118651938696312e215"), e_float("-4.871295715222498451362428763443444858067851929723012505252540634960525911232956986822512531898418888991441846752191967076961484444683946252532821843536564626663710463997860395273158914894040278760556986579180206412917528692224754685305162788639563705095746533488338671081626813673496268703612893239105503735852749695165116926748953837403696825036513623170624217579682692149526060061536867395404677761e214")),
           ef_complex(e_float("-3.436952997645841352492357523385372184271480156637193081320477429644815920177341532195331390820963743073725614452058477176899720656778205791612808791570256436277637996974724894548357612556462154116583857336513771526477493323046062437376331656556999843135046717852835304107671918572662850184594281961463638411822071798856620656262318073891270342417356780264741175555097532398812283211311125809963564249e219"), e_float("4.3124534697946509444658476716943165563936928113364451661000478682235821712355649341322694380526231533308529977128739132577989968206788050924616559871936779479511267747513453594854517325354313953873100097767023162187466958184325878777611651736566910893700795583657858744925259253006048931763765237391021276181752640998170290147903513572026401686103733595351851628167672061825869335556720404183997844582e219")),
           ef_complex(e_float("8.127150705327845879222825283123104399986681502009880767781942845445456703849097805191202917857579816247427247930329340993187193103378606963577820959730924035118424920777782744777923119375431126382726453835952014090966545362859425697308503187647820531629108735252416281913706647383716921398194160146067073440770281203495211423388090530486784591853226269804721223661653805601115194447585703555616867806e223"), e_float("1.4876649578609315279489092396930726802548433902136716549785894993042941875286146268065064039514376926811104904219088265773678987030463624532565580338928758641851534105036318814226947013146231908358180009386659313843576865005644285821051139677965408322004743011812133548545734346548631876637871139633528369246640610278746490075525815426398741358453739323813351928397896995344624409488428667505091442427e224")),
           ef_complex(e_float("5.1839298058231299381602959076233261000033789048348920554213683343021065682642997240188346185554730762783278408396909905490399650237726287627915925663380769950644653463233980921833973138913022502988021769882056293693533974813502608096399985372276850697530271262606468021589742408993977125727524974812334747253817810478079396892383462084188671777113596774748982150125796005133571933688394545449028001984e228"), e_float("-5.311386411447862037765845401093461186955586387832860181710046230933383231089002771242609068146232080829509228252825556010350119062815917787893219593974956001122482898886335907628601829239122575528700376340606254462800190569771752098372106029776116384662941165635127131228871427795873274059056145585765480950562397281667515435406369944965505408174201050902453712492986900348810081781124849539925365443e227")),
           ef_complex(e_float("4.669559442852722668330929691990635617881161874502604689895083139825118179507127916686366029400356606227254213111883564280943472897344816644054132165272050809293734965439609719542321444819463397690159068286041874559615273611113214700251774016155143787404685579450476407900048094900261460761474930215638385803078112194105019908372076659441982900518070234115472226557270756301610523329523326118892609994e232"), e_float("-1.5323341807020110380571630428775644150144494029807875605615260682804475944194519472575808908877307887180619862841788823046924594594742872799234758097438850352908500878406021343251142112344403993123418367044409827837599686315224079667558262805231459656064046945053919647469513465293319149294011210775434005592474380020548673447649417402716494099336128512675018387165997520726840692506813381554101364681e233")),
           ef_complex(e_float("-3.786259598781758176704264030127116928516176810841871998612340448281940811328424932104470389845733869057301698286270058744310099993490417492481635743896403406840311496366561899173254460248535416968483564054860361965066591832858642083948935073119170406083650895982661178911560925276764663569654255585276253417267703296960696219903873415761817609431618351529751363669875204245993473092706783105385198708e237"), e_float("-3.148514828690440085179891558991917734358137480611503898218861329629118352551865999651030929904256224541360011561981712011456421060472504139393391463881452003373453889799273111785401819463658197137604044234804134690567195175184866384634089461224537891848715143797903113941617091553534098397787565082889233458128501271698409337555030397013091535949291595831247075873990746195694450207246375280103020828e237")),
           ef_complex(e_float("-1.3432480952472570149526989438861591944251313857604678768240158637632751297569559973566527989864230857662614459730712359197645580279831169963446312469990064623483229513051890167070354268423535158024007884500646827151893162271174800189678646369844163235880928522358964392268205139742082371794209633708401483621430923211535279769667475750628072652471334958251189639756348362137161161282725764286294823076e242"), e_float("6.979543421291728299257303905893547247813025321046322914953242855815342054557686063184626896725072654105683795079882546219697233088801850793260638960724151273802524838768806575093997681402059137676993018298722006731867138315613549017374559623378320189586789611677108656152365256941867380379873782785260923605157040002872786306740743724334912244177813907552249325442590594684112602799454155395333245438e241")),
           ef_complex(e_float("3.779390278856900369420311463089909037233377372015406481321590032453358105899010047684235327937475883067312158084321387706477040585235432632717343483028386936200106966252726674249419931982390512577074511204259151716906014565933904181659363069285650277606998970601133500319546985170228924246752555829931681446482214618511559708007021289253850127467819741274086300360438991256635925887845442115125541293e245"), e_float("4.6379731027165974257952631887600118220488131250348554097867981288416488753668707753479680252667858654509523821345418178775469411981307731822270068606683055462307571059014796735155288523358786928030907882659210752805700447565224471260768766967481702882380304698695864514628594780848204334254407577040596051394888932882033049446490614879953121377883143623294424533183755219767524876817960026332711609332e246")),
           ef_complex(e_float("1.3593679678929623838121721048705097545852818946384008831801616729023298908632224570543152081942137191098469341205379143281528712260805465623668708225637068390416459824292748552188506415447915278787939085574001751702162861618619930604131106632883723921932598428841807042505313273588361671913002234226390523204209111927085353494456790242033575633448975816663289279180876498720362373563482636824738374469e251"), e_float("4.453403423378403371981976614689692859616657002240436878632412612828760811311464212838314193839108072752783757554668997300575377652114953707661207157134730610845706936234546877853584722535247770593665568582700384302757802437044323198721312459782298758648941157301608163470808559954284816326803875600618416373310789555590461707727165071115742933513521535464682125012612920210289944760955506690308282546e250")),
           ef_complex(e_float("2.8812329030610251918129514582973636812716872276527084547943226857755433982660986427741016883875363335495684503346311100984368586908819154846549362483847794466851313930496827962347375428141787017330924074913832620974138691904558075909819212141527439181466128131004517928113367365320853819779691321504645634621856408933508939182599356204992128068516355758997384661501792624267865376703015264227603669979e255"), e_float("-3.321839478689370320145356866982221516812711438869656848244909204591636720971902292985061959309168709172691412174968973436783448242752081627841053703078147901720783566718504714821829056910661236168226962891093684034612419220052918259994494978541411987523500888808009562904859845751491862939093398641492015266924087198193495020563605036243372333777689397873282864991496488664437161043068284552362792063e255")),
           ef_complex(e_float("-5.9817962424146591300413216881545882416051975913057176918737281542752736805918189743065065076638766862384075740541894810476450908085891826435603610806071736830932084250667361212148348368658138934190835412479440903682388633788623149960563515153018572637696262037726940319722032208426938180310804912563666801517715274037581854983505781486654500436338713465960424231021753345053209959648503550149189245084e259"), e_float("-1.2121847514564309895231843639734537735884377902833907123138883000445471529975978664256829904961161410000397432324085124228450226036612163472332800239575051577394034409690198594026010078757905625185627165630473653371826095097328659272402425455247123084956373818947724470588391344483840679420007988185023790056869116376770976121570577802238212115991770847372448914496451986031146822274383121409628414776e260")),
           ef_complex(e_float("-4.1477091246035065222270195453251790288702940855608969938426635167080020222989323649891500412095654542043454242204030930281067651263758088407249293885731140338404202862089811237041493872698709263644584326405368570242436972404675965520525285626810436785567108421543867442296331045707464273976875613273442895650721183647425851628818423111418598088992578233182480557930869500918835265652995493344340726171e264"), e_float("2.513023038684423865689370039381291133370986088511298842168251823159352280515993226732781213708325663783714726879456729111702832856234884123387672429690322815756918728927262695316094764231058803075898344674813149516187941820232090704279575473723647536681080013129623409748462446759029372414071430290749726744611634198401704415299467280001288805738125227698183906391372616705434674478595695222976705458e263")),
           ef_complex(e_float("-4.2283085258753643514310653606592676195909978720921722303011015273359010961814647624453468678691898563428384699698407407053999572064292979187976870421883542557413233233339683055589086175981223586186379654366146919307276089693185993259102225643527388101733091947960280933064116591506158602542235985896154347854173674008441518464784243668116988262323109851314177659984287153772187082712938202558154954086e268"), e_float("1.20534845135194276003313151423244177558419900347090966764032450196960190742575438159566242287625908640974258433077003778471913849173411272740572805906236704113305566333589557637456554166878400322006407917951959622032847110037220569990469948096144130286813569054141484624706417091415359643388251613391244214280791482716443874905429181950971029606904488307944460752502662664133921783642769893172883411182e269")),
           ef_complex(e_float("2.9121769448130204959023626363631432407581621797715255755193051561667150710768217876765835479267645439517362108193070508932960883900546542166198815199233462660664865650587834630240720293721875443733078487858593454197989821813363299738853770743839071332537992942154584565150647141192109697020857650620215353706512924461706887972642473391234579051903383263265376108644595767723871910852148584365664938631e273"), e_float("2.6339858255013494653584679935886362085460444764344261394636201250579547831019520494279773583154322426987716315970135350871279572277060792005119771136901937329220553997400258884745662138789501469896158942080332649031262484895665432375139664976942059744281539117699600034801763681564222866915498738168149939535775911438109774201939810732891483809657071029939265525037951255855606475895214113094966430627e273")),
           ef_complex(e_float("1.09332141719479251534928971723901877393727937104816508709938203708672240321946524465764717334873411095376841271075322114647047295809031468422316957140304744225232196446622400210262989593000537089207330715021417447169766011272701643558353664299584755775081823404129627830720102542188210638931388065879951385387029491548163310551115489860826905876639156018086453593874246266335240705359535408101799874305e278"), e_float("-5.1153618622811302112319765624872505136643762648857710219992609883422861836751804040851633735012914714979970596562259079815724785875924725443056883552225784178974583362256272760121794166127295810621638174140114178948865264939258131087774781225480878164185235546726441408560066841813475823125707827541782489803426002545184424316836881666611155809720799433380417863778687150402357899832066710890660943038e277")),
           ef_complex(e_float("-1.473463495590434951785203529772650730444875798164800956457407962385209173736246852979767509176503355251497352422315804661682091780448114178979422826627542159529981672043555680418565024175410625796415318645426369246883070953967580590401645292662700386060427227904390558270831968555588270784939710669797548017735567366592768649614527431585393756956580456391005293663537859311023671573323819803560314363e281"), e_float("-3.7076597232597641740988756035376390738883837381671534188799456378997777243430654798825071254355040048966994759554391623156560071060104876459075100859163576478024831483522754752826818967854932071480909826395227093923152946641495130263088179905425727700200321534341966943855633789891147595497631201698420531674854748337837764149889440557740008209887800856533743141841894105879450232888829324697414328787e282")),
           ef_complex(e_float("-1.06826077238701367051568179339615336662949901178468954480029390993649886948760060274507380378058925274886027800020304807549549512490006430174244658636067962838698843020470162025267386199452683664461756754182411742135306585394001308471889807132666379636228470860125823764383337707099272059880006125779799258886327424045156499394852247085509668272547542224574363532536328944851459934601819189089877605597e287"), e_float("-3.9987510479745286791299670098754999473305261648941121078694774464172973060080733241957872500195218944946412321688504652196816104811008050386047276009802921379598109493555590161898642747883035181489659607747576339181934770230599147315185846358968234460111844807152826444586580510937297003497884670229111324893576869948884592186666936369059648644647203762892438945572224675568350711812993275708519033189e286")),
           ef_complex(e_float("-2.4056421655209930361984835652675746177343261852593896885252904471129661316820622105754170616619843257807720330828926731565941254923796647755713402005255902759839105388345215518771061048828378519795371708723762760963590566433668946421786060887427313094335274188647448825382899463342458117485847413747536001968605053849585893729481447727190217084043929328755682578007633724822068533103301809275562031675e291"), e_float("2.5510289234662203173245593172612242690353300158634039604377789352718349804980801763751086197114219105049599752190527915061242630663862570012627861854735040384541257770829772966532072351653267721720237311059301491139035726917909075465736648782101552400165844957651489535154830629780817582485397863007409336840807067642774147295389463138992149887163766669308322591553823710428649482886972278664174529043e291")),
           ef_complex(e_float("4.363895782439673854203526630687136692062109101736702396593199161582783945746588373952463028027155487447860170287828976829721011815653369056928202675664047166902328191128256484309516966414869761995719575812304015989073826567431144511858698010642062997813992357134544807915215781512985254030200453165153206983337867138154991565314810724459803809422780569489866438550302907956987326175113739999027237688e295"), e_float("9.8559382468509493346438874059441095502203614828517603333056823041314070512018086443443638801683113510606513075208862660375059573055724469154044522203028810673623081804228223009875924829867462147631168765099917551657036647741515783634125385061178853317488856457386868349038724426627567770122559035312504974784576580073903997591169984399427112864374766279396190743132751173128896392047885966380077742228e295")),
           ef_complex(e_float("3.3128620347118271955956789394478130681481327985137012305598787955799123088721428708063706774788134691367572301876876026825082479646668756380591650368799030328204117658424611162750051025598701428859776570148477818823352931026668056653032509174848409057726492643448627359328668729957306824175256118020498437807407327128478332541453203881821729811865356151317752109335627514764308454778306097005465545602e300"), e_float("-6.27069984234548629424679203033784837630271728400820414084952130910933362288796042735134730510937563188276838975235206188517856742021170240829281667910933434076396131311427384263364110199032430145720798377326043291938604975786870434864837117961716822703653394216910830195334598423058953348670621361113413595725070361988799781243033755591926915555933068711947287914470962490712818051866743145487129047e298")),
           ef_complex(e_float("3.7683532375043027104446341118364800529294751005855108154349236894890512714282425171785630436769864633438510440036707849415043289939285408759625504842573826140921511950582398110123447369910343556103782094311534520889208550625311321314866030557361170894472825658855941128344570620754239062827046626231946269953695500088290974241579158713544058627385800256554298697641221755329238817765536529239045329327e304"), e_float("-9.4629779324914668004562433586915924347265034325659056327137695432263089213956851794822963774343326394370802037655085803977631756448873514239190202745201239023536377507120309768741564823027438426837994969360684401791007432446082497379478759398378720827666410579895976948530492258449077702244062396992393157091466604508126546028072569167415073282560266290824306988775205128198458557017468265059392634355e304")),
           ef_complex(e_float("-2.2328427278579302469420310997293629951150073250526715504246256204984639757107099497973098842798408796337194577323249250903779743431331331156842099637464491972564668305747697203086829447989599723928550859982215796469600905621045261321554976805378038711551565343399288378055605610009882788844602666664186876001405972057041113344626693518143066648789582626566495227126096635142038642440957951088926103101e309"), e_float("-2.1950758875219412584097865073179643873232458852841989176303231185556660607221016063978931912829361800641721359572997871613976227273780258447732940491321894935880876390491509575862813445389237193876998259203475041835668950512390931461119792218354594002785578015026107959739462380918877667380838596403385009302073415579266712139436189214824538021518445411600642239664161401748883812852433346849551955413e309")),
           ef_complex(e_float("-8.8802146923656345138468058110572363168893022484710994036684926623411706015596970994762700849948568992244884268399358898979139180938136323293864915951609295015381266387173019151222103749342938764773345636822796077845407116014966968201741708407024422643394916445915390592683035269154011831069834980214887420867313012095442164956877233218214337898786505981020420438008564479788963413244559623434634641721e313"), e_float("3.7130035587155321287392841269717078362264211640848385095845360095237514403961148258172010346975584305764402573954241324168449999315079737159476020064685496060125056921819702516923294366381841785637001704400268510710880464511608584050925438751347227121844650318939931398594596583652110832009634487869387626328628085042185523877240165139039318388367258105236467206626356826818983470951638743625653335565e313")),
           ef_complex(e_float("-5.5270651429257740128167589257320619953318400897232028423017389452406793449278752633445521933407818487378688029351676566857850728931859725594284571056363049598861637677721023923562601510033614568245636299983779218963851439325931805703339569160622418851223670418128816193530478598488486623665925438153937179835901512186913746120091039386148574540339200332639778846502031594545914762100018406058456146e315"), e_float("2.9588228476549780857101118137382855417156100202574061914849165034101029532540274892934388737162590398636324559256515425830715970726176031268731996103396314003605284383899084302949517129463634725354870619477583425869725398128202478608036093505764661621162667382655133422760240674511729127414730951234098071508659304714804873914125429099317973315308771686116205900969243926064369793145755551584586307891e318")),
           ef_complex(e_float("8.3783941112547563423498798726393824376807737946120443773252980076486436053998115059338151465101832447026177627734008646981315044737011699707471540606847981536579249078174064089468801350704353057122282049431622904196596743536024795900529630000123782187310619364959075695130601611017227556450858815006836237506715248203672551877468932109631656767258401324539593906835902799258112375077491484220001805245e322"), e_float("3.5400134313130119275572877659772926972873395802221133091973672775953774004174264485305872905021789039279794738376065337064298775053690429810717979824842231332261178449797998401918669001729778949368106656537002359677591147071487372160587522057906396743811600830564508445316044225407426232232290810289220614375136349306283905684703193852223154723762067496606914807845865854619064526419260521406539304378e322")),
           ef_complex(e_float("2.0011785909284634676956605374151572419892203229302219739898810724927285269633826763103194078723550719517317500456641337993610114791521074171885099592946146641553280479889658867742690791080483545408104224513742328155277295954864495813893944111648828973130241883550186149283388977671939084852097653605280413945608094820550439243918960271238884898964123102217761424334386799759592636524408525821394074054e327"), e_float("-1.952681934971861304335852581087370182228294699126135687373204788636258825150171089441119526305929743388415123544581691335811485679050398933406425598533189074687555118291510574754389627782643728530145098112929625508743450404092723731894461993855056615221039120640773873772837589257446169738104284237140487477693472995757195948912163149995276822858924439790497766068276984631879576611138497514729303799e327")),
           ef_complex(e_float("-3.150016164845040955589045245890168920374644499240052154996306548330822565059471885706641077292517961445883777014391218113533307338386916457943072180170050225939524303687098291047720881102391874251742813849388311939805781228369842277121932034364372230311550407473176328146242641713915337237909475407245246221911560008091079954873556822625497958237675821051643420901048241969725426480578198273777735353e331"), e_float("-7.9970224891617370301079345101353515229541428203041245183466657839701331468411797891719937576458597638027958219537330462167972930425870711912336121154574025892368627340823516350004468500104446607826506798346742174984820732118308237923938923153848768937598475782288721311912837687700551444573206901746627229882217690935516735167669352192880580657699012451019086097704935975306054992131259846481160438661e331")),
           ef_complex(e_float("-2.6414766557032734400764989383171202895214013837343070579763398235547593569374598863373958941588805923877764313457249043409298637897370400432045686484670972867010837935329112031970947749398862473405888465727921265174589455556883891631251563711258289163969319782278590580702727122036732352758237428293948888341402970836912087607186949655934317572303554623438484498606810653263440759058387765177034147907e336"), e_float("-5.98715804211761468308042296473324585754473217690609966126353897114006233596693269845301763848725575844392237539904438555445647010770260027457851047183026486902534792656289645645796169180974560888593858813416825590718786137796040136440976534973329192038804955951532769680927331209355128581672991723385047342741129534712726880287844614225211410546279721607008315400228511034454903777127171258892486523e334")),
           ef_complex(e_float("-3.316018399852009227374659571337801413582703192678470912585535591699744472226671117117850964444499577059978896381450697053094100758815358362477939856528587205278560822766530006462360805777519720523293893061919031740261677563270502444741769011832416090299203963464896026634610832290973776516131902925874617109139199517774007411349077208879240533785891717484019925731437222170531949045812057684419475832e340"), e_float("7.4143384844463472145306880949303143758348681422649425688267611828495379472707827804776065811862862415008193719358661367319501732961079751579783417968299485800470557149847908086969899250749994226012685787809702694816547518382911367887843873740308276651522172780497813962153805826908339598747552781460030180120066361997097060328377206340851704454156976841952839434974119508789399741041697017952723208053e340")),
           ef_complex(e_float("1.7061599826260795259382747835513361807793494745351734417608381465891050254069020898680243030514411760384935571358668088252802014655430893649557555838339537677861220176300048926156538224668493063182275265161513798004428064976306771389116929273320072244819229994313659459776161798651955432992564472435393701739690338083753566630095701882519327727573776622917154051352510030334014644534321933497528451074e345"), e_float("1.822869061675589287187604830582539002347545587369015550744967066877963474904448715036812161433275260867478674954435639187289889863856265399163131171114995242770593569497286120510905968164801389869397938302211457041864776668325476274554718181009631198326420418620124728283104478439398410310319516488906403733667521632394457831951213550489727281520114650261222400572393535917017231098203597052978801225e345")),
           ef_complex(e_float("7.1980726186445401328706747467877314664788742582708762305236465534882443180592109168040675660539882306846910039416037498126735339411084438819990417711199981799507080408925526376537608418912312895946679512228633413225941764078525177981060840287397179216177096739430391707221549211270413692450522655332282314803602152153991754487753810824794387899994836508525446956288900590442933258407924284450657616008e349"), e_float("-2.6637904367778336329133665962045950940857874253902254119256254208798445382976683069213734625268352065300216377782503259175201986676845161998206776487983806143593600849104418421864464182631330890970670916324226624628272736588822640529583593625433076475333923943520747928401485682251994086834969241867246226170374053901570675875221280948985558961813436156555088553635688439947611472033865759824731930551e349")),
           ef_complex(e_float("1.024970651656829433736340915262424418853494701190471497559016392826323199519865075586123004353243834010464251468395681394746176785301028397858656272608714060068225291837769079953768637208742175757863671269483313135935863787899379615582655393574817920607590337239709905843319132334504913501993564790659422777091448207847809511878799710756059289063430150843553101987269257366893554900380143859130552041e353"), e_float("-2.3571471438267794761407118274515434278987068802310481804382469567759376135555795329002416504617855520384745948720071205253575621162790632281775946846805545026861300448744076599214880824499401220360681707686615301428926141006448951697598321019777658869191521348560298972270997526939197333635503086261923137495670572546008984473414906494955982194527004479174459973925435878066683410585097194646351784945e354")),
           ef_complex(e_float("-6.5578074063390788076904738110996136539478135947938668396841278312836854282569970666735087861972160894243533887008950732161295304604372051030786252208315916889456075531448348374051397019116073190754082713293054689674597849189447545074580983501072626499730206553694029038299800546788340478868152682584984961521662728493197515184298350915673804936876053260415979294835310447950429405388871123780167478669e358"), e_float("-3.0981401723555587794801781517411181414711883850419894587649065442698501826321729985985383998301105129759360702848559181853864612089824387722856714460506193685630398577041267290343040333303228110789261709302329496621299436601152872967772758793117784853686514480125643504164419747436419592905525106205053160184030310886594145935852245130402025592875698766494245905342951525326563778037103944266542570484e358")),
           ef_complex(e_float("-1.6591005666733386305383011174819687959273891589094137515293595448409840417094562346083228810838503552937901964417941203215208481515795370015669060273939821705744313016784121466431399558784212124564157320798701020121470395375458967044978138641646130026888712182508654943368693108867066784081670638102133026075876614515950078959283857958485152798765797705403445580968853422137567255232165523250775710338e363"), e_float("1.4893807088794811513271218626226097448147254313099205807967090440747097860308728962384421669331309841444150687137714326400466905656744226995393614051167725368221832825494374583158280513458495313075157770843198586897486923731965164833003145596363768013093402337386627621058174759685978008000301959131453840885384396361976012961500146013441283512664513616823666220692144318327697156120023192536478518362e363")),
           ef_complex(e_float("2.2445318792394524873886990910121388189948986166888312378500682315707720796045964996378168620229794025475356633249608793366270295627301389923514322757601953573035012734994436634045038207605514681639275041991976207401556383074822665215800959088407089815710755495725982564985953875643277065057603785951882730977439256543075091300572686770272121699764148790250880956306684481455762458859924370740713161422e367"), e_float("6.4757579092107700687339069883588182673169181882143038895808011811887420259558049297459408657806063021188306376468366779459135835268680130511325394788763544324059361244847833466350375081997579443167377728533415831898997175211481168092217379559546772706786130013968981024717293942584313245908973797640265644169887841593806438987597138527062928466772780222031732403109494910586412622864880634559938564006e367")),
           ef_complex(e_float("2.1025118692458177153964963749284901977255676511179717852785517890580802120206088548351108964011702500720576953327053194612731288267474282939737543608706649184548146548791913747501113609204955960144621272121784543077818748085873366473081391848947866147775187380472378960686387796609397830722991410871721382316267771027653500750046945543249392424813815503190339135623930555286808018144757326753877739398e372"), e_float("1.352730562938370441528963008526293914783189479695494232907554415803378747923343554783027302127484071128311149402350790144614418531196860251499931859140363195540664143450942893248003165916931077372625950045368208542825673532440038413118419206652910428093472713026253649840654743593212554630032864983363227885490359092775603332967225067716626285520067133972614522856429234283892263931531627822940011358e371")),
           ef_complex(e_float("2.8877193403373737038518743064631303004566915804390738158135399876620678951122587329847234192470356263609027048074437828944941756164374608053577252706220515410969787435361048405497231271711244008740747566066436900445197462114859158261138222336792638465012827854554002832193142594590960500129993162114237630060301673978307265435514250199800437945665995942369563441130822540165998355961071633137523210346e376"), e_float("-5.7971585742148909989922115992083509218890001823094164021144794388817154921362658053356159716657058129869093415693122746946134856733078429344503925109603828136084775351642857235026108062431476179896131184902999124868146864830573477991998610176358582244077739060474997949949838924794270081966634440715662136209858328035722553128734686741970919775949333022836185271120474487702534308391853064502169755059e376")),
           ef_complex(e_float("-1.2988851313367027144088757427195191945939177462043867664010092084543590949993660662245677402960760929768590025765279043724420728773412936582571345212115729924008137911662417869039699329432784425504804657840839565219986197475083114333899473766238738060236741469069100334546358724965530972435876848441413528802177666371354452534771152833834672501722035410935008165394554691981157245244949242833798466377e381"), e_float("-1.5088662621438695985451712021417280608410773743356718669577290837230500530107908605969260800712178069673865975246119571923725066505891860007670925690997549482352436675655723394780347949158044369550785516993905739404771046328225442784163704880450651028820659566212211002930243197154562516299886739829143090621309792375016549584263617313440969161498522471556785158976051233526273273494366369485820784313e381")),
           ef_complex(e_float("-5.8231049699748286907017816004583474282464185211288284617697147917659425540702791317232320669503030641396178539231113050847937400230521563712069068708582144714856476691896021421955921166963329365348562687313619555192489053533895668486309143534476106321294071275410594868531587848146900416617337658227336808543295116184981626298924610866523389329291495307349055390834257106469195928010545223790698544907e385"), e_float("1.8836374021052828943417795247215034281338249455385991371412465819580863469418914210065088722758289735575965941515498620378944594021210273951008342311417086445432846097729521528848256697913431930509008545053880325362292367692346222417223318619563613197560221599006832029946099007639658138235651752975093429920783931428074835155286833488939682771204316482025745590998788182506321185787392524670773363323e385")),
           ef_complex(e_float("-1.598069513324284661699769443091448153464992467276974031468223616813424400194666706882322026935408594697770388613264855355021717950882320919350666464178334110631175371078322827678469416019346734485786894109471624413834117971063391580479971979012547852577932318604428751107033963754517598684836187440990300876600464342249356150559427198538008347760009771322110447829093724556052640829581935750815999631e389"), e_float("1.8745699077960615886746833655767396666629291283546844883299178206193572356901607392609415957153112954854711240572718583869140719079324207899477839557887913591269728312698076596302235036015486960391116009577380157925779776954188387158900230027108093635409949287472057616721256856570515327883475034481041330214756981333960141156282625318312104015798999741474774891543483806227888165070758786026749426429e390")),
           ef_complex(e_float("5.1219730764194001820802490939614016462304595531880033475277654414400442583670359163673426872212595071452717719934810934074011959662434235163069712718337420713603874502665256583162055792746609612231015424742523646659421118749421881742957521575637583325796493231154081427674223842701984988199994391302014015752618977444781457093655561802898964425877677680862676675380445699276722788723318790947882019757e394"), e_float("2.6857365924961934367273612978633640695637260539209286925771835284092214571471365961493078642425279261622018758082539080969102745100928963358861261547793683361941541856723583057493075574686755673969401936728159558813641379238811774522621789222058074766910708458504393701104897018314411857259356496604343447814274524823302290098071279493162997426583081501040477116183632575528279856842144481909129754161e394")),
           ef_complex(e_float("1.3712030339187750493580824609156882097594976540229807570056483916265322312641217916516613700920249098045734663163987091514582884219414443347282909131628351243673172435940737240215252450574081409078851320957261704132596438317390909327467946535521541200516549369949108725668123953463651356965445706416408240002159180921962365185901129896240597703875825810585879865990983519238464898868172227739615053974e399"), e_float("-1.1316038323326848565125307773759217231718819146375100143260183676687608385702310712489030328421974694395322584467801339754805087262253375189221294235268324844915325446362074198803138957390540395735107740789938073744180927566691656012038073913923066942150461416766956782227337338764982325231175441593938739109561036678203024679314314128037248014324369252728737318677303191455496674170158154503025091062e399")),
           ef_complex(e_float("-1.5735558109624501184612578695639222172975437252703454435157529314999224196607245006582906525495279557570159249568270712630510793065236099354590405232315864456541535106305336506345166431759140781536096141295739246374027112705014918657787752135248882887045383215670998924800902607198329757136151864426487467616509559673115115256698017298243241439671388916334651074296535534999899555337201804917743983007e403"), e_float("-5.2337283581890316891886859724226309227191883579130689151024301863248536633010286680596370313162538543765221222117573271294333738856571839857620776877046922862577711230822464983192235350389541606048778440126528297777496515409871244443638326030758610552327031569667675246978245911582499340993961551336354338355119491057141464316161445572004913372760137188797097263894022528548060398122611653371643615469e403")),
           ef_complex(e_float("-1.6706122480570746176371519410854362380441507235680859478920884154453730756617781778697733868018821466269391835340775604266593227739436586785222394874456223155018690466114957374965664202043908772650840816052995461997969589271434499103708644451699962064191538390829153400521109009550010734568379381415510545731031473333824486380819982073713527020033418558860867055894336984590382159409774480520825423499e408"), e_float("-1.774780845855832335443596226615815158958883083498599599851741661228277560410019025314046173121232940702871453386723155305284021142472120488474112142731470198507857661240011118717617007111867286884749350185905797901202398776923080003688885825735161074147357123656958232519755577626632022496317137283920985895356134717287118085150317347663018652782882730508908796523019750858870054097087501159887534457e407")),
           ef_complex(e_float("-2.4928740182984428718224385366059963106708349525304934837442711429233445830836079341558211990528010462551879524751364742708933949630795872313727684873451501605562243472583827635807536516684347064423943143886092358625280944217950991229474138465335330138143014114980728114185973346261391348367726866928699060213077089113703553625393516074027649068316880719333051117307659910000723256618473933170128801022e412"), e_float("4.522930903353476358999940424070494928319826011080464736293124649841912407369006078691779987768169797062932891928114771344842097243389426921425169532231479292996910404761181935953963616422997446220010426303673430473539845780662080356101253714726456576986685280494915795695207564833944791427505216322177581445287875123290982930581915059900676178231119893048470939922500442959517426435480957062634518567e412")),
           ef_complex(e_float("9.848143780513023225109578185855785881794364084706128981264693868641689572496252373863538328673184938368468775081219729441199772738126503491113500165651163924332394387621444404719219461074474027410775794181260992153313934387039775958481982436701783243353681896052865688838918479212907453044960810725991536297784158931321965552103776033717852288148221730042273012904432446500307276803397077350459638277e416"), e_float("1.2451940419066296723126606621174462460062109013346744029501120416012437588377054268938604246908455880446350977372551552651425487557132875413148193877048186096554055385851358892157164656455571627590966406488902252376844607546581233531888032341252896988281761546157168713506298003288321859389325688875118342626321674824155041588702054560158087060963734855551267154093814409869738415274284751149726801686e417")),
           ef_complex(e_float("4.7017870705082228151953623348698375865194796778009132915446563752584259257693170331595015534641251902599382248256206957759244799741734722446939467228764739038987547893897796548786555284055112440767858598930728005545979345132523501464958660842506908289237273911180496843980485891840734647779262144323016220168467942520873668405147259756190020293966759598565342171995618308364707050553590628646702158913e421"), e_float("-1.3076641067906469433500051694628502731658658557249907901134068245459653205877402857653965928344987708191951753971759854840464317086124073436773111294095369739726359681576976731110525191579672247652601583712831673128787117227457837720308235754175840993377666125641402715942902397058637204745399365677142946760328873592744386603906130317023520808076438425918936875325987275395714778947878374123557993378e421")),
           ef_complex(e_float("1.894675999734553261727821442752226046929553349226558935081627967504386583213528554741137461519947457266132466809923114859962300690912455643414879435610686251020482409726218304812915632786597744157156476759591590410460304822892942558314314195631401092738941878894389649329897253396994988421409894199042260715850954431167553864686692719089349660375746319837873849917961175344573680439243987666366897824e425"), e_float("-1.488194727108398267445753612131685519718551203475167123326723738303960123315729983844599671418262771061429892903042570061759272301085470327391426291691076609269850565055576445237074976056693289446205445078569914950932273799538784354896250690877683487906723569575421922670622506770947698438238430317354330841864353028747643188974282671888859380976945345573296767802888382033577490366644787134866518607e426")),
           ef_complex(e_float("-3.9916986678794165176908277144351009664874797073808077445764397016460259034299124580258674012114694569885354060466590048484158984592839041101406452033201513047146921101401417569050493735721612348061822068599666535074860865363968453519337820127542642428704702003738851037874483782271726170027540106619211037184885625569398495786095045873402227461419387816465453967177780958551096567294781940004430573168e430"), e_float("-2.3095675272048778413680153969389780327835273655901758963063739044205550269350117694572368442687609914899701610166442003128440172930894590497650803466961096454697067825953137545027131096080195054398037924676421850844053315233956263911602561748071672410752212017285446523253122501943434980868590107095026437063954212135616428014600434779858524671446286840272194126480782967257282778130516454523542380159e430")),
           ef_complex(e_float("-1.1299702011352111038451670298467711188935400545415415410820596883880667827117141285455717145080409238269209586654932847682146887769053660803296645336968394962057332805907655095983481442181507440882876140533505946693454431477359837298455068283573105187616681998723646275724927176661499899720812063210824795024587718977186836791804653889599658652242202260585271182075587674779663799775803401417575598717e435"), e_float("8.561032559020190277086928807580715418534189074431989125692318113796118797428987371449790341289249609897036947686134210453396561657454652035640388498546119909370577954537628344419534643878828640758402334962697834256369253397203962810980677653716249720755561465849907955747274951460159814317976800449526986190818297406278847619034986535637487989478348168505901725744868873355418415022992055344728575629e434")),
           ef_complex(e_float("1.0801578565683887474866181185211059325275727602549820379581563739065294973595421744919316898735857416805957170904328287955749411887571058866378010646680148000906728533845040940193462719337440789036535300155794431765326871989514377927082738211911530928369663031451976269810526475134170695950244222066316583732069178729633998802501151220854017667725778775608983911708472946007042647889861657672524630332e439"), e_float("4.2219434024687238208431767592019405958150780080048764565904313774034609517050952615046231730959651408152562423773708441976548537496055717055855937570376605659031320947638991181171448716264101132802833536180948403794484636136259366248795090140043970644329963705452623663409393569144226221216137809085980034964624135347246142978522449550876585047786254069591672125046578821592201375072621470655887041762e439")),
           ef_complex(e_float("1.325113313445252712120232518085663531024066509772208535958056782535366546915723088056123363685546976196357059693035005521986401091751017572265655047001511205640870345616539804068852945716108855895874598433440768797827959587485581164701496585618633844166339285753597567648851464844560615657143333479421214518089320427521917443880450199247472995792128953030216032417782298668425033127174276145910875262e444"), e_float("1.9678461841159002200352949079681499523392710997102436521467569506737208747358306258546476162049259904249619666872931570592421728744297364674810795924474964554954009971650990756356915618780516168097810357222033843208733457422920544476627588672762731083952665145532412987820707787779996612443019279937995915016363278913964809813786681741721372567808258808239036002935623063814546307881327248879594067302e443")),
           ef_complex(e_float("2.1360515628125442042910609161229485365867763833873280999272311826777632020956550701308301302519042236425714952521531516414821299012340337592846051188443882673117305491384250861216401916910059210570629339966192426106839703673691412205178909333447988177936196030206680681000270199748957414894631722861186818495193475091806466629975551772575082524316805213516759798310561649214218949887646106490245748046e448"), e_float("-3.5208283910119465379086285687400253526911610272721490473461347962125046191388354416499817327015649273679080490088694309123214660686533287762823944040659781239364973146385540232607741071444830104360676495169829068661724625221986607402540568854121159426421829705013059842186667085259027183084354696465209242539788089265401175860470150354713936110843533306356813571076424718098199475843363499833334686769e448")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02101_z_sin(const bool b_write_output)
    {
      return TestCase_case_02101_z_sin().execute(b_write_output);
    }
  }
}
