
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_01025_poly_hermite_h : public TestCaseReal
    {
    public:
      TestCase_case_01025_poly_hermite_h() { }
      virtual ~TestCase_case_01025_poly_hermite_h() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_01025_poly_hermite_h");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(111u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::hermite(k, ef::euler_gamma() + (k - 10));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 111u> a =
        {{
           e_float("1."),
           e_float("-16.845568670196934278786975819835195137915681328120152802388465530230264546444670658126105873416506500970737105500385835038078991971026914327551652004710152927492999332514125324524652114414809483505810167982529592103668658293533696446776942757600996984030412509828588519940157290427706611940791349156961882448929465337201491974065158972491720901776629794384031530244825589923137812005277254893878221337"),
           e_float("218.39090914153277161845673078014722131993947106084340864903423031937752866101248773868044102385507194027574563842595631559633842278084519310277219670216673505052719358278685553802790400326944558223019840777215008942889208966044632526208687179087905126157521329386294306462192197342347972519145331702520987897679649062868547843299978462286876622583838071601874778406843168298272137039536438885756703234"),
           e_float("-2042.5563331197430108222015790564075130887351864371997259300409160780811886123563400449867196886322224677864348253337389741964950810344578936341258168183920247530935553752018397728519803664627144342562196767954848414950908174013855507162147285947870326686342098208637623665075828755318271225873042321258814771150955700919690374115979571760847511260416026144140782443259162157533069743891684556570152875"),
           e_float("12436.444197724468174174613102878342251284823353422061203509044289416054286039248076397543457985879718855357746818887368769785108456078322174714314314943651521125113466833660550180865470224789872787192143526301471637279978653833487085112611101375953396207422840515104760301295342149869583247589600240117449515399514325114571362833556227430275675749204987825254520942254191765545948641162892010619202163"),
           e_float("-40842.247506191781185226932692655819229172208031605843344142622111565705171120501530014494714551812685109065359777538919764292872268210952283575998698777221976414471710502480853641945992243992489182805291731128908522597538124683050298581324293890208385914701495332003996797189927801413906371714788113797713925532873534268362525039581424869905492282420202461151279495798358954038529379827265262177428677"),
           e_float("45344.155195182192004547091393822692005396035550975130110244667486188208986299217900854469649491312733529014071930765528020289599084164194758374257033601970242086489338398621101280802430637186834071909502107168319343616146178286971747550422986643444885473700912724895443639607088259180623242550653625545889075350844371340747494205243203665400993544531883822102432476566569609817136857017644438176076459"),
           e_float("5760.0039225859799849195282716469234648112272132721740616781399754921407880390452832348608752055464821917993403300643491333624690610842857421850618861328855183179297489538945664666941733819890451018516446089356714549104369345689742601708058653054855045028345051671733995174662504635108568629304281188753334100385094089647322823342645441696509516943362572643037063910704336049320031837987412629323893136"),
           e_float("4116.6740565903763450408449608412027157930498814885099520242408362231267565122736766102990051136725840413986712968707263165317314943409569339086221297516085948057952285071528237672285774079424894816387800928573763083285002059507216790835644311737467711952741088815201896622034975755379152290039130766665439214894429416988566059525706811810806920154587996867863797615592946456425330001526486639463923997"),
           e_float("-7322.4767476594449789238943284915411954308711291936649199152592562061925044866103165381377065640997676653645786490767380943025153463102812439378952077161137333185773461854188506179781229014376157179713172444797294532207766080769053190535926574315155500529056382077281172691501719959838422318688917737944165564100457413486832633249106002652326920328140205791111034319244794684025016368611684592068357022"),
           e_float("31440.040740405887945465710434022894945780280351653089626249093885654805688186716781803414046195844826290645961705874235693877593996588932216764451660607893009057240264647206578651126618298872174301499398173804382725700738357828090216412644464308612926302873428975832372557838610435523390593842426255153360730086564302294758656321252711006460430261704513514216816751319624583182481970420856766848544654"),
           e_float("-450947.00642858874127336698074158743355498127225886661272772626180047354877043333074142430717257584017334926289592936405693285174699840098088299555164895938382204388231359552676956479071733043835669471729632636615335377822545632158996138178549305371461686271542966919392532960191296015177119307953470216996498580094533007432921564237872773265246541762052608198075683043030152874277958702897562454519956"),
           e_float("1.9177408662629403239477711841835515470723391374592258791865223833469396930127771062073113704844032673022181674752935689797572275266834223428803735396582099873909011536652413015206803925383790507906524754146202154013017659542193849569755317373976853460206376958572434285130214649432242803200248166189544767740872338146054581617000070619123567345983041185064001257842218108024679395723649071663279528329e7"),
           e_float("-2.2573513786654027636988339789965667932605872394776588488159086234748552558553794965875136255905924543284935876440068012482994392321931637716674275173720906690621306593423981410816230588102134074444898471699481970242373786704857765193429735690783197516082743349898109599991881029268090221906802923466963653612174621285401784712190407859059758072169678682653544873608450120349526283774749828866323042424e9"),
           e_float("6.2366325490271877546484228035368966341195393996340873856220914844145122591945672814805257778314391852204531488687957251790893962214921251127376360953276882749144072518296727656005627182398401282406908133521820392117312906918291768665147175600657119781851899854480552089987547133504213973514028596272294274077754395804111664148923571237759299524503014710911023376091558667212793828800769224677551251058e11"),
           e_float("5.1802113346916009625554366992352595255035552433249173720512911348227182912930270659484293033563640109422469568197079874726556918150886264666554410292242188337209055540359884809554440563756558059777162226809159581231242964808497140870879780483936454077768384952288528796943209844697498975113657753900899798427076420930721034209950333768461882021366770021656155265225820132465685631743508208010826497579e14"),
           e_float("1.4433041114352944524473835413236656235135800463690454638828592384518121629421427681011398475880572315908104767059075800433002383132140795957311458251789512087786667667363624354696437971886388762265199861305740250893117881889743340581141499196564742549818499817403987626370455924232511369167103646059737870505279040896098699544969130127298268680491216452281650008232129620416046281068041353388098677935e17"),
           e_float("2.9117844371542176476102676322674334687039294411227885440365067239036242746938998481657948469205513244356736020915104746082085127675397055041221070744335525709071013962373650351080911188720898539626655977816429333510882359137995549445359094899372158244983516537461826569429892870868568318506558649968881344001267534942668312583498415625873073259413578182666523117855175960716451629005015882439968285898e19"),
           e_float("5.0638636003762125195800497100802715017039773728173908946082899255098958054795022837103465287282145390098318330959888664510271735952361570811044119896757093425156846161048910969487186418246499597280998819681774185357707450988691658774791841572764069171606591253780184559968076843775637340310931572200969042368024150506623214348800471940196981551012881771457794739145845899696729192533265123793131042554e21"),
           e_float("8.1693199607192509137895016497900563790090942482281133904037667286333509387697891590529574405430466407735807842094977022082891186098365280647662575965673420586135539753919004241305931548113928252162451867484865830826746455533548536978660950384326742451520985494067791466061986304965228304522312672827262141090975395529812208894152254989950926298497144742435575933404015419010705197488824868846694164286e23"),
           e_float("1.269982190471836803505513196910527192582417493158404178727218597244342515567096688945430322472158912551171122740000537462820881112708680250298365356798661812803780376075528187721490280288954070546552466048290491342214059206075636054774609628869641889934765868001366669304398206883288225252481256358803989352226676054247149402305859191104847363086858066064634227804699680650165866803645198090858640738e26"),
           e_float("1.9448349599752041350088530791078624538959959829774766329515441357981132989388018844179127697583150432178567224222253340301793183602310613258598731876567830759393599884571371644069135066655467535675955846121792959613987636300157764924786905702120045942500488678966997762995765485757029173252987056097614947115121565132065867196372326363510679854716232014281225848849505873155695062673997418683087139664e28"),
           e_float("2.9741204319397999043870056814074534609096865047276936450282211662168793788171922428757625839277840170790672106709156134297860857266402228695365838492716835064924018508539114211790749228133645941714002129237193558520313244104904614056995543351245404522313514644931794536160996124887610106113495413513694082975417195691781171476117530252652892404805778210705195307915264139233761700655724348073082126888e30"),
           e_float("4.5819049884018358655563761021969148128263515379107526583641589173510488521398326170749498822352141653608946305447300334768614597699741719899025026682246877711562838676494502138804304563829369292262119109009934487051045868143064587315011969433824022072132682822963296942403843530581555899377364904493495281687751615093062570871685952997572007998952803116870508868785944794745812186738327760206032843049e32"),
           e_float("7.1529009443307542046225308046866092643558954062560816323695100994558805323810292664492050303475610827373583023228815054264255678354417568320509418828478306003470889741814694658606334653246921144355218076332377570477755137281802819019107811969911300421727402800590385641720419044659756383850943021434338084451723004325975669284738424141451133912415464529750583011681483816941239316601629662633518309048e34"),
           e_float("1.1360020822138370618644528767250496858748423842011551943453603860365100915657564697055596176519951659871843697777882225993551106987969298156414193629728318205389669528966600402517671024227045398859511664652750213549130176413875371934495380259294635962070109087611309815481321141649489118055485676493840256309081264426658127321060975863570856955455268239676875276812131010968256269530361079049182856175e37"),
           e_float("1.8403483992330915403955084355952437601251508041161040744304593473585564208580843598622419284430725061925491341081839898809296284249489268414063146937385499678228780180998270647115420837067155435809661624071898098871011942308848176482164798399671525596886116191553065563998687105156112033334920474612079449761471345323084552946408857596615150533494799320915636896106541244825425623157977873862311659506e39"),
           e_float("3.0467190819099567196533881529050606699947319779575983115715555134833987461148560462290654190708323415955558822957778195131193528548162883043263645785642230427670004057382349609981738466361732460951664146144428327594040401782751575035090670245025613477454902694107519271911496748874342444026237939599715900059769180903589695912189419714832806388214592139416877612443147179468667072417290473707582174348e41"),
           e_float("5.1606060914231668726445622975404103146672386022145430812068436261257131708830556528436999827555677841932629550241397694119130625417698122965792083173866481240683674687923892294253149554132610810876575787234161455087451869362211499898715787769652282253181780970391616082347394816891450656108224754780957662206671000543291725978485342836499584419168723364282321716190835427946738253943243620032588318083e43"),
           e_float("8.9503951218110955346081357587690446228604184909915833678531349393061382636955815034334790496006160590649955652608482792556768660426960588659595200058283983749502909591748498487117098075565428958328427150518747495111298293506859663078307372108818036876329380771262910935066030918840807501230117401506530966355998165925027094329573447891096174322070268387406057639842141488915858596527588696039700978317e45"),
           e_float("1.5902267384349284218248125314790293427610886407053996840920881830038379215210978063285958330722231595919873785514943950217183631413179997452331313248304631836800584434169490241099364383491312025680503368771382470410652122206783270918355480012270793227273144385399293977205754318169464159277004633688998806440552410322917575981820001860351523247832674628607337410130514267286529782987734775456930903278e48"),
           e_float("2.8950420124229312912180791005514696626594742299753290695355037580367134224635982727535541497213994412358684934896248461832242737981674919524418407121961596854658866734770511712516549538798670363892881975052600798795258740307322117519981894086813454861025223200004815654019191856257700148563832481457643140807662250398437477795909990126011498409269305251966398562458554233102656124344880070610505670264e50"),
           e_float("5.4008354353208664922572493531027837012947172841398555698295514021906713890329895832294234678775422440072794113905852563568138757159414862454345557728183413811835865544996917199327620459152340049396660051254809082757131500959732729857955977114564595775350258515271833670379855405543145958094408541466775654463880967240644318190090577325578031977213060821928077678523543100508856473777439626445370179988e52"),
           e_float("1.0324171097255580715599391141010440955663538624508835711827390913029788402466360302480206323611925143577047490848897710915436321797589937229302737986763931985447631821688887728161706010943369010688502593848186684424959399237742171861929885898662688427493023282597168934640087418382595223952009754863196375512127449871795348717339553720788520606626766343261799725339483296930173953358004370639372247578e55"),
           e_float("2.0219766532586457569062950579685858747960104432523442614374224990913777409285160913429930548859416236818138024262818294059145729756674052621793774568580055752751770254035672536352978661420148734595084452782076294556096868281823054252631456384248559814209842858267829974280961641551551853267647570710259268896183451427050245817908750422823367786927704722206645107624229158138630308672613355724928247304e57"),
           e_float("4.0563298791018554112204010735802206599077966205582163802334571269326524838451244982343664508308515198375681790594335801735458848299793226946351231954218653269957221048886550308718355434052711105685796272652406155056872431429929767193973034809411485109701919995713063430889251985862471813148206546072493685352823361387339355053631142793694780033764938277839692702684624340027660524530030112896764190095e59"),
           e_float("8.3332579563469748165695441876908049648705228668404383691497048742105658714288986336934476376200081606883080751333227852436769835261131528019827536168000728788245108193425234714914233824213651559911283231862261521636075591387132694060066577245974558657535042993322538587083823951642455253335273168976404230084196162687030206771046963142154128709702321094671645044036114651237439599259050724430115499593e61"),
           e_float("1.7526439030137944263590121258218469254421337930944507637502692953347578684473265152970047368410933611905297993375256203971665266561340762764195821749242674244324215571267872173936974494097301161520788960426169688817599148089590116021165387762835265798469906224128371995482748923357870093258384268327390429155703077318421840533685966894425787236469622961942415891314375252116924605043729384776492843747e64"),
           e_float("3.7725223506396245237507197675024819400405250544952168892144659354923473182267935881231477537286115718470169879963000233893098682288540224442671678465462679402591746762747451902595708639941850053793380134794635514892278012291358007694123415722950563034517558259625590270736016842144579423746902125740485861714444251454642073472563981498669980636150355068411873836488220509286776992675611452206123715053e66"),
           e_float("8.3077557627218644444885633861768717204619463796350804123498217127256369544920865539669294789738703405906275579318598166508603146496489540648813637415144152240571187183824376844749478577522317913617993701253510701095483269360618003978217330638880428936876608079141099158718402463668200907947842496146958401391005302618242256068438431139909734173097171523276195211921122299495711075736467513670507968223e68"),
           e_float("1.8711086647046826422101535904479349919967122040496198885023445877801024877757184454593973386894476523985035172905047047081484051117714783469725981236895362634857112131235761445303698865757310305818475542215166339419525959692163730618553352093386929574655538852643450998729389324486840859740799396191407586853559969755859728093013285254808355870206740407880539930714190186212156159966026351408046969726e71"),
           e_float("4.3084838442638757698641100564706099425347941608184300204451054909514613219974645376867680879185119324935869414059643437872674952635116593693772850979877570923731936282189499190255485817330092230917141674107967273358858474160995154194827538446581776827481331914942785830434125417619091244816266237637772086254009538464009808921968724005114575276169287357468320896812467771953308004600296785017093835835e73"),
           e_float("1.0139244065641463835915898955957998909907837808060198212835213328912598461109612910177589166469052362133543717523722020297188647460171391867630864079413478758869694887135212088436251118582324258386772520382210685379880911729932027357981858090066976483906855233384404446616168759609400125695827934572949241036043988241920464169518533667925553789216968396342658209588623625162474293109193461797089744752e76"),
           e_float("2.4377418224707007166125541329221364994639230326375361564821078612800200047974366996360458811288551917188367554074930173173512376900227314881238157131251748607116721913573630118493593718642902553584927574358419819264407315894605355066596931196059764731842369065408622493856308506235851533375971911197652540608828808416397704086347365060551105473389114294391586086900781307329006805349439745934119114762e78"),
           e_float("5.9857288623506419741819563560933932969951617660327217851711810805024007096710952718386826599949742716045643648954146048171444583337270104977538224549356356439484407053600582173915757048473646119080718017940119283261732278753855830066227648900436639048546931144466864464488944856339155686566293825236681049109572326481418586726049424241024774681822500381008174975681035237012343836895794868000236167479e80"),
           e_float("1.5005181574362554639428573000251474433398801743827518845557780510972748225125266237956750486207388446064856276200679674417225027410784709554310784988814066065057632640292359706043422183021003892306380101933378173648278284769749329394899460755047695315292629193103289688330818258641948777228949886975949808704371231554134640445565972696948425351931884894839024077157123681487066291983386686226648020123e83"),
           e_float("3.8389288376434942673043071863495462984718294873877510365121207679836405739723142479690355684896507401902170739619274462144801120832327503313679103250862169720061598902908509859997378813695618444842300543100670621929330326268689140366404403873482390660312411319882583080467108080240026609866891889186466281257506341130962441746312272772681436056385767212362515011096948905664276764168215344147150673865e85"),
           e_float("1.0020181603649070991800960691842143596909660559345834886102855928465422639471854486533041422545953773464899166329490938056900136611689570220434116317334333858683976422282306570980998281226815833481285030199303053418364134820072155646107074677458859300887106138047423901319151570036851857370179384588591621923076498288942799870766715769170360248134296273874255190974522046841081500942695747713276495467e88"),
           e_float("2.6674279166913582225655506921986852697731730676407693442080605652761898297686539778999208909119635237135504625204062026853038945381817893893850710793719307461638402554561474533385928346475035838333097297487235293194256811964887476742647115058350068157991231321961695602860407668898467047771885048556909910548654932381240289818496402735276989452242857171938760554309204904499464719789510036610789389036e90"),
           e_float("7.2396758582064460204193853840102060575866923281624214491983544864384726131444825789089674537876542593548271383184958582432285616872489225397354388206478598496532179937015545462003891317200901697523298346081289771941870141597435182769562163348146545793023607169631295949736435920881263414499233334449731974676673609315690283906232554866079382872577553379062969252649951723934832371895981999944783580247e92"),
           e_float("2.0026991056543525655311020442650750463093700966397315032361716627113002221989502058695124395981733561036093257999452273075510899710802887153828787676832971516300873299607913855742148416943140858993363961112357279466514817039152888012666068109422469275562349577780162092969143100728329054237249234841511144663947767464122297752361963988143934771612749565420582525209779719334426375017101514708770257524e95"),
           e_float("5.6447720526204919861087235622300424695441228472661317772223345885523088347971088504625525752830962290987377499693697541034979776499650188977315751954021363110589528303222715027886346393969348648528152649604485452399038122011075184004987505190888503662527577172441801728402529236206191729369197889852009459760706413283456230076565195679885150206012335071544244286186298027436893102590287449019858403822e97"),
           e_float("1.6206096012755781870241239315249789761459347066542674197882381956517973380001102358124579891455885672638799870423305527559720671389473048441563874705361342204785445403585990493349108650987134515124109261005746955640170954568263530305094060559848037440708503620898760835024359884631950343617919847447061741147547082492669568628440815372355488748235597237189083002929766732815788099170621692792494043287e100"),
           e_float("4.7378585155345072963455074149993637751371073022977769558755477077931777100833519302645641326545911867340377780415876172369106465409365660974636269856396946513092036113304030912885103269703697148132618658160940256144719027850019277481680385031853868540218013274773466082868790627842715305948060335302972382839306202895591540544908975059475732978542180395350716561415945029852576158580020886556300628857e102"),
           e_float("1.4100387458709552957487167801924786943463458051825200810889424211177881979949225562719097797071417676538922410382532529807829800419122418929578548770879513375366711276672586785608868172845811740806115297350717365552507319367792942992729553178290967142911405447562278236181714068027134712580359389834833042624085094044630767590213621353459050392411499101436175226137476714808679981356743423918344799595e105"),
           e_float("4.2707295218745113585589801583391171179281160014841575748449819868340501138248295605661760948239858549796232671526679327139646180634764115048069626959777556453647460936713883535636702280580720075738681827783018021272882213738388451291526394393563150746389105937478176223640519148418658831534634985999393943636296491222237349665857959970269442277666716765928125919332537044881141898271848253425591804985e107"),
           e_float("1.3160581344573049793349854797034666724134999440949986760548289739726609119118869018451408685219996252353111457924947609923379323194060555732554805779778118385093549479915682359712205199211662570575215782682671968866105445411455432690608228498386805464726827824761836934143141245728434866394469047294434385534027487620574192302008267696458017770923094295470730724809181349685638504688457031596132984931e110"),
           e_float("4.1250867102532683607342012561125636995697923080771075054360159374240007718543288356390340616654755563929291939554879064373130317272303187820802871448423492905199105810957005786832126852541527886743454598447839715695337997559745211463951681984994088215196595055289422145921588693182054421896491243813588369653273947278479237362414101931860175922096871533941797466252816669363112178154597062604470011247e112"),
           e_float("1.3148073872176563852935208977150506888374826471210679994904446277839149301738590478128983309456459812734229344323079743443468979916779935897373874595608426453345883313047031730708727429646651026182223181845858387248674706700898564203211349193439314876166570338444505999776298249318643474664638368975565336195570921211225341830033832306848034222237505588899897084748210054178161943653590383966000875164e115"),
           e_float("4.2604084764838406114146647344361312911198904891203692302125706577870022776078036748611773959345693803249907998405433842493877258523127234087463027401637886335265325684582452771096547397679847450900735661019178575921513571205769832372118037081819577442040131116122346135537726512592460227901642760659492120717600150762931662119533983758210759778631489301660058892953663849286789400499587613358777959321e117"),
           e_float("1.4031118445712483115161823983480919854334178214010833181938617021094386968485320806158482824880735629571802461559731877460842218753257353337438639074252780942230360360662060963660385991430426606156894880184125461794994092517067528216138983341564531946735096473110706711031405207373260899340688215643752907454222765040089532016737758377772893821538988541866224390109809960322185872288880394076750904376e120"),
           e_float("4.6954800229874756146133155212827893610190468699737932476705857036175717069796087399818893203069543616623350275485290185259337289792706873483559309807977901871509999324763485306740803041989431460795382090637488971279177058266333188425797158500642384451604159418950105972783885068572733392594483661284990021706813803866452113243157289252384387065769778042975758233381424662365907131781722789566551850567e122"),
           e_float("1.596290048758699826014204190008466152674189972400892192230091388287396259233657768011007211686373986555008060199845079225659678314156306291684057492844492459384144929810552959963461268019284086109615285576555038025254627655662115913753872282548933101006763494964810900066087134596730563608395896891047231451061386600778003433045755377726467662520908563765361676081471440946234741694708592622531311602e125"),
           e_float("5.5117286042449758525845226756694979024997706142657679356301329514354745209868725589353446208188933477107108885843467099401816380410300742430470093213188238144551768948320109594729158924712573288644795927294765337735320225523473553431498857576878235746189926391431012301118666296872338412319632543434200205199267318298391177641569803732095268293718322171940030059973364963827260834230919124286501546407e127"),
           e_float("1.9324610162510825912273577458131303196939818388805907384885064102680162850675954633471557635865361209713177156321966063037789039607017872020965790754179852936412836487830236896289897353307453051352657485632196413584422515578289625307778551827174157059131518731337910310440976715813361947467977781299538263723809984862606971483995238828277423712311639553487744018948567742655185569229740884095413305561e130"),
           e_float("6.8783734116346245431218398200537889180255811598761486362031126559477424817454120167508464436901776664687849693936175196751158128947427046498961537003395785791928561248500045137622691581610358062635469952840171329234118351245507201836701082875469487136507879700290212691372599305238455656776476022441075453165192578504991265869470859395291009269015459933570955657462355097683498566428967849986460720677e132"),
           e_float("2.4849660920966199235072003360843779609405937830282239033066514033497158677975034136580911960178491094876719039647890448462827353479700919658422846306849091660872184674693201424496301926531182687196881635244357016312194748156934332584417131976022787348724815362545741868565289839163018950650891036991636609651373208257765327364867309775936497856670740338845653351411712818885629978156815616286148074803e135"),
           e_float("9.1101361498518667318837890890672343611395144858677536431113872135182425475041536024026651812662167450281654107984082987890034284489495860223105900736432483037212085059651191079696435655718073753188266584072095449886801510102845618784008800735440940632450750277731208311914176984860742920673225951771821749901462949085451842421789852268984325728597527814564366901334883577103276902262242023156258886872e137"),
           e_float("3.3885289445101251631769399805464526054958701958856862767682262058453858069467409110831954600588703464548135371593489988052331440461064815530260335177842155040055983624450235178683599106646315728890004517663391070972866394198394886330657171288517110778697408968219760251873423791302660640027644134622723165115664723926374935629289637072333195148545521877293358875253581338191175839280565402063332903543e140"),
           e_float("1.278479940593706304637897191884466293818919836891610676093385274095994420234132141673435524602667922292003718797353909551700320766539064954756677666938892617761092678051009768058506577655654266285946397779766229371865501324718110149246897003063233492457268275797640186595969526729215009685060413598990119224583831173794711738545820055756811727569324276537755912800090777504829929199765104954958098233e143"),
           e_float("4.892035643986746227453752416013544739793806091064473144200561034601346431711203306552190276360787922045812891066385619936050332708976037900933141425408285157651836180086575499584852340205071727695459465812716475748811148737580685179593395060846333811386846027789641598829750572197356567233231206081257480284833051080857730156638876285335517811358793814921409855401649764477237153185166590478555023131e145"),
           e_float("1.8980905992292582377677730771338404871817546640085417786965652010844896560552881756241369742489035768904874797162116382904650280499253483722373626479594022298326274179883911678016733089300195436593955111980659744977670955699264891425763753845857097634377433310425020031784733633844044403983547105466374102906994524311135940785505747155999120607038156960904591846657258787886971357501590178428100028708e148"),
           e_float("7.4661472279218164786210393704580529437017946793444385080878026300616218686323135224279485139262483102664017173760881919482695364082505919887393715785982828036748270730402331409220888446670101180971726702149022688638607681628283103102562777328309727642624024494955955653939844654927590367731980919618717258748769108963156128395315752076661016278887282003325933390617411377537679169739530797778607517376e150"),
           e_float("2.9768094568875385263853214095324965956900607599077883168978811349689639659690988324374477964320307053416504938514083015801546026751040656580989305981620098749628581173483459407978160560258099663236789860167064363516237491766408995380320014156875530859893001425970594134200894503479619977937736784626356003272295881203239397220294063942509914074900701470009813415061012663070363589889005075906671060663e153"),
           e_float("1.2028316887695742584227491768194921652502457128041677673261815210676997249034900553409187131886427043072349009205513084492799870535359519655127405153676183366692917666081204407432458358908836505565613398957527019441528989180163059744715154534065010341007952253535384158591971777424486576710612306325334972299948148837844825037620495253598885988886975735607932327010343675582562961697853257784069890017e156"),
           e_float("4.9247512222813673502727750762519003086128842224370607177340820746196131237468922463334049825860177724769753358810827584324608550776605770764352575264385311071874873620394419638640125272023105518933873137993686060358067317804008775886866594942743600201921590009726819923408716370764946109523871861201944878568283638590393541547399456273754535059566031568772396804294022954605573413968203248271847509923e158"),
           e_float("2.0427601183907459339977190408814040936242577828001647054857075011530732347058567955250009061611913843090415271180348566021432207145592550883612472774544003077747903513394826929292640863505409137384332793573066185344039609676072216086023501370647377866540320588944636411734186739166720643919803124458881785083575471628720064664917247216175159972042462925578232144200235291688777262139234944621526806479e161"),
           e_float("8.5828951331572230669420885939276172989614973777406955601003515248178434549539590680780744819700243094027634830988329595295524101526671503934369137640254458472089461455026487331491257081393261631714771628354962207317718067370584346873880025848826017123058864103770867703021074951971283535106183267590724120746132444904768743632399678815674524044451187429172023196312434265537389238220837599224328166708e163"),
           e_float("3.6522876188301407076404177278104195176880572939177271432296732343032164944155957945158388203317693273029344345147413603035942092919257134193659419025065203616262703189258608911335960842305883729387127322928957808027607530900753982475007360573778950623687012324919612089107150842701513506847920788446318449409312779734839466627774221755102110629498009179005453187396375473827208693979965663870812571244e166"),
           e_float("1.5737792729143581045884091916152475183492824379274654276940962612405743182577119070182823555225021253487281011486145380237054378180346113024836755973621889039956863595969146544665298105210299427614421212974521573021798676633772164885357144051212013413681144086232508434480950694875234159509683647999935503188921063216800004397628457521334131942562947820470747165956841723553772206947320244871426688918e169"),
           e_float("6.8660166616031623788268675563653238200059027453938602055733304773926122617850554290731193989489129020729871871910523639804170503414034141029200561739363542004384642472815465855610499542561324955566835403606040767354398222264759365659587663307593516530088139799591973738777705718006061175501518845008655416416908029153041423038671138923438136609467172740827529952983430199849995049121623918609653868046e171"),
           e_float("3.032382998504296289511713010123752009008355566680922379867560069853558542956472210639816942160680286035762087825481216592014258094948956261883548416397278554188477026080833132425899347791579022823771717920542497054648358888313767404004978715221721716827172888356884570908106175127775440719510092805189639501514565264822843599754598830102926194668141678228329517322812585067163115401504208600323896474e174"),
           e_float("1.3555603330946035240080674471790891674867850455165823835040677232564432123042719043351607990463025560702319915980772025707382895107427122317870554483641051957460152211803644755829918925176791661326613112375878363317994924507176040495031668076519855213689371847064676579151805557949504867639177748789310958537748557325697728669707822886662329632616893448983588662519626975351120582911892776505250605573e177"),
           e_float("6.1326485713404027358883082408439476764548793790453181818922732590463404864824504127254909214180462882415927696976250427693816010302645576852327226117049123254099811848489688517328857235131193890564383508093251960712330113968889516291186364604032659278370527267625646364353809261871649034729063030897831894035360768082426455002859016240148784344163637218310984441541091690506426424238694132462180085618e179"),
           e_float("2.8074492623377762717201657631944404376158714960519184791184732847662187156391316882393741483402567968849933244852424236445561661480054862595806444317699323235004798778773679256685308756394995099295993026910016445382215939275277963814720044426095439551661609929081241893519461163611347111882268669359274935677714223554131343537506790186572443130919874331450901021131257704907559799567755189275742005678e182"),
           e_float("1.3003248492539801318283562508504409229332733469749779726135152024726290151738674934305923891564803933345652253410686231211562620335344728469944568217486318728259724719605444168734199496962465730121781860342498212261379535774799633305824766895402659848010682326467986767900162498361063691543565477961722883664548092651816178795161013648381755984758474642172450673469772859543121797038602667132671744801e185"),
           e_float("6.0927124914220620630493420205826532166327842467886780785174561750840926753516624556349867250131997879008273089444625283748734495061410603277867651382286090689594876771547184985768370066374083387983747731703559558003562279643113901082206882076947137162291918349545026604513178209494721292960391038461703042419138391341895273180133171918561409795875399144498573750367017067072823531077132777436820884349e187"),
           e_float("2.8875691066839886762321561394043950498634256102618179814315319356666650544164887776416060703619935262880452014440816766273508280275814614917179372265480817375263810360589548289628666942653490411432014386617494699270086692591307520830265991844787489984902385824771447090463432222348598051169486408860091084657863434061587359106433155698581333403176813205808547425476349644615144941052196129985267495818e190"),
           e_float("1.3840831023327674462924563857878986901828779478350777644092981350627682978361021889259223223477164902801686234810343635592266895892656886399157138941893946649918846708209716485562793663758750264525777104264846241608389530047774369424077888124221669801723318007802754039246454887533209487938414975389228359774388210050562319650583297699414046454653417477832711078350590064229370388895369781092165749391e193"),
           e_float("6.708823747664079365996765499279090086007703789148249935782542487259265348130514555082568720520780503419095594959771318681115080323204687304109677926861413213599962720191759842796924869036681943660842461221417424314372209233385739158851800588083793514286943637355868951875424893009432105925213355873521820998745487223102810939361994003617180034287975635459317875729001928249991597673633505792682757952e195"),
           e_float("3.2880053647281218443905327082468918831307934123323160178654570464043371806649759105817050261399312750909833800047983181670415295439647587687256901083463606225719490028884487523933958316937724099191025834211015189409827086677258947764933341845769965623203423132309676161797214709671386596078840010039597875106350269499143578522424931715575740732485665204616360317390060057057262959445375851917104280453e198"),
           e_float("1.6291802878659899271045448564791855766170147027825050128611946960008767048707887512879335764090306240903853170160269733617472282616304726765067630020552906003952707427185884919649883076755460990805855429624009771331009329455722102108872978308648147568600789839327718172919884284389100966043893320835696037192990716629973458975297549086024972568006972188445612366269280389523488801049965596556582743428e201"),
           e_float("8.1602958498922059056116532871197180396033507823441084506710039983982166004483768615608832743215030371595235763177774788408955313334548549442499941749547254582660464056955780791538280805808481265769738056387268291733194131446502619560241531834863323065307109320097292786192148316972847768746988772212735610653969390030224825472984499976108454430289938542573488796202202916929222453470086971052732953054e203"),
           e_float("4.1313639203305506513369880686175606492712848730285222212098235618685272169214793596246298002548631973939271000880658060015631840187571842284207847328402256855435966539341346888795171758963741135096257112280619206730544969600905140687204915381437326110121400207492066450578493873867425716376812184830496652170596679361410285045640216781340469424075702476767129120804118599123102770422226722426616238892e206"),
           e_float("2.1138951955106055115405515675640285107842576320157846189620588617862929724107897027535387177510681710640377117105210446274358097001497906546655614947304140542248510437778956737362937043497862997789891827400526319975504787519542973734597467909363910400716385775107314721644054069579479769829490843343431708718722294016780470222264566349675794458096049101967044075813357673893643916715182493020580354208e209"),
           e_float("1.0930210648188081064188178116995023618435219646474930439281345698123431614985568107663783882587101796367215583666845005481543589961172035951379920394921635373236381850338733397318873205834730939977797956954211778390909005829486767854013976611495637300618969924604496004442150159612103570674234460859395111533709357846196222804002851949964674286462036298249013129701008371671077629348708902834360080939e212"),
           e_float("5.7106068779693945329014349823421114765060824421783809707634404486063835007124428306925808153898156356613798760794242648115999578502851389789329963259137019961411857421571884853585784521752886109705544902632013629285095192280945374153305141516106539316223487684279015260978996907058140206181267872063342044603745528466875055624485426661036261683634363036531826144328668294427040439062592775499398833361e214"),
           e_float("3.0143878761688635861994426436492351604698772175173542099259216210203004829213914801276310467594037741441184827669638447581584108244106066559999592173835902459995262279774728987790477575747964049589702549741099526076911186183676766335025984148928106957683065005514004048311853607887745943338128868157010808789534604699039439338370449712956501012397090223879427214450247129084334152294129752450045453341e217"),
           e_float("1.6074390605065547308315931243846158603902599555945652599459156637696143310642805948891238038594744547200629824382853299597420586154152369231340038778028374687859043302063917370061280473296256683393201297767346163155203610917078906169122730698060859339916622256067284823954771895105298469657192998959016378905439651509837554027420449127193230354437998975961522916503833039446887628708416758315315493309e220"),
           e_float("8.6585396797259602526321322548236740112384404795916224129197143687505089900125392625089453189758220325393094815788830316899869833532159904687893244740487804765418255774630433810296176710380040382944662427556801003890711040009818454497269197854603980569659005004523128096383795517613613177696248059469099781636391362549241755430135265971624187368580192876979162535795747138486623051124666835061196460349e222"),
           e_float("4.7107126665686786677295833772706425736912625563936534020283637237248799497784529368969445774434921314785542193690368674640186247141640492200765302537843320246284458812489920072397983151253186395638919996190320812038023954373592205659020912966593549977808343645361567923077600599097627868861473569607714148328051046057749522774805875475820720956613287187978031638071964882720179032509524813576545135285e225"),
           e_float("2.5883219907200544850455500356878805268699194521513150884930077913753645606435514330954569025173138078862677539278705599984895442691243519254498536675204430962363226886951114239359436476401438902826757318509603090992790270748687289804156145349486285249177469368524009719046131577921159638089491459151434511803441932019000400619912066025728775550627190727521529263398600961471654554749390571664444427426e228"),
           e_float("1.4361453683063396736013376393398662509449381957669488508343926220653472525649048685982970955872821802954612792357696627624295254854454341192614724181618889438025897301100920466868918696909417484195789518405935445090055380862344143163225689011755199205574300107645276866969343907825383329889626461035977085658450328496422696268171095397314663341344524466031080132102049058861741517751135878947709348593e231"),
           e_float("8.0461175896251057825768002336896183506195304442475324975582649918893013049957716676943376853982618953695026288128554121982571498326177531502754736422419219944147911835683932199446245227754555926354092853543317699144231183444859820753936294068687164743890692223746142368495223048453074938741804659783625422066159401484732486451015680942561219971872264079981607856958364562350446543903959383448465538556e233"),
           e_float("4.5513730623188665746104338172994331354926616504475700509458212317583093833550001778082870449093645764635143764046426679954892892539860611639758377820960221239672082602423325121467204208564990170581003558943629669135732731562544417801763333414234873949943112311568952406645220370130215495983596348117719798136174340295556881538054908213577500781461888314428386353349927106798464366938814717892359576947e236"),
           e_float("2.5991271416108464411119438731066282633452648652950946557203310271665446284466772708963579615983494182295885032692148011233386635800328424781298468865760090906862709932792617378859458797710436042020730186638675014156906834382238047664609266324358741547051091645522671791340751818059585334773720038068516465711915865155151795815274805967394307606880637082924539867890917761700962393534039853990818828986e239"),
           e_float("1.4983155956745563358788643795707490315280722051829564682825701934487751693596035212577558808351486135882162395312365420211438925693264280627256652750658316088488545047926579062368112021976803509321774697562574175138788737911060531244470620508142042472347265508312875589252025948026878579778498085695962483652697027132284370274578024118784906641196741002700842402202186457284847258374054147824303241594e242"),
           e_float("8.7183060483893753979213754133655742035178313209268903851616285487856731303830522842294449362544362264246186704391024236728513275508936890809668356609651973083438430053977958453519486294613109726010189355460367446686429009997143836619083740740238140491904992742193038987654740018063890295415380406871689907015105660338085801658901273456410111616299258077967208505807845106674064092437590753631678014937e244"),
           e_float("5.120082743668190399698661976524122862275134041332872386063947457331633480357084784261167597562012941196448185908503372773418577490128235499950748418503014442450284751701313540528087019441808867524536060937055880537329119521805053020437405747354083599299203296562422648518705898877649024115407872161100856471935149610486529859989864059356107081981821614364912634958743824879683746555559738756872766317e247"),
           e_float("3.0346009409225821196979689839769600201876409905753571656426855123133247918796081904911530417159723032213478766470713025667787610468756880012736514148535813216494261894236205879188582447910876486292278422603102037515356057610389906111878530507495769089429412043034766964341637110668242623543358445680135679641199031283855491397766824448235801621227819406732368303488005937245665003825485456785950473551e250"),
           e_float("1.8149733720261392723890110894655058068346906920131064903239754039291477012408835879624513228344972904652870711892535947025421767133392030239618117478091995854454606332905583010529944412592802404440638110074467144378801324241459525436719771063307840764748008882251995584895012525421703706546594662861135049726809888855396668138393053907778325808457569901593766849197443234277695978422091147104850441126e253"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_01025_poly_hermite_h(const bool b_write_output)
    {
      return TestCase_case_01025_poly_hermite_h().execute(b_write_output);
    }
  }
}
