
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00584_airy_bi_prime_small_x : public TestCaseReal
    {
    public:
      TestCase_case_00584_airy_bi_prime_small_x() { }
      virtual ~TestCase_case_00584_airy_bi_prime_small_x() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00584_airy_bi_prime_small_x");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::airy_b_prime(((e_float(k) / 5) - 10) * ef::euler_gamma());
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-0.50573962086203674291332296529868918847311625391300546758675288755037326279589519723675655154744837741962437254824665354360924894138116818483952113284986015975766299284866015968140654053181017104784262469445281584436467626817726442840756432805058044120065759509902867976427032665277595478732219127784693742917834182586525140313262470435822423463384469954131826663690973153189642716807358124034279962942"),
           e_float("-0.29084942441411502292903367402103322818146320771004585298573539207746888851447157756459771012202072551262875383666069886125112300920985575736721217045032361119206849295207964178856726833937223040052215390577828369538582734538288920070180968688372173643952837072686089613793014689217066898072127791886304216053001498830244042883960565833377918066394771689641533967388881116461990248858074841192692966011"),
           e_float("-0.058677413557817949001505399131621374823571473352485246199936333199622177975992728037264103907638604537569148885334371552057918486171735705688005305753989283055495381175243388456823818980098411079195535450423491601151411800721314706820926274676283246190916526954205900303177812117713642891078923773982257022859100578840254003581272837535187065641080058961711921840228718095965153611245126128778396834048"),
           e_float("0.1730283603357904503391395903911660170593167962527869675289961622559472046270944429996761311501079580719987600845551214389880063248445207990618734742617184827231948147929859304074086574487909071364067645399853143129756234823144568332865198614727518928574008513653807347931274190000266204650931812638469676105408629448926609975314037008380465644013873458582620339542436354522407217241742337978026757883"),
           e_float("0.38760917465881573098378295134019035027956882791471930211845677083434185207143962166394951385913356937556386053085067241838922414163771297613389697481918410251213905135658271488703177787382054150608766001570346204088141122113540452275661176604564893038594299750274336600632936556740902646894953318602690407879542080179331238321396725821102388014558293609531794109734142186075597795371014857293732505097"),
           e_float("0.57065293416225733963034948244087528730857053893222551017888192857917952886540591064809855412524226983721918505274834078877838089373364205020107714724097162828910524815560296462143065809179344566288018902644430567844567760353259278113400248562919629915380144893020591804842445174082591568773639986703228422952673087020734099256400938470670755616923086530156129224824934416168164286684190408455849991384"),
           e_float("0.71087198523608747380469086999538887196377638960941814010735814756033995777231843748926404190293551247468283888789823810241822392637573197162786695079506352241191831363450940764066582869339393548027597965761913903670480230851813900537561248030513189268704772864156092683130034928837908796825129588591060865258722269880324886638041933109798553590738155454075938956058318168169541414283723525887021250309"),
           e_float("0.80066339347509105871480600980585588878898600801308183995223019439508275563464551904165485595046048187073294726767721248619816311722232645386536153022110605204548561592841331418406388390801240693394254810086674574901425498222290831774306668935503360297141448322342741553000732026170623314544525735784103723598168530463034968692628823967990887446964722570194463775978319264479308357999212787400629366126"),
           e_float("0.8363436475097229838075155802390046301853632393773419153184400777345634829011908895974769470930855782529669391433289957049863318657312304647535499219220483095542604446504268687498524250734380933170214743241995093879725236251798252627251988934317861732614540625540405324008824486656064383913433736879515751824950007636734003044346968403696368556352607090222291828348146741848751291462947216738569934386"),
           e_float("0.8180764248469911184246211182183099966914985307568759090118904676920362708390265920399101068120807494548470813885042865976801120867224409745937968332756336374079850271774770597606207065480791544704902550992576878470820208709145947565051502812561636176479159433714403070898055212417132252182901200629289710678452423860138962684832952367651860771929404820168021506185370053970146762235829964215993963111"),
           e_float("0.7495336170969049855552888164417880452526847395432026890388418770473674545704606670550441289339491676781289720381948991256236655976917880200791534783870843200808086191673390624505778519790329377197028142752472739776694401321891881211881816738692822987701844107927444546562592511846960393233876365037349338141728122923344626689889244957919331691247089931036131710428565247286372376446059850101290802425"),
           e_float("0.63734520882036033500360646335892327395881997416528305078259119866415622339245238106336404680900191809411076531819342904327404961084070515064953680365816000020992348799027930491672285671197734186037563947978364761539441206068134966260637627565422263377143802431029977750045768220223542358322713927152992384510465560818656533479356771086169107064988898020385831709366077083250872962331998232212526619126"),
           e_float("0.49040247470945771366139935030381356233658148627789831909864842898724491730279367360296345108524143853570449744015218527635203670147074333766980379663834015558226046584787078726944310678655397347179860247847320540378327125486614101683390135415420886577041213808611975846203460898112000144585026857188169467469973978413271786252841810872186582695498114448781632355223819164603937805418465950738991426998"),
           e_float("0.319081552301283856273811697662376125500051352324527375012496417751966124864691461731363765243075121613489094762568861758671458756842454785805042566289016600230472890075409732094714056935549340689382768742609575895630073844546039255182436901738385146952879504995720017597985611866633152363032912558951080987834125874460228646635880499449645335043438460784186568563226696648301847816643103542929853666"),
           e_float("0.13445149745957825872501946473279598061141995049457158872588504934775565041254863522490202733139055680138179009168006168645410844626066355129016733864500927268620256286709470478303890503503148001635300789350879638533091896337180796733021516131146090253850837861147634068646968756300265458331256043267932612099587763618673278113976511620399911493962203602890213784921840722255865188159323169886890085764"),
           e_float("-0.052476484921787651142780704592212539583198458210189946244430008737240522990305802077707733415491936747891728379228038095209821226248315597445074454170157840600252854215839050829702809187831581853261254765131533805245290932110143108191793716687506762250711027654540041724881280397027795918534649555121758291077504911708859460044039992620268500308727653184947068785657621216856442266397361427775856437631"),
           e_float("-0.23141255219353547593243989958998631228948704021991306565371869785355840655349031456855682283917059333818070402548785568580015268947081880663715015533035075875395403468424075898017123952442132368226818478513413740718602488021773689481650029154255014716110474176777283816826157852053138861454960045353311811028202493017162303715678304090958882429353710566610155342454246450059517846404258278200247309994"),
           e_float("-0.39333087681796372993896384852452871229501305060581818932646319872218901578501513158364181388747933593401869642197698614713221298063234296923673596454467534347221101678271745719523903842544506564350629371463921749219553004073286570638375505665269626942037712359907806259570090199953072792984397327060304030226040964900278253173133334921143358763553294716290330268510057213637686843259542876639680048451"),
           e_float("-0.53087094093714302115403392904958467820694715974012147312268316784849791120212704855208492890714847017142689400069484144325782792705860307767453255905291827049191368306241964924551503427636632509761362364432563874977425009401402895389347907329002048488535860034886251693535101466970270386807939942364615395300311891906486671737977316697666823294201793322140939701490233357114700644879108671249254146671"),
           e_float("-0.63858959632111917981221772443530681883293187786437932636633603465784590420642574036592704115776762476731737578678001974658564079997125781303859109038182939801200426543938441762590818620619191204771483190379092999611707183438683820698592747216722814978082366296923702042599087800545711964318147788484117715379408059028234305868093197929653720923122237428366958041235095395071501231032356628512161995454"),
           e_float("-0.71306728654091422891080385385153590526578072501407242476251204907866850564281671986608574766268812693240327181483063494286699247283568469702776721164811490224521512510834866420473743757877523630014532302687610530554635702382981723025195619364433333033754256292677053469804211307354042646449079066396894957569186038907989013832022213455177959956100685269844394729393575017034074929133941429756415320897"),
           e_float("-0.7528811308200095647539841327570798582017456082397486861051615107618251402259757758606731381933082231960723718757024362428698412540182892352212987954217481495676638444500130102127079435199773358413957583397276868751761778984651918416876552250999482864029122981171865797030544560155727576890392282500224907775371092005176974661372348945006355608041359812410104285422611839450769767664948520591679537835"),
           e_float("-0.75846453895658090741885866754995952613759345106388980390448546185316774384361535578005869353900036305773905909470874274761326700687552893419552711944488127284113609785660160521903052302361636516630849943810333169003052886470735973013061124714948973683036815247703049217015863207093170310313889181282818898261152980523037571094426631394700700430087558913777535308845280633893897510763456125705255781786"),
           e_float("-0.73187754233609505067388106926266946574612248511563273453575823887032924200905569399638934329897849809201757203509152805376769765385100479608781051041484990004594124425186677054196460870986915285836422079605142120650029482823273694331981670106628129112119455860977060120549210277828279498698387314764094883347450741542583985791689028305415309642801389423795431012894280838654683307597251169567958802053"),
           e_float("-0.6765141721689593150712527055285834616912372382498401578936614927144364193289128644952621430516827738408855801604370305468292364087139189311479369203180348559927503584596283515777643702999758163809983655372118659854207394515373427450669252478766445781138739115841995354755064619908515883466777104176882126675317971272404136295076587535743739471421746960172468231987185931486124444724023283238307482608"),
           e_float("-0.59677323952829378278826402412780274453384983491446957359020405906502647714224296742578085868307593668107620600187319346447610610731687085147900137225483226169266527102222603761760798482893582445343664114604129131516285325441281213789204745469492780995026025016488404508999080086956870066711816865855209481781960383380773309209691275035213547269631077133110339027102250121774320540766898063560466835409"),
           e_float("-0.49771713240059869257947568370996452877889731976007565187797963380570103341667444844673469359675158678621435756289698270126262525512798899218841206463955971491723927055287251966836223366120685608732691822161851967576510503197080773618030058020203773717248816545395155552188657633942809726153611354767043230804632896917711879993074067152632389446349195415242081763201181259061768610904374228638664793694"),
           e_float("-0.38474016708646604959552446577797078738858021645664337905258699705703009986726196227903787702315864050294897136812571496493124400932258388322052999840179545297683985745360472446388383463182018328176232169113388727306425696082045834145641482996052669821913061596464684827147454461752733213594111395206082830882088330446284302443836035351251475764182127491881297043453140257157008996797821814565175412834"),
           e_float("-0.26326405930947572194337197837822990304201667451991639882116481591788673701499757319529654101041739115322658413222150817956157525777672813088137012948612759529189827268212902909594432333234716753553478762672629670092165631487768064352696252445892724355923667739419893341875477682811828972396478843152111826116803788625482959155329361321694085455904978215772931671834690977311795848700772064142620655074"),
           e_float("-0.13847364161733156246648816641132290661565199603925457380559079150375080820069513112476684199831327244422520839363411814131474954073624912316447621192657761681750386393018440958197054067077157405385364034394193256303508711976506692793013959389974929187399093935928282463131462618104896584922395137204749506708823104918588059484888978570037456533015813420999889740929498544388345459623697072423657736049"),
           e_float("-0.015101429734279107843432536191733325473062320696320710288757644432839112013627745063442495820047534262962463501306979123273384204871023530643817530339745716306550428084082382654939113669708008219444650625716472190439413490706049450518059129058791411002631381538403562570079071834788586856356425827176021519723155557304637894677702704177523560540111034557074910587665197864514959390702719070387360759025"),
           e_float("0.10273465194571448812054546561528218079253702886373248687393420660038541082937911271487061672994103822476524984362473419720535734549740674568608610808748620531223868360755270159416125901815510079462101526021719170005285863410388249027184905485642635153478760752912582864282209389227439739633538318066732304182809900839009873762273075994088934032748745177979290496031289994580297295335126723662701796196"),
           e_float("0.21163989551019576605954415077142601755343443376565531430242612195985223680751547800122268054830793107720794218870356464845335236391383146873219985321306760043433361751898006732220735096611434343213973255543225892276645524647140761514392978482912920540077245699691251863430330503899917569884434692674310039266674563559953539361557301078577202702670449127420579525269982430468951849524800748280540669128"),
           e_float("0.30900047980020508310471174414638518381394882978544422485438808331523326445686490775565131875337539100930217244566481975446887452803335211239516052587973113437613339046213212620421629514248998834360889605145069405520649129285266806120879269343133666832854172973155764914312679994164781649540739271896992716059064608521396707574314360489941935832090912391285819983205420587559431954435005984805790341819"),
           e_float("0.39299534141407682160318775863749020251561596496567384218491089708959823741304583153229925774512992842961305542555317994889719752028892563169595830004979776133706741157138030924350904832804957641562397158421254566582183332193394654634970122292327637919669059036963477601203408055377467887580159321492738530172969822417313947442993209180864122346402612032269690153385397649275680804809990134943335077931"),
           e_float("0.46256911736051736371554020029645475123565019441205350688730095449458501168261062627452319150640582857682009644967555713068596958262210120603092920107466614158745424078326496340098438660446183815568560889586625496879498123374354448773732418070577730912442883962635476303941010387670562338330829439703182053078773220092246452414900953928216340100059069592128774391919383305100020319309710098632182488026"),
           e_float("0.51737403185978610642879030113926106867085874596810719516474305182761806828078121601277575154333842828072747297473729028926706938097615770739069557140403431169994755731603515829607892972822849870052147119436290027377050785070851090132068297918225845882406269783540222790663714692274770729547900294438552774050094509946831556505279565930552101927091458846980279988521915885010029005817806392017533817507"),
           e_float("0.55768896094366370407898701616784088320158259111967715603739632558251703903084495737213107380640518091514519138713937024594510638617174594205873981069338439946022855431651475893153155675511271131439146615400240564438798631827136959161767170692038355804551466765981243084293511616316207522724429494404364741846867312097498576406395973871656784016140668464909600665256662575816982303061255126577527383046"),
           e_float("0.58432373031049634230664945376929957567215543672179446765907361074428592474618516040281637851570814350591310135330375038361335759124553990195337496943348015227964447846549168336703009695410270348884866200024233427935286311828332248620946344835481107197158215168226077639024182128366464576846434357776475948071317840966290522832408599138271470444647603235252438717066682592974291513556534482099907722582"),
           e_float("0.59851610065546287088300914712285199906971554945153970690262834140461537906474203907952967088597224366553581138859306235282749112157695612223018647524899084521147511722822951886787963149344562554261717020659498788564597878259342514856567417585221195172403645619232498910551240709452827436261719426007481803957874949580843803663840859787665875395897787068860226030641921529185373486405189267422074603766"),
           e_float("0.60182799097484679403502358758498524396212767567350692456955485152795504244127409436037690210676100457028326764980444187718994632197828947292304742347538124923151320994946823495222896263040185287487499133155012658658756376516757407973510848333336207608615282233784762696214164931572270793965892524003917212341463021448629706070125776417932319207467594751962425174908656509099061256285566394987864489613"),
           e_float("0.59604640004018926200824188285476543434489540182855417588848621196407690742841254353270030573069703759172717108684260668098702647181075768866021377315205749137904160671831518532226002680107483603778267502458461304566854197285719712769239980062491750410082399826281693531726964462430293047392653806090830549299798295402054458264853369180815098080196612075967246253777802194151508471521328104115181062865"),
           e_float("0.58309331396913300672564845826849036104693391317544557847226341843038976698325131488422144796035381361649852245900369126219791239469223852941167456804448950349843702755250333711629639748892522982790755710240763455476013720208485064020768557990942299999180904802712650083342856079565087385893554626259159068730635405406360387165335376038075948322428279188076326331849285343373734931255872983710904960486"),
           e_float("0.56494772253317287725172098719301167766298068720455755119661654887059599841991607137257481319689778493900343180184683927482699730330550080082353946570855634769020206598676895074426020470730595480843495515787905329341933368421146975044029665244238494829811553766440747915293167766018105970475448680080988647568906557663619639965641232977016881911759519064239007475358902896551630986207640820021213060251"),
           e_float("0.54358177952107161017762337528102560753226846349092690870933349121874180046191480909816440886866652065951686525682787880792508050876599900206027647636330167948101016319129891155892343549282213372614206956269089926805247213936668869627366919663424943483835970652642784049596886489957976228738812099951737014823178711747616177590815265157644044544100396959177535112399579192790247240769456654015743682935"),
           e_float("0.52091218562712662917634285518187172767630341749894135032009130717478410999274398914649078715963648005457144921044296883790268408854958169181527784109574621887148811188422231748762344634627884854528748408403233184712659041377142659603990603389166253159715222347786338184323240919133084223966729752118531926973377544434590825784301703429452256220101761013578943007348272333402581469314067173846703167392"),
           e_float("0.49876708091352477066676181960481289403771611297460517940427277199838536735146557888833780975912958830293169186402435397179709730182736390775094159016946750539045219162974294386033088345842631640186608206742058985026185885919457531396079178568904418022063258376382922075766751095870711468851510608806606561769730090876634270193580642501259787377064935507531925124033128879060133483282962106549136683158"),
           e_float("0.47886812730640334436540148403981961259163575860066831617272419942629078345789868630237928182826843701381713400388518029992476806879991577502983810095850502620091300778297142999770766641029401059338892736214071509993019223251235588901792207188170973524092409417613767762452148910083834755620479312604630618977279515328353946282836544729333902323011502143381022792554016097741212572712659042969948427399"),
           e_float("0.46282704637000311759662501833342507557556280662618483852823371549530779837264163842139302377410951373772151058164263008969335964338621338701820564246831875413621272264822562608964373508685295768278814165925148645461113601562250242667726352088474662150286250951601855215751007729706816247636646230230654386915058049763206175134528838213376354744874237114193470968630476744826921502941078598704632789075"),
           e_float("0.4521556505425689333572785852763169815178758002345309486231334115740279534879320338077453906670116170886047756262301319755499532205836876231311168472599872877599513460103422126109215547262069346023365146152604403762597004326051445127319284027222334813027744110793689899672030016954310204275279701733113117599349106724269124110405487363305802300752929237794806200309838884428602565945382248576560648082"),
           e_float("0.4482883573538263579148237103988283908662267992122620610828087783723307550097806471850465744007363628784963292490316997738028894795528196138420152730704671627894105741151837124952143935564502903235539360054967781859247999128703054707191968854307331963767656789851389354480648491609933021355563644946866966432970232560686942504784898923079635408173093776356691462422479246233776964451676808475956585711"),
           e_float("0.45261629274875101076424000426364414907830922410984108827116864402376293202492324204478989985780463893550650266146319198959622699905337883883450688830778393871141798654634292087257422604814442865568361005966260857115403059940428157972535754524505662369263228460265452364978310612339582133887258378789301167116382436272949505156544669116729320878934538738055903628697376196155883507064106111333383085003"),
           e_float("0.46653235800162414860362036841425263406283351957078007783754542043540992675862874185665078186224465438656196969960228946999693008874180564013049222427463246363359732604553483866621667544140959783390423678165029896823479461248325243755301607030967127249728056631615696053454885242222699360169822876861895550134568718244818363277276288085295128685463304384129924532314039267448377960045833470434738490521"),
           e_float("0.49148704366303787146467847576896476106266520874367512950620789872117984937193533619633077042496619947203305030527717149239102333203480280797469527082740653063417479842910016490206811698933676472655252474144393182426275816193105566401511638231101854986618668541766013256836593925174494467923577131320686859723225292724568137084170515059828017165869242125980310460207808618985361027761896104082865292746"),
           e_float("0.52905531725803606086041130738467292660035265015202984572003455589306704475103734190629921891088239070001663179210287301414512524702979347419687373244457746400078307589645736802800236450764541692076982692963085242641275154318630010235744064962869686149872095507619086509688236861708561021551224725381435783692712780882207586027241901162545264900118135278536693496557921414651701581390248148747645410304"),
           e_float("0.58101558998085373924722509246014271385037303371477255484091806310159973076755380463634327109504905855110622607010154462795449135417079664418731084467418804422882852455712208714813420830142218712373812699793519586627768996392858674513585186746217548067601610147071963903056514492602192138053903055174720550405920288829671242351249494855906007665739955776723573942013066082720704671078764636440079217979"),
           e_float("0.64944259185701428585971648790553209709383392086407876440962426197062664874381676587815361743723739963739116066395810848309743176981317712808756113225066347780315515050714852661762554166842937703398120323617811564710915078655725805158983406680902936905897400388610479337602906090519951103898737731039422566311508033706497483575699169854510273064692192654550855853769241716415329356634551694266897006044"),
           e_float("0.73681697713470545677954218378457774706076381396359279104540836610764779372581431484681678516701077219111347275723815352938709949367686030543124825025232247405731692802667075373446926703266154792122747829470458671239712746140064454687759744918615529391105051822779031243715498977211212589008968473227198566180732319992986042726727421805012081946363619620216633161435673158676531478175343420731223686447"),
           e_float("0.84615567905877936075809981978613395939146148187788314657272423810098115165148858242451487404309009230736708741735066792727716705796714050839283705632195889705662729700079831488855354870480127449893250126402092584716159946715527981488387521985239023226746046648648993901487095183792363783773567422390692308195301868408797090963462140083725061947181360215097697872011131588078169506271306276259003571423"),
           e_float("0.98116849072834790251671359355234481169064799892896064027476084067577009308558826814973796240383899941994573370459534481665972334972274368440113607050830297366020150987248750701835835177296264608128581255044024195154128315522383511501929616591232568520858463988785417249129774071074230428668050481565394476264600487180002246738386941984789954252891404502167542846917582961864551654668247258262758533752"),
           e_float("1.1464481438291636034536370268957237797336579970487154919423993180265724360237838261593987142881897878394842442643370039813969336415517559460388163740925411738711999243895058971587081225644766780542141859039194847822056747684728425847227157352890884954744052747998022358772269677978210399069973015213101061681695778738339627799526388318889609470053182722703382803601972966422859144741577120149450053049"),
           e_float("1.3477033950768212000427798396642986401725769356147788531486096117778613585291720346343760288892195594312535186174844387261554837691955711059209703392386623440082092796124415825162156302989922986833701235527094794343017964541860558141210203673103184212262173119714989315150594003108573212425879630139208116843138864549736815083487491739473170005327918379097649838884152391999611429929165215163756038614"),
           e_float("1.5920474522761622643615912645240034483731646525704695670544881854101585877417705573939370217742492849314075314284178547820989764169130074238960723882961027734914041532523479205955412405804337864386081368735629225389320604885691114075775283513448321731104566720924897579720140408339336679463127952569961074104131844091844826487998604848542378133075814190978372890061335672382289755891366416150394308633"),
           e_float("1.8883576650049777469932367960821421141983556869234496601369122084902767191162158869170380554351064046197342728860054983998831906901861816650755340430240730937545802703615556103200183057356472826943838526938275178111846997569212944240853104822081274937539254957474935351900489610250990094806963940026335511379844395041300628179831626691876107578749648359852843403839897027880474817877419986426235165717"),
           e_float("2.2477270158772715670348052691005751393235327265715841567645184877439794819813434634036133699488092002589105152317590167344171628969566441261448531676017805763843735016994884004139014006909586647901473039360963517664185195612639981239354275450256224196027129816234438937287611986704232616506236670300358994095010707965971881058686049656754331695620770596364241975688295799628620880332133853576844536111"),
           e_float("2.6840339024284613786228363465191182831208597885650450382596440484562163090213859247898360358499530033128251109562577999627479530949479210624619167933667173795548839230234854256293855279591324066009066862969921725220845783184220610211491695833482852534999456854040824025461790145933172623973109435830901673099285944116680974960265453781332576252016436854917696853427143972519845706166988950644858995862"),
           e_float("3.2146644258265477674179664850455921188551071736331702415730943890913762063242915361837389307956043197984246715032777002882576929661999616553545176702631835514789026147069511905963165035515723924936088670975935720110518505470646375030377669250931388974770985607013555511930449412758418600029639109414123347721470794495898500098995489240651450461450302829816788460805458070992549463840734416245527440497"),
           e_float("3.8614314672751386556388696194352377897594266703858772530741648044073584910883774532331173192581284448827106383119717434147476262990377902937444756837687282645549658865448849292258296212793457417648929244834889032573879519342394553109770320677251412177550371503781820885698570079799797419405863019298902854377870466941062747539825521408506134621458467314583131719296307113055495666770615327815104170515"),
           e_float("4.6517479856089320807192986854326339056198535561223860194383436062494972298885546303178917061412138096879030251146440823739506326057819597511280873687066808578880556304859767098843134728214211952661775432990783376092891186090595888265632397122090844631354059836020002705053477883543257093504827279001282965236749193504694696441959888234918541201829824701016645430925404294995369204371612272055648730315"),
           e_float("5.6201292040467981109663105406731748975504414579356867291743567161346878043583417268211279867102317141471314886989230309525135087836186357552658213996044046945022088603808189691243979817901677277069700091702983510570818401754260960277370972473574708200717673596842708912330196633138287904682859499357612747849867935913714385710373409476601489832627756173235940835545875515810118706154793732452228409303"),
           e_float("6.8101209912654886822276911701746965863233473949621055160073997661106928994888655921522514006563209546882433210688788733029945232872443468631463041927275913092510499150566402386859048865488409477946438627779391579571832116281143010849232885470401130943068220693261356161292432699772359062165541485569604966735322886799384058393270756496948878820584662963855241775706894767991985267659940791562758834366"),
           e_float("8.2767815413789340506047353652034508072092465809595866648460782671271341936035360963601186577793503538232752699391099978002488883143858750189446117074351281046313478404013154144043600766456465826045860084140302920225114032546147437773200825244392945233387521238115842121592321127045847400344987989468947849840804726282710566225463863894952469994719182352047425748128609442216108527350381322208387856732"),
           e_float("10.089882767862105865220077463206162199498766199289594757971518984035379749782456521404089893990633672395163145046063785666887333814816543041609021834434285991930857417501439531094388256179040864124219133257511779031488423877696315442927702064847318670862929506695364197111989086032399540271422661100361261260568602453008921450508053225779690392616790986888606034761676286272589223629138620976919186421"),
           e_float("12.338049790090995339352692310755631791091187488489755507910858132664850406794463495816223594568586859031422547352301818783856338678012667977141417608324185064157801655977800711870577032610864313280468299072854477509856595928647988006349615028443958332238306686200451554326265607280843618493320793832237485517080113012798404132401222356941250254726665700397754808484624987920890105473583141874753078508"),
           e_float("15.134125720095700181563854811802861873745682869076055238182510793132613164817925635767810558985886312399522716004799531813730700721174476316579669649558457961052171490922308592912254488943317107435757721500919511201469637064149420114914187902218974013791346489675424410114839671935762466957136061796233382929864970869840326388789871288591391157537331430198485674725995160581904447525092460629653072839"),
           e_float("18.622140309170838892057943452652548152138490817203116583569433314382368697892607250656670407669609584283179312653960561619077202612704464787680414220579840399727517575863461135489362491206863318437577619081547521275667585255192601353694064797114665282265048930671771641801502763422785732978939130700582190810199264106672897250996361286953982856159634307949159517974873923171865021994734590294199967265"),
           e_float("22.986382504003384556090219066591944856118458113524462443600046247884413829343236993864066921292879914268157041925822621210692441006413600858881101298996416325381649704309086731130726003574670950882396410061675857734370542972141992620887776279269891876835821670313995330846593167705777785397755642392209991374251800902454979609370378294734172632945561866043014792610117219405696423482816178033082448625"),
           e_float("28.463238858864002201717833997023271579675955996916295769532198661380663679275190723561507321350321561337771261454718767906375524815617198855581388289350921094629028893347991421397992857977286806990243458458419395827575306915988659228106178175328394092170842174030314131099975662803808803495871322415668446143640091703150858219386816700054763328651357896481232651035540006593792749940422181650674666624"),
           e_float("35.356675929101904965660771862750794127342298768758229121107343975475755732389705476345157296500495383197804397546087689097501850290155652568320563529104461949808956611183310530677822636597605055140490076167341063587611657612510129508815414712360915055268503876367469656064508506930178360380226530928505970017506770690931728357673050843369079242694867771035545378509654833036349968462132520374820974493"),
           e_float("44.058534015220602499194393458617220967619460035664981495377158989837948021961599640267050366819644976806652503264885341404961973306696045458159260036487107335654696213982154709326960282415091914062052094851484929002573901274077447800334125148280800843056616171669489192027514459231391236516329552552415413996007100525367691170480238857499132287442284491306075940626747604565387468150970063371380901613"),
           e_float("55.075187413841208274394484428815454756611342333000484398647740909286458984862887749330290835894662058329443839885311315210737742365360577433001205001334811752079729351446624594322606974065681901212852246588050617502750588976241253442023886994304352133083834413671296573948344285729361156504607521779321453001975682157060326595344132530796106009172599248343091731785500671784268671380710710280349364674"),
           e_float("69.062647285660869703756881178139701654723737730880131152530429240655035873498647940562553911832704549877042164698192326632008731120796079386882832909587835083279353284873250562619702526816839679969300129199100993806576321140516279783709153326479419999438911562609153393193100351937717774231343981043173705784796283815592184709691495999658868568089189988789417089321961624315069169915349925681333171747"),
           e_float("86.872884514468994022178150641532756205081724063719021679464590802899042332896963527957581912178360898914097693632969215165691961509134238106042165559451585617956704400764550651299397802246123585783647049854353497012037229287471030783074685127174169306233570792518065267635324060251208505435159101754700184685305330936558585329096640236706228070498217812906032325934920176737833204833520832806939941173"),
           e_float("109.6150958180517149940978862273771846765171714206553082284410398888021325646722765618847448685907263644763244138951558017069979839805920145093229138989566217432622342993084925806980285882931134731801741295866993000243666765781120582688860021166856317226704900981860326431513443416981595180808438935474156870494072408281311664377251902532948676893291256963055914258348812655722632870965802730025560086"),
           e_float("138.73691478367348450182487724227659852662271854769136427021108967161924246246509019035003368028909801005498718290589757544956969432590476957725438107852098981395566050429564898653443286571392149682449954872174715279083358872447185202197105243783286315426776362887264780026271487506781784772532075328763229657377640502863486409252742198642941063185380566121773786641898104720903542879196684950503284366"),
           e_float("176.13230081111139440410829764265144289835607476069337277877092837550525538188351587623986678517314974962816334472199759817989840906331913800149723155516277806852593163787519412163093375351711453560662751478444366588264614043927052011326694324506489110732953886549401952637918713949974270995879112268040804695671630923075514895774243349743904953325151081068694746931940351084202208295781314409272395969"),
           e_float("224.28518830758402844194315977733357518660248248490823656339945524856344322733811043723266196892563782253774068995408572884247016941096153969345063056781494163625912833658950476617460636665371695167253365457239265662437480459555454851201844290028515362577160850769358674273889912846380010910595729644422721857744697223486000462051544456186027421036472382297870688732920378623664947641654108894844531891"),
           e_float("286.46117291152211502133318483120675634030896424123575730143368521906056507075550739383588066400315392249726404351638893692177364224563903331903955033426126675945864851002161687007235406672668511514724670152049417883453349398402311857244258591863915827999931306619837426087148412862988544312754364349545943456519823029244741448400554765585530958631321631196819869612279939004458413123205872619230091649"),
           e_float("366.96386368102421976806516992633824565415088821869251412524178627263340738773008167357399604775099836215000113857657762340879375085920180328592331593549013632035438465442683547787502117525489187472636569636160716278638206572266012977106981926164921008023413076768690562237055703089337138679971995651641130285983180775949179431920198181889447699909498459406752817216358288745546187419602941312731383373"),
           e_float("471.47847147494723387362055655497822700851284421395180006790689453667717445866321990639214577684721276880876681448605240128916389581901187757044763265079751320723231765636802603816160668370797955760102274833085729442756994967232108363315609218543698681056026960279262415508549609335347761541135949867967748997780437950895348875582543864177232333292175205467360323034934075113739133925955386951222728738"),
           e_float("607.53333056645356084951057127514766420221824002177129178997289509750510342629748197312245120453555136432888581513349682248498313999886800241304085927092718727971520977407453236150858995962795004594729738488800022933259883761461496913803406514421409358203111412102397892804717627173925171606324243273531704562743977032404157489588323869499188400945003729261416513958267245735159871002487934432166486079"),
           e_float("785.12118887192901602015669634549800071648828207327199818246721227327813405263840117648729618111120380505726526945188689334048650343182831259134848992303628699473302711385151278151979003492033135510671414544167272614681816054597806548371449212311014483582024832361052754072216938094014707600061519925065870838828077726288449697265758371333613380375902056104669195204384543892353513497260143995622812027"),
           e_float("1017.5373982518501602666430597843596881218510954090015457916214834003867977501772240717536517144933418878567883539868933935562714166326154463934669208752700764063050885555363753262326928996580521416022985844843848742337545925536666981541695629816388033932025026554086748354822201075207251297846696098966556365763412939925822934111950056281567084165212779753877545168958601364817967192065067172410002261"),
           e_float("1322.5131836311592308173897265631258777812528879107853847420030991441626396928387769578525241035737786428073658327495383259411364471365893982397097473320608917349016544937261626989954469131688742312113725559025656191553561572787509664046053345927169413812512444690265759787375122663379693295216392845527109810108918698434984064596586125830860236916835390567053585002237656945561007391264199264799156351"),
           e_float("1723.7511876649534600644024947043320576819460554737287252557500593103187596301789490117752935391681572904316067643089289707122300621478748644435239370120066411556067968504555116010287192383338076429174959825608650090728928131728691424940245127027169683109288108724390723130968315608120652315287670344356779461548029024345346516576645114056342002261559638130659292983040571074507689196201055736279297924"),
           e_float("2253.0105734812070624526227145319834724733668498793245538466993562307095299480807102606915368233537008442342934302441055473874781124355050726953361240000664955853281778311274660139602903641758353926376454100021300317846229947898906647964633059254651614822141422106791090034286677860084355339846505468706525762521108410104921963140650219659669766351196818759561915126740648614537259557709541919784985216"),
           e_float("2952.9444516028637089364821213346594890269592448862483045850408731477752079649868869419972173657369259215074781394641866927961695753911360322355556400483182618782767210303364570173404043441881425166282250304120533277676679913616854412261905684925898727424357717869935110544390975647080430728438260354949129393872109284407289835803828642019851898926139348412166051814284680907116235685864936347631052458"),
           e_float("3880.9693431905099543039644209650400406081464091679619310829202173733373569464354559754762691987870564524138013816370032600303878572552072641456400689471004603948876881763690020915564732274157983419705521506088429957316405694899157704905095087770510922007244727566679391120952533729775642096177789057069410004386164776505549726882420856298934854830186029487730206283709250846715982205741218917566083123"),
           e_float("5114.5533105191204181663126515234693155020944536376908180564315980908753319047079747173348956195619963246031741967464586863869663216127870166917116713711634059861559707399269096069232730883620971098554761288011229699819534631233020264366935730556770897817622076694248362642801797138240207188418507806291816525141657656000823912597393316570167078202760911296153696033438793838718275284416462231837986787"),
           e_float("6758.4582412159917946681482271880206905050944252523962810185057021663955879974323630831864343776738862272382420874270428162151946932097260964963082884940235031316984182305060393527576569689706000763430982574406337648548173200203051808355524839170551648952493470599669976718768191071479883577175856519477341485405659542167232003877165500071362249689022766513064175710480289739716182708248071364712770481"),
           e_float("8954.679416000104161319395591648703715681524775715122038315145400868020757692850910969513616447434737275397105735094444719750974065078605286469367307414019798293171366034192606811729189806659263949873302644506650988139419422738367920074729694850238096572884666187874354854704032101152808661396150757921558311757711132701303133403144466699903922759392512145501844580550462265293212786054333090027779063"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00584_airy_bi_prime_small_x(const bool b_write_output)
    {
      return TestCase_case_00584_airy_bi_prime_small_x().execute(b_write_output);
    }
  }
}
