
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00572_airy_ai_prime : public TestCaseReal
    {
    public:
      TestCase_case_00572_airy_ai_prime() { }
      virtual ~TestCase_case_00572_airy_ai_prime() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00572_airy_ai_prime");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::airy_a_prime(((20 * k) - 1000) * ef::pi());
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("3.811141186373833771716692691964416742993016466048612109703746199228243372570995915856761170396462895706403636024839624634667737076291875126865001283326911086013406922583409881816458286867925034235719032048901486016789928899294785312740854339262681291352932667703023331475766766961422441912163840785521261177955734184827689577787956905412335965624861790617430181163979745277733383199016617365062980183"),
           e_float("0.21534542359013378208269876871602318624262352832508516946431401834280931135387805450398607472987760456577271055640293658883324962246604320782690850708489063585743215192306196950094763372843863038811121160835904415725384124401136558886712085845984687221254367240367401524672272640741257596636125013270438394979655594086101228661073874200781278026595564024365330575982797460328139819239209291681585511352"),
           e_float("0.86916457609472776549439542921990453321226133006953482476742752816081416485704040933371170209461574645620691039375899952129925332514635206765311769978322988497157386487154499788244792776249874412553652167362413518871433327452897157051519221019518158496320030583890546629661366289054791246033045971835516203466134207820418178118293413028631256021368673428924744279296534218227071801706342283348024373159"),
           e_float("3.5424359170577879452157219197034300208656630787237942885587978879722735148361625829150469835108972650090320406841826046584437636355491626058798555069908203216869428426812151769086031957837084327419913560818863633256076200991373758024438217773875565687482460432830824371376516865514609064904308804640992544604062220347002767911171745694429238004613399099144721021482396933427191770135886698506438864869"),
           e_float("-3.1716664741239127155100185907528096982007756424576638034768420507720287348392277802542838409048861926712153401541403189775660662160543111535058987701791371365139621607904742952675519837013369717900525313985799225249238792851442244237863349772642134082280299960538776230012286698420135390000678070831286874720844380811388544337828635066226477036837576916393726829484331120472816171454108809195046329746"),
           e_float("-1.0316839246155142143549203609128503527928472409399964767754521627457881136736869551782254048687100237601476843323809063648999433761518134838987703230077839882801920081056081277047843952417071037705741932152716771289375621114807235298502428915495173417947772435099013665489560023716536520259179324667343135734940971546148378639872771112601349979344763482746128596295067473840446778844502645469467006988"),
           e_float("3.7906056915129080304750780684093041750508557160726609602170875833246515630745187138203725223586799605047551529900527279759427178069796021740039449189862934482668964746671644211617865921270430795805692916830174795480387302732357849449392181837376454114346064000696846537205395343043497601874658006547112479958686705480999296038803529603194975122224476202707566158870364654566369262582368158285724262899"),
           e_float("2.5386912402633954685651574349418890412175130740537024349477930463923835240748127723565196125172463405821875532967748457504291490830721678131646989627568554027198516245138370476845681267903878268468630426217790897710005945056405971812492256380417256298906526870754465335362992420167521161503099650793711402087211775953559821968807865499037041595780304664802297974353016951064451032557610742623295416993"),
           e_float("-3.1326965618540294156660870299988647535096658021309555931923326167670875241906142281503269761428741848554611351376816946573310690863328911183963535479706736368937815861064582492909592936770258933506033841956968637723627373345767405057849416725969690164184728524343401397817433407603431432198025808734399266783459860426493085813303681220037332584777912105396898957958900878849506434821794675165705380253"),
           e_float("0.12972061050098264915082782675391813237266919426927897548406273539718681856862697251044935201909995128454005234737306796054206232648260290827288444029512685332630223381175727764368098545896995110806534705464770142757922395702705558931756612982560153801656495549692224086353113563250551100481782917376312748531685180597598056990325621974363262977390607788370299480522169336406184919906875161629702686388"),
           e_float("-1.4502613122543473357205569780743671174901688727549838516300858826734000153348464618617846223812907600166137333446993765596932954757024754450873133673167617896186590914135398155250899446514234774785547443788963762978071907892189981708832549729677454736241067777731039512446520726074938349798170000375754989995792355774367260639537210425386257573942395165586896635929128493009596118610957457182921425664"),
           e_float("2.7183795859003871540593131743477432583830691200344881594548305035616408701803164696859615750895989821307226414368261481201035261650526537367713018555855535122960815433229149344120467352096997545555815889032968701967674400018316611740217606920812956540214955388872279572348567635907636923822520744364269729547658646799993063436226479035265321807091008761559040725702625493259406666063382481842402249077"),
           e_float("-1.1576177972093184285473761137445531296990138074041914116439441499566907064935151347796778286034678241732066774300505838956856162851122392604701190649096165995121570951566257071548669341858112987351338103715246897339571380509884301759876495719623185627240804427634150431465000780201999903842116159566996171616387253064541232123541861326672604798842747945157446997040747050127859088510807923662021825564"),
           e_float("3.0884438785267689809161931946177813058472174928579918794927905533355347716712741045485452347779983740562944924638275998689553022564530608809563787932106624495749552850899157387657522107612622177891006036897769167919234320086100315080869957717498218570153706295021629392624674748801591120403754557334776942761700643743692004323777169030760356076654376305616621737550927941221219895250117436252648980316"),
           e_float("3.8864049558799394634154077352003404639883755503753067888463596801521993541793451093874210200684092841373461035000983955746040697750256752622912510926416423583660545222510378905472737227931458628355001822045534497380560154921019035559905742269263954142308345509816101331104080200035935498318368698123120108610117487830054989816166843559714277976610167719317699167872877054116196544126733079911399440393"),
           e_float("-0.56680498493315603521050499194223474378521222708217309549999357278855934901347526483646005744432619931338575038923179982058718324989734425474776682437739391176017698100451914998226508103532619908598486565046412045451456839689572004032136139167636494712410181359182231494329723047721989333911293797803470736522563118043605287651808607464338394581691775767552001840473671674111232891500618062482141884507"),
           e_float("2.3489311401989452630011464036741854396972752456639494675186518785742395111663931937994151432377327086874028932572265780221313481107729498768287272594015895382648085734950014581670298242298455189781359744265108095066511578716591405234947173195491407914352441490672008040877187594328650499925699575015027369282546671176185868231276381839076600876889187238527058193765196964687932473146734132678241339514"),
           e_float("-2.4462103310035178567537202468191354213375224547160451481041341145151637742596753923537055441977780177889747663581526825068872862630347444196855884873565572717127035926879124067993142612499143184184476644742353389064281614766351417785370113278922806870884824909944442579785620036643489117177158654014402941950991643922971752850584637678723421011256090822293561300002870164604793235533447269719983414597"),
           e_float("-3.7374659668225310614661018432115256450404843466385872336483966404099671030983823586443779713072013277908603713944244953807453274279960409142731912868812958022288809032734037083258549255485782022449543988346366318774621209687290894607152696002230612436490056328925334534225181393956204603159507776640128793782908595939981700129740512549543134799245282648995856783378474785899635630041934146642810077111"),
           e_float("-3.0465878984528758620461467793462733163738337734864331058392445795396499364161353450281727704582474739796165908642680552141840098997346700801997113201533376676777244578942487875667217520673891728393943324358827899252076171682743223708263481503164339325553760163989734419538675856802442244600853095066070091284272902592098095789195821849345730797893600430452137281377793859009676063787129339792639985724"),
           e_float("1.9930174365308467021132964168770816504232268955885168338001470101091512039908841266990836164441052502906340761127812717698221219796865758686402245718741598801443749719862452512364303273254369731027945337205253867527249564361449003791580702216178394616072053443534704700150085553830184847773268913728659673049976667429298658253551657876723931086628110231919292668251307333454532546300426041987877205037"),
           e_float("-1.5203544584650348121537881929673748549536036091393354357216724563297257726013417837860730196533752475052022231992461560816686634140128672674986362559058320679727460630609564992688225171548698704786833135580828284515871437123245323298010377091933481871547757905228179593819199687467985412035571745983779655059640597069813140900248684756813840282558783468309341961920495327052321585405324699896212248609"),
           e_float("2.0436517901557015503443966321051287773653150841163875600762967960539241017353197770936874074554503333698911535265334237691881899796323202510552516020523971880016409641208706477581615720016312838678319906669301313342522761594304727639556029104005259138944505397134859720198491367432672380825758025898392173876880240862623789095219342304172076852887134598562299742945645418282684184799524788999173885436"),
           e_float("-3.6025412515531440004395960173340567934637951239070477765021848317878241779051385277026599376991168424545485185505464003583138416396978976448321282844317170336844232362901831421060538425330243018259250658863633584894408822779849389620386999807313595167763013562138597741023708830290672687367631746890323800959547445595203406727674558381479338648363817262243740744089768880009461061413953961111702379225"),
           e_float("-3.3392648172037943040977415719805640732268786186460905994096070888085404983447093065206008976210585955649058184030472034067908030019694317831311913173648966531965942946564127742885210467839362707112413141879515017352940533333290375578264032834697537577307235797018732009083019590247828966865118456029246187814272159927390757710441945048282626247004608439713387489756338448347022268529106455481828526979"),
           e_float("1.7014026126757290150884425159145755959222818838365586246505333410073075990895727662934923183808618493767184204204704966117579656773821753327404856308985535879181034083801472137681466922689173795290056298872901837482577695583681721387646325270229487550356539545717575873313032857050661002938702600747135421002306026903038865653807234753396691250605406773106157971203732026781583556455465277835086034145"),
           e_float("1.6533476352446733840620801105163779753809405602069097279536063477049285642967978252112730115235860304821201002085140580919580880428802434266588552662028792082049526032360208675697324389325821722466326910453791590768996393193241169975815326673744703288864025515788494122445604539757619470280339916468861108092515584381344183723032410962565863794259812967532100952563840958699343467479411595897932883088"),
           e_float("-3.0861219684011301480380788285689833633566381164564772129461746225267171905754141185397659924764096501543689712272117663139360962194925524425381986453713908114405302111050573936421235487339755696450052891804605452647631729698182513399100950823986748684315954227036637719752636616108200770765129885760692077075570201545103923832001218869937514655116416270220152912516875293882559583685607050107447416846"),
           e_float("-2.9066045889296162211776068501183570152354841158416560348819417515042111742268065361381549111211830742203595388383915517665525477126221050395316071818781917916923283207173669545260730624413166215959252926380233972620180763670934791289095486796861891711127895920773273702326831014650936511873227973484380499978616630552394234157307709733597093913661558229007482230052862439168434323878952117836821249705"),
           e_float("3.2046744065307749474983140361659485458810451132364461171064893188708075207048472069355244154865890342901641878403565437791576381511289053249517007573154533855105919664443903821112452672838061268963118711391113035787446428436567411480150893829708937015827763743056547163775489086151362898078340793248848519802993339676194521523163887445413371980038200842642253525423110738375809336594786314123951095283"),
           e_float("1.6440524666997872273285553627075610211962102578516444363128953810481462027818623775803042225013527961037658537817529259266280859954589784655882542540993788605666544484667972040920492927654145700915632881158988948763552907702457723208547058520623403049790001492734403841519419055905769369047022221291024290060474300591798962887698694498389005635804514792583378625071809685087021587408322194298940494724"),
           e_float("2.0060976206870906819468482816745210891390759490628091320173268083805587707166613808629728178981931697969787479244230945311024446488200151738412239701007714726482748932962362324933953006085248690057528769760076103415364100239091155848222787269595124097249714483126601052249341486441262224816380227039841311539446165589487341772812473064601450551513122236464588106098372582574480370745993051235524108559"),
           e_float("0.63978213224485854902069589553682608190715836315219355313917451033514094465874035716352307724477432950524744371847491932240300089068324638661388621310039783763725379860444449409562374308620261280193888585582759282159115256007827110981098337263500908995014153109677565422939489193813537678947618757435625946619899941506098148507065036562768546028076133564399035134067373766196721553260986768101863364758"),
           e_float("-2.1450508906344809983048280440694720307358893294044713673349383328714588961067299847774402547989759555051652149881897274555664361056752304652136974303137364420691968884390357070309613348602625983599845834282336361183905578522838534651462213732252145897456741373148781491765416033811056019864310505722178673605962297442350618110205209648324500554661813552419862049267085008066800485238933192696458939386"),
           e_float("-1.6292627901450332962927513886171229362412733863501113475615118250826118805819192443922379967387638017678298143111648964745561547978866012261221603432618350184948407009067219850306142704770009008388402291719859951928834089881299915705970239303658901805317790775587572727135777715667872074359801733761602453798777007551500169094379986475261234817639943188845996441727468475347636937899746904503928027496"),
           e_float("-2.4685453515794558968894754136464201553716872412169525076326250789488557532378941062667780648384882543006934661540615620359884060934659240252030855080894909163737542335382496124730223514952683438395858680694854622690703754120804147290493523957655484006853441942065342006023326068468657005877871001242215810314427936549879812362455772364250221495997562915996019985480568542807441556340270739118756098452"),
           e_float("0.6149087181202799258062869121042266239496947469138976826853266816667815862757992691716648956836787509698377169374537323423181676397727130470187342043300271299448339571959543145598835887053036838547898970873742879740465180225915098098241989632417572761594413282240102016532601337274485114549893208377870333071618745446825874598178862357176370745497031498220507675133245605209872367009050734345829398266"),
           e_float("-2.8389350270745310728330653617273556329680369712014449062171164755667836343080964899596365779313965073782377354653592138978940608077170686857104905115779992988867449319218888121444996026013855334152102148982956202986028847481805802472881461591872925375109827140119652425043974831954010496736710179037451399862104305630214200867674891134950681194814875067515882102461269880893858972060790789669688861368"),
           e_float("-1.3249424100302254040653833211549553141475923914828869366194378367590223156849267452769820638835897278989583561684486703880214841666031984868483289098216812481765120819940798666638693286431172824329626774273988252287789001924681564330738211384797516952862974160928933145736584590973121601435235282300019890967351126302598373641927330211527934498460290563489999670441188719677093391656667552756977892962"),
           e_float("-2.8054767593579258363635138131657752477984124820664355133276683386276999363303678735903123840632247082818169425668492144195658266446434925788815974679374458035171925464243159492218905153177291641973996669591723545812264731758872163649860557138181662798205795912078496883676240964076384527286301495586632954630499001078944013616086755696785078943572978558719047491709785591067064017494404732582979665299"),
           e_float("-0.69356407396472484959111039063494273402331787320128337413079011914231572001440513401076401937372437702243333138923670382813222435909228477428631080553814770330407709644984246875648636505627557127856358229538936795588615995211292254244539923811268228239485908892633064785760466683329197801321408485451410532783900776300333971879702887589037108171124361804474576104831257839327164114971446037019904829788"),
           e_float("-2.4341185323255405780488883026376624110334897928048477540437289886663590092205835464909422987226305410661546299125891834783431460363303744179923975026456391735818653365234080628872971072795762018647089439710820776695539820192551690181696676182337255864037622909229927466319940061911435958069900098800003786235814522213232071687371625462169922095239116418420486334539846417381674682375765014326994567485"),
           e_float("-1.6566485122608255177351396422715864515177691152487476455206620257579887666653974012897070483909149215309035877929424458417234493249081949382212198240633829973268051421338162652624120680872678348303955231351512171709427810589670750382288679175762351896750114841850547139314137609541041836177972742605887146502421478032995806027828782707485101672486866357127747883550836855416187717009538480781563055829"),
           e_float("-1.0457368974645037443922444372978459394120753548486827684302917710139595141474705988933376685818097091175072294384896790057107611674642587780916924431591261278901054585275793548172890594715717200964422516359526761069368486618690796287664749764832058263008149678070760086595115588346918637841177561897584115216767479899515724054795174067594467766664143066038915096919009728129320263399777784120567831675"),
           e_float("-0.39458150992294266388912830896400815691866926125707736532526493845327092982021803605843792970048736775295799578888513588338340091244723259498852834107103781506753874007607970267136395420852265796240756563282158037314905565652919494177361904898443590105097783058545323547626005051226614797797128081657815627105136856179070572480493735845640762580776653564448531331171682742444641011700929989175178893616"),
           e_float("-2.2243182643199586076810503757104779222832438479960398562443849330100559229032053451869106248638392655287259111387578058202079106300590252411339085897857943723565063939663495785859082628676681605352711510494955710839292749433525489770221410580625273028029264777840989384364199262882566507077119339071508778003863337355275758854094860168422209638950140026527865692784411425485866975697323365115765921814"),
           e_float("-1.6367507002243033963781134927886278307656706224665925397134765653408870893434919615824800072049249032035702295205651729897582435493223175709089578586576890729433059288140119837874129154577521523808558472165708750884011818892116627466505700928573242962860573375739223708058079533664768349836588166832443970403985755724903216405379460645624910888696551822561785973265509477701783524437375694603033368596"),
           e_float("0.48956521555527394636094943622986188695029684311446739101960975776907218461685623952053962132382614026340932681910662370862366467723731216024390969019678651700540484621173899864372517566584011397408678742505025873955486289408370609143497604916933379603712817199491380897045462776172533622670073853130235861558665478503367067741319813845963607143180692796249971124023530264607364493739778228325990371958"),
           e_float("1.5856387568284405110848738238566133111253577952171756080553430034009930157229883085757464070988346036787337357413787608950249174743157290251173031222713378910182934708481670191178795632735994851341065437461117348843073988019798525741388691454183309357040765570377125613297243151002033302585872340337502864945125600963616427728851458957120066737748060403037467718560372531493578685109344892848929963954"),
           e_float("-1.5591892112570690307254549307089935235853616824838065419434036962966188444463931281827686498754225420930931792027677340071152895909961185911539110681128696409983472744276915479126289794294064931622759671812554843984626688896183330134465377754063769561725901635626988359272981692188770142673699216705658077899721690558675665116779784117214863806423802115534474782157528406391818332472423389696561414927"),
           e_float("-0.25881940379280679840518356018920396347909113835493458221000181385610277267679028065419640582727538431337119321178913338127503595216762601478505098984841944663202964488880560187838330512695052512829334249799988357074907925906015895105094432208938405967357771932802510665017017568983657860752558311354781713186204495829272133259132682105203140001182996722445166103044385530003968535953695549959290311145"),
           e_float("-5.0218732430803338497938668067544618766749994920149090291061569602878699359105830662060165028904473117147708258765278230337657296323562987523888825248012891975646563416815472655934132125993134538556715296024470247455061012684181694767331380010588826662695023180482884723662200873843805341772497053607780414705906273309145900987476144713349673840798765517899704250878355036493470265674400218988747426545e-145"),
           e_float("-1.3131376364890231666634771826892768941379217159567619389581627116040148260855349561771826605511363862637833036931872966554425270315958034828040020407528200568475136881378095867678434553485028182227912371831687312487948441959986137970468955386327346600957810699530736612679488153282197316576983294018075202825994722382112198678457332013951098401639885589050829116329616267234159005760301166663814481981e-408"),
           e_float("-5.4728786160067633211525326303235687667516068396648769606478922340653188235495897998786632960597138912018476464110557926719051943374439473012239744079925615683070323119998358289538096980764961689624339820339820770109539779132377731031330742248242006495976374614093574919142570649161082089398920400344653537712162407831482341734896421291044408444290319657050673276251484659837255889057783138350683654649e-750"),
           e_float("-2.8632601960575296057909511600910403710117056400769323066927778291457019094901799928103768849284290209202569234633671568639229941334760171263588528418033545015221678408060640441815890213788004195005356405661303357235852929198301723491597320818748157621118335353803887358360617621040977941908118243115241696337221278612795633001075320919380459749761686477204489223887879528691748090255469098038931797145e-1154"),
           e_float("-7.5615751802238664117324103502003829749203654461560727939972296598023472273294037392797216357110894644005934677969877886241015727603122622329312367091926089768310017731486062281456501982972152309037337940945232477673844575650612468620719371603488899896836104511024199334995089621248032606143216463571685705555354481338733635473041636830150748097428003836879341744557063778460805854383840694562817411163e-1613"),
           e_float("-6.4224394913690892372745138583075949943256082984097671168528038793885427233721599962003360383333652858288016162155169086389215730987267726838464909686324386710140447802517625965466429813989975171310654396468221049443928480971320003478036463291462958298691345068062160242186012656434605354252125101718667898741767628428008088038738758007216647126520419843415688756772739452826066710671972659201576911576e-2120"),
           e_float("-3.1962506191029712956637949948650868024732799586383773401912873132574918306958053453670529472560389872657535606884259299786002818770585351248053297173322761616792702116411808876910011990655367877254432458372355658998516523862245683088191591661472997022776440573810975846536045808415100805729767165657754820741925367851831814156990128633392222030410557271187817585002973609066723332444826196136295859348e-2671"),
           e_float("-1.8632038936971219908523702067050368762350951283546150840058414618690856593578502688212884160236179194056243757150476245675579744110275854850590342618552928282626652062805625958250285566374932364609446858188718936914242479996862382350933214928394146690441404945442480884387268670758116863118073112997235532786045969665477264427909510574222463666030965300008005661259485864908239062141632511559052107572e-3263"),
           e_float("-5.7553435337212688318132912845143265564875534984847363772549477991894677186760845722663468526163560113649451144067624716904433966809305734232518682236159578822332956162969112051246695911920949451191312427180017653266867233701267608244372623069053308615424421964864530549610710348610913848676681993224300949800436693784667812623867329400284939206082694468280463990268737191685946109902327994119104214135e-3894"),
           e_float("-1.4818913136466439541419222641598224338350455088048660074012723208876084328598535829832039405529006556171815009929575061778227270315958904040482659212665812251345434981392618938364877776037117543513998847936995238915728788348812722595996458261568110254352602019937602882928150868489477603593208912029739373298288925460853230747196665160803690687650183758316732783022624897302338141186034570712970667825e-4560"),
           e_float("-2.2865959193653974227271190362831492688266551640660794177964893939644567867882210886092113746034529327084706009061882313674386443316010834699301132853738329996063419938129639656543556146347404989995018403454058218488068731945846915040584971404417473019738817573565254462639492961416906037626794467157469443089470369480530742970632724227868440673004312975441503779075351240002082942822970285637462634438e-5261"),
           e_float("-8.3465387667907373803179434008581922680124235996011017687331998874826100585614338715331599659732548361125314297082776134110246987129476936688431856275533210078872695890429137188192820834743166160813773811849693596630880803595457345755998714197010270126925530197144055538625394464426671015040119874975491449102707631702413326472348609050001170475788302469379781038254379965942015738965883175151830932172e-5995"),
           e_float("-1.7760128399472248978567710011077521076834132896436652656890989280338488195900088882985559187756138685007347933682943349262724244053705602394697618752040743616216042632033033759321831183730954683810982609407158954415462556620848372166275374455608666073647210774819041978939570012908801253474937728133585257445775041037118032287172156633311683202720834031987038720430727855921695343936691087885361468193e-6759"),
           e_float("-3.7186252791802005750583977792031517542901288907152798955154658665389441424522343749956041753332854006716132626834221294309284421886211232608602033278862602794700834127092381704122687132016900694609464617654710858293047721396099484376365839584351713517494789159172442397052935239682746459146003197913511310363866457590532154979257554821062623596537289156840240169453540280829198307181428843564970983116e-7554"),
           e_float("-9.4926960813117113426033796604332332147214269983160820552646505485766384245333126077262576113170495525106380029456037929608965105269155220874132689626292165691602926482061425456530087039521271812816229664501126935049706379220061454621706075073282959850291027423940344190319023840685640864983528233520274244481424442068301896566191668808828804001776668388711072375973815383167963302044439494652769642863e-8378"),
           e_float("-2.8319862442860961169479151261552067370960565308187349999054707255628850202533822351975691437164830166382821254106949413726402956164673729587168856604332119565650140657333879565778419109463002961753776808951741007571640648707019233005737684832373703115837373820387804565355612217722273085690995814620282222422668750002734403865985856997665577321581714235840072198541945258703891878658327374896605114094e-9229"),
           e_float("-7.6279721595034563460596740924258476241305726668868930116307691501484576676513278652062604230415826739329650481646354295219121440593584391240841222732914976527905641366772125722707897113724101289083328331802329571725072659113426170220861807085260398798606035284992482400851223305701856899271495122208964186462751617937753338780329488413089461116803138344699064754331792162014202963037566605287691792789e-10108"),
           e_float("-1.1928610510265566945106161166470537470824462720980840482927341476578808648178669951751313383134997603143295191783320409229859068364926256837339960169553475298781829537682901857952742463143719899787023735293321062727265915271835980175771171739575813123450367828255785871450340449677651097165119294358127496627812441574410449438718495276324208238188234588669394757002406080369830543986006367752244242608e-11012"),
           e_float("-5.9491519526428584710221397879424185973335967139536540654570194531592040026714023288321793794906800113613043061202677496738960352834608023909240922527668344021300702252068464215311652028498995614912146864705830086204237734940729384766379564491733556261155793090013921957105595641181980287815612193561107571351376049706684239010301780964236959532881548444378443482765523532164851349105713200540239102464e-11943"),
           e_float("-4.5346720237997983305867977953163706894050255207332180425997702248514691843886082686624258682750638247912334862484072227854664084170211135512308363690167868656211936915064362734070188277596684344168879402116893280614274832972488570515124490091037287243371910845163118478278566041605654731994576313662997449714137057715851923639173053301803452231811946698055891743468033877372534404604987426884511521583e-12898"),
           e_float("-2.2472033496717686064211628948495115867161928640761931492159057296185430007840475698193634359630012869259587540052642334247927485554333696795281845755320075545543071727500910731357159340234429072694864562847131977267067350336678562653989493132407895898880959173591530316232064286980779855574164232040271413926780595928908881181228771337063863944392132137473727178975172257458396274845647826178591210878e-13877"),
           e_float("-2.7733928328126191190774547268471871047916218913869311310329178658930387197522420318705618922770592496138924088548617566363372669337396616749207551164872284402699508784135791812465266494973517119765324685763438502480987787602332553035991650776620146870933039894040388435175330058150180659053281799921940901241798025946507076012597994038504314755022107519417318084468703136772416997966997177876318204473e-14880"),
           e_float("-2.9760953026721969622211296132949531834556508695017207620728603238996013658089862620828010895614225881804213034937934254646599081512608059692446696798191175145077002796943100880391660947093157304374930010200304404676980974851243557379448745504672288234676686627415276881905879778394198392767933494677473546098419129239193690734655343145913067973344783030764267201676291452671978355943567294905046351618e-15906"),
           e_float("-8.9269294499382944735423313298403550749328687236249665216440606914525433603002956157581104126900264176712724124775310066821675531005624428676896911967489742820626284485850573233110617816806785479307530613064578919027700940469680336446234672325618740778187643039824166134986192385399651495898301705082741261254254716313642556813087253807240745684387268451233972422910977877899425743107268429428708001796e-16955"),
           e_float("-2.2349514299721112762819573084919533748422452610435461066520791121860905394556525235989037601227528399455739115132587395874876858633599090093866492356998720216233196869493751209461900892525604375689196830781678979767167226149015798998768668850393796005440393400618378139765971170664862734636302436974731411206241442021464666999253589224973241609403529259682884338278587619999496090311581984021870442149e-18025"),
           e_float("-1.3050166057882346379082113640165775718839976057807803462921621554303386093496166040048519273538237743597406130767377218594267619489530686486374177824622144782333094771048617756663734651846327247744828904320737354036315492460749424247826602128130185336811115040188477435625695852990636907934296094974036749927512545298416837519138498536136129283610264023855286169920544283248497234311225764030647270104e-19117"),
           e_float("-4.6773397138638198957260656221372117832394247837283731316824794204480433090991024108184651311700867879820286129828655667005141188962284007052151983632777440885805046508505399899013936369030772998578783841807706182862975847095563250919038546524901951283303544561060353120264152555429076203091726197617007210927603055062768661983934676578171573781840071725640923927304662602924997442354443602205806756992e-20231"),
           e_float("-2.5649902325579965845618246343232876214180585950483547569079841979320568105366107366637110102860464798631047242288737581521332431900502945344390577080877454653497137226811814143385496650783369653790932542205522126952177303013983320959413961228956043969921563445509484061519964715601347883311060898933148177217486156703851899730603546541056497467588618568195486138894597168783993517469710649975209906318e-21365"),
           e_float("-5.1060885524376759158337098149914414215862401573001712003961661649968504695882749708614884819403035496194605965406632840820453033333457902993362397226078355641103060756943602525938141935454978443316058956228594622846144968699160722474176258800835847684669960834048343839154897901583448507585969353588425825024384645251992193908678583673974485007267261208052940118330599729214010466844803238401778875068e-22520"),
           e_float("-8.3681453004281046362895271451956405148551001490159598578848054319519850214115663774650414212061230050554581145436889403579441229740749179917797092555378254842295846837818218580999547305121523893106064526441569579333891366502279792711348744185693714247491280587772006095792770244749914076661973385601962839232857512606484766022300738651312668657569508433795523044460225027021506084789733179896448162539e-23695"),
           e_float("-2.4569080860716985085299381032512893953313956255324183907353297590785324819804514437893955277940604116027608547233147921706766164482693949826105662024673243442161853821497283705586259557169340347160869034487563078003510252759295141657579681700917357843008742184990209323153443082179002310995901583900105188179108886381988728870410185724001275671338302000392645110126279997887144415670559917810536043569e-24889"),
           e_float("-2.7074851632383114272136836337632321871303259704946404866744892211749405057612829708319474021405614366648722495426443409171633057103225984193244803959558833032129810444843022360241539994706661735110160350375747445631162852107317524780402634249894706318687392483437254275307825641013667979205037422605121488842953663203297044542330352269627063866437217869081082101078526922951950912770127532104994251388e-26103"),
           e_float("-2.2655636322922969218797205758045358618882522882682333754446791108661993821717958650772658043533422335331039133287264897368533267354297933207111594440953017173276464719215832832990446499672004312962990025589348218869011933615477722610448910987564490359918822436383876914660271971747377254185437380429004612643640318638277140269855713520838900078151958678883590757028292239416160386284305424488044010242e-27336"),
           e_float("-2.8197571992403850160368848986732430211671994707157539318290992162212481554837861915168247317640164372923979912177244212529975195920539454277361036398481726389385423717965639622087810839754989692621634814839190863004086462006771800771120328881614134358511395869047832768909169528762762790150206865844087142690208123115368034723861165458992867610833448186121343262171140176499929666555970447547837563087e-28588"),
           e_float("-9.9238666735526696092513036667222364981198965066007401904295420051520744340943926921655302300521049923465023245589254281319550646118255546938301088062634470582618358916241457081760436259705045947874343002445518641912137152673184640429028940425041324734765628754954749630106926761586836343694248550543374382555901286200596986243390958983448897330178559838962525983572365046249796623659793387516626396024e-29859"),
           e_float("-1.826178751823940143367958869464839861638309824198014615021959456431363550561099735954357753283161754293014144296905422467739706827068310407023817116415391571199431142861024450175237978042349806745881874089990887792471280458875617752880112292303189367631462232774951034271790878206553279685936088085573852904958915946476829349802335742046848197408592549183685552788450376339613742407407230326683528156e-31147"),
           e_float("-3.1663012552953228951439129196854545021359528299854144978843356606035774515494467917134048833002054205983959169121058926714947545826195697032707196515125116725350505828368027761508446759798310283225844603037290324426043140210540952279231242973848746998161908473959409999175703191222574287908489502859150568389240221501914425226165465503827780292963534001312642577347834729904848889327608378496305082357e-32454"),
           e_float("-9.0995092386938102041683005713556342741590111738999968503765283360789366658566842983146082059638302944466150114577200587281291890872532163238228687853590843296421944119281947233441423836489906552718274305207842715997637019045007240739173876257699528755406765431233834939715287741558248620885704484665178455197853230098452952109143224219244369102250256184801669150074555120741956639796222672178676827146e-33779"),
           e_float("-7.4558895902352163390080456737446617337611869293668534062391584530361713696556477759944615611918955299056009073634040748064199930785922034144539482373110129446872112447058213033246631218088972459990730600907210694525401661214027625429647525416338276515509911507301776129718787985385904340239251419194999640019254215430020208272272818830218353423846436138003256797693953348138121527919187072124050700314e-35121"),
           e_float("-2.9338229701799914582978704081778509195941965724485028644030687871186610349453773345467949437542867855690748915388692268657026843129149399508068084187782329855678152772149534707026583271559051843067754422051498181169060870844544098802309361382564941572193791511335484728346896999681642613804235830005540537247794752304586018662510815504519416799721406043953079628280189296685717620353419256333591993334e-36480"),
           e_float("-9.1561025024122984820228387414848862911130322045558127155667014118298994968047651792841703512149900687071827149272274132382371678481552056127448280293196301848428108645191314457516262579074081524463635230892294261231492454024709793194920616057143976193084789687511893293843250228117121377743422092835886921706165668632631598561322973717734980023375853378445321370893573464549744918607065691579690483897e-37857"),
           e_float("-3.6744801145685685092048129566410514405456829944282210772495162078543226338500355736959132646421155143596765459606706473713820401794892752162463008481967268384094115718841530457771380805997743208231199872136962263044672016147029971415563606021770216694893445087661680997577775381940924870577665678629053300992321558186362229316068459924988168628983344173773514515416683227971880191309428016967475403041e-39250"),
           e_float("-3.0214357745439161651673737121822909331915169856842167138674697795978926092137360251823670861961354090505316849240441608701039020364137421601599530456287928908493553782720665203992906513348650716972115024503696962285255286632397161330188407469784848342038638296410684932667517384663630837762774216854429118747634156108040017069144526812747097076181061345450721678661913424149564168244433645486002054888e-40660"),
           e_float("-7.9796804092745396662710071180555938189815649056120837338759385165863618615593220468789436095037523500780766303449228802672836971978150377150549144248140768752034312626680218067051846548517465156169992266313869663602895526247265343739043319502817781807203059028101244531248876015541066904255957052960941816658647104213136823281986276189546926690897444706825811192010328766269653152344812291337265296205e-42087"),
           e_float("-1.0448151458747893572222899976807076288812859723291062553175802615118288366528489425323412389886057930535634422005513737262693106838287885656366112894671475752606619674038439660625302556643459827009395500950434671514960314370998546854084358075456974779064368942042286171142393854893236815756913813813505425337265168197091346360636109053249929014750070578319844130410162508510481042232518139666998854343e-43529"),
           e_float("-1.031766238528690229892677660571523382138291050463438628334163728502065029650833438283989860311613946463661826479368774472771249019778538604338247067336738773942332198506928558272678210308328064986303123755204520352840730968316526771592831038947486482155700158636863482819448901973974886938922147091777025173896846851094270619177050143843675863951379869227684757220330809886179547394360938691750672243e-44988"),
           e_float("-1.1530325257181962331461891810111113047324077439204220295605455717230063898894129223690899148406182548483659983543539974161842166069444932579536770852703375675895129753206723962822229422719806633824160931628875417099877747213405409469365068348604152419680494001664757144509137457502295527887921059734019198766860470521616958582940893842586591047207604445902589190464361874185797060940726501102201093837e-46463"),
           e_float("-2.1597068254583979558369011468835257607818435491171403642357362885744498236191822995677617771214162216311268182116853068153555810460293492238379768662571366527825042648795327137591850196839357854180053281916454910460301023651137109783240501624560286171428424950674160102204086127013992611828405433085776055082551217991918288417098116777231889297715752417856497449281374930076720331220376870006996121619e-47954"),
           e_float("-9.9187277440594623356271237144007526432396411338530941546690172124342488185817283998204286701748172219864304722827400168316531440180662718218358403594111621707716087498084449743788325111463448624251134069223486918541422431386240287831096586444349842106943179265249220294465494499880942487598224825881610561192477838282514718657602001257408384530436821739264722091755408057714528398177215492627767081375e-49461"),
           e_float("-1.6149358125574188256306690430336581659256470426846744909282983397801156369011476277233738195561879175372088848635448806056425374472754196806149727883137911238700484316914689785536789366342264720254718386294612803523619353429596784267595159378055380378737419521182414967050580693795611306307336048530382014692989735475082197545594481019593118611050150008247851817581119044428368622102545227742463242659e-50982"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00572_airy_ai_prime(const bool b_write_output)
    {
      return TestCase_case_00572_airy_ai_prime().execute(b_write_output);
    }
  }
}
