
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00489_bessel_yv_at_v_301_3 : public TestCaseReal
    {
    public:
      TestCase_case_00489_bessel_yv_at_v_301_3() { }
      virtual ~TestCase_case_00489_bessel_yv_at_v_301_3() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00489_bessel_yv_at_v_301_3");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_y(100 + ef::third(), ef::euler_gamma() + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-1.9430670597843759735114136496834601888324454938512257880899385424389526462356604172323608293332156368736886191027442171458378051023150014703779723192640787031008348140500029984729733651237441284731313880835759170834672621265298172253555466056647045811578820952101123299399716380909669439411594060734852038459082282638989321743536988004919468987164715240663467974490364952651989279311136057443565737792e210"),
           e_float("-4.8556557492555317253991673651952207458722921129619624672959818029963741387763174825114506478585270214381897821384360025280664875645044934859221816559492192493772342728345529299051823025908680793856379156790565158671455499579596893633561769883362828990657249556453200360076736630750007678179336099480456025164322688303708040704705779497673533391096356615099250734564370055444925557587731953231113777751e83"),
           e_float("-1.0746796165539846637019027366341666872556370433200630186158615022162746055185700557113201791477956623683287605496303758430776308749567848892856492484408291783036360755696923623917443006682748498054242800548922915391234456282245718169449743144861696274706395904215858967375080901081299195930224304388866853433739660426950881705934505032403130059969810484922794330458666987064695395343897698511202782678e55"),
           e_float("-2.198033909186249365474797856461161549949663823633935550894370676195570223652042015574430491700779277371129246191497226242446961480651186585984820217501573594995128375498380194486847645312520117939612013190760835026167001887070235242621081887823177038513120793886033735786259127904646579172557393491296181677574860595068509273944417611433993519201172682594135950226184133446659071377144941237783804098e38"),
           e_float("-6.5765935873368863022791608008241224459139133390022311853852329023868834515715823122405995870400670696515432136810879772517615804115580099604404113685635916272581423808766983298443192013681233042432838338204229938264729316021658740478842570047291188488561412111080243997022045795114850612990900721781555844437394863178219484057390197192023990205291952389645826377768442053006041872264591828389745340834e26"),
           e_float("-1.8867383736772079779745033229904626032766636170640604177772444034046020057379168053981078717629658904400335987150451051158041372554271113118388789780119657038684187026778615336676920615465058392799237282754893472643930900947666600955908665605675021561661586325373293275947218967823556582294585289496998618926960757614805175538724613077982848273826851834412620261930216379239883093012560262688468770137e18"),
           e_float("-5.5717678310393933721103990149481496073574946835775931902337112839619953731552376840875187934828458592178064319604804347059169906550843932674610110025967313809199772965374722141537017769591038385253427412622721797824527625580622436179943630844061242793479061007280904307376988158543984065103764735917973429007085984747948854581396423557104673921571238678779434234368224718971760387423746374533657962659e11"),
           e_float("-5.3932956749022120832812177324504446076744539356141070854571257554725817229228223622582737830140655495919766675297040302601902681317694773976275675703503612713093742817705658897904803547393335932785474909539512048929640117479000979044561506680240269242986643474321581216111236012378516217714841213518292300470596681522387560920949739390610900079361345092824464567647750084281348216774904196076708676473e6"),
           e_float("-944.96321947442961851329392966414032866869957364522585223620519314773035266912103835501779987504901250621470747327366028395584824151543088929669263268911919538299685303366383906381989029264852398550633872073808199377432814644647077796833145260387148283241438005441699902060559136139789532886483451689609100888465498202105211700463016719207942079197323273634517338738444429422116383128265311148326831426"),
           e_float("-2.5200601428030161367447590927513299348821868048306642846134270233956695603336615739812073118733497215417767657253713803377564543933456371365696988864112935153744309163759278913126141600203150694438312201892970011563127311430022896050694877213341126186610154109779931031100638723583884559447271001909249118712541129259223688940163467262514435726002509523677036509305321249270787409727680856719577774111"),
           e_float("-0.15861967981593854476868398851269427202329850435334279292699832935337168283370611845411787420620293532476910606525672329651978982212296989489798993410099478695501415094761391804232741245498427120543698006843154770180636962494233908645560654181794594470551956049173638135939717765022864174497580193151972578680056326572907139917375905300441214396548485665015919757714538968960130580695668711523685245259"),
           e_float("0.097886555945493244737958995760025883661638839309077607155048029190037188059980660586312681386162649166243213450125256089351535302070070218408895461374664283249383867579796448206050392165472239354631863491529937113719734095943356378148343520478937542399887840041272894301744865231295861545702544053824760120587468278641040234798498765484822860966006031650715995729958163531459332113883946802127034080712"),
           e_float("0.070666501851663609163032403682898273905496184557440553801278165165973968912126660429566916041486511370438041171256180372252866516757059887236760438002257652526565915627893073561639092477473668259155745813397047886792725742828507817432513757894989360408096529689752484231193470007330049972058744627081855438248886082872470425027069690883875660532954995395474103063626984827697580165237426565042694361549"),
           e_float("0.044209459450708437021745011945455711598053051439761695642011137683479072349459273896785332576480090624067642965966916856580459837657333049985952973687873733059060066467009135759714104717082773153222611375588671856627467779409871996644686687168195986684750387631593327410816238419544639882564315473198984626692570413630357976382850803215420909506408887588124475376760829393509765592090648050719087717562"),
           e_float("0.066205593447749228767079244878903588223898478721100599492794307568352878278349948332121441301097364372630147547441252477296512059988165270442571548306755549288181758424535024982304211483532571532825404595100589921197461036291937171035063852873482519373443060900354390947886807832103325457071489630786647057800177634206089476299754996601673139914977674895858193248593747863545617985378417301275571664016"),
           e_float("0.070603650206225295592954527285146284616597172061910805080322083748408541339690316153298714956338364105952734207907475308987825888930482219657017634522889462289871935106422875016622955845591150395985616182513611939984328910790140041144911831843339528060087282983030435920467417271562538992428066559117048392710494928844207664459535020136903355429803862965754422727765073770904090124900726609112314200608"),
           e_float("-0.0099814877805408000400388161526170375969677089680526446810131680563851232557202365258457455242428100252948714861867725967394442812170641730350733211816984906385546399266557756102626645512087454919002499401918316980123782768716993454078665157645088912262630396743970300327765002979805775934651960726692363811794520539581550538911121778088148122053063334142163166269303426783530190945812080518659914671647"),
           e_float("-0.06599540892585023865922622136944655563217455112968579113522603104466889149480827483007390791851345880658572106957081172859246895513891668410503634144377487792562885218159307625803707595734501461669132398464381951317400318636421086889365027764504703081123149709781887375402182933251252290230447442345580375143386800655678334809326961176869575305434112263073331477962090019890165602544196508349550247463"),
           e_float("0.036234399657514643434012207946654390702158866044903089979581348016412472237440193389324165846135413347581045687876934849111893944454144231372245418603980337711661981745202848083284565105940404502629961267136377042192790862305695859553440082390134977149212016169308570750772656501912790761680001344775955611969394174789679259276761203625750116588009578345164395033043867983186079498359286127459632590377"),
           e_float("0.025757606224747675000130232971447118756164922665056612479901129661615609051415895443226694067452585903113927616394527300345811826583702965669212374557929711798880028461065820664621848196708651888599851596119980156221315091380499105178195772157047465586542174933175059444604112603046306791360211434855825738903578000876796902145218400268346281143476457421339318343418827189235669803148298168465548251741"),
           e_float("-0.057741562816853817789543796842398381022079479570743479976763518440256208054942302542975687792684639798339288067413461301632035735598166681110961155140597280523058534251428270758528247801917862380755679251475303074875299026056213541579113104028515455596784719938840415909324343093564646433649231713494740536057244054610510270590010306486993273933343733236642056656453655547627098395567776704242858309216"),
           e_float("0.054190418124033359611826632307490144327705520610611825387264257567394556086946899941966041648593136628001465831233922537397878262515366489896018551728557111974704561820249471163339239397815136190630747773801746113812893066212428655222203805913619091783739806085273940714454177461036733243644880586398800601337844020661308076915041390876778848966899234924701599053808520161654786843293969509625012018933"),
           e_float("-0.032343789488724724450666601362212760773443162389583820645540143437419879769610848006512895059669452125425601610119951807553647088874426044192717387420273582122989447059383603410522365481443098349225197321377515566556971445724808409311911126247694285923572076083604119300350300506963426600034132409606118799582315828740334047314685127831957511022186383069669193576528882301129087121570483506825763395063"),
           e_float("0.0074719406508858846163848122673940130953304427377054374417376258796879189431261045028829137105683621630858563969097686463457058436325007251242846095420950024271999098449825959426446031954811128507300650737621805790612522007229748056080001550882638568451717931968333907030960074828879449948906729482981694888022266417998597780934331669557961534379708110550711714595387815252765901935047904764428472159126"),
           e_float("0.012939845526005400235889322234773967496064713962236673808376987386714096433484744082480182070800310870636372052292675955091719391152235654318294358320457490531408198586734537151644681551547440970863893334027956305799084918774627624607347956041489109973861099068228394500827054726596555261559837164646064963163678264518916985704680893003949840432332079116528899839232991779425691904853077798055240799802"),
           e_float("-0.027071499909997588746685700494735271753838747119575711724886696387868543679820793891654812719122965967676993968507196617554317517143420543125210494365332003926442161746026252581545545452971529414788607846570997856199643277982738382165656516762190267249587589288918412426984171756614286872766703371277218212623407110018936089474561477458465919106531858739212680631259137213863356628828791601949868529515"),
           e_float("0.03573788646261791303174615245088018475564868019105670368685908075528964117119867140743002908043721123599102302385678525868131235573011515843161956868511200411355624007261222573388623172634321795564576530354683930878374915040828304716549949209430237726426587148003999152805806856243712382330308538258949884503780746272903765307542927302189575075248584008697776289898123478064735377218486044727708477654"),
           e_float("-0.040467813852545331475134109781381086845613241727025805731127062888573725189705725090313243092249199990459083171581718524968962032569598178147861183023159004527035890562124772556574285077946878554501425216225751333524195221071597042175953097509260595351296376556664199047390356506702803635230665979867472628292278268168811238247064983892062982007194275628141148199490055807523813815610902135014553688638"),
           e_float("0.042640963609978290668528154901934843057727823825342002452286577168369532179075741482836117662599875268997325335769102700047513230376656494697649853016067770242303838881810328627698816986722660886992491757713997447793490446924973061529734072520649668851514774685322102198307913408193791463220591032877670001420113226572099218113000831316726549444945457265460709429315637084899911794395146637496227037102"),
           e_float("-0.043228902809248144325663355691156096987208591043288506174608799030812837020296316943822849541962923923089824360348945948867466004956548627742064921810896816714806540379138658299086061031093142791699589483653190251755132975437063208936313108119762311028441797783807723624425197818722064541793414882069580849488860466831626341328737641468862010296111185054653740616295076494587875558292096506467106431374"),
           e_float("0.042798342579919097054609338093338265344303626671522534067896808041243708051825201283867423884055511075457608712937861970576402740575287449321577172560073386292487986478085883293542690958358366002774162664945747426653540616531072820048423095684548301123766300401182345434110368287937403882569128095797858929600178609950079027577328227997897592943229254085502874114971477388076336512475809270802755565587"),
           e_float("-0.041597751428414759220803195038780597060672858505679096813986155308607733857042123405431794296046792928815138722331620195888396984415699617141293435854789841529950092634144870969287120543786243660249095560145300576413016893412643219690148698458577892983349795160400076718794630467778080420585021622364949173981271661174783088203393039286460491069386424099832546103708096864233018167019722245409840655401"),
           e_float("0.039653938037394022689586350048895666806576229824645109613679351614046994947597791710509043283907629138552610076110173269453723889548038806735536121788646144537567145170447969942876653011407866029737582081695915417170682340202829746252359092518656154192576567764837251161593628585737471118010307393449641103643069225555845989372344997852696364593002837039241919653020281350156296294934847967176529251859"),
           e_float("-0.036857200702206261978275299525232484622803433314674277920484306999534879825988781244144710457742999879052046407591944752571158013183017320804534330137844398118835965591235677590491424678654440431230491392438788970290406206775490694092225226848790046461353632121934083003910218184956871546613203065522371124318548413086144460860180172239812296035354469381176817154796079342118237569361889924022116905195"),
           e_float("0.033034166011859354149555815981242321271776277759853655720869817783085835948489090799891896693614830941914136860631907302529107745271302201255732607721861187599974081855062295431795242346098259432717792946295110752301776958256668768618547396305136655662975323330878383365793250329724888882601458883855211494661337698460619379253318996818880712129433190720257653456053088549758437950180872085711742395997"),
           e_float("-0.028012742487411211179205862822388905532259047044810864313338711212374696001739965260221897469701816386726396939625342982377343496987146241494879358317564767329156289543974187765154985468038570062273208040214061164163264784944744460724875811990064021408021092943171778416038978883038109295357175174048500888913663303782324089327120251504860437351173946818366288926997595867072263333205355379199545353799"),
           e_float("0.021682492433857328238511972500928438969298140470980762692586298844247566156839241899383589802213840461542134304088783732184462291530756961508956987360924224364556180956054873880921810579038616233962418091210847683521953401838735357732591654283570413318535759273688624895548763010186303307085212240465720151042137734426660671018637441781905780467532596003597573993327178364318702909266270632700983801698"),
           e_float("-0.014050341142790650166822198967509878429284484975087819529014375263260638940897639759477967988211254305014795062988303260563960343090471637578489373198803773955991685882070612074356115288801156138724376116634778652219446815674469499549549633181013129971784899706088464126334417481233945589677215324955873904602152069298132598053391892289531811876540712461811930411416223211355717324733211524195817149615"),
           e_float("0.0052878223777596668872448890889193977401679311254729308212420041337044238990848354716912151412522179235679298308075621546825650074020285005238011236907511520157793678076392088808086511440179409599884120793366832430551266874440712359448015173136469104452689483722969306563593156640987108694659309426358702871467430384625245573295364835040137537742508004975618520092240654097471140354403827021592760030607"),
           e_float("0.004236962931541176282038866472585340555239940039875764489086680589121763416441007561441690102754534565863906211202326948029784167577677566768557076416796176262464854506561294274101642432642494145364044073754942826446502267278799345029961211094554222380369591179227467498419873385645739685127348201091208632864305100937656568480997520397684142992681666028286433061442914752416933525304642590324539881628"),
           e_float("-0.01395108947270987280403292672241545776923546513068453642948971578035553574264831856102662550987346157730795115390738762042101272134414205180441462702079763519817458297184673532694332456275837188897719040247118618797322732452930887901278375687693543567205158412919040961110183763629019153920141631055715103871165755848421948293294790757660309582577116172617343169292874667372111814637690401026795556719"),
           e_float("0.023100242679074333635187638355213523320025965625912670271982411696748495210188052594896755258820331108529780322535089734943537796171008830682755768710922582520784606099773555577313223993597789385266415760291784205115191591007162362716743190084275052022649016939300314384274749743690955393573551575604678114412434629664908648067336969972125394668401715468967626142726331036003518057967227780533632411415"),
           e_float("-0.03080902568403720311463627539751028399581818339385777281911984258969576567797396960352583745852894668663305099913483349958265638307145841221590599441153061000089629393146322002429910155990207210485280267047415600560706765407429127440283928842920757668762572344777148035690244709608517209270712057865589955887073056566697807962990695791125753164493438575301661983128626131515366635326479906856531705122"),
           e_float("0.036178112539650014063434336044675776917883299763935160336780744036846846071415277985752126532721011889871876351474467716667496238278928930202231872584138747302860975227619979780929434293319970264687563617652904970477941373766488970561508678957831370295288085652031967730574101117666440610439373311692333412219253926828140970385908593174615461463549515227175427725481848218800766803100720387884223644295"),
           e_float("-0.038411130295675345181241131377438426815020367563209810873349718092788964418387349789860283297580406018400259610354749552832734867215166541122336154113351960927153126765321896939140800600295802128906616309692448843609488562648788448966058316177177165702998837543374498868469712356494117506703717301923311676509790069757735382073434776770584654392106403189438395060488462847772083195647235006844370242121"),
           e_float("0.036956260487098753463642665211086465739744673321022694518241111381532480266674265994342997654227709659001706773873961854877745964368953985978798772988630230713140143538328592148861850207381434897794730253298855691448466936956081977409099178065139460481338920455275201039588695893025547236680269809947657967737059787495411016186853651190591617298248554420895985321080122432302145937179711820788393535126"),
           e_float("-0.03164045616045765799972212449175667134632009152457162830635225343034110050205573086657253518892475922303778176349020023315887461892053972074529874242241611792995239431006914269571955623194550253889089866618755218653384231242357696593496024153411338792231574062268261266305345056907956254277957060792540538738864848422142265605647327670808626515127900703486663608024346264093588810627494322383306908332"),
           e_float("0.022769752072393873743555001713222866780470317661824325937078288297344290826756057860872646566006759335289903305128775672482262726115135940895186813765377998662492593402896088557847839859631213313887174482062710966219603477391064079690656249559733995635495222014314911627407640157666831521043464822574431910247149057463679902411769790793239233930408604585656471755523420488811662045316637338706864385477"),
           e_float("-0.011169181660917446872246994217174700937654827394223477376608819070145300770967867128260511243700020075535060860607046811351422476903726803776587378808539960609283247452138920606972236528334904243896652459603861637711501016172456611196395600363992612742943694716014312646882040907308405642531237847371401401316924757045104763684662628694132320798934300982151523363959357158772215951982873959778211095759"),
           e_float("-0.0018584865087791263232541287354613165595282831166357514969044411880874996265801389711039669995279831458169328465472494283596633590357662875677860233252640118702696032737995492329771793252454875634125649852378381296119551053413566260621086166923139664170662208154760299606730255296319833112574726142151623407486451367742904110251129351090813632078165341511716459218966454074224602040041687183451832741891"),
           e_float("0.014664436993045880122490155558484752043123534004939978270670605175856116833868476898862304261461310100400863954510879770055198565006151699358324781378672473109285113297110757848030511042786807938797503824644517050530253770992885680562666911299391250807505032419472724114721729677526812404515083077053692402176804043255083400801601291274799883581054652809093973745614615632060204431688136186705020527391"),
           e_float("-0.025468942438298785971862950707589620504442001118669943800705384944636524993804616696167906207109534994142442838001334816866893515898760275768194592757685404400434728949222697071364123232404564439512692443319723919207705025120694738658695065655018104026854417682579410892238779712768000340659802284671798886853211326758729357021866850688366273958078041452010772497298862862928305112570299483893587701901"),
           e_float("0.032634631916935063771563588350094149983182058595087418228780043215218784910756967644271685102546682910620237128949021320551009383254669852181759872441063383363743869780151081185121784977217299646167858977795771499594783342028649475073984483632605863303260503047933725247442423611018375927827952566618293290958724029826506130902725322210708177789531954828060177722035478810360468563259086227678962803758"),
           e_float("-0.034955805577664740087913622412426810158551472863761655168763284405095654272191009513534489072149880708478800652089930104410453627045234154126084801062029031671915477085827640727033770953253534958931100372535575486656676010014860740802331516260567901409215239874334766191656617818472887238016091616782294931844694540669963539131567225295044305339240195605741876020234411142814218735263811757626957275638"),
           e_float("0.031910633395423289634748031443193247361624703695238097315600262850693464918262800504608790320157493960388184302732891101064145878002962570002106985378177529816603355188099873994734747083882980553457180819153658963795350022684228356799178385590869264824145677469491072758206871475539015537316943351381891877048148077812032699999621959144679506638956748834764929026255660213840140873359876563987349529389"),
           e_float("-0.023821381405506271848135536645717893467228612392385210513426705370278530762675933960621666579347086647010492794816614940628849335237701942475103058182727277022448017376824228690083303882506083604436180680665176337430327026253107458529561678494863584353826982067514056694856328741476225745351602762179153802751196983366976679244205665086629771760944109831967002296697925142361628491131339039074895347673"),
           e_float("0.011877716709297640648181891284436051529257856498336003520693181849380599410542483818648194017671045108782054409461255571553467071365863483709394745959642011781934010584179987824571052636055636719133729935284640277562729458989974676877538551771029420367778144761345539719548963702335132817758291683284227782368104172835175078875672642872258014123183648480200203116861373806452773169376269160554938858777"),
           e_float("0.0020004366819411853818277487648479758653815863113139007554462822085543983249317332351492283844090770362527018022228426338086007789756868857627746056846304091806945655334781273794550789691396935138027075109001140359776891358399751054396159794280535850085588340409272158518799936679173460962213398063168748181295000235048256632644895269615197377934460753842598543984098205252807823180332680853040236293189"),
           e_float("-0.015453923617563634051529528385505018599689148621921597126283899613535942546732738353810482349576851178736662156678325973730286176805919264405052246243548585307645287155708914063829490408511986449174999024617502039070116513121563790746228690156896820165798792079291468764037623717771489743899625808533075461481635809709559870959553578198223196603175312451959980487660071030383329384855095940570211193016"),
           e_float("0.02608934008631622738434122360481167371246337040509853917376024554748044124415823572617950452465930662854934379806311145073977019662321464098088554850973707342737116088499509665684059729738356335772916325009570590766662657767663946698658319656605502826024447666634613220677353256079541804958425992752396515706655361427828503965881988959238143255818538205243499488634434071566009893484306816000409394685"),
           e_float("-0.031928552658938770613339246945578511798193715856267089413408486801099114449304472825859402284710945274071890142632543553866401051779460597166757879723928418769051057140633917851920880607851207214450174467943593930010749411856758876620244796644934751728728277775120117281206303226758927707907280300597240614545920165244257006027061749698870442880477399362573892100827815681915823189964776778595396602646"),
           e_float("0.031815088567266483871229919207941587711726342836060433155382271236251227120767573438594797366177676965069153651342312815154753626394479738479777709880669291718290472018749876625799059933045591878346076653268179837146286499543871841817840382271084357088794954077077588734958189307672633830333882157753704317295183239153603986156420161437888349890539970978283122311608990211443736213269849271928355674422"),
           e_float("-0.025688596060237012470945453546180603605760571307532730301262923225370237961271157454647343219076850256018283433799283143862786539848314807720099602332696315527031768697236536608088732409024795599035225719917901398004749735392713905648166612402631354514359966486692498822551891312707250777615718104521307790320442321193809002911908874965627933325199191001531569814499965090632743716996812882878238550747"),
           e_float("0.014657212647872849668876763545626479687869254421702931961154162423306971564988922779864615068020677540818712065902314626085895928579077828006139902256547816686524730119474933053649857365909842282501164831996846511468164081059030411611032644856765711861276483213068240864571645259909652858394034861808198773340117798513895031616151113953088869074888452283292025173281838451636794415613292205128268686895"),
           e_float("-0.00083438926782676807600227608292237332860480788176467436341021179864209098012955410106757446938679412820378045562758934600868784668582139563038928228926592450808117547937770414717162916084589001541830874745480988303104529420040138591274094765509914235485019111039977912444352335649818414116090955998154326974366078913890216216601415783269581648159963311507109133354685346426697428180895471940197613254254"),
           e_float("-0.01304477791306129301281102624543130723718702103874021434225919507810728331419244057894271831029693205955287497643841317631107685869950205454475365693813895566830810222669589114924905045945878374304645524855233152517277690496323894620247031625063178387940689458910226242516457583100320216176679204657233124067804067890024823868850918457467079306637562716705996959725106728543549604245869639127767513509"),
           e_float("0.024162309718630272192153786633977015102031759079805897311966220900122532697507105822854987156938778190501825962303171699812587538062055480078842712558435010198436747826850234309357979748504881167482000736437005016811146611799070971945418692284963638326270890882025847410876796229813396901423095198010291089250166517576116849970917406897296613278209749901612419028326158560668970506557733199460862818633"),
           e_float("-0.030205260926572850147973760794132320344317151719539043009151715119475806551950658400291473986761715224638596856283638155224134061758606626710304220468719848017985024499268518558537385716184170375262807950275874554103471147959622653689236941509900792536349466262676898881434419477914958395831393835184060553068156237709693708350888758004314762897324548008729212052689232864152552035714448568279157503356"),
           e_float("0.0298767879697636607607338779935090935099424785250948363741117313784718715194869783067731924571096246546141689760485815844455820906750851708632058875326210641696480532582044224207408410531197747159670420917147932230483598358025003825858551673513008361407285187101091140695783202410942860148359439310764741298774961189989740235621543636361892533220460477762297174340924925272607767883962278336642547855"),
           e_float("-0.023211686926396640928631717591606329486765352082500891441441700970910295074864484902377782839716997600940199532109887903358146167510951764790340667909391049502876181412619425216970962585157557400173115586111523335728245899483258941750545959149765409901734773172933222526891093944467229259427086959399799701644162692508784469424009800694045053818994961536851747280523715370153999132956541894051981983562"),
           e_float("0.01161341407042505978041461662741475351858365470632535133684310409622524690753664993160033521216954540758528470717566033708439230098976306930051176259988110520280277671659832771376416324635046957182337787442251255472145968959688823319898083162144157382451732698288884120742581470781858590518637788397998461502145043068121859804693076551316790424838284144308746900762415932360174727523198671264934848837"),
           e_float("0.0024122071573150873345165957632923723218517101357746648664068655321285754901909012915829161130869301809221467809283033447057133571294894074358586595143794967484919957310882472454416604998420004377460197116616695715989489124748571244739057543686849185416195058669632055578908680946204445108156305589823952686901054634784540422547072674704901475627029062238246374361278319174998893894083663723513962074388"),
           e_float("-0.015782692025044356421332086944577552395003546620917532559682798779323084210092969902087346618628314548718321745735393447003586548423204118975040445535053481631303946968157806898921331759349287673444815935184567875010185308814340002392491092707158176471728843107016704792109281775613186434006328527789468526327427681792624056943200896712468611294508891867790081770631134382585289387336292226683338022778"),
           e_float("0.025516646192247623288919410583102176497566267186033205017091279802215549589879305872472892076412551086460897291886241824503908700370467789029904941391073460007873262604362451333569479433792848195879028852436061538736099317006214473418094194634722728468672045368805803280010988722407181446815060038633101665067700933983738951497787386365773641997503211720872137040548294657352473976034309133503707064947"),
           e_float("-0.029413839255889890424492619256330931765768392744925758958661949886080829153582159280787503201789143960682389871297137810488012967304160396518290766284153909310525263974822427564770821943452538985466178386836561688585774582310041829450874491374672876233349128385832370301559797927648060100650342789463781135948282093018989547554396613866108642085307716102675158268643342124873983255747368142864372108128"),
           e_float("0.026578643344027712844110339942221436178622010274849841971846529720339771089286437902848819455586630772041535828791730909693236939111955717078025157224496794848622071445052859393544667726121182938011659109111776758045228092230713759318850946820241563057649400789361482800237953343528100102946320808205056557916449437076049884690492715999979958873967615479964138549441931132120758822797291440329598690073"),
           e_float("-0.01765651583018785495649188906973081423101680759940856235404890584827615252468662186347964346556262628610842667947618102057720040025376761495856692721363534301182586198088984727112753885658432529722286194414778727949885109835558712998547601577977243917803476788608196535081016222310409271878299865215489316775550284895525764482710615285494276923494303802839578105188745443711274248595364993178772128796"),
           e_float("0.0047153377095998864463586861956488723484443809185577371074290526678090534931268776395183810338328026725993842164333836980518453558862857202586590935528681470982303185381898833035741333105026476276336936484496042897599900084161159969839516848427223489179392856297076784867334634507983444396319938081805034741427989044998487959644509593184497740489732057486588243924188518419417860537322541700036755009444"),
           e_float("0.0092140904231689831893771548363960904108108613787555437504855130860274510475002330334374916983968125690338728783916642066482555337650722552167783822028770934134363605319104805783188159731830058955755886940091641254798787930975866077947344528530033150789233540140734517862389265031221672276434736596449479195087691086535073520188126077163198822695339220838853908802843257251267403122797852390968135118694"),
           e_float("-0.020840487941926219128507325622999194052357052019172081533075760239575519208724346366572200056870016051013127899793737631826974251212837707248824972109741463099145496493888630728178332159434043191295806104357808038049564346815026769220087042529608741756199663698695158428951217922383550041082845652278869304489099687135937816316634779137060393813624225505973493046034696233535279419526550765079713633808"),
           e_float("0.027395713693285130860559598381742487301855993977203907275597250381533952374603835185609652402072129999066708108563747095595304129733706057846116301940966101599699816640582272515759272563355036177939001004909198081453378588854245636600726973624646320669574974167984256486322751733431783567329174447013868698620439217660287235185664985274002707687355268831060883207201922669411637464901572301286750647047"),
           e_float("-0.027310950817635295058777626241940184697873330016933840555738198168940629914269515879386001607096737659151173748099499524093067470290474471839200773989230172085068083001507779892421425902430341656472611287956941937905806657019886438591681131360530102697619075250108038709167549905686330462577737598930923596769584250900653131616155026570977785289120242695194999385419646669800916503227680785149591724706"),
           e_float("0.02061585055907908344905827445788270237227236015132028789600566517678257650195359857405763755145513169299328193881172629340537629162506382967336510440862871746964939613376205923635423975830853762325374233355759297538567693165164238015963681927898028863820859994288310154649221894919803716534193893776383577197179673815152824166638206975040302244768620879449652818976055503877256163433918811445003765107"),
           e_float("-0.008953551856763836401346387444707468437422167052364145047851255735587692460558494775071420198972756258170564731006554873353712668670161883764799714540208881600282323388395143057134476820810435418316745728497887145561525144533236498267467534910168751466339871323122591156513642169810207804005830230535996689021738862736418386607046019073111690681284519629263019451227332548513060900386225018982934394636"),
           e_float("-0.0048031711678445302272051242745092294828752640401459488489976430251226247029602192510996091857815155005863253924904573879363583828402747158177542821628201834110454737450244438674924269992119486685808243128293411622794954866617782922760413645946383332590091644099477077279418028593407579619127125604208215910307874662157322369353458308444138877213429243588378982804640254485691901895731762219371461133494"),
           e_float("0.017249416271209390753240295570453700102924561690161966253447317889442952047207413542804985212810213984291259121837854874038217176565802617676557234669547718669334899821058685657643711181112323173362249896993282789809424246625555422021766502069961760749098213379686371450899931386408958430148688207656458454405049755611490889263861157688321826092259207872868527310560633234716093872402066087805256024431"),
           e_float("-0.025291856388782460541997666532144763148651958339855997273911220203227274778305333443747589416519207657508550446599605825159691965675898180680723271133873869449227014343267905210332454867539449101164042186442641658031269044368862938584882758668121405155845501275433369765419396343810262401538337909761502522057488050783091782085763597044953338331902537673659229624026019162845583795687250043989451881087"),
           e_float("0.026928706143846821778630672771938128238647372701657537023047730808157016906266333155983152642513175808706076436331551821172741030738164393000479916154222696717890654933561698226441095100211908966075270705195146290283822228006656360446708732332238217762729644581629065445505328202153832220887569739985450594377587507228292059297074417731791677621142317955672705421433884031957536954171956009836098695836"),
           e_float("-0.021766038586168065378514048472495866601257790844221017770631269693554914473476478728630842620111593966389608135642254650944610511675391768717281903859673134020045514085635513863344650265964040947697953348635009729161738559236228599543451854920844387446444809771450648558726417136265811998436135676411625330585640753133622323612805363002606356033898399715355379542855172411623519275569386740096211531906"),
           e_float("0.011132606686043692205809962909708986308626917364929323564849733845925068253447019081978154583909486167869265635723576140095286169935012535954335031021134045339793302551802935241198065054759675378103064556191167751333836169349945094368136948777254823335440955265462606722161248280009526348965475916955057454514215812503477615289274249351922380747945294399068850311436429061319401894640546417540196350255"),
           e_float("0.0022447371070558009531924857816687025232370526062177066558409766039308786793117888205551379982166667852541083474352114202454850078913876849025889851898719057550047701624295555185241331155745253379829777581687848090091071241084631294344084069481550206488734745973100828652027119473876123687629004579383961163638625201517550510695713767967225230892673261097450409390919791818283521811372996790013816212052"),
           e_float("-0.014929921249714424987835226178725322112184064720907147047264886845448094474555417476544098782133021120641080530672806884193409676054895809019049378613847041304443539930188835151502221848117487666926926357137767518358329907641511365027802087970195651917065592275614104582497779991783618704712745519661873108795471387747226791204569210952387447216832810793766121624233365091600625523686045618370057912487"),
           e_float("0.023658955528665459791629846653390430543295163025327413297048356522762301536823298514568708942673883898262020732931629735492745627722444676999641907265877225224276549671385330452661734291467494683610523573445280214976613012305871280168543273440340479259980180621909488834943251367873192401316803671391886148441968554851095763439500841358431145331583820223366347759525302165064239265800073928672193396057"),
           e_float("-0.026187376844209340501620368696965516552429340768465358193012158826849409678679577412760811626986598259121181897942064407895775300597576153901263411971207025079056753428466230789304968555603032648432779025287987181699622748880901258587672834465679439842723603750669278938602921058743969201383396680635479302237303511265102792584333106859730303746934370773188789135858983486400124792091242244542269837193"),
           e_float("0.021881393602598304044626007251560595413656180917630047475360073796216036771926560846699929434896765083269095725367136001800756260647024350430836003509879166589586739741762588367754143645646678829822842872791167612297673032553518296967314027654917734082174390360404623212618465831202307315117053821702549929508441802419160366602955375683879263871511987701847003699633833180666464495942709798162901288952"),
           e_float("-0.011893160415278024529770606458247675686648553762495366099932745289095831490171196874634467947352773806372196111478459612932696848684400041538777831145738629144040255826817489192763022236314872012329930136036093564110417700741150927718485949201297534486883552339156733153955090755471071752841769675201969558746985026028833329256139793905563843668321551476612382378598578095029733116297535234277791639295"),
           e_float("-0.0011324655146048878758062202897432872837379994466575297950291063229318076371743359955203643409547781568965267568112303269155855197130937040838966289139612718404012662323879026420838718425076717542612454844514564561053796181311176806990713248355319975722863794138605045459293384483357486736548938408144601974931636156306426394162357584803822345330360046761036907609882776833471316310102077308188407472919"),
           e_float("0.013748762297815957492319844848630414084481702494351827293415857421532521945991254042484211341882853624564371385454479481231097470096869249777822065186365299250623916503268945996310499239982039541663648415622724041593329476957805179554201285074692157248271399647282125607553565245419424996232189188131863887985736411660964693161953133859424171366410107619688516235848027696265414366803486483120357682968"),
           e_float("-0.022617207560403791476116265302030943653062451440454676224283415493348217611829054549238637065112688644430267957069087228765208739197677137714678776567873545982845283839078671820019153037844950062559177486716493562169364534549218925183159683533557269816635240543167988048447682166681138984077949801244142339299246188950249173419623453260149749326599990620391485686727524022906894156549900639514758835819"),
           e_float("0.025396518226586974403850752242383239881118204860498478420749519358654032775747700698907537075886146225003064328106839076000485605611370972720711103675171414199364901116400972098195057334997159425489952352575950073763346680166403340198391986598671788898390110053278570481762985323466198213054980922427033223651254099110927261799832530272722589769976907700712238541566191234319208441725356570197900275272"),
           e_float("-0.021372019184926883570228871133723889593618266579989072012612998660542402767870198844997208087444706007901931354600561074087712161403282875844730057251908191180339681522388354662527941399730155378374571140794447275223723006035213985542878097557678884851192063656765506189261322766558533804275831830519781807401959573174952042877600194421662666324942862267477924718832912888080196205240660759269536309774"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00489_bessel_yv_at_v_301_3(const bool b_write_output)
    {
      return TestCase_case_00489_bessel_yv_at_v_301_3().execute(b_write_output);
    }
  }
}
