
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00487_bessel_jv_at_v_301_3 : public TestCaseReal
    {
    public:
      TestCase_case_00487_bessel_jv_at_v_301_3() { }
      virtual ~TestCase_case_00487_bessel_jv_at_v_301_3() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00487_bessel_jv_at_v_301_3");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_j(100 + ef::third(), ef::euler_gamma() + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("1.6327672651680363371966451741863317033056787891799301417880306268585094797625342214310145824077572828774487486608622064018701318718773355925509581944632555708352495335141808705327364345187881999297996958431547698278440447969241600038859049703132551755747429365348327491566571650352117933707257486573956946304169928743788185634447523842477877590419171398537749709462787343406307267366433495925491849463e-213"),
           e_float("6.5702822970632686809334039732575676433121815424577640062631259773008571821500206093969122977042680973880110685881899559552695078982308719441122676370616634863664000931221997872284466625827332027659184886962251688080463598220609993938994485619115898364353260622268050106278299757046580889120560254987359973233632938837263920476904127569661935834124997430550406239969265737256844444557994139273850845169e-87"),
           e_float("3.0161855812518276682402802823949754730740977172337691065441339809592954849272240599320142539167903018518903812151062350007010971271079942854826011327244404762348261497183532317334051887452839844996219061414022614535783812473985042488035619631551827958177279493755734061030739736762921874036354344759563160441815439353407036977083616078128828412456200159466652429105448358604994360799360628440996180236e-58"),
           e_float("1.5154444213447559566485916430999283520603288446119296480991369970337755235369746739967247974890882132317108929768474036290019347492183274236550204149060635558810400441163701913162257402777071479602045195708076317072578008032606165030487345587286512858179197855616615907311731942785214118690846836070960340639544142891084906725331384507097784367208431105716701642232310477074300025434726792900389273459e-41"),
           e_float("5.2746355843603609478486074603327857828286700965396995435412270824802364795238881317838256916769067677294727635050314613174139444780606965294710607640217705557873105096028863654310982845611876109788878417959688472178141636667424126011250252877986885212908332549944502576899193171105994487000402966724987238986487995639594849776406415206332714034792259736963181374558004963166816134464855582178640247914e-30"),
           e_float("1.947015737147153725383218684763117779868554436386392621032100508397767689704874790472948220467136585437896456203375221968520897869165279682014590833088289744782146924034919816422347355906432268837809178547564059318394622484812467242115493745213767491012744444015364824778050560141777759267584533573723305803284073279662197417619906736021859483148635299659456108117210160051647478191703237180248341814e-21"),
           e_float("7.1432585476590577395631296533372426173121181122351786118356057696189098796018278457119746234798105917951099406668975359979617827381853659951208716799089567872801279136631710397128773543300451700355130334452395932202538886016172629406467550333264870582696815069101796312527004706402299261670403892050392946413622538281271086102651457955449886320072057242743400807443222673737388666899430123950254969447e-15"),
           e_float("8.2778361097162106205882208591643319947928626092821639670682768182450680917892181893558235874078569113829105729043692869950280699899593091086921795954760348821295984134861223945824941458279495920365310521670838521812226768815222770424268023896921081474935201925117945517265797631212109438963853160097141035472001069210394867549472000733154010429143783887889400306587935988826336381814058196694501235375e-10"),
           e_float("5.6392430900198292339602071426947282343732206570072906389051078145090143853168547133013631713282439377724428472994799500763972315048767393583085991728222508650606848810726872440146528058334321363824156317838302169673867200594685985782393026058664624358932246161773488591730486244585136941238861723729637419116358767323009884085305648009131003492479929635809833741660671684103774669151155948904170135091e-6"),
           e_float("0.0029545936753228932841975169744543262364812206089441218219036775561602149313010109549035985703548040591176426888591662738142250800783797426147248829424166969108441745586475548428788171329380195447318964703832320873389514904500123742530536500806314289967696369954945349531203529665522150562925642753353562942005941271680674347301225716547838926890144049604854600874647382077520365394703178059163245605056"),
           e_float("0.10084326665358789974663267570273816000513383880593100875786117654607714072149954764772245150624224950848361733732367551281684574493671770537827443966833082759297079866817566394561382516370333036982932551885950507350285015523258143993533310429384532244436115333136648889783055612665162098622619131694174610435177417733208121101595761958226130538175809387609547648230013212685940759256855568679662369178"),
           e_float("-0.063397986318211010170772490403822829505685520654472493879849417904096385941018683297609674810525735244531782714487790057374688741300062559830217938742357407756555734277816914379214221729903825697373865270415826555473954113311781266704381989930167729116502356126819655333517313721350868909599073555545104611080308241433892282370206051950423982622120103133862155517525302998737187667969896640788347844726"),
           e_float("0.067198484407083362422281779553355130181508018964560098557585512851677881974559719314303809669899782181865603478864905650092240579578713017623741631450873081755303224246807873887422904919490666898782001770416217817697921841113500485554767062101279525840667814828257933694458138717597322178139162532117814041044377994432839763456968971643915147632122593305100690443960996591362194969985036720343409218908"),
           e_float("0.075238203388156534729396890377482654850839110613494172472326126540600189042901600077276344071351871110573855065559886383715315510746350146313981395835832361510612370472038906962902752048376635348537148289930085718610340177516028393403391494679949404430798987193063640807027049292468820660386238967949933423835215064869125924842124780029298139552125021390656015192801811163911075699378926565466991782484"),
           e_float("0.045620978834686637868906630939900461788490702913754505502561265228371113786983963754649329798257398484420481972719216041847660312183763788740251938799415890212446483145408031759035232344369316769597273805619910627788143153204265360852310051045624294769581104125054446234926845989926029565201783805923602093356820185878780793977114500897063537264947316354822831473447652752176695273677844473430706744394"),
           e_float("-0.026164263700495551548895358925386085174288777267222049187716443710631034162514631821752494641468557081970895577508384725429933885456493779483484850600455635218717813284237794883430898915223633457044139758977803130975930104188626971459910196221606532589128461849318280320958947516635184601058001476230305333051582820883737718727970854452660405032507870184688892535920876856238896550710954161509785290069"),
           e_float("-0.07055436224474387235973105645669914163196858486006360742676017747338894803783635097093177377396493193467480151092165859955481710450745681417534968268931875143233174940961546921481362635254766712571966628874926502279243692854565578978115310447513347211672460289531020002122101904322094895952627909020981134966276649504769111755839244316563185885385175192273897680800069218261406735479420222014525658401"),
           e_float("0.016104153258539728885607446765543534288298572212875380709944220332670972600787006606611739547527638446371857054722088881205587568965399723307974906320427415784609173248550758848694149349961344074526437573239414513394355726232309711005132435338226509109949542728615672027412027279739052157547749079057613733343396459446113975446464072974378979781277973343403719931256303745362914042805588242381088572062"),
           e_float("0.054103561720103408740005925303210580363762295003868351664731599303718917798437354293898016510338159827129524365957907619578988651840682963410166916582018189995030943891291682996181362808028330031951213467644390361217584136308776976785974779885539646411716835862112391634539480040372233857222762584881648293412585470914342262070686674187314642714305820138696190975736802141181228614362320575364816794738"),
           e_float("-0.057145043194472002633249333296107115442486656073153243649986924959331564520432127215483562885927610539342519931862715684412494490195103273417882958382680501145896734137287332873336909716705405466672711279147671690926784385516353923299612982735264885917923247451930143012470405285335344375361352202902608545093472409424150301254246694409623882875605212566587916697017621395047670993330469287877348241576"),
           e_float("0.018203065073541409732984481249782494641976198927136770267867053105952420379117832474781718008736158698412575039463840831193271486723622945388068057594347518304640240275879900237553554909804841612694167727466642367981926129944532905705476201925241870621192796846702561839178137659026703169503919808249642863453529286525113115991677847684056744343165519274308316292050051419424543089485787439002440990089"),
           e_float("0.022405047362397312249683780593126901532482598045239550628272559310290442775743130792513169084269432956340262856160323933788448331878983706661305808458418332313254549937352853047325502173544354048168870045367405915529121188094263248952150551095101538918400118694970859604150966117373715170094905597565912477895603380138758866027820102503313760953496668788961419938034441757751466918648919968136193820475"),
           e_float("-0.046847429237907114791624461782571864310585698687408855453478126031769666875775165001902177739204329049014061693359053802046480845468793976814776183312881351108625117222717998105788554860188226157570962491205001939608960385749970346700478396206267866077305146877529618384119936346798484858716554232205688925139309303583616394942584989257092380160837712195920054495439543921877574740535621471284476781178"),
           e_float("0.054869561557707791363978192844410188805453176336365213139028661438061106861094347743356987928757657906224405519159737890833009200297095930926476929636765579248169593389623552049360669250679128466209771131514823661773378551138674257811891165140881554831026428877399168747243405160632082089863012538160191149377750275053334406829056284891240970575724639574211901434527229644189730455122994370599037679304"),
           e_float("-0.052383672693022582574446855903115126116703030109184869907007954280783865431380106546943502229091298661275455437926221860455210382241746413719368750212628138348351974330020459299438468194635122991264380156685195127256920461595283491613502771175118966393919621181966692397805581367297602843065874403657017993648133212768056139741633000299888473182414706829648086968847301346315282448688087522715536556296"),
           e_float("0.045162981833510173615203769151500293408388252916297551888123167287978899545174284186992105320996673308859115677350495153200902694480760850536899323460374285708089369225566179184485936460820001215594480478974611983319451756322867692910254214743250566384547179613839178735349220656316053392029019206959789130612077983175548940106361943319477121280245953285796196883480416779379224916595516945980620075453"),
           e_float("-0.037013623032414073691307757627102579294391118223992401873862234492646268442715411219736155388700792648334527075929812734258610850934449193024337427752244820381137914073066126948191094554779890243772472778004900143138287231576704910896910124159613899648111842607354127326098081280729550790375027829932876388500915567263563833495176153814112982545298652104785681958805753745881946060769167660136200561389"),
           e_float("0.029929594615616076797329510498649969590581502564213441881948181736124726780039609810734908040942325150280994283237844003885298520525641356539919314288895305072241152663007262049071728565968153327844305573257706526799155404084175227478851902851399618703295805603163416775440659817404865746869214992630380916066716405485211600099782137452195970983709722115371556597564038273522443057839073914993601639365"),
           e_float("-0.024725683923010056711573388938714922514261902221101483779544291553822501434455586802214470749549621976994583136783408699990817937212104262755018422899671892041047248472509092948553903428803552765046214634243460077570653766814094205396492339224013932962275449459691892246644636237455010117570776160952827128942286715821726764573266370550555388346231221219467410289185634047691724386367198420244656200954"),
           e_float("0.021580374462865800169338882455824223098456693612100902145081199472089585378564257908508810135273915410244689129007796495673465679009327978762443899261643362498906854787490808908076123909285578465911243997192323165210722496278802385551085472845507770227858470289891016871016653971016874202020350269063847325398941781977909238572922817294608623124058574993610915789078081881829559687811767947790089725597"),
           e_float("-0.020375458159374445823489883396015324988920095738476090443299212080302921321905176750019311548099417729550158822975009767974144869662366159310091045660837087500940293034743739104106191090292959041560941530143295622202162622244922417343591634882815233265105384482409597505514175071261800170620193326140204856945485000629980178849596079459525588332942902397988785684625954243272383174906978569183120785929"),
           e_float("0.02086991661517477865879372370914616165577300564952779274240783350304830109151495466696562800864151483451545405104516610459249688745832117242156955489558449313377443107951081192633003983477789181183838823311569842274421776139567111281518882150835990354808053680081162013819144953769803138831729709714681211142032527771626004315533950074107937995874198449563908414467619419780031618467865975494020286504"),
           e_float("-0.022769727966947867316500894362066971436414178742301424020296690179544790124122167951310873788518657203648029354992583771456371124819524354898019717094370089072887781392519087339476895551602998247505764740089640994077864618968937023237945476754598608811456745438228404423856297876230308695784958954958347938652258691880929041442560158371740935744623112182021250009560822857708837975694168422833186274874"),
           e_float("0.025742269501141513290614211145458283279633848874536782761380622503456710017265927625202047805756586028086706709863801977379839932753238764333234192076116637537761154582919294492091452980292791345477135911441411622566814476774428347995077920591264235329119583297230579967451875871626501567586642387856054461690932427628494237410431695732524616027431792085056706339992459277901049863851898778547569065867"),
           e_float("-0.029407219372853137108946323657742998737190349030861622224043265987129421904803489853085207825772432157119353186486669871794011638607793812173303252390691285050981632267642971806610164710779988210032710419102882678685744106556856345893554491432103496447643444916761236744709383109224523345820687550779062995622019871515926571032280924575908005048406376579640191475921254119996954945530817276095023255748"),
           e_float("0.033323788007832270861051598988361920468420359531528956743166263758889806566587840831867685152262273825003814939718086940441250207512202751283947134742142173321975583104315829803552229193254330922004899896512964312735580330920566395564816739508455341516885686718396733149456115223815272129655082225338946469123457702613065836492854014283489659770968325239029654752682605068376656133761502489666042503718"),
           e_float("-0.036986741593635975773720247881796098825953747130359629629881866486569032058505889983473297286502660129920188241959440991063035713456296334032539523954886470097820655198546981525483202201176876561446651476085554047750954157211979188681179670134079436914053753528820455592216507271046381389262777683377932671920886541288017195454269423151384834155427441963371715226962456198046429288567704855963839202749"),
           e_float("0.039839085915873972431011705973951242390901726703201190728867408612842624424462372232674763644724172958282484321703537794556493032391240428940010567032043972548863963029022108383898022549799140030833823394245300418644928107045659861667801621234003997910179385412755987301449387019175429560687396893106803125253982995679948875626058328263242531457245435783809284099496226776857893946662940445083564389952"),
           e_float("-0.041305684473880650481354005335454882355483636501721520319234038529434725629565197669585809546941860446064578644273101394777089019022449787179983572468679610075599390482274740212341067794275848215826883819923829301304721295856924570958852455009475164823734284745209469918393722082857842758731886850278725797310102965992004618196974660018037201600557294157107402514448624605116608123400099967286308753223"),
           e_float("0.040848365243271092857118391477149089417410722281447495335963126748475137676939625878438361235716434357365233723787111541546450751608000000765262314389753547209690031626302406131399639045936475165468606029673509368815496446388218483343677078611663327304234923752760549582959298583694260655789085304777890567300385959663488136693839213690741085351024590790979299327090032129408731034167950246135280743526"),
           e_float("-0.038038776987168674225145887992216499631986004011650873003033536175205095101742783288299635741072547103487326366546227436338867518430810986153029165071168808508659059187916724624054233552556434895646952271283013916011300067768428001790811592718299013611481110934148527329540407631771085003402808132358760748997589277925734262671214576898538403383936159748474429496655233807620794624122368620850641263612"),
           e_float("0.032640542952138222569539739588951232461903086186214902453955722150997643249657101421042417709446185734240410757502907016103516033705220188152100516441689639010300565159524795076602543099275232643286843414761619072111606149548153611504028609091049454255033744093067364597580502063140130874241794705882002645841155425313016741938027120556942325370853760455741691006303275315852389649185524320373762864831"),
           e_float("-0.024687780333196219902508172657710333296209230172501003391677372982256703680895268465358874908749705440455636426077761640107939555584044572587770385503631999958544672766035483031980442971400716020589142625801774063953320094710186659992281415550386284345203103616479217838598316396393764947824939410963812962847893321853552212949981603099045953708180614159159271251638172470352927121379358777785942667821"),
           e_float("0.014543808731056740574184094050144358650629150130972272515486233807242402447191490017028890999753322032700794185332611363027858916292515570390096958250986426817403891130461259417472345403840089874718610010272643846024100925482221877609785994799917878291018785328360255680990135159581706475011872537533615391994911639371780486301732571792608507352736097935558909750750413451944902087818998670596914818286"),
           e_float("-0.0029229868832630720891526443051425099950426259189507753804333191173009049629229842708288123856282297155868847015329835363133662733662497456828505295123258999083206602633029758261598273137240307219020399323045520857565275763603111791934068332193979915647673200518444075296600897395455143839568288731096051796825219014983525883959883617857400670676810453929495641301324800516508260589593617215618492553553"),
           e_float("-0.0091389409402180916346794311462789628894536122684863792564912467565394991173730453587243813291560449694661488380254166305196512693413299807519380905305892230669787422824756814791836521734002142163613792341758998861585005826828946616334192336318438365186150443070875785032297938220513641652819305298286376724603810000672695725297105853009055702963771014424859261646460592687511583705252370038979927374319"),
           e_float("0.020374355702455222134249082036101128650220299313029806721131761720833114861320261999547885650253074120822118418337500877054117893336323380523763616565042340758157313872744047725742409460789705720596219203338181432876789064473202111612961116635597849644597577787413860378322648298370932667738153263381485789557132901447178006186124747645625005670843800300163119228146431920778877974972455455030623372665"),
           e_float("-0.029431717818252337179212824682538166785375140165060468499817361448766393147597055924029633241196468443498101624098305743680151948918043381622576877759555958662749567823508503614725307242499897528006277542397519149274628077038869956746075327919176433901847856517475195094095167373942465905865593389714313006741192859212756769167581373797017689347710676240233666019963424057228259158849112581353701304049"),
           e_float("0.035068451873096011078814208908332256500266361215909541741294336632633461969586822763483830448802847420288175513750823016812873758945089722745281232084864969787650009085048391859099137158703497949578925160997886050759386251602669891096858160200709875167998293817742550761746981001620086598171365955111121006452433277140211014006094159419893534577152063789711051257856020997915041244045764071812213442296"),
           e_float("-0.036362937953620966287438105098550139018796019047809133118168400405358222263481181268761703984017644102520826732580670415898178080343948951264218670840691737113468616089757667771994052197916518423022282973214018374263380376030998026645483124074481109286439497590022668117301096182355773600969465231635892476215056099157475548731019273211713993427313834123723632740631002794098790395705313851846921104535"),
           e_float("0.032909991022343134122005221705703418442650286227188717509285846006524476091358784918775822806736632504562206512962449825624269401956627250326329075219125686207880194672149847047268615601840256230734553561899320322998362915376432141429016037736852911059877740850175539746244635392157142927324785655277612924314102282200070648703509808160677390128564471180021474190360251314833829402703609688243114816021"),
           e_float("-0.024959766884885833163984409906784169848403547399404619634438633066603483318145249678683962679928589164987580510583290124997455038255908725488780597919973707333736461846787414658253215330457422809754602237969702905101053294917148625505618006596494598418281347557754035682682762800670415474418949339820188977199567882877030773684736407209825952362107699495543757862244632132577877307374611383594984055048"),
           e_float("0.013463208703842681127971136285964569853445237295539521577807948314225397132662647508615173302406509473125341320579269435893831025659741245320677889967933881947505141328666225759189292339150411954380341767557051731904034174721989701708400781179574169895183468489006427962661175798823983398922222108957439736272398330028134375832050996488631739248152005385537049242954367124121651357309875490718915834831"),
           e_float("1.0622838098134399694058568146674963014766729427320964407771010612384065615754753511400013518862008619659677036644862954267522971955228747308391892561691996781103033232761330091409009743170895915208289076435728884321134444782761062471254114777066527578701857581179480819072824817679619003568429876951927916522963320120702065191784110440928499034374078631581287810283458883501025141132013013308932278176e-6"),
           e_float("-0.013423924486740362513586485387861027010568658715103790651005688644338732768584357982040116378402004375976665572925451823986948325869195828193317445724101542197612464672779283295244126569214207089761002683258930221162260906198546084924243510281153630286629020979039152497359938909270744666121721405935020817548584438641914312719566581597433351051970993953232685831356577007654735247743042060320460759099"),
           e_float("0.024667981783486442803039175252839329302012384298372143956279642928160215234309355396571850028414812416822649327263636885713858237760367170870125785351887890704804479444477254401764676144109556554133959971272181634516947280472693099227837379911437069861981918623409135046931366594469807978890543967462315795792852321252889452998044630055795549386541938007102957333819170835206565003096800502568721031982"),
           e_float("-0.031830941513597410674535202614664860433962555932299467930608571112558151065816158770855566127788403915139653190350997534864372937228025315556827059067085813320236747534360334745123335350592152380335064857548499217474861117627202470429836171764340943638503599271455600359909765946219358727810284468902369373894868235401277136474170281333892986594875335008745146556964193083941083368688954483990031571734"),
           e_float("0.033606630539230897965819376422759194874255191652950604730898659455081016329415974263232966391526452065306271248321596297292770185408361048692622356495068292185355799194707553499996589382961810534591461942150846188822086932150819669552822199174144171308400951444247226200124096628196947134531973368985149172401373898547908383508681417452381924149238435694702199691007045233160434143103299894625797601211"),
           e_float("-0.029571187560254071072864268272323261586629797225718601867183076435912695797714685289334468587742448203748251869838629613084743111190163537618133132252226910524604510046480580982807597494413039492762869746824322185727604833311316002454472476653450794456813068223617764151780261899962895231133174419996927755236773469360779661421699526895712503561982861425521954914684082148900566392514564097604729098472"),
           e_float("0.020327550954838589904442620754741357083940691124027763068291283262928047177814895702095685178684938876155422825218716646082972709302191618847305813810518267566082165548085429560536921129118909738144545651250802274326189817132116154716146332350855796187236414381722584292015892556578345993223394477204555602772145596922392295765752486265332216701191452577080968043785024730091309571897018459048956765956"),
           e_float("-0.0074625415861215612838021662774850448327331353730497172583224397028020773481381898142470569012618280435521734002628768349797321456487011519745502009023736588924353925001766020141072242582798926810183100669317539816887319415887466249925684917196006851984573798255203338973547898717499012314411683048043131923774177066430541738850584764781947438930352645300655017161475634680288567199090682104624573606891"),
           e_float("-0.0066948500422405577211178614192367539957859233720367115959345721839658372162406771245003971688430706866158909459078945277480404040997449164893911113655534072878089501294449910694561704064765911949205534605811417719975018078616179270061411647690956168089586116261233468640531584913336640280470503666077645084705850743627004226988303828305902873609928089462155025121847539313778711839095581203406767590001"),
           e_float("0.019483917230778272755986773547955174552072161713996963376360887785708300568125880413826018869430232356263410050219226608936349403934063791389693898828010303229029341094958962641483884432829027560554101212122736643340655963425678350630213788369812533699557515952908136231501649902587099273916955392985044847564400069054115059836909457365083200750782955630883937048133897365339040833650305899294628783849"),
           e_float("-0.028421401500239783724198115493977184453338644462223471390401224599690185990961890631051730981825683418617871737893716692914888767200396699900602821346814635565212715715220720284696007594530905983486203612837298388298315720992583815572771375022501157094903900975263706685669986761587228278977338208285661308559499130880728539460756717570218247938047119572510806722877193034928206617315296886354606057408"),
           e_float("0.031710331404139975168307453356042453246568359603115182494015967756153735631979002811300792448023320575242238044474117781507634282035576752592075054468633382645941211233916140921327144489981268436514138427081192561023638286635721108224415115573754325273553572457403768617686492221611200994419481820511634072963917687079941843180066869190388143886719357777873959227242366201929625689843218967569731089164"),
           e_float("-0.028639629115236139113770559120046254983079467661792139180157540251971615264627499302988148485938640945749863296348223894484751890761399592074391283236287351935378195348645995419214131543350810529286926719932047965277686985894831581943402345963055868574131374738506198891901540668668016104424216243847150597195621817144918431714014953582804186414371292090976256927914204962346821531385277023541567547537"),
           e_float("0.019779476358712243009208669427082649062831100917155371235893137170276012535397220477397820826697451301427050139347226090533069616794662342288728933213993905042209993959024163989667611534018190860356150377730450821443763663400003151837131251335970965277753122447180798119030640391030482767303750116843136471595292070621041840828226427010936826253533438927913624217763175899909885697417269244507950646465"),
           e_float("-0.0069145636819947978376659875262751922433789673218530882693191669899304276916143402459747331200699043689576166673673464603631730451875803466540277824078720259984458875656964975968280065148521337703927251173731547575387092071023997521168573311531546578832865528257173928402127306438205896947242215992067311823461415361541879954524887955435753111322836722615003415571065729973386499528343959181032448235962"),
           e_float("-0.0072885216095197568563050879650353911876332857219252859553610836129751292415875368343083704803863358194321601741902801133664223856300437466172957106724886741776637615913315331955510715568075721531483084669455124076140860163633765506177600858141972318801670697713391447918333724275542131201897781410140697560388977539821557536131643445278053446115342407511572453692260870039435400804324023657817922887316"),
           e_float("0.019823472850332072920853108381354896138038794054265809214983557498507585076863880622145367002111922978480060523905344491306312239105406756486964308069533606721157230836464019932865864522390498853756303385998965227435840449383080335524800121544773662404369677904389118827041883349639208515975303259921274691049452771156701586830408244033859711393423599043413521369850193915875083512069354511832277040273"),
           e_float("-0.027987510920159761792020850501583101302406497636444875339859396426312157200128621440895291116101326660886646263170964885272560525103182053839352650673346103241493765176163199280526286721701128676590765002091444201817643372829279033491646277461857235728249376918722426246073449323549691200203173800936955985204436241013478229838810044943616280032713924109993429483964008914762762906540803838344788755961"),
           e_float("0.029986115877882730774396876222268296758878699195108095652177893228038969723956115630665516025630058322818270925389552291434601565482488179025236584013480333090454998396148981054239549700529475832838819256659928492768924107937640097477841136995480828624580331715198251777587302623082888774381313888968346546209781791902649014371816449327783752293887913560480987771493787171268199359227698986231159509458"),
           e_float("-0.025359086288854553429868101147297155024526323916109429562698926750328415819171127367510292066019033375972272703448722733070973640319775523854495784648402393845943013139788506636381438680113250585956566389694545795837171545210630942801444098821363707111328192653928613166647950976682412423183636335820718628443752568439055710492103563836391043034382093472459566836868847135115152708882229552708272425616"),
           e_float("0.01512048423960702577331730710909114063115164713469768841929819919333875788794066975409766836713484748555565782111733047242021728599936277919387152910490846361866839058175258454251587956609412631381877814239304145502073705859097529593010545862662754859505037920247985312021618254180538563907449770622386782423429051825738963555237018969494156905696743799615669018975780262347844156226448468378482276508"),
           e_float("-0.0015657994636609000045690272168824453535685040995685632042982954127329738456114841697018579614164575974928859020728304940416364892875455024943811793092973339751549540358802748251057512964665584610644675396488875138099335695206879766753891437888922656170073813063879004457189221217236314741352365157230353045831231096184617452849902834349855567282920179161186910496442872952364291705703273755036574268523"),
           e_float("-0.012224164050981608392283376466030250178177021155582449879650593424366031919198594533035623611124614351245751646119171362338838778871222455563078553055189174996551272154514534763520141632917227728491547972646969546912177056362557207683041022075125119372138677632771175992803255363665364872136743306701809748234417532543256477506167948011651415221541123578453532581265154746361471277174478886392064515053"),
           e_float("0.02307918079142447804762445449469402026524907933538648527282914505507833338775295232808936399209616374151408488331853014011276788548694521915171839684592397991037948057759095674700026255365334857998787914429302418674089772432220555731052264838972499638518471585293409387556088873552029999541860479778855013855297573229320822516149156612305956893105412888758560324436534444441291665350560629486739734775"),
           e_float("-0.028478385749334836210056639546133545608919501138647424575588383174816327882780480468874225595797991445135553072690063891044758808623891701081421972388014595843934175070318307316005589613287513151947872940239519658602369660283042802798784424704540543586475027677709418371663318707830250460187654746842670496752455093457361308903892073852338407720508231584459328045466683846439123073263300788884095699211"),
           e_float("0.027156915584909768445415925510323125626197185587877550651215152277467744659752133533063823518630907628015380048008898009821191103312456790591493970631461623942676962473415628972286646957246765361239687044620552167625216845459232885466559248042753618969641706600805702821462512486890854522845643997468153249745343065521716386955322237064836331269713575362303892521699734674348461988898869885269592185455"),
           e_float("-0.01942930002750337462978875498916120312534526110842900136385710941663002498189269511706271810601974193130692072363468996470036242453750896771193798680134842900885607827512225079855954825242521814374968101446632804498432605531603004150956346485855045262606087220791034468766247040719855898734790290508710715490996098111385227155552761460412027400034534454037847196594601088701102088500185168496885444276"),
           e_float("0.0071410909414146296161595175177892760371670092228225992315691631201623717420611369644162213887411839229940634817146764622787428534901679296456361747987411672529355537581887342475193918244673260316057899651128102977212116319773687881628723214034543704001539205529179769415619200028513161646485045771493514119660016623762973589136060243657424332422087808752713743544410620530258387170925979540523145177825"),
           e_float("0.0067519757162001869900218051736269572805323378158773373100171016146432593885773590402259942412263833271285505170871083557927875300104240920817710347161882156019863388019996872237877876640794963793653108608651566735112963884773049166621264254494603560540421907789543916770161585175670752768281787098340823094325250242248720859191744263521643331670866826938676404924160884838831464839024745558967084832448"),
           e_float("-0.018885741765577859637166254458820906427326980390833161442503981120286949401214685258217691093271326531829369430440074579000689715685866385143223883898598970795523247217914232691113677847355714605377579098318444466264578548384072888162485325790763998380524111743883125369906575551827268127303279209413226639172444393053089774537429152707217960836583900147794927107014845930705539856271806073067274903741"),
           e_float("0.026305263309238710573885040339545085295158844292349689983434177312621131128618210719253010535391974014126215099542718843072225746270525280750198348838394493270224042250334850827743811454479862744672589656191888809873340179287038770549234908443463145985142952323276402149128745146879714908740359739030402731411912978399125638188423916893482762951906952625857585857373206467023524223861376743863155157174"),
           e_float("-0.027198220472825884287166841107175115025992649191139149955116125508880480929957736416919164907145719930095411109618788642463781093747616711872462168082439500751251621783740359523752904245037985858486277365805549484539158552329582696928320623823226090032604871660515839580960315690891816941319045702229906829937794203830901463945995475733907950260061629802905063044633572364337198164860396562801948521576"),
           e_float("0.021358272243703304050791031765375470312956382249103667069673190943037041576680498125515811353261700223575445996710705997544747744905042480753717958081801447182506473511459660924349657700721377568203897694228712058496109053765841830098099177161306674928178076877267140248950110659511505565413601138822321090394011905635249215970677846625626415990854920146023863147996912388967994947446025363348419750372"),
           e_float("-0.010254777554421380882356330504797395517642766837124453985775572773232871042167200517985911173410036072598527432266926538302776152239258724848225612035472518148899640942445221305894091243179987371830951142594093503436027272892758379124228019091524629580625951247568071490613173767549420108515308846099714837301169598096067392158659052434676353352383254739274968658474540655980765366126007954030734396869"),
           e_float("-0.0033183908801150882984297882872258949608405767223813359629324219288019891104002098971840377014673572824391950049327947579375157409170014949486948615221583129525263015221292990375377954623902269776405256115252805022079868831980749133536718808662120001585098081460782985476142200262898317790337638890174936348813676372401485811036188165413211584378344727818226354344341311834127789194475688217560125963481"),
           e_float("0.015935364733869369604067142199312663623074731608169472717252845819074723128950068241910714852178894047826075853259915877732064476544248379074351286110215772550393291053262641960145324262552965041593247411071257805019107669642185509098628715628565022177844664809388771260405246315927086241332971183998589171172822385533266351217151279274988670530032894213100365652816367843014606101450907781443414171553"),
           e_float("-0.024402554052640651638399623970531759133953114429232169101471320646332126259057010481023764059995205770177730351323853998406571306743900592960302743989964974686598233756150022595391090994561498066552691940133036659819998928807330522351169504218308923274357668373537920579456589220656526770775914973284691495709754585311873521915162641853917495993617678834907338124587073068458498165362035869552282839088"),
           e_float("0.026576142228803085461374268418379727349879431955545185127876833683931138436701171017661609958708121463374660391807965527652930074246409407471935514677213794622941443869201211053609651043733848052456309657999438526223743304826841885065398645507818859915554370631810483559821577004627782383354541814662239602682546737166964184781177405915981598235398462061706992102491330384607758741318702063295535302289"),
           e_float("-0.021920748731879074538229364289165053762703255089107861941329442730412212357062820121265948216548023745789784248412114836048276814563349797920210239167504980910819030689547660133036599645194078114452208019360116676654259483133551104661485349177239755131559567662986723819247345201348326037367881137327171956855770838091247983614565908463345357532996174196169280373585716154636372514777874892684869460613"),
           e_float("0.011659422648997448321440925437878321454826657762062820644574554874876697686761328647609305776760448927308746423759270173232682860133371016441085845900558095932839869013096596883149716079577178478102463336188560460477599667812562173117058496384944526939122922906604183003462525445811102259793777336687650907011135193784733766481375834480997019846480926247749497780396820184939545157573439634955569925529"),
           e_float("0.0015314435177786343170679389862658037252967818197271054469045565810490976280135677289604584135723132622457338979246970131995480481458138586953275616859424295321828594109614199609617983189870894269327746111059152602990999697775374546985309779047506532587978634017283503480024248703112611871038451625271945991830294092950916679427572089870982237990502233964463601641225135989615841555113413342183829014725"),
           e_float("-0.014210137292318608977623165473429843478476446928056951594277004076831371652164360062528361295559815773967065601569703207440655571987589198308600543363954610420375790045665300106337006901765323262300108569071463741083018346019233846429074241136569958400311276823871161883143623181542770104266992781334573210468989815295400091735773843069676555008181468063482706992124356651483620262511803111637275973653"),
           e_float("0.02306585905072912385950262796040319222060512097153288138331949592919006150423365665579787487056738200357537631970706784287966014215253272562896576996128446834025950623528593688959063150187926865993672444183584831586308743322326474900585635854948683554964980456647752575910776424391721762401900514217471542069869398856878468459232603230237024963859435140942488863141365968398588474722668159349016632071"),
           e_float("-0.025789720474984157323347893285240115993211324106522188089558581775539725822841976483905964445277103278455206643550845963531359511349352506055258372685804951027267970815389475140298596052990283455619702773021300478622848297376482132052180200265842000291775233275460958010350580672288206767869696955070746252010912196704858745327288453279286631978967612258675691110325679968744197895158226736916551228966"),
           e_float("0.021689241719913435783756997358448520545639801789157316658750950333246399675975158920823668241988352342579186657567195032088335890463808153018117199523000655275350701064076860517967985548208945640042358037803618537325429861738811564033000243076515971656988945062524952261715138944296033282701965105372858987311012120480832752338825830767484066492369364511848568278683251454757227291086907339850109870809"),
           e_float("-0.011879264846524329850120101066664642103981986172721628139728178151748040534266550746359777989023088526099563151260853921218289884360272814821853403443724554866393472023162585312671123711271034592243482954726608335716509756721423340357205307061471711894480435838285503537761598436600155100820542822428802851989024299731110972414644576845346569897384561476197967015938777015365090654694312686530504589433"),
           e_float("-0.0010072710448940447767190422327951487416264567645849113439964453192356342595975295438192001406684305820305170897264180087988631675756672030367275939061648155288934346879897229242506217998177744017555391192324532534840801567831410979486813535908695255075115793117955622544619795352210793729753028971214467541257268967233420119628017969300159431030621621942554253820802248640851890764644367127994623567728"),
           e_float("0.01351711388018226449970166089480129205345304220056227435407505901113339755226700274776067199377140404236067390778702638379162584451442932446001795727835821927105432951190263062578858914346809190714226422874388599833523869343694162530562527434701900664092911473354429786938038865258858141292931448529416885003244348769900820448167749017086912425308087136088687197751119367657113115811016976154008875839"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00487_bessel_jv_at_v_301_3(const bool b_write_output)
    {
      return TestCase_case_00487_bessel_jv_at_v_301_3().execute(b_write_output);
    }
  }
}
