
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00452_bessel_jn : public TestCaseReal
    {
    public:
      TestCase_case_00452_bessel_jn() { }
      virtual ~TestCase_case_00452_bessel_jn() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00452_bessel_jn");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        static const e_float pi_over_ten = ef::pi() / 10;
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_j(1000 - (10 * k), pi_over_ten + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("3.2750814329662038591191424132793687621634949064509543489046211776198977117592824059039964933246588135634438136551536083629026654984375074971142329707821500985649979099336710649389447860293512425469683453048767108976226232806398316770215418746815024630216841652061437780073539540772148486190847705867802817589295112103579055300274811274363838432498608479068051274177306276538189925211110180006992125846e-3372"),
           e_float("4.4044758629094262522861371790962053876520259382744851436557274424223234220788403057822007256651577779358126984792657646595728192274529510509426546957947081503752290007475409871787527387642271598010103605895335449989428217991888872685027410769058640020480291782802112562060097216622402912004317444676774459910910469602377390864132265297071508107419988851872180864313190974617050918074674355635966848403e-1833"),
           e_float("7.9451785442959922882653473528662402588129077312043512695366398922157558997263005929342561733955368332521199187797154993954225182895503336258546675452693032154806353856259321250791092089489162797990417860861258956163225561539176262817700899767922848434901715359836254046133936110623277119602067310090083554274768002398660353816562352713921779745762045253304525969565550566187533762727129511991163786445e-1522"),
           e_float("1.9899976121105430153520082814548785815530630703141413571884525804165822005788100442303784780405876259041955126739659942458521723611197052608512869004621629051675461477159712342558237894243766710912473838437491321668062543072995844215510556623126816501651175516739624816613211770192063829871304990808793347733752341836748689738583514173867827219763994791025020588608148145522386642667888499378993852825e-1333"),
           e_float("1.3149340917301601523200109138359182290096323346082085349247727743103902021144199484776959722059202549543687207580616136315949048131603496879576840015553472146808145910881159819028334004549808371796400035718154556427330847344173700779081061198081802799753164856296027181769941681747420209837559182727018416255038553019046910404347530621322639004915647951414608910294942546985336245905237389952713806351e-1196"),
           e_float("1.5575340028186117844662665950939185612189760255412459382427399096873870808707416667243408108761925449023346718370842422701474335123528595561215682419605027095781265452719002237061240063753203213854638154000134272141078509736221808777517349434150176577669063871415481546379952604796204016861995667653328664825969308767564372975712143188092391727580208026474593638207533508278974205564496859314446533041e-1088"),
           e_float("6.5601734559867363545825950377454713758324140385830732774329470799384939018220106710045396389279642377748954420251575941931616115345531003671298976235563070168753621519462511282448897606210740808492774695130313440475569595949829430400601268146031266418796576969939636283325218087851822725539477441206381573498837475742238675444955233164003405329749233844108542699090551668445934089233387958138212881351e-999"),
           e_float("3.4376414866998342289723603406096753611811957061213712775019221133810039819301536457087416641068446838271919592245361130588794067132569881460029898161117109859701573009693542325217941495955145805336403809923076039211407816926978037714672312591941484663225728589366379452414719869621768222772038670087920335127122101891303494292711719472245706824732427003853228067318442265028951974946479592270288522612e-922"),
           e_float("4.8430092127072194813688518660598319403576527549811779534253915178890486026655050246635287496945932054906271177473955766444767870689934688491596946694397132253280158054291109185848168481549262688174658096167537021084516941243990063352446088291844389710822996257034587666662066403661436965077436403028807481212246449136026272538991385337714700044082157328828142720809965460105802192428428413814506989047e-855"),
           e_float("2.6845453423355760584478940002652197884267251270194506122978509747866511406828413709913144224556800788190066743032414232828272659368184421499380244039211931362556316414307795647866806877354352820442558675851001566452137606006386104572633446285853241699901180670467365876337909108562158335055162570891890339097045254779016755338041475676027568019406517762304442526143880505637153108827647710872734497548e-795"),
           e_float("1.7990325475342024618399752413525626237049565637752425464233716841319296663949686746518811126371524676098630746260320221405048130777466953107618795506063736264037598606812817724429140132073459264609852011038644705572095537932261019088020412716289104383285058730553321764818878209518102232335126908221424751231409660439115567929503165210386771345647716178677793163398829581157343693893146828359615005602e-741"),
           e_float("1.700351581428222371893902603454683798813439680328354539084096706251207979939870147807991708960071918207230627903140316747605711123330496588033481743368017617366242213466509093262635857273580617613569050419572986747557109425858735113351623108805421113981874805806583324149466291334968996775267967503620146041387083422112303587690026142067075779608152914772978780179961887296799624110055554959147987509e-692"),
           e_float("1.4035531107784511900261873528783877352428100493228234673612072640339939256480409511040707274306622729448091278275906825552990759157271924757367710065485481132296329301259461224679429819546907272312272182963057121809788686490308876755412186402847164837169096106250356481396022361872676402856919185299175213653381789100239455808417547153332281112743201815047386897131367884336202253882175226672429897455e-647"),
           e_float("4.0677325755076905689749336683297404741689462175480018758805538304394023993406388775109135990819795873355027604346947636633873600501989730009416163813964091499077778583783753749707147517263773115242942645572712612728270306285361424098379049251394851099472330764019766851287278320021013121265158276029055460100355678881439294196611325595159811426610036490451280593233274056470993699201465535174198533318e-606"),
           e_float("1.2265687597258087981322648616383831510992156995726112453315557327220277562210427921457758480989097055691855070628040566953922469486671403654095591249485618862684499337662487207340842061845076946692680705823472699198366132421546678030827441549819595452837211373050142419393314151681365115655343775718278459053843895368596888934393535389658767620134855362326858450195734467929051599434999272512459192256e-567"),
           e_float("9.1364658059923356797771627172448234851606407770185932118187782338430039128531637327527215072093097110327797102626444084460464202886350300115302047611972079784942840121412907798515376044556390331190011052935319561442676230759004867400348408967904660079281600055285565856024638057461239222933940733775877088840961560212149478035566653185365314466759605634833463364166735844810804971384041240346125638099e-532"),
           e_float("3.384317834486327554170165564347577864100474618545410976459799961044117586149894592185070240987975564323036473652308697217973298947356164519244860220950623486293271265271289202144494034757732430713197238689716298132018165020077328104656625438264222106261076927947814411239634166903713262759096309078646276896706118590526847474402774518613532519587160391256909802025668543748849571809836281177501698101e-498"),
           e_float("1.1069507108361605504595121487031436728964998317011596010827344359266672548931299189653943854682778530762352100752291021995966682406995848486055746822443847693823131605545749544010872430721500111670625500475210238219244282780699006682910475602505201443247600563303969684498056839388563710816213390476626820298728396578786981416436563034773541526414097911135853910447872641318291145592158639982421402426e-466"),
           e_float("5.1510437066360250292998713487192462672821511373922697070186930225338634840589312166199847039553638468383659617390462189662957750531015754327277982777759620016392304976295132786621457808955205147884963295744092669794099677208680145072833936379374865824585167033381699144998045822320861832521214221754559232444844604240939460863691613108066399713049277590620980873060945789204994230281735388682136904786e-437"),
           e_float("5.0897049552618307731429701190744013941459001919209591005499039728657202284744243060119658039141988323310063033000661307360805680767362886059849739486632570141922362755108626322632899161987846194452330642287377488501288750172717457243002840128162558753229259817574194553106659312159905334131973158281444691207977241375480670099707986475542400321273458252176207534502596007790564308023695985983492739498e-409"),
           e_float("1.4993805214118049258678476359531497975806716852626737667496359275065398788921122891719053090230530490032958867788900971207128557268541740006982310619150847466350817675610215628874041169248996265575934187494957046023338974817423938564833969591657966466668884367018263015521650942376347220704376785980341663740822663384352709914950355604073196958880415443482654058281381046931486968363703549824010759434e-382"),
           e_float("1.7598956888263695469671864674889493654544308721410136900257335748684061243147271079320398415062972566320688848915952065950503005935809642200620519983512754553693914211415532116597347502154865588582077222627175636311461351892735967871596330700018057864248696924708083933383930477365730546188281308396791502978062174882265098188953939922700222987815637786107111946864162819244973866652637557657140218949e-357"),
           e_float("1.0563115942916311671157201322470209527669989260372421952959396663671247867142152192144805035878640711920911875594087089765420561228945377264632335614349997978785096856733550112245121958498286283769116514877659980995927401698107014453519147828150484060537671830121686315663175389811675623123752660650443782276983686485452935822544715802755162685247677881224773229352349761393180216919882094050210878776e-333"),
           e_float("4.0241731632151115331315894017805947771780245744299294748781817612208554407659111375143402349331779731459815051315104341807653698475126705495601671931685513425524930752203503872915618009993594670199680552686159798615701459922804417535761589608309913580861124142941241540073325353278773500616523103654990209293065398054315090058859362008152197630261045300487536209831571715605676970026890579095939339246e-311"),
           e_float("1.1745070745108875965486743317426766662898728755858424015964512665875160898354344167846621672892340507031302046087523014288214258513058559914486931063354979749308233595110271511456736314749458065778090439337230550489736966048004930659251170715370994693958935543976443969742660973903195285907496536102238690121817337634675353214240772577121649277417077973762838264864080895311089285030720965006423903064e-289"),
           e_float("3.0960717901709440956412889701875652717029640820150523202138987091644255003308272405022861155718612006103970488343641401447340163851353391037320950352034200537455324982068810327369979939065210270797018940845718773596227911131335524975977720880401188856532960783139776765313535427261246180137710304675682174489861623585620947625145879007407823967213186520135489799468206052295112489969384356561549939157e-269"),
           e_float("8.5176261953112301245316602971386958276290335525553791574584465671436323277970081577923917951567497233738793280071747342716718598365634545589762726389946898622619660605070778558021456324292550422346228247623720247686123712748260905575795633380723851687007048424223671980011104638792795488336224046221415205439829373055182567057341462787794729932779448073780400161104125104184018146935642719729742123714e-250"),
           e_float("2.7776812318102638356433708660231632628620650202795009879817130857432535039735292526289191218255075252435823535025944536491357021627740186433012868040679712959444100621969781663358426197626329997024542086018089439690850302940469635675771152066636698057239373749461394850710996620680033043388814945560532874755697279143222906799983800515131825031522833528427374353503603276344940318595253785333739586488e-231"),
           e_float("1.2015438771970846498908961133868530255093137072348310729271405622677190015386477255692917058052851927619743002016740583076177898584277753649346397891551366216966784713374214653007689162222925527145361742936250407915069734262641287325640774158059622292761305375393924357372662664607146387437711700251647239389307594666758851011372242059959112134761449667194665001451185167792081504152347862468898480013e-213"),
           e_float("7.6152063042931167917123970583120278664710236759540118240663209680785672539581811720251260421305415025072797929496868530208219359445049039393025505771191716940967968959885969103241551717747276704424122530862517446235369920738226142924835428839974614167486894500360599338449108257479483516962899576787212069019428217764781862375766121967858965658860366338767699987565603014224472405342551825811295143055e-197"),
           e_float("7.7219535412790867631353175013188590646196774584291864669559655439849844122035332325806506261956189364808166153545580914658134138234137939015022233500759015986994199816569544977664733139939291044143944821045710127951906320265657929263042720953527208020419637372308077318937466421087476622974679777480134552595029117381584450969744526899127455459605378215332132556346571972806459476937717336305917113328e-181"),
           e_float("1.3541708362555689200692242648510834655202211635190634423846131817987870326179540552321333159110559670167165280124796109849950860763744904162589601645725057885527504225746158987210288644083880215710382440707161342883349480531328299609851312464850048498022040753078878750348187102237361916470898003348365466706830513206686587761519795121340628816868946198132172377284309718175916846427254354560255938231e-165"),
           e_float("4.3989223349793065622569085050179995108629302073184624054139898255699184763003641100224915991266586037735111145031971737348564633486172632007983449019380110808467769191488449088617923489503535025532766397385364604021315689582271387439485635154239226605037235901890682087899583973565848132706429608038207910935444502253553196178667563989387646135542045649961204670968642355986405760404733790189221415538e-151"),
           e_float("2.8116641725122096589041672011611086425785261968556981188751269705811554966093215249159932131255304764532163026326661626756556659832862579725276826468687812416904046476933780061812948439179925533609189904996872137014491883564839510492694667829516594779919670367253507420274457511410726295836112666460906069337253292022600407029198754153567406972979241813965446113124341249918305722459402124561554046865e-137"),
           e_float("3.7275405488494476911060672501454021835478150862961246756103754919978105918742506286035605354587193989489578192375867419894653577121061319370202048342414644641280443201404376134599057829681690982890726068883970472268591778396496983912696349927794694590039319251501875469712868296398169758646233064406721705661701567468228059177029515617087173554629594905649866234039563256116993325928916757918978572571e-124"),
           e_float("1.0728018568977461880947514780870545182363200589763221713298987496869655845997407763725074438478553443080015077007217122639398885698917620444989202554742581594602099514711176609929084181476173126394574977709817545356289184775507604322632249632650170074813422567335927629302804927340055485437143100714387287013681890208262246406777920142430737727525238499501293467226186331727658808489524414194389757307e-111"),
           e_float("6.9679451466930988558230597896068199820748992261666062133552550126361290739756159722248857562297575673152428980905559796129461459436660814645285325268946497490953339828589388240912350629086452540849657454352438404119804784668812898953728554354122198365221266582439841533027451488535553518518566071467639723670773233823608320261744915900164981482326566664293484308676753111340114501492637890231260518531e-100"),
           e_float("1.0548022074375328442223702722734977202464429311303421422535446452515141851200544315029290515457749826601246507157346927587646276931019930235730542068689165036885850282281163062806082632688406448956148570759334654772884538578804966686542541916089161490775246669840398149262630255895225157351997798066941562514775062379752125240345491565377228662916248139820273514856625556036203889725092421737741694199e-88"),
           e_float("3.8183490093388227646734165874453182407921804550242416180422646692132231150895626108561427952989309282164381866948996185604568410914262139822026240195874753544711523331901974918021882506532429384755284420694747366320586034362397149659679300022888840788145067090774022004976444454252460957330805920546413077178763314878917797521343188259627021814581085369189725145155678087518759413156790553488366920135e-78"),
           e_float("3.36885613898529116677405530103507401759111379126445116204360978555312775538990665456877083880023478203070676842521094028814233821582351047491839541102532382345993253216707804020125979182537094337274006776631188114757738596656264396188077318921142401327052598546938998194901348272198116863301972977149840055828600029824197875408548878674194588968747020830719486351669925393986352783776101432122613585e-68"),
           e_float("7.3317762174965636147258005948790479329589973962921226963739858292351226158642739740103495735647651630978977244767002369427009696247863216026456201676192354857062457693914743380431334118406420939325689839107201451107787530283505129677163242661754872549618952410286229193193280202097640423245769187020355124362686916444684578661987614731904662594750448046454705717437766761955038294827624223477719392393e-59"),
           e_float("3.9531996036686541914389210498050127145863440481929769772514948888023956413508141426890223839765161355892216286617882575706064676368106340863253236942331968061844380057757380107408541868754577669131391259761336693628762277569584017795254182103624431314083605586518321623873414430139897061556627950973586871417939112257967622564355204471732423019982788207451645191028682197565463585704629645323278313703e-50"),
           e_float("5.2579438859785822187251795465811678049592658841293765873532274033580148436639152786105958722430417548446061748451183860490546050151720508264270668425095745374945773158386596330016597673821501136973722566539950758933120073930701196462120161739141469605577406160160132079242088487422953368414125275063408733314194972072689158440137927344153052443773626685666171469082583346356724948557508585506630269547e-42"),
           e_float("1.6999423419270989555269945612962640378954202629092077723637514691351688531444115211954232111268433806612656746797892740058671948074337257837077501122110769348134083161729087354061238161593210021445584289220701002352585772816452924474656981058148595071069688058393690874673110559046192072352682299547783501605064367000315670571360757374452248450862354558096089696192657111032865649524608506442615292906e-34"),
           e_float("1.2996004685894896392665985848463060209128684424259296744800090453538996265216181353053544015477651911264174566711217022862243698542976977356210757185840881768661670176290229378702279003144437852542441683833802148839894950454989706435707158043860681083452777916707918434823187176626486935797086341852018251355981541469230481371389481715879776382484443955944124254828904736772567885653776957236404875703e-27"),
           e_float("2.2465002097393729667100357757198281608184827619009244776578712872410450004620098158992326049567545640087905042597149120178876639248896502953887436684635179790194998608320624590768676840795121574985304486490476688518911476562448369956484815598059253412384853313315887380667574862510733558175225373490349620587930298351450240057652868781489497091800879966722479867609322456926760329615379878099916818821e-21"),
           e_float("8.1945518574947182529351341424507285730284360048891901267160750809955139568730611969866280857014465648430099706978165643947106105313524901316031499109285241005509833520221739268523264869963022917937801067009179239199686596919630917585171904961228203938116554244508505401239201178870992817044008283208944308646307557248956810545868855906838374552148732596750535129760534578938303087663467605130202107341e-16"),
           e_float("5.6692470859992597505976004381647117459092041785813015410161259798993190464286942602768795905327894676381160483998729726528721488155379582968459345894307777509858537266356470221461688105669419979982701473551234530083826202093358808303920796199051090468977134304370194642627889058054850595974159372842988475102917539582987994273731700536611533152296431940296335876885033224078396437046283938728455135563e-11"),
           e_float("6.2615461279559754146347624847917804997114926566701009941371892988458362318126775619010141557458688406581781214452639035158678005472952336723949565893916606806695403818782894650906021767653748663275771360203465231751252942640508389023190538478080734665459700117747160197928437462818520606137666853892145195629602254815623260514426506688858886424156989564331070721971845703644657449386449569620096222854e-7"),
           e_float("0.0008094619507185889205927428561708593429766413143515402554682982910330030692674805685941225081652638450544924755982445285343176402524870633144675152947299189597566600438101491394130376637045087682413406761958437812503551133327646981227632515599249142838489465973822598728282189406469473771052756378302089147451765228697705264215387334587805940734975443041112654604328747940232719854817143008912922935401"),
           e_float("0.058396991364106228305492942580048439427563134548010321442943935437256577097130084595223099792918475982304711053821982033135960003723202934472760973608594397381515253253199857595075642518387832752980702706305846393093838662822414215104820989631152564077768485519105272824476856908890020567789413462045178275589317798503268831430897625345567092256731940851131920779662770752522229904980278525359957378138"),
           e_float("-0.06623680704541457303586306593627849684129701135580748617414248242634064085491740650819303868866790568967757096501212992748121740043797885847411618671394426137528349673722824446504635247761775949265056962114699390029221380594265499049547541863145708962141572269570723013091245928408226752700462250366755488323993007526671771279616385482514996788196389655907714028114038297828624038466053590035371975281"),
           e_float("-0.051742445980782165597133164679054870679202886751482758358718952630596678384490042519287417680910529908209350994303107383230888313521825646925233340889154201910268481897671467242102971746900081318402023396115920283432254738411051281034740933582082436450697925753528423070814184540545173317403529873930308862303660266617593330188066135540525740874567338032678919104371594238428007625242358389472741811842"),
           e_float("0.047814891180703745830532461656862057274208245874579707537840561670653546330299090183979001030749020667562440945227216981224984607496264967548250870055790694237477613269345396389297094408322560354456452501517708923847953481077832479350174021972064449193934177404052897235242145452285129680848590121262357169617790834639652596834336273602365454510288298178672935240479509309096414644493608795585204822645"),
           e_float("-0.044453434042355917257066556349287089433882249262651145993603165630466337581040928737555778435885138347505714602852063671134812548215818156142359351721551402273142677676069125269194359592839531317241523774981453319324970673475838382320675213735215489185624490376149927722582272777542539220211115398420325077681060892814672949628523192900549240323328998557907016238041137011589226272793414582362971359609"),
           e_float("-0.028942473516345346668266271402910649502233484047050394251842010807116539402501870740095599558190755477160508251288219258150598589482979522743204807359091517470216369183494264925961486759369901677078766433189120970125868688842117948561314630928526541731285702027489644495474007519155897825963980465518428686209624654812893120820354149433029530675709230734717026447367573366088715895397503855572379121278"),
           e_float("-0.021477637951786391247265921338709018346756845047013864054991756987116212090334724711119847164682079335328164625331028131785602172443908044121945542628970599217927224950802612609069971724187457205120317085496428905103727276935286143396765121697843205521980691000263992085317691617776514225009600330803081039846385930622310553890151379089529037437886417630142027868224412128743353504175882596923962638293"),
           e_float("-0.0393628077133969303763284615836085057225649291431371293447690865353092034544848072961771138020766438610576018641249573425006062196216219744064549994592453063964016260572474498434674999893926183878966676556992206975382322205585152367523946409394390013917484445689451545668698451348759697525984432793210902277471240823509629561164828391639287321455906124780483274511325398568768358209341900953170514892"),
           e_float("-0.011993079736220783814655598636795617559294701414914255605898253591926964273019286626632638362693397215879431438912079156924396611518588205214320489880288429880696602512322855795645901169202038263970117978123230526217529153948914216052425710859467129823630745236099650833882725894646637982700528545562986671764374136828960236817818712205916807620166660436946657285460466337251247890042187413923967409157"),
           e_float("0.035136166380539326407419295348913425300690591274879551338729835255855019861306694024029484930226659272653347642106728310564350291717319942531108953772012762759511722506561816261731451365715678751365541013229907966975218874776652759420784407147219941440294566258198122721920472555548206267660984860704019102096750297509972672259020180225273648358751328057397924832629073488282944919952076721515063210841"),
           e_float("-0.036258220947162332989033247950523723435997861738175637051110771650450059781395252695679208269891353448021249133191320090565651388209068283388249120433372084484569084746417431222961883350137789699321221755350709413855162777866635789642213772832215941521698675708800346625105750394887872780189557132830839061846653327951942168147501713977519386040090005899300366203345237927502315847406836537412083114876"),
           e_float("0.027080932444142814169485656312745683527039905923665516146315562149430486350913430845399547179083188615956799001268886498583538882354450200846348708413005461514602492395599852423220450021221507876595677859232516712079833606421008305424870496378846363923700923824735524388551070608192509332239385542187304056901679010984829440486355906958199087323283924423839012615243937837416741408726062699099299281893"),
           e_float("0.007599564599265942470080784687051605774208375355437025923682243946118267765128051481163091869504655212985844596383039747836941020010859782573411497380611219646288832728299419807921984734473433017394985155709111782387461818799841826185955071171852022173578061248533378111520755635604053386588757634282789270120126574656041905711109363794780703560233375490118165332708437083629972201272083374850073608527"),
           e_float("-0.034535755748132792964409815759183667460431093478178227417665275171400569957944830012300765246923842333180583591047429273404733978582504313576285845377293023992144558630072164465037900277077910519849257282997079652730539940139558360429116708685619459395349829997676646557966111750779242517293372266037172958397556401930315508747186007545163326372595649523818698998636990068738547480876197155026419994563"),
           e_float("-0.022439543561625988599925802318712959962364225899163347359400450280014472966166509538170701408079267079793078292444525886441705767871988754895691787463961102686133098315501429536675678261981328084925713068862012699050182002300740432085274034255219930696848522831926979702736912036364547475484573134859786675043144638203822541154558026203344302650437462708456770650939594668157773010001931735633810580091"),
           e_float("-0.002957181081893057690680850435949732958155558650185378868022526089058487916934992162154331661540783293199664846382086518537200493310580423787363752004022760482629643018597489458161718625476911062828653692661569547521182163103270081062771986579447000533578447243169112989926142844320569328087832718230809791964729098195347301902445572180450125227964366202390069408470892661997446671002232382939239054635"),
           e_float("0.0032874235776096227792860003644654275513143718930408454994711995342317201760052748007116128959193893182932493186398350865908412344261198641852843863324274613643811428746155162679384263708343962940913622284079837959435643501070547086056571450082915061929261656992988378093581560751105079621152106785397301053219320544913017055337295042768600529752078293810339278008747558590561403267278491062291470080535"),
           e_float("-0.0040326227975306115545006952136706757570798556807828881090567252273567046706964099612069031339467905532332045160269818769339126598523622739198063020827370329321806369416852649215604557226571585929640140544264374189264386395983891200467636029404503947933199998445966912411019585595089077819190887207615317326887159555490751262582584588805807462435675377547012204050775801369705980150201889357962484548474"),
           e_float("-0.021589930630046324660452837635394890411264888042600673278854380229749184721903750497708984146247415635672104956907011502594947102327327954420004109342709334312494119409577309159385821125129069649694601889334197051313858645852406324789273374895609200169584243027719704313927266724553041999191488459769272831332397477515262823059637263164467961467273447277950936745108669367860294304031786077839048436495"),
           e_float("-0.031908341505425454741584779538910355690433873530398610019458766877209897628571843485654795999922114575872171148090315240067264360494607679455952794835439943103904214193430314259083085900135405399803654876810724728233439469328184472681682535659099002149475349517188196943934026567347133542777609791922777839692654962541216398348161110939353254694517808214350021292145625081195990333716066299172424587616"),
           e_float("-0.0047642075060474502788445213243678753783483666688013540645602679204664201267022721918295059443259687502127235200790798491417980791008156268298330562947496850917415972231596430289028530838810772702113410882166108439703258982815916024631508325332275675020183986562369489079281230125493621724185650721724223580506104686617324585895076941932773804245970048682010623787406407399022069017590527149325681501618"),
           e_float("0.031190215281927604255501872756258426684873707649722635377839914999393716082090045140333179022998109670831111812070702819119075597235054123639443775473561005276023758011712555769870929983432183484350796415001440428737445995842456454080065384922215074452829444141595669152245840808579427203596531028052197588055404840022626131807433600478058960256252024379744853411368866311602987391764943636640943487342"),
           e_float("-0.0081188044625253034784936800944313954313289576002956831986773623239478071039932396188498291390703691267816243137784751154390456059151875354181868729966999150135618224838848896822708324623314031504283809886030148334640750703789015003791300351242117932011309427575102108602659975748050783823835025765015762911278370080493488801742209020670883079299922659323769246246064258170332904162368000988033570631925"),
           e_float("-0.018631393206391796435643761509609436410891082222203517207784606683970612469056933835417265959187408243789156063126665270646825084929111020488218206693949806902357484413495808719799229384347221452971826274970329163408872049150016929437340083527339677100873924470554621423536002370822234014202550830242894831184097614234138400631360056603775453697277597414165065979113209701265808146310275731452477235518"),
           e_float("0.029172402961997493552223010440859945533877339203592488842855055571694475749820771489022312860735884373521651514250525008733982792834842642957909567241682237560376782017819740170233770114117843837222792876121030485611095004541471004498797972563492305337073900771069178530317205243571399289519973335549229097767566327037049467244117496860762545077550920284903690901022814000309709547666116245592068937016"),
           e_float("-0.029833763595559989760631512653523631163851567322836232135803826358173011817073325231075300693163700543460276641776086161500149061747262500352622148781943089614125385624895394764753107979433525148118596912691054365802679680789261381936932752120415186265365426016887916624157643896318785197497888294100355890547957756343060803977281453737333065819966286142908993873516659332644913865176491758462702697563"),
           e_float("0.02890618951955400103642261418760453839043870836113429124499217640127199026779722353039610117313699942917193853788764281850581698917042559704355023975384829346382792375807717377694334280994967684861841853561444220823269059010085111359655510924137383024231068127994344071305994687131714626587169128642163505996947138520306222032796808315409664923325814753521736127602598674990819441198242615525288832665"),
           e_float("-0.029214149617156683573558181728265999277650125997938515326055852132508736219470517708744661473798244528964736606792635989733071686114396904551807721497711767012557631500489225790451745340589450014228787341192023470406928597341164618047538058705841104815368085357288879028555429301012239237287027151970257633985028155697346837131845436558535474311376866553132985092512000384399482269465083313744806202951"),
           e_float("0.028449369939255441780141285622503978381626276352918315631818157619374085515443825228728345290737786950440767399367570443679818614223963439415581885414584123854278570358768815823247833358518001520385465310236200426562835815737158117213738174921121189914011398998553768282829953983918450608040890701566672621469215453892538113015844703990559370971291660682494890870722825988325853871200566002613731352205"),
           e_float("-0.020498174930593957453129136307499211465357552388380104186116961390607172970319633548927146603865118730584868702930916119506258996688959763274117926171175353902045267201120730438097471994308525663036498168233139234314018216505215726934656944789467325736089979777663325057558165039300431707639597582458491715381489700994368924649761515216241275700922603928791731714764973493093133334835351560470514652071"),
           e_float("0.00047982181932190811481404864619133925543272627583690677875435633132764101909507138126790330369264637053337455283227891568339328438817963650788336821608068373626102466296360467241323102949018391944020044902775069059823156020522873421665365728508121680361182703189838431856069215279921986707610405187601128751848947106068018513348109640588616952810191421140736581809931579351081269311545224112656797890563"),
           e_float("0.023229885817072586736899599118334565381202004347831798700856279901601030277930539123520744879990789916645197163195106055403461462018678953900072239896547556441563843374000203003791356811030264076080119680743779885315663062329886112387249184145713726307849545760271504347568703409768305901001763126425309818296627924382837071448069587882987700400862005347764458954847353966609443145761685153948028999263"),
           e_float("-0.024010558916717178271170499384899286345671336003257202742316101525865426355921053347385082787535726898485954286286004680303838989435457671597303915067296573039525904530232079938215390274746045565395350511549389648440746075843132762470909888449103974736288815499095285503725540203725847762754524252743765964207797655582685303745622375367403540723426719616798260842623176211687272511984226294996152884557"),
           e_float("-0.0091750787717380253292151646345252996202987408578024098462480707312444985480573024878748452738080031865748151375879907556414012250272034637512621775909958387990475350392669655695001501266632017928230685796439193440691539265268577136568647659800206492958021866883488078554710782990406808820885692719868924205040803198390552813943097085209498755608227998228622874129182879417797821019516529568220564431391"),
           e_float("0.026585181283926804763795273440415198865998954326431783623256757848025657526912473879845808237928350689485519100898723436946099035492296379787479244610675448145038945419723215001566392556975357569004451915316980934119939220368211307812395927905148180246244966803056316984335906540410672751728835404054662408012628797368879137127322012011717659712429992017450457751124545739412317115338894949709686036571"),
           e_float("0.011408149000831887920812154748767914785208633422055022383290729880410330873805800198280682875625855584228550251909832493866403864922616509590506867673682986039758343394376718245417170429891881180928564679720080453481637580272408198170197345864727021798141371316784933189139524477934444646764631796018817137768065854875596253401234667312878175096543539434540013947999902188212716747007106996580870690761"),
           e_float("-0.02051695348767999988216410906882738172058133660311991831323879958206644668210575318795251475901974532843328755067252496529689904247315193932577211919307192071789652993087706188549219143196713295824207324686355053915125700726707439753917069189423403296438914396780806545947414677024920968245643767015364968281027437180788368248325374549042434420683862143510743321233617579408147407311094474865249322625"),
           e_float("-0.025156328664370525643698070804054771110146006557899725831025321590325768785726126664136998648730348975652430462311999922008955788449864862110500147746229306344059459637841922381202875711154721121592575475102918312383796057197939661084484139323770937153395837040000629160372478811279947459555876420841939618799002363762529579472814586354737417286528882101691427296030786495325535397514093031126526488689"),
           e_float("-0.0059047043709809469435921683814704187385022789866105741444575606765877371691270322383187224041513859674386396336714023791680310810831529603628436882477937521647625531312932844215961041799025913687238607698455424733031686607131374707573109970237988903541629670758080540892239486664694925728598344228882660049857285971836387098882890504639167265358875050001274344259154192198585097261102537069966568791746"),
           e_float("0.014980314484360321749431550486465407319849202351670351440480247214384054243519802640725957116144652947793259472393367970252092982647268147392688136515050898616742771011660988644211041891199282895487718159698853150239310470653266148794519618951400171043075231623078101370368915398013360235390848315697736048483877227899027771617808869057356682265780523506331898525493911314581387220709388398689011135054"),
           e_float("0.025408535785463487534297595859457517816589697520718395451866229764931513137360321610376651408806595096650046482566221360966089579385202806064220765819029025979864998484669041098925199368125621551177600847541876764404592706651292341341854611613758909579767238512568439647558538054981359104418493938329803149009269929076773156508794395990452183256386900972560318827205904303296484964799504220176864978179"),
           e_float("0.025858359015727026436144382019251189276520007818387939236842114480038740540132644204258826860766309267098116867660997139169503433574542582361981238666859074880734055210520113170656793162839055174069416723200738343208251067396648078339628443155559318095221026990736834879737843819112548541375618392235170038649272785762315768854167553780871757092173112079026293194335569145436664278054603916645517252974"),
           e_float("0.021441085419590186393275310812542697852992076806272256129296126053293949733367927475025323401231164222484490840515256117716534669212008771270696519409577567824674902257108859350997320901697684984262365916276363075297549147559141359477338351995387141595471385909689607546261830226344416300099149462458991027284140516013628038846055967048022184142183399008673819601411211136812775114556528513636150352832"),
           e_float("0.016495872839328686837903439950925919236986329459368563554740234762776446912660019326921103633924869271513619202463033171530385798730930764651807890829697092535970665169600834518798420234797899352815790350630193490512809539725784292412664059702500456315674361753515321444606368382560086024360278630947136275929071155045231523194011016571379155632384252542439024298048937564115951551676355820500730369694"),
           e_float("0.013313784641938850120451176898261706377206552323119580825348700299863180300889109283235963993244001153165769112904277642634895942051972229177297459991419099720752425642652888861601802287710766200504634162750071348151622033622595959438474923242703540505336864458532974927764153731798667656451660249199757585569435798194785561502910266714831659867184810346422359800277940893333886358179952573708238769633"),
           e_float("0.012700693538383581378152731010235660557196158594603242974032005974425156386070853793447018434975136547953119128320130322962200465660426339050231822698589399375485277069366165001155765397320671426923488087074216448681305382147989592243207955223173823193007290573535932679973824688374894583919936008017780445350432088906524609805094071875868541761028146098318782142194500876629373121212638999442743104354"),
           e_float("0.014655926087481617764157490889528250608706769435042067428029110157369426818108250911586529315461406537364918198908986506693215591039832247079879423240948775207493440497185235862574478819394728796178489649305064709662605757564669689418900965088915538475599852751753021012941375326070021820386849566011830393827456975169283361007985883832459897016058475301998715371738981088678288504789336726452436970341"),
           e_float("0.018576070561506603491670615310954114677973983798189742444036035880723034041189425104602780197065608922273459382253160472516658116228122680267400115327055429181243983301368201464371888659998877789500625237072051405900431395654080266899677260388830785439200055931495178271926708839232459256828788118895394977398766153056571319696809041087806549452827699841694386734757066411599183066253362226796870657266"),
           e_float("0.023012193107179039226188334080068874511609981925370681969827042802849350006546649178550209571313309327891168324930650699252074812387487579032942360776146755697103210591908501869252897624529549804246115956862195473316239864261202262524443712026930625171238327337041121683413608479352076410666049081652015044668760524974647209629391234360567931078465335157644111860622872734746287052908152585508119636036"),
           e_float("0.02534860524858028386843203426490630539592580371301710865862996418364600455507659020162532307861306361751768668310301613694131509633415490364852692320435129697476406864988331309172334666273921771031439967012133755853349225796821991810148407998971139837737945456561231154463754289271665272764375109473604272142764124908481888646238986738812779249422726367723764898734578650969835568255035716346672197039"),
           e_float("0.022112766915017028332990484710453967928408704563633298766069939089534408786391892211127433053708596933342070913842368310359890522187947961682143386124947625864517448606597486401934545823949853431807249815255139603484950841663536225246537747733350185019852862088098874007460743757025033746796000733347820752980950315837837138091199642972078720688717997201696477232998028953667840980156688512780031315666"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00452_bessel_jn(const bool b_write_output)
    {
      return TestCase_case_00452_bessel_jn().execute(b_write_output);
    }
  }
}
