
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00021_bernoulli : public TestCaseReal
    {
    public:
      TestCase_case_00021_bernoulli() { }
      virtual ~TestCase_case_00021_bernoulli() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00021_bernoulli");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(UINT32 k = static_cast<UINT32>(0u); k < static_cast<UINT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::bernoulli(10u * k);
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("1."),
           e_float("0.075757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575758"),
           e_float("-529.12424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242424242"),
           e_float("6.015808739006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714006423683843038681748359167714e8"),
           e_float("-1.9296579341940068148632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486326681448632668144863266814486e16"),
           e_float("7.5008667460769643668557200757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575758e24"),
           e_float("-2.1399949257225333665810744765191097392674151161723874574218307692659887265915822235229956012610692674151161723874574218307692659887265915822235229956012610692674151161723874574218307692659887265915822235229956012610692674151161723874574218307692659887265915822235229956012610692674151161723874574218307692659887265915822235229956012610692674151161723874574218307692659887265915822235229956012610692674e34"),
           e_float("3.2125082102718032518204792304264985243521941106167306871532223644899701237729406743491250533504054630815194195475885616730687153222364489970123772940674349125053350405463081519419547588561673068715322236448997012377294067434912505335040546308151941954758856167306871532223644899701237729406743491250533504054630815194195475885616730687153222364489970123772940674349125053350405463081519419547588561673e44"),
           e_float("-2.0015583233248370274925329198813298768724220132825915915207456197556627972696839267857919220903438980913873309856093213338550497804443285074561975566279726968392678579192209034389809138733098560932133385504978044432850745619755662797269683926785791922090343898091387330985609321333855049780444328507456197556627972696839267857919220903438980913873309856093213338550497804443285074561975566279726968393e55"),
           e_float("4.3328896986641192419616613059379206218451368511809109144986557880328480107894369354471222043378240322213157527249208064148641398216949999632512365958885483503480107894369354471222043378240322213157527249208064148641398216949999632512365958885483503480107894369354471222043378240322213157527249208064148641398216949999632512365958885483503480107894369354471222043378240322213157527249208064148641398217e66"),
           e_float("-2.8382249570693706959264156336481764738284680928012882128228531714464865111070281341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143414341434143e78"),
           e_float("5.0368859950492377419289421915180154812442374264903214141525651322528310976742989327917853870322793148880105401844532279314888010540184453227931488801054018445322793148880105401844532279314888010540184453227931488801054018445322793148880105401844532279314888010540184453227931488801054018445322793148880105401844532279314888010540184453227931488801054018445322793148880105401844532279314888010540184453e90"),
           e_float("-2.2122776912707834942288323456712932445573185054987780150566552693027736635002572659102528031391154956836417064395064162898964462210131684277509818261259620199915049717064395064162898964462210131684277509818261259620199915049717064395064162898964462210131684277509818261259620199915049717064395064162898964462210131684277509818261259620199915049717064395064162898964462210131684277509818261259620199915e103"),
           e_float("2.2301817894241625209869298198838728143738272150875878542490550781038036345171224596289317738768145763813725828620893106812398797131621559102475133009484154522322461253758963682627804765209345362017117742308582003238491788110108720795743696507055285681239879713162155910247513300948415452232246125375896368262780476520934536201711774230858200323849178811010872079574369650705528568123987971316215591025e116"),
           e_float("-4.8412600798208880508789196709963412761130549942324620385115856258002631506521525552178309537216871114312353272795725262246673092291728096899053674187234167807261542084271564601822008330021928856314480403844172663988108378589194519257656703018529147718074381503230459034247280968990536741872341678072615420842715646018220083300219288563144804038441726639881083785891945192576567030185291477180743815032e129"),
           e_float("2.1426101250665291550871323135148272096660152602965095141559634893447829324846057506121300660480116095571727001472643102109060678384924129331338489401985182801247744635909557934766223593397274234702134723497680130878165486155231936048000991389156311181519470346644027481455381476744433377631412239401985182801247744635909557934766223593397274234702134723497680130878165486155231936048000991389156311182e143"),
           e_float("-1.8437723552033869727688202653628785487541402926335260270034458408149393245849484726102903484283419354319667413610910191555877583414761557944288440165302368315207456197556627972696839267857919220903438980913873309856093213338550497804443285074561975566279726968392678579192209034389809138733098560932133385504978044432850745619755662797269683926785791922090343898091387330985609321333855049780444328507e157"),
           e_float("2.9596092064642050062875269581585187042637929901664913214415150864749542291619230040558813869144340995838686419669420754538171435973878011027730113620408963320876130308468800757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757575757576e171"),
           e_float("-8.5432893578833707718598254629908277459327010789872701906044242968524697462056996355108348662792070045654894333747091988976565454621694124070630607217777404605240645634756508130707910492447785761901457236132791006283832605357761862710465302840166156384191677554938953378386336173402101001176464463558146941381740399877613095394204207795900066829119815603748233924783777785761901457236132791006283832605e185"),
           e_float("4.2928413791402981089416829654107466904552098101211773632787098118229333448449227421334515845766966132843879793929098617107109337670402931788376787449343197582408610819905444019466159172774476992178165107052197366333491987942249722354434396319213073139774710455338727590036490560050769474853244486752340155481516738061240679041726162145010312549579565286371569094082183087418689512930350626685705219737e200"),
           e_float("-3.6470772645191354362138308865549944904868234686191058737682730903621850206107709861390953897990603874968087981794273041284029953762108443710719800551618065493095862101213464712665237801062630150840451297095408703496715853365824387316780458533658243873167804585336582438731678045853365824387316780458533658243873167804585336582438731678045853365824387316780458533658243873167804585336582438731678045853e215"),
           e_float("5.1031725772629575927919818510649676853975996289216196314852298959297983492515877272044896127090496935068960878322016954404553092124521002403101596993511088954708582718988624591824851689483118747039916204260128197938441124072575224285856271089567097969438859046816072451895331919456500765368466907695917605093383785403429390589320549115083557385141392050268324807221863773565947156871755386713543514609e230"),
           e_float("-1.1484933873465183993849859920680559254835379696471413978842101139495708268220839973893499744525497367883712946129053507938903702921608803130701271106954606862596755565224957799670899084263152138601385537581171191532923110885047640186709253553054421677206851119894598155467720685111989459815546772068511198945981554677206851119894598155467720685111989459815546772068511198945981554677206851119894598155e246"),
           e_float("4.0685806076433973442401212412493731863368431075452165580263344845463077529803699331020735696818015149874671107964869898086324006447419617409859552136116222306460721850603786948409495282097795104907812282479879036766930393499658467956084050515421086551206574248430544809800128949065119277885235332043842682140554480980012894906511927788523533204384268214055448098001289490651192778852353320438426821406e261"),
           e_float("-2.2244891682179834667660234886504851082483512780169019320578856338459117898256476467190731955204204326255512695754366497661464998007267332409437967916800349276667581421295454644191440291140188263808762356322626097467497021978113685682538449175520779512092614395530247138574463722480037302069288600697437557947159015122705739902529645851100485919655010465071285672852064806073946235151667235528204041662e277"),
           e_float("1.8435261467838939412664620159770223239649247700003442945697589715176258684233534837776558440474285697821832922003969788359056020603056358044856819735659151510513686831683786752266530942856333382862289075957996933971198209110928564393961812953609407215690862253521742864077383938476752525488157107177351201255583725703247615598213207774960763008571773512012555837257032476155982132077749607630085717735e293"),
           e_float("-2.2776406496019595938750589835069380370187263493260088971518639411379886874558813122651399909378858142427133813872435833793287580177928866469737668914454242402643059579159527351851709964178612790612618203228833871204461679307297524526992180322187672666247034148413862100977816584301412134216109978704555314092411507439365569856712014280788585844037377956433119907122499661747825365857916628476905014425e309"),
           e_float("4.1312131760738423597325116394896694042661684263765701768146935396335825435641026127901400289712928442719568182762644234376971088041629058399848368832652903563479387602324008882282653253951617180829818312070901495294807172135772304662117499178427339936394830424539396262030330964230432412400191944858320642545298205945811918403844320752536566443432167437455028531278852355917116377963770818004963062882e325"),
           e_float("-1.0845732840876861105181252911860796163202480099707850406069703649224447241646965545159634865039437196476738931820619994064182929237151149928627493816443185871256316241654682917407113046352087611365553794062286838871389856813836925854238198770341945501884286221253891604346448050358391421952792218585519576146920034896323918904966987954590492472007586526690164075264720710655344705571798956478722156947e342"),
           e_float("4.0672563035422122586988360036820160406288243112994378892537751818435167988020728155020423377297803084684648105487329512603738588653615135137617100343594180909364785949177594131739074246615189089734835514593074140931529528938273070688979490644710943201762606828504921272301542980868403127177932886534172744902520846525078846739935933954219555217135811346394379058808423215202876219825372367745249101181e358"),
           e_float("-2.1521499732799868297198173767560881985734565727838067018493439258467969958243434747665570859768285311824175777998234967126951372030306532613711572150699858846633724693137811577325226590243532627817835819047273097459806434605278294634103040263306422135204224628525102013793319004047349439722630091062338904573288757384392938574084338785252161198731111842810037550618267765490454091976578170251662927941e375"),
           e_float("1.5885249124412214728146921210698216955471376348874976688357755510140681803889829064391046223959740449379408979241148702710298404886061574012910650658195542354096006813545952155105143531177491373596648856257775623696369142942192372606436021401396736455236196035297346478950727173168718612287218528399428270386146036586283540070566795315625546292572077805479396131973767970756569054626334149269107254214e392"),
           e_float("-1.6181135520838065925279895316369550844204147199850022952162114084094459767900117208018085961002536788653678264412815278812462327380799600098265285761556936513447252326685190315938108987993794012470661259182391633780082699854068610664051619170067459765030668158650369726513573761139991102084775043031685475470774108746642145192553898182868256539614687773498231202005627808385194938353747606525127522939e409"),
           e_float("2.2519105913367168091539581467257757187072044017748030856388342851119000703417191482325787523804907166264078366840381497274845243587281583670035117260407804065514157769785137764679380628969903945517306916597549888866611635464351809129010827389647021610503114386722924241424052134815639613818053861507434932638458772145817100846170481520095562615896588240789688283687381540299554706952575557102016017168e426"),
           e_float("-4.2414908901301373390524149606841515151656262101324599707845433950887037160792473294245020684472987301078852415441064259995060692395193837269332264117831466034746930708793114798340883560823354537420533379613020110031266826405817957900896729078960790152832022022737402063927057194391058078222151272011258103440804157408725835001551710119444610367820253874305341235754917085862052855237516925645083292317e443"),
           e_float("1.071643382649675572086865465873916611536594860884232094371266192006684962684692151386814692953031930848054465974098142426112886654557234172825489848481554561468954762306606219007046664508710492481393477753458624821123636998138258741999817057439020363295111386848649530967020818351552719935716027877767950259267068228049786302295622049964869525763264076409231481869062849905225388267106313180890272988e461"),
           e_float("-3.601686379213993374332690210094863486472132189343015017421868286898192361150735738563964085330880865454166855485955208939877044866544668051875199958279503675696471026214854000232857390744808580879935764950303448621426845318955206874010627044560480299831970651597232817244103455559276193502081027655825152685853446233562332234390478609141018904827652845992775077144019431452158153557761802997156607754e478"),
           e_float("1.5975222439685865482275146399597276966942810312936088471957256372144784951715182276803080383257420971275961968036762613785274544248480495290714918935025597209625460374560529998094436316065734447329350550685504379095398672286004194792472097033715540170059284927809617511881079328418018279150982739443739051330416375923687199185298837492790105280142695213917240187681467072037079491956870919948803660047e496"),
           e_float("-9.2815515952586152059274433672899481503446504234776778309881177450526281216807252684635602261576688279639881005299357505986143058813152778527327172199066212796922256236405043420138480782260913685870894350673891428352437091170603349483822784459884457176435843571132474469938985739024273168070542488744169983776769800155014749970041330923435336811031380237575585655047380053219621601721993583843162751864e513"),
           e_float("7.0136674428072884524417779814250556139822164032150252720389451158659501067543851836381368510499567915669238248898088315970807718987191841464942435521549422496748940696074607389277538938531933151791091822399180035839200564502138122265600638250823586093664889977138703822312811779672548271490002591251742293319065928781989271180632117540106892699406317217244484953226050324167352123918880627916344919023e531"),
           e_float("-6.8469448558064533606162585823108835976782300971806257424147811503113571978345899503289905736818864420989394962086906601394567974900458878600657308679081450376386606494905531641419562386834668359517963162627520026827084022006094525108963495747310580188137779648226732579688577039462338550646311248456026576778469708801288158593525274157301225996009017937543573262495196730516980749990770247731291131479e549"),
           e_float("8.5802072350326178560592506430950197609675459283173034170736379302261878916315974643588282084631626259603439498644902043885869696606563580459732394732019123511701627490739294984890042194164291298058110694980477058006865339949849315804753111314790672988546736681696455555061699896246082026955341047929597563364263716633991277862123256163346060885510319047612295210496728141447136895288403303253800785186e567"),
           e_float("-1.3718467600528878889260554172973421066138312611641999631890044958667569017248523160040132010778228051590516236810101519136609303220389224294664096970140411350788082358862558706675027075883000790952766661472935307556140616411727720268397027958699098705430326237943870103269131670481149061643859774245963133378558190027576483308435757205997441721008452822239522252114653792708854850833230658949706193413e586"),
           e_float("2.7822977852787564261775422708549840914058190155714314219074647345319681738861270695351477948624681848820066815997935445418372051031488640758505301413315148218266683445151042459517991588017217858437842523581004585900693289152538733495813351722522361022020539323205567644271785754294399676716792424678984674852214410496209160057981610584253784302367926432413027126577803147452892087605468952118927260554e604"),
           e_float("-7.1185585218738003046127811210440773572778522851224935749975370916659125302360166484091747200440389864076089368968800523554415463016657779440883823555593513265783381322652450864999224455425508633798292058616165621410520089854417113044622369822513434112141079327896534109703955532879109549433035488936177459813381729988117132580636289693606707276407242581154719141250407800269306404410461836456602261332e622"),
           e_float("2.2854945652875306814657577985170335428884547909609892069299409063163637252901643617679247021013992990200575156207998673008127778624068113122016145368894209701415009816890214075574219557238977671957915727861136351708597941803276252945607386235584918449634297327295405000447887684698136928824412191148925896913174659002659806559377374678250567928654835046141383907814512513612995321358792395820401586004e641"),
           e_float("-9.1617613632706489205376134357718828980510024451796117430981396746500492967874850883186586531354265024472844389033876232776920208408352271851909161034227542653986014864589832837863367808571424738344916515251057973172021342680340052609149061654774512869784077892179741921245541828742333165183960498634557258288775014851967196532071528457996888548040301785487688556566566908602202311631763317927499374162e659"),
           e_float("4.5634623131905213632351824201787844595800642116103694954734204328091843095254702443776676220620584171541513857951181769913524378490548145245906960865299429633021751378827240444314519755147051059896491729130044734354996882754823215964757347243984122739126304822052612785701473592257878107388872301644183743247234311613713772064596208607597206123738276506861508142751135935480616399958213447632911941592e678"),
           e_float("-2.8113943110814931667934141570619501324032589175175732994213150200375524476825812863034932942103951872049992371273075555982897516311195860710946237410922106777275875415970220332742861008196196867903099942357389537858722698749939037809552732399342576987782946000484048258327366623220548036747819801768318304422777578710486671956447162387133503578798009109158574994279860498332394862743294295643333233361e697"),
           e_float("2.1327473713601905075957484445369110787880193539718207761580439146366271443331352356231618466382935889460896356291753395124002044153842335386802931275221754703957734405727340990379987938958124502044930601048600481699924611266210105196554814350472619113903644877965621147698531484031213852298695891588366162718380031469681330995164948142686081538273746138051678915986808842227578316461232153452562687162e716"),
           e_float("-1.9838295352127113782914693566660013658726826032571390874967159257545672863566388611787421078525108592291530337029092400696473622892424856569225941011347853031330965565241865631367095715329644498785189089774812431217939917109217088908065600473155379204598591294227027120692725766683900900349671358071820289116601173816247567076328078381349393263946718375394568412317419417687153563974804965050546375342e735"),
           e_float("2.2534460118343527332799463068359407298584818345085015529951596351949384592100355435663580001598401952338902584173341759899871946100647483033733680748737117793579681214583983952611411952396480324565867861331108727400135951055161893717377099296327728626303652515618466297247400330440809905907322025804522863583805446119417782039090337734883889602484023972267663437681354792633158109238521872496443961361e754"),
           e_float("-3.1136353860232201278341029803852753795332603697573910142394141559799266515137845748586926336609510305786696558265560566406575444448748649290619007503982263335973110899490148796721242457490145699540283937817631325216817279810045880211589565314318391272684652339983210731230540392648233864511603921118111291398416240313410212757074176743034602669972623589469347724020083241386113474569988458823872260982e773"),
           e_float("5.21352427258719957498011735101632251842788542991838718320837121638451862088576682943530492502327470052093449990717451158999084250303115725221816680074753676105157215206881311149835595634649665956061234949748091313501895638926911152764549022292592011796757961002447216586109322395566641275784917820523245179188023392645664490143229867905527406059367609715404360213447555195611216448321322911209279834e792"),
           e_float("-1.0540591770954886398360630730705368256752592812691969635102380046780202591310191799283361340420951117594448266219267293531835535494164548078804545928915639671857996266426365628951128613445949203054419452312442794641836045708606188235902532390860212474158158938033120472530999432887702244074382992856119004823166982057320173278246173866715847357632730068567749017234889584524118332538142312582400216168e812"),
           e_float("2.5642103857192240001565482409341089744469639865497255717514438937453839377353131036440633061249625364727643375796566985536188279678219769976060096592074416003032743809654502400082504950790178253308588625329188024728325149059515675214831072662515878244659810543723666079617600834834918224416378805057280085904888658776325276293728448161569283210365672479093936975539791128757000689202424941735697165943e831"),
           e_float("-7.4806192000385053684684838922468064888786393127199204150298619736213164661873573042478642812267049667761726658341663963378269520792681483843632369534434167482005523788601926377674019595527497671581909930301124797838336213459576454843120708385867683546050498115917677865740922019303130854955840516623343174310588732912211499667247837210859399278993345347749746126390775397129758997682615034459592173144e850"),
           e_float("2.6086086819393223935810691882716261225185941046751731194997750067036147135908047128931252394837476780484850064310121668856246084039789502765468228198130132091033852988353694224684114844505603757195286115543468835791319250883315601849681064272443255026036333201304339301542519136186509865997551561992030486713488703792411803725623394951246637494748281709638258429388635051485673485709361498110769247376e870"),
           e_float("-1.0839504753531719867482331579093973701925561452676204592714015798791364128542724072151939261965212470080225699817236991923477893137480477100639907273139882367022386186781883166397713746506135867465898928787990671924868123425154372054861147084978216158718612316842573765863185804719431029449234814023818341825864434391425531181006815993954665663015474115962373162386592900132609580696522597288153426783e890"),
           e_float("5.3509080897109642446713342247080578126332479242818080426639644776797510805595107645155989131519020746017215678455294864412628302641992284284393759699005400019183384881100753199874499731869149428894367075640455925506629841328566433038207667633924313912561893681656947560895323386676957335504160859930494386202963175338826820851436227255746517390905424909003047534830106695742286334275477141079935752724e909"),
           e_float("-3.1289307189936583563984827053173818083014991611933945180875917739917074527737578994718922030096282129076387842049875250631717676102262223091853727277142346679857954552454926006631815331910736310098144838480436962901567910528692729050169553294346300333761489275759191208394762229191905498384780450323608093272495312645957700325115874835463379045839252442219399148504005951697822006078429092381445562747e929"),
           e_float("2.1611746976997932657151820917646766664569511756028011908405837091008934823743188264971995971072365882783659291268615337502234669324129458029875480801956075443463770692310291895153381896083155956790870713679080180328372807403661618321658162031212242455510680438104570355803398076615731931870012874152291214661215994356186342586733190099956435568742947674048804036018533703059623174846735252077519054129e949"),
           e_float("-1.7584275296346096133993277445952574971876834832637145603183420197398496322329977493287448647245317777096015818897939230667466854120707511420613613846027886827098837331800958054495818205438488408653112989780459553113134517071104889487660339437976743186719992006808644498595853440684910089905960772543702251837714492934368037210532892914166502558178814214811073967134506726806370068102366361945988372897e969"),
           e_float("1.6809436001478583221487678069875274121122099400953558480328965080276354041050891212149833472657684529305068878122682008000133623019251881068299156520850241895972814285180873562409716402937006077300388853476808970760559967850499710063388208279147849221856667268409858733720252291837748396064639931328530681100261427856193317033991606312703209770399744467218773452190316272023933525977789718789598267705e989"),
           e_float("-1.8830664597658071289448973779146696003741797915458891307113056022641466520308169098659666390055426212784522187063860034622937408259710709457275651856820037067124007956343989407593132330504854269103350541540375350206900038666924422499427514110292354972716812214033975990378316814463758459373128232239962986611189515022112487753484174766628579466757618854037248077559115264317285021819358884997443832276e1009"),
           e_float("2.465962312241418731528973526597433097255547444279149962309704919973944936220300961921670282968225375727616522458015003481236911744534207184666483420130170130237084309080846185587945026482262014223688946253085971167297236761076331817427124715765956836356762080602521216336778096603410528109183343759063898957558979207378157609581082260168048782614973730751664798115018337321880144130069995266591199438e1029"),
           e_float("-3.7659367175924829287969206752829300340178733243582817024414124501030473280162895824637436675685127438854384856164039516173298911657490322933965643025035449318216687171868159909199484190960855903814829520311559935691864064001888122517348475312234349633865655292732889094059630445193989187690504429649531328280051562641709403120176416405267990169406513317474257076726968244988282777148869590635229511879e1049"),
           e_float("6.691361332576333738130720616841706994101031015273191043639467001232985990275833174388418677492492835869543047502458560575641749852752939596807064381078998326450785175940314600802932622704038775230361655847574297269238671733777006247048974901509195177067545204800132240426439401790528124812146628711696919108600939369987430337863124048780938147842784553153296449771866217759886226532727963051117008592e1069"),
           e_float("-1.3801620167216602413080466926464527324457875723894365447147582103371295115478190492232974835070606847657559497695034376984672637749599442605065144271967816867764709370477285710893303281655886087721328548761205128772028832951457730156499397518579882453605112484702433565703915976233067347650984423906980546329956883387346900221019507533969852030680246982394313468130504844919927122305149214325342956068e1090"),
           e_float("3.2973713078486431615322274599013867258014183773756289890072116807922795821376499460951022298551146412475535459670808151748921607259232413567274022905733886865203041449331265539507136745154406144658654769226172318345501259465537055633862040322253772018849808217205797748967784857667303503750057200907372874263696832146295540439652886146690163591279866353775294884244219909396735861950103405118284629644e1110"),
           e_float("-9.1054932884599086206367127487273956379646149557830220110552894216435686563534922411733906628494815551325376383474289407246040587026379065372287526079130040961003807747485644644050503531810476284023160091290144665700378743655364442544894003582310792497306541453658445110715589674875316327106097139997168675156942840111599194566912690646600176659537420480863240511694210236996874940973711103979316066666e1130"),
           e_float("2.9002736888099876941288576550367832619913851072276556671118767858495700023335972925071763630978222844656597562999497670685325693047147199120677644785803662746791521519771194119362131029931261030118787464474756683978897277064233894869769569835489822386720025197267922237194089011699018515614296164482295887310006909982910482547187068850268866712071103558037626381886326293846250664447923744430552516004e1151"),
           e_float("-1.0634123163034402165397972153541411585887430659714313256460791923718197167432638517250046579815640603431122093854207968093201940671637005734419321251944874186342706692908477286317907622798534576392706374169638162753208221409629932152280657338462677118803747524392343929810656176538477730603370483720435132098938208222484733751433849806315968898902974529136110878907519223028790955460902207753861333427e1172"),
           e_float("4.4796402073124770929385415467769159565802603864215063361318225209468479997888304646033580760242137679852665318845323179700545509700404556379971006601698714029953710066055825966430652395517818241011241313427273248643068096501275748058448705147987711902989877774713863324248798014235157135021984339618069205125540217029475218614029265107603177954756825836006143015740457200234690090797731327239452608299e1192"),
           e_float("-2.1639045707247504595923521734714468317516324768614412378942780879378806960260193700859545569787575084543511787485794961965437385883425460788691619113156685116462135413531480224839383800995697091994530035391924805237355711709180356628046372890229990801794494320820889094258505095891030880381899723768850007570383852665080879211688806551016223880298025075653458457175719832310497991118437121828326075906e1213"),
           e_float("1.1964199997474119091441443154996544707152232288874118527999144928883054674610898347124937826860854531790529710010499091864734130090653833087992824338564625863030130358356076022936220198359914735807261453736377016699975358960852138091586999204127314064237264486685930274263035172584758659545944652760444352898886238348023455996233602126800794175731959451945119848455110571122892525392933821396860485592e1234"),
           e_float("-7.5578502173763236219847843087744769177530035119334987145985081706666940070292135229748473309960065345014016993311149534400988583033517271681569177662073474956320395073937651501790380242982179792961060802724638095279154277038324555708072903968012112317004802886844064856292851616432371608948263975697920802709872366254622537405060819633985387533556447528159213503729844294061395955275403290793333732084e1254"),
           e_float("5.4452895186363069929426047755859777794176522823516449920221551206579514000686310015076143663311795238464199411272091257124737647571796250673831500992631872609693476208140966167638603379427829008066805307965908287142204861982379338951959336832965076474995122482407073572128556887361651026846118910245631076515593718620385501978162132001308897449940155020833300830625394379518939380034109125929656227564e1275"),
           e_float("-4.4669441740250266251370327393176508625934888399583096020720567788914875312715192869776170231984739971950468187279127675014588190765977714905547495289774762403351276250854602300221599083997294008846340514786448490548119737453964595049382106920607473115936264135826924896932817523061010490066010209637824040169054755920713749780098295463947694047611247310267830030118282466864137328048455738151188490485e1296"),
           e_float("4.1652847866326541685630968506101853782332066076040386113206995372655731591900798966175273291284137622011708392039277456267413644635055538360415107083581120613488245189654674152965297359776566614159241127098467976394996733700240128611314025228910195607443750496657000806345394711734926853137564595080437236817743968466284940048411707832800110821729884462146225183730541391656304558290864431467538732287e1317"),
           e_float("-4.4077763139644032336768101788510051637249465844768523072661320016220362689105275169698481474870241148665822645816847485811515205080205164569864064529606780097687736776735284103376331643781711055207581033364289165628924593934786693935978074046169107360986209199945757431294466849447948686474148284234697085600546016753115567187709655336334411861943447829158151396897553968901907825526380911169850655687e1338"),
           e_float("5.2850451251258323412638972334051968080960509425180025566956629975953065506908936699832543092143801144553739733584284270783936603251883136070085856744865350574048084025091297955498989825238434358012009527922985371628604508448001308693528927411059866127075491429891123374912360442107526772654225011257297462395641065124376161139625292518471838653622885222628785179055752281211536829495153678366628585508e1359"),
           e_float("-7.169068531615459070909644981451297906219846343751504295796066338726990626027651213615369026028001570454884524331202087418261362122625085707522420096532727596312866491691638099619263204052464238836986480263184005092885496040412181139702094700715053532668007509668041537142378462443372075561489988690437925448094816070710185164781663230801713972346681522536299772687144610377653663982529230181842233536e1380"),
           e_float("1.0985214338602996334814496853649141154684149273662882417441850971303887141105426784585246984880717552087838613287031369453689834544315818357398510737481127206297517421736017166103006880895892260725193895959628173257330940818732529277781281807495460720184260215205490016563173339989395116878374555519920055226395969466300758938890235878651646912634559617599673051613251062188070099443585250471040045443e1402"),
           e_float("-1.8986666848764927952339071744937575722902614204616059355687312900780793630126511004088477476690679723609322863685036790246291081213924562720005640422216971779052924343058141836033114691634030514510409266844163555874518782998947141533322894630251346243045078765113597298650544577425477228652444686154998941554550997421287885526393486599535747817140662763613782827751693749416817070639154273309803959201e1423"),
           e_float("3.6962480258171446908405391321035388341077143565408362766119774579623421006673549143973354799886790319636626650447277179679383891511883723784029434874584963805873407371658440855000451898314703084092431496598462234288068290232247074911557817132769720912626312541589955582078233428504043027678862141574603562018299478964383102779011065760059516682728935457322309948848207643322638838844163976606381346287e1444"),
           e_float("-8.0935319030118801186992182693695701788119715943316128736349635811189616033792473221384685235229036702986037377206250189872639721822029500286498221572269172729839366535289724977916109249528597532657259815820494733442723187787940802737105413905733498933652315514478286239029236200191440565787898230638228870803379788296377248973424023484065418021360206216817461669745042156788497861013253995243123285849e1465"),
           e_float("1.9906101127247151268950087930142145057598175795335978934795954416177045453057451488017398906804563604097384073117644381079946911551950680958078637922457896337486450160487057032206853550463748270437421549695997164479532663966172148469635393256207969535130061519154103333671875126793280852597720984189878373542691920521227384255757569352411344409651974885954843011230717094637240986314587748971711600681e1487"),
           e_float("-5.4919383630676133213643352494953941644297738291570186195191493547241387902520542008500658514286266161715220313016323093808618400185878714093827629452428744716836257888750808732043806534009893876326349091953588502400324487510258202476622975228714973871591881822500880471243589012061199162182936754558311564273053333076700754624503357897934607479022497358345812231389978356575917437679357042034365884804e1508"),
           e_float("1.697421812794203793865032206191322699260580877520987079195771191709038800940147378669568126235748089878197547941843689280474061382674986005815177295917008230197871160223308295970046862575755341809680649370783030155245397237442996426724269631523691154296083549010350251040842527901823559251770737145788732893121856994711136193205057394785554087746810393815238913209011442958145238995499373590360750258e1530"),
           e_float("-5.8698182903848113531824232865430865307284559678156716370956329621614599326521937762273474736369519536921976917811247229601248470210462839274127633101915922196011145963677389237692917770921335868285519045504274752459419853613072670442501778216994593574605805524812032057346929843813865180110933383545675847567109658598413296196124754389561254302373634308014833626766681716618507480055524503424061884183e1551"),
           e_float("2.2682382557514213125598061229809329527056431589030675493974652186362823864112647955244614835930775839037053911734887503401556221574774484049126480326824602322889410011305133212783574032996463771884705966943468821589724045892889445086231527592091151445142464796732816956730699485710642843787741673723441817415192561231725040666076238224911953324493763317526175372918662323848798491690702599350430999265e1573"),
           e_float("-9.7825505162048031953984286112218994693448508370347634136769662774789754155999695192946998091735111881538184428853321333858728132737633874695918673496291816005612246025688267078484762883639399888695039109648996557471593951629943915703744688740915633562762319303545955595088499984816431575367651356722794577481100770914650471682176661291351518328181188769791178215542018144365703886114583456044204463415e1594"),
           e_float("4.7032355675438881520496284113545425091562017841467781148925786517900588377268150700246259431992304118688676025578951611979069188001346879824505128680016354388299087762887277478740377322774056944815371944277855272769369087944195847280819990296740471011170409615988774030524320638888787555369005312764790792997132709779004604734594357058850745006582941904123699319423171916898357472960391468860291280348e1616"),
           e_float("-2.5177667619876795777067796898806577773427662136923726854693318625501341057551709345780604707011453528268930540940042128561136288973086815945240180365279461369518788375371721857556263782294826279748668153498486705312622833213174567386799461387858577704011391612946960164810837163391887279347427002010025555029468062914940348545177781617089433796801879501779689032058181807531719714516615837126171264423e1638"),
           e_float("1.499036144473064593308260681782048262300672522476183403023097435402319191460916196077737591701317369079053994984060167158102438239381295972273818468893930590617749304455039285284768080619535820008759589815609164579714630691087894951352216541122022564292480382960492128277237628872943242683691747216104710100020946462752878630130003491660064655289328517853200418316098213992030653406582452825880631906e1660"),
           e_float("-9.9151825072869898180331466239955071081341254114633121177671182437090773585552809597031837356076617744112441621771083602340992098305103448691734201561186331336057433666646592204872092806165370864602951678757586197103821266085102127041249320425311904739853502923248628006903219797432909556310700117917367334734459813406452823072643961789192994179947831903391267221745330289050888969050854843939209089938e1681"),
           e_float("7.2778917591427252941729262583644559413645247874537434352476160764414594836246120615027404697484993691974903660309113493930678824337506522361671491144888198803648804316502159054664555093370708884911194073308859318639294054992499949310154609533113480585998555710196339550084534915308937046330509531127454006403283881901622157836185176072028044297015441225826239286391560679588933738971078506982735730487e1703"),
           e_float("-5.9218965990284987157744584931170793401547002191016590006016543316177351745141157658457445491180438692002374420752667896786007841205834198762552010697654851687730933420823122885782179819699575893598063984287673532758185926070449127925395617524477580185842159834345773332339683784951856606936296387280557747896402386146926947935240829977902591111523021033784915138979666976024238014844016233537531008606e1725"),
           e_float("5.335928195512405709733771642389502809087236433810937269494669506697449447861725441499387684318372308757531137462854190016067740286769650854313062988105349115318824334799248168593432440564092198662831296155845320544714023813410990981304006847082075065281769068059801703654699231916585940179098199398002098403664094395136476876926937245598606760475772161517183839104028107855704400472606862796004879052e1747"),
           e_float("-5.3187044694155220364829137437670855452093660052166637474739092287348819200049898438096886914613452320729737901774094090851536078192273446134466286029503977071553021512748444624238225391802292184284892136641078576204473922933138989759768559610802051088789692615636179352160034447083550583732169814766537275706072926812188518221562566169939596222318074505442019074535078167017210417947036637892446040209e1769"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00021_bernoulli(const bool b_write_output)
    {
      return TestCase_case_00021_bernoulli().execute(b_write_output);
    }
  }
}
