
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_03024_z_poly_chebyshev_u : public TestCaseImag
    {
    public:
      TestCase_case_03024_z_poly_chebyshev_u() { }
      virtual ~TestCase_case_03024_z_poly_chebyshev_u() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_03024_z_poly_chebyshev_u");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(111u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() + (k - 10);
          const e_float y = ef::golden_ratio() + static_cast<INT32>(2 * k);
          data[static_cast<std::size_t>(k)] = efz::chebyshev_u(k + 1, ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 111u> a =
        {{
           ef_complex(e_float("-18.845568670196934278786975819835195137915681328120152802388465530230264546444670658126105873416506500970737105500385835038078991971026914327551652004710152927492999332514125324524652114414809483505810167982529592103668658293533696446776942757600996984030412509828588519940157290427706611940791349156961882448929465337201491974065158972491720901776629794384031530244825589923137812005277254893878221337"), e_float("3.236067977499789696409173668731276235440618359611525724270897245410520925637804899414414408378782274969508176150773783504253267724447073863586360121533452708866778173191879165811276645322639856580535761350417533785003423392414064442086432539097252592627228876299517402440681611775908909498492371390729728898482088641542689894099131693577019748678884425089754132956183176921499977424801530434115035958")),
           ef_complex(e_float("230.41250404732261176951289737217523951719601277720876261587911998619337759041312137704072043373327519446361229891976182070612171342048211177711520350567281967183140918092456517801374600770228495044808146619809311999353248891044046662833031743031051327142457457018212311997573501737521707796969499974576011978769346556206454738826910357706545234615605564265733257548590227346027284416845810409192955811"), e_float("-243.7913600343715041396432786251176495419535645231503234230263167731846994941010972393899821901077534546492003580781352500108686510949246776442564023382995360500480684899402444024665183251055476092067834799814437726668851976013947270479340151097146809286771553717316252737532189628394593827636624037607333500974461549289732405638259858170794119807364609611310911256660275809535362476699316152871154423")),
           ef_complex(e_float("2380.5873167083259469100878996385670826451247211722731651666534902563832076076367472171989737025721774654976695659350629239072590797190456095666303649582415340274570923216841746598601042392660550762246409382953844667424126203187403824730399633693277768963353367730502280937435540470837091872825192604360014508233882345827791107547380933515617585343865219527833229639991529048812946804271245174897626918"), e_float("5987.964715836778700245860312703012944995704020678801538371426774570546034479934973717812627390419216865461828321310255681860489543892149666890465153726860737142307160125585205605671168494359529044940422094590628373418031029300327224979063729380972873268428607592436661819304920574679080695132290517889385253428005249759922662354890487752331628694457913433771642626988503816309237797781568023010948342")),
           ef_complex(e_float("-148510.23614160507569561589913439868200182786551281003548698241750963332590720601426454084846012557637002107087335714610940098520573896369508119039050943295547658977541120665582313933382666500167098081356341800026451707900683791783791702231259951895547698021357529551648619778843934554156677558570566501809956784505962412649701029614041933685000211955542552904890424029989842914244108979722467150614368"), e_float("53727.26586556764758226022023065083097678388446200370963161551301722412618550473598806872947818787885552071811669439826746708634958725074921562665606547360347264244314260000078758925323764295695640136860173045582653699064606834074204038856150773679142824564658064554982636567264496214082970189675356790308197650506024489947396072722186397978695080482711132590533794993945356414160755110661328903263895")),
           ef_complex(e_float("-2.8974765922930184758350671875058784718016370279508211278159622216048823289492046595127150073347731150972080249624526486160196007187579610491431023105942653878727327459034814386455773245923952209756862348222720198039788860979946983384655024474491728791819057851059424285494340173568523356920609951361848790425040037118562409234892596608080448262200942354356845818253220710248839234565183938288091332486e6"), e_float("-4.4065526247505322290693938194884903979954613930626364597594617521302354832922524260762580127749072046483878510168817290884058679123787743420414033246770350157005825402892508406682772058922973910614165905825903382844972095990610942322518927002829815853080798352470230730243200894899756683517142213392976382237330814706559157880783649375337332463034457007066421520147138197804629703503838272573045246388e6")),
           ef_complex(e_float("1.3541614783181892715851570907740987157421209344915272097681489572767012971808697377987489815731958199475083657390094621008419969587446754243960340492026669952437726253879292929294282201048322876512402260453291616721182006466987322093842332420923503775865516048760116108105849099058913631976494326714882683450229492460289920827637762456076868033266103919006121929350088594227423364032374420024254724938e8"), e_float("-1.9528484049770428697033237322749167271201670371374003704073990814725764908772750743338311737165545796240954455304674338888234872801066525901327443362276354682783231897897242574331797529530922867861329841283862155677744115551961448694294529712964196376011056829444820664049938100009168779897787196023520151925930429787503523365330959013057310153966717930076850653519441670508275477334199004984448001563e8")),
           ef_complex(e_float("1.3714305887056288914541631940533056855208206917501196828131793578068855703790452833724780808690636390171949989865621457314226472115403962405604440001102109081531372366870073282232517923997742014901912950040192921368942660346430997647534561121625400051731604007417609952726873318043603404393139710685935680410417963244768416069358541692164143519437328870049784244706754239083105139539417295836748873045e10"), e_float("2.0629910077595730502523589506492863741006787290610900398340663155844906729547538935202481090073300841167988759361409629307413386580345035992658681095545172186263340023776806886016907038118974521593958136411107190586953118791086505477337772912816866436938325258860051220924130509139008820624355050310117704592113370048984672749616613242022602643287694153274883066633862937149445437719656598286383693388e9")),
           ef_complex(e_float("3.3622242434440964449380396754521036116739523119840649929644810335941231610386732711791681319984996970988052916500240464696663777062682839854084874890644103594156957582833468555580723972995527474051923719877062067961719436534392500298731889103707810853374597967070142058005136792559727802599406198504754785413533017332265221675405656063380283680615684579315000917148591865367656568804535041439433990207e11"), e_float("9.4534844274866159699292847187523354795714877861356808953710751686676490882850806622259435080618015801366883556473364883168699301592124338603810590444654772548740613004393496713758725129405412250271240806883909566735143331958322097564320752356792086490393947745069060112303150701999458149308483446335821795488711015504007579833722188775092580045405048573916616808921875847457387116458965236683445278404e11")),
           ef_complex(e_float("-5.7484441452666048945101021347718859296154115932919820219173734732566871020585456612089575026633218515048706912470324403205295558017998653401650435735045238009069630672269900924907820146965894736943434088372313959879294309581408111197271078971690596110005860614338232002235408612085768413919257403216127247747003678867568305911795282471054248693088159546541114165571770099063272388717544193278523315104e13"), e_float("6.4986796219113719590307552705996392052181701014742514263228780873304231991647515141231855213536127011026347123409971207389195448215965850056943964475116094348328318491993605791445824422749695305109669073741615140437238843826801677202430331455089576042125274996453419516473335962718327187092268088694119735274259453579371232542401773349506549081970653720509942617424316429759331709467836085171520668622e13")),
           ef_complex(e_float("-8.5164594940863105483661128063307467634275061319704022449539896762366699906635325487561349519092356618658660359171062362564129865091508367855178833349747089595334906671672089874946247289861519784497891993184621895257075368686551694336364149312718236699594350798112842094123737313825383324019593972541826528202448589046222946918866223362083123526986786592613903048179734195773259839534438548973940545199e15"), e_float("-1.8617766810473649004130091058442618682106095757060189200191470039486988874792036865123449817771426292878030608662938928551494765022202427332996808928001834655870503227382564524128806375572251033177400968445304782265970800325189475324031980890323476962827394660027321376601141447359745214234570336965993452506836648858104631717650609099609883508209005270679660333705871997384084595077861536869642773427e15")),
           ef_complex(e_float("-2.8805140445525014158281539359704868344814546531034994418349346885610829676399265434873064559147228053064105160559979258429462311959860924474095579749211803507060062722304706954812501191800223507852197205817268751971451486304212972889315950562503275818345421998127458219528081746783241240426637902791344940692385858798248033249420332799495958607834702886792325984082729358979201759391793812268616136635e17"), e_float("-9.5359911419470448835918756807551247359608332725044859342186887797147821457182546574434803249277853753453597005998236532855682726228574005299113606028716821725641497744809389601728119290769393601332122586970426600484867270690247606289549083231994225361040228135690100085553358757731624960740220504303934019901620150292165604392961650773385459582956520605441650268475244683209231706597490178775374410278e17")),
           ef_complex(e_float("8.876765101114173489194944027772653288265572563468147363765328258589515126649298182980912160160494067895840952536302066666138050457504040459828485591509242571724291779120898259659638397632241163252412622802071124018126864230015500290351696259591239155652930243051341731071642708971918043939520435932914198783150261541386977801960643692396198145418243676770400833631990520563737171077891637745642971318e19"), e_float("-9.1311193875292108403497476735615566555280905607846185444754863262019049391162455436779225279571802850936577568074832434700468387449807350723198882924353740864467418731693953154355913309190202173059554178387191273812925901119062597336231551659664544948112332987779702856267649784104174793786874745438533391768515474202227127574760077427278284014586247073359770435498324078892496844793045891708783741773e19")),
           ef_complex(e_float("1.7338783990429090508057796892270937390296755718377402522778987023374147329338329123539953974625973675487483189022415925721780135721630508629565427838413854190541989869755831592888202947107109190278314942084026937055698203576706857872544373341605840422990174735038395780254075735311596137676234120125580162877686464542242157933752647677362297655892732379813618663153291033628289447574732598685389456076e22"), e_float("4.766206620796076728688515775541739596348730238724137137790374935744596350241431240877543160459271411943534627652357196164771461501311125187969257701397692643005110972319823201598777105628122786636133192080467320345908605243321911391164690454218711537659071509524987024678666101911707599239496235246881039279013724914793409225708749994088684526963869013591736851634731546024519113922173105147780201874e21")),
           ef_complex(e_float("6.368171909159569849437770839926611580097650883826129822285668415639798521693610105313994653550483350681436520565073572609425792288219328566175982415153091387953382684277093449175308910524029755775839096018295555292793742820687873886358542847218361987050801783804711098172024374397692581035910828490928756250612938493962595665550379251751041019872611483324036038182541004783822036159049846376346691583e23"), e_float("2.7022136610422379898352200814954314798262668515799007553005582206951881628536803389801893510417329563394403861788292525467065738804010987967299527450714643977296008986863474790583948441914895277867091097813903402907043652770650778593986810087353341679190640121720337430690238970278100702222890919976148423687044519709552869808543056396444036799312588052433272221855662921354273243797132166959132061625e24")),
           ef_complex(e_float("-3.4700404923904232228096739036270924370961697156278070023632762113756986302355218592583931166190134710469231751937945653575201938382326884662338416448646895960769214320346584691437480414654552914189952254087620541703833927522564765923503506123713651417487171193416907278857003276326503225217584720616566338955530894683411609591165246101873854877386349798062003211859314281596564956071422451027382144642e26"), e_float("3.0926517584029664617698709555507533879066458675795398250856823363624894881316596015711608217947139758149905996297795199364944552715062175732909364769678702184491264660407576362740196531654845623727785516327585609147116655422618159252060205055930444130773751424176822231455051321935298249253224982203855439451871332212137524659252865999692306151012814495273533299077397200838515504930260210621323796632e26")),
           ef_complex(e_float("-7.8764395566143812360492747861919039097891524705117867123192978528380499849406058308886961611417877166867957225692246814634705248970106320606122077929378860215796032100933326339696010142102020127124834652152464140375717419434789649489393630731881577715906196438615158349744545012176127562088591486979576022268894717144898840327269390709386121524055974453959323482211141470856092499753003646606896662181e28"), e_float("-2.8686778270140886894650785852136433765066852942453829806758655367815778023071406884481065940299276229349881394512072689479319950108760350364757925233451618610908735202743670470411380528215400438554203122580497905910254370146547702227995773280815748604925981056253873160999204417311505925628492054018642851904878102291815722790523813487880171818963379382187160796018360498587071711009221396008171863711e28")),
           ef_complex(e_float("-2.285128357794502525829938829463519593435929064408573667775070872727162795750725900691162973089486427417798701090915101300544862067979767080002169131626624342109070759106861124940006043133011864402004067060831321710424415981276480725089182727679033705903169094555400196277746455444686713864511799622128198998223684248085298958926678737682586179925919819140714529891699669410125184777433042496677878561e30"), e_float("-1.6028913592032297495607113623215703790604251074034367805153448621812289398018873106034467750506777254821418930702953614094030917067956317561153667429147713808062757198735326059009481536732063375019448746054962067711292299564449778355879870392268605504673390049009574991756524117110831647586042399125651403483589757013481335364723368512371669495907089691343448376710733978385619639551382500580085781702e31")),
           ef_complex(e_float("2.6932193799425517291910910085607279073458230289408275894447441927155774196142384125653676778192628696260311838591210592261403842087499153261186011009383475462140464747860006428239414974344808087338109201395682298851701046102028694610957978045732697745893678632254885225315085104453895152067008020454029929910875104051514604125181419680855545377003309036256160135081290316299666112903756926207514744055e33"), e_float("-1.964053328002778239321438550598195227042237227358864275651158935032273499468029296256602870691163467128680159546875940962639753707705268851701762579703957575850228236325366926270561493489757997541505139501744731097690991857063169147589069773436900992956183206455623460788241888771212640582947850337988996594776651137077163997194912412298160036786850380122223370187948037169804338751692745882001891335e33")),
           ef_complex(e_float("6.5451290069036459825881506800140975774420933411545954707709612486129125853372272507869204958555056841174661160634792915841122262514716463145453426770575998161752385553297623185208137582382774202284896015968969752167904759170643176536794679547435276117484920571858131162260292036707242877914877847819064721749558212243677062084276512024590136326485463065808085395042545204514774864485108706466409499161e35"), e_float("3.1969276136365680040486841611052703261206519517584008686671207619550169062287757684953458548820354184589966606000454915311456584435175260514308506793354462138030363375762515783544526478644273884485562098289629672958724986680250291422539509225122902499582174287526053876469491623934246971634171642929745944126089002758059666028526857667561113407527049926162201193705356631706643462219832300157106233739e35")),
           ef_complex(e_float("5.06221445856336944172978249495310849419029434516079709900878691863911087860532201645897123728619217899843003124336232602214769422943602401165114063265859477204076257147414013514392071450578132454272647300397590051813903506632699295260343616006720665935573362358950153776075141495461888235770828080425712250480600844447654767242261296383156703024701417005939716828306017614399656447178221737182946051e36"), e_float("1.6827481415426890077953537665969607113261066488218172308043875381122416448717889086255139848183572890610542792581981643048374761877198360655237797268799234007435192753053970518658539443847330779815177750203294841475343401564225724012422188886622600812817942160145645952891213645958271811470638900712742253977910462129639216618898217633734639781793171190697070940134128836334629034804602273088219478348e38")),
           ef_complex(e_float("-3.5744078706528473721532759474553409293313841762100656772523342850276463059768254394722391707541951340299601367425251225841250181594801421597252297305142266912304269605017579392664941235976586828752251186690319436460176776664438913068806746628612514104031340278770777128045096813440447624373976104851304666170261454375696688502345772707246999677545806227770416383675478122679703123604901015151676162184e40"), e_float("2.012575125028812948645827387779142234078685376914692187745782123496050580071028551661190316544098236374391177622696596722950476242822015087349151378176070042902628736699358681899940920148967244684847165422095280161573506460075161439125563448957155756378970573930849401821191536483642468552736929619367732283335693848294878171081181632176461241963586744384893225091464212573958770932955759357677137807e40")),
           ef_complex(e_float("-8.8079566405247768638151519510234742706713313244708561597256099672226424396202075581971445145077114309242079424989235123076418879056289004765214197938901393548531295622522599728840583448267266785460507220257878746342530398797897761570344624379851838944648354833863364567939198215543636345846326387384704432168433780495559097337398006618094239922816628322037825265104194825371807343707880695391387849985e42"), e_float("-5.7301101451963261904287033773513343250177422340368690682065080650760653834326401098649320426432368472180925291373217652006690224697500854107286114635013877062481193826820317821844563461202098508162308264919215303261820422993874071111692729219625479525702748730357927914357312493037289486114109746507050932668772639997511785468714266859231966099732955689665497859484719589090722879017889193085818324574e42")),
           ef_complex(e_float("2.730962103599691519981020162339473611873893025503956340069643573653011393276616386820201037351358341847562160857397634436156309334752189159805144198006238224738965838711243633375290766501145328371226569748571723174814279925793488306526828840843924602435261725674340025683933397952096817645914575464683408374586463097115627071778444052140379051862896344464626546953992400664521732482256168206534750643e44"), e_float("-2.8093930298067369634590269363537678376397338426719068974306651762010614804926475462043968809328723630067687107548028639087843057828674922287350071832947999755797234977567854364747058156269316385367507981477601530557965240338287675934011249216239447733336555578422031761115925013140137524510573530800184764742631622670208349433585047160971427001554181796062783148288184164819584837448330284147553003129e45")),
           ef_complex(e_float("7.3620432210392428950689489869291495822651846642586573969121497374068787249545575302759667468108377325129555835974227560901748496890074620699167238496098387873773755291187256749145039833932474676949317086731461956407084683771243749198995366530799495559090106436711281220407675580768719321441519908118623386604976305586359910841590068066764182278692959944695945436354693498278489287320321093299448223868e47"), e_float("-2.9554445611621392405116521480930907424633562434368138214804043239726169589808618832066520887026967462175884583802005136170705891678097029363454188358365949996183423076094119718855798173856318461634718823361807151405450559796912630261415136440318006960664621232789686386761834344859907636177359894741471218920765801046596638967197185477434022706636984583708922468428987396733723499489429584587675043906e47")),
           ef_complex(e_float("1.7632450808460992444050798685059668325615022256108319961068089623287656613552968869368592571312074663158711072189833040636716847073052861990781329008567464976687276359246806910560797025018662284222532274146835769375616362076548278410078389375919574526329835318281161275387034139575894997548398454112178569301876609158281550118528764260011655398440004104210002589803971453329299745942955217733684436117e50"), e_float("1.5201009467077932727226404108642988231670642079262098109013061907247128048878165072170847062703193066592090094503901786170641272532989850972688956002229869836648103591111639668070340767520735479534384325321363777180563426204203940731376987314618267339515793498399451276843191302611091889614856828784426662175909358309677725816280229323246268491488682217046362044365844345952090158530119451027309488832e50")),
           ef_complex(e_float("-1.6570888300994061572697592766612060221266614382666006336662838285432971571311339052615886728970515020092230708445088437203066451666839355748475037956428224366442295728333795865088295017586125500884558019851917381716824050504277420476475212191388136176156252260991672882561790426905666140685320989159476366206387072868680381604530862077499401567615252179137671683858821338537897172089002016975690758794e52"), e_float("6.9245016525213912572551977565426218306949932042840590134599996135709080457101381732863165985874910175451950404475256067976626298279188675164585183618229842506394218579834633684365479756854637430743242792911899156815051227286681209498841861236677709583819030059869265267726483048418528822942806340383337390550597123325851218071844824993822697546138276486748504079564753148947133276529852060762902155078e52")),
           ef_complex(e_float("-2.2002037840487369159894306817734159614986264445572556349695599401947565803006219811280296516964613926039544593953891656145669385352602610673615646777461050003761495493940068427946439053437089423403671940340832070749891549786854028644915571039568174038362428331804512301669960837188599006921028932371463570295418848336544862738888047911982283591517087584092357344725075068955705388869437508751372653861e55"), e_float("5.403294318232824536266638496758562201810122224334618115674928292173771810886068686362690067960607182592319094050939872405371811762078803772187311095640959167210045537962423157269738919706577208825756175155533874528761860560995106494643673184802687079829431048329888006125372012897171687225392817190521940079464903677831991654216798641159109317063732253659076769348890246335629484844745365082799230724e54")),
           ef_complex(e_float("-4.9137963470466169547877654929676913344087898440275727672749440875746235473372098742217977733402423359614732628735558841329445407103770130293099222139420353258872769307455426412084545374006792652803868407153771204881420542340839986634200982652306993638869763780144562002128197555288957113549236143678996716260495219677374557574718554438858051390721340472149461124724961139111262317517976054429432235376e57"), e_float("-5.651087663046224639152232479134963912943579374019580621764844667563719949835647459492674562625141927359235249563418023639512974902242056512578101541349114904261462039494264760604815059273274954841457299774567780177080349691918878638964943631184071446113794633633386072332193893948369024025027118274926723983528758800680456973316174672188970458310687526935476173289236947501509126068247768503442412441e57")),
           ef_complex(e_float("9.544998999814246533192644664790386131381500416112206708806928741606247771012793565009232119304020922521481314422335029974542765958653505161955146807376591746319238744058460671298089549818094231921341063214423329195219082327457327238005362194400844991496350732534533922115609393218618338010168350415011750806994163994215687027205718791874281828692943772240314356449625192172005685210305787512494489382e59"), e_float("-2.3836144079609323355470501238658751364321598592691933343342032151614100095260626398288960301469300897444135755457518794635259009010603079958462805209588339591006569792221360208110104958066781838836082000435592303853604731756835277551914835802346380965498826781888745698447225334043294422684857188174401682310427443927956589466964156201727178966375657175216783836188992605733650041311439730691389875163e60")),
           ef_complex(e_float("9.0805899199476119332477177730439760226181808990490847622099670409444904644033522144322958903483186377196649640402152688809423617975777155762911335227471950596218434309164520548025909586314813479686646498912076975381804619957019718291132918420553700938572782717680444585342100670404206927204194209105543490483429218527836543991923892920126458572917039748446556815198883637456446564636456944522560579762e62"), e_float("-8.436319649517314829516848245155597390686374992700361569924374579401942289244163736047898061752665922520403842071588987849913409522698967604305929329724920174473994337378805685067484813154181517064155618064015443695070833227650558539095602432565936311936287212934740850192764389060071915234786032903708226653228453654615405860437823220911829807502748135349690296912605426793799974838836458531383730127e61")),
           ef_complex(e_float("1.7959477887357836822230567832333097637366129083830297109391703376066339683660930285524506440921479151219513259276201876208894368359322241669306014962962632136106654677992505705486213615908743064486432965152795285088666029256058488403321864492092961945038748877963988123710939015559800178863811351830965955616300780183061264924877539622901965563817620984063139076835642059484295370274672321483609615242e65"), e_float("2.8294651866213612197495230828288122590974148658409015902508514253575572091067363370206271312678841797749724452128937303353895224307765493838845212096660434841662576282231146072050513116640008096987545338638730534190856726032870887967538279256910080713381213953738922982617691402884889289685518776195531344707723139208344288098343033245016357276137664105484858652772103186002192250246633103149892696659e65")),
           ef_complex(e_float("-6.4653581213771479992820071562270706621623297065042173298409843205305617127973337066699729476573151006041144677254415537843877208076703064370384904521112567363387814696009201081877462960512002618984044800365094583296401614805580106880434774594567394938111272808971572015019479042617992672737234694020534967396846724765468521820457097281760032095949067648903184949688096178753083454549948102258049933181e67"), e_float("1.09628089609775931675768745912458113230469468929130699861912136001215425810463860725936352984319173559489780058867854964452881363536994319772301959701199509843954197229451231725508869068115965324246281307080155850321018929179017667292165036795156491567528977169022751887023180896855385252063912707946185817020953865024623050576895858147071141983483186812783873322401847840979119272650906524737936948377e68")),
           ef_complex(e_float("-4.9804633791351690155093386358216496470326467041590739221390483626248533867581151728492937022838215986274612581302355057755428204075195642147156342648466672018825821604112685183749573180932465236666181768856251089750597829616487519137724260087944109561962232865923458357039983558790459484214436278880510657155925342755157228607492035628098778557495250061932571049535382827528371731850207239531821935578e70"), e_float("-3.040571909943748405129969670647901313273061028375037291962496408753403620855693395323009367173171083469177452703033336600690806679764784605522694058643061792315370308739554604788680628180340185372514793997080713377813781884430946455514772216809598756864470386032158335098908544470659854159644732277691724840238353921883048564744451214581401661561778342110835359119481695956612555326746718815592151656e69")),
           ef_complex(e_float("-8.049944216018602611029015126606746065661113497126447734881226257509887896152919008789145029238406477479701280443068850550531576588028241783532576759302378168825825874771381015731377844130214636725286675041590379304820165799419910747534230730062061575497248600167676967816186308754950680722300556081750127378832339148207118855057132039904707844124222806086751918391472789292595599206741601521748644825e72"), e_float("-1.8498935526753047396630236407334046509969749238725687693268516146384702527529487133742904152949381902719213394178390969870560005855157083600590032516703424914861590758982654582000799746273537465463409755521123931998502430719778334296105263045925851319779825132250236974587080199191555172853935184761339127352554021322835542124091559941128433881755725419621450636696476204235418157077058055145017025146e73")),
           ef_complex(e_float("5.3455625335664171591207181645417397488817210934988989687531122549763466419312139035605351596919934884741398485795627000510506673726666520771468808560427938148405961477086471120478960028981594612161729993535662185667310289495638705461870533030834559359471316499598561560738258442818376141438408815121735098972822479991350295844654078428574679414784506635146285556341357083660042449611079030180156104982e75"), e_float("-6.4852675597086808935046832060915425413960561973304495493192612188290097897630244621899182007211457491345794811664934920953240226849498183221354610587802915209605570965743625957423411532925800927675584584035301803793110353511876460890271004876445290734413140995471109345924374461889790654194343140466519942543700456334707568283744868216958671843000441390184012270234512386548092507161750524470941390741e75")),
           ef_complex(e_float("3.518238879744422611404771165017475930923392352663088431237005625218051437963279212585207066855130357689258950788768665199987694737867846609255051975950427220542956501222303806418384350173640758006743714923992395521812085862439496694221576048568452605429440730388736292488122503061348946668557935112099353742579470085245785075978910887518085453815321948370316668309865110251014622713054144859672960648e78"), e_float("7.821613995637838885150526434249370235161523038199950263766385855228001584729819189722650505100489881003136986957425862223015680485829167533048369108535045660855412327338104551249141019756339076160157010752374135974916664219424839002144357434673690471269663959732312539447180821725395302397176583072800074658641924518090847382733562015875529359733745294675521782211667094028327437892647232634377731432e77")),
           ef_complex(e_float("3.955934322299962302366742872679082204606471150477611502694879219860883335794636776224600311911578685361265908160637492462258196251559797877827696142554555776661796429200207663633729916267687524083525131867648630965016625675257102167112914981022907282728882449075949198787610975272712249937808934128141834632882042130133590583838780094726722660111690897059545854501111066585202923067633526023037399215e80"), e_float("1.5397368284405855016640139645375514671391621432151276288541622750063458877200035012455611926627316276166113961599302776953468454576899726225333558248756730311618548653331168064274024258347574273265888828555526281357522622707046496249035522505422426942462538726019788295162991521786752771915000940000535924025189112822690083639184137599337118491326686285797335928534709104028908863954901150134870940251e81")),
           ef_complex(e_float("-5.4115083340092259289487327036718010439785889000283853596543091725886774360401778218551308291328346076914224300300176923394666411345399350924009565806151500432914081808979272586280832061300165354991921424885199064863893043863704200229384943619491832479248426298774849769312148592389132762393398672351191926894949064594559729838368062161671879193114256099306534187468274370038474833135472519074301617778e83"), e_float("4.759602701272515988286238111500305270686171072752521708130968042133329418558064770462870546508152784507481722399188073597496307814759187400199934130270866743458254378598300424494440551529665267817677078395951724605697722148974053890631903339472726444829719864652490777152356581231776042200456488128081181126848354894611032581342394444725677875613284535448679966180823691943092397558569119586511458173e83")),
           ef_complex(e_float("-3.1161729223239515040408253460490062323856490949732416081236404461067249253772116967698914408351463991333597978609753778567449326902929578628502067475396508356224015242102237979043583513874146268364791587381152569379753575955931139224270829862853661851626193138653080476118830404899557010140817067926014906175251797404522347012886179800374459578354356935367937892906952215313171511834462153944767139507e86"), e_float("-1.2439358969938239467109922782792451342181458544627825269571730431972474788747438391871035085920638799619775115186303754638461825334985855566027563383808907946609197215131763591522909437640182904140535057274317317092220797291373011293814656394305806261920648927137989222511934521290301655866287043520503620845173193948912673589498079876740616853561985259477656623294992753240232547182550904273147831678e86")),
           ef_complex(e_float("-1.433022314588175552966366019103589330529001569008234075040956485659052284882105555013781321732789663194566510756990513763203866263770856203002419015166134808211234668544213021170424643600411076215253041492005564990286991514023411422062629307672288803422864755556179425555824668451159781231751632513146040086760205554872254163992680571515258623083513042646089158111313129337579287182899744402509457174e88"), e_float("-1.5967473444456634836797819976040137536359028741735702468750030130540018917292320334250509891879563195020448346229131338279159951742245872488911135463327221771507972664958321457567657862870849355026724208169318797632249066216752913477513099352408534954342687116203930585456497749388106735670566148740437506481572285781567605344549578081206063203931437586079551855989227822803887133206398725209009862542e89")),
           ef_complex(e_float("6.6620942425172210446994524873982942276346699279958470121375006054718002254617033520437864399461492789963716289197523884965905249049072714148791578914193783110800929284443458558514379289622120597431632330624802721819942827196727189062696539673641216013606780126246024619884144352695782098355422834709335579661548963606978445464004445652224142250274504361228199683969904665649699612041999636912014667537e91"), e_float("-4.1633645017881973273392996078853508765869000250135580040008133958729093587561944268758019024371650574066104172300676099511668888143518934673158596906449905962344273433856312544515492688983668005822954527734727481175813488967603722535638274913200629995523969102990927028094648074276891531305671476233849316709053072111985464461556946974565202926380519499481998861052420896995488456439671075029566579964e91")),
           ef_complex(e_float("3.3772790501943888290291087130363933876623448497670867517021368059906042485544804904626188963649558145422873557506449066956134232031621825335727800457672765926613260413033682771041189009891867147903852106400160104728630428393415438513208909133686212566073620115167677634924181317813061023156295939507906818355553172577527207149225853427958633895710528333498760709377976321482727666248163677718155166168e94"), e_float("2.0403077957772319472733718032730323214638152288386792974700524369318251894087669879937935060692787884438933111517111043861039046622637999692197932442883417103138074596205097917932780738492644978905100711572227064948636164916477384245618393743961534555049095306121929393274967179889380028834759058563210467209575540472838139056106446963804156737502137557077255166408975323449924340835307088455723915022e94")),
           ef_complex(e_float("-1.518747629814497640503861133146726105386299060831263976697416214763011109930481765565949664776662662279200550685057872275577726969757906747728932383428844774741119204385408669219776197314941724598665712346721208988877810041208514599511654665429979680158272304068377631191118233865781132998731503592994534247669824149414745995641702823795581557046349276110105538315734240667256520158475745604930325508e96"), e_float("2.0243057599414922270049702966951566623054064792151159275922692952511180496195682704540119125456258954621671668862342529987930343349605047047661484649885513244636303157847663764229289757220497501056723890037889469564808270164386203772412063789023252877556980605906383580690211513296072979574459024962093859348372409315087710459708367821259319622661799269154990825115279123955761742195528176006271430666e97")),
           ef_complex(e_float("-9.8748869460813239212808475204767651376521004831322668398410878623705788324204211418131534638995591135588479338271152185726415417539171490875564847823467264467919205957351888137383231980208767061014738393902734219552487659139432058365898914358071275182277887929750063231435798559817771577226418306387333753573354552544657835641817952314084270810710913629420161203448037094450982770450843815711173488387e99"), e_float("4.0991346224669960563768126820214815110071932926507826292131596965775525597423416376766542403597857203521751107711451336332893674074262296384279274086612554882205416623335516613013108903408505555720158315578213426915145758845033886567513446690795110655270502497244579232557363790850339795859996298103319580695787655363185326305271136738508160278162191994661986874353576011955955873006474594401326733094e99")),
           ef_complex(e_float("-4.3726798113090277666770531208473512980650920021182784280070726845097524205413091381120313025504035417593638518636291577335671195339895667608611159124575530460819689670802753328537092406711909963661952957968348564192523326826803045236795460411625556105008624138536639813173532605934395407175558334302914929662351973041209875112801109109325361739130959894326110896569047430454573626408700213611874791312e102"), e_float("-3.7522986238087795602273142888666540593179633237017234030449794738075426748704079428614147982313846688778301978461452377426937380059559744665583744452923046574410191001958351673873082797443009198084201362262636511133644996719558775569053804362497150438296854069424803084987909552397123402959216223751427243147746649956771077140330170336656617497176539658925012079359250481132209213856996399104773928232e102")),
           ef_complex(e_float("7.586486996154020094385927229839333511943636010168758742862121799715908804793120207282517753801362855144977015467746699487590784168106020129359017862996019804608881965170487191836189458623918900152869691453282081420701344684780524911199461931005222743281801046744908670206896185186123394519782504816743028904511228184776845308553612057005904298992913170074921382023447140436179464766742367726994965728e104"), e_float("-3.0835734443900840809108682686203621442590868354879080289843482853579414231829680061699692368851195535974500493765680789423029164933134640811870937308440807681218323510271994944255411184214790665314653790134771934367675630951452935339309804560525377086308696949346026248338556985353378362973112164911741450910739534872709431341796172345207998851090794078073153547166716179971654542583232207178924374905e105")),
           ef_complex(e_float("1.74315985626532955388138063599637425650769225591514651240353978666612362476315403698926251755244406244055120448809194959850891447305504441161124413630349208258385133868269210959417549798286932370987427771013802567400102544131167221041790741752554512534294492581191189862258430040100083803599619253569531093382841034277878095080466415946777779831045962005213588450264460431539870902913607663067429685e108"), e_float("-4.017869141818299571694172259322507914247503782815638856862725858206246924672085573071267360304793998962488464287834375818626376303262867926139460850301478964440070135152308208574665343669321284501378760459305909248320202963576533311189513935823564078492880514078748407568989912774081883466316892507488247865534082445777192576495231466197268022303814821428646959486747089256486231636893673529692782608e107")),
           ef_complex(e_float("6.5863406284191525729471620527628336737278680366025408557448628513346780120678745236958312680076838702442483896197482832633255996335754882244690142197152211805315930523599709227676839239543861827929299025523314349004110106159790973846742999488981026607742243227754352794283476522631108227913398762818686845159342140262456064048144108642492672337698340710961126803943750401607471284111785008753005082651e110"), e_float("7.9131651835798629492494216801884971069102411102404844404048833293328335452479276508340010889793126654184947180743545059553607971206633508952281230355079573329345718606121323554563469696768818376272395643787997831146614921799800165651695436454644614253109679846517685366433314844452397420160459382998705356678104691015808396184810844937355611688253103839975819437930795023349381035788691454749494531276e110")),
           ef_complex(e_float("-2.4075922855169458727951534587572433801771234366116462339278957315882617131538786262866110350199220721440689504390733799596368250537710395334233167522290136164436243107031410414365689149060829354449324343017985544194835480574622846753731978184969553135635065344819879070240839214855452677953445673122533534176816001057074117380050118467447734657454396382759494456481917421786651924678936475331850415193e113"), e_float("5.5514896875729685855004695555527321639705092545315990167792682160835545088613541331777241253794016766000016397576312704677445725247432199009989986985157296350932440475327099284971160474040441641578936471545311447464540248284176070131108276137801974167614114175217076897182687130651347931815306354450077763164725758264326369824012862119937372091840430037515425126869967560623117223112354119129412121132e113")),
           ef_complex(e_float("-3.6241538926600622540282069772482171685093218441022555573138447536144918642235138505452911692334055052776573483931432327733466144901781814647541852902211327717479164868081821695834958304761162542584139587727269219419179890172898400995049832501672581004638563949578773569319185899284612648722992098497743096002834364079551631201709340072673565382592781012252177114197133790827525782439558956535014315893e116"), e_float("2.107918627576251115390353389153726572053375215982741926612473282085504552829315919633605170883946496194692731509725980778619739687369894458682636815760105552692033125194732562376750089527689068055221316535576484443085270149634686475949405724003136272430279893621219501390668276567056319720956518547112140367117636144223446720191713924542345313486701571953270959741306255229630419771731554796287603733e115")),
           ef_complex(e_float("-1.1143085358382708401434933501675974926192053595088418443794895067617574319560550488908941986731696878758304008566342898948620860892133996211000803700234101024473671072099834886596472055974540657700540438414020442410993183918938916217122250013554908247046614822659588698655734388109626676630537596729729724842416350737820408793494333271293230345773826179101718624541888015912521967371474765142596815149e119"), e_float("-1.922664226902113336646923390287184708581223780404576475004623289670959991352996574934995505103736439415660397961166400954971987558674141285912507446021694453708166189687375762148104006141379779859642080808280360443742210919984305491639516372177850000091269795764467567019211549173228110622820192042810959474823905489299486322098242243790697154213603541113978832599908879179962781326521453161185729069e119")),
           ef_complex(e_float("7.5860927740889044624637112562171638613583213960521049020487637210731954335779890275986886360872385779716318563930036947469136247002818849739964515923080803215272081977358982385053055907621798233674517400211865655882535811492189862712414713412092837903310777188427860152854877396377881952537160421879085297128124504735058544850253334820195794526759374489294649526290431923602632425279205822238122516427e121"), e_float("-1.16165648048581570522644562838504399546836889407810172527279515265794163537172023137792948181131613694667266259883861761344937723732030513180541047735284967466165792118334775803626313697471796497846227203592658609935961821992030343290262732256514488790864180847978928874475758299063832487598562017401670086654674314001168420801420538632322930785620949070277635946898854941533361378627570732942947607937e122")),
           ef_complex(e_float("8.7764166062820354351980130153425128544818813180035073779478557804516362491077112270641742128964017983318072942207672095338607887870154827730874110041544214791814283811020774105323634660118373796804026618923179589165932095093055756454454490107850071661538469317983515006540695927676512157729313643709514146125260773272247926981774171751801966259754093715792542926097234285981766580403331613669399581287e124"), e_float("9.835949413665060085037998177238603525614819445587404281799845406000502564849109894995082909787863961411114276448655475490140468283039122567876690254273446957747539366565578784399829993032326054310482946769864994289485750199559909360597373209946031126156775544153473295495350981656110968112489519050979500804232509774781230963581042871081923938205002865348007112300290638018859508429131629066459984692e123")),
           ef_complex(e_float("1.9923464646129811666317286202927896650040537251353244281861003374277397864612391748386659354179373707143851035892352269406151709601392398139747384375944420994954500185154076778420451988901720715381484698081523834651570702050806932490078101785390523425086620556185918793566935245158973489301432064742711472115421247971803100146606168997384363525917669887824439397341975369790786533177151613128467384451e127"), e_float("5.3715400623449757891962679325299062992170508527699864142991444320342845887337770027174703133606446115977278750800240280411635002128014315999612666684180519222612504729753396503749195120808381847418957382567890838083502483795416889830644889950561781496271269553205395600907165096053281314642318530472997019712358722262686335234229198910338337905358465752893140164130496195095901895679878088909374700961e127")),
           ef_complex(e_float("-2.5780866159400272366152679320771915003284151850763118721403504692176639489740592843954563322742092611717322916882816437532259857834863611708082895831574271218596746811996289386599540552239778124812474550984896321546535613063270627327473647847555315155286346827233628601887231151224365494327510192399993683310298208563551932646125271548877306141498245791270123268398926865790330753816209569541185368418e130"), e_float("2.7732459870412966461740875758866649232587419121007899307801178011162686649796513305254363013056834575238468657008969913880872675734383562134041251727598342838731206646268105307289421793175317484038540277461133238856618879628754106935644213087357478815011015590427695994351597293151436171003169161369518965176370452468080183570321567627370410112795415267209417079038700595673150237972381212069358399487e130")),
           ef_complex(e_float("-2.4477696667264876080954461772594697903179804736972211643227953284557118103093481485641569200255101169453573913818263005268461354301730906596185684409617110594879575215444616394341468443159473023525220531469844643913883305190800113467578417722856154803339248924288351855480968248522869892845776624146458281313167952797571421318525599616965278531298851617268441337112664107960948387860950210759357984691e133"), e_float("-7.101732104737797541021799622355864870855319229463574238797815942060495453880199732951337705084640281065448636246050763822019671886378913165927198261598855998141835423099324633298643949666197253366840128933636500239557334414514944740681409644722929564344937985310869360813247390932302288717894385447404238471713346070891621952446916319793124184503406753715073077933025525945694961474105783838453316329e132")),
           ef_complex(e_float("-3.19720308197117617750733615160670290079020984860170744711718515785769490634363182069904693641509426647305793129208649917757356283373524322309900645988604392189305019649851337820266932233434904562184125464781572900176707935149735411155177688089426863529148379002939519768310418373271687171998925008383785509408182858875133940793583811009542240683260640334041953886785402712755681932135287355495501359e135"), e_float("-1.7171128231839975165458312375119369389079196294263949071042651085970947995461797599440928708706974460444581016700908945236589957680143209104566407427719482272154864475208932491664735861286393168949121554610374623111734513922029054853325339576104497053248053949334156705359697306737193712342493916296520203218749843323729542667468964259624658834405561493006547543146102564461708843857186261708469559291e136")),
           ef_complex(e_float("9.6948682788652340369824016300564102756350130535643368669202597386072348066177443604333459873917600867430716597870314404043199332036316446381080173788619855058765204308719627637714859482624862919123060500589886801775397417410843314344879468520393844048434948361288480290562125601557511115279194267147391374609381801418123384578916897629669051866710129003458637500701706615383842419253444431590003078681e138"), e_float("-7.3771089753986714710408658055179725073933081802723162260121986911928209202144587009301715324469004461789952907062149160669482895131181669628555389673640827446040504721688620088225870272870533955336305654687153460800846619079734425348860497572202914154920798438110765957617805644966844173889923835831908804279344293645913774445234966761817356404629409092473384874091879217295647002116256626010716632498e138")),
           ef_complex(e_float("7.7695418505884087534558681466582082386662848365453985599830785450719807090848396999797445072869770323133882147437285351811732356449720159775698043026968672733223471308683771236489831682988350029825490568193718260219446386836598955179380619692978439419606808165970389828447935082937723184189081810021169690415607356026056955084874374340861997223937276677665408674533745510771701604036972389730317599865e141"), e_float("3.7920696696978392180774302035375928325911160669227735433236263079293423102986910846561980784897440092138224030043260816413978988427960265700217737931770981462585668316758386491720905386692456040133744936324259519546543177391688127570166396035272116907988670910112118831186256139541920410867108240912601644949336164888637690383146175489133228726514352581760451941147557683763859811067601918470196546771e141")),
           ef_complex(e_float("7.57415817541557914417437399295266904620594863073505384163558280613640063871866829301220045725118184200361500405071635615474356878450967451570284665233115517997106592728152343928133955392290625056458225094476768691896430851467601231112842949011324443987544563782426493963654999948231324246548761834579547658384220966112731234378622120310078286636820820292898826746507913080013128680987765640766092245e142"), e_float("6.2404020632970201259013029075986566301941648800249451047291896173922827442239550109164778690694329256615743308600541055449740779696053022109499526702985234957325479786331010313331057491295492178876641915885851097941691155946127205316192079247731168298503236604001418246943036016931534501654369155537878325635213430278597578599266359912414021576218457690397959068703030394077009742936659231910072115191e144")),
           ef_complex(e_float("-4.0670751844680198423519540255037214719558028063962703956996490264322040714143724052202779394145775081153234970018353691624924814764620498594775737875482376502232639720447646672590295395813171075933178224041563716475988000852867429289760216675253871458320622465959339001676297154540029852637956235280455981738370821339153278805974652176190054535885912830785023008372560220959693008421393393682974675719e147"), e_float("2.10831621074060636358759320666645022432612004396385541738831027437816265990443083659243340562713513866366064166769445527710619797565381864697478643836007479245753582726320546891339646113660867796354981379276832971490782465734815625273805056276878671318092757638493458398651840652137800011916440894839469022797803460706184971177045150242386663539703192615547122726759762748001504509960052634735807902e147")),
           ef_complex(e_float("-2.7692490906338199997312821129908121851872579718712536483869671088809448838587659354162649227927901054406679157110837587231160342449644817901546780502697285581255987798502566357374426872333641548025534376767555677598744071025210909107790888856312523521722794105003595615803528927956819751531819474081252726956146370624941361276917656294799557643473698329148936264976662562276976346845515460661429214778e150"), e_float("-2.0043555372711128868236173662036651509171454612058503167288796938825504732605180214728589943132768525428796895411391253268131192573585939790248737476560748999498564777001478610129416075703341573760648336131556775248652967664645387264599661545934582274702488408486013418602178202845245532474097952648188549178889654134978063946251207835446009048570558236584987676781534107138817989129669043432604599591e150")),
           ef_complex(e_float("4.14475650243612077501383795792300017635185552023317202330322942663038125182834617948101066628326570365330780929780862145069722050728380325089246599470598630441102044604137444110044440695553378463952621313259628743008487642010756923703718812907608584020787742187032989371898272373702419969201871574222629871672088801861532998975335340214486478130591960009055153363053217841776967514904888971701030425e152"), e_float("-2.5592795364257749205210361540590841210042894996100921005147676544442885912342684799475057642315511930178477493787909151884571547566834355739862734413649230233889359448493870203769509217119615068219080313366053892220133863734186009849295893650043898463972034239241160968514297970575619196489971944832951564250519436601178063992670289118717067282516465159979969412643575412083542724439782444194161512737e153")),
           ef_complex(e_float("1.9054454836250023051877024215526514181156116608217590275469925629572238600454748724825524369398351423351650697368311889865093168755806815784790752353156293161403203238462709099148924701452038523000402757380625352383500492865979970375913166205716727906538461621793541187808320933703055265708085517850486002413718182600021419346029358526049757545760505993054775290824919371585728468570018565246161520768e156"), e_float("-6.005724950869884254911188197015446917468121390454555905397191599657631010348431697983808816891486151284721620065484591651192805001211908549971970402247750840657961826772983463307943210264488033998323358480488254581399193238197995254902975969255479418206944173924752704067335076259656920677873513377588983011234140369617292089863680106409299886281833751324929962515600333120568701270126063697683803188e155")),
           ef_complex(e_float("1.0899494859620509659977597877760004983560419476622145048580807389826920980718401478532739311089132509327988355076529295718063600544505282183785920559815680510931444162376948495538270974300521949479308580215525265455266897258019221783074953564631633301887956750712657143389664485592674206513261044168695277393238185565852406243609015986160989658296675771480323859766399341882072105401854399094987892322e159"), e_float("1.121458224550127317447808990892901235494110003446125074835242553940355268484508803690824781151206426558830802989030737598226135546957517895559345230733485830845062118884488129600891167071868875839269737938176505324907795979480699293175367620194369292185809962065419450560569541418713093664596500811587495653515195109403878271517870418681812254784456165584751974057732886792727378937171869731983163527e159")),
           ef_complex(e_float("-4.0742075481986034146681654537983878086196018424138427752280202427128505802432256465223990164850354201481064553827220914045859322326346340091134478568640549139744556006114321515553306595401083951921708064453258415538192854843672246314334657281917853327922358076968165409073630499010210162402361012955368433498458300396165316237479675849615216616768453086193157560579213786299582512559612866627458465609e161"), e_float("1.17453595042211500860361238130667359408748497291425369488712142580075633014883230863546503380200262364657734805195395082705981952130919911387536716160998702781781982399746027029708639740974559701578424394388705256924082015032551532641327958016076008358031180806901924999136318551538410756863837788949096414617827419568186292748399738623315527755729610500258760106387003348118432347183185240328747444946e162")),
           ef_complex(e_float("-9.9471464569316242961997553842752931675040566837074239066875781572497262633492534369742661530608858156785304875350317314583469771290408384055109438845954269969535033537976348887675065540211239439211385054051803037383351028948093144090154628206483724168380146494694810378026063945999911503369007519829963190713707912390370104066531602445408460964019097076122868982248870869259502861120144684058428957324e164"), e_float("1.3186951009045132182640715829959005498591423712901034213250177587173358591742612515114296545777276230318493189212419964136140141717293044875610159162746084833102427109486323063929186068744118702865084790370048596423094800900195217688900468688500527855679266058666232366438130726965329919757988016763428835061289725648537012865196703960041350365332179175244105019916938426464132396949036145000397644849e164")),
           ef_complex(e_float("-4.6245524112284409644631567876644677660216430506054192955221537369827011439874871710850733958725574700470874452467401521381182401870492696510961156517787912859949237509553315749440772885864880549316790587369788385329705718649615801243687082289272430372879259500421482379804249182034803026949846855216272285122685948066132420462126627324531861590800458753890771854954021207689384504107268162825794149746e167"), e_float("-6.797038318898683998200907399941760142720756596242019841967950624074823111876088096239524121197302594308173468371664550667701801922929619695856040684229106830880766282030974467158212910263186582766905374969553933246945927585237308568800704109289214982689787559018094220760861416790914721061423165379392884536925522150146090418207223451478000849642315935443743396132834416879942127974338167367957667141e167")),
           ef_complex(e_float("3.3238194421445795059647302609639091380115787144402744248984910798588513650078254859326123349021712174905746762523986493470379389721026975667513754413432789963822562856585520066200856400581612689755361446252004702123034039103778314904970431886553853663050708075804398082586352466656106245413165371134811529225917794297248329147971441497865799583238032820519407403100780020777147658126170582655555292317e170"), e_float("-5.9732092298237174162820529101172946136499352592770835430694890160661571639186492593378432429854155398327088584948352045510339324512506371271214151278584287077052654690527722900547000913857901856489505133523816325113330253786907659167900181060255931600243629853473584632131817404727526569056258833514645147501156076960395747114003856297335060066776047025450354325024069365599991495044794062157918202331e170")),
           ef_complex(e_float("5.7618894018658533042497493571087658555649070883804521238125106139503748618879592754136709494203166626015564787582138124305573976862612265396581991739832658170484785991221583059295152869400783795458583345174495962479122161669948349947938993192721552129682836127531931432926877210371260712675298667003706030492616945918841421704219045598673668474489488076337877910335444148963888994513604627416696254027e173"), e_float("2.436616739545772979632968371210444439309711811502667049626330686409170570003361286341544674792287749310196651638873607654363957522176229446425301123668642532780264192191827245966945344882468707186674446327234938422567452211742863059302380241164524079598846544149458341040964073552213671366991284436907358076184316469144959504399031090186485066613060144711221590924803438907513159847427491898454313653e172")),
           ef_complex(e_float("2.0270059333388071165285978176713855457822994380373402059072432929373708266596064117391763665162197484562485794557059667201554686756486590790741537743375755294594569014300692027423930347565569685726906249204529411124712743780420744890078775901659920410625808221864887238428769758226104986234438712672402711977116769994437282987961750033897775562080319403907533944232430682127441746715164941452963212244e176"), e_float("4.5002182830179483337502509606665635024016163084247726115421381049333867251947622378941942798996006230876318440477863687410899378814690755124579859864110820676846714274742557998520058874108934862782143615158102401765696136666097711427258941206234737095812664675336664908607047495016637062779246232368253061223289252169438955536372644781668053804075025149734992615247936214551071228980923717976476707526e176")),
           ef_complex(e_float("-2.7011134586218766714258669203020835790690868139030066651451631452167931218401268790013336057965800572770973460170143702514788387438842621675259098294377863732254451305125768955625999983887111388396371294369549737751955001162984727877621433722771357608028982405146968931624962244508127911101509177513725784847211108254857309501058119971799721417645843722733376469497524888079103691455669364927692487222e179"), e_float("3.3254414084991580667735952384938695461886070379088216377205612494107966196903122265343830674219330123523598858497679369728754367843337532104596576846720335079357696089251423471325834507732321420104171120233043932483863875074919780414562193080162575302903108619893254585894085349288935278238513429587881444141335849008592383748680704670738054390765585801980869837952384883215920446376520763399860826408e179")),
           ef_complex(e_float("-3.6826570158949828093832984255630012949471160502119065324193211064475380023405193859398484611100124134951310740535332711953118188433629827391701756192577412770489696128875596691325439477627649362269413369323835733450228430373227522786336969701886259767602645575001798043012484995880935337722702756730342233548142949821974541120933723116694866370409046423112645701396385464434496420354240074731414730915e182"), e_float("-8.111430294767220734627661770251631067289275511575101518738128153093288449941971356932380542124481435364604851801393205003207440363719259048380979353904970096143560506526093452008509516567099624431959954791647885659862381571322543336139082308257701955817046633351322190089930500938708835104658889038894449701032208142155013944011183588946177025392682387263954422502195819833495846721579839778994005041e181")),
           ef_complex(e_float("-8.277218322878412909278057267390684901592486525610118807361193221578587658388541627365695652366469331280856415882892255671438850337309697375882008871739031677075900726887276975663648846111468737814876777991673509949849640125023105447164886214771211858857061120131510277444492832943059620390545631865466076938093990522141884468501332560809107072583889847788291991210275189856824387046859895725600300796e184"), e_float("-3.2616553929657227099930842579538736442897787010558701780128531708495939036052656086837728875556210402186327163584226756058843832808041608972945899190832450658947143945259273293781978950118378541753899855979690803632575498843399868734237675014584387350445579784722378317151487005205478728826657755838430481146581944877555070796055959277244803872714727264038895609373895784009883784512842863726948291201e185")),
           ef_complex(e_float("2.3007372877909551342641303403372849673510424451353404058284641490650088567693514509119388184493120344636654512104929584349302632958071656000861242896051624191225444190510685932546187671028047049720851886622111297090803083406885418992189579489033978450860637538573064408663865204805668519505618655743790492490620109375389317348501926357977529754545464516494227968912478837504930057113227943963731865779e188"), e_float("-1.9928352983404788061351064060398386931871942364897733445612023324289785083975328521327253470599706596476227737360932097775490849479035671191743348119715027561613136990995597762294986716275300751020800144508659183757047211354727916405059831840111471739140685700472788432841494695273117262056878099556326994789393522716442903956460436723784414093539523297963142596596271018091024365047862207448948750795e188")),
           ef_complex(e_float("2.5789115661101591709878985247520389241112039474163159059467977960985841822123070229055645959770717355323328073737639815218686289661641051311769206276517299788987070286281207615456472436764046411545080069268775367994440161223582877895272980143569543374946124997585228015519938864310159680538342126540875504860709629707082218169067191745969580490670943598573247867427526278574197264441302057739016159837e191"), e_float("1.0653510439309356504849675973929628719093064430321724755198068244817352646889498173489865798390858742110323158153352056422329355492263369189520416206955546132090475105892123623894327471928428345292667504849752143704183624677142068712492587518082263824951440864907808171589449707052513832469431119159551392535855089624837167067801256519552541830292434004458148243612171800502473203608892029817565765465e191")),
           ef_complex(e_float("1.901981760764853691866524271219320727966125646173708932395324696505146297515258600342101503319594558483587765740698490259243487012973967429239336078720832354302831160804151089519238398665458712950971978456326074241823385020564282630900107461838340113996084166400536840648650499079922859370388193307835766547805848213036491882146226426378074260949317956314357452856784213052670104233949029476329610581e193"), e_float("2.584876048480092315350069753578106217755450019584277223399924963941259649859661244958617319095191248186942274546301105321958519810136930100161773285142877101542387750341419290663112254963793566178382511124847122418359641837009981519116153052949847740185032810930059872082643586820226903310042330020168171950225030669302789693927118552413749329043510597141826569042590856023179925373952214558030388681e194")),
           ef_complex(e_float("-2.0937748946487053793153555177879260332350403979283387820492030429938773255055781690132250315252446989802569525164921953671427374516164565899642317558047640962319448493317137332676102007511435784134911186176415755303468658563600898186061298602356772644141404955235666709282239931283996590513068465174480009247753741931841898389206514680544364632843577801182527702112212554583187617933128991453652238338e197"), e_float("1.2511103728829465057886314694770833761818482995237008834297789055777163364264326392272024106754454848851963232645998602836448843378344788239329816075751330595465423803164741389574587157713130194206580745714973100286981653415996780484910397621968448615645575025828376670562816318305677700101593407095651018259933557569754167726731061743412353515208118566661976363185245701499225222152525421571523113289e197")),
           ef_complex(e_float("-1.9611011082300167783386852839000890671531678828842723881154967736612581072562677768268499915623819487507872502430858035848968697740055388899953666959445013382153645413069518879874131678066019280847628175151625326080154577441538492923676604658337609359115785788265787805820855290001152189430217925616213644005762418863680216779657864890576650180658629330045375768632683623890576418899114414346622447288e200"), e_float("-1.2489078921779315871061237659765428447616545648802802418587832065160784643617117142447488991130443698210682981479473668495341424650274362162456605457767510894761570932841627296885892472060621234911359453370149312407530402665408946866999436765640397810908873798100151355046574330712105685974463998359371566222572716631889700448043715452925071825834325695792577728367996771845267981061197349573306297354e200")),
           ef_complex(e_float("2.285138065156834574360770209404989033815528146691766373109983744018059661393256951642311456344692673580077000803172828173665686091755780774702957434684576329438884890128313845637103228398630081772674052826004571014701358030233948252747866950422792554140936522186002447336282226665928206232431232364494846736471056607969639208612991000069478426223980553633144754937332851314607355847850126163128318338e202"), e_float("-2.2329072926360753656244254231730475777859784990318613563070678847388862100517225644185851280770357849413332081722049899723217451113058017015316619693490862658427763207548855317921088807380148681218543719637225321923412042586607595293058114114911728912666008093016408128114225097592589210861662598066362338211953020348766530082034980689036177805262819106974804996191678249289349433136876870176037230032e203")),
           ef_complex(e_float("2.0511924581301049656140639111875701696734270343695818455713917491178264875025765058346675456657307181366918224275529479491669441932050553339345628296939405259011531162742843061079129116345445854059748041157186202630028283030914672236990000416898790158855904356175888281783130885879141863759592217288115113555554688461224064059389068752491692821465716635524165126388796300460130760189144394802605761389e206"), e_float("-7.792605899130623870121648062360816991492469043238344985891468133779013753849652890449527748249166490487832444324926625701786718560078828329627138755021770520884469203065283459096133202982384891462684399924155324467508149069928086870214142025259187906797153270170812159928882275997827707504639958658657343879903049535826066064044495700554466072815231360471155606397022810562693910769711635115089469654e205")),
           ef_complex(e_float("1.5997644784497256901463228895900539186405919180572609621948871351359009594030980536949360986143372254225039459462597520309956350382524380578051432854821008995454336168496653457272385806185689576915518896203812682770877803090721150419754101298427165990920332112297643675643159714235597996635327183931592387086484957953882670378153949670531625212611566274725028120492506675552110337605883658928572222405e209"), e_float("1.4687159298464321956318247482483691100154256592409347916287500715410068022475145302068932995019542863113171940629869417780420848441955895050323224076329163762878929441400819649653486003753890184570999559936065318520341980968299301373019471513175763005422301786420037332118242775746126122679966620115071600810495176946075061747092594310477102571343379228406804500834074731985402424132498367753589241224e209")),
           ef_complex(e_float("-5.965746004169044596684592461559775641924009197050998682252352270946239122953826806490691706560432941820448059071621529423878300793825588491886682524473097849919210993001043767278152365766482280393139247032515097437903041532994203444744720269389998703220653159830774336145361129464261432640903119881234662104582661796868152460532086421892944566392045342916506259188529191929134751997797596159771436562e211"), e_float("2.0924945689802756207897822676349365837316521678246739605979340975824429244521743366092180548744566814001966974552737644910945540615442369232019534709215769329370002998613683097735448439992233818215688873682529147336764759849453724150859911419323965562818775596136919988713649270996597538430256567480775383400532068271459272448947795710742849467037193134078832531704872739693414661994396166888980720774e212")),
           ef_complex(e_float("-2.16796161788252070570387965617903819652882625253705181921921809471816377025632220395320689040121183455587700606643871554482212541188249663682103120537479918410318683310336771971850959522300942707096271420226367806122281430029108776151876484860765099874006681184396562556970372106223050990822596633694658773576703785093906853671303100257288416302243036721731752978204717181618068437277436702000476868e215"), e_float("4.106898005836969809017770740118813686575199325580120278575999293253502223218582565023163009079131383274869877953234064228353091851204532842107258253127393606391993620197181971692463065253623413498089470037138408223162768743230725698754038559673590816586057963777564063219011475935765696349786563436635499626351780744343647226606522337869311054300699779457531911022700054009097330769460603527205507087e214")),
           ef_complex(e_float("-1.3742627662720720027498558850345392068919838742039616907858394616308420255380771921176042025620014230520818483729818245082442561787807285397388325438154108073090063486952859453857986879142757092571262767051463961141402952243864059918146487188465060025645061079503230876927948057726374599975792694877570252802559260443624438234837317882375136277065879719456864512014100645157881727260397354508931974258e218"), e_float("-1.799754065796650535888021465169332367160569156941568878939624882866525354177002010411543634111561174243775379281482735741656567987208160536778612856807883001829384777494058882937003188607949471109570897814970321862967114516226514882451395550059920055994323437698732419655972214483459954253899833294134705195306444308808393669747298982178223370418375000538185069982948562638202692881294730758347291409e218")),
           ef_complex(e_float("1.0307682434403817998612113605369045054044439714520537260791593120242878745981130472435899107996385511800292745890245735051610448580251052719425059173291595741721866357351249804907930457887467472525221709332321018274588466673496399720140025158145349236639321843838694027809194665891798255909843673904197611455460394876164644481111519682603445486729177252427853354955653553766567096344312053154352842706e221"), e_float("-2.1134883034136947403074370544733142982508462633421758012222319306960256329445364685830954295349882882510900982009958311173795762246996462737254838013688202795183825106912949400863978478625039928958236770553396110931992494650645486477846986285459802000266087742966752108439806521128546684852011425242414782575405134499119404846842979564504231034902953554404541032224786610171300498559282493725858435001e221")),
           ef_complex(e_float("2.4702596957646636378722713562443304676103729011608097354149374894336757094420919574749139560192829106295597028903263788151588354891048812038992253861766265522243586219409780091830468871885028106842347020795937920391388996653691862741591348528513620236846691065137357596318021277084622052666481211590636049773489760359698071075804912848573009900114139311936849446464212388823379274324782195671596555695e224"), e_float("-2.74111756234699561509823805785608224015689720195342579148163114238104364320603664741610138805920708212960838054929838292068383176806340258740172417638200285602580925654576772178918022273069747404479122319342776662512533694540121156903892232142708222977678251272134136391378763571357902830646325281429987994396972877056262564751302848424456048270215938510086911528201726219211722820093318246611267927e222")),
           ef_complex(e_float("1.20289546584276059771595019888692254369684293642955828230610493847845132284990048347224498647732467993541792698075018588508949136646252795717452117371196848556316086083867443744009541455509090853728759953538296479184986889485642907746021684921595467039507515777337455551907833357366380419107302166003426237776137840803176158003132164415106100445007242374490443837590232918653806945928190156650684881e227"), e_float("2.3336773898995002402049333144554352886867967618242606369341554436090959701763638499053797265784722738975904263621770687759552331187723287627871616678849375851327017605729570130296168971117890777718969205057461158064676131220405454219944420813989871271345608374256078422391478939959099274239037760088217325179137404671595201494113887141938090539235716286469737812495583351467050852390216433581944977988e227")),
           ef_complex(e_float("-1.6627958194616648223781432881820878125449258416907683034884587273229568953675949531012342841949324515806047990188905577517230857888319164635009226360049180336578263137049218430957927885777594393142898286195832324992202511966872805515717773081888479573477949752440953048185346198284858003791839513877718772375658512361989822389787681154234869234635188917970256695472969106748639427279931918612224980291e230"), e_float("2.2803013627976579081221900521774875136842427417363828005701193603321552941371306284460220443417951970915665148000636634888356367959832597818452648862194676197764686328328216210050663255303794362501837451107596405255055239538525091688282292380839239814059404618703575024757461929939731244617218436931285099557012640532602854041346567037229778352807878912245609911783111908290698775883318379268768259579e230")),
           ef_complex(e_float("-3.026168343749078241963964615058210663759437122868263982056892366815129558892113046916205807683319063359310014485433179119878338211600300851040028158361971859401536431815038458163095436551736537451064764405701696559541145295866514321394269807546937780562438255955591818728143527970181058190221972501933174314878182957338648911149898209716830738758700618494380099181584005127209853411898358026537176953e233"), e_float("-5.047456714724244740712152985940610744872810359524293229793986094349893445065712276787079117418852661731213700206183663659970616787767731537100066357430580222239495276398413831221633014726535807262276651669568063717616621654240882536079981918620947824268600373696198661295231194729798328330353065150189627588537379016586228173828703138826758738118518553925882814452294801084083951687070397294291288038e232")),
           ef_complex(e_float("-9.949909095358715702416338731254733896478479316563393030961140935583522020676293748213196877080415138286686878476929805910709232301127899183458024458916926241348563262238696645369834381847022816271515590477488574012522267438634275772083363651622103703995086758573938209163271812141200975283448173207419582167961715694418888513024392328693673620010291422783189632384231211362956052818524407074189582164e235"), e_float("-3.2223956639956615044709390458375532995299412468494194916964697047923271835141709122530125227980010301998674345434420243940482597633155185423377625449056874413431602946648854506963148702518026113232011026009751047842904660636898545545276495436826993225851646561129371914638079935576934315489707153559466906542815667467031363793545742100626319637890014634512306901109389318224454431956197283366473317092e236")),
           ef_complex(e_float("2.7059899391867066991926718104592993534033056246220115561904249146759002622690541114577695762992140576003849499983143247804141457769291850448924189920470471741121453138656469781599187106927118880221762709365067170269222266840691032042791145038558409166978517644671248050119650309969172018779576037785479382928732140328316202484924052531003873881985671585709297074344625088010892238832065916081024636753e239"), e_float("-2.5937408711175623601345708053834770352035653199700635345027010899265463519431359250282061488354088271970344328959341981295628108723405083756864427213900704539073549986890453434031367459083606528225171757385969325673895392373516827892766836795555524895148475144113616273702000124756560034517920704057931765596527976867877966459186359607721000701519298743091510321343633218547688462235549085296865092532e239")),
           ef_complex(e_float("3.967883603766066341994850980300802150387743195134670480482915941443610657360703158713336642190742019174524291544191935520096475298801124012488026855468546635768731900831746657332819508236822118318019500859259318976772562104616982725090151914980920953653869743262602167052889069791669170565940406870449060310034028720836062140852275149559101721431894657407326484754506146995051192936231648113828223598e242"), e_float("1.4119121923941866484401325225097875872405424500805035436981559472661744446493850600853377938448345018038165835506663787175869013357012281428139492883517964147819930666243386930112913808830942705813784006913684565324996566971408007939884297556428330106745460173287531356665588146487276337500921235551532746251331142654702646187567941474144053313767607349473227609590317757733099835424705736809355354361e242")),
           ef_complex(e_float("5.860461768919442831323820015666982435519117183321724724794943001340267233488460407571350347179047893288944906584218431767224544624503813870880173019419595953815418624676653222097989408898192440879232938683043832093943121105550421594450310148440614235042604640578378854589645785701801785952284329034958274112924584857168674119079762162399856588680159627808904409270192144840190688833195584005532184155e244"), e_float("4.7473572399471719864295076401040993303413421366021172621252169046355620008323944168201995758181738570083737683696725842917345633491010679004894099361108282370285475572298778399248836829609535099494565645862916029549709965107234880080509088359216778282961240349806062308924876009614970466940508573973582864496256418028898227484729427414264426134946167725771278057916537633291578000757120978087679350538e245")),
           ef_complex(e_float("-4.570350445022643653558491386124682145481421451089330243300733202973636025522713639062460290435793396167478993048246113887226236878681481853019402014601873989074170663433447014863062110769844087972302600791671932988222090470361351661405760482806495612719943856121734360195610102389267709858207973288917501111237999823633810607001361680823077762453552039894497457074158020323658194697742464229254579484e248"), e_float("3.0435352780875535766473850777066033473571335340630136539841953313488773033486858218518302654640383432727879299058197300359700823432738604442675349645862851584276437900063319501464352500101943998171664061007703999678933947604570356112081579554310057198576053973028013242682858105272813690338250173185318437110020388466965662641414789861669071015990484442879694471643384447469014621879880238980194690451e248")),
           ef_complex(e_float("-5.5323537184201467847012238534759308919838367717833078758474331480778282809241713628797303788738612893948576983641925997658205301373594596173674778827758228503007220835065622632948175227194586553862486419331976048003653402384134980125423706945155670071245727475495597819026943584660840673598198440556928249653183783151619914697243815528120026131776354006798414692270680297709094276590333235510976242765e251"), e_float("-3.1577596416689478833171792752897050749199592145097169600378807703687681763318870892289132508066054170272007861936019876640183439846921080097942127338455933999757124962938007443289953279116458420378756772938667868064575590843086524639763338452340704525268600305162456705081291719744037285599571886208885337664874224876070598564479430855415157402937869541078295932563176445667198161430174850445929489084e251")),
           ef_complex(e_float("4.032835009021367099261656950101630190122526908799123521214351332801830194612832600018007911701952516224779084658545253189035410690432269952564533872272426013324401278468988648075715787560599255843754440440342858110463050939827715716617299954228322906026641806913083282705407902705769386770548344244321390798786400556147561082801056196456705149614931710950585869579657853533643249146572380471048922323e253"), e_float("-7.4565678010309888514562306648324787576250418059341490635816645420580021741428143895401169392816000759955225505193261010902785928823126975694671616529113374866858621484674184656968570896769825891377309465680486378900375356800195941398732739347620152589312443657895527264186420385537256864297914521719285398344055114815215354206598217144369410612588243429265775739525868994092462454792117648538542269276e254")),
           ef_complex(e_float("8.109632049286176112814503469528684405797501544258537926487053678866948911767168035224877144646970604496079425218364202531054725825360503680227860629451329118285163409268881652959489198853467531882968778672908238841557775628366294184146159092112554084436178531432522600921988977656472273620164022725443607672800070733602519299966171862219212042402809429566945280488275125953038959610573929601275492445e257"), e_float("-3.530236972466660693504593993162120022918859842726224954610276497934693224304831713860836563336012838269185598673209985388861936488161967040681360004170299390061865104090425106499376586389302054840049951852808089826609839384286246843710492637657831967067970033609705178749084406022728478461075625736391001937806931035442918602731345294638734498126563797907762638063225147913716085630355421637456455143e257")),
           ef_complex(e_float("8.1244198976371991672330040226453202192271924377948990967171831856610471909129209148142374131830857301224082659474842214214940173282541851154866357805881529238153727458216021443928021833113481115538891638017296488284754095924454517523797907802795940001380193255897377159303465272011723486212272157463714143583440239910661982512347565209644895204247918822459435152083099245328196100255602091750387976328e260"), e_float("6.7827094748634254098279280170025741472897668891966874570785817160742892067207457746049372139036880530464862181774884822343044446018157310849527256756743743451323866706711221168673599759327008221025647566743897796363634313000281048956104018757987653406081206934939820761875390688973036096445177451035243409210372192079663033180863169703565775841885294523431340795085989424620929436559899428157089659387e260")),
           ef_complex(e_float("-2.9298079951755350673943530724672414462320905869643779821946797569685704272096936856508932583288241104621460218749999873058357570127713966889825589368327850414775337638392228528882859578172682467210441144550039928580618170672338312913587000991943182007358239129097727424291742860159452402930301868233838826428743668015513238203417823597861188396802084016639098326246967181818719824601286197243636303357e263"), e_float("1.24529846259241838663195402180081046712804075853638362244849401277681528368556399612241702751832111221185881888271787300347929620494799501670201721868128756848688037531148630438799331551946190123603955113436936044617949956585906263833941417065197281895568250523999063140155401156596900589382428336076714691863690428660710953039356946332296461179826506194807673770286882958971580293125354541788548105551e264")),
           ef_complex(e_float("-1.5195516372663014351141578399980571685360447681026169854841818733974968791623976685596774890118968418896954852106785625705425023469728103291912818856629470884104910544539283278094629507802145997108924832185645207643767868888711715290712575037820412505974094992902546388491701624816035699153377110243475796815133308388798208959416641223007244374750486412345700933695538769267321673905591827819947816684e267"), e_float("3.613795301670303212307602445200458999784396465690836093860596341160662503955435234572163522067220215752453602640864127274034154535191757795580287937433362033672623233976513597542138119379619198471518047228465068393581750935317051890506598260421991421908261121349454159504885610012966655293634583511317225874596598222480806241942182698101529359961956244695611189310811603329432378342826644326629996409e266")),
           ef_complex(e_float("-1.2378419948456992052998852836549770512072731350831089913668494652662819032146445037965860547032856145833757209418291709391264908892387749729565325277846533643369734285475367729271126901334315759936810641907185421910599870367151349172767386279303755841900761331964400575071589405957931706152675943120283535788711846532924262970648300671734575831182890857635300079208453156582113760243509689736555655968e270"), e_float("-1.4755526544143745944946408833311548156778014297416558154909988403911856832621483477078904447028203714943055213601550882832807716139728484536074002414457054225855031027401952910312422184580759224229463724102314879846329496935938793716698966972517741601934337116325119395777870436809839379818833310992834594700822960492235623664216499625510515582848319749806490180461001882020919102941073586154657997954e270")),
           ef_complex(e_float("9.52200819462735943063378681245612974153969156697730428689988091162446678469323691256614141013320614686821981781555709426919071754121218159620988177245188662735289098184822521252489126405520019848383106230894056126230587320367631287494509564265314092923212760644246466593743152903675759472871819025332848161148361251194873051683081071542846860886609045698209505362107340377321548449670110989557964644e272"), e_float("-2.2012570442730452253463306760580723964550775434316984947359024993292627948526341773414771984764667484822940180665318751437294104728699719859649800032410081149125580514241078702010098231126734959692343953805543015671059127204575251814553619349355915652416998633475747711217115359290032074370414924458551473406363094145496662057574555942948234872355500480883963656468962301077821115435114019024927315732e273")),
           ef_complex(e_float("3.0110103407538215052031064834034065452254188948812740986778468170892560005299888379916094969340424122843600648474909881529749098043362985827476884506447219583406642903447239699733751752831890083801319853071382999065096477328517878633818270212370866155656171663297443075507241613963156920306322527031614380514340526666050546857431005702485181542956217683096934814124292998905148189093197844900052120128e276"), e_float("-1.694954145242739238546288015350609632354810797219868178700313449493045488809843376101149768138128800547490466637013838179356233840821434317252361235669483725443717906133797612638782155698074447791747809700958790238003407123754841762883167046920193752098930640790173043779750870549315217278010728516701018336869724197660837590354887625509083656233925273523546230128857845921558436910359294608360619978e275")),
           ef_complex(e_float("1.9048277571719507059109690813105700570727625290979357557046616343497195936211740962229191343988054566878855860521404262163222999425660452253861835512778708608554584363251335295449009863924687227158406017818354030722515172508822406288499344902566043692064932138244520012722070989261855828069045962115767668110136045196310974330138315033477130763857445889918856974645367699501885724309377405425128014429e279"), e_float("3.3213403657798413532980948452251702103066674132885180664257304788184200566466661931534424806069189856597763838974842367474083090091233840345746816976678127507206884154527356358779964652701009947652573255688633363693463762583000869374322984030653144466416737752016150571829755589399727153627247838156530339330150230776668832428049362268269514384417830857168821043386603009543649143570895044939220869821e279")),
           ef_complex(e_float("-2.71246901009973538046626309798692923380777053618738014428536063817875714581266393130486400385166074778794875703975414666435001474090212526093164756474850734260376177005283878982863784297487733755033392638585440641292318574795880077919798720960692204348503152269742125122107971055613173250600046800376900892697139442975231423545155750424781084651924944604616067217750157460688335644336526216604293372e282"), e_float("4.0898334237820196605839102228064771254411053794470283723635058333718479578307831211404352460704680180415090560448819377482341233061961619058701079239508309528789243524684628917217873294502702571496790209781553713667230003378283067976708514285720263647130834209205788137606595740616150822771959100428247077721104644975487111116683774379273873227065916083454599642635994864148616378256539764782771209662e282")),
           ef_complex(e_float("-6.3034331739757783795843991634126751129870465233269368111243321467564811935079471085579193111611156798468938792088584955469246944305362425464363509209076200729798814203050736384058955259310922226495277268113157365725960105597987201335943494697461807688179670725953895879588943595316850273606537934532904944483588783852515171173799952097618207541271711180509701056540283534025837430027395880263339250086e285"), e_float("-7.674997583905020697827060847514558029202653520496486318786785725045587665086945723323665913306857002227425545220576866917246275658367576164890365100770844700803001377527986744711980553855576212782590702947801787535885045322449568064569799477938014110234423292064559960670846417517295558272970400812552092440819838182194836012269564206438003617476932020266066175777947318008988207999490625137493416744e284")),
           ef_complex(e_float("-2.7913942640594615674124927651733858571789967008192566724660048134930105127050827612815139389576482419945301569378473102200874967833980487286507060581097030769771528573879215461183516663135841330595466998363134557111321839830064316100785356489337502672530939285776434914391233903437965034553238580580362386079416723941980106359174930964805080152315626856871757591636056481276634168398917389007096419353e288"), e_float("-7.8097305404727323771476830685845871919211683458781017931355928912126509469094579398263813210338765008365873327535847191216365222969138422874670039967583586282357316830402898194175203304588778525188973862576351248931489306901487917996139955464022690189223846239570937223301548710982952433090668420531040750874813726409469736363983072700358981899210613000248242238911566452343424214339391142298347731243e288")),
           ef_complex(e_float("7.556502952845255988171641838752762063609167971221690061937098830718590001964879866732190620903885962278938411543418609024993965851181452970371426955178312940347735962842360056844305519763242007112028640457242165055710064567794886078104194923731444535264879629648620861243294266217383098625447505845900831476387995724760050722243344542691239634482718901829678975944425470665753799064164537939944722334e291"), e_float("-7.9012466852689299816279845976055562175429702459245819554442285462378423880576893615480236033457916877825622185761466620651993388655366009336469556142102767531536599236233811517394121313871013102336086446885306645214226206163044548678903158319661997446546063225110769002879469146431288753275873259558562820123658246274597830230566233117556285864666180893641198556026004203677380683261279102647719363218e291")),
           ef_complex(e_float("1.3901329182585909794605298730416804894166712985248526622568099878985488261614431422160073431240862596260494397186532631512840222796991404378585597190401092269748152304764951834650761475700393354156451399164263910699307034113391015257427533195146434891010531380082407960337337576068550088602177966704040072012490652784824650080587714761952649802541884039617260220970526814896750132613271040613211428862e295"), e_float("4.280255776438020218230837589454062066923877072753983364539289329105142300211892405966954956829463722945880238928618040849355927425816517134670961628089207585452497448082109039926913153215123819484852119782258573297513989543597824968426743248009148112093025196152730849769445648208698600405157884569598686409594729560159789115925649933458419635013447061137351473917887024950976853923107019577392688271e294")),
           ef_complex(e_float("3.221110685012350910326244910225143744472593322091879580193463293445884436792476619005458956351260955407700319798861380820404511204596700453660364572711771855238234693323312535379609188912646734362422776806750955632683911789307703780779550169220466847742453003322889603167510820834082624701560882753053868555554728341135243531830032773132755401968065165279063199930660636779430811001298321387269640342e297"), e_float("1.926072315669765617516291398889936662066199283162648063150317302288612056314464914667453782002118079840846795221858264685969523528755955780821278034890112835900578389682570061599180074935580086685968786605920535027853926468342092357012331485523047570162753418999594819922682841050682521905176522820677249595786493804516875751662251316179420312185703087642058308027247153265184245656273721256042108354e298")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_03024_z_poly_chebyshev_u(const bool b_write_output)
    {
      return TestCase_case_03024_z_poly_chebyshev_u().execute(b_write_output);
    }
  }
}
