
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02126_z_atanh : public TestCaseImag
    {
    public:
      TestCase_case_02126_z_atanh() { }
      virtual ~TestCase_case_02126_z_atanh() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02126_z_atanh");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        e_float ten_pow_k = ef::one();
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = (ef::euler_gamma() + k) / static_cast<INT32>(53);
          const e_float y = (ef::catalan()     + k) / static_cast<INT32>(53);
          data[static_cast<std::size_t>(k)] = efz::atanh(ef_complex(x, y));
          ten_pow_k *= static_cast<INT32>(10);
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("0.010888039538300914462425507513143383837824511575385076739857668315499899784671319582947916281886760597154556685543665676238377231209119366949000327908715118426225518799515862419094593477367150728963907411241402074637772892524398011256330894959363082796814659131474018474236459346427379517356725658593433776842700009807759783761586394472615438420559238990389725959339461828598853348471511459006217050139"), e_float("0.017282698270953502931578076701349980708438003646496704405385770647491242765159234023194590894208343112063781488343727890891759424087557358169141658397508968499614694429360752621133837534708981665699708894518252091661107088448011272503512220390844260249038992780939362395300823805203617318683488079802151799918856168364455745823965602207898676005042990837736440452947148198824643074064881544566962905968")),
           ef_complex(e_float("0.029728667374323112898024835938496450203648814501710369102852752639162115157813582586665124359465373491802557256887373602635341926957744078720948792982723913802459304163490285400735072164382090224040327289620354487679085666957720685463362311915479384917334976935456615411993725428439513479573102018847274944766279176566343500172179772635331342240901084414590671910400029408913999271301384511453596330801"), e_float("0.036166517821665024556505177607300952792226612866245563679670077095650790014627931969428926817937649403485606205911336911758103771189359920260472824013118993856952314438436988238243193591137826911740678824720755308173751894711419505331300652245329635279050677346399405670784345872767625129832195569340784668390228363512205727956728037652797287129552911826635424680452494766295203449593465299218672941731")),
           ef_complex(e_float("0.04851764964785241791896978387456601904397083159776519656208845469683132604945341298352029616276046499787790017621311176005352167656603183654444088189996586750207709760610338171303686688093577484572696921532071633117101865554486119584175934410880725939970030908690064713242445861798766125104637853200026190372881105024877468273577221142012741181315055248214633441236324916717059172361657564582317507273"), e_float("0.055092419294046267816218781821991675471079247724202351940334029699821644170048077833045596182165267083969795812643169602557783325226550361494415158802969424770957645874326784737150177905849418676067994277633416971666954642723403111017642729420186932283114583642529431992084306677592993569462977958901095114438903534411145361684467839883661816077448474549537659531036327711195129022334596747999703224478")),
           ef_complex(e_float("0.067227609609879341246012409061915701674193219793455891156179985992082023871865234324005265668018349458144538900038302964243766798841241056366973083665787298987934363516408861847432902621063822569119078404413272462608149763317176141300233504346132472514110164887823788945901257648891373306695077497471756582346273688903333614634556212930505578861323847650837522748039846698668242052896274399968533652635"), e_float("0.07408657372433695273954779071558877876655911708961525376796322286279566085814625876268183030653109102355192611517373189344816527177741545226916352580890946621660433772885346607361214663540868143956742910591473775794087469281789200987518627233323728378418509733112827151290089598452849769475257995926807955801515400031284328980626576061555979726418377780527860406144179957866781534101913919046984524564")),
           ef_complex(e_float("0.085830601398320394302773763667666500466445968485322672682477058090801820422428087140852345486164877998654680481101993755039078994942591380920590558029115216365320372537043520636758469808964786408855134690095088841527346244796923107719477033973685045756281655493978723615284337615224317142118859141869916453041979942241533709734453955828746197239663740745697244691631997943255682788085517636836593225765"), e_float("0.093174467515084213702712393261021533497930843265367775852377306858181263666442687011542872019924169935629517276652171691339569318248266582568550157937174893456623625828902637344188397181942684626886736096433691795200848631352327061399498775199786301031807807064141064517797214961946985794702273222469222203569141700638928937136684596877311418935066984735867895591477984717485010288406233959500064874618")),
           ef_complex(e_float("0.10429791082446324593184198248789985414285448500354116539868085290448978339538338039927930089295280675540152148307533655331569883792253030512525552442914698690727977084066271975803752103062288682851673577383470340379426185330758164021803828076222021713588264380417371358150882896308708654450738509842349163992644898315822374094099800997813727134294591906863266453925348474907326891823100779588392522319"), e_float("0.11238065012272520073452320829186946617691188961304890092870030951264656598766505002727043644341993704722667452141880916598929415535031263906144815189998040486994517347190003930161200260467733683978866472089792384271343228478696985940133685846943366867019747545666315279596744727712780772660879519595602498639700377648038832817617895383683272859956679109710623475133064260098937226062011241323763251351")),
           ef_complex(e_float("0.12259987687815101721348550285500500376204102941292858294333894253671366156164563943636138415340842268664544089700123445912718445775505036798931273629174373398083142504304730929886702984562927620467830934480432124950651308277664482193855697132703192984531223184583916656592631122961129371306861032834697478695587377241507526067640505947076920626227104260871354485155411784215411391487802904727485670881"), e_float("0.13172846640896352034860224613629974894562263830513815963136950875435500048222399425026848077555103127310107561343450935163145646166459336029044579033866201048880292706877716743337294331576796558375304250532842648485923253516539295942521210062328717896326772840454724711927130201364673050041205131420886153220086017439334434436405364068492091827084059717281172409060908141105089117071977360808966988986")),
           ef_complex(e_float("0.14070574028998813029273638949056520835358620435987175533109891374191173455554413910548437985382221626114818323060055664199771777318979647060332999614242689900197572539718078401687257910270036175303285496007545034708495228345371567632456846937125488295219709384670751835136346787460670168495841060893126701044773734961598850691032220302006339904588638018125729388334851042289996831569516470414048939342"), e_float("0.15123977086413392652785999453649468063987227088716898450335412902997405501370331243211540379807619175249450876313326649979887746472246998062547906845043846262130801702356200395654717937916745153393608991796544585882685054069057565970664956353613790015060528891330887622129654784331850697910159778392320909042526428693724071914844117950726488150032649150628097455918582150047043080898250693783557010138")),
           ef_complex(e_float("0.15858352609470982178770295159375346372818538049410433939530566062783578202881536047441198113764458210648998389779954054300263697130648889626348943664530903249959596485866456249727047085243549762554403940318113095809165005640588950754694781848313807734291120377719960858470614955602118509710757332356381415731592956446052792809333651340971481636308242392220109616023628556804641794594225207381406591616"), e_float("0.17093462205205492461085527360994439331097281419883373114316271427068786377139126757866583950268252636789639607120737332401398272375341321370567178754852980710509658538241814654475028640787436967081041390511008708868721484628708659678106615726506774885970488886847217910989966576277318270758011219174968325603220736236241286399923695504837521239656672395165372200957194071947284797518045525393684279355")),
           ef_complex(e_float("0.17619996772307886271905085041925592908803153637194579593195706026385724775850243442233606117310082199908368210701744584776493327667468828018556089416376962604400242110186763956138543535652306292306078005189550760210035590130904290012811475473595150969347251096813961852966458258294993210061589022889330439809376888420862576866036872974044186611499880355125551903433817081207411037465500641477970819289"), e_float("0.1908309570759138668026883623139673103280309492865882147586254980874017450060526984776984049142820634501358189404597007693667416868821422472031487312971871657130294687071091723352666220520750183193326738507907519482127181711335619710052128940817928865240566199197272349403484881769008513654016228037667800501367528782763124265281258907197906517409500340253160663870537554515223565765395290784921079853")),
           ef_complex(e_float("0.19352048061196528398804606343280707569177832673759113163186915936074695757348050232447646466142081585434764564423671333528624048724009322174799530714156518789045764929368428572271180440635776155557587440836677949137835822545819987925579228044163053405228108837016542155542446707199811310661451857386651722851533111127124597014886171902864273990373027098667019225955032257878595801480190855770208035833"), e_float("0.21094424764355408866084598739106564824674119802011923741165886416018382744430295057561229469254482318293865157473367158743146688871748164513904990718583688321955592534851855590418566663863023696694198970771272728943186709925716216500975121920558177979909280141384243922618629119190961198825668453959078065190974185729441572467888182901669647129264707091589665288923550933380733078870697028984054736072")),
           ef_complex(e_float("0.21050919354446692098076582103642102855740876508098264443058843470205774989747037679677780295016676928232917166488658234443250602410777504774867608934636417317580349658183950734538833648466806448599043146205627645516592638033232486358661500208298595532785805820000352327034806676410361956625257066553524197924963775828680986485201590022360682782482434302932549233234456765193808342243419877016768957826"), e_float("0.23128714141978478647846944447468744004424350236692282752245142283751092536746147065331704228714066165369271992793346935068283067729195310438224535791704612218539260567040683010421380869554651387218531739247036780228376156952504308168120968235408693234745441044586667246452379757310305771180643561306763085301842658901296989046993369735659172243071439250059231219497707184882149646877453030885139413538")),
           ef_complex(e_float("0.22712904577707390317091001295698043761654449510993147928269536641438870143783888800261234036695790186371466869883662233594313332744697831792729296352104605701078249283771922433605281761654643528225724896104044186187239706561103750125617523727953064971564324875714546539806354079545457232924524939607737955369144881339275836681133411663737308984681679764406041016690021315835272961048762252670452542219"), e_float("0.25186909476514138877528755491008763691751848649687037218050465864826016629839587072166221886561479730661921068947882422417186568088541394290660223306882940370796464371030224609956752079722479798101136169741144956145344868308712433259952689286292712905081591888517664826571326087774499022881955186375077778460015654998089849364016400698196058528666972783946838261479871594794808840186096931011811217289")),
           ef_complex(e_float("0.24334195733148120150723635300930572640520638136948905825945226121637618886182753643165336521283709778778863405895045462983871919428042512828270843704167486637562782765117886131590662232182916624592973906844862826819601521060187062467309927549252885279852757877024571463160750498720152449532655054399254832059689978317810106239998240950151409994231627305945308912067520157284864156277709110901171538398"), e_float("0.27269600560565332546532335521826171921675136770968759844904276740264318154767514043866424399014628319987935811513753285307475296368926478418749591988990319956460896517388185754133140148699556057812157857754958294114935651668508158655308811457610595563617842578691780022617266458536523271914589070351789773156959573127895980329498795736784572024173475632895922132889485393364218016428803598953247982319")),
           ef_complex(e_float("0.25910907847937571002577862823864701117085658234626539867801679389388820046695973520350049311628469814811315334805151547882094712962947724104695319173258454285393962555445746009685450806343008061605452104877436897187585534406775092798827255205777031017783523580363372344611249645550853741843785913855204029389488908591617319579023400342725099843074825348976195070227244224727210916359031650869275139981"), e_float("0.29376985793503961085560048657950780751036671391553032561583212918708077273108756630740624996790934772531798301757032390348640752832800898478089990440078246053838869748383400920512579564722969364258489478567426545295024330880718881347547645226494080347112888009264652493269658358754403487816364098516674231022369658402939289195880758894532361864549877731308136238878399457192772043568469629340106247521")),
           ef_complex(e_float("0.27439112230491615498764673249417978917468091562003422852795705206281404420770475132623483086457608149621257742921172822972906265513794823028410634197777198105936768653779609633420916068075760233608732805526453748788700051484208664418762272797249905053828790740838384030017908412230358836862938603672734453863668168698645267321274062036504872996281925582787929817928983343729001041909129470782998981733"), e_float("0.31508839213765447425198468388702662411261169797863627591196876975373953651812917310764962825577482909829409785791304889268152228915290209833835594837219932513755960488264281526679209748640001818405672859956239461327324130497702859662569659583402873765604596661439218320486290005988426629805859317137429889439321117596431181508747456448754924602143105406380805835477201524351139007956970068427310223574")),
           ef_complex(e_float("0.28914878121257350433123936024690760633576339090237384243933241799707946252086323245504493634736134301567412107661069667981534575887042689547458621819353313188766935049297829250782076071371642825820944733193165009491991581271285522065036217392154343809331919961116610538973533550631583719972138131840125067690334855322618300714223324376675741266733603979088201664726704078450673325503085300253568354225"), e_float("0.3366448176942097704759768150852570309233596696901125705758042198551087875095439351053369247208202027946408674333853574271284529277448309451615107918681805043237818577307101594084257969438562897225073611339571745526647354651135387858395568176087067164730284364374162512182503145446738348581623913318233011430340977151963301847620655668192002082109897007919735921359263775702126626129292700800985668954")),
           ef_complex(e_float("0.30334322435208046679757049461240711219869544794463246777874439431419793847582699669873696541694790220806318525602637817967066105958724538703942603474756995599953630940194304381412080943972924320961503889662271980356667503401307374781866825906591839724800860148135468238807509409258910092409424317604189087632917815389398244374208699555544620704220137084978768833856710241519867868854807412761034722172"), e_float("0.35842758659635194484246128052054700724425486393137050196825466213712493960964392653742747176975072211836078938444377905675511312199206475682470933199206812319038950232719248081200980352600493273841674141065287203485247386757474696020564493635445588429352015090194873772052023763632514055255638310244260209146703095219191597560655956295980452198511370710070291661121879655940770241692265322276667668326")),
           ef_complex(e_float("0.31693666825417901655582632797534969215139024010479387223230998209840270557632975184357352121492081456754875576381120225810667273267471932805825593431846607245136189099260536706352865315158690386913214441862735600438725415838257492065112303561823031433991453047409422373091538625336589593064831429958310484374047282582274673379526072310774309860064902838961401784430734381123197207426132281793932948037"), e_float("0.3804202466220100087529652043041411254219971008860322895821758768107669905064268721594405284073013773915022325424832570461783393561011610540801351284008949453739279696293454427470060795028894427280273400692905863060569806251297029328663617077998911458531419729617170073081382531046379984427363480468044670827954153174597480109569579339214283725161004338922262257997622426090338111716203510625310107457")),
           ef_complex(e_float("0.32989300773236325544111417801647488662137470146365025718736482640557114612609688371652682269399952619702154801742352092635961290702800450899539613765810162171328326171566458438648937812517610787387622805902508307293669235036539652018744616684629590562196324613229947463883036752301154195640369965800150035302002004440677136749643462500267891333049402522353142298619792583540053797699853384859763859586"), e_float("0.40260139318592334664474984886833070029012387623383667587349687375461162957493673820738396743222886104797415161414090844458805176203820365671751423807490174850900264119354312701300013940908234708399003939251470355451523173971753598629129702450673777550373689955075783099207429898408832266829637108915815064981153983324246917105452116432386816627543345636424327298448997101895433621953535326758602083899")),
           ef_complex(e_float("0.34217848866352458451593965998160175307613081356817673748457225622508820607249031260413562976559969179799713675110846503005130060328342616616550142934507748452552026956484091211108454385897144158652452201840784854270959643977173419593173431801880043102757394617926838661657581051945149518973915280884713223647232672765435570450812982670967510748829149559402778883862373348592322325329540921789793787638"), e_float("0.42494473650606635022513355182228975432474633691674903288025437713199180977447331085293492860294211983357843174682085145876086084196868473848592750977473269519795820602816357492206436393828325124211707396505925703089326251396523774988317214961650142504741693777420061005519559751201283251922700261177448483757224471191390123506814799668075855575784874539021803589527251612662956626343054296780279624193")),
           ef_complex(e_float("0.35376239909550996794260671245437742151752680935677101382535085820683865063355386667686716163905392108201999201794824354917696011358501962472112649812432580598059354839766071585239969464653717217522273161614213501459200944426288280179729090277608476353399548774951670913882927360956940210161546755090971156555882593783210418568698807405177563157634042875261852367926947659616191950443309282374239633833"), e_float("0.44741929715365714826470094106679685347887091636972528334419021900881431693906444243866020075992745573555194273633733353894983852290267287735169249933923051775942604711821996061540926051582336294093680563410506002352942403278615570315628578497232555700287225624631048156917271991667743948903342261775346806336829204695547183417563074803751001221890000872539454187275945556521461019330202478215988919061")),
           ef_complex(e_float("0.36461775081161503401602670648801820810251421920832255128059078085423370769134757292487217874412121567187670610007024482748882126824930864453637395223246883410261625452130162066501569530697605231388166821685589589505487183222399886508692486454016789436356894803830224054951404805499693181279372449110456923725896804529237971511888609986001909910058138054906130753279862482993625115181143313058280240065"), e_float("0.46998973768549200126548579420104925484277782702641417435478379280456288952161856628230389223415735398020083319600046440918200212079685782052423485592635160788413012924038345578486041977704190164044865421639204637313240863014832592346090613587694596856859554383934287230055194934262369718881982856851780164009660471852061811979455431222525152989476356075097676221773507294076550914602487706266233313894")),
           ef_complex(e_float("0.37472192060540955768706786708587808580781642531374784494920965646925268978176825724371026859003134576456293938531293626603046005275926203044327934008082058540562430124474818208537059956137872198626887878964578996928540933006785344682540286346796919651043095046414624829774795366353824349352199020519170143798827412111942331617153049851134575068438345728414711091588297983793500451824174029862646771305"), e_float("0.49261683120642639517994896889067675606471578377641537398747129873266477894641216855964100906811986290755541909953375743225955408790074467317304845256185771644110104123593719019104278968493383745639462154921470866953677295182611737734710980151058814494777578636221769258429842323646717413033635554724836210743227983745303270623532737208816172893347175781610416541964082093366129944733605797952920575016")),
           ef_complex(e_float("0.3840572196180859614676989786309683320960865736087508135125056094824724179283492860201703077574327161695140867682631974290131211171722997008285247131526038523387570580898516943866119296868967492708350529931748668055946141186094753974297228657753847068475042746082315683631060084114518500175999591170987966118474156181153539687111934977363142808887260098311649442121990376321621014310810373372729825619"), e_float("0.51525805981873472507269167924450852576199963049351655817419110849449171945906219778117296193496425046954049889309875333486915538092690520228036204521666031065903540569640515730476633695584615283451637872347539998196007248589336620939149662011800564761052344972088408063965569702358412783768909973808873639546416420933916151816281965393021007156786251530872528429338707548299984496340716646849026649326")),
           ef_complex(e_float("0.39261136054347836784348625711899425179599046901899582808212653862443320788655442979134677769072168331022287938398000756561699883511273978197134206879549452910894223924273619937434058259056463765287065563107307956581475412699974875835211193117770497143914189120400152391935684946810319457076629967467463485746720420409760977363216697663864555210319790855870738404147207379317358723771096904400155654178"), e_float("0.53786832763296172209014220200470326692606999306027071743396739574108784950385836457325206453324491205035260612198579411219212643189965623841728167493221265483952798934562089086761483808378649470753227997496010532985336403444152114171765675750347714652985054259517905755516368019515197392693474735121851063496705407098014407444778658217440499122639312679073354945765514595703600561141067954382220411516")),
           ef_complex(e_float("0.40037779645040254261271048318210800667224430028705176665204140432541903604653292897496218346087557264336977982196377887463044989966352115478598345413489474080038919559495263844322125745514294701297746737977581888852357045415808111661115933338435461621196051084012354550104893997070213387958888059038452151769933345676542556583499599076241066868376004265824342757521174059604580459839080043361576780588"), e_float("0.56040076513496962774041968761165738105506206742778317009893475689198698245840417793697678036654687941977775197629401532185144767646326029517011412099237231415552452584292848773115683689174460093207187159945750655643872171714942972056707198139203692840620583202319106614066037030701385231175095516645561517811490663915534438973902412638242971565076784938061313751221542741339706256303730003486850409381")),
           ef_complex(e_float("0.4073559112474618477691504768859998111473370617573367953207050434076621456653161756201169614630747469885063545092862546126203313793430142853335872777270560643427883846951782564099919869341179706610305746762782241942350948777744746749161056078114397815358758660871171630275768117967104585061705815117236375555175900403422874926425016028246867415234813743418837917065619067523046260099404773891607303151"), e_float("0.58280759506247431305605786503671631230576342334097152150896691139375611525386638744380848091151003300958160740122699394809654225830313581335279180887740939117261027909278857389609792442044006782242920812972488050256382699075485331139557454288778453355728640822585230309783319456204478677929732982205424385233348683986105758744692517124416930226218375343113403082411867806493695060070854024760378571807")),
           ef_complex(e_float("0.41355104995376476658764587573869174645498563921577732172657802672286412666429028462737162748349563651899495202215856462024657459537751331890918690480879212822489351106041862440818057456937997191081238097313542504523039913198086600248531049655329167838898773839913227829900008977976257395936939764556023863184207158672277506773352121399266492957450543867746699467416942201768276239653319790711167673321"), e_float("0.60504102529740952607571886045774910419968159205316648710934416456099002032518806026735768512724325429404987775025024985655891615732695968129342295497623830179334871761897715228217665347668255890220887487056885282813763045709592870666624267756063940459565609877415191499350802252900638642498956168288049663766380477714650340633780201424114520871690221620394369312196718597276881618877924480049065821327")),
           ef_complex(e_float("0.41897438620989290598568513015004813278843785187161764552038532447227369606983284228377043516609836073789860821187194082011369783022103261249736934366799135895981583281440066861664313528700186460352921506104344957153918040331571199163688537498292905909446322989614503652940481674200610617996650461212509606865438481122368869928869084312442936874252293504595831809912138595532640121324607736770021328348"), e_float("0.62705413218155875032882715121747985107513575761234463739581323687456561762481084628273031002045948509385202035374714937083101701585048506574534676775331180398340027204339512592875670506689555980647321245973801641600013367650143397378545229630132966802358962007134539909495413366667572200461923360205690756603148969347701273291087412023796773382051393421765543377539431403289061464944041608204962224974")),
           ef_complex(e_float("0.42364263397126309782489957738779662740964184686665475333301657096709581307150210537374143427149274133061939972349319436126762477253472887860360655143770496162200670113723010794638795851685977917779828434702643433347682752382076085432311339546577770847613749153463620535284012248251097545014744224739384122898604750787944938266346825009291405192759692763282051831563616979551451745388505095222715502446"), e_float("0.64880169836890489557336367177410746902319976879606219828765836039816300263679800961066639973749232490205818091973180003878585424682270174658655130220936201820101380854157419304086064165796973584838486872059525244315538476325017572642436161844938828730616435454385692081579713585754504891773609950527364020130670005997489682631738788438202061423066766915113182237729325174168451593640356134784526009974")),
           ef_complex(e_float("0.42757761913978428497468604874667738540467065234637258645551981841964803299627797200262842926802740095457895708455189976675428181157448745099913616613838856190044736731822279243486012432869777928704307124126250468089151545172974056649084143097429157056842686819188094796107645095089421339242439796676110690547840136581721153073925695303094865116377499899233180387044263277870487363336179389131733170327"), e_float("0.67024097275416938040179421297771022062074883410280791965129032961189124364490856793670325289586138199378514003335102896758658738579274578101250408972754079913612593611116669427630215046596668713341412595576545067050273663120229594306313137471567533851567197176813096956818531514170671559641496448431303184647196373849641180359640682605520127642611301872688653173727760780702715321022553296231511775607")),
           ef_complex(e_float("0.43080573418067927678182723974081376842474822763287583357519424308687590453223275141280789318532659338815188278585699548083529508524741574616708697882426245948841953970755871414705818036343634863134426520452435647029999307068473306922591170913515458505836080712329481985370309187418567063213280993032775810944079938230486122492146335751513232450387262196036689713940028426645170485168509426068132547375"), e_float("0.6913323257514414273120824183222035601005976814321294420242648373295211642246586371523296718140558403736860679503651188799113553079084803811569023066404384749723104501576635587589368549988707904893171451461456495584019664665968924454127892595947954271762413841468016553772004827804219894944447770255985787878455206083724480569134362342189409645619891777664600934557341246140045384424487250815679019496")),
           ef_complex(e_float("0.43335730392947925279578872522031350541537087664557157268910578296456124982960018269208023207366699613327280217513236600108945432440806267637151029368787713293245913490273965210705972531290480990647215331885248173006571888587662466521597438043600877934311958915166205206197179034047044182018794378435359902233215543694917275798909695895950232061094999316639499229967336210590536386194069323083527889364"), e_float("0.71203978057285162104618725335661923085333400261730045120247102893084510057771252397805159179203651646114197991657473898643924869826697363220712595936167219730543386837205182919640905304965656936509881153556006290835095143357665255122392102684881270377233229482213572884708738798021643259975511236832845530447834393863840022681216326451575709074517685314233631574352110772830800613840113865664859865526")),
           ef_complex(e_float("0.43526589350099978511562224181338964244420339418136154990022464116973002591831250736173263346146333732881027456619928826809932037183731826144749814888276107123668230480351578553151149249863953660853575142622921407765896320371718944591973363780216585591330495565208742771791279396763407825248889246000264856514653728206380232076851168131228147986862551794680258154194581455767159440030613212686484657604"), e_float("0.73233140936415867853512075527703543207729058754722478485619576021681510774675708901284732521484379726375915175226214118287748485177787290034387583308866506526601117163036554596518447416180367051832888811919756669491355150331213846444188222539979851256041473902559825811692748490217506202527208265017154404124330056375944927787432200355479393125729295844310762931576110080354082933331798222232554031381")),
           ef_complex(e_float("0.43656758945864714431613150868267882168444382208401124719586565799877601020605645336443575201883632146747483947625065880778108294325299803661668483091518601147367457643099936543968551315247634825733511751140450185771328733510577065279408288805513679933134675031498232210359218678647062030418066962114363685339034354831822861315784201855537752130200815406367658899938057486173164788745306944418344341947"), e_float("0.75217959126314776343200003914201268007421528617406450782466324474083168023608045161008013853844435888862486954101908305805521853227505147219803126831792601859775061865755486050687261300723555954327680292111895702994246284302985698881675816282130040462258746837378390439494544342675283371244008345100484414808553295521762597289599971018125328386063629772059251546155740282459362977811767906045697421024")),
           ef_complex(e_float("0.43730028345481381420207043059961781541764366427678475148105174597062931263709173674811784103354047668757516425534576385121824859872261202304160839874066263276640078746248115679897706149905669144346763074111893153575310581607136995233345727005400242567204037694774422253337987053418824244146744782562102000188024551399761549464770334022663278435414079333696341965623656813486833301034059808982349502142"), e_float("0.77156113692607783788714805825745506318773389651497993129349533823879677865098998128431558079666023340701259292354349842060751923427059711140354466215087618812034928429724860957271360150660407701315611448679296627372850365063651850772219936768411042238637388510500657593931617525335826477602933658118093830523817505622690085748721449801102028840550673938212551454553027119107552338026133869472190779682")),
           ef_complex(e_float("0.43750298387898469775351586593032653731207978821052421682577047389175087305564761233448146335973933407031070217320067080477633761070291717673470470640353517974242324893351241125310262914238151282416068360677332825610774257500227820064923042880211264289137436565880472622152648938492955524937853430409230051540015109450846624534523547917794509774989732205832283079448649774323652278079611094572878433421"), e_float("0.79045729026590326817322038265822086382692983527566172803574225501328045457132642131433332445669572194340900147813211097907023208038111580081595268043404556578320175436204083226554589177206687145879634944852315319894560282945051707250897791477351008951514130472187487199595627890918595739866354824884860909110101387644397483379066350945742321263617100088976004954794764172695464568736913926750150600688")),
           ef_complex(e_float("0.43721517622558489571981047557404677467258321338122222734277817883876612733450434529581253562253974968548325315951617143264117469622042583437935055781587668584257146635828729455597261531786093244192631220527587454656447200719985385425522011208087486518956314197473462662937414593503165448618089655203099549450590398974638649881382705160468995220637796282484852264818845653040378464491730501860526459805"), e_float("0.80885362273524549176325351978197527907271720853537073527529628901215540260829712195176900697233481847529465955976777080775504082077767730768400348583058526630200678262985119283164318872420740726771445149074213452627912640392288721353731365596280874986373808895443002293450700810882688512263333958088666998330338659350984786482439581351153703479577329244849706845891433736717089094862144460785150895401")),
           ef_complex(e_float("0.43647624751102812866979468711536143875127825683409399232766672593801790469356981077301058996645359389781637131282931677913113133454410537010412660229706543105826280523496442755991306360436366710276276048425338982143344697669566903783553327447379711029243970085617283681090808902598131212267503313264419867175908178576579948278525425585153966996933511217231713524309046054238126027302818114869474001063"), e_float("0.8267398383622500635799692400214762705089917045988026095162073530385133608518409840690991453346368437810501367820992396438025013387309320263828930004089647554785112458515134126660966022638810646509732282651006066662665498309898355425734254481435311841905694430160540254585231940741326594084015671824066976419544046212966394483912616732149456508235268251425210538818778957171474168930035857928901334444")),
           ef_complex(e_float("0.43532498466215759990386525801358052152225126554557413594781218253359419721068664519179529679304731261403282988435292611630745031918045574786310402554493846639869439992475316404206374057544516999585888044535070362351264258883686271532963657360258036782134461158636757198761286922178665063763211167045249262879536418584642134500024026707541448343719713611976272883638734173526014668401798883033870275675"), e_float("0.84410950899509086095037305392146551721292356625369306460903406078877237368833769487297320810963993461660066236520987848426722574605035251905125182996987211228736403676904374373077135878836370652478715721849217649769000505062058493779029670288827051600377409976864595850334595670951152625030397526998228550978345737167798049277892050388143471157406076472467705623958909016250454354523035844744789549372")),
           ef_complex(e_float("0.43379915179027160409811686311582290677745632609530839607287840966349507869200604669845110356024766293815281087815186714297226794582205201641321527837319515029393474964303429214905287976789946143828545974594943882364052644143969068795407014787718550555850187046146380021853791578447071771082235149896527070039883442339138297131368305033581967936480821228153846274927257916572323075782062796645174573542"), e_float("0.8609597590569023440057079338117512406833254601740142524895850550770716930952632192404805710354934339028508511916668715482909317447227329358807719281468672836906471960807397785403446634710225455951949894951232135555663608539609339603782956453502092933472640064089469423552980236519118348007316195606326893121421073995902572006508801507042866734295187113896939961993766929624808966571089477928583720896")),
           ef_complex(e_float("0.43193514694791314626504326546296303210110498442076326054362151994884241216512582180775063544672506130904656251319011653488751585120784668391198053043111245118047354849606467318968460303409739430309870327930923724066396007582435616004369765789722955440446327607718442232497941012925075568009982592805605510349544320392985672716255345396157083618726610653465566390843272452546408343392193965205662255569"), e_float("0.87729091786408630822150917241004945868601606014938693496335617943464779826406114120744877752551248269706631577818352984579332852663074933791149321332524992586437707458413709028570889928506221235114069708428131743975793451173946844989356287353744948873228672069621963160751532328847072413242405127690629967273164839735770743397663163534994071616336692585374181504712627241206188789762314114008303389133")),
           ef_complex(e_float("0.42976773549965289400013415453672995935208339420290519476675585755002606964425084415493958297732022058592686068760197917223427410975400917583267786775336647746964654663113192330213050016135295317331216418410836455040529882483493595733551023954176009710628519198340941460021274041611888980491790061050337358005080542648457561342403968798402454475047160595755393771024175308601956037417409871941442657719"), e_float("0.89310615555073364763135085510513187218267599764228973471422972310944847060255548800278181052721279993745146084368456255306856901290590001124631626402947669118824186866473738348617776452736078325855179793964557037261878034785555140588846225937857961092731150650686312047714655782901763729088587813085589241418080848298760955894604183087374092866289189318451929949132204400775036501522606746234938138735")),
           ef_complex(e_float("0.42732985466899277640740556272339273836513506773141026934478748179248593845516837292647246832054524831713653283168476426272496350402182163150034287699396429954586594605780897429193196771125274171249819368738825935657517625209647636433677852372563447098316237539656767006452460562022055039815167335919466509964702453857143038481156817281218117811131024774118167997975254218916061188128997277687404700495"), e_float("0.90841111618782664613230436800228136758743855532745630630643411906297166903249771764335674201706697384064088585867402812668780027181421708262785313630057319195812608383235486436589364585299517456156290007237377706663338338586349179992025834774371649713708920828086334280708413562372629989791005009246887449972618179972145392459205029166684270620321934537369380058854289829460159031505859723360891054286")),
           ef_complex(e_float("0.42465248210930468213864564485865116545942334256024428795920281455689179599029345491596738756406252012276091405415444836621759646887554783823818585726596794958477703835111543936297951103559146011658098122450093186803932533620129734962369278868651807993193536415527286381258146392560715457466069484001272724951459107513528987237542990039484561711944667662160086974280642333163478804343401200900533266114"), e_float("0.92321355906100686785490981785571492224561712427630847050164088645489730000932168908533220196545652496292358168607802846210843976159359076555413502949476463696652285344604609391781096062001915161356854819810870895652537244848473227242242810482261096815855320152430669957450614863142370162966672701903018384489492910058214352201382655697399028696772863870560234950791613515137995366989826401389048346917")),
           ef_complex(e_float("0.42176456038681140753751392117968027062267742551177105348970069729834891565732664227352003289687243734083678901154442688613035488000744119241437015784889711430908597666367493545476376602760749935849403740322071415216317391826501782574497117048217204088760189482349493346104262486410118189238513661837689502703948772827733932094849182958687734063545009488008361824403565408518306228492483160274964637196"), e_float("0.9375230164890041030868658055311470452792158255739237459375118152805346391978978845644460450229986952189308384929678744071099198713250194650877108307007013613698735944649865481844521157415178838361753380796097015195073846121433919906697151236576977061530500694643908381553666428375982513249336852289862606280231646776702602316878901024715475424295569212290390652654091944424274381960435550451013204442")),
           ef_complex(e_float("0.41869296892568870590345744339027485959703618542872251152270628909746966670136957958224482875987961814928280130883753346430564477682123168715064231578683019783169846564094161980703943044630827319536046833100652439006008069266819024223216239261089580341609031887985222151495010810251362952971100552145388513393583495603873485236917751958601949276665779230866270332081661687321767150290424848855157795279"), e_float("0.95135047417797320297616544306162144689713922485567430006183078061630593150355671714928080844210319144547378327710611648054778819089333159501782975525355450261534569357832434711305204970274909365318882795867222817921298114063429124128943379636200064169605117031888852042315405054848511698424554031167129062139326008229125281551912679829828723865786883068548849331104557473684805949053744682453287757138")),
           ef_complex(e_float("0.41546253510720201733825891037124775261110767143883092844649628060423240237716038986625047879939145076659671488706142640483285510779075425082827581974866874253002958127342269739143028788285799880478436379365178404794646309237122126666570478440887890138166568798521156813818220220306803496461540139795171284030967968570652027822813834321907036152452994553405632479826418760751553961225481659306084254744"), e_float("0.96470807800899275705347843684497175887404035471880360536295976654690290760801086434873236583515387973150758419502215094012222319647204025715471147912933005248095404296386553922481404659239861386028975731117106580668153993943009415310678917220693639457115102059863884169389373264884328346382861698930852648169305196886404937017843574979077369869868835972815613462646303484521297908046966838109118146157")),
           ef_complex(e_float("0.41209607670006178521932472960986306006157481004782404035612085006888621828347725259945269886638785977349637139852558459459567666175381372501230970146800007117759578788583064433471891059510963775733372478313108417064404879494857651452961557508976761326797704117109105947389388352762370429098197358977433483897790875330413955851411055338924018008240934230059423722740829685843496802891391724972885115462"), e_float("0.97760886939258242067585699967008698752718859549255026713026511502885539502754924047492421599759901916855741121800369536701600493949205254339217171660973161139302304094907760203361718489115166382979924852894465069920511464215870734852341091748385498019130190590912475387956199760619049290155507535975357073985243619535099785215161700713321589175614048007626189723906459839522255625233317886392838667595")),
           ef_complex(e_float("0.40861446850735442908943097429980570102584479077992910023746338519706820057706323917464310507183988862257296481180836206977829478684308576730321227818492006629684237911277335937229596326116879002303212053910933771091028950537379879223238493344785265924231109170437287952701513607758150466875822790009425514476828223487556814532495980924071287321801566448199850266206134307990117933351946056130628833695"), e_float("0.99006654990399305332696300255618950929937612912547984113216735528329936353572508807839408582605084252979381123470610803862698542709685740137539984697127760737418530164068305892700229154930253986370640725311615162232177357818554218765354417534828778265860597663410536466436883698894283091990442235751149097949039795435391607244493430665811924069388369109721114300828129887536318447039123321447236337798")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02126_z_atanh(const bool b_write_output)
    {
      return TestCase_case_02126_z_atanh().execute(b_write_output);
    }
  }
}
