
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02121_z_sinh : public TestCaseImag
    {
    public:
      TestCase_case_02121_z_sinh() { }
      virtual ~TestCase_case_02121_z_sinh() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02121_z_sinh");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() + k;
          const e_float y = ef::catalan() + static_cast<INT32>(2 * k);
          data[static_cast<std::size_t>(k)] = efz::sinh(ef_complex(x * x, y * y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("0.22677553223090453337644811321282911824885949025003408565110610443424519618297583490592634354745683623914311528490554367194394931864582041675903303170727653078304378831614924207099449696472167643521417596339415352910594378555867479766528217404016137733829144062634137543969182387179113302843791893511851908242677019160301264343570888255159303574445925632279625095730690074413063280813227158382560451794"), e_float("0.78564715943647433808988860973818531882387090525739206854324560762226951266513592852814987513556869495880076104843063780862296368209200506540922365351544186877181921584409803268075679212566980200253607241456542618560605547169926524570493743442980629821701848888829794161581672755898703131864411208505863876217567724229672422763927562776039264511409817940643228975569602988661791169410248289776959582049")),
           ef_complex(e_float("-3.6104378303315156835890293997941096627813337641418518302472037468543949857139072092935629568497344523117372790659489033615002742378448082692801705512341997610591807656265889417084939382781576236660546681171677048932404384919224639261267628186807142020087083512618677316473282158040499304146636767598008119416509409850391900152323530139545513456452400193655920711995396356155857020904889635109460164335"), e_float("4.8266358947248917017158168923981801998689061601377305077256903141505511927472274659749847722385111495540701597149309507944237513461612600402663370175931834403513125476220543892698601213455181906291715136593729785950627738062007556932962493529872474891037207931192426704773531984646984150558570470663366644153962980989976378925566233106469864726817730058488486263652719839673080291032259705279920058978")),
           ef_complex(e_float("217.95094540713026660164231811028803493877156307105774163105826379227044022223871028811043305258797524689062491509250982693729160811466921101378824399004997816489877559100749101671520098078413571302702308839209143819796166769921457541494297366063920095244530332578763723228267223190397223232153827730223166987683934265017857769611844196616166126977761273201274967292791025572585728873070370790680224292"), e_float("-315.33889406768547034414802006229981863415908788723470253193527730495090384725931169662683190559887562780512335664296109210400257063028208934396094628980104580818860824013564934012495863164218636316158249350414234832120640774185973861816848410352926871637291698044680785337961650750911115891822628553860157029937999571596925474397972611722499938134136213392417640772299570721887738702330869936637179114")),
           ef_complex(e_float("-137250.83104725307693453314081432721508993031964917734339677792402723693750472537723066767932881276170915792457917144637024699674379358155045425312995978159858642903947498663914363819165664792906956814387415579727816865432085885473551721497611498697449480961239002051975804981524853710632653534937084966414729667651556255365006324150435850698155168390636448604617414775489467344312591320939249448724282"), e_float("-117183.39947925875228176011102960906202564386789988841345288495660366620011034355721747699479773893724853490033948894513592994906980585544854203248518585609912079485733470640961214806986189808747860954972406913386068512956737810173915874742086441600776280014469804180022084576727093456954925017572634445191582789229165434355923597420875182234833176664733190288167252399714674705866463021537252875926689")),
           ef_complex(e_float("-3.6282300779413504848941290393483063304215743631360893493622840367214137609333428412291525897808875372477675517291950104316445332785892371808847536689329316465458768811186635242969382033680331590098981409061916558849088413994304741921104585572647026328794511433325841478815363587359338640880555715750154148991819601411932592988702556890804417855859391331865318495471143725309354912601506343834105087542e8"), e_float("-5.1235838389979256954900659142988056287624165289078226908840790882031913242784976615261332287870724143720900557803341122309441014788821287382933566046276855180785078252822342460760457359164300935457701039178413074725413206830448853886177862806485286178565058011346868162542524169403239391654150928860864787204703979453384441797182883723138230412324058240595891112418907766815014030075415386803771983219e8")),
           ef_complex(e_float("1.5741025448048176154268192266158459390903579721665451912213666214033759532282002043943159389440873387509258526882257313881510003273570032895094096091383360483921296523382286620113254279667434132751884180513593368643556911550323883618505652106551431356311928284090078552779899062579308800648855069962067191529737605856585829144421839330193824309017690306621568469142535791090652767641172992631829564526e13"), e_float("-3.55664335988244780014840286663141938669707419088390062563568836273024524172111468510095788513616481339362290801499771835178780821269317666445532610396889244437101692183506940093324191265132132327766413069459411563652830701164011443570801275177506242462139482847033471142844743680122539707389125922226871999404267046302312890317990847468319853983039377635426114630516179022352647112399724823091653755e12")),
           ef_complex(e_float("-2.9116771566553267439669777308588279504925564648707271745137984700416971241290714912556018510513043757177708252904454831880147137250059612550795839561915412538261822040203076195789544588300206454106393323031225807230621223295884878328263380185474042334495252178301293782148210347050248387700636880334138261170873615671186316220389160872107562081429991260346319588661182700642555782987400754438859854929e18"), e_float("-9.576549012440550742382608546401823126684193044877331158075622998133687892834211730093037577487948919559221085816545728052700302812602762779497089006197695009459238315716827860845148281548474661941081642534318136075832615598255500263300552257001518932685254164689930104651725179894343969967547546395724868194847067461891312497762614030322992368134218272016819993846335958527959767644989098102345231297e17")),
           ef_complex(e_float("-3.6284313975960059246920762395862284618540978839412916297220313888870476166533151559017142050956399207700054643806881389613322089035710488121072504349189574249647366972886338176720846044390114264130882464091327180446796028658439472583404929289375433683311947962961895510031506834123746671178515611627425492884246842160774957051386243842462549420791708979184481123197478925331790844679876858080894800262e24"), e_float("2.3106312870487930891709074629988515403633082299936226566903989394102206835133482273697500149821914360726247849672121972839942584207545280023493654573342593184139168064765160853402368436875165164489151444802115596676679467789073483384876480424097862633559116253866057457802336451592006506007319077629595936602348463579621476575809410117956087697052385632783693074500560403754428476423855021580602277337e24")),
           ef_complex(e_float("-4.305196964828017092161702713250902796014085419246543337414225499085687159967596791684525921414254613755362200515323743980925082364272539025995404175210108765476258517973197736256464474361384002456351395197203384576937753082197448380419749940965657699875200436547324894808630140411783567395850960515889127750256831697349229114429957951008869223078767266393723853007593689921422063186813882089774657699e31"), e_float("-1.1681728030412053626213725796394082606981293595430093040021337812428392488518370405627252102471497137378042477785540530662810205844596280926714505165895900270283063025632833965470097159040442062768194656996661737593311713073549779702474519933976142036090587800556323340521469846619699914925534923193415194532975821105618098587514137774520689743975222813109422042159147444639540558897450211944492123515e31")),
           ef_complex(e_float("3.2361171971567102334678646636483234457533584382122037150648659977641403248801646906470005816696394201113238402631238779824254824651576948948260573411822861779454594483246347272364982605229447622660784972096363905781235464209557073781047216620347607319333737578111926127791336142722376181989889298252446687316039119084235916222070441909842428025012059352196099919873253885310990146395648802044111299106e39"), e_float("-1.1005312766933813274328504148481609162062374085120882509246142472128808172694655029181115503093907633525112363792792455365489524779453733904169524517727263341558575983212256401905839421848345649586785321168422220526943756261542814638059291683073658143638261011508300597844973266063410613897954194799695872279617013788640911105201480768364229139859651497856328602887739402070490525526089661255735726622e39")),
           ef_complex(e_float("-1.3535461209542691090184488205458044108334911668976694422367285942844560654431564179202157119414814618029235218068354542790618953044269239243968544096544906339306177239276667333312556893968509856285042907283585729877857221298784046063022257546769685563391858849935691520460429466634356332217980457260598164655493113512883035966852125108740460976405196705572363575615593377012521924364180286412919933705e48"), e_float("-1.3832129975788872199276197105195130802643897891219796458425569147951932493586604304179033084830525311079768860187254311460973766855230997510364520365817466211643587670242422594130218691659436125216938370729739983855931381579595912868954537576857029043278804000372104063561904064411797320119439164386729265648951911715619021269260100326199678789330171710923778748777397582185778610724692241722806319349e48")),
           ef_complex(e_float("-7.1226713342649731029277141519032971715749256094246818681298222129239977841913596722910812967203609479278551685219509156633507296614825738846666050419913071179796909167244088079341199671638861323985279824535143368572417472704967067440365302784402505930034097815293777220570119958863474215602361970107367371690977749789813740894603175279513992732642879933653958437726905914612021750551954029856455015251e57"), e_float("-3.8496719226025009408131493037718349872478727963904698852238527444287365520565273057548560872617387952958581815160320904220530719157862107898568684503276174144222047295366287585615363963299424677811743803231567090346796306090839246165197390124633332675834299735032403358573905445981263585365787730319414712519203258342798470839474319192152847957629038359380971631938015816757816199780103762095267211205e57")),
           ef_complex(e_float("8.365295283044161449873346682117397689799132028714938309147413749195318040276620013162784505821972226366507147770544148631115287090585218496953047826641759769931307533754400928473515744580784665234419216531683739497800354422468071425940225328435399668540158633025960447792152892222309852821674452376558523292791823675238026006619043401827499655595304955394853510652694046536842190749718865684488134304e67"), e_float("-2.3588884838457740411026422085921624813092993474077576603985056355616529268658059114634589400955332817215114771801304793541703625677768072468974103996723934463490743116224918364079439137813743013147631795094892052510491585405283659600068686137658996212672189729814217110874528682475618293252653026201970685728783853413540723057437059803508556251029014177178219950683160016213239839311549262992904267537e68")),
           ef_complex(e_float("-1.8638396106761196029682513593593684732884104791848368842982910605052523237737987576250085393318704480843540517745791426791418564752124321825055925642802203317878729337247598465386185639823455166656950282904871153321683875375722633628852547088519882510971220087365978620984736795530854499305296567677537624595486845273763818662505805459433857316416937950422979666497862920137779109344600000212707044071e79"), e_float("5.4044729099781079108793237928230050599141717006901249666083152403693298273087396128648988644509969668549408838570377914886483527137345564813861791121204588898259747990700428486209720368979682591491701251370655030094078322002451980780278077134492989293595818337828588318617654610515427348356622490840360094447139759810249506674795163330565471868667733002167389778745316958721038534334292937395422364164e79")),
           ef_complex(e_float("8.6050295533749666236157192710611107233084977965115811339602337355125335054357106595583173469690401996531002017823125075903700752275325495539474947634295235832663489435236843041239541439213105009929027479889283571077288829773522710506706040520104305392156324170044404431887821295034889331959557040390126088394021215926870032509827789304526672302190414282392381918960683888100866763925785330721089374964e91"), e_float("4.3647888913193229515617890139421109684998488653384224447212925734249252017357738668906581731586275883735068047993745612696443317237058401227289566910643040873292478251307730831303552409054879864551308214034654267076120246435896629935880048302263143816446369568332183216151424774879146993232730370005796119546326386912587157789567448076305356672435306029976490750737997341159199098701170646742519843887e91")),
           ef_complex(e_float("8.7817085214236743837670978349620967675578904099350455969213901909175969763959186387175463259517343833138279575803291895426185981123695841671415272915242626865585042211834522559531483625288922957669546059511516461807388678483633491517933033943343245128198196906288955546432296257026135459104163352527805923190119305923058559099897717017369436904644229231307074426038315903278740339720999631375733668714e104"), e_float("8.2264297733923574368808588912132833541802959180211839842526020870975599296122722333636500041909203491961422487372681500183965394520742318719697806155128635403637791298991261189820339640456668741947012627701045126537024178483203208342838111591417469216148777242928016809854909740182444905690154378700182601444594270308517848902287605194413582011332136155148226709218348707835596642021514073262933707395e104")),
           ef_complex(e_float("-1.0261253616238474318840296762592102886982039174394690701920561069620992567055669018018334398225353892743935899845702766430293731799650921273602186062960118805942797081914613327841607693215408065759374373923861720843700737550076841711594625664256421201749064267175859096552546389082442245284370602814486183230687141849332242322661398418995346540801300377179757954221473308925892312486831391063141469774e119"), e_float("4.2020478311587451454658519689807226179055654188779013643574711927325153305171471141395131901119238207762672616088390713251109337672903177988432098595307098193530100043542678875045881965940699634849827906257309316790965882031570606929734184336469280318993428087159487579643868779375934644771056319835108457773959064653364271925211104995603431733576319072494934091330231837558985808677210017407529761633e118")),
           ef_complex(e_float("7.4187799840449939387324917370406211533826962503945679756913595442097369421831628221868074411218669589117765010547243549703775530493632026685886934451967602989337366529039314432888763930453929844077623864851843511162669985554053765528561020181248353416430920465037984575593888705630919096929501810766728564503776407541586243419442659695395788580639784611704368900388101612688170456392223855884397799095e133"), e_float("1.4014361354807257966710691624089560287539093780870099730942325503556255644476317841524537377870862610219212306182039912447348925273783528058552574194966474081635487347901200834657828657285624519458666183829560234836359412747808336989039391904826266847180973758882588903116794425459615236076256452944541697872408567645046414718619373774553789992303220513633531586864854904188046720666298023378838893444e133")),
           ef_complex(e_float("2.9945246919254280396016832519830856586590428156894868587547580059651512439924471044734417547715750173465599276903627590874103499907355854933009664145536873035749220106220575407003338316712090713487117091496234607185945385084972869790393538545181273735528849296893355456340097408673153310691318220483767147099421727384347949797608357286011600472965074295268434631011052799681491053706125693062578239115e149"), e_float("-2.3370280983652007639153616581116807345616200888595366010237712891551289555753117805990734946227057487546617146309501137467016644889339688267101244175675963761878438481422004563787985792624534014886659250678870081218818783193687251268207725868532713687500239446287485548587842170128831892126746192426506779054206627136624137521329481932548952707899917225201393761383941841822975050740290080953232862947e149")),
           ef_complex(e_float("1.38264397661925330284992157739896839985170944307587788725543486268310018556578396606770814667639334768288245876523390767703058765598784685885472956806686524851820990085498734297843740473739011757920912843819460724697086004727909320922191255647312251441284816342301749501061449839201221337210155716559791076668236489804085877490563640202567545687731938819266187882581402248883002053339456258805203826949e166"), e_float("2.870753096057139640029947630246548364240520806790571320710327531264663089201648058720134275272595269115688797225774244387049089313620284041486416259318386791725502385116758340109525053097713357973262689379094393509050335125016334717807906322561183303017627203080312531935568762610378859807804004215613526506352962331441506003235784300340244501137251967009216217786657263365006522605206412659562575897e165")),
           ef_complex(e_float("-3.6403263014076246281022400254523316620364362592135005370712247108613864096760284489110427484919607092585696925605261514056194031303758174212236327915672017580131300456692302536348986809625710610888552264766349418654429734202198987638426196534585069755123657559133199393279870055799713646167253201512923762937200112970584193112480500074948529160424989946243918003950666748546186502112231976224442998946e183"), e_float("1.3397403290941228833833403731499275831591901529840353716590762952206148907546257604349664617557298458181560089641350874484155337730110575845059810928095501404333371067232749570376959918247601111811171566495510811759298894244371285976093245479648234469411970846851074544754649270837446403172449524376822570979357375917908419621397781570639061499532784093629942993069238466117214268022213568315425235231e183")),
           ef_complex(e_float("5.4468453814747859717787911497395452945761901090884834745202622618767137526170949513113444336579172121449738243401659103913587213340257202086377264753861204387035989712346458927711141345619000666598019436048407944160839071492354839579057436136526577433220587145529778307346982185426231477867049152378929012367997216319790465165572175575740292664497067677626912787439421171829358260186132288697383987189e201"), e_float("5.6852160505943758316056341265697395366984255665899495416486039282062217455993054167916487407812796436052608187805280385196386619815064439765453330938212650153823078225420025683577356790118688787290722802084472219068927028799513901892516909718771870054160857197254872120855895014179224770152275727640238853735142498703287795161147720098619607861607115763859814913934721642232248042764208309721495621145e201")),
           ef_complex(e_float("1.0119043377078488392567112268897334801599239936221099977778975245904146936883032694190537304268819204630760116731743755025709500842066845668971430992719475577729665616875291413346849982020018314351981645105327582596164129955280966046784796970740257276691368466988233582086782015503404025411280197528496313906064992305919384497507038986600580136176569200081832509696633052422176121219328255921289090394e221"), e_float("6.0860525870886998209108259540776833768930752425705644489274056849488306590798080436606046769185320676261591407117323502149904221109988467134930495386158278197857996763615179815867239414541890571565177299019805315463079376717264711379783692633296323292831937819961614250468130024620055151991739972325212652274277615544017073545566951902888298333443411236053789145774083751089532086420577540002731911381e220")),
           ef_complex(e_float("-5.3618398601169415947201997569446292511165072610447941740125453833110330005584781488924845029458478411154474993262895389790422523657614527370231741768502621106466526406838875496917785419171616042553860197065651195296519766277132189798876230000029449839303248576041752335815154888896332016818432586570084399594611249542387468551322264399414342720601589432432297042499905623313460230206333455980225410449e240"), e_float("1.19368879092269777667356451342343844437343822699351140039381689886805096573950223545968660628216707537317939017607749510263869591248006106456447490975752823171832245682863600865663900024883283978550141720107804713190799017148519657710518990262966103446594804066709835720300212113342762162967064995004599314357826039781256627745462347812170175561424631977167225664207892690526212486649951242739742576338e241")),
           ef_complex(e_float("4.6500219459348045899412153323819461894045722987359390469091481235401324454717102283795749665383456803229820846014875879600004662432108501763114159116080760814067057274368135714087768348883985370162211898647993306657433748015048369673818957151444368965400683092220158593343293167694265782647683865567067351231603156305434246593347182287524281076571946029588795137939468471164288023150006688303283644011e261"), e_float("-9.6537621997368329859293736340275730719200127268032007029866746682967693206617460034762811929404954720206391818448771377693316973229940592514024972133039325453037088938551469901657948147630233947201002119935742632922137747096058709319651107406271270938352976258646648755725305364348785690315824990252492946323788323771438327293964509717400866282849369048229187605285837872432358474640109145005447012009e261")),
           ef_complex(e_float("-5.2705504358370908554350172318697216863205313689602541078095424470313844139622109896415730525027737852782297094466287439085230881156202476280087285764977942239748085665887703963660810801589062686720750447955322806427401850676587963729400022029524076315153001825821333691713791857521077495146830492737351176033686391706154574968812509935854236858507916191942410283124293286881699682885364200831222801475e283"), e_float("-3.7755439078922160603413704610071954181648015720685801066598836247898232200296138428251806146578842381706348444518965122452055304263229301209471258687499251547783234400709919778244085886372156465104617363239681999349496029121626067837554655843359799966231096034475676096752676834926763750624810307880704811273069836873447120765908448192465394920859630882432775309322657180446605886395197834177788008017e283")),
           ef_complex(e_float("-1.7086799193516830844127925329641464255574810375026063728907624783613793583596511986312785200743000273321032693592129433877912474868457658551535863894213132741521977809663469524837770899789659943545560765599471697912448547302515428935416882432857529983965036601745022947983444793832243117260536425875397334464891988944583946262538137877281987292777155500714481384399658336023545856790026303509047665699e306"), e_float("-2.3413547411656698849070050307633774669766973017279596557777296925266639427562755442117677950970445405799055121550641124081870624154502022665696923084692550581303711539617073235919443435705837871935905592616307870104330052986360652949754212192628032088447371244556660884726267116068412181711724494607037756075215834654176089827323809221371097650091587808532276695306205635496179245355004604239672270694e306")),
           ef_complex(e_float("9.4441404215062877633661142426419447711417367407139925136003311342981207978694895253502224703420479194690939101177112530792221757071020799919628123570657001138709338528616361588569503676405421667401368630138212631707262940266544350093788004337136420114287786566313834391542492273198385340112487877262753233649791342615872778731215092737811136596445675424278198238205147159831021201949785724743632977257e329"), e_float("-1.579087014118544858061608326114484973624804958464600207025576730717122129326176856015329125389734860866601637104008263193968768381534402352932216967285242066344746637237149229061608705972273839937300620463992400602171915745827836254893697175229933958557172971585363969310453049457605805117327288340537918085614423493450814076264283106856386450964742114301029459798612295153676524892265413792177469639e329")),
           ef_complex(e_float("-2.1095335709917411710689571329152187103252066018344571311523406151884999470015389560076801985744772408288341297473071674197824743174765270917758336776695186326505391660516700182455631984237359722227502075867695318653798340757525762993356700876505597587981845626517828944443571336866763711815813883063773350177202755640993458028552926268200700762032407136735367563192276439727761752353765151702900257557e354"), e_float("-1.0063375648883879098307908214523141095659396400631700459172390298567632848608134976644622880874469195210310673746767860302407827635421577005982441694649055736808915978151740129617744577548400181885951444903146907543680520210962514986036839254361959770451288532974785595528644402772021197019518295167969763744424273051467623657411336999869822400391890078387395935632375683424562667838877339912331790504e354")),
           ef_complex(e_float("-3.9320122854793900741587661145186649399843684105172487060055176017048560876922331060781506495586832326544401757832546696309826701063837018365157838481053975241672754678251549523734766068269088621044283616635705524353230459417920488505287876901955476858858872128538977484248728401508528773074058597824734467562855206229046861945573917414333893794834885901846493998576924586757673790460103772559090112357e379"), e_float("1.5200200118710733112735546927828442863479293319012540317354811088866877115946742367782567848472147884642709077915857072915673201248304120151605426923735372780695624870757997131688249011719152043915494769149912344007783625090902933400727216801523508748849733616674074351900382945509347009400336956439917776001975411214468107288641662468891215103586431565624254191201377782215328340807350019003954395892e379")),
           ef_complex(e_float("-4.8361774423087682404253838118046013423723119871553040021266323121959020356445629377413995075548998359754747570054832186906720448103683816930730666363954621583269070107501557338865729282797782609269232693045500463399441693284454896670970422998805127842136425136400018820286184292648710982022185799224221266734402159690242322627172576825319445583301218132846541177737192850963291278865704475326660848522e405"), e_float("-2.8592564257359270278810717148693571348602947941023696553720097701977056619332286066793821965469072382849695665191817614381193831170472497762136292098223181574091641256257135371365612379518129251868791049653479447009162600912100150107148842447615564046888348556584835784886455110702805790250736624268281355560686589276667174827520397237497787894651807689858305401362872601295510675669139962189316467892e405")),
           ef_complex(e_float("5.532113852813902943234075277642352705609930846785429834202618316655056323172897014158766924646478994173402308594990978354269298743687147322855847028081713823504293157794205286848995910612717311806470456282774930327186662994840621316210306973750579979618160346883433862657172770328792050956739607748363649824062946567095126616526992750233643734145580504211078177211379075864667809584188074849390417363e432"), e_float("6.62951825900330329111066258724975404885880678686757153969464191993852240844193413149113513946125314189164948372439696186153685036795993310302911403576070803701247187718711885291830849452140285391351805821385906147696241402467105611057065648938440803745604461111051894258067776034144527152706545183645888122120491014159619083983072965322365961285665065639870395721460663780488594787668736281678552778e430")),
           ef_complex(e_float("-1.4330312705186836643504718328945078301295854022306354165344574737547444709357234446030524620544518798764456318634679866058782048901457735666297221621784473599841444786489587303876085786431997723973832666879219244677409981782820231489896643606180230671639852254301723212439900825629850330058834566786309937688521084421212266229933672891550395080088605160776040042352387260487293705026097586882516315802e460"), e_float("-3.761969324576549134206300711445278921107388874705442997458572119945399117110300181963403148209885058545137318074029012313658274705313912013902126347295056341319803592724945627067666211598721672769596815562694562765029057593224797716805539538506838454476522547659972459527537043981969133905887159603685377085894330689043876166580580278623629691139447717383578670662181098174274528782234872355125705343e460")),
           ef_complex(e_float("-1.211163478220948833634129372031962927368678318043594281619985681099352954757499568475251684326162928395649976110321160571304632534223424278126689214360830634852663105587245010806987686640612016661178846583962589997428719390138928959592011838352956639597617870890000284532632094868795618395502563104540423640384996903201838482896174599862635536542943966568613282304712570715174758504419958199669426393e489"), e_float("-1.7938263941136071199255565945591078765609211534678445593461721137840071706058410764178056398714002831842204572033920027425620903733469193205817001395257643030224643027156741526914437990387409323826055464104229071729939951078784227420219248211317140189851200019101710074467793235816518168419350099063479126792583455855250815087999880556489640499872525909084006893255083779533777311478313384604012609351e489")),
           ef_complex(e_float("6.6981547670062215106154722855653294804841887620584091586215731200901243017536309597498861689848508325556250361163989169677060976913250664917295391734917663100685664278684665650674167312181394536723894297840580593254803393701958352462598561029629425553879809901409369239101300500194742250146277221346144305143671005263067229786073531038320846824550493289692229206060181572340151442200163943237398947626e518"), e_float("-5.3919721389496443570049656220264509642435682637618193955029029380888395042743260562761498586148942007162368495676471214043965108951964286761503408127795372610611135097556001286182677824977869344577618142741913534108382153644115612622047469926093156240957360839858051988389244363591208664624812747127181738903519612438763691275971738172161676952286315545683841811794487735952749724437611505082940637252e518")),
           ef_complex(e_float("-2.0607079370079310742582755232513228928021625291467388850034585246390614359769422517513912787275712521431482679423397439481018829623606424089119917941944462369850128938237874379554356041266008401474631262208170668651598427959740653140620422889950408872313852333187215576426485094934390321588320081930405276767314403457720256380194039165909477117259068409625497673346145478417604404799219675606664547593e549"), e_float("1.4577048532278847881334014274464883013510043844172755090088215732026676192785954196607320506646661905736630723593235054782826498249457452384015808314420719200381400671679710263446442663663049365146283482439415874858822029917081207008973444465690466457415007207943558184750841110006627415122642343636148569329794535009277348257691884794153899611275761493102047970136313608047637536616928974092600766228e549")),
           ef_complex(e_float("2.169992173541827565180852188253933198438600890291049753630954998084682230541965586300297561637354041513327868134472415765096028278035376892318291905799892204065798408227786980298885683484948683150184381632255215519398619288950134186343684448793433561746497029470678706484527075746719708895354740326868766893460379158846479562265776686551795337530740745654258157518721445168682527531013715427819553218e580"), e_float("5.0266790832362996163734172487377946405865993071361682893268387250726873792217457412587874284662386233717630504814801597790015843699834758298895032873834815724078437081473311551986127834685927392595093881112056941806545510696319305170534030844274214394095562354699608412431331370305654951164917940700644617558241480655804828493589393913555926699943015723237989196508811729089670478901503871328839206587e580")),
           ef_complex(e_float("4.681438382236954627739770813650935500310870332350008416922297239682787604080595673177828281526945192726730965002703410858960140313129856570093645987462581809360791933475557549918768750161780504994115639929359702173439670331433231706591635398237813976939963558254771170068315104701527853619191238525633003752293785546006933387866667822451297682819710457483208642236094514402511384215380554111614424396e611"), e_float("8.7625584765876157608518719982374837756036310093065669869879558723752961942199112821361357672577140944666353568863074979407712278416868039256744596622408226974711957803261905352937479911175692821630237685818953634139733058658748843233718218015401165976249177576259576254416957364212585197870717893397843238524268993846460969200666089105845487681478786732276647548262930723265260525615151774252094433347e612")),
           ef_complex(e_float("-9.3718783920656422273023345254604889533280804282668566517546510954770155758182641919326073152750398795737447456517649099030234390368955700451164846983563763976132030305128156039759883021893476770690562526568568511282079844784589163643004729674366761029314652270192423594975777706081506909279042263729310861852105980859638247352894376480166285114682222831289125040037798148393395017649362264212825153522e645"), e_float("-4.4901628807010350128639121663836982174463133267495104641917614390752616308025390637760028235562547399202812634178101748468644641986922372071093429298637114209876016375492745806583826110076636266902991775817897346348195482821278023083343166382591333436569387340736824856786105243615106886147659009669027417206763106952945513403515580637889432506267616727584499769463098977699701829427115459115059736755e645")),
           ef_complex(e_float("4.1815762397159392864085295248783856410903438048480569222207678730124566548390647634807709366635915346117159491399004276256153429215087124052729158091007339481088427504401141773329216746623517672987350152135252585432678506740228079157707919668374900410305594589756204828789800820328916506720645770235285313465267765683537457490056545132606315798818334815300652139976176397622720566141173405664667541301e679"), e_float("8.0751826843660307013836296256429628792829524373699264571687931656660822469055176388271592787214800793240947367068203140745829411008107993927471826325937680655216063137436047595449887577022224029030485413864314535225369441897852763544651380650193312334147451627940448866034652490478746119442043734371193053783869046599678921081807719264545586007033916135844262359097486210822467744792676159852672712297e679")),
           ef_complex(e_float("5.5916150357915938904793464378876482807801012747528086938374659102006549744198039782237429450137246961188035815989824472328851404604084199994574062792357420983409817188036627756823235047425666376667219485965591298050817692910622869861554819969594925741911196554450487790002583151147638834483805758586330693423717833349907203865065037518916917276089732711402076622678126734884631016689634257393532168508e714"), e_float("1.8183015498171211643957148649014784760558423911782461520037982707536459639432931690872527645582234813114254169956492209270425960582039013709261487907388792567406703286633745465778975337664043718504099559663330569417698990219219400659717501228847805648364785687467906970550565902394765632311261759982349934838108351807681047305192673549591867380488400826627563986949978033641610883886585154487376438555e714")),
           ef_complex(e_float("8.788005749706022872771921751415725147464133564353584163371991754751913116008639308438635398092044858827369554167218344708119824400254201791806736310189684598895852189980521191268966879014835050225687459996424499639355993744511100257054837613205371845566083361546181060369493587700380925100779469592014676178631253660117897693231662988269264914227623721801274679082347306868566849815169928140742026066e749"), e_float("2.6681918025474536158958864079065134673268023038165923745044949935178321519255499389746822445884664228320235592488098842001001834421370876131423051243009238132998862503647315004472372260522553100702760306009400489239041481767489449508762698769440722991254308937041274421309564510700640523436683025904802524151105341036241061571399009964953631316112602618189822901189229608924711592493241215457387406403e750")),
           ef_complex(e_float("-7.1466700625131816506517692988528890820010254842742263986192272152516221791117621719306423055140086081293607223351777838041447504967608717374568446606208777276924168167420853315637002730244817388580280093625425400662613357494246403983844938228009301840712088223211759961477359716567442625491601613654596656599372715322428125925740047614031769930613563516625885002951484306615576411001255504503345638531e786"), e_float("-6.8756499336729843825608494454889528250435462931821960588436082943381411802466893359066258537869729288507682344575531552248527708115037338070627309934197288964778968829877865191154968686233254264863599539212529779351698025091937302691433750874002274919862288667551258699223631548001286201173662297383347758998622766401907643013775477545376465021008517202113269471284947883608556315537611192464077262603e786")),
           ef_complex(e_float("-1.0679053344678401443527217749357116094377358510393520816498416536445432434401057026918666827688353035017260367077995140968221122636023550656237805527543353541956811389231477974753746185602082696037279488072078205199793194251536909137705873170801736551243956732297691539288767241818758963952631706184014138380545157852966288279563332376618520978543512163893941425910345085337350661369498282924744613618e824"), e_float("2.3561926620071720878517361792843405904303217981649808887962899666940079480180804377552923931501736155950443814069754120248572014883386684867062341429177646334278864245714689836463492201986190999050104647402238322890980847453155303248576495003157104765174159876949051769647063473336783862326581133205609952346464486225672605560005484506287965174812529708089384844229529136651752337030244979950741400829e824")),
           ef_complex(e_float("-1.1416990309137097287393149150088451472723197251982803501068912458190355296491777529902501327734153532355646150153520404151324993568065063260705257965305320776581722036850429184750835704192574678572272467653724162874718342418120192233815992345628351230850698742931909081520209044430383114514352579251819121971369806794512418243889627943762738196369131994373240920070099774022952189143659387317516483667e862"), e_float("4.853655093255361778950732149861277628499859595921408179552613943482329302542148084139415271229329716519865519078261075377620277910932574111578645907596484429535116469843173203254044011199786894380176452370677922073432018090926044562949741280348916965724518799685209973752667329563123492260872061206355188343929153875322849602854111649214833625590209929419690027420523749589030630772746492539938175831e862")),
           ef_complex(e_float("-6.9832901358894160796669966605687869960531612484659478065842641950842148133466017914839915543795615408104773803885182375790530053684882963718101951372493140231730264042300054423171897662340071132828065887762643659784848773954807685472033604375776875399398076274483849194379881375606658856845313863852175712681920076214286348779288170622368792682123048421354004236827654540282607147129174336827270896119e901"), e_float("-1.2889951350382483749656184932206455190037440224980773516679748248152736571957458361291945664962317569950425627923422908668182342013934098528757365663085958243863268561996862154322882360425975448719578257834588245971035969997060243981257370343758521789070513094990349561840581126225686219956196322726972646875959269167761125795314657000720029557114298272336051010793353215401605476948358211511068745112e901")),
           ef_complex(e_float("7.1818842358084001444657818662138577830817667085438169442023032203502403468650840891737051146444306855407166580420665001256836643559181089016521210748324069108257297578640874859848930100341411396929371458312659294339791436169887770429472137167794284199439223035013396015087539513120721797938890341619783260230130716375036493235410008646543581898826990285344272734833309351054446927924018102455567005148e941"), e_float("2.0655724876396686252918572290066782649711237082763884192482896136814083341886417340700637929454576617994832035718522916052746929710753232870180137773351733967224201418362490891593087149963709323080086463661398342164240502764393088005904862326444016437320561825941960132347346658861111892947585152231390505469110256886316903642502497934773928720231073576859577161160654639322941353322979125468807005342e941")),
           ef_complex(e_float("2.9054271535403832063542907541400346266903859317439753669764587012277922043865122947642553106706998941355767465919668678199184457802470154660849719784171466722870042576515046411204990443107220054104972353060555395394711880789385037140824963072027938443572210962772274930794949363065676001919425361717907452534628170564825904327177767862103481522059689111052772359741272340497364942752255977473168385103e982"), e_float("-5.032443552356623845993602575355762902359235660076476009907087153942727932759095792503703732144994504025024502792368439038623805252107543461198368039405829430553924880024149552183993973382326037570335570498885760771494355151531762922668849890098774003103232296325981040546500685047406401601992732597068034502484891685518597548158840154857750232048262718981216708069406942557564537389936330178244515929e982")),
           ef_complex(e_float("2.6424031439367317698066495964099156317798960548376468801282108458378709842893898263247332073894871276336700524788059400827932032784016089050256804024604036608757308502459663974752886333667639695210645667863450212472440240800941717974507932268290740810040316737142586496325558055891754130937246988435065195965886371732570604479645821137095697829834129467967089666591384958490533368880248382652293276866e1024"), e_float("-2.0408383092491575085051945797641679916304876211789313590001335120698523522760008982275833512721770624838296882854924578809145252201071026207866638787775458211571427886016410800893534683187576009920513275359728115124723080290058706886397545581128295958842790005697955745439030461056221582860200887697683945281611926583503126022948015769804087602467318007542627840710391377091622783279682794720950045288e1024")),
           ef_complex(e_float("1.726010778119196269388355436967696440005858454546977968134071410145937183664639286714327101077401225753030125714952814171036669916719246652201770268031561097627111721833225925806320837982754275088917873910216099112036115199826364513684932187991557448047637321539076677144565218937479333862712039154306720397778132174876748277060448579375596970489915763662203719793219656764814379655590549284967758963e1066"), e_float("1.406919464600290559603459339266548495361909160564541299110569851509649490180496930211802346674258115157867880907985348935987210377433048096904320949104698166307045107179394801248371421876529948796696039602694044973198249201032906853768310667908885986685522484240737987882648808255424155638875924615811072038136812172779161329449804389899275579391867573807005330095750667035128649507028706788121137378e1067")),
           ef_complex(e_float("2.3601935273260723848272417586005194996895987794278395776068126675024456838044991111253098638357198934590747619560477319643264467064278005340532215811320634917647126737993526686707580001179676396134162894234932686174867945816532567238943310225691860642635162389171146644069114441966435572610880227332576828947278331891079531431772082285133356693978052793002701845684837723094469297579406983320344773913e1110"), e_float("-3.7685416503387672374061390127323897767663405123873886077645048620076985197130646539871863173581309561509053308301859546885533125223650069432800564917294027877443362837655940726361481944021901432957290144236239677265038183962925593641042567424849331746968489117070580728503099216190466495208847480038697867387389391106594437055061505537480837924061249067823931016159629927602818506925730561318596123198e1110")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02121_z_sinh(const bool b_write_output)
    {
      return TestCase_case_02121_z_sinh().execute(b_write_output);
    }
  }
}
