
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02113_z_atan : public TestCaseImag
    {
    public:
      TestCase_case_02113_z_atan() { }
      virtual ~TestCase_case_02113_z_atan() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02113_z_atan");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() + k;
          const e_float y = ef::catalan() + static_cast<INT32>(k * k);
          data[static_cast<std::size_t>(k)] = efz::atan(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("0.85942212476935455544963853775708153436578353098889929645270064627363841983123362183784497818067637976575867924602583194745827086721061438862610276895949669710681785611450449534278034099202910387602324378073383263100843345671247831619356403485513917921090250501928957568940482866165554544831432615649927574770162963208610972825419363633738600069857643013387145386047580888647348526608774965943641139695"), e_float("0.61635606266900938322275576818114966791959548688813491873447556025371464974946639995316677123188790278277520788143066561315741457294189496840118728239305111701424381418637751842737414851327596854721432299260305679800394469592191932448530108417099657292414020354200516839287251278678230591485272980459466230801928261847297172595112288820258308533538800000845825147680301362753180988953582351645324876386")),
           ef_complex(e_float("1.29638091311657169295978148834231199735209217155035092572317691384606729024974465590795952298340303684313671322781490075745458323989914543527854859736444909701598521562637154261719023866329362027014479824356565819776804799802006176264844610026269732194547359439792174277254475944017935832840729198242782839466144986962282878917547403303110880830252315526214912441790270411314709813104388492741850280191"), e_float("0.29876915314955680194968694102933183360746428308731896174032178395584444863600131005819570217283443363513223628285289555099413505197401925730302807721611609642656854903168349468367421608894015993414744175357693207879651541214865597725497551619031238009723363372393925028827170686197503917693583163103734043020651220589660715583629932324833777698077827420217851819544331022578682645096637903701281469154")),
           ef_complex(e_float("1.4851845600661426775671312677904992831571440897335670868947656158533435785740420150616085016768118055260415042142995346188175848409574613732523172549512838203661163530676748488127425456724116943492489045435657209480498228152540187106643405944603177491670646523811735739049382699933015869752377912679285694137577398620921000675130955394285906962537142667267702352186173764727931882473659652145270515317"), e_float("0.1597723041649029642680302581987690491047722490302197662219272521445009166678961737823779089917677412385107222440238836216724631741827757135993779736520414976729346335435275713271053609301793977225959378638976314460627376058457204579764309619300359539133197919253716118154051654954663928449238127658197517650494541116270732996908101039387628140440620897313321155045348242476577713107558252435978783771")),
           ef_complex(e_float("1.5383580489559639892779881348906123440166492604290507113220356058095841788968752057187776750793611731418206537262750761693257889923939719960593861923228494493768784648283227695562916868906200589822395520787539184318373853285956241766603767980626227199328499654930809227427227191864618115076423009046837756259443321833703134955265680580297985376369060833726252096079760615214464565378033485308812220231"), e_float("0.0893783906537451881964611223607059619471996461423395738857349374074480386421693027669989728609075808705564658899180680478181527435275307361169642566501500956176781104574179178640298136997056166424713312819353691361200381777912638442406570828859726885512780154966935141392034160193075088186910609821352911103887782141606168701578812929936149854812898564417934085367564824576507864177537286943260479079")),
           ef_complex(e_float("1.5558474869318554189348389735102623405629275518216769344614107140559671677655429676347049766858477243647164447296333844052236865403875845372038390279201264926762874949392775401686046472354314085675010201650913233960460732862938659094641729209487329274444292781449612612134148746198915566381174697517078068744143782011897709797812653196424840655341734817285672511034982402786415832322705443847359481828"), e_float("0.0551262826097403004073188420034139197478846426696462241517016855922268051402427112395866220957522934539174400488238618840804962825494547610879902602765648192806871142839103985644764897509423979154486354672989830209896474540268950810946949505798969288537501923608288255546708571990299181756776417345570363646817819640606955992798578322462424732210255474053369958682183909703128470711384380361042203589")),
           ef_complex(e_float("1.5628493303285815184391925384758407069618703991181440450305746303367069174092384530869239280554041593335794251244111510272815778305515319854695922123825136161160838326009731652469832888291223099847419761965930839638894018837352882665727522021678227359796158858296415940407513443042231217896042939801160235431021907226917322246414847272864782993655094509211874058801892221617682070570130268897882326898"), e_float("0.036892721319979676293734140578217396515652916493602491481675493965570424741451727209520305611653058168393979122305645057819045202304973177683620239660054381793736842838271520321987373695312347671760126813259102084822426412260002519717189660273728412379063130764621764416507394439710647551386675155048401790075731249862137077432993193648645620785098275877560050138766676349799610690084166104404965224")),
           ef_complex(e_float("1.566115332132818612748217725348068212295036737793740045645901896232390852484765170175461971326366678218563237796338836183186857284899775295015920389075109229388750332346375591330304748467055479883969208203515751513678410205309818159827255857608718422294750913499467619685647041030809844050916735032312612129265193324029542479909352626694234952215038693227126803967286134122150290962154559603557351401"), e_float("0.0262605794861014199923577921079627978090062279452391480727715268595482536583687964601586294475476014436869179347483618111285189337688616054268957581830314269954673233406886266592793340124482302927411352586713023284761874121131239339813224368500819621006050899460136474166650957414232498463652432180614689701629924149054178008230432223522541059872423238091440465517531054802097588529312460679367488629")),
           ef_complex(e_float("1.5678225931465175903070194202027332741387390758444728829520033664769786972471536702336099401519969255741859682097156695493433223293213554041965298548784896909321744610447508226118787118610666369281235661404524166087088704238737454131922367997688511049540642700418580180856972966433546467071285502982984493415357524648870705393571586491420911328253551513922363580975864475429683940060976245286471554829"), e_float("0.0195847615278622207601048241078465570703730394330398616917879740654535695999924126759395374933695273726309130055649771368204862500769600685531942690091189949297529914050832194259710999358881893417684591403542067395000313711119467343596908399023109174420791883295436096911794474932941496474511962500410983572427023635425788678326084499030906079900367948023880232269028115133355948037648860407997422117")),
           ef_complex(e_float("1.5687954245887100187270686726856485299627133456521843979357641362796887231265778988466319656755434058749520241219248969589223037047274320495713669698524679811869056386315327054003928838935499104854185585538878562264389328607753982828984497903340208750599736723651831154529865773421558403638257758507300889831281856137312039664243074885292571259760428274516470582857020107378357458080470689521167222653"), e_float("0.0151413123944838798123555206603683842394778906632085111437215025240894599302763056093986011219463625469704810949118081229831173325251116013582900098338103312160145435444409411695824216297958479692432968166328011339940595222771787390238572605689066953331023792834903838153949283816036075475178153611351682677316378229806997525873956452430787931935107498426498889165826882665566966138042614925660131196")),
           ef_complex(e_float("1.5693881128713112550033538014100271854684796253012430663909154094528101066592141258480998430339256897550832575208460676598295004129899133691450254877998726706257383036312254049458495057790878928652764553405609394891850929876686121893604219248493915985175244955899084098807806785237124959522325242029245897138872763287176055367791295904822128964238437923056157848466478701857540675711901916747692647827"), e_float("0.0120435730954486456908073857388813994222349814931371109628680151286683071469571576270307922019240735431229349924932376761525612079395088549402647890090082913181544525543832200389541479269335453989771173815630540917430915050852990375846250606367255572161932132315272741043457584930282886537443119209278190812975516394644960312654538908355499087212443200611577400610175212654474782055705351147230428445")),
           ef_complex(e_float("1.5697689063331559609750961886083707863032190182421579879547665599195999007062900189965665411929374634057836160969065697322617698606751530767813437018564750651171023836277808300020218385975439753853113567987271713021184177720682310218290622575048878266351885606755018294969408169629612508037783196403852902374955411040069886872627790643069881574036718306104244398827562133111536847624661764479576120974"), e_float("0.0098018625677410182020788488166049043738832044422213236422324922996362316245838221669608457817307135246578439856873407095846993387956678997451992124860104838184734531107653936467741997480371493596760391380267811005433995835357996340224530922613274751294628334356861846801767848373131899552059857908546333334451367595620329078566009158357238506595052981672195919602621736093792590108383075178892772076")),
           ef_complex(e_float("1.5700243346792275470147431630546517617524581107045492936459036591760067124905908857134598151986284188828900293263617212124242510117173990722300731137688957385343526128509340334844750772459560184426110717165504786793021106333283933477667738715982616931431684022856157397875219260038505533310005238583237687782882908856159959652819601995874998730999516114204803877782005968327041452147751478164857488667"), e_float("0.0081292413622316059612239461907927491041891367993444345688865686410222405256006015082308796290032715454655124870791992283950154533526445364303516379501891533811414995167652263209523555943722610425292396512031732266424194562920648762781106097124841751969000599015626605054861999790315125666491630860274659546390306727715224986444580035882813422065779969884331616858264623541235734738029990736792473273")),
           ef_complex(e_float("1.5702018795552770674167340680281786319336643847508611570086346302356309262200622681238171352626998475493382398182297541860961377043935210210048823958152727954957779736985725970164609268062629712166143543073826893622135949265320297475676382100088007861961953946592195599134109897330189747434847069091576301051652406921538078374156394714157933521098616304404193440694504236630411941039940607494400331107"), e_float("0.0068490661020633406869929365432790010495749042613698927192442673980457289994926609239208962133639193803659280790488661260618559904931876155505604637498487727229456261978983063771490561053230999625607073053967621829813724964397794937112387766763853794557567862616459835103356988792339938217877950755566373866579059194850440854381636482112865783331091273735491915929852568694760377008945176686924972698")),
           ef_complex(e_float("1.5703290297266904017332449938459522738938939895094843654083799825707818203808023685658545568244064500744833880527348175254314138054236129516998807339823906399886710196291717794969730231118967163618899045124351470404333376523166833956089977758239733149621944633767505063374239743622596368187218328737758211599156803322728675120644984254416866307400363731772197334402630616087597971009925650229899314405"), e_float("0.0058479892121736504135073589761288644117437882901915233516957530971184404389754977073194632699224264723094888383481724982829599339028994002549799125611392908099181831106191816790213660493606058883190275799033121227576476962507052624911741398515004919539241870421253108208443051042929647477320663915312584296578848843170640142287511039539509369622583268663093155344429476824588844384985186198746862423")),
           ef_complex(e_float("1.5704224312371317712973933614418713664722721594347863970510846866735621782275335018275307549360016539863682624521996887037185065416204217739928094494429823048292190983590942903356781265781286049080290178036089323845524046424120165667826682102251520832037140629823835842202286459933907501548330024837421723498843643279369274254392306549642008472347098586823875016282664332572665713232511043494484533237"), e_float("0.0050506727440937879107676545889660667139098467502725169480605620283085147260136065747521079449692613301975410858852108722087084838508327270333879517020318985041627123888978511995470822333232883519404772303519350962662988822721320723025899671506351883046654931113879074818516868356307394226813654540929354610945101894758140901830122651917596383774641414374281330755588461318791334812460673593733244445")),
           ef_complex(e_float("1.5704925570399627281391538925106345364924050360349510447911405078712096789943480606755752856913774837349028653528961798234544636953170278293495289769655639451551680374280873178691886944810268968701875141098833586972208416127844393806032268386753852242013245869872589057553949985466289096060436121434059679207818232049789786461868290517129852447281166510082236624483426705431392630925033290107887027949"), e_float("0.0044055078140677121936072334942252809336733630558896464600296088454965052248196074528920879847851415792448718884439063557388348870743374321456248482109857143031488688803982644894559727829924074723782731497927498136532744957750168697350705304702013301997499037947148005959526431909213389336237480644716258674131899151617784480673999556231870404129732184397343252974205804215362690128933331383778319496")),
           ef_complex(e_float("1.57054621650581483209804137882342144090566071531743137443385064028068557393900680067556975501972925162262022798423288472737548149583378258727910045109628868224981000951218675681125324750869155420948831906837157108315832330111449072999633017191704380861306245499131019412328025244101172506493446528655280980398835017871567617266457293047552273214847114272332373365523000057758889980903782467662970897"), e_float("0.0038762046296301378691963185579113508837714191870509032564568459784854245521102374349191440614861476849256136522057636309579986923910020215487196398013395856098833266946331661988113003799154530229725690377690809477003878525472356089546005735994634636001532840246315243565900893496693043292889386345674214253291108276639997360063627863412238345071251271201916188609611893043619405744017518090795272321")),
           ef_complex(e_float("1.5705879652965675263804520985803887344208000655933079392131540211279374960615571402019912129212076138844161470683902479338114213394271887589357094844609192502109219653459057530596352733673766767984291681912180941599260086255596659303916269615836145709110252522473803906533237091661440477087913644173693052858208423174024879037507456097147506654988549790395719763332646569277665245490292582303501894211"), e_float("0.0034366562233292476286502755125720804106635443977190445906043762927781473284428477989377109371425280797987293249541706716239344789740461272879343929981633233608579055790389031723119858093882304960750065710035398370929457979211492042826478244128310196237701717332009146831003344097868111038004864365319110798152025853636729499910784667807328851914988776535742361808868159863898382626819018085391690445")),
           ef_complex(e_float("1.5706209285697542588914572883627261648475577282069241824635862528169706457853318811618229876744326305085473275302425131078445630718938837489823957551475222496281212664208631651521731715856812078285879064473053036619110508890573506052777658572316895765317495320474921020875839816852629827872431716136655927880887208771509538743014531305812388191764230267738418936461792707278505959030339296241433712991"), e_float("0.0030677000257361088432655491288588866168240505469517949826962175641790643008260696296990299445864721382212075042689684864158578650996680512000162489178396635641719265000133185553527111347443067004049035535340522562266393204878914907322481390905228749984869450783096550391476489753603638387849663702748047371102799509547989147029020858949747737903526038592718390772856240239492145580967412184503909974")),
           ef_complex(e_float("1.5706472981306596308465983409324169573693173144051926111677662349752260551259669776241852084004672966169747526336006176950025902153185970301931158933000710193376770287900075443035893424327938335017199402005558332586308317392084437291000296110952114496803416717618468487368399739106718554582940029755539228875745163104054042851733760149804094393576582818093513588980857919999436803996883718929259990043"), e_float("0.002755017880185932450969687467545545516759311745387720145505909165271466809021868295125234609532615680356708120731396569599162941562188002846129389511743124683268959753308393978908773364642002568045257015477556913924070723158568141624625805151823673127506090424096334484842370887991348883524406436307840088344882794849644167940969507460984018628217965288673742124674165831939336627307474238022088546")),
           ef_complex(e_float("1.5706686417507831398302301417024529197869749168474640828853617929116396826469227445930003943798855197461881045401008442067402042552331404528385994799349689878972155403781513600220297625767787954105975930244457811946492547648148862160760110172932896500470102913452745409205184934645805017886480552486758444978957595361423360697941321886561847388782099889232552030732144848053275058844428295901260052501"), e_float("0.002487739926611775184771274498590332923164995529002610356150578439668152093454644866854201228917728117788657607676574249502996239141784250919636564890526764461659828230282369179055793964017156513176822616248997781845253409070403418778828247896309601160937427318382395378101133397956123724889418339912092574902271677390147737188111223031898356921271521262203489814149861987392995530837416404202021788")),
           ef_complex(e_float("1.5706861007837237129414639522115749447192739938380066857254468722132883698561871759094476527948677201331464316579834934983522402324699999879047575960228242003155213486733546846705374363716120167507004195353519489604175287804324471121521588268802990533264478089909469701021763763335518876056478382582569160968630484826596387723823564211188497989661770072471621691984385066594483176801673703002456983872"), e_float("0.0022574955465916288801860548005154011733025656659709897395501036189120445085824886705273605851721883400856037641747462490592409785730414585560809886904686476286529604965996897713357862268562007169857539649395874739408753907438393120737255451977268986750540827828576910027402997572070480117570412656445019268264501994558240733469033058740819015705890043543264797272070184414315176738137192831788358918")),
           ef_complex(e_float("1.5707005194438293809163205572991711301169401240483043126737654602691978046833035736566178174903568406708011496924061170916361410123983391234521556976883608521617947042756694036386458643790595400960032275078248731134511780917236246895908493855481238130576211045947581454407811853654886974899904747791413172460758909155119069342979551611959199272445864730545825319748079007699558282203314342884804184343"), e_float("0.0020577551905144348767787951478642457319438917319131330404433589466388050772361091179587981142451604671852145765133719947880954583670241905559430327491944332265034243388754523107963891429612342246420032544447676785198825366621970107347716404226827284736102586219229019072953939953183491417963002776542627717757456936672270945856544853096255140130906587901583210631859606487755591128058308342026870109")),
           ef_complex(e_float("1.5707125312016532239092227937587878833932072843092439939830062876578632743885527885662600840940051706279634206833653591714406286560091612164451431101821364155810661743221532511029254869841752544847738004195560454773347007235176345353536182389940452684164785501961040759263916630063960653804401405916168927180977381566638950524562270115670435310043045754990673174899373573787172596333847256680159579547"), e_float("0.0018833656240603992673150111691313446478473594482963715390143445802030628842315704912814435347326339891952864757404801729834716460719028926963607171255494760108650448704965770085091793648187601274473389621749465116797149332712182057728901292101574352145799429665709651310433074541654283994783017282108779936593461377468834887092471873602062463119955719172132747427611051168301003973781515001405775029")),
           ef_complex(e_float("1.5707226176454017544144821271190298722536411653354239320077969789108930273228759684489283512798615155427565254650460267682315811992683510259099386845594808800153371011714048689924770190914970438786570312534129214375776367616539727698641905320598746541528563602112065011041980934258149496351867951290963281682698272488014940099549823222756801270207126176178912522511434370364924781497597420149415826035"), e_float("0.0017302163398788663126810137309012346623943709697357714867139233906743980326101470062008650229205638161625589350802597444485072050097133768869895263185518843736813300368869502532878055716321068764346257761380602985605287819531135445056553329625523807621352566085149603926996427295562213603635948144458839526958711132617503517163442325780842824024160967631664544784134912655865979079564913520764802256")),
           ef_complex(e_float("1.5707311492925642769477116099600549645032562503527457815155139626382492537765378620481909924767933494951747795818717156932515564176315168144855367508450697290610226762729725964703188245962836131906087386637719470555096708242547832585512790512957997485406008831482867017593674641100519248061636124443421758693096515777460797582899820669357171097539712592751960141701294143173072342443010162967284415453"), e_float("0.0015949965209899885944340847044478287684530886801446799105714061852262550072150641150971181023654680885835469710839691034488256873700066949168740915412292504222063099243527393277863317281509231016257362796421482040460181184826721261035667494397153075442932309768662418434173292607408927015470063640309673573887097058917976361462363024869958787102987001807437193703621747489453666488899563624984831557")),
           ef_complex(e_float("1.5707384143431189304340654861878942829482318533153552244748046229043449530236877676459695495047899041979053392264925128006192673011005404941557503243877504984924530796463844852788421230763061907006428855461968789597246029463096381313409843035072640294707560978911567615321859951256591736592518327239946009640813714033014660841819695048516984125544979184002680834118538761703082627824624644294492468133"), e_float("0.0014750155457015489842449869986335320857805890435531699967750945014286855024310632703753272331291219038130403490735892173389904152906813933395411505817949670053753123499418170951220181479267286099604679856314451743829032944441575832019023442325982067967198821761032075473564059078266035535231552221302208170137335617703714408201622113701864095245140049410095969362670476106643030416261215960137046017")),
           ef_complex(e_float("1.5707446392364173419296164195911472898542136216336213062891278873190602246103912806876303644918565807805994806922180904850755102308574711954935581851774696465200508077195513351378734244987690745879330596276769018493353914833485033583212099689534261237282457016494753873598627290697232305846669029649219790406709314500742254065959691373678518264015675035999397075801443794180259069023035058745545552378"), e_float("0.0013680687518868573129271201765201675538287769087855498047325032710084548046648921073045290514651988752162465017649277415860056025898841954576740575610804455466258154476734610698211793814161923702526465327244506669710312132334000563573062318082444900595486952579489983065612171235296752492631761189853262877741594455321381460112040203140307543719996487705324013467121722895486069846334427171169418606")),
           ef_complex(e_float("1.5707500035477458600665712348079369288677741028924027722998869691874917648945980578190192431457011083160318935619073028980864096388123633600805362871946888417111777183344728162552254323971552049104564428497804925265107902810861996630945024400358236919576565987435824680717525441733292333351508877737504850524467042197630083993414972088562503959851603030615075423494997816195131298670029851661802773148"), e_float("0.0012723358846668511540468665559715617198496766634870789602407802659958782216785860127579002979886696181513686669311852393195117116211586689914280394253922611299336070212405473673089420033680986568793909684615089305753174902258371208447781022074814298943506934453764456801594733411136472619322336228246885770831555842258366522511841346800583334965041494972622743882295594869610003052435183334224051473")),
           ef_complex(e_float("1.5707546509183336557956131485140117997019766345212165188132488987157784611558630201748933695672702598096441587679554198973065517331278376085997715236266906814831246967755943759953546347662599229581502581218727797960709098457355926208917689217784720510117632451530833627813212802906939616453648843799601645650624387722866764471750725459037906097582874124013477433439551127215335190207943274168987664293"), e_float("0.0011863034470813072211818585083759321063445274964251730513091543069758434148202244130803331629102644159056905283932607071796314914824154250054870199312463728476612197851520971109185360131573240599916205251456731237935452667813129516169067644800619641721863640610483116335250180277935215068440535515281955443406322731420889470869181680997793278532547050330482111144046993162182990077163477284621496405")),
           ef_complex(e_float("1.570758697167932358481140043948113958702337797746876778727737053869770160478194403019266372094978507658646449475641738000563566399287956407452695609097953300411269689629837271495494882143861619251763665378129965692699861323249940565259662334130028811190217225873756881488585502000325159128881836820896618187457417770926126890612252629788698133267456669193223266771691133511201903184322251029827762956"), e_float("0.0011087047385070959591338401605390879156488305731539118524387266443262227031238350114936059438854634299799156247699931916730567279917627876423387089123752058508563231266815471736863865867611842300218117137388709650801066278071468010057448724575756819203076314257194858120302235999804117997576683030416590458424433773323220196968406438143731886040003126311037872070815563207913237561281896221757379583")),
           ef_complex(e_float("1.5707622363809694619492432308802104594720991597290590970836928390831188559542458367155684391763888828347467981632436947356459852923089373263699639514609971041354380343868879881597620415616417654394634464948480751205303839368202579313777918682872607947131792452078072131966565450946323000487255327627946669901082567986358248699500915783054739563123092375347597439420595513327810949794578010887772541143"), e_float("0.0010384731249557182319556866938974745461037649899916412982860029547376276967990689092032951965623770931193855221620536784600357956738547503390413745941249850391493584213002718195713991425370337615895783565491100822597872528374112575418633385702238897702578308036280923040994939118440085967521436668187597785343794839861523186741527809380594571178880335603049327614727920149015758702317827506488656966")),
           ef_complex(e_float("1.5707653455181395984514561317059463862329030007738802091277048216068885674025565619181278594841222806291561933813164849001484140701686261145634161998059856522780964305547230395416095287361285332693961682475989576166334694550133931021101101412719789005428928266240264305128847953679651261216944065136049099374801374991138796993209617828824845879681061294340692540323622614844177879149705580290882115838"), e_float("0.0009747053086931649095156786378160390225211149256969175769438888376973393223259648429441034519664789709923345635536812172009010117597097096614238036127432385117800823871578296267304068050848013572775086234189343715435601601632693461691729330178175420250111904142384121135229381255960475137341647239013135272866699552774970908045683411681908642043543669340032092232913415462562611824486858455797065857")),
           ef_complex(e_float("1.5707680879433072347583894880319027788596016305319004870573308075812674863304534017894924092094371210373719312361105117892656742652055570211341834172957518934294380347192821421376170026266186825227069941320935127989729463531663876031930218689066062951503218594004525388797038063582322725097932513589641080258382921307392885413402303444926298371866762976383918799356491362726476277262776019876272194444"), e_float("0.0009166322260919735784913459167314078673656949095442588390902746573336636840203372050781234552499676227446746463606049322390852808331576910605572019648377311580853218476100267477554669002000554189324171048941733084551286308356086777175388168442224426206269149325800875413818824017987773687574303346309532085149209833479553504034771431044187339027405574569415669090813396435173511861636735890869033685")),
           ef_complex(e_float("1.5707705161443887105736226084194545855659811502356393016214458214638099552786862181620975933066653430192623751259782250446693641952818216992680137289070411209595662170329358555629835733949664734764268488377120462394368553725170598122129400285467612233246417986915762539052291372875290195744656683037273358003845323833185041892727196189790126145108402006268471399005835237884543979763040687109099605287"), e_float("0.0008635958165163508042681126148592577140252896773040350910360818628545150200070514478287655859794776709318499006098508819444090122975430408367523890351009792480745740456693554845665541959562099432070001524564271407546914527561707157767850237086175846505883661583719939759769398483563440824751579845523295192196529332714239368325544140530247955256014808627060666457256804374770346577459624106489889134")),
           ef_complex(e_float("1.5707726738495822348564610577989841735973327622702349830271865265223095813146947151138646930551121536818957876887959773274893808332148197296213861528434805394265251769790434928095517104040526708875638634100390114021962574921440884348756181616745265741718821690463675158030189150304615289766120252398989597584499932060631902297784054171008640446242207871256532646140184546569897687716260833208297403231"), e_float("0.0008150303473839602986418971448962129605773504632882265373765481939562306541538964220776122364899293155945467255108449492379939398836389323690928173488769141886261797182700777327544277600434735018747433240278878253106356744693543556745630263306445153455542817452662598670377023503214093392350103779659704338269371182114104959492246665143784080998918210710085787837117521804834539400543495886183650995")),
           ef_complex(e_float("1.5707745976859533215158345428773003340475694726224413344363770109501280745877258238395576212684226648684044383800428938831106507979693022913148548207797523365935036546985474191665194506712526264056649610336331068057021783073588240976100753430559365511044131511168759518696985933694517651611155721630625226427879241509387157782275536647523165701628125601962414645514414119301721035027329583156695237801"), e_float("0.0007704473026082422162472022028300663033621188588036953286717554631736983082508171701815686763920439951851068545327415662839923381176127519336543075720628736657415336788583094972879925847460708014537115614116606789449401492575468859613562503409018807200399030937776505610143557049656938519078756130967690235352590987515776391507748254075486043459081249039578431537633091238843178163622596029284364563")),
           ef_complex(e_float("1.5707763184887330584097360683852399380897414320721923169130150365078589808790008864651830355145662524337285799397896392241026177609665459870269495404269507824599327689210717346313672243068797191712700353729998764486351802797975664458828927224310825910263873600705254602789461608289351552152115531332077681632404256017373044331975892680521339851048542253811696390362925787975700668065671564865988734373"), e_float("0.0007294230784076024136428801603307930063240281562214122685230955339811460782444583034609023264210815648781338628317293635437881941321064848531168036341499541057514658110363594431757273502925910728070893774140709365409883972373607962999297391652369205799127053027386744565295217815208904589286324986253662823676440206881949974806164685651853312628956919824166672511678534378675754110990897925505023203")),
           ef_complex(e_float("1.5707778623419230548425996302145587585746443509192392107872262257415389108267660247742491055296870016499578012613075186497463777744738265495010681719111464824167727259592357451911139824530428490450196255655357978119618496613235635363999635820083677333276844094734584878591880368192384175243151208540893589537460431333086295341566346526000336685522378213239908796678528551343586575392846038846145004615"), e_float("0.0006915889061566746347408951629465749123174356498601537818547008394753121389151251182854747345211124718164074576456618264819697456837699232496373025350734279220356320205377829508973842715450382769322233184494988694536439268814677721683670640233738955318113340613402194019870426724910837233456677001320004116638191151208470013804707528801616240150969316589028543713759184227696156175768557358652197435")),
           ef_complex(e_float("1.5707792514106636395836392972647705182319841664039145634555341399132233512251067391850731252185292815969746188021127076245684920309273296353599272443765258505260720382173422370289759448444711446844008189089921639218294588255725374610064784222684663257984917716697722546488452825854024634777368591090042950308447111303583763659128860447458038947291864661804075961375073853328910811213290085100064547692"), e_float("0.0006566225534443567935925843154556723446404006034620144806263971029077284617485002084297874665093217883562278799433042871713255131387971662518403063188742133569210328260058387436961178184868821991238082956322999457615628949444906922938258536011863756959673055255801257414983737859508393073612839094838753462719103891992988534160723878005632683895274654818106072144653187861227552306228502939291759421")),
           ef_complex(e_float("1.5707805046110821854083645121613846097851528653409580210435852561651869805183761641505538259321163366210339577412103987001856823826051954717886801812873126582736558784420949051548680624029270618635776715725821577510500172429490428261486224255235314149059019088035212403371985782599672081737423859583109464350732136454249992739909595826639356864241675420997221268390002436024870765455970295215302048971"), e_float("0.0006242414537187625619316420025724976498244577786738577674808398058663215693782460175699499234931464275157027514803286706755662398905641455174503666936667749234496895624432414230411017049405014386938599410730558717250383502442333653722371939242168715320232156095380029371926733585181349221890768886854667234599240905153669832161982161038433301452586122416685980188930995742299723045381949282260030497")),
           ef_complex(e_float("1.5707816381524561681913537588955954824901174399231699049610014558174515783232758519818679304594140773259117278553691925180546666292205858904595015406489778812010784545676818727221679165552585133166130489622100093855854093227058458088074376994163633992134390154891164337042865872818409493775210571551370979838355436916982541256974166226085143641722931021846299759715993156013466618214668949783917736617"), e_float("0.0005941969903415894132732813114293488684538357431655205679022972510648767693007396483117016395329417983752629588138641996881487711196215503400947793725985333253937167098962396919115735699724313148770865342774942051809076749354577936938229162894684461981355162646988529280882613351768925629735133867781084812963581635036772475885403346484383825413877961494209801211568600842593750584839630767835606773")),
           ef_complex(e_float("1.5707826659784254405885162260941077220171117994604569980591135939403679325363912655334640641223733606742363012254537331147652074486933092409050178139960477541972674697685188678722867239907390322674630720113549800827462066588846829866469098009288422404699678651883457411661923927344903414287043267469852729684546026566648596933932278141489540972502580463554695964815584000938553260095950490577827010814"), e_float("0.0005662697186601780210593568398281325265982125666617126220525981031766554975919849123129078469043856887342087040566120853401733594402899935475816634989873426855123317764513301709111515342411573771797726134978190004147592539941684891826668071825966722244300348550467626171590057037456539867906652533930816256911643662139351590676044111391619002818379821944564208067306285063812587790932780215948631873")),
           ef_complex(e_float("1.5707836001279121645229298930328523440862408651867879978075921598655493963106475932797710352457632112129753398791586926311415770320919346068604866987168300437321467425548452196836161716055458713050147261247153260688758393041231875291703611293224876257471371344513065638030219186462622837284775594898336968972731916410079115204635159122496710839259820541834458437944975694982615157336722731502361746081"), e_float("0.0005402653542744410237746424871944208033467746070633886933844414239010730117024788431044592352540164451051747322565443059987385970905122341125911963070406664310151282816730829731935879478609690109273885952631295057967755795044046880961833647185061705092275829999294036501388046481455074939141783539543425608340052169306440621091958383230391635850666787498311119290775587997238092677756424829119582946")),
           ef_complex(e_float("1.5707844510318155708786317047852048536780301914924696091904473649874377663350654597138794952053468325040989298078444579822067443837110317527131806245626641374897583759933973966869605987404827270522224506243422438156135186483990748896057655407125339828640918233023174661304534491827822423648400820911337757127961180344846890654405787004838820616631771763538516889404130523800998239262204082048819061409"), e_float("0.0005160113902774579576636833930074694362996321970820088730739410228436567150419207777020990539090980155406728149144757565648836472438345185028547889857613506061942709944431284545017255054428015783284880048085724272385822294310424548223383334656111132074247751345469049187393554102273372106610597627202895136810938736037929500698845118118604813209067755829744153028173151134776122917313278688201542929")),
           ef_complex(e_float("1.5707852277580551203083130492572039777000706888605909647898721776206776328240924951758792732435138086041455894751468178007407485960138345247727251727500434799026366068981073604149987840565029980069795569800898870706403234476949017029793210917258989723208770353481083869616383636670337785306365412185340753825992866271706412246655026873698602126257651006117881350658031041736967553858531767071890433055"), e_float("0.0004933542332802526269338349086105649606162819018229562948306282833445589031738685860038337592588081425694719737054428625192879530074020225375589760589108947052249723153940974387347367324607743785974121469560055841162811827235294080679884706367784811382033418000163918626033268305409974469308420633078449347420883971573535925359211767543397345832784363967808041201411549682004240734690154122857018928")),
           ef_complex(e_float("1.5707859382148596109631884602349888768868842468308438785427964295300611275381812668498512214401847526277739552464811969007960476851812464365845912061916749545978200026621060411966521945931683269596172878901500130114293887792335313627946510128100647819712965331808741883216867055520193472860306088199196837822336960891930064244002836138431920258013063392905790882418179091071215821394496813832740292153"), e_float("0.0004721567692751165350154923413209235649870840210892728287147690536820778132130193194806644357335866967846045786763626540142828721461989238431059811578172767657003133906520014373949331681835075604418111262145565201961169634036255655471443269212195094802432760059860649795584490771400461197194093789822237887364828843533343803265402908640329504214173015878374503619260724380196188405664335975378868129")),
           ef_complex(e_float("1.5707865893201370062456317319385667501390121456970376008372036881543582557430891077291207589830901648669385576595820037301615878023712835956319544089148690746824047633985115030345719018482669775740490641899485194430810847785652716298549935896453628810113928349879103826489684772022735767798740689473023715336540408286538641464216899395125620562303744315505934411888992600502718752634574195604863713337"), e_float("0.0004522962871819530665136044297228878249664068443052562265165871994537642984857032954599983368477029318616269045595984167461063397346805135604665286477974214413309730426376179739289656425637499289476039928934649309645822813951734762090175995893531270013569048580190960349057379448349890029529251565948649277016938395463910164654700889252832870074396785245347419685388986976711397771181249191140222297")),
           ef_complex(e_float("1.5707871871431600960604931636219745743852540492216182662625394751185241227836546738492389201047532213072016615807070595835214137358621513193990446275127319970319474535040981886094858802431694384644755700621670525904376773980594126280184347781814545085629888906883378854921933580371936551037246734688652619318713429255484536564676163695021061841908553157717501706911237158548392134146281951054996327016"), e_float("0.0004336627012641454884426470236277998668601790557250234008732692413686726990480145940334855056330784624537064568173005654432899758400211718875689869465989258904525819202904443424378152155751072585579996511719172590506874063065480035831519211072087220996527129286319398827545626283425929888294953043829941127253673855704157366949748309194839284928778737105226583013870410431605053223170517933157448644")),
           ef_complex(e_float("1.5707877370235554317214904577798841995279585842143925837604038405798339797019558758658154568773046715299676722444997686699158553182658016436824933524506861448846163813709589224241199879767904171459315797211428188486293254803991121459064843745566358551979246930039038728935981064621840557716184058758232510199904849751715500853281213755527822479349807987058033615510106964759959744892487989791285382956"), e_float("0.0004161570242573948490305960321290719177581761926403963487432898468477430835454240626311728367918819596737494281255701319742923815124114880137952039797374181224107571803610324826323983242014773050093791983613381687201924262217077495109523462171424771380819422916478791090855174570073444906297450419905587654301510188595043452847897487528278082749169807553335788592150642768844499802366235821627452696")),
           ef_complex(e_float("1.570788243671604474831965204560882747288368588789570679551769541663683253342153856721062881716565956709313461480764894727875109537012230139509804865524242860835592337311368828971603581945802016998852352972766744512751318279152909703488577153277311286667823093802349081742652001686619216947131342956791981907393315732934746425877114303072236314050212290818007991481963373566774627037685516263305193334"), e_float("0.0003996900516093324334754717634365935566198087111370308540057906221988028431839060730700192424666832168369249269402594829621127013620214383183985217159118654544019839342818626857435037487426143100086320584921733314133011353424145493613736155420193159692299745420725494216839203313556279478117567985323828318135394726200607903081255696791555782485864353917845004871108895589709040521742364584783076276")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02113_z_atan(const bool b_write_output)
    {
      return TestCase_case_02113_z_atan().execute(b_write_output);
    }
  }
}
