
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02106_z_rootn : public TestCaseImag
    {
    public:
      TestCase_case_02106_z_rootn() { }
      virtual ~TestCase_case_02106_z_rootn() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02106_z_rootn");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const INT32 k_plus_one = static_cast<INT32>(k + 1);
          const e_float x = ef::googol() * (k_plus_one * ef::pi());
          const e_float y = ef::googol() * (k_plus_one * ef::euler_gamma());
          data[static_cast<std::size_t>(k)] = efz::rootn(ef_complex(x, y), k_plus_one);
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 101u> a =
        {{
           ef_complex(e_float("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094e100"), e_float("5.7721566490153286060651209008240243104215933593992359880576723488486772677766467093694706329174674951463144724980708248096050401448654283622417399764492353625350033374293733773767394279259525824709491600873520394816567085323315177661152862119950150798479374508570574002992135478614669402960432542151905877553526733139925401296742051375413954911168510280798423487758720503843109399736137255306088933127e99")),
           ef_complex(e_float("2.5170959652509175140543227140021035814565046580234322049869387200747016351165986990810681425942262507516826700899681833805592754345637646359904196665132865108302973650205549510319447461279363868196790088906911519932914253116113099215780756079222972745626650929251422232022391033872107934615691539118979329868088701348602109145470294066136355505159074932501202185571955347798945662814408440831616418561e50"), e_float("2.293181002512921405298100779075648722903056502053369879943255508028149500869347065604415691555078456199834592074023230693899188090223203598052777878206151959764611466727863748035991029526931867763931380138284693333961628736740814161101507288193956884215366699814263036482627216448958897011038692723602651497193967240537743542142119571460474155359946006912437693699078094076589790791949724704953480704e49")),
           ef_complex(e_float("4.5676877571349012822944124125988156781931086105768420229537579897129604799416650602669847449749001171331380570941330512994161370397400289282802889821835607859280117290493064055479064097139284620110837242336973560258561496576939626750510467425745900601589826809580442292531765912292619053751950296319478398293626871870490595041500607573517174059421386954637744862538209743447097911860406298064056171385e33"), e_float("2.769988744247083190031371182949975288744721796515523810949622370426608723388448717796877625781551627922433840191642180761395698933405390211617372985569598273883394760851411235704888930997689977580584055254387752373773386832689523753394757162321981956823980258382680186457043516517499600880732905146550808980149381666037538820416548202322415342502132732006196792828930803229723340813378049737231547176e32")),
           ef_complex(e_float("1.8886721189201865653450549291355012170977016731450494596319683521348119435395343793280830270627346573760602133375616938821064192212389896386944143050164413349423189731171341455229980743703807126788930625467109680391196702369380388503279768207521865580619179044138896114460381817884670941035265860250109626120264865257931682133461687813073390151427509457967806373308511557332159532236835910979780747298e25"), e_float("8.58552324207617539703917356994363879622829734123305522626533015286083161290019570545152766610868427601864028161421048905509709710095406738633313904776859801166968764466299487915610416966897660567172343355658501388104928712139623074118587986644068708044128500809697163933090690479909357703639990256520741459824387857974236767565604412068415381416547867041464909521525831923645770150873917504639385779e23")),
           ef_complex(e_float("1.7393180923477741218768419582810439211807533736423571319986591576153333179480350438625436991071742883543610246943359080113225988692486159415146518418322594874986203090284810412047274052338201063605383582384064593923175229435040216672511331808601505688172380588279902791031282489443999958959258037699949966506787446491013709278544033731629615206213956165851391330484841388079561809443730893901578990663e20"), e_float("6.32370455020924293814209124649068189496753321529119630923478053845977733279405374459670213105053612426380877949803850993960548419747396090332473453008211156659590150423694774808000019991738042029769959572713817183596567114986576189366900568882149173840395046044541393671660498580412042934729515658202297131784029549404924233694728473883642890344315067016971122554175376792344352667434540245982641884e18")),
           ef_complex(e_float("7.5896061571057829941600725311640730814170436602552880842229193540783955831783481242194575325167685761948333931338904183588624792140475767600548998881507971823209483907500940313710019274815214304546288339085986385735328512247108465972916968150242767235556697884928079487965894819556626087767608781063360308133870281653176822404060446621690682530075401112434814852585887258549932390036826880481289001096e16"), e_float("2.299175381835378965047524215946861591363972119249677776833683057146756035615907652228376132114837741791644971939754659702197285658577448041491534795588620800409206185276188014669958560515850990771034452383067690613439630387787213984161992925080690862685774282726559427053436770461308611109534114218661766679422811267316171635103117271257439941736555306211272595303758350090170388082722739328311622468e15")),
           ef_complex(e_float("3.0084830690884151571820832298669098243985453791913672960777119059395854659296448372796648460537232124600970221159652531667922201958623671465320053367374033406797383096346458916327614345042602823578679641569626277469474043934412902423713626005808116971408114222923809859718406522771241135486972729926060582151685783011142356616581885577339787655154253095229052414684203482304576086388500691830871153456e14"), e_float("7.81121163872024307858991260172159703270612882524710519983225873566191283191836852742366108907760587835205278740246229825194878009615147929493071620983131109950729054447716912849069801225274767237797578877814035920108043236090878660661643643467733997544505784790762556254053456014902571240323283181026694037387911556267690454339914786659959941006273778876964537541884741397068189549206782757197757255e12")),
           ef_complex(e_float("4.7404451627409658359402206126052626416496283336081840641184243568204787587220112093776617855123067493374295060700546331749979975327308219813444054010095331707893105402345608948544236206061150674271243332635653946640965665251678225826870930325412492891088997793445970208643037697256639878238104214096654722028200180771338511943684495625073087684581172368156282221386336755149837429411300586829952686787e12"), e_float("1.076899423470466630051757909858149775666279543843897431580430528975015962498525528569824079307982219195084604183790334890528873381466623124516255725301475346032248838670819343757960197936807567852383243242435247243468915740190827053847982378648863956871196914566660583348584649291981616870793779920763725623993282114013536381481553605903469223278660063457290724039154623351348333647996481629226930057e11")),
           ef_complex(e_float("1.8753807765687219113059473540228856662210985550647548297725895403769633029292452728115359847441238051332490902550264328792675041511603270293016243634405729592465640213531331608527490222246937162971450787079880962354676909331710003303468492447074326709518009923658448469542310327360641129586852802761988582110813807400841952832986302825713394848454360088654110693349398085345091710201221803717995614781e11"), e_float("3.7868428020705860652183020668329546406384038487260849711415848324099930894960607816405734033309115502766825931816882119541668947799390481981261328532467125102949122357162128712952490279920348942682680283068141119711031529106450085543304868770936400019525870107873120741046908937072566080678846671172314092571887268333151655258502357162681770579224192888237688480909846851810915738428538959582285652e9")),
           ef_complex(e_float("1.41372269772882738188317142521094372398394486420397133909438167787258206810227381286051264572027008012705049231088708618265449690290810587117767033514495227853911258306556869143988016474707703376799807810112633659604083757058900380226658080089279447474020561801434367525248780986199321524707660733566719486551315080689181047022934730193502623403774084160264011661421946384843770398564425110228209167412e10"), e_float("2.569113810644203565155359212044008576180879429448389863810864687231708004589782440890998123493258844866456276722596579400258133371275187261772679105384879178368188360669677544113770115360690483318404559825381353200903006824303801630371244056577109820807128763889112096140022453924249086520443092738193111260429714657978283160758533632256983408740001922040186090569791349080519702221955726320077073892e8")),
           ef_complex(e_float("1.703620054241587165166792966326381364364257156513890218045969084311628994778444213624385062416242594665670284832309152146513372790933787803585646875862242785840376843644705081548982009412130595472240640235889287217031336542523399003821423874424870828503122656689540834735414023922431983938068371496481069904214402946646464061198525418642466691621534427229804254720475821723923792018815778795019881594e9"), e_float("2.8144327445963105217323703455278604492872581334218329294166754203624308794402777567785139420517504879587372914078992598125511109280002792500219181351925768410064918448601699379149300628593983557197318866969321786682279643586580481047284821110920380894173192602779597320071121129523049399752432181620208516019751481718791174468267242620235820174652621533873690607657399013793303487378059308517997616e7")),
           ef_complex(e_float("2.9190750125820318935026576246580725030457081611405712032264224907979713936296085459510857866777712428595285316021780314862893195345330739810247271782146656584433196645638993540443790065944026180970040867440859227039976832098650077398621907386107574632060188128582265740707971403095286211179151907223898714205445931047591852423713333056199317967578903542841840417640940255329302675266364742240929456063e8"), e_float("4.42047069258878851518233272420961050336329957107536888317118637495855351655894388979375805007222533671250230297378422757520908461996777648626293326350410949545330261329364420807475669912319378550102755209436530910371189050435709640672156733379414901044428405558630369723801086158446069117079406410886412558772795065982380416977382207498321773964679315091880658236409323819967863625065005067142641987e6")),
           ef_complex(e_float("6.5576779921017183963123314893982630088263536726892208101907317812236479561201885528332351639431384505447402703917817104911401018662374247971695478876571644908246339140010248984438772790722395327998090599263952435375857265516523510520273436799334345737862903079534222536497525655538686255967531165822016035179732426065240152644087617936253557155891244374865706729072974472632708024897728010572745108161e7"), e_float("916655.884134328291725401981394883155794736327963635734315725498446242880726134417951078919566111123101970685154465695370574049195450122525937697188615211990537589841468215970094277126445043206157442894207431824433818313488067975944017442808268111009253429383484232929898428240235403180223739639589055866107774149782613489272874104692368778637892318236731600214440525493779355721011094666715479450762")),
           ef_complex(e_float("1.8226887598147765088089045919247650165172518331569770297139864479796209909157224002818646377348792895496753874857407413002014725328368941377581078743994305891915361796632191844472470642983521199674916518032866677051378963460293142915423428020400469685605349291460404381097163168420259762309800128567491832960497789744159546258260676824707199989272784540225244835156875687909694409919932558892000865724e7"), e_float("236581.171989952462058422629527049532687094692501065511470595071264607096909765820043022949938129704667556410481167469638804227046160242505673147353750493746593736473629763720319105568983919217341082436514223038928108760135580350830016622166129260844498973360285918816560263346434722327235147102983742253266922797375123247394166532188175069695989606392761319210622617191929720873942588972392380850185")),
           ef_complex(e_float("6.0070996836897464243039206593813441632358567141203379012208610728170917385614423817843290331877071352757178049235447102607302862817322978306869355833171317618173526639603714913064825082120314656750771527991303994546850869558692188657311682528297026663205422091152655730064891636789579044509803704332269024339419645000565753254723911460692853185314664001187015647810937205265201565712649374266591829233e6"), e_float("72772.3057622220480146785541839431418451144504286715916992802191297844495533695963730167077423441957140191826854565769880795836622132476886168469900249541957115975000783693532245678692280940459745170767077622017183235514893156292716716156826332864169266303457774746587926943776842714189007759363683540231924179041890277079094807468061150798279173409784797724467265735330727853088233885210109442080533")),
           ef_complex(e_float("2.2737983596657355962308409426935158927163816550281208455817401316211994670412650108482215511713487111185567634142121976312313946713724256533652209505224804413688038936578212508396662905733073655058031947314484745263484837663340197765380583471262075907439107222495490861921293557389600773705671142743260215851355201123594887088998582478028672862563969002077486498653693757809192945358421703937113835775e6"), e_float("25823.9070233550080725233419318852239206750153712574980800287929625895891344169904755668487200735706562331787084770050073209192208665437179399890624608441617716500449060691399363811806126514889856188438954735197376020886317292424657489178616156069765260647529686555690784957190205230975252554918447404890675846865763282396379093068681392447644215078147642836447768947275129412776685885989060493844653")),
           ef_complex(e_float("964663.11998837170922990972251947229785514857071976755368157898334054718283983165937279949789991802567544994988673860649966948758679909981067188905719775502709114876861486152809068122830012271487221804120806464185952545632496083795908011282703378210858114305028166074680448787411900207908184328563807388258188099012351492596412069239532180898266106487225554693341687937452911605835532402561184298394312"), e_float("10311.32807697840195180566480666520302148492339087657551024602680935777773071059790278612797848188940545650938746175255011965297640834327168120941861403969467676669593810369923137622353700918507294956820262708226607538828334027482427047461042548462781620869932832267309652712434064917967027122174279230977037083308542557707084210190414743311242258301253060204281929161440111744599936621694773024477035")),
           ef_complex(e_float("450081.07257297380475207168734641266297421461412533207372020544452940960376954067252276970723014202549536765583238675884553783435531876768865887219042698004654607011791572209218819929689203615986793187667906757747891318138916943353231029170315814990855890807325018896957851334194988789992856224927389694206883503912238364529454170406027033806421084535484195298788011244095838120525410640495260443553307"), e_float("4543.6441313219544911307536096884600293094241640367637868133171466887241964772452614863049495746227004543075045056745599201794853415801084206627004544001255939353972032191767944209474261541900090350763566231939656736482454689426509532218038246395089815416387698180957786193247201621265349308058898041327377903129443369624291817867070879949255411883498336986106337008590914119125523484362986432311081")),
           ef_complex(e_float("227502.45206576547919238745241940119056891643070422417523980154012044502982053157565816252539630562976842962607585487122125619719859349215735054873062329258114360953134416910548440397254926326833611065809501756166511859514742396351077960635192853484856909707343992301809524209276298475769672198203912489547941291392442268071243935852131094838218500612024947839958328689640435984104847077264746539691936"), e_float("2175.79028517679813727601705938210669843133614667601115936188715614978515787663441647430139537225784411800914304903742482447238971949584225864422355350338684938859298612524277077652202104043561971596451343681475960556868368333545592504171346795041880984390706545574592132432558599829145770883981055089000130640855892075615548222198353532370326960189602338919233952086311053689976453578818017943359842")),
           ef_complex(e_float("123098.154213320125295419130590340577252215750083307550864936362244769522138381872979816670870567978456619431346707976951243231525474456957223978001520791801634664573351597382723508441330151706011532619527313998430026915458457517831885260398333234129416309227539234946400045687823586210774672901136700445350968476832439360589577059932397332261057065217049584789744211456339831071210060785451330882205907"), e_float("1118.41969608753031582743522165145585188757259323470985848060485534458644420491696419490586277960862691141982267311880279986722436278056426944465248186280102779644047926947789297596435951579704928482759229672629765168292162858622442209389124907275780225040782999041448905001859867780107705182642412590346924779407464378762011342029807518416231988383986727630643903063188424729384260600279376430999405")),
           ef_complex(e_float("70610.361936015982991747847823284177151506100567737939405276091940112492068269605529297518065043301953619635539007545829715187154634547525279038309442628405024336838405565956029491734533982730073822772938359572157158961755640587112892611133268053701540391858919538966061720017520490449219548486261258003654370987940522530502847076070510663770020666258811900185504653305164051714670691873796113624475911"), e_float("610.986048153549387023678179241901471752191791459897893226433852511054459232496348814919653041207282212696791486013059626242148828962179225995886494162664292265664273208261971608015567747775102116972350712734613466087476230463124869805640100228851089597134890464190997552086624253322061549556475328406379681437084291172826788438422444728567455277095987230441173138083566951501031312110752831983529862")),
           ef_complex(e_float("42597.525146589214545227737810996951375169455577888417276757776484051223389464321091520008484646574140584554068376854305980218255036793004930737205259540061138941967955155734532999304975900016403600576427509534940093623404934846023319736266023477073450357209053099813772029149158293136290660819362399032353213382812914293888808334532619264313630747941501137090939200449327475342416984110714796139017314"), e_float("351.838106338950967255312109436184385803780715833405174806445450693216493106868236888279752032774639263886163945244657630913375370556450648935452344713274312159866177718712254264480179099928489259496197279720258985089335968974514914187854309804981695150406459122111982084961227822631582590918818976739608756469869212116336474385823668601288588853482776700055035432942203667379320036714211880513503799")),
           ef_complex(e_float("26850.152543667484058931855459417550124751509380546138221912441625649809326621261530943801981268871612835257028706976038220266163154812763122533080491983339712915339946279470741954562269224227812880309466690777834414202525078754761082865377609862123022296523507348453511272405767305494483134863392418788648434914881946917090071245141484533205455702406728750748415737287807995821223614949394860628431536"), e_float("212.128620990267820497641099622045099555357179874613022483401045896278415521050328555029644562564769049955655356487685266010294346040792940214833916845329090088334012204000556334900251921082016060642045199341362952775170579115705758524152452100304273505599223756424878189995627137243659632983663157636061379571364759416563239599832313590493489934724695570124941622375679470584431915093265886196022617")),
           ef_complex(e_float("17586.442331976435563548500175639833100604437247542486599550782351044570543701167475857052179381796138631639546882740755967607531807513131856473363683356621958016471908136886440470514144096092609627835273427077857257141857979699292008798422458571524981609504986751663839111885343726859416466868787609781826811476261411748908979425482334734983757299567927564401387394342918383204297595029150196065053719"), e_float("133.151591154376584385247420152310526451947568806287911203573298225310011056867304634702953423371910521804958451805452905699898506484668458436913340118899936049892266212853394860988070659377608523174736805061408258547526916453366412225986231684525977448356770859915782621120568549407271001584554319072229101131274316254452319188760796587726644821259927884123441533994064925779987528378487900544944849")),
           ef_complex(e_float("11914.6283829200332739747438535848765163035451050895254434178942820277330912397047086235692805405945539352315547935821219338486528451917243774187863337526853015500434466716544096788422039710349473367222377597451634647512089050973532763758435535283072377338043633587894899015018613881765001023766739288786739128503954704698300858035923924793953572766849575598574805122508836727151247477196343878722127943"), e_float("86.6003110716644217539586147039768649535317657807801700069974666639779714507165005989771739123160316572064471963244595387289525339461560435172530859897791162745996517783471723379284696668930872663023789730992871084396475411445401125949451365158557924160792508901446691046025798494230508154103634064024346432657013077362629735888049466192245583520722767792195625367581576412056855164506021179535439656")),
           ef_complex(e_float("8316.9430364400692719935007608131894020072621269861789185620187251621495718805995938253572210939691567468512856779396602487955099094963193949513399716468942989765238308383046755753402054105137643359516598616167133699985654180073520477165049467837239171108615011916014238032827913116162476485003371912159853832852255269780203976968899794346824631576904530985378629328760364174113849510395768397217072142"), e_float("58.1257756699766839123541554893697552342580501662403525676895879163158210490730401274210249608249593321277413774390528070478448823828192764234956213690254375843357724547890714698521043719484692602005339009044425547317811261541157254172813129511302114378921089224340073219762289617553100072962608732715293807347493534918765528709629049201152486536255896451864202629689603562279374737270997121434342295")),
           ef_complex(e_float("5961.9360862461722960615449215192184850026613169240671391561326561983402985088921798017620349214014241348382154103335154246913366785604277154198901126479258098686067216683004921719206212935339597851065421224676088815422563107804924865020698932619193141207486643475555134195101890997295520067681015536949795599536347071783465808222282837864265489080343138253963791142606334791287988537676037644714561211"), e_float("40.1237411688885860742644638040881650694206189617876279601961084458840966420779149497449809283483643182619175945590415819519925527496948088503763625363985930388413150715251767552350550132655363278642623231479255976839098316791122571167505944452532152891374699375487784480785835142652965748283722544362779100755315656099265299872227031991051949442573815471390576573270227802865252956823289225969422568")),
           ef_complex(e_float("4376.3946086688478391234157301596518075647712976060044436577539832045422441177377617284587873077544198905079486378182386716761845204342106604750256562093090834612582674987265192526267695312315991591190267092568668259723476607507332599494017869308312262917713118779697073135418870409764255569041430495235279146631623060324812200724429321002463854521345059533913675438436766396756632625746663438720249036"), e_float("28.4011451522665739875413688134311161847708871457892273758667478529276963435799916167869730574589748484835926844130067256216220415048789806187754511259087914774658037402497495660737389191677470961255278573585285902012831033502305810139915573230997085153526526426602832976704827849454904719681066156086135859552206318620220908464445661949306773091228125033459061153187789000745952014235873668313481508")),
           ef_complex(e_float("3281.6068866451426057237508720307455567215873208402972903191766280146641906965597608603224645598209831096280837644584980640985599360319661066248905624306410553278963840104635760257928801416980571753167409704396763602548669003601918650712057812406443005949331252117588216373542464553026896426051136073335872509445798783337965229923275138288867626364142209992736749729842383892877266727141359869445292984"), e_float("20.5620093229891859478142423737404419181897380482288718873289412165150461953870865818758441273808994883580077937762454137046381418067126710280398738951946093564626530136403728697518327188185138606139575019426189194715776486589502843451198391919528196212191477344865233147762460384506229621494524817154776803427113211429270430229452427984493541605806526984372758554701980401069715025489117425333315186")),
           ef_complex(e_float("2508.2725144762967238394737101271210575598678677046426803861674386289919512147855203762880388861468103467436123504267299239119346338163073864976072814488808545880539246284745399516559276266293792526859746593747889851330602249755850271605220602065382756834449227051863376285571996923802409841687838461488611997534280174987145316702471632999340780664286367334960452547698612439681857784353134495680522031"), e_float("15.192529457827578570761850819224374672329531372731161336786795635433869157002098197802268717876231513374994649314182657722804431714332420218810892834333106777851078644943831244387766394423517090210824655788066693561959618074683619293985178083831873008473504469246546793317726246085915418470215203074274651213664782930621682922148620430447180839999901780643031194701128986345130686622964384881978767")),
           ef_complex(e_float("1950.6398303864204586788502199506412224750386295909629536093302637972410174235500689332560284372701880634815743886089012083843640098019827527607973798801592978304147483056983270713113161757796278356586527061295316546923473996224938920131133462850876293770023820964979831930921614706588097845521549536323171658576713624245946961679455999314547334158182932343414087363433102255660863234224909087649605013"), e_float("11.4338286519292509132010197848572863616372460689938286642550900234459979783603896324039665128458083672838936473052540765582638893707386467948520557312111900950632483636804087733508447690873589929881672127198377981142573419574330520463332159681073448173612148312220422058767242840195768591485862978310012357688697451937414375197688936245859394313088630222319581584163431671744932342042444405662054139")),
           ef_complex(e_float("1540.9557355373733637326128003532395573068704357963855483150877316354830994634713568786863391394956955386363832952353604342570722862634793100283490784972205742622401121878264400569758231426114689215180977916848952772919853921457636691993570115435466481233390838522408542397069506083270364024224199034009056176665997101553226138397938860786483492059471851648631203573165440847117533636881463219405569426"), e_float("8.7501634350738122808156425937286910486208664152498207302934936939309820503832976401774511542860703242684887769917850811839179689753979713895514366325215518682346590386716463159235841831970920990849208381551014366026117230408039705733920931895650417214475395089115895487128160395770179364255278878648886286601155816089280422286544247658591013557745437182561099791051862394499592256679729221322994074")),
           ef_complex(e_float("1234.79719993664244838699298750439319247869415245504311904822717764610705691558542846122032119281703894759481563809131376433035214518535664842145547181984537366657399934176219598898877818099644469389110112409659146332602893557490385314636612260897374861137904908746944287329687367011169597822364396981034106064844813448587808039485415209067719676799473099106282388103298160093681622541186101004631096846"), e_float("6.79919343669373402429455587419931729348489491217052521245638310622168117715664341258954981298163689186432523846713906107945609563962700998563104416662389774462103953839799465303882279628352869511342533078423117951451967767720749696195538890570565730700828536608665459019485248280095506580839384278900106253833461346267109558002984807227550952063487097556763233903617198753522187818870179690155975885")),
           ef_complex(e_float("1002.41570773770672540579890175406832331332207352439938418256458493567141191024730852626487141095763952297458970960356928936675337044385655801927213718510845697565667943926503577125871871966362144486853914810115104613424430499911518216169370199262465298727811627364503574581861573035746752207678939554132923281945999676162519138414747753449524287606359884348312941383936533744008242237796988540463821162"), e_float("5.35728058386628771822018744607969619573746585822186108990664422210417224998710160780877505623086946324280974081940590270997795198433049281204006768958606048472201785616269703826156879918636738468429558928889875399625914301301338861747644757011453362843717459830640781948220251158563211755918113877158743343294316984629315247901173879966341528787895582458098369351136067622244236571212608796125565032")),
           ef_complex(e_float("823.49980413181821592953953794066874610568294119817694370610706867411560545749992046745078330614579018664981632009909740501558377037337172879021821216170483935101623814341210701479468763037975527699684264102254688095503233212947909513277058179580861841377227609020792293527353873917610054876596714596084250634287371511492122726940901687220304149981936985365087077508798302502138360114206944752655797059"), e_float("4.27534011213431903653649325315108881115267504950299130093696646838411851461484384833733869891190202103062035972027807089546959638657220788553806759765814227615402080827942584493365988491138967464793595799610254791811206618104297657390176795774139390694794687932850101988165631110912254481434093020199120176251295807006122332276810675768923620366287404295666637436803334453398128359414514029709263823")),
           ef_complex(e_float("683.93188567063802135238626264743402318503206306566495627458962927817429400256439432084635995208442555754346811775374135669683167956905662555706238816657511475421306082635637101664725432064773204973800634030673478923143968136667512458257343689701652657894189073879610927193188385500234927914648175833033326115285015751292192651779027348296301835966704996213463186857649856745063321212062269259867984087"), e_float("3.45211576051286283520366486828065365218381494359508183432600797609781294044372966517446018438969957910719585196054555297292843821889889032170300204339783754816663302983754981645380803141241213358940701726871569365036640988817285027917256657285897147508518096045291994468992125587136210206167688237045723878308913320746751794262892321534929283000878735114530163063341962195546432702267942052276670754")),
           ef_complex(e_float("573.73669673059595666848620539949304421608464017247421014052589750356255550376414921799351721519099698925357770511576926642937168728078393944376920023579006727334833309773941642904379143806083592162808719678074211774164714832436780497522373651894054331211465039934363982978678001372727051483259409819599731363491143650084493766125259270274051523947675708410509412521529017499560587116311459803268233076"), e_float("2.81764132174681595476714040462473147858116233076723002170593005104178082502895231273644503198573295477386737371473100019027904279374680738566852767626345572348377397976842803926561830657981437476856923139894567658488412482127748677147866595049322328207586160529425210054792029036282913165604748534077670496125444959564985210053200977042588491672363230346682597610209661629965604970407900875090762128")),
           ef_complex(e_float("485.75787297816695213073368435550789175232815608979562612067313517305992311494807054358591140242855664430724944896099619779741060016698801377760373781327426746178299873864791120000449278961248995800543588572330604350689360568804667631639001806478964385418914647976231724142717188902706473701704717718938293084678909779221828220206292801476544537050279261706603200636831541216868289760968047733193724597"), e_float("2.32279495141560185823225753555048982483747905066698863166148078911849687928544059715606922141589935662335528483579865624249926192987502057582265594998895924412531887930621470846072952846851901226098454867296305882866004286630200738591024230180284169257813834389422139572913923661252293611349350002498393217986110709051434961467000931615147118593184904286699860146424674461444606611913562530868472165")),
           ef_complex(e_float("414.78846336426733446622666133834398727642874052919381552839457600217172539706994378903940434310537194884304745975786344948529850432940516047398262023472451302142725227516976973067827380299327099620442698245596909282911163139428231401348359432718201844404925062045548207459861876982164652605089415151817367444246090109015026012835913163368738819393404493089150175827423190465694198461686429348936423634"), e_float("1.93257570663697130977828558426712221481038588766390883329701408391775938720767635978244038009427794054176512725699801651337522194024120701766699209527299804233985312257393172529021902317037578453291415536884281789296084668429079933871864057669113151781637357291643777108508023964703919027479271381321364387025625229014343494465580303558110976833939042107625744698352911600662275865544633549235840213")),
           ef_complex(e_float("356.98995945970917742308228480035168342557254417214498917286851216265162087034246907379610592128592049755700543994423127955325939236807852236739497724920146006144827692813910422537774849799019444017949261538865299374309216007647628564875609076534507352518076276842675101864055520589702069283181995731551880206460575514963519684471338325869758009957861669010020349904048559101832520821183645147981510349"), e_float("1.62169922544198730876856689703627729456789173737926558586995045469888903721208036775308408443079808009805289855645471211355892182582917130316372810355988358355274894117290446481662181997020910072076964621985233023701339681271554295154331063878819036958364471747922782775707965829274346480640439840539151728986308001075231930699083559513127819330000274765943408508913721784098546522308417350488304477")),
           ef_complex(e_float("309.49794044825349636463859173252842270519734788671812693267979292440879404038989973671135695432010158762996101796366038264730958140426143037933652996397661896663199374457727035841500165411744276643434092025416592563158605421317498725282907347529769676899713701878740856009540559544241088547701636700167994649387340038344389181240844470354507021979366176405161676533539564885338012264619803330133269684"), e_float("1.37166501470083075032077217789178904159084146350167954803411260482456306906887008400071867353417702398094946528523681784323902633130701801490757719246751852692554022260674559862081643927783346236756937495744794664422120757266781284283436076385889381916175421017341975947115276373533932730612591856359890577737644340055090681631047888855034644195448839491849743291547119220158965811225461923110282236")),
           ef_complex(e_float("270.15043063384539046389285696106529518784114854938378886845049275996874355404189985836305323281928412522163278639792761920485785878616908160630238135007020344142562908306270613252715361181521517494697706874972409639213892322598956732168409198903842617535518396345530844964360018952148835214910793187213761653155675658567662648620461539519503576169450725641519596803433613909726082537134449043806174596"), e_float("1.16877360494329783097507287823221546899907549333383022827490085871188970813423386579729762867829291474867713426376511807180362082025716809023047595644458997910028248904111883851465496071579840645230855082659445588321514376664066204358051991853297782304210606531810509038546136988319087112042433190695557482016521929146742370131699110286387983250804661376290173845943223326651209567972823674913531171")),
           ef_complex(e_float("237.29819924721116027850851201119027523626531895766141209795459499309956445967312027331093841854439275248118170796287071449010626208276894210595837525534703845283233746333190421011973170042578946973731815276994794899026346196110169630452404530751710701455011545887783677677315795285681626492915029288319987378117782185129199138207367699542233520964846867180950882974120208891915211842939147920762280382"), e_float("1.00276665463691133043307367049535223450700858088658901271751679592400981234436616612196912573202686256392898077696406639238010561604124417249897456810383977584558680745421885224139681552929337168947093690392080661333232900625670415841603184375140527827102380183581379559239811095175913023482875380371585587228855123795806690431133350106377245171931086257273169277040073535955231751515605263582017581")),
           ef_complex(e_float("209.67057113161557232295130301811910623703115929881055563672592283346929235285156641853556951312622826621855882665751267060208540500289476282876988831514174268043807070755466775920350756941010596806803266524227523780979331265140485611978120176047934147797946518967956942773880734237056748940301899591104451848546987011160421984768186301492598380254535499248176374946438541024941923197188631251820024974"), e_float("0.8658817422686268705605937735957348668447736534578075314737813808636437915181378313893510688434095784681425168613477961081774379740340899019830801558891986831895065156825797475774054918661157527858356162405930699325357206537335042671813267209853819285502162198144884508554467814033280908680467605136024365924603264184702852882359866455371512774889655073317494948131271357559596583392414856779831242")),
           ef_complex(e_float("186.27935358166761727164504569977284143076185192688694969011922467010245820213063866233976581766166854418198288656152220448691199592440652087073912007104349030181929429450497101740612605608011251855760671582244114386773724573399801579351000468130218313358160440458220891519049256642254613080947729477374864924811980615664486478026096262505114850303930951569654637737576990810515816145769118810472719975"), e_float("0.75218709918947387450208895598417212492866557636952502055719203660582438409730703548711705943870312957646609271699748698466889379372975177075372340218611510472570127927363296633801205734329784001150204527982736926542653958478254661826275395704747341262843420432493476203126602412808303704933438801995922290031442377396930449883889995514012465704555453443124362365183718613230340186699489314822752077")),
           ef_complex(e_float("166.34926924427435442516385405052191167421958249545822747243052825312836897727766563790922646759356501354351246211300103353843016782693194797662260682597371561067325898950150776462973829659339757404991123642127903127414988639150233491222120287857024163713403127395859287039757502139207573242827771596151773799192249489379360011884306896926269098434101786086245642173939013129012559142134697651538009636"), e_float("0.65710782109276480471541153651829451973194865335045484925428744201742049116473035786377628837747991374262314505851964888837752622626610545791002917009422827264114734158708280468621503987895535785943420630212599514269088183489725566085737637823032886286904223272798346613873449781669407524963175872778745792476050732699393129749239601179959405974178356438360228139224378719474203065915002103945942638")),
           ef_complex(e_float("149.26704254343549340853402731545293636268324857142966478625025346582318746575010436177929252699478289765436742910043923271252590382751175363526331785951843179832688667736413471033251323750432548035781911538233898836914240485933213068501926360071491585931082088476633624917987240822547623636790318745661751573118718215543028103631585488635782508688737523653451805509537013043301672269933869132257138091"), e_float("0.57708468075717583072238968850414418654197862096402590682648955394119846991962753587139722160220012426732736195803813676529623563473349901255148818907617240993782319081819351339366466787301334558345393573884540503019022752849285680454089679540407716506593327926287531177157149306219071691750062475587581092849386833499477389749453042895436476439103285972049617423294129063108137467925084871282490057")),
           ef_complex(e_float("134.543761801588055203663956058742845543211374249173769427884023884932094517257620414629417350983109337682435972652879082931994147638741086292970060592642078718017993207158407341595388178215255445284116439968769540286403393717733762712946244072251962276989506348930923520962317790738904732077840108772555561640480871009090467775027433816150506835683435901971201235899449700931783297693792526950570391131"), e_float("0.509325845927930461289271613997794908642167387494433400628349512645704402574531352134234039742735213529961356297743032813309488523188849664178777715949542697008075477781652636570665614308838791843701165562694945237132346106083005094320925899329566077832882260286899660022366293164835378780403532337765324745322972527165633734413907500318816015987410388804708297868768188309113454678137589489753401122")),
           ef_complex(e_float("121.786790403198832470638147996224674104524086777411717364078532579267908297549163200155315886909975358031276808031036794388110213547904924771133776535091187970555596957330594813619301818600927305514453526858226445879472236578591485160350003717925065672597553174297688428877273372660505325076054492461916420426010340865823669279647935055056649989454523499845778767796468889156164829215772648979874617059"), e_float("0.451624410374531696925050008855745774955167679386138497813422183265063072279526223039084395851362253288317409098518014560582897333978222893588557666547554195352431560857245924312614230526697340600174604919149466610575564903431805875652364373564721757457850394154147858490187111294830002400541523074779399004474833309668675377927892996755610099632222307509574082062934251515555908828610757036549747668")),
           ef_complex(e_float("110.678615655049131508487872390582842727606778148459928775401434187564170089208654457913490897460154356095170319561424107038605566968743306170988066825482212690157438061775671048004200768310850497366373507831231337444288557825301611314449352750229570119979289378363328645021151635380747670271868957607319460846696601427889644193039158514790191331252419097052638255770129776363647178768566455731757876845"), e_float("0.402223034136011433932509040985087339245428872689757530716283368719494000269224965465168188156166437211624440929758036617524459603386875475183824432871769730438981312262400054248467489776826844767031037666097299360275230860610497178714954183596376057888571868570948986998725207259648617462152486812685281143058353875541998516435504634042262721308826680939059979966326744654044861678239194244513128924")),
           ef_complex(e_float("100.960786151287188640809829085299397310864881734036702190000914539188848487184062773886993058583966853074615990118938403234522252776291290832732339827956109739700506183513751679682655099945933304197288907250418577774254529108055890758344435950757627881753061797628460795227187595055167008180740377362847079738275771445073990217428328034465182907521271459930905194855250078621059810381929451694732042513"), e_float("0.359712638433265226840279906730176810293024900300229241488830523078770416348400494976904473430448184315971489184128223671486650413009358616234071271854566566369463455345747253868927379211924972682397051065295850473631574395172711798674319702933821180257497321280896810939627589988043061452597704807218968305167932427591111773849709104304901512204719286373452015745106592819874529718986370147766398688")),
           ef_complex(e_float("92.421615035043164139985996182558825149176798058366466552409366374558462339808850815877145635141166873243270268642514145840986276272853696979116495252409484581346968916010485036414338157716920945527048833754130252211171892831411872711401279316638822478764179681282712773291860004493874914880998810400903770303099357974805180118204867461330886784286493517685629450526297540210886119413781756935491081901"), e_float("0.322955949221835435787505684702627279041509988997089690059352008270144131503491385594891980989262593431689077048428659364183245017293932010120058417163050696650891282141189798105082589645232333140242273306862591729041016984193994889752494097263614920954437787130766546232744253198050657826752298619276035297125975026918785782515566599398352966373072498795492291377546540411573973335212538679026985341")),
           ef_complex(e_float("84.886694188129635422866708592709395446410361151319046679107210565772486071256573014118217382505388741090440725482025481256094978033346756968140630458587798803057139051642378647648325574089471901544474179215930788187477419918372205606287941338086159925615106816264834313806005036957929160404146015254839863091971981355885449271707150643207503151209247638758862346194786750598935316410892065294007928064"), e_float("0.291029333395985159723551785886769677674337966998731304034012705476806841085948088833752600508895032383130774345801351493502450644874459118224269210069011126740207642742462037392051454856944812711613099252764564582380834900395760437760484015426485852081060798809061964596156346579689977056568889586486446792134845816815710278773089152892377322818780533821173610328948730669373417190906987287046077532")),
           ef_complex(e_float("78.211523606168556494524722834538314503143385383525872299006460440355524983785173472458406346998141606200185189491575241661277183474860398014655187699637066324129780300812000809231829303564246210425498080553677414649030391756573338793410299174673973284444305238352631248664690801796510846594574548782701165172797927050074411542691090968262750818634804080703193488175516310514955428161353550638007532795"), e_float("0.26317821520649460020480290825572996830095561641962171335185174049403944253321471861323491464714596623521620974156391239392564985490776885512172130066329526617946791306777958340872336829446912099164297895537711871409191184456402194146683091224814990618129809771325599308119826940138931649159319543875308943365861881081752680195309424214177238517736503406831720353478112390057787032566113477176909717")),
           ef_complex(e_float("72.27574472736837981612629642830022398094452138623690574896540517889301962221149726894212240412240470703927279595362278598917326796276270095020906702912235413614318453178430390370444708961767644062579073492731084370382726336524432034783121030834732096280915605145587671477364913643608180209681525758112215113083286067712464943771146057339226767945464966417013370743959665252077396958000432522777605991"), e_float("0.238782655489563075485853037801239428181759176307132027915321761347329288346090909358347387516297972301888018691967939209022374687556115121877515677475543600183133717401131990220729130452696968206394047909240819558662406412367444301554977875112357665771844943598973101950177447362713244357560930294809320745723335195390470041433831467587091556641087869080216929004493315585282136692326884868297873118")),
           ef_complex(e_float("66.978598995306944225515865993469439830752401398438393352270032255500023681577408633273276259999960533044118141366593913556115558446432003735479206245547152608081126266950976923286026335958101175380977070373942573725569608524637840582586609981711540578021014291087087138771570645119314703013247000122192836740949490817325825874544986066564151899518018183874323985629707185652321373345959863471714388124"), e_float("0.217330594481951193976641824636984713278502759657695282937120045051082312020767397189511775375135838405091657817449796857599095900266062853497511488816388902832336100446567077802122239908310001633456401074787594392877050237658513553509482759441271863211394498387452444915851435052903573057464852353174846238719117250350770221505284153323370104461651525168135654203660305368998319983939582509686049313")),
           ef_complex(e_float("62.235328919179444082773364062449770058333047833689332104862868917604719535869659809327886667453634962052611455666281311993352278197077663638825397509925166212162273640715520521954939766486855576824064708762857558205465666302139017271615569505365825665385974460068442073637890879027125498837052733891876954091443901463790972341989524243177456566153205464439888305847385438095631167315193748601043913531"), e_float("0.198396915749221731680880331636417086509550101689061730356848451953815060876229388794254188850764233099914479956886810074515503365634651179014794793272530584823420745554277103385116562188663862413122614254753573621174352558477838184283428763160961343266613299548452061537908153542877847025737735103330228844574050970041468743191491954232179181929632537503058812703396021918840120609067731663054717544")),
           ef_complex(e_float("57.974308986797502381221231213965359351784120412269033498823441571055533345125687647324963132769169533765925426868171390475134387559342134167698588172184534816382962894577793295206519948285579633112788137776396090063951915155657757651257774467504240186829756533017043459343561099363974656083851577416198971404124301616528401300288966446968921818610928835516686508223970536883938025210616526321866872028"), e_float("0.181626962480431947823356154736609126368178988200973827309233618396782791319836848212576587461452890529058275841090520085066173915394297746999311268315825322281957160956515791769558422148255746890962295371388179043464055386597076013598198084528954252821021509146588562040751078002359487398679753550513346293975442054138657814287537266492064476884468024640285311750653820242719085318152451173788273314")),
           ef_complex(e_float("54.134745369346705804802696134042920791429996022382155581300406024680975009315782629698021905223040827638787274970693803286113133206161231069763945470070435239457948081261369018045203452121617976120612617389243904645657573054372882466244620205560107279995073604891234829893949869691979349732487398383486866029791004075225082070244921047569277639231740223975570201365246025321891704529330539215561534248"), e_float("0.166723481864029781379515757245561120648231626554514588824102240431556599448744349778956148398129419746221365277999172968730196634995410087871886548640135401322401422517560619140842999829847021427002121657306004614804541319025118246987024117264500335853351358724950480511447012355029000105230182542416111439439003244335092750945382650421092512300413667495135657980495996920574085298292161297666464242")),
           ef_complex(e_float("50.664821602404647469177868586332841103691061342091777466998165166391795370069576798171233419660025044439234232071807990709087431665431312057496765831898300103304005639301211895343025197852754487317529964207214448995087779151835839307341445426964564086270073982420377489275641451661057892459058143169022352054605280608394294408109971399823726313663627258623184260181360356096282482000393976594809917753"), e_float("0.153436225657160328444183893716660835019100607195582276428865473078165120376643866664805537598486668000014836466039767862244480361449321763293821196099928255181870323554805164870153057968276839358848622175884308571179903261679349850748581583102750293018538516677456187029459182570208898362858728271960985043367750709150110964382444057048479719937972717990592803910574057069089427194999616833955781946")),
           ef_complex(e_float("47.520195985823636961219988419952565295858193847303503708833047800507881224574125928168407493232533367258826049141678043877929946786897004413401594807384656973228324527382881837076988391525433006063726550051129978144441340909461320285632970461481184142321822482710888158463976325321600934037269400366178252979085595629873846445297291721108913336271339989375413377769361426592811346674717873313711806525"), e_float("0.141553621361831220725155763516391244007239216825659286397079164126060624606962401883189397445653657309787733417577973766976720024760373316184805756293948033891765806983707349563409741934869332814724277269037609465177110278891005652780037950413061143586035898921711674994438440893497096515240284577153534757551322709689022075500387787845845985350545732367645032408306666515688340550805964962091740449")),
           ef_complex(e_float("44.662777914867803680787508592842141925117374460351389372072775483184231959215225441344136036577911029002860364047977676130264406587974226214772045097955627824882882021130875773394199206055423228496258458747284073591348899619565801431340650409537483644374532475146629381700768307970157740181672820146728439605203071860216562091022135694909439261196386541256965230007894644785040765162142501245184817387"), e_float("0.130896066904472739281192701298598300224537938419682176218229054880952296531527690208760988569236518990447456360022707285379607747501296478380921129790322128122368087428049404586989659713863375330452144949393953074837020252075761752768345923884885878352503773485644175909131612727827646550940263742612873681434371436328116319141006019291109069754575743813994368749599947734559175534332200563150290276")),
           ef_complex(e_float("42.059726601174878730699110889871776960259630831677957868244876984609482101680258160436450943571566633363617438870923246344349214360749518849630578378082330236322510182673276199271759171345799990155582007637807006903936165015553166406044865795089114976624503751871866346655396901202546858380226882667772881356379572544131282707146474913154511449304788328119083608766511526427145622826095272592734090062"), e_float("0.121310505348894944266479457926634311468800826864044575541690480552307394260992768307792149628535795690774366133793770194696377449637576343835941770929108804127921417099997852726356531137322655560820819106899487920567163549754643162673199563235098722141195425798240641158731448431667096343061709571195619860833258037285877372472909981950793076189388783659566805933170308026160578062982113344477584855")),
           ef_complex(e_float("39.682628012502033194079504250937325841171389133746642504005982582277533230974132377714941156337614512170643248697199428172599873190193384895934310812436329101800836027831235403409196672276621076351468240252544820349533093496953900081368261340315994758495518393381638564796631768034683713644960506751530515249896393023949486249732207084989034767423203802539448653297065483778246208433770195019567165433"), e_float("0.112666014228472107239900877186183520110019022711525706320823161999788459455665627217076901579969710215902195955600905552128338373513121474209733116925820758938588436298692507067842607114870398995581711689414576978279907096167383703562831565921784073908727856792928708975185742745837561023286023565612261547218204323830263036508434937002839126173099788352879745459111530689047835023769210037828473567")),
           ef_complex(e_float("37.506815335976529633298056993993078170698120138484750211479259195466060717298622436340716767419091333719234075701581328046967884771323485654011350801735334653646895896974585512249622547267307377044816835385679915211175631765330467821766677422848117336524903374285475022292583369961666814569466270254990700169227727508677540542740456546259865508275910564491609218575945288413151093358157586622018642192"), e_float("0.104850203239469685077425586373205919137101598365200166751096900720753331482564591910956920062013324850173600602013919211221323989706265554296688257333805354304852669998887289932106903408046696874112642197941077104843756353816294748158740442172693438399571369095668091069787695747848559056672701803544617526431254347900397810787895168829729662158980057117364474690619558667135564213074625327934388268")),
           ef_complex(e_float("35.510805569860522976319480129179912476738759241878587740944416576471840590378647800358493521218215319760398629140492644568297920579375790295141809972191357815479943627639280635142544930927721335074842799823666410386597572366061600823646030522196546935555837336167761948777325785617202125713025467721043103688064638841794510446802196732849171102632212846729223422584606449828715458933291387975673939809"), e_float("0.097766259137327018506567357699056340027116433299082285757648385765610631379837013709755067184795892395547096733778315312902144656166237203980206604338925347651271239097638610936563604164327758070464477608535878622428993299227762870388102801001276038538294290006905948912062169444396313470117261402198699286999720514425818332210744840184008921048178919253975716850763395474243261599921628257686649646")),
           ef_complex(e_float("33.675830504240855912186840849774387315806591719175944838927764789973798867434721421341384275153820058569235511213865594463617828993751048685379623060466391207538726455990396959127859528760743025750071884950360559322093021052777063182943205839483787878639745047219722629695638332879132758589543037242805812896618817520039487547111909612348688938283726222288231760061345807272216458591574667710201042035"), e_float("0.091330511258349723879506653660382897066365423628495821427163326656992127307967863978760634776714693226138097292626397235607930741595593967854207901984223625631396866942705861233760408047084777779318656922038132567116345465549998998536166139869124765897590605997262673513185480239778102137988899140159645979881597482442469153192733076581258469084780269525825121840053917389232587633277761621567648691")),
           ef_complex(e_float("31.985444755509345592179638655055918333422820977469022956171327131025281569872130595912015065677790049318012119820161244727958305897176328717939120393080601206920380481446876704210587979782788005097151817318460828712504222221432092158397459183731275266338668058485627093735105259023787011628691984812354852229304517837642987471534417921551566011842247557463404829562399487211749782420558011712247693447"), e_float("0.085470417750284695109050490871571410997325193400564345292094045038663502153340162515959102179613847064429059761942175560683662367766227566278842180284495265600988068526356397319854846326420239729027929779178655245027956751469956066100047767775201345777739033476134243056324747412816422908100089886571259154951919773414117586849830760355197544634204249503954370245514535226785557942234186788025341848")),
           ef_complex(e_float("30.425196967274358196245828868555680548638280594566380148758658296192066588709850437341769935638831784677858200107346207844254562547064409341344344455497311251553849332320429527566892327468625267131230987465499546827545296140040572592344701180928688738399615388568797762703391008449848260959904743414274302569460444597234164427339978966610502144080055389368365863114672375016256588199206553330472928258"), e_float("0.080122893259363223190336558076132286987068694786484524112466161497717086064130703110231661196951043372954468118843945813244921631504284759461048694129113351056189538106299896361799709041373597374178017046436306842709027033797087319022564783837020669354597734570858263401203139028817317886307455336739588485914182317558035540424553144754997492443671280951733653788656062440052231661405092841522111963")),
           ef_complex(e_float("28.982353002542496427473532399406028567570671481587490002884271873277987060952610895518095398914627681681081597824542848254042785574313578695354483624472075419147215962726029315140153289383710843743268996990944473993151366152191309040642650990050388016979030107218909037252030309686877652944030646173931215629130735033909772063856130374221160308547734211604047136054754911015275092032797858911103029817"), e_float("0.075232914919252009045530371307683067679598202290028864098181665693163604342606464835911515254585912641574292181911181278571168999054370442794244544580398449595913587631476315370041866529326494955491713503398565141300448314343420518191309531536745402994249276210047189967590513245449609635917984527019703821668886892014164446338792326790841645713150486620331576777802384110541179835063148420479363574")),
           ef_complex(e_float("27.64566209569612856091892611528884732076829908228768586302028544019034025041634286827349492051105676064660972129277229944375101623555868316048757262369833216506166328417846573904473165660992692543252129257037770206698179371024696285090021810628431592422925705505092473551739041826845604229447293565686887891154779174247233491504346723743089321155965093438127574657563722212847919141219712330102393902"), e_float("0.070752356089652632933296671682713732398701963906917775269130520977119456610520927257863740556160489296811566831203247258742013716620830441754667953711007983349779371669593265146237176397361338322994870782697664031903006602932237988421470815429342227037577144287523301125157561261301168270354955490581474232125319236337741153715510415391347575856250214170836721506331888066424333694894814151803969517")),
           ef_complex(e_float("26.405158634891368425666112444242581892923325610360001989172193526275719839421424572009508232675726181717082085775459350958613611125783924093620122785186065457137188213586495653721710012152705176423182798030759915369787523765604225936181520763107678231263153168142853355815194100768630857933078897937880749033629244422175868695820058264582367864977476650941887850301928711248505144494786962835543557477"), e_float("0.066639007204851627404507434692515485918082673150130044881368743250177774541496923835762808891178251277094611151446067937717258331973923931433046436697427433049966799762432108027575572919372816881805350609653692171802679014039867930013745705118058925771692133245838472480771802782098185296818901437887354820541874422368337239377861847109180802453381814438256425226046655343805259919470427399032895122")),
           ef_complex(e_float("25.25199360294361779405669966215936518913281266005247120862966842334130897239227093842512762520806940758825723111733344683222857069789510451174823258405295464732094261954719250247704174001237102093371491506044745012102757168712789553997033636708163292046787418697720785712865794058357748052158432355088448163411162660166143420037151477096694103755792477726993426811082356788090018153946517576053467982"), e_float("0.062855750925082086146394232753159651090338926074784120443038095235184066397777671748450719976851277923873100842449544708749335346080836591239934749953775418257839774627340695472668545880220333629671521754109302069823293563602493245220356400754871886435725689675459748822790501598270940878873243414339423468864958457829190744091311944593775505293882534937538169007294576999614707762426744123349007675")),
           ef_complex(e_float("24.178290791955719011032467599162971033330817045142458548544156810356774659588066218503707422690475141722722652472439337862262833029412118395758129428501797448168014654881370847627187311144959144855658022355166266118377348750117094699929286330308099887095453144627479128959305424733912141930484898139750721836126143151163097552886230220960705428848888785779218936806336113574843926052146576682230774997"), e_float("0.059369864999890946298018881897427478793833694379766311214639030906961365914845623781216568516154517520408968404077682953058620412203268390530173555637214963634378446235978285177092503640580821213730961660417162555037717516885566227279413158614885477365410433198637143762303595628671476742625569448253303416862275768867784822118542497551301555056253305785717783617156382381543945362102479257197275798")),
           ef_complex(e_float("23.177023781264840564719454756959998257110367118861636647157399980573471488326790092743868891599098255412655942342427828952494894088748886217515354684970983727332773012838219823104286309989762369290571342925793868700043577637318353415233711642727011837867785692204886572931239051036968184449306073454205439205555074679124827579946472793986558620632861065653377523546024500234076031631247805791049461988"), e_float("0.056152431207348657673473978403504022205556498397042665196308602258316068584153839435928299628506704542118489883287183324561482898020549552516205678666153339526856379434209436110211656131747835233902212771749406638466033877471413675306569868884504081635738129114963961319121502233757134217841491357313043562232340473982507605881422343250307254008053559189092254981965041136945812406898334033493186216")),
           ef_complex(e_float("22.241910374211764400023073562991294246391059206423079907593430575533609716956311028582505258869006343751828808226388755663344223800536240588130345508142466728016927575863190716934638100270937986560495421057782625779637065446767039517061822852241053186510384548670736141355043631479662267384173922394136201640137700287736612256647090515755048234657667606441133150836495858625590623665129824848691015177"), e_float("0.053177832698233474960064686484578597614523726176566414356843554416680798788876048615735366499659812703925063694735579236219599706471214983145103518864151016907982013914902503276009097529879962670973426674903998524331378127337891276685870206692529225164966800818314042957990586642770522269638897814608232619241412105833408900772668928264489037576864454597517679872015796748187424057249376674633725777")),
           ef_complex(e_float("21.367321761392694342640639414702521438837331391152179396076077520331927788133623258106235713215868148640566273203205173922136125440845864876783247297388261174903500844623626856862602014251150528176015356798647866561171863991905166172889181736305174771432757468587817461519408992164486482273423993520887050493521683072387455133750898912387567257540127646664994156574366668659847423508755716085816354311"), e_float("0.050423325260461694636467332593879793539231367839767446239484559846907707062058233907309454105611736228402946195526536527464605412971622837524217388443554291691328350771357665699703279137953941777484036852437751566955000400257561678202974071785909904069295758700564609384850047754494122279428375841693817270985626831344932481701542516691357136470331223093500603849277305670836578937147769157636946794")),
           ef_complex(e_float("20.548204143511503756676120291616055347630285496732001126102265857951045899576897624218179779785765229287759262824314366480582198618639644641725525098386874955654501786850760088975868165599044653673831293220164419076033706900443687975848081196746904158791620270869063992332957836203847991489250007094154013633271918293761277253523663359121106991836217411957864809414336577968754852701671447616578824512"), e_float("0.047868670588977671394679136616319753772684023064263056670964323608765714132556952936059514951190980293757181630084096917756730360763000601924372567566466842043233709859023314773162569508442480561126242841135586754065850347905591942915260766708206760734753829381137663779782858045935816149531900048681255398425090819874353304058808368886642548881574626069513471427975581248286198401854920397202028689")),
           ef_complex(e_float("19.78001092696870366654443574365205112983448188284388201314378530162332308356819128063370747621349427546617770344042562555774354966361404965304426766070304122738329040001850464970383023232551675218090312043405016810918333042162728157755216124255658661715001002047554336456857459972513498338407963990860246578462033939285294627489046499889094616523891728996290024226307804440540390732528795737229724008"), e_float("0.045495821726961548649369811306337202932785285390213544756132971932571195732332495995363474097033281265875346297588081168562601749404251628529344997858787934628058443125185308524791736770054103575037275523016332711633303737765019394842183562223007235968388685054036478264141613177336355574595762245163055939461736325497668848662263257478730020100887479991641689560588413007906084287802957422418091019")),
           ef_complex(e_float("19.058643916665573456028272027402379898016321920334406948411301326243836771810659941811771375143385641523427528550332370063389592168541718986133693922060633438875210822822778969290934383592286959338062448524849846471444064043266329581636570167917440462708993453433569719022889860701677022813419868219266517052737372000291961405738406798442424979613400182238848178075755030702385114422300279645010371197"), e_float("0.043288652534795978284511404010926486391490129638047858465606139997415179261671757462348339060922012248755835004734700148702471461347505011442306103053689586351295424341803765991832111207068174608089475199826939759547043209618703124914772493825582897943394504747247948678391146972026370782010296181077449572946497402100865389639467092003011837066395245298488444689947018865363448153719245110002818302")),
           ef_complex(e_float("18.380402186438824386302430048029093756176896159769818668623507835724790826734244314928848723720082222590002168786193952950453931182431000812007440313766340360003497851253526675014774621842284762716118890812297747851455290729444236127918628988713294014476144134441092623736467476215370826957124623543083159395318558620669282510027844337935549021379719259647158843532656212183386188360046819780494672463"), e_float("0.041232724421682352789817232885055874754039733989741932191235366240516265818716761967020785094177967624569022371910183632556756515335655090653622333182287247550786366654394104553640055712861942091774338630433023877800803956941135888483558978007848200602175827639219227050361041325595452401286928712908155970763388789938733666789612766430445483673338678874543295054935189722581246648701287122341810878")),
           ef_complex(e_float("17.741937518619836909050838464173659537597291005355201056590358688341200845322231420657543074151857207389626617256081804871341222663423956558650975819245237153658594907796969078739925516608396619060607538268668671141378295681686771725922642278284862923772149171617149574414344980313990235710132151490017436924052043832242051976242020973583827493050099721412919469268496541456007974616891039342021104862"), e_float("0.039315084702549047783621728286385679805609381516640145483232365856137400481963978552901915796228582308377148450616718623384500308781387369865010099752376167689420640139336650167534770471889758816947946367600167945310096091378145129056858926429418638883688359138976506137709114263063262816753340339030889431478948809386790614125057772633863833289510572139116276803378768186261214090618430297654219932")),
           ef_complex(e_float("17.140215478846531713398059749859833424362232432849744792496475278479367488891920225217602806145166628354978725333097155100812241929113866518246292849223404872867361508044089462743884551389260686075443891469724919277623135025296040779154718222888380518799019683555622856243226327376367906307039770611986957913309546948529328142166087572573931310300379684520645925067907707612980991131611202729859734482"), e_float("0.037524091868572954969725834902543656683218006691345867753630709195731327240491167442170031742938071855535327863522610148722099490328990397662394795280966325373720712766274871379647237619257604771673552313374798056996322064059883869368841610481260195812531580087113295952410616555214122358231710646665956283719269550083477944640126631464313060273861287814250952804155995720354759355486908477454432902")),
           ef_complex(e_float("16.572481337181518967928430400221304055929741880857757290423014446556367319449748337160399421191376708157856161677404659586344936197820026001226474007463979065110358511934079130299253686827455448046576079512445834264455454148712894765912809007675488766106879842522529414777249557284976103064230871201536669517579265665159645810378268031090508403559616381905104005369132680289713813339055433151069052556"), e_float("0.035849263821869287866196297886587132485757644787383113011117283950172480280921296435958263231362121927845270581116376084932489780848605487593187931091250013949688312089129513098082116174545861386991819309710857078682060365700879403755952509982009320185551088217899734794960738118690967446300839934090008903215935802842820789143522764822415210861253113041628915215226244194935639917035425953601475242")),
           ef_complex(e_float("16.03623016721963034129208687025075213162602636570605932474384742529929105003148464023541201261635665569000338308226917958631963499044015965114799362960849724443366448918598703260356921098883168109234483892790614521799018831856552788836065187766281839085670956405283355318133310341318298114299696583597399784085671064840090213612496581777808998198725975257929889781673183903888356922061443250532334877"), e_float("0.034281145754492261370796097703417481407941334476754300299575794346848164439247915042388380150634826557233179464547499696978701544906127342485049102236475986983772377595512752733716516748134890277191557868624475619066338667760204441092264256193452409117911277926290625988858461342699977908396045701968097165109106371525576359937658853851831901476098654953777273606432787428808643467002449481797417636")),
           ef_complex(e_float("15.529180555564792538982969395479323642936398294675866399393462575388577651098671879123566416215199621872984249641626731805939631239167035999475903207934739028374188161066540739610667090906448335936497107286016326905225822050346891535307157714851355159080530092241199005392353061852122179681045914187934820936430689730721636622563423833953882397679470781571471313146913297880548452986201969724921668975"), e_float("0.032811194873474386248893557897919538021380687030762707469892861525390036424347194500205145069293512149164873071291937293437562230963032115336276162749567379316881327494034633758460489690788091838307364056299106353713894954826047850145642724002226420734321254313162370070250107033498289814730551390528847934010009763838928221210964523411981622893204547669814942326984192564590286629096965168272173068")),
           ef_complex(e_float("15.049251438350129602687222720183295776134701663427888405577575299678908818399351692507748488627530669023052370384490617991454080707382990247189118079974307542325741810180588644687750273181230396437633984758197425673718951917878403762147408136495758870511496882116824025229134499711326700715746284250007894874686739431770036774100833462564788267825677938755267469475938528559344296356395363119417172511"), e_float("0.031431679607000967686361954413667420003409156071084138341908015627041675164255490955834716731151257705655125198096296127278032530312642310102065941650770605539277059985574106823859267195355736362533382382363243009786191264434885096998977515080955729352277104583043961644250600657044067077072033403052562368817078075787586537136767575548843587462285684985177838577940772209300366570301705670760982303")),
           ef_complex(e_float("14.594541652230605973185581902752851930307304225387200176450620530642876688941835166435253265625764866823716409974227802908528699192714575147686243521615116899003405990883555481374792419084754477364293663904735171240479863972361428990986918892956933943471527370422835469103306267758354906887458552884190865721005088019474660557212516096109880598012379723855248955062289075596206478762203175379793286263"), e_float("0.030135591287908192766214191022662447785358898119347210027581633412116962790181516304807737463761156230634676639802465660749918819243955547882106489571458789884700687677780106653646645236754135478730802187430099719731378603549113491141704174791296198362971505797380008461502238627626586923253600511876487023491026655173644695936844173292323418662895030212055132475412774354804190376400548374887587239")),
           ef_complex(e_float("14.163311846826300722560655423327858149068558281259081853254579359735625097101960500488168119385897566090741461973906415665366039217080934094980731711701762467654968493869131157288859275935156753067565099603573983282230343675935317212260177734754577065832609100409671258521873699485130810681799296982155780026325871048022828247949193745932615871153886042838307745543204580880796914843114954016569002127"), e_float("0.028916566612389834738522058121555512168549355016358730220305999236175910984239755954688968929893795844960689907201661422731960836854223832986480135270758118439541753940838299873097112563974471928085814915013357994740776813882473373083789424851309097734983747893728196824408556981461214741702414587704064466696614510781555242802795326478947906722675291559999375289636835689314976774317892184356636802")),
           ef_complex(e_float("13.7539684558406467842505425885789582165165663244762900677580693232527481316478607458341005523483215214368285795847838239491662445712563776138279851745433256010248117263656898331647380461186820630275353598533166154857953074331622106020787859363275124052455031219806470363524782319888172555586787550721722857064874994094673268247610330711978117845109201918853841900964451174855543071890865635969900078904"), e_float("0.0277688194245429243548640900023050706054724870314426284244651661937779021591360345154097588736018036565372246348571677524309722742440280051811197469389976953647548227765027943566656235547356449931175286829640210767174372323055814034948372416853612249114130372052194586100115911465578659539810794536103020681081613107570761422110616351974520857348600264608664184843129343382204010799901098469048060363")),
           ef_complex(e_float("13.3650494665811277485975069479396655869408934878132886886711997986989289877534124955249427428923227353534010958323498797587591582276479077675316574293055895807601845797045135156415601067904583701624691267979433130726621154918235212487172113859298882068063655538994800424581108394910938028161101358610465907530130690251332983920106551188357368243253384133665704641929655811319651215818861350324966878924"), e_float("0.0266870805896699123872675127115035240139464944727982034434580389947405027786812678983213703066546176984123253030735066473534327463111914606402026862232170118096341970380326473453023798147516719850422579864814757007046086679561883409551891787561331001244328162296608224680609324754433274129928131204089326987806356051792101783790568461097053756475565426993855045977523689609250759319058787256730109433")),
           ef_complex(e_float("12.9952117636508672059516094233231983592163404076852619731457873047590958941342812150115402763689997908823822139284039804068818113958970420477925692935248862919807479806114370649541456787157609582318288651468960313342647623969702367261636530605426165566832728444723191913551846486745084334785937373096579593551802831661747252624655309388106614781348834755946620081452095250320934902510524302885884134979"), e_float("0.0256665448980113312834737817318982431772519478572025189414175381181278490202261854605377139885694925703580451740253878239612789861167980346128879395307738134516753590295452188926278936122302488643788266100718128281225253554973202599521810395735932541629443795557980410275916823484629011007154626191946667637734939219560777242854573395281128599313563614988124533744520405331322163689987839045863495812")),
           ef_complex(e_float("12.6432198532132840292049170691611040794883071590033462939728437763531353955119321783073343679522187582187156240069895587986751697645392413912849995002075135294241550052216458528117916052445808493394875241475451539860596690446347622610929342461524828798339166322573684540383369196262891558786533100858670491787144183189415717572699314331273261268425526967650174570267380361402439836847077932955714734804"), e_float("0.0247028240914755492017664018137611761612385917306499985833065042583368428196107397113304508588062857876314088277198008619205727898955490391720665987080746242038381773051628739978129610842965031137071864886783284079816596995482810515718792847466813414934233440321529859953916732511865520383953134294629638091550705488509369301061631031320506884769539925027365256397514484452355763203450773482386878626")),
           ef_complex(e_float("12.3079358003298826560752825388761733392535654233458629528800256093855480322415646839625791417490533295993203489371281075375906759626824220836156392651626862655065460587926932352718161234040660279307193873463306220532070471736066128438513360988753544323207280963329204165492737761356543030397318361401598497418503860510202816159007250612391264655088785668161277732005662244724444399804164902350360568012"), e_float("0.0237919052336095423149291321186821799880732998381382999752863603836795366861604889610062029223021635658259926845513976164983011329351600635781553113471659625292777756615371199583499034380328806183032970499025018245238915433337304434774493178837677229921882974219301986114556680257311668428510227799246627069780784204906686672541316546976257855428296906317114206516217387965712987713584336270638556589")),
           ef_complex(e_float("11.9883102341548986573336317602645329863533035907553092978365372557764768276147129628670917469292981010532061187607901154321427284881016590833344106504954344089528046191373867862811044321285614378415082831188309447613967202568477211276964598355859603199863381158171078070544139591903850986434945956410652929549398286565434371418563228853115180173766103972001726042586439720286501502769878400332554558935"), e_float("0.0229301137513406179970240891018914581106020362191429412733293368010197112392366346771657930600650986833298300133503396536697042903005916615360728813562835515069250186138302691193350532379903262122397165533033981634829463958375171977638336574881190811713174558236169581241311323473330201476858087767279192504673805828219687659488930129294143146862048074057018691476381322402363290172043321386485156166")),
           ef_complex(e_float("11.6833742948390542398901473986657789498165285733747921253023425775971130770669442441468394653699183762945262258236059958123105926605014134742253598184826530862153970859249018373382280746318760363947969622400673654057491727982167871621575422270368973041464857136758505962029389116054423176139363561023821222169889586232309579668846441931993553224115859508600791367859174940326222423103577544616231460766"), e_float("0.0221140805690676584863731523792964741485395199061343532561353136172563902387170249598445293464590758545830995003038403655163562429869226975748992094329431495097086382915687646006691543877407245830618946228431430620305936861405227672231986782783056493039322887468578430177704372985093095603297882219305323332766028572122390155190955498775553630225850270606625248159470739575833289430470826682896574401")),
           ef_complex(e_float("11.3922324123467975100613287907296952925731129904471263442915697266899888014363558164357931348769518264246347903972259391880437082047722722682383565911009603040705895510012607073215293495910792557901380318421691569941549931707268676851073776985275371593848408773242087574626828624106094206430175632005318739877939686919266944244437739920992058246420458821982037752732221059365756346190708499172587920963"), e_float("0.0213407128340998866699425794728494266489078506059422617607527241476029641064481946602232653728395584499172445257861298024802098595141751514120489554777695906895600126167471722283472933581960793157604141271318202884086905594717367058626677501066843782337461880972541749667376161568134896451095036908481394539405982995627085831678642842941818620370593797445138441907768250682177893940743994398006955183")),
           ef_complex(e_float("11.1140558214432364128523830198366316214807031980320209983121594509448102196736742823039130361069874067714608839153463260106786278303505306022255306925385648569573758897315387439553273733571383243592007413435821788237493780560246378602720683464883860844764610277138483521071939390237571616567115453326156731503183771125882969319951124790726011881801071703959021314418019262741640703369960289150045893667"), e_float("0.0206071677993936983242843496954267287627808639728357193969964345643747016148989133103016206502654478843198131159388482478804478258700460039769690079643979047211612612093377021046076568234438699264091165327374427924499388892974556426853811826723401733650413911970527599088402255870009303964051327259668171468875321525209154777691140787851622320343309248994797190491535891605733883124855042813571953459")),
           ef_complex(e_float("10.848076729206603464329173180532857661782898739423893527410227248243253576977186448326952944877227194059441101941721712379309130541610681783414619265160972679666124745226729833167113692765260726358216743171092289365817707536009893415980381429389749708564612167400082595408013085719221780673409699208783497406304736108492187046043128235232578672941500719661800601938086977855443484182898925704083098936"), e_float("0.0199108294868208914256882238217118189256607318177646259259624786734617193719985939488234292970675761670867429211165269513869531451187390365359916149948419887549479180858783785020306255345704233480830442150238161122610775209735100157293560371926303652805121266364180963448198003205484671535773778778672272339460815949240335726592534295995856063791926778975241128262670448712489051036164947380659422536")),
           ef_complex(e_float("10.5935830618613231900086895579566543013255770650699063162523189545188846947403154766765507905027335840727412973401642829264549928936713244107279945209274203321250389235147633802644631911988887095980726559214294684258833173011779934345233391908634492007209918795152909034664582925251650405872537755939159731182777780239584492144720011633118855693482883036776495443406641523739595949989243155308714630168"), e_float("0.0192492878033118944719519869004980730183580010868469170770144087197695711334125432905615212129203978446615314383154974483375637323115901491890150184454360314495578938437760170491252311267897584772828863565923207516186394420740019121398933086404011096539667107468087283336165682001503187024333686466208207452423737984561180686127632661311628831181047024356535205820104184586933079086396888046969505093")),
           ef_complex(e_float("10.3499137267508246497554262351486511747179266103176459836890321592705675016873264500423222111087337679271681265719510389239736216261334011429151091567545876813368293835666716710382520377978211628894704862693855049991276039288149617001513802977101122385947738579782334436001354344852781543983008650376018016714807862848718636250497907525801725731150205402115699168381998917319864488386715703070238881424"), e_float("0.0186203198244056928077354924739899833699074082680504906398779832606060799754441820162258802441600610054606709840278426903516574464778753689032109151574032125499214818356981654622228089868722719626335691891029829929439612548354667740391984122445821899294910640112249615709464855780330366619174738717756561860656065789165308331215973522014343212412981897886746224214650952556558713438270903314718297818")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02106_z_rootn(const bool b_write_output)
    {
      return TestCase_case_02106_z_rootn().execute(b_write_output);
    }
  }
}
