/*-------------------------------------------------------------------------------------*/
/*  NOMAD - Nonsmooth Optimization by Mesh Adaptive Direct search - version 3.4        */
/*                                                                                     */
/*  Copyright (C) 2001-2010  Mark Abramson        - the Boeing Company, Seattle        */
/*                           Charles Audet        - Ecole Polytechnique, Montreal      */
/*                           Gilles Couture       - Ecole Polytechnique, Montreal      */
/*                           John Dennis          - Rice University, Houston           */
/*                           Sebastien Le Digabel - Ecole Polytechnique, Montreal      */
/*                                                                                     */
/*  funded in part by AFOSR and Exxon Mobil                                            */
/*                                                                                     */
/*  Author: Sebastien Le Digabel                                                       */
/*                                                                                     */
/*  Contact information:                                                               */
/*    Ecole Polytechnique de Montreal - GERAD                                          */
/*    C.P. 6079, Succ. Centre-ville, Montreal (Quebec) H3C 3A7 Canada                  */
/*    e-mail: nomad@gerad.ca                                                           */
/*    phone : 1-514-340-6053 #6928                                                     */
/*    fax   : 1-514-340-5665                                                           */
/*                                                                                     */
/*  You can find information on the NOMAD software at www.gerad.ca/nomad               */
/*-------------------------------------------------------------------------------------*/
 /**
  \file   Uncopyable.hpp
  \brief  Base class for uncopyable classes (headers)
  \author Sebastien Le Digabel
  \date   2010-04-02
*/
#ifndef __UNCOPYABLE__
#define __UNCOPYABLE__

namespace NOMAD {

  /// Uncopyable class.
  /**
     Base class for uncopyable classes
     (see Scott Meyer's Effective C++, 3rd ed., item #6).
  */
  class Uncopyable {

  protected:

    /// Constructor.
    explicit Uncopyable  ( void ) {}

    /// Destructor.
    virtual ~Uncopyable ( void ) {}

  private:
    
    /// Undefined copy constructor.
    Uncopyable ( const Uncopyable & );

    /// Undefined affectation operator.
    Uncopyable & operator = ( const Uncopyable & );
  };
}

#endif
