% SEVERAL TESTS OF THE ARGYRIS TOOLBOX
%
% Given a function f, and an initial triangular grid {t,x,y}
%
% f is first interpolated by the Argyris element defined on this 
% grid (function "interpArgyris"). Next "plotArgyris" evaluates the 
% interpolant and its first and second derivatives on the grid 
% obtained  by performing several (red) uniform refinement steps 
% of the grid. 
%

% First test

t=[1,2,3];
x=[1,-1/2,-1/2];
y=[0,sqrt(2)/2,-sqrt(2)/2];

disp('test 1: interpolant of a polynomial of degree 5')
disp('===============================================')


f=vectorize(inline('x^5-y^4','x','y'));
fx=vectorize(inline('5*x^4','x','y'));
fy=vectorize(inline('-4*y^3','x','y'));
fxx=vectorize(inline('20*x^3','x','y'));
fxy=vectorize(inline('0*y','u','y'));
fyy=vectorize(inline('-12*y^2','x','y'));
disp(' ')
disp(char(f))

[t2,z]=interpArgyris(t,x,y,f,fx,fy,fxx,fxy,fyy);
% 4 uniform refinements steps of the original grid
plotArgyris(t2,x,y,z,4);
pause
disp(' ')
disp('test 2: error for the interpolant of a polynomial of degree 5')
disp('=============================================================')
disp('(should be equal to zero)')

% function to be interpolated and its derivatives up to order 2

f=vectorize(inline('x^5-x^4*y+2*x*y-3*x^2*y^2','x','y'));
fx=vectorize(inline('5*x^4-4*x^3*y+2*y-6*x*y^2','x','y'));
fy=vectorize(inline('-x^4+2*x-6*x^2*y','x','y'));
fxx=vectorize(inline('20*x^3-12*x^2*y-6*y^2','x','y'));
fxy=vectorize(inline('-4*x^3+2-12*x*y','x','y'));
fyy=vectorize(inline('-6*x^2','x','y'));
disp(' ')
disp(char(f))

% Interpolant...
[t2,z]=interpArgyris(t,x,y,f,fx,fy,fxx,fxy,fyy);
% 6 uniform refinements of the original grid
[t0,x0,y0,z0,zx0,zy0,zxx0,zxy0,zyy0]=...
    plotArgyris(t2,x,y,z,6,'N'); % don't plot the figures...


figure(1)
trisurf(t0,x0,y0,z0-f(x0,y0),'facecolor','interp')
title('function error')
figure(2)
trisurf(t0,x0,y0,zx0-fx(x0,y0),'facecolor','interp')
title('x-derivative error')
figure(3)
trisurf(t0,x0,y0,zy0-fy(x0,y0),'facecolor','interp')
title('y-derivative error')
figure(4)
trisurf(t0,x0,y0,zxx0-fxx(x0,y0),'facecolor','interp')
title('xx-derivative error')
figure(5)
trisurf(t0,x0,y0,zxy0-fxy(x0,y0),'facecolor','interp')
title('xy-derivative error')
figure(6)
trisurf(t0,x0,y0,zyy0-fyy(x0,y0),'facecolor','interp')
title('yy-derivative error')
disp('L^infty error estimates (function, x-,y-,xx-,xy-,yy- derivatives)')
disp(max(abs(z0-f(x0,y0))))
disp(max(abs(zx0-fx(x0,y0))))
disp(max(abs(zy0-fy(x0,y0))))
disp(max(abs(zxx0-fxx(x0,y0))))
disp(max(abs(zxy0-fxy(x0,y0))))
disp(max(abs(zyy0-fyy(x0,y0))))

pause
disp(' ')
disp('test 3: a hexagonal domain with a polynomial of degree 5. Errors')
disp('================================================================')

t= [ 7     1    17;...
    8     2    19;...
    9     3    15;...
    10     4    16;...
    11     5    18;...
    12     6    14;...
    2     7    19;...
    3     8    15;...
    4     9    16;...
    15     8    19;...
    5    10    18;...
    6    11    14;...
    1    12    17;...
    14    11    18;...
    15    13    16;...
    14    13    17;...
    16    13    18;...
    9    15    16;...
    12    14    17;...
    17    13    19;...
    13    14    18;...
    10    16    18;...
    13    15    19;...
    7    17    19];
x=[  -1.0,-0.5, 0.5,  1.0,  0.5,  -0.5,  -0.75,   0,...
    0.75,   0.75,  0,  -0.75, 0,  -0.25,   0.25,   0.5,...
    -0.5,   0.250,  -0.250];
y=[ 0,   0.86602540378444,   0.86602540378444, 0,  -0.86602540378444,...
    -0.86602540378444,   0.43301270189222,   0.86602540378444,...
     0.43301270189222,  -0.43301270189222,  -0.86602540378444,...
    -0.43301270189222,   0.,  -0.43301270189222,   0.43301270189222,...
    0,0,-0.43301270189222, 0.43301270189222];
% the function
f=vectorize(inline('x^5-x^2*y^3+x*y^4-y^2*x^2','x','y'));

% function to be interpolated and its derivatives up to order 2
fx=vectorize(inline('5*x.^4-2*x*y.^3+y.^4-2*y.^2*x','x','y'));
fy=vectorize(inline('-3*y.^2*x.^2+4*x*y.^3-2*y*x.^2','x','y'));
fxx=vectorize(inline('20*x.^3-2*y.^3-2*y.^2','x','y'));
fxy=vectorize(inline('-6*y.^2*x+4*y.^3-4*y*x','x','y'));
fyy=vectorize(inline('-6*y*x.^2+12*y.^2*x-2*x.^2','x','y'));

% Interpolant...
[t2,z]=interpArgyris(t,x,y,f,fx,fy,fxx,fxy,fyy);
[t0,x0,y0,z0,zx0,zy0,zxx0,zxy0,zyy0]=...
    plotArgyris(t2,x,y,z,4,'N'); % don't plot the figures...
disp(' ')
disp(char(f))



figure(1)
trisurf(t0,x0,y0,z0-f(x0,y0),'facecolor','interp')
title('function error')
figure(2)
trisurf(t0,x0,y0,zx0-fx(x0,y0),'facecolor','interp')
title('x-derivative error')
figure(3)
trisurf(t0,x0,y0,zy0-fy(x0,y0),'facecolor','interp')
title('y-derivative error')
figure(4)
trisurf(t0,x0,y0,zxx0-fxx(x0,y0),'facecolor','interp')
title('xx-derivative error')
figure(5)
trisurf(t0,x0,y0,zxy0-fxy(x0,y0),'facecolor','interp')
title('xy-derivative error')
figure(6)
trisurf(t0,x0,y0,zyy0-fyy(x0,y0),'facecolor','interp')
title('yy-derivative error')
disp('L^infty error estimates (function, x-,y-,xx-,xy-,yy- derivatives)')
disp(max(abs(z0-f(x0,y0))))
disp(max(abs(zx0-fx(x0,y0))))
disp(max(abs(zy0-fy(x0,y0))))
disp(max(abs(zxx0-fxx(x0,y0))))
disp(max(abs(zxy0-fxy(x0,y0))))
disp(max(abs(zyy0-fyy(x0,y0))))
pause


disp(' ')
disp('test 4: on an arbitrary domain with a non polynomial function')
disp('=============================================================')
disp(' ')
% the grid of the domain
t=[ 6     2    11;...
    9     1    21;...
    7     3    13;...
    12     6    17;...
    8     4    15;...
    21     5    22;...
    1     9    10;...
    10     9    19;...
    2     6    12;...
    14     7    18;...
    11    10    19;...
    3     7    14;...
    6    11    19;...
    15    14    18;...
    4     8    16;...
    13    12    17;...
    7    13    17;...
    8    15    18;...
    16     8    22;...
    20     9    22;...
    5    16    22;...
    8    20    22;...
    9    21    22];

x=[  -0.25000000000000 0.75000000000000  0.75000000000000...
    -0.25000000000000 -0.85000000000000  0.40000000000000...
    0.40000000000000  -0.10000000000000 -0.10000000000000...
    0.02280444786489  0.35222166082161   0.75000000000000 ...
    0.75000000000000 0.35222166082161  0.02280444786489...
    -0.51086956521739 0.40000000000000 0.16571481108041...
    0.16571481108041  -0.10000000000000 -0.51086956521739...
    -0.36195652173913];
y= [  0.50000000000000 0.50000000000000 -0.50000000000000 ...
    -0.50000000000000 0    0.17500000000000 -0.17500000000000...
    -0.17500000000000 0.17500000000000    0.50000000000000...
    0.50000000000000    0.16666666666667 -0.16666666666667...
    -0.50000000000000 -0.50000000000000  -0.28260869565217 ...
    0   -0.17500000000000  0.17500000000000                  0 ...
    0.28260869565217        0];


% function to be interpolated and its derivatives up to order 2
f=vectorize(inline('y*cos(x^2)-x*sin(y^2)','x','y'));
fx=vectorize(inline('-2*y*sin(x.^2)*x-sin(y.^2)','x','y'));
fy=vectorize(inline('cos(x.^2)-2*x*cos(y.^2)*y','x','y'));
fxx=vectorize(inline('-4*y*cos(x.^2)*x.^2-2*y*sin(x.^2)','x','y'));
fxy=vectorize(inline('-2*sin(x.^2)*x-2*cos(y.^2)*y','x','y'));
fyy=vectorize(inline(' 4*x*sin(y.^2)*y.^2-2*x*cos(y.^2)','x','y'));
disp('')
disp(char(f))


% Interpolant...
[t2,z]=interpArgyris(t,x,y,f,fx,fy,fxx,fxy,fyy);
[t0,x0,y0,z0,zx0,zy0,zxx0,zxy0,zyy0]=...
    plotArgyris(t2,x,y,z,5,'N'); % don't plot the figures...

 

figure(1)
trisurf(t0,x0,y0,z0-f(x0,y0),'facecolor','interp')
title('function error')
figure(2)
trisurf(t0,x0,y0,zx0-fx(x0,y0),'facecolor','interp')
title('x-derivative error')
figure(3)
trisurf(t0,x0,y0,zy0-fy(x0,y0),'facecolor','interp')
title('y-derivative error')
figure(4)
trisurf(t0,x0,y0,zxx0-fxx(x0,y0),'facecolor','interp')
title('xx-derivative error')
figure(5)
trisurf(t0,x0,y0,zxy0-fxy(x0,y0),'facecolor','interp')
title('xy-derivative error')
figure(6)
trisurf(t0,x0,y0,zyy0-fyy(x0,y0),'facecolor','interp')
title('yy-derivative error')

disp('L^infty error estimates (function, x-,y-,xx-,xy-,yy- derivatives)')
disp(max(abs(z0-f(x0,y0))))
disp(max(abs(zx0-fx(x0,y0))))
disp(max(abs(zy0-fy(x0,y0))))
disp(max(abs(zxx0-fxx(x0,y0))))
disp(max(abs(zxy0-fxy(x0,y0))))
disp(max(abs(zyy0-fyy(x0,y0))))
pause
disp(' ')
disp('test 5: The same problem on the uniformly refined grid')
disp('======================================================')

disp(' ')
% the refined grid of the  domain
t=[ 6    25    24;...
    25     2    23;...
    24    23    11;...
    25    23    24;...
    9    28    27;...
    28     1    26;...
    27    26    21;...
    28    26    27;...
    7    31    30;...
    31     3    29;...
    30    29    13;...
    31    29    30;...
    12    34    33;...
    34     6    32;...
    33    32    17;...
    34    32    33;...
    8    37    36;...
    37     4    35;...
    36    35    15;...
    37    35    36;...
    21    40    39;...
    40     5    38;...
    39    38    22;...
    40    38    39;...
    1    28    42;...
    28     9    41;...
    42    41    10;...
    28    41    42;...
    10    41    44;...
    41     9    43;...
    44    43    19;...
    41    43    44;...
    2    25    45;...
    25     6    34;...
    45    34    12;...
    25    34    45;...
    14    48    47;...
    48     7    46;...
    47    46    18;...
    48    46    47;...
    11    50    49;...
    50    10    44;...
    49    44    19;...
    50    44    49;...
    3    31    51;...
    31     7    48;...
    51    48    14;...
    31    48    51;...
    6    24    52;...
    24    11    49;...
    52    49    19;...
    24    49    52;...
    15    54    53;...
    54    14    47;...
    53    47    18;...
    54    47    53;...
    4    37    56;...
    37     8    55;...
    56    55    16;...
    37    55    56;...
    13    58    57;...
    58    12    33;...
    57    33    17;...
    58    33    57;...
    7    30    59;...
    30    13    57;...
    59    57    17;...
    30    57    59;...
    8    36    60;...
    36    15    53;...
    60    53    18;...
    36    53    60;...
    16    55    62;...
    55     8    61;...
    62    61    22;...
    55    61    62;...
    20    65    64;...
    65     9    63;...
    64    63    22;...
    65    63    64;...
    5    66    38;...
    66    16    62;...
    38    62    22;...
    66    62    38;...
    8    67    61;...
    67    20    64;...
    61    64    22;...
    67    64    61;...
    9    27    63;...
    27    21    39;...
    63    39    22;...
    27    39    63];

x=[  -0.250000000000000   0.750000000000000   0.750000000000000...
    -0.250000000000000  -0.850000000000000   0.400000000000000...
    0.400000000000000  -0.100000000000000  -0.100000000000000...
    0.022804447864890   0.352221660821610   0.750000000000000...
    0.750000000000000   0.352221660821610   0.022804447864890...
    -0.510869565217390   0.400000000000000   0.165714811080410...
    0.165714811080410  -0.100000000000000  -0.510869565217390...
    -0.361956521739130   0.551110830410805   0.376110830410805...
    0.575000000000000  -0.380434782608695  -0.305434782608695...
    -0.175000000000000   0.750000000000000   0.575000000000000...
    0.575000000000000   0.400000000000000   0.575000000000000...
    0.575000000000000  -0.113597776067555  -0.038597776067555...
    -0.175000000000000  -0.605978260869565  -0.436413043478260...
    -0.680434782608695  -0.038597776067555  -0.113597776067555...
    0.032857405540205   0.094259629472650   0.750000000000000...
    0.282857405540205   0.258968235951010   0.376110830410805...
    0.258968235951010   0.187513054343250   0.551110830410805...
    0.282857405540205   0.094259629472650   0.187513054343250...
    -0.305434782608695  -0.380434782608695   0.575000000000000...
    0.750000000000000   0.400000000000000   0.032857405540205...
    -0.230978260869565  -0.436413043478260  -0.230978260869565...
    -0.230978260869565  -0.100000000000000  -0.680434782608695...
    -0.100000000000000];
y= [  0.500000000000000   0.500000000000000  -0.500000000000000...
    -0.500000000000000                   0    0.175000000000000...
    -0.175000000000000  -0.175000000000000   0.175000000000000...
    0.500000000000000   0.500000000000000   0.166666666666670...
    -0.166666666666670  -0.500000000000000  -0.500000000000000...
    -0.282608695652170                   0  -0.175000000000000...
    0.175000000000000                   0   0.282608695652170...
    0   0.500000000000000   0.337500000000000...
    0.337500000000000   0.391304347826085   0.228804347826085...
    0.337500000000000  -0.333333333333335  -0.170833333333335...
    -0.337500000000000   0.087500000000000   0.083333333333335...
    0.170833333333335  -0.500000000000000  -0.337500000000000...
    -0.337500000000000                   0   0.141304347826085...
    0.141304347826085   0.337500000000000   0.500000000000000...
    0.175000000000000   0.337500000000000   0.333333333333335...
    -0.175000000000000  -0.337500000000000  -0.337500000000000...
    0.337500000000000   0.500000000000000  -0.500000000000000...
    0.175000000000000  -0.337500000000000  -0.500000000000000...
    -0.228804347826085  -0.391304347826085  -0.083333333333335...
    0  -0.087500000000000  -0.175000000000000...
    -0.087500000000000  -0.141304347826085   0.087500000000000...
    0   0.087500000000000  -0.141304347826085...
    -0.087500000000000];

% function to be interpolated and its derivatives up to order 2
% function to be interpolated and its derivatives up to order 2
f=vectorize(inline('y*cos(x^2)-x*sin(y^2)','x','y'));
fx=vectorize(inline('-2*y*sin(x.^2)*x-sin(y.^2)','x','y'));
fy=vectorize(inline('cos(x.^2)-2*x*cos(y.^2)*y','x','y'));
fxx=vectorize(inline('-4*y*cos(x.^2)*x.^2-2*y*sin(x.^2)','x','y'));
fxy=vectorize(inline('-2*sin(x.^2)*x-2*cos(y.^2)*y','x','y'));
fyy=vectorize(inline(' 4*x*sin(y.^2)*y.^2-2*x*cos(y.^2)','x','y'));

disp(char(f))
disp(' ')
% Interpolant...
[t2,z]=interpArgyris(t,x,y,f,fx,fy,fxx,fxy,fyy);
[t0,x0,y0,z0,zx0,zy0,zxx0,zxy0,zyy0]=...
    plotArgyris(t2,x,y,z,4,'N'); % don't plot the figures...

 

figure(1)
trisurf(t0,x0,y0,z0-f(x0,y0),'facecolor','interp')
title('function error')
figure(2)
trisurf(t0,x0,y0,zx0-fx(x0,y0),'facecolor','interp')
title('x-derivative error')
figure(3)
trisurf(t0,x0,y0,zy0-fy(x0,y0),'facecolor','interp')
title('y-derivative error')
figure(4)
trisurf(t0,x0,y0,zxx0-fxx(x0,y0),'facecolor','interp')
title('xx-derivative error')
figure(5)
trisurf(t0,x0,y0,zxy0-fxy(x0,y0),'facecolor','interp')
title('xy-derivative error')
figure(6)
trisurf(t0,x0,y0,zyy0-fyy(x0,y0),'facecolor','interp')
title('yy-derivative error')

disp('L^infty error estimates (function, x-,y-,xx-,xy-,yy- derivatives)')
disp(max(abs(z0-f(x0,y0))))
disp(max(abs(zx0-fx(x0,y0))))
disp(max(abs(zy0-fy(x0,y0))))
disp(max(abs(zxx0-fxx(x0,y0))))
disp(max(abs(zxy0-fxy(x0,y0))))
disp(max(abs(zyy0-fyy(x0,y0))))

    