#include <iostream>
#include <iomanip>
using namespace std;

#include "MpIeee.hh"
#include "CMpIeee.hh"
#include "ArithmosIO.hh"

const size_t hahn1_N = 236;
const size_t hahn1_P = 7;

/* double hahn1_x0[7] = { 10, -1, 0.05, -0.00001, -0.05, 0.001, -0.000001 }; */

MpIeee hahn1_x0[7] =  { MpIeee( "1" ), -MpIeee( "0.1" ), MpIeee( "0.005" ), -MpIeee( "0.000001" ), -MpIeee( "0.005" ), MpIeee( "0.0001" ), -MpIeee( "0.0000001" )}; 

MpIeee hahn1_x[7] =  {
MpIeee( "1.0776351733E+00" ),
-MpIeee( "1.2269296921E-01" ),
MpIeee( "4.0863750610E-03" ),
-MpIeee( "1.4262662514E-06" ),
-MpIeee( "5.7609940901E-03" ),
MpIeee( "2.4053735503E-04" ),
-MpIeee( "1.2314450199E-07" )
};

MpIeee hahn1_sumsq=  MpIeee( "1.5324382854E+00" );

MpIeee hahn1_sigma[7] =  {
  MpIeee( "1.7070154742E-01" ),
  MpIeee( "1.2000289189E-02" ),
  MpIeee( "2.2508314937E-04" ),
  MpIeee( "2.7578037666E-07" ),
  MpIeee( "2.4712888219E-04" ),
  MpIeee( "1.0449373768E-05" ),
  MpIeee( "1.3027335327E-08" )
};

MpIeee hahn1_F1[236] =  {
        MpIeee( ".591E0" ),
       MpIeee( "1.547E0" ),
       MpIeee( "2.902E0" ),
       MpIeee( "2.894E0" ),
       MpIeee( "4.703E0" ),
       MpIeee( "6.307E0" ),
       MpIeee( "7.03E0" ) ,
       MpIeee( "7.898E0" ),
       MpIeee( "9.470E0" ),
       MpIeee( "9.484E0" ),
      MpIeee( "10.072E0" ),
      MpIeee( "10.163E0" ),
      MpIeee( "11.615E0" ),
      MpIeee( "12.005E0" ),
      MpIeee( "12.478E0" ),
      MpIeee( "12.982E0" ),
      MpIeee( "12.970E0" ),
      MpIeee( "13.926E0" ),
      MpIeee( "14.452E0" ),
      MpIeee( "14.404E0" ),
      MpIeee( "15.190E0" ),
      MpIeee( "15.550E0" ),
      MpIeee( "15.528E0" ),
      MpIeee( "15.499E0" ),
      MpIeee( "16.131E0" ),
      MpIeee( "16.438E0" ),
      MpIeee( "16.387E0" ),
      MpIeee( "16.549E0" ),
      MpIeee( "16.872E0" ),
      MpIeee( "16.830E0" ),
      MpIeee( "16.926E0" ),
      MpIeee( "16.907E0" ),
      MpIeee( "16.966E0" ),
      MpIeee( "17.060E0" ),
      MpIeee( "17.122E0" ),
      MpIeee( "17.311E0" ),
      MpIeee( "17.355E0" ),
      MpIeee( "17.668E0" ),
      MpIeee( "17.767E0" ),
      MpIeee( "17.803E0" ),
      MpIeee( "17.765E0" ),
      MpIeee( "17.768E0" ),
      MpIeee( "17.736E0" ),
      MpIeee( "17.858E0" ),
      MpIeee( "17.877E0" ),
      MpIeee( "17.912E0" ),
      MpIeee( "18.046E0" ),
      MpIeee( "18.085E0" ),
      MpIeee( "18.291E0" ),
      MpIeee( "18.357E0" ),
      MpIeee( "18.426E0" ),
      MpIeee( "18.584E0" ),
      MpIeee( "18.610E0" ),
      MpIeee( "18.870E0" ),
      MpIeee( "18.795E0" ),
      MpIeee( "19.111E0" ),
        MpIeee( ".367E0" ),
        MpIeee( ".796E0" ),
       MpIeee( "0.892E0" ),
       MpIeee( "1.903E0" ),
       MpIeee( "2.150E0" ),
       MpIeee( "3.697E0" ),
       MpIeee( "5.870E0" ),
       MpIeee( "6.421E0" ),
       MpIeee( "7.422E0" ),
       MpIeee( "9.944E0" ),
      MpIeee( "11.023E0" ),
      MpIeee( "11.87E0" ) ,
      MpIeee( "12.786E0" ),
      MpIeee( "14.067E0" ),
      MpIeee( "13.974E0" ),
      MpIeee( "14.462E0" ),
      MpIeee( "14.464E0" ),
      MpIeee( "15.381E0" ),
      MpIeee( "15.483E0" ),
      MpIeee( "15.59E0" ) ,
      MpIeee( "16.075E0" ),
      MpIeee( "16.347E0" ),
      MpIeee( "16.181E0" ),
      MpIeee( "16.915E0" ),
      MpIeee( "17.003E0" ),
      MpIeee( "16.978E0" ),
      MpIeee( "17.756E0" ),
      MpIeee( "17.808E0" ),
      MpIeee( "17.868E0" ),
      MpIeee( "18.481E0" ),
      MpIeee( "18.486E0" ),
      MpIeee( "19.090E0" ),
      MpIeee( "16.062E0" ),
      MpIeee( "16.337E0" ),
      MpIeee( "16.345E0" ),
      MpIeee( "16.388E0" ),
      MpIeee( "17.159E0" ),
      MpIeee( "17.116E0" ),
      MpIeee( "17.164E0" ),
      MpIeee( "17.123E0" ),
      MpIeee( "17.979E0" ),
      MpIeee( "17.974E0" ),
      MpIeee( "18.007E0" ),
      MpIeee( "17.993E0" ),
      MpIeee( "18.523E0" ),
      MpIeee( "18.669E0" ),
      MpIeee( "18.617E0" ),
      MpIeee( "19.371E0" ),
      MpIeee( "19.330E0" ),
       MpIeee( "0.080E0" ),
       MpIeee( "0.248E0" ),
       MpIeee( "1.089E0" ),
       MpIeee( "1.418E0" ),
       MpIeee( "2.278E0" ),
       MpIeee( "3.624E0" ),
       MpIeee( "4.574E0" ),
       MpIeee( "5.556E0" ),
       MpIeee( "7.267E0" ),
       MpIeee( "7.695E0" ),
       MpIeee( "9.136E0" ),
       MpIeee( "9.959E0" ),
       MpIeee( "9.957E0" ),
      MpIeee( "11.600E0" ),
      MpIeee( "13.138E0" ),
      MpIeee( "13.564E0" ),
      MpIeee( "13.871E0" ),
      MpIeee( "13.994E0" ),
      MpIeee( "14.947E0" ),
      MpIeee( "15.473E0" ),
      MpIeee( "15.379E0" ),
      MpIeee( "15.455E0" ),
      MpIeee( "15.908E0" ),
      MpIeee( "16.114E0" ),
      MpIeee( "17.071E0" ),
      MpIeee( "17.135E0" ),
      MpIeee( "17.282E0" ),
      MpIeee( "17.368E0" ),
      MpIeee( "17.483E0" ),
      MpIeee( "17.764E0" ),
      MpIeee( "18.185E0" ),
      MpIeee( "18.271E0" ),
      MpIeee( "18.236E0" ),
      MpIeee( "18.237E0" ),
      MpIeee( "18.523E0" ),
      MpIeee( "18.627E0" ),
      MpIeee( "18.665E0" ),
      MpIeee( "19.086E0" ),
       MpIeee( "0.214E0" ),
       MpIeee( "0.943E0" ),
       MpIeee( "1.429E0" ),
       MpIeee( "2.241E0" ),
       MpIeee( "2.951E0" ),
       MpIeee( "3.782E0" ),
       MpIeee( "4.757E0" ),
       MpIeee( "5.602E0" ),
       MpIeee( "7.169E0" ),
       MpIeee( "8.920E0" ),
      MpIeee( "10.055E0" ),
      MpIeee( "12.035E0" ),
      MpIeee( "12.861E0" ),
      MpIeee( "13.436E0" ),
      MpIeee( "14.167E0" ),
      MpIeee( "14.755E0" ),
      MpIeee( "15.168E0" ),
      MpIeee( "15.651E0" ),
      MpIeee( "15.746E0" ),
      MpIeee( "16.216E0" ),
      MpIeee( "16.445E0" ),
      MpIeee( "16.965E0" ),
      MpIeee( "17.121E0" ),
      MpIeee( "17.206E0" ),
      MpIeee( "17.250E0" ),
      MpIeee( "17.339E0" ),
      MpIeee( "17.793E0" ),
      MpIeee( "18.123E0" ),
      MpIeee( "18.49E0" ) ,
      MpIeee( "18.566E0" ),
      MpIeee( "18.645E0" ),
      MpIeee( "18.706E0" ),
      MpIeee( "18.924E0" ),
      MpIeee( "19.1E0" )  ,
       MpIeee( "0.375E0" ),
       MpIeee( "0.471E0" ),
       MpIeee( "1.504E0" ),
       MpIeee( "2.204E0" ),
       MpIeee( "2.813E0" ),
       MpIeee( "4.765E0" ),
       MpIeee( "9.835E0" ),
      MpIeee( "10.040E0" ),
      MpIeee( "11.946E0" ),
      MpIeee( "12.596E0" ),
      MpIeee( "13.303E0" ),
      MpIeee( "13.922E0" ),
      MpIeee( "14.440E0" ),
      MpIeee( "14.951E0" ),
      MpIeee( "15.627E0" ),
      MpIeee( "15.639E0" ),
      MpIeee( "15.814E0" ),
      MpIeee( "16.315E0" ),
      MpIeee( "16.334E0" ),
      MpIeee( "16.430E0" ),
      MpIeee( "16.423E0" ),
      MpIeee( "17.024E0" ),
      MpIeee( "17.009E0" ),
      MpIeee( "17.165E0" ),
      MpIeee( "17.134E0" ),
      MpIeee( "17.349E0" ),
      MpIeee( "17.576E0" ),
      MpIeee( "17.848E0" ),
      MpIeee( "18.090E0" ),
      MpIeee( "18.276E0" ),
      MpIeee( "18.404E0" ),
      MpIeee( "18.519E0" ),
      MpIeee( "19.133E0" ),
      MpIeee( "19.074E0" ),
      MpIeee( "19.239E0" ),
      MpIeee( "19.280E0" ),
      MpIeee( "19.101E0" ),
      MpIeee( "19.398E0" ),
      MpIeee( "19.252E0" ),
      MpIeee( "19.89E0" ) ,
      MpIeee( "20.007E0" ),
      MpIeee( "19.929E0" ),
      MpIeee( "19.268E0" ),
      MpIeee( "19.324E0" ),
      MpIeee( "20.049E0" ),
      MpIeee( "20.107E0" ),
      MpIeee( "20.062E0" ),
      MpIeee( "20.065E0" ),
      MpIeee( "19.286E0" ),
      MpIeee( "19.972E0" ),
      MpIeee( "20.088E0" ),
      MpIeee( "20.743E0" ),
      MpIeee( "20.83E0" ) ,
      MpIeee( "20.935E0" ),
      MpIeee( "21.035E0" ),
      MpIeee( "20.93E0" ) ,
      MpIeee( "21.074E0" ),
      MpIeee( "21.085E0" ),
      MpIeee( "20.935E0" )
};


MpIeee hahn1_F0[236] =  {
    MpIeee( "24.41E0" ),
    MpIeee( "34.82E0" ),
    MpIeee( "44.09E0" ),
    MpIeee( "45.07E0" ),
    MpIeee( "54.98E0" ),
    MpIeee( "65.51E0" ),
    MpIeee( "70.53E0" ),
    MpIeee( "75.70E0" ),
    MpIeee( "89.57E0" ),
    MpIeee( "91.14E0" ),
    MpIeee( "96.40E0" ),
    MpIeee( "97.19E0" ),
   MpIeee( "114.26E0" ),
   MpIeee( "120.25E0" ),
   MpIeee( "127.08E0" ),
   MpIeee( "133.55E0" ),
   MpIeee( "133.61E0" ),
   MpIeee( "158.67E0" ),
   MpIeee( "172.74E0" ),
   MpIeee( "171.31E0" ),
   MpIeee( "202.14E0" ),
   MpIeee( "220.55E0" ),
   MpIeee( "221.05E0" ),
   MpIeee( "221.39E0" ),
   MpIeee( "250.99E0" ),
   MpIeee( "268.99E0" ),
   MpIeee( "271.80E0" ),
   MpIeee( "271.97E0" ),
   MpIeee( "321.31E0" ),
   MpIeee( "321.69E0" ),
   MpIeee( "330.14E0" ),
   MpIeee( "333.03E0" ),
   MpIeee( "333.47E0" ),
   MpIeee( "340.77E0" ),
   MpIeee( "345.65E0" ),
   MpIeee( "373.11E0" ),
   MpIeee( "373.79E0" ),
   MpIeee( "411.82E0" ),
   MpIeee( "419.51E0" ),
   MpIeee( "421.59E0" ),
   MpIeee( "422.02E0" ),
   MpIeee( "422.47E0" ),
   MpIeee( "422.61E0" ),
   MpIeee( "441.75E0" ),
   MpIeee( "447.41E0" ),
   MpIeee( "448.7E0" ) ,
   MpIeee( "472.89E0" ),
   MpIeee( "476.69E0" ),
   MpIeee( "522.47E0" ),
   MpIeee( "522.62E0" ),
   MpIeee( "524.43E0" ),
   MpIeee( "546.75E0" ),
   MpIeee( "549.53E0" ),
   MpIeee( "575.29E0" ),
   MpIeee( "576.00E0" ),
   MpIeee( "625.55E0" ),
    MpIeee( "20.15E0" ),
    MpIeee( "28.78E0" ),
    MpIeee( "29.57E0" ),
    MpIeee( "37.41E0" ),
    MpIeee( "39.12E0" ),
    MpIeee( "50.24E0" ),
    MpIeee( "61.38E0" ),
    MpIeee( "66.25E0" ),
    MpIeee( "73.42E0" ),
    MpIeee( "95.52E0" ),
   MpIeee( "107.32E0" ),
   MpIeee( "122.04E0" ),
   MpIeee( "134.03E0" ),
   MpIeee( "163.19E0" ),
   MpIeee( "163.48E0" ),
   MpIeee( "175.70E0" ),
   MpIeee( "179.86E0" ),
   MpIeee( "211.27E0" ),
   MpIeee( "217.78E0" ),
   MpIeee( "219.14E0" ),
   MpIeee( "262.52E0" ),
   MpIeee( "268.01E0" ),
   MpIeee( "268.62E0" ),
   MpIeee( "336.25E0" ),
   MpIeee( "337.23E0" ),
   MpIeee( "339.33E0" ),
   MpIeee( "427.38E0" ),
   MpIeee( "428.58E0" ),
   MpIeee( "432.68E0" ),
   MpIeee( "528.99E0" ),
   MpIeee( "531.08E0" ),
   MpIeee( "628.34E0" ),
   MpIeee( "253.24E0" ),
   MpIeee( "273.13E0" ),
   MpIeee( "273.66E0" ),
   MpIeee( "282.10E0" ),
   MpIeee( "346.62E0" ),
   MpIeee( "347.19E0" ),
   MpIeee( "348.78E0" ),
   MpIeee( "351.18E0" ),
   MpIeee( "450.10E0" ),
   MpIeee( "450.35E0" ),
   MpIeee( "451.92E0" ),
   MpIeee( "455.56E0" ),
   MpIeee( "552.22E0" ),
   MpIeee( "553.56E0" ),
   MpIeee( "555.74E0" ),
   MpIeee( "652.59E0" ),
   MpIeee( "656.20E0" ),
    MpIeee( "14.13E0" ),
    MpIeee( "20.41E0" ),
    MpIeee( "31.30E0" ),
    MpIeee( "33.84E0" ),
    MpIeee( "39.70E0" ),
    MpIeee( "48.83E0" ),
    MpIeee( "54.50E0" ),
    MpIeee( "60.41E0" ),
    MpIeee( "72.77E0" ),
    MpIeee( "75.25E0" ),
    MpIeee( "86.84E0" ),
    MpIeee( "94.88E0" ),
    MpIeee( "96.40E0" ),
   MpIeee( "117.37E0" ),
   MpIeee( "139.08E0" ),
   MpIeee( "147.73E0" ),
   MpIeee( "158.63E0" ),
   MpIeee( "161.84E0" ),
   MpIeee( "192.11E0" ),
   MpIeee( "206.76E0" ),
   MpIeee( "209.07E0" ),
   MpIeee( "213.32E0" ),
   MpIeee( "226.44E0" ),
   MpIeee( "237.12E0" ),
   MpIeee( "330.90E0" ),
   MpIeee( "358.72E0" ),
   MpIeee( "370.77E0" ),
   MpIeee( "372.72E0" ),
   MpIeee( "396.24E0" ),
   MpIeee( "416.59E0" ),
   MpIeee( "484.02E0" ),
   MpIeee( "495.47E0" ),
   MpIeee( "514.78E0" ),
   MpIeee( "515.65E0" ),
   MpIeee( "519.47E0" ),
   MpIeee( "544.47E0" ),
   MpIeee( "560.11E0" ),
   MpIeee( "620.77E0" ),
    MpIeee( "18.97E0" ),
    MpIeee( "28.93E0" ),
    MpIeee( "33.91E0" ),
    MpIeee( "40.03E0" ),
    MpIeee( "44.66E0" ),
    MpIeee( "49.87E0" ),
    MpIeee( "55.16E0" ),
    MpIeee( "60.90E0" ),
    MpIeee( "72.08E0" ),
    MpIeee( "85.15E0" ),
    MpIeee( "97.06E0" ),
   MpIeee( "119.63E0" ),
   MpIeee( "133.27E0" ),
   MpIeee( "143.84E0" ),
   MpIeee( "161.91E0" ),
   MpIeee( "180.67E0" ),
   MpIeee( "198.44E0" ),
   MpIeee( "226.86E0" ),
   MpIeee( "229.65E0" ),
   MpIeee( "258.27E0" ),
   MpIeee( "273.77E0" ),
   MpIeee( "339.15E0" ),
   MpIeee( "350.13E0" ),
   MpIeee( "362.75E0" ),
   MpIeee( "371.03E0" ),
   MpIeee( "393.32E0" ),
   MpIeee( "448.53E0" ),
   MpIeee( "473.78E0" ),
   MpIeee( "511.12E0" ),
   MpIeee( "524.70E0" ),
   MpIeee( "548.75E0" ),
   MpIeee( "551.64E0" ),
   MpIeee( "574.02E0" ),
   MpIeee( "623.86E0" ),
    MpIeee( "21.46E0" ),
    MpIeee( "24.33E0" ),
    MpIeee( "33.43E0" ),
    MpIeee( "39.22E0" ),
    MpIeee( "44.18E0" ),
    MpIeee( "55.02E0" ),
    MpIeee( "94.33E0" ),
    MpIeee( "96.44E0" ),
   MpIeee( "118.82E0" ),
   MpIeee( "128.48E0" ),
   MpIeee( "141.94E0" ),
   MpIeee( "156.92E0" ),
   MpIeee( "171.65E0" ),
   MpIeee( "190.00E0" ),
   MpIeee( "223.26E0" ),
   MpIeee( "223.88E0" ),
   MpIeee( "231.50E0" ),
   MpIeee( "265.05E0" ),
   MpIeee( "269.44E0" ),
   MpIeee( "271.78E0" ),
   MpIeee( "273.46E0" ),
   MpIeee( "334.61E0" ),
   MpIeee( "339.79E0" ),
   MpIeee( "349.52E0" ),
   MpIeee( "358.18E0" ),
   MpIeee( "377.98E0" ),
   MpIeee( "394.77E0" ),
   MpIeee( "429.66E0" ),
   MpIeee( "468.22E0" ),
   MpIeee( "487.27E0" ),
   MpIeee( "519.54E0" ),
   MpIeee( "523.03E0" ),
   MpIeee( "612.99E0" ),
   MpIeee( "638.59E0" ),
   MpIeee( "641.36E0" ),
   MpIeee( "622.05E0" ),
   MpIeee( "631.50E0" ),
   MpIeee( "663.97E0" ),
   MpIeee( "646.9E0" ) ,
   MpIeee( "748.29E0" ),
   MpIeee( "749.21E0" ),
   MpIeee( "750.14E0" ),
   MpIeee( "647.04E0" ),
   MpIeee( "646.89E0" ),
   MpIeee( "746.9E0" ) ,
   MpIeee( "748.43E0" ),
   MpIeee( "747.35E0" ),
   MpIeee( "749.27E0" ),
   MpIeee( "647.61E0" ),
   MpIeee( "747.78E0" ),
   MpIeee( "750.51E0" ),
   MpIeee( "851.37E0" ),
   MpIeee( "845.97E0" ),
   MpIeee( "847.54E0" ),
   MpIeee( "849.93E0" ),
   MpIeee( "851.61E0" ),
   MpIeee( "849.75E0" ),
   MpIeee( "850.98E0" ),
   MpIeee( "848.23E0" )
};


int
 hahn1_f(const gsl_vector * x, void *params, gsl_vector * f)
{
  MpIeee b[7];
  size_t i;

  for (i = 0; i < 7; i++)
    {
      b[i] = gsl_vector_get(x, i);
    }

  for (i = 0; i < 236; i++)
    {
      MpIeee x=  hahn1_F0[i];
      MpIeee y=  ((b[0] + x* (b[1]  + x * (b[2] + x * b[3])))
                  / (MpIeee( "1" ) + x*(b[4]  + x *(b[5] + x*b[6]))));
      gsl_vector_set (f, i, hahn1_F1[i] - y);
    }

  return GSL_SUCCESS;
}

int
 hahn1_df(const gsl_vector * x, void *params, gsl_matrix * df)
{
  MpIeee b[7];
  size_t i;

  for (i = 0; i < 7; i++)
    {
      b[i] = gsl_vector_get(x, i);
    }

  for (i = 0; i < 236; i++)
    {
      MpIeee x=  hahn1_F0[i];
      MpIeee u=  (b[0] + x*(b[1] + x*(b[2] + x * b[3])));
      MpIeee v=  (MpIeee( "1" ) + x*(b[4] + x*(b[5] + x*b[6])));
      gsl_matrix_set (df, i, 0, -1/v);
      gsl_matrix_set (df, i, 1, -x/v);
      gsl_matrix_set (df, i, 2, -x*x/v);
      gsl_matrix_set (df, i, 3, -x*x*x/v);
      gsl_matrix_set (df, i, 4, x*u/(v*v));
      gsl_matrix_set (df, i, 5, x*x*u/(v*v));
      gsl_matrix_set (df, i, 6, x*x*x*u/(v*v));
    }

  return GSL_SUCCESS;
}

int
 hahn1_fdf(const gsl_vector * x, void *params,
           gsl_vector * f, gsl_matrix * df)
{
  hahn1_f (x, params, f);
  hahn1_df (x, params, df);

  return GSL_SUCCESS;
}
