.TH PYTHAG 3 "01 May 2000" "Version 1.00"
.\" WARNING: This file was produced automatically from file common/pythag.f
.\" by fortran-to-man-page.awk on Sun Dec 31 09:02:18 MST 2000.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
pythag \- Double-precision Euclidean 2-norm
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "DOUBLE PRECISION FUNCTION pythag(a,b)"
.B "DOUBLE PRECISION   a,           b"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gampsi.h>"
.RE
to get this prototype:
.RS
.B "fortran_double_precision pythag(const fortran_double_precision * a_,"
.B "                                const fortran_double_precision * b_);"
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.PP
Last code modification: 01-May-2000
.\"=====================================================================
.SH DESCRIPTION
Find dsqrt(\fBa\fP\&**2 + \fBb\fP\&**2) without overflow or destructive underflow,
and handle Infinity and NaN arguments correctly.
.PP
The original version of this function (from EISPACK-2) due to
.PP
.RS
.nf
Cleve Moler and Donald Morrison, ``Replacing Square Roots by
Pythagorean Sums'', IBM J. Research and Development, 27,
577--581 (1983)
.fi
.RE
.PP
.RS
.nf
Augustin A. Dubrulle, ``A Class of Numerical Methods for the
Computation of Pythagorean Sums'', IBM J. Research and
Development, 27, 582--589 (1983)
.fi
.RE
.PP
did not correctly handle Infinity and NaN arguments: it went
into an infinite loop. This version is more robust, with two
extra tests to detect such arguments.
.PP
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Algorithm xxx: Quadruple-Precision Gamma(x) and psi(x) Functions for Real Arguments"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 2001, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
