IF( WIN32 AND CMAKE_CL_64 )
  FIND_LIBRARY( WIN32_BLAS NAMES libblas64 PATHS 
    ${WIN32_LAPACK_ADDITIONAL_DIRS}
    ${CMAKE_SOURCE_DIR}/ThirdParty
    ${CMAKE_SOURCE_DIR}/../ThirdParty)

  FIND_LIBRARY( WIN32_LAPACK NAMES liblapack64 PATHS 
    ${WIN32_LAPACK_ADDITIONAL_DIRS}
    ${CMAKE_SOURCE_DIR}/ThirdParty
    ${CMAKE_SOURCE_DIR}/../ThirdParty)
ELSE()
FIND_LIBRARY( WIN32_BLAS NAMES blas_win32 PATHS 
	${WIN32_LAPACK_ADDITIONAL_DIRS}
	${CMAKE_SOURCE_DIR}/ThirdParty
	${CMAKE_SOURCE_DIR}/../ThirdParty)

FIND_LIBRARY( WIN32_LAPACK NAMES lapack_win32 PATHS 
	${WIN32_LAPACK_ADDITIONAL_DIRS}
	${CMAKE_SOURCE_DIR}/ThirdParty
	${CMAKE_SOURCE_DIR}/../ThirdParty)
ENDIF()

CHANGE_EXTENSION(WIN32_LAPACK_DLL ${WIN32_LAPACK} "dll")
CHANGE_EXTENSION(WIN32_BLAS_DLL ${WIN32_BLAS} "dll")

GET_FILENAME_COMPONENT(LAPACK_DIR ${WIN32_LAPACK} PATH CACHE)
LINK_DIRECTORIES(${LAPACK_DIR})

IF (WIN32_BLAS)
  SET(WIN32_LAPACK_FOUND ON)
ENDIF (WIN32_BLAS)

IF (WIN32_LAPACK_FOUND)
  IF (NOT WIN32_LAPACK_FIND_QUIETLY)
     MESSAGE(STATUS "Found WIN32 Lapack: ${WIN32_LAPACK}")
  ENDIF (NOT WIN32_LAPACK_FIND_QUIETLY)
ELSE(WIN32_LAPACK_FOUND)
  IF (WIN32_LAPACK_FIND_REQUIRED)
     MESSAGE(FATAL_ERROR "Could not find Win32 Lapack")
  ENDIF (WIN32_LAPACK_FIND_REQUIRED)
ENDIF (WIN32_LAPACK_FOUND)
