
FIND_PATH(MKL_INCLUDE_DIR mkl_cblas.h /usr/include 
				      /usr/local/include
				      /opt/intel/mkl/8.1.1/include
                                      $ENV{MKL_HOME}/include)

IF( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )
  GET_FILENAME_COMPONENT(MKL_LIB_PATH ${MKL_INCLUDE_DIR}/../lib/64 ABSOLUTE)
ELSE ( CMAKE_SYSTEM_PROCESSOR  STREQUAL "x86_64" )
  GET_FILENAME_COMPONENT(MKL_LIB_PATH ${MKL_INCLUDE_DIR}/../lib/32 ABSOLUTE)
ENDIF( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )

FIND_LIBRARY( MKL_LAPACK NAMES mkl_lapack PATHS ${MKL_LIB_PATH} )

IF ( MKL_LAPACK_FOUND )
  # old MKL versions
  IF ( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )
     FIND_LIBRARY( MKL NAMES mkl_ia64 PATHS ${MKL_LIB_PATH} )
  ELSE ( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )
     FIND_LIBRARY( MKL NAMES mkl_ia32 PATHS ${MKL_LIB_PATH} )
  ENDIF( CMAKE_SYSTEM_PROCESSOR STREQUAL "x86_64" )
  FIND_LIBRARY( MKL_GUIDE NAMES guide PATHS ${MKL_LIB_PATH} )
  SET (MKL ${MKL} ${MKL_LAPACK} ${MKL_GUIDE} )
ELSE (MKL_LAPACK_FOUND )
  # newer MKL version
  SET (MKL_LAPACK "")
  FIND_LIBRARY( MKL_INTEL NAMES mkl_intel_lp64 PATHS ${MKL_LIB_PATH} )
  FIND_LIBRARY( MKL_SEQUENTIAL NAMES mkl_sequential PATHS ${MKL_LIB_PATH} )
  FIND_LIBRARY( MKL_CORE NAMES mkl_core PATHS ${MKL_LIB_PATH} )
  SET (MKL ${MKL_INTEL} ${MKL_SEQUENTIAL} ${MKL_CORE} )
ENDIF ( MKL_LAPACK_FOUND )


SET( MKL_BLAS_INCLUDE_FILE ${MKL_INCLUDE_DIR}/mkl_blas.h )
SET( MKL_LAPACK_INCLUDE_FILE ${MKL_INCLUDE_DIR}/mkl_lapack.h )

IF (MKL_INCLUDE_DIR)
  SET(MKL_FOUND ON)
ENDIF (MKL_INCLUDE_DIR)

IF (MKL_FOUND OR MKL_INTEL_FOUND )
  IF (NOT MKL_FIND_QUIETLY)
     MESSAGE(STATUS "Found MKL: ${MKL_INCLUDE_DIR}")
  ENDIF (NOT MKL_FIND_QUIETLY)
ELSE(MKL_FOUND OR MKL_INTEL_FOUND )
  IF (MKL_FIND_REQUIRED)
     MESSAGE(FATAL_ERROR "Could not find MKL")
  ENDIF (MKL_FIND_REQUIRED)
ENDIF (MKL_FOUND OR MKL_INTEL_FOUND )
