program thrdtmessy
! This code will probably not work with messy, unless some lines are uncommented
! in messy,  Look for !SAVE at the start of a line.  On that line until the last
! line starting with !!$OMP, remove the first '!' of the line.  With gfortran
! uncommenting these lines makes the object file for messy_m 20% bigger.
  use messy_m, only : messy, messy_ty
  implicit none
  TYPE(MESSY_TY), ALLOCATABLE :: ET(:)
  TYPE(MESSY_TY) :: E
  CHARACTER(LEN=8) :: BUF
  INTEGER :: I, MAXT, NT, OMP_GET_MAX_THREADS, OMP_GET_THREAD_NUM
  SAVE NT
  !$OMP THREADPRIVATE(NT)

  ! BUF  Used for creating character representation of integers
  !      and lines of working characterp strings
  ! MAXT Max number of threads in use in a parallel section
  ! NT   The thread index used in a parallel do section
  ! Small test of threaded use of messy to named files MSG21,...,MSG(20+MAXT)
  ! and error or exception output to files ERR121,...,ERR(120+MAXT)
  MAXT=OMP_GET_MAX_THREADS()
  ALLOCATE(ET(MAXT))

  e%ename="thrdtmessy"
  call messy(e, "$L72$E18This is a warning.  If you have not read the lines at&
    & the top of thrdtmessy.f90 and followed the suggestions there, there is a&
    & good chance that this will not work correctly.")

  ! Assign units, one for each thread, with unique message and error units.
  BUF=' '
  DO I=1,MAXT
    ET(I) % ENAME ='thrdtmessy'          ! Define program unit making 'error' call
    ET(I) % MUNIT =  21+(I-1)            ! Define units for each thread
    ET(I) % EUNIT = 121+(I-1)
    WRITE(BUF,'("MSG", I0)') ET(I)%MUNIT  ! Create names for message files
    OPEN(UNIT=ET(I)%MUNIT, FILE=BUF, STATUS='REPLACE')

! STATUS="REPLACE" if Fortran 2008.  If not supported try something else.

    WRITE(BUF,'("ERR",I0)') ET(I)%EUNIT   ! Create names for error files
    OPEN(UNIT=ET(I)%EUNIT, FILE=BUF, STATUS='REPLACE')
  END DO
  !Execute a parallel do, with OpenMP.  Each thread writes a simple message.
  !Every third value of the loop index writes an exception or "error" message.

  ! Note that OpenMP types the loop index I as THREADPRIVATE, by default.
  !$OMP PARALLEL DO SCHEDULE(STATIC)! STATIC, DYNAMIC, GUIDED, RUNTIME, or AUTO

  DO I=1,3*MAXT ! Upper limit here is arbitrary > 0.
    NT=OMP_GET_THREAD_NUM()
    CALL MESSY(ET(NT+1),'MESSY says Hi from Thread =$I,'&
      &//' writing the loop index =$I',idat=[NT,I])
    ! Every third value of I writes an error message.
    IF(MOD(I,3) /= 0) CYCLE
    ! Note the trailing $B in the next text argument.
    ! Without this, further output will be in the error files. 
    CALL MESSY(ET(NT+1),'$E14MESSY notes every third loop value as an "error"'//&
      &' for Thread=$I, value=$I$B',idat=[1,NT,I])
  END DO
  !$OMP END PARALLEL DO
  do i = 1, maxt
    CALL MESSY(E, "Data written to MSG$I and ERR$I", [ET(I)%MUNIT, ET(I)%EUNIT])
  end do

  call messy(e, "$NAll looks o.k. Check the files above.$N$N")

  ! Contents of these files can be seen in Windows with: type MSG* ERR*
  ! and in Linux or Unix with: cat MSG* ERR*
end program thrdtmessy
