    MODULE weidemanMod

    CONTAINS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!
      ELEMENTAL SUBROUTINE weideman32a(zarg,cef)
!!
!!  Computes the complex error function w(zarg) = u + iv = w(x+iy)
!!  according to J.A.C. Weideman,  SIAM J. Numer. Anal. 31 (1994)
!!  pp. 1497-1518,  equation (38.I) and table I
!!  
!!  Fig. 4 indicates a (maximum) relative error of 10**-3 and 10**-6
!!  for the 8 and 16 term approximation
!!  This suggests a relative error better than 10**-9 for the N=32 
!!  approximation
!!
!!  march 2015: parameterized precision;
!!
!!              made function elemental;
!!
!!              confirmed accuracy of 10**(-12) for wide range of 
!!                arguments for N=32 approximation
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! .. Use Statements ..
        USE set_rk, ONLY : wp=>r8
! ..
! .. Parameters ..
        REAL (wp), PARAMETER :: half = 0.5E0_wp, one = 1.0E0_wp, &
                                two = 2.0E0_wp, &
                                recsqrtpi = half/SQRT(atan(one))
        REAL (wp), PARAMETER :: l = 4.7568284600108841E0_wp ! l=sqrt(n/sqrt(2.))
        INTEGER, PARAMETER :: n = 32
        REAL (wp), PARAMETER :: a(n) = (/ -1.3031797863050087E-12_wp, &
          3.7424975634801558E-12_wp, 8.0314997274316680E-12_wp, &
          -2.1542618451370239E-11_wp, -5.5441820344468828E-11_wp, &
          1.1658312885903929E-10_wp, 4.1537465934749353E-10_wp, &
          -5.2310170266050247E-10_wp, -3.2080150458594088E-09_wp, &
          8.1248960947953431E-10_wp, 2.3797557105844622E-08_wp, &
          2.2930439569075392E-08_wp, -1.4813078891201116E-07_wp, &
          -4.1840763666294341E-07_wp, 4.2558331390536872E-07_wp, &
          4.4015317319048931E-06_wp, 6.8210319440412389E-06_wp, &
          -2.1409619200870880E-05_wp, -1.3075449254548613E-04_wp, &
          -2.4532980269928922E-04_wp, 3.9259136070122748E-04_wp, &
          4.5195411053501429E-03_wp, 1.9006155784845689E-02_wp, &
          5.7304403529837900E-02_wp, 1.4060716226893769E-01_wp, &
          2.9544451071508926E-01_wp, 5.4601397206393498E-01_wp, &
          9.0192548936480144E-01_wp, 1.3455441692345453E0_wp, &
          1.8256696296324824E0_wp, 2.2635372999002676E0_wp, &
          2.5722534081245696E0_wp/)
! ..
! .. Scalar Arguments ..
        COMPLEX (wp), INTENT (OUT) :: cef
        COMPLEX (wp), INTENT (IN) :: zarg
! ..
! .. Local Scalars ..
        COMPLEX (wp) :: reclmz, z
        REAL (wp) :: x, y
! ..
! .. Intrinsic Functions ..
        INTRINSIC aimag, cmplx, real
! ..
        x = real(zarg,kind=wp)
        y = aimag(zarg)

!   ----------------------------------------------------

        reclmz = one/cmplx(l+y,-x,wp)
        z = cmplx(l-y,x,wp)*reclmz ! Weideman's upper case Z (not the z=x+iy)
        cef = reclmz*(recsqrtpi+two*reclmz*(a(32)+(a(31)+ &
          (a(30)+(a(29)+(a(28)+(a(27)+(a(26)+(a(25)+(a(24)+(a(23)+( &
          a(22)+(a(21)+(a(20)+(a(19)+(a(18)+(a(17)+(a(16)+(a(15)+(a(14)+(a(13) &
          +(a(12)+(a(11)+(a(10)+(a(9)+(a(8)+(a(7)+(a(6)+(a(5)+(a(4)+ &
          (a(3)+(a(2)+a(1)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)* &
          z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z)*z))

!   -----------------------------------------------------

      END SUBROUTINE weideman32a


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!
      ELEMENTAL SUBROUTINE weideman16c(zarg,cef)
!!
!!  Computes the complex error function w(z) = w(x+iy) = u + iv
!!  according to J.A.C. Weideman,  SIAM J. Numer. Anal. 31 (1994)
!!  pp. 1497-1518,  equation (38.III)
!!
!!  Fig. 6 indicates a (maximum) relative error of 10**-7 for the 
!!  16 term approximation
!!
!!  march 2015: parameterized precision;
!!
!!              made function elemental;
!!
!!  WARNING:: This code does not appear to give the accuracy
!!            expected for this approximation.
!!            For tests on a wide range of arguments the average
!!            accuracy was O(10^-5) and max relative error O(10^-3)
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!   further variables
! .. Use Statements ..
        USE set_rk, ONLY : wp=>r8
! ..
! .. Parameters ..
        REAL (wp), PARAMETER :: two = 2.0E0_wp
        REAL (wp), PARAMETER :: l16 = 3.3635856610148585E0_wp
        INTEGER, PARAMETER :: n = 16
        REAL (wp), PARAMETER :: c(0:n) = (/ 1.6113619507362786E-01_wp, &
          1.4930410723321574E-01_wp, 1.1842547828839359E-01_wp, &
          7.9647345163372352E-02_wp, 4.4553723452833510E-02_wp, &
          1.9966856069114962E-02_wp, 6.5975073282514641E-03_wp, &
          1.2221130207159285E-03_wp, -1.2390107986207227E-04_wp, &
          -1.5134964555600807E-04_wp, -2.5254451440227268E-05_wp, &
          1.1715048611098254E-05_wp, 5.0112634426414266E-06_wp, &
          -8.5222221186645569E-07_wp, -7.6309160412714471E-07_wp, &
          7.4517431589434247E-08_wp, 1.1684961555291640E-07_wp/)
! ..
! .. Scalar Arguments ..
        COMPLEX (wp), INTENT (OUT) :: cef
        COMPLEX (wp), INTENT (IN) :: zarg
! ..
! .. Local Scalars ..
        COMPLEX (wp) :: iz, polynom, r
        REAL (wp) :: x, y
! ..
! .. Intrinsic Functions ..
        INTRINSIC aimag, cmplx, real
! ..
        x = real(zarg,kind=wp)
        y = aimag(zarg)

!   ----------------------------------------------------

        iz = cmplx(-y,x,wp)
        r = (l16+iz)/(l16-iz) ! Weideman's upper case Z
        polynom = (c(1)+(c(2)+(c(3)+(c(4)+(c(5)+(c(6)+(c(7)+(c(8)+(c(9) &
          +(c(10)+(c(11)+(c(12)+(c(13)+(c(14)+(c(15)+c(16)*r)*r)*r)*r)*r)*r) &
          *r)*r)*r)*r)*r)*r)*r)*r)*r)*r
        cef = c(0) + two*polynom

!   ----------------------------------------------------

      END SUBROUTINE weideman16c
    END MODULE weidemanMod
