    MODULE humlicekmod

    CONTAINS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!!
!
      ELEMENTAL SUBROUTINE humlicek0(z,prbfct)
!!
!
!!    complex probability function for complex argument Z=X+iY
!
!!    real part = voigt function K(x,y)
!
!!    source:   j. humlicek, JQSRT 27, 437, 1982
!
!!    the stated accuracy is claimed to be 1.0E-04 by the author.
!
!!    r.h.norton has checked the accuracy by comparing values computed
!!    using a program written by b.h.armstrong,
!!    and the accuracy claim seems to be warranted. 
!
!!    12/91, converted to f90 may 2009
!!    march 2015, converted to elemental function;
!!
!!                parameterized precision (change r8 to r4 for single
!!                  precision version);
!!
!!                use parameter arrays for rational function 
!!                  coefficients
!!
!!                runs against other approximations confirm 4 dp 
!!                  accuracy claim
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
! .. Use Statements ..
        USE set_rk, ONLY : wp=>rk
! ..
! .. Parameters ..
        REAL (wp), PARAMETER :: s15 = 15.D0, s55 = 5.5D0
        REAL (wp), PARAMETER :: half = 0.5E0_wp, one = 1.0E0_wp, &
                                recsqrtpi = half/SQRT(atan(one))
        REAL (wp), PARAMETER :: a2(3) = [1.410474E0_wp, 0.75E0_wp, 3.0E0_wp]
        REAL (wp), PARAMETER :: a3(10) = [ 16.4955E0_wp, 20.20933E0_wp, &
            11.96482E0_wp, 3.778987E0_wp, 0.5642236E0_wp, 16.4955E0_wp, &
            38.82363E0_wp, 39.27121E0_wp, 21.69274E0_wp, 6.699398E0_wp]
        REAL (wp), PARAMETER :: a4(13) = [ &
          36183.31E0_wp, 3321.99E0_wp, 1540.787E0_wp, 219.031E0_wp,  &
            35.7668E0_wp, 1.320522E0_wp, 32066.6E0_wp, 24322.8E0_wp, & 
            9022.23E0_wp, 2186.18E0_wp, 364.219E0_wp, 61.5704E0_wp, 1.84144E0_wp] 

! ..
! .. Scalar Arguments ..
        COMPLEX (wp), INTENT (OUT) :: prbfct
        COMPLEX (wp), INTENT (IN) :: z
! ..
! .. Local Scalars ..
        COMPLEX (wp) :: t, u
        REAL (wp) :: ax, s, x, y
! ..
! .. Intrinsic Functions ..
        INTRINSIC abs, aimag, cmplx, exp, real
! ..
        x = real(z,kind=wp)
        y = aimag(z)
        t = cmplx(y,-x,wp)
        ax = abs(x)
        s = ax + y
        IF (s>=s15) THEN
!          region I
          prbfct = t*recsqrtpi/(half+t*t)
        ELSE IF (s<s15 .AND. s>=s55) THEN
!          region II
          u = t*t
          prbfct = (t*(a2(1)+u*recsqrtpi))/(a2(2)+(u*(a2(3)+u)))
        ELSE IF (s<s55 .AND. y>=(0.195*ax-0.176)) THEN
!         region III
          prbfct = (a3(1)+t*(a3(2)+t*(a3(3)+ &
            t*(a3(4)+a3(5)*t))))/(a3(6)+t*(a3(7)+t*(a3(8)+ &
            t*(a3(9)+t*(a3(10)+t)))))
        ELSE
!         region IV
          u = t*t
          prbfct = exp(u) - (t*(a4(1)-u*(a4(2)-u*(a4(3)-u*(a4(4)-u*( &
            a4(5)-u*(a4(6)-u*recsqrtpi))))))/(a4(7)-u*(a4(8)- &
            u*(a4(9)-u*(a4(10)-u*(a4(11)-u*(a4(12)-u*(a4(13)-u))))))))
        END IF

!   ==============================================================
!
!y0 IF (y<=zero) THEN
!y0     DO  i=0,nx
!y0        prbFct = cmplx(exp(-X**2), aimag(PrbFct)))
!y0     END DO
!y0 END IF
!   ==============================================================
!
      END SUBROUTINE humlicek0
    END MODULE humlicekmod
