! Last Change:  Mofreh Zaghloul   June 17, 2015

!.. For compilation
! >ifort set_rk.f90 humlicek0.f90 wofz.f90 weideman.f90 rk_erfcx_Cody.f90
!  Faddeyeva_v2_mod_rk.f90 Faddeyeva_driver_rk.f90 -o Faddeyeva_driver_rk

PROGRAM faddeyeva_driver_rk
    ! .. Use Statements ..
    USE set_rk, ONLY : r4,rk
    USE Faddeyeva_v2_mod_rk, ONLY : Faddeyeva_v2_rk
    USE wofzmod, ONLY : wofz
    USE humlicekmod, ONLY : humlicek0
    USE weidemanmod, ONLY : weideman16c, weideman32a
    ! ..
    ! .. Parameters ..
    INTEGER, PARAMETER :: m_max = 40001, n_max = 71, nRepeats=100
    ! ..
    ! .. Local Scalars ..
    REAL (rk) :: maxerr_im, maxerr_re, time_begin, time_end, xtmp, ytmp
    REAL(rk), DIMENSION(m_max):: harvest
    INTEGER :: IM, jn, ndgts, icase, maxNdgts

    ! ..
    ! .. Local Arrays ..
    COMPLEX (rk) :: w(m_max*n_max), wacc(m_max*n_max), z(m_max*n_max), &
        z2(m_max,n_max)
! Needed if computing derivatives and exit status values
!   REAL (rk) ::   dvdx(m_max*n_max), dvdy(m_max*n_max)
!   INTEGER, DIMENSION(m_max*n_max)::STAT
    LOGICAL :: flag(m_max*n_max)
    ! ..
    ! .. Intrinsic Functions ..
    INTRINSIC CMPLX, CPU_TIME, REAL
    ! ..
    ! .. Equivalences ..
    EQUIVALENCE (z,z2)

    CALL RANDOM_SEED()
    CALL RANDOM_NUMBER(HARVEST)
    ! ..
    ! .. define x and y arrays
    DO icase=1,4     ! Loop on the four tested cases
        DO IM = 1, m_max
            DO jn = 1, n_max
                !.. Case 1
                IF (icase==1)THEN
                    xtmp = -5.0e2_rk+REAL((IM-1),KIND=rk)*(10.0e2_rk/REAL((m_max-1),KIND=rk))
                    ytmp = 1.0e1_rk**(-5.0e0_rk+REAL((jn-1),KIND=rk)*1.0e1_rk/REAL((n_max-1),KIND=rk))

                    !.. Case 2
                ELSEIF (icase==2)THEN
                    xtmp = -2.0e2_rk+REAL((IM-1),KIND=rk)*(4.0e2_rk/REAL((m_max-1),KIND=rk))
                    ytmp = 1.0e1_rk**(-2.0e1_rk+REAL((jn-1),KIND=rk)*2.4e1_rk/REAL((n_max-1),KIND=rk))

                    !.. Case 3
                ELSEIF (icase==3)THEN
                    xtmp = -1.0e1_rk+REAL((IM-1),KIND=rk)*(2.0e1_rk/REAL((m_max-1),KIND=rk))
                    ytmp = 1.0e1_rk**(-5.0e0_rk+REAL((jn-1),KIND=rk)*1.e1_rk/REAL((n_max-1),KIND=rk))


                    !.. Case 4 (|z|^2<=36)
                ELSEIF (icase==4)THEN
                    ytmp = 1.0e1_rk**(-2.0e1_rk+REAL((jn-1),KIND=rk)*2.077815e+001_rk/REAL((n_max-1),KIND=rk))
                    xtmp = -6.0_rk+harvest(IM)*2.0_rk*(36.0_rk-ytmp*ytmp)**0.5_rk
                END IF
                z2(IM,jn) = CMPLX(xtmp,ytmp,KIND=rk)
            END DO
        END DO

        WRITE (*,'(/a,I5)') 'Results for Case', icase
        ! Generate best accuracy using Zaghloul with Ndgts=13
        ndgts = 13

        !   CALL Faddeyeva_v2_rk(z,wacc,ndgts,dvdx,dvdy,Stat)
        CALL faddeyeva_v2_rk(z,wacc,ndgts)

                !..  Test Weideman's 16 point routine
                CALL CPU_TIME(time_begin)
                DO IM = 1, nRepeats
                    CALL weideman16c(z,w)
                END DO
                CALL CPU_TIME(time_end)
                CALL errors(maxerr_re,maxerr_im)

                WRITE (*,'(/a,g13.6,a)') 'Weideman 16-point  elapsed time =', &
                        (time_end-time_begin), ' processor dependent units'
                WRITE (*,'(a,g13.6,a)') 'Average time per call =', &
                        (time_end-time_begin)/(m_max*n_max*nRepeats), ' processor dependent units'
                    IF (rk/=r4)THEN
                WRITE (*,'(a,2e12.4)') 'Max relative differences: ', maxerr_re, maxerr_im
                    ENDIF


                !.. Test Weideman's 32 point routine
                w=HUGE(0.0E0_rk)
                CALL CPU_TIME(time_begin)
                DO IM = 1, nRepeats
                    CALL weideman32a(z,w)
                END DO
                CALL CPU_TIME(time_end)
                CALL errors(maxerr_re,maxerr_im)

                WRITE (*,'(/a,g13.6,a)') 'Weideman 32-point  elapsed time =', &
                        (time_end-time_begin), ' processor dependent units'
                WRITE (*,'(a,g13.6,a)') 'Average time per call =', &
                        (time_end-time_begin)/(m_max*n_max*nRepeats), ' processor dependent units'
                    IF (rk/=r4)THEN
                WRITE (*,'(a,2e12.4)') 'Max relative differences: ', maxerr_re, maxerr_im
                    ENDIF

        !.. Test Humlicek's routine
        w=HUGE(0.0E0_rk)
        CALL CPU_TIME(time_begin)
        DO IM = 1, nRepeats
            CALL humlicek0(z,w)
        END DO
        CALL CPU_TIME(time_end)
        CALL errors(maxerr_re,maxerr_im)

        !    WRITE (*,'(/a,g13.6,a)') rk,'Humlicek  elapsed time =', &
            !        (time_end-time_begin), ' processor dependent units'
        WRITE (*,'(/a,2I5,A,g13.6,a)') 'Humlicek',4, rk, &
            '  elapsed time =', (time_end-time_begin), &
            ' processor dependent units'

        WRITE (*,'(a,g13.6,a)') 'Average time per call =', &
            (time_end-time_begin)/(m_max*n_max*nRepeats), ' processor dependent units'
        IF (rk/=r4)THEN
            WRITE (*,'(a,2e12.4)') 'Max relative differences: ', maxerr_re, maxerr_im
        ENDIF

                !.. Test wofz routine
                w=HUGE(0.0E0_rk)
                CALL CPU_TIME(time_begin)
                DO IM = 1, nRepeats
                    CALL wofz(z,w,flag)
                END DO
                CALL CPU_TIME(time_end)
                CALL errors(maxerr_re,maxerr_im)

                WRITE (*,'(/a,g13.6,a)') 'Wofz  elapsed time =', (time_end-time_begin), &
                        ' processor dependent units'
                WRITE (*,'(a,g13.6,a)') 'Average time per call =', &
                        (time_end-time_begin)/(m_max*n_max*nRepeats), ' processor dependent units'
                    IF (rk/=r4)THEN
                WRITE (*,'(a,2e12.4)') 'Max relative differences: ', maxerr_re, maxerr_im
                    ENDIF

        IF (rk == r4) THEN
          maxNdgts = 6
        ELSE
          maxNdgts = 13
        END IF
        !.. Test Zaghloul's routine
        w=HUGE(0.0E0_rk)
        DO ndgts = 4, maxNdgts
            CALL CPU_TIME(time_begin)
            DO IM = 1, nRepeats
                !CALL Faddeyeva_v2_rk(z,w,ndgts,dvdx,dvdy,stat)
                CALL Faddeyeva_v2_rk(z,w,ndgts)
            END DO
            CALL CPU_TIME(time_end)
            CALL errors(maxerr_re,maxerr_im)

            WRITE (*,'(/a,2I5,A,g13.6,a)') 'Zaghloul', ndgts, rk, &
                '  elapsed time =', (time_end-time_begin), &
                ' processor dependent units'
            WRITE (*,'(a,g13.6,a)') 'Average time per call =', &
                (time_end-time_begin)/(m_max*n_max*nRepeats), &
                ' processor dependent units'
            IF (rk/=r4)THEN
                WRITE (*,'(a,2e12.4)') 'Max relative differences: ', maxerr_re, maxerr_im
            ENDIF
            !                if (any(Stat /= 0))then
            !               WRITE (*,'(a,I5)') 'Stat =', Stat
            !               endif
            w=HUGE(0.0E0_rk)
        END DO
    ENDDO

    ! ----------
CONTAINS
    SUBROUTINE errors(maxerr_re,maxerr_im)
        ! .. Parameters ..
        REAL (rk), PARAMETER :: zero = 0.0E0_rk
        ! ..
        ! .. Scalar Arguments ..
        REAL (rk), INTENT (OUT) :: maxerr_im, maxerr_re
        ! ..
        ! .. Local Scalars ..
        REAL (rk) :: temp_re, temp_im
        INTEGER :: i
        ! ..
        ! .. Intrinsic Functions ..
        INTRINSIC ABS, MAX
        ! ..
        maxerr_re = zero
        maxerr_im = zero

        DO i = 1, m_max*n_max
            temp_re = ABS(REAL(wacc(i))-REAL(w(i)))
            temp_im = ABS(AIMAG(wacc(i))-AIMAG(w(i)))
            IF (REAL(wacc(i))/=zero) THEN
                temp_re = temp_re/ABS(REAL(wacc(i)))
            END IF
            IF (AIMAG(wacc(i))/=zero) THEN
                temp_im = temp_im/ABS(AIMAG(wacc(i)))
            END IF

            maxerr_re = MAX(maxerr_re,temp_re)
            maxerr_im = MAX(maxerr_im,temp_im)
        END DO

    END SUBROUTINE errors

END PROGRAM faddeyeva_driver_rk
