.TH GJQRC 3 "04 November 2003" "Version 1.00"
.\" WARNING: This file was produced automatically from file jacobi/gjqrc.f
.\" by fortran-to-man-page.awk on Tue Nov  4 07:39:17 MST 2003.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
gjqrc \- Gauss-Jacobi logarithmic Quadrature Recursion Coefficients
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "SUBROUTINE gjqrc (a, b, s, t, alpha, beta, nquad, ierr)"
.B "DOUBLE PRECISION    a(0:MAXPTS), alpha,       b(0:MAXPTS), beta"
.B "DOUBLE PRECISION    s(0:MAXPTS), t(0:MAXPTS)"
.B "INTEGER             ierr,        nquad"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gjl.h>"
.RE
to get this prototype:
.RS
.nf
.B "void gjqrc(fortran_double_precision a_[],"
.B "           fortran_double_precision b_[],"
.B "           fortran_double_precision s_[],"
.B "           fortran_double_precision t_[],"
.B "           const fortran_double_precision * alpha_,"
.B "           const fortran_double_precision * beta_,"
.B "           const fortran_integer * nquad_,"
.B "           fortran_integer * ierr_);"
.fi
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.\"=====================================================================
.SH DESCRIPTION
.PP
Compute the recursion coefficients and zeroth and first moments
of the monic polynomials corresponding to the positive weight
function
.PP
.RS
.nf
w(x,\ealpha,\ebeta) = (1\(mix)^\ealpha (1+x)^\ebeta (\(miln((1+x)/2))
.fi
.RE
.PP
with recursion relation (n = 0, 1, 2, .\|.\|.)
.PP
.RS
.nf
P_{n+1}^{\ealpha,\ebeta}(x) =
	    (x \(mi B_n^{\ealpha,\ebeta}) * P_n^{\ealpha,\ebeta}(x)
	    \(mi A_n^{\ealpha,\ebeta} * P_{n\(mi1}^{\ealpha,\ebeta}(x)
.fi
.RE
.PP
and initial conditions
.PP
.RS
.nf
P_{\(mi1}^{\ealpha,\ebeta}(x) = 0
P_{0}^{\ealpha,\ebeta}(x) = 1
.fi
.RE
.PP
Except in the weight function, the superscripts indicate
dependence on \ealpha, NOT exponentiation.
.PP
The required moments are:
.PP
.RS
.nf
T_n^{\ealpha,\ebeta} = \eint_0^\infty w(x,\ealpha,\ebeta) * (P_n^{\ealpha,\ebeta}(x))^2 dx
S_n^{\ealpha,\ebeta} = \eint_0^\infty w(x,\ealpha,\ebeta) * (P_n^{\ealpha,\ebeta}(x))^2 x dx
.fi
.RE
.PP
From these moments, the recursion coefficents are computed as:
.PP
.RS
.nf
A_n^{\ealpha,\ebeta} = T_n^{\ealpha,\ebeta} / T_{n\(mi1}^{\ealpha,\ebeta}
.fi
.RE
.PP
.RS
.nf
B_n^{\ealpha,\ebeta} = S_n^{\ealpha,\ebeta} / T_n^{\ealpha,\ebeta}
.fi
.RE
.PP
On entry:
.PP
.RS
.TP \w'\fBalpha\fP\&'u+2n
\fBalpha\fP\&
Power of (1\(mix) in the integrand (\fBalpha\fP\& > \(mi1).
.TP
\fBbeta\fP\& 
Power of (1+x) in the integrand (\fBbeta\fP\& > \(mi1).
.TP
\fBnquad\fP\&
Number of quadrature points to compute. It
must be less than the limit MAXPTS defined
in the header file,
.I maxpts.inc.
The default value chosen there should be large
enough for any realistic application.
.RE
.PP
On return:
.PP
.RS
.TP \w'\fBa\fP\&(0.\|.\fBnquad\fP\&)'u+2n
\fBa\fP\&(0.\|.\fBnquad\fP\&)
Recursion coefficients:
\fBa\fP\&(n) = A_n^{\ealpha,\ebeta}.
.TP
\fBb\fP\&(0.\|.\fBnquad\fP\&)
Recursion coefficients:
\fBb\fP\&(n) = B_n^{\ealpha,\ebeta}.
.TP
\fBs\fP\&(0.\|.\fBnquad\fP\&)
First moments: \fBs\fP\&(n) = S_n^{\ealpha,\ebeta}.
.TP
\fBt\fP\&(0.\|.\fBnquad\fP\&)
Zeroth moments: \fBt\fP\&(n) = T_n^{\ealpha,\ebeta}.
.TP
\fBierr\fP\&
Error indicator:
.nf
= 0 (success),
1 (eigensolution could not be obtained),
2 (destructive overflow),
3 (\fBnquad\fP\& out of range),
4 (\fBalpha\fP\& out of range).
.fi
.RE
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Fast Gaussian Quadrature for Two Classes of Logarithmic Weight Functions"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 20xx, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
