.TH QGLQF 3 "18 March 2000" "Version 1.00"
.\" WARNING: This file was produced automatically from file laguerre/qglqf.f
.\" by fortran-to-man-page.awk on Tue Nov  4 08:23:53 MST 2003.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
qglqf \- Gauss-Laguerre logarithmic Quadrature with Function values
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "SUBROUTINE qglqf(x, w, wxm1, y, z, alpha, nquad, ierr)"
.B "INTEGER             ierr,        nquad"
.B "REAL*16             alpha,       w(*),        wxm1(*),     x(*)"
.B "REAL*16             y(*),        z(*)"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gjl.h>"
.RE
to get this prototype:
.RS
.nf
.B "void qglqf(fortran_quadruple_precision x_[],"
.B "           fortran_quadruple_precision w_[],"
.B "           fortran_quadruple_precision wxm1_[],"
.B "           fortran_quadruple_precision y_[],"
.B "           fortran_quadruple_precision z_[],"
.B "           const fortran_quadruple_precision * alpha_,"
.B "           const fortran_integer * nquad_,"
.B "           fortran_integer * ierr_);"
.fi
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.\"=====================================================================
.SH DESCRIPTION
.PP
Compute the nodes and weights for the evaluation of the integral
.PP
.RS
.nf
\eint_0^\einfty x^\ealpha e^{\(mix} \eln(x) f(x) dx
.fi
.RE
.PP
as the quadrature sum
.PP
.RS
.nf
\esum_{i=1}^N[W_i(\ealpha)(x_i(\ealpha) \(mi 1)f(x_i(\ealpha)) \(mi Z_i(\ealpha)f(y_i(\ealpha))]
.fi
.RE
.PP
The nonlogarithmic integral
.PP
.RS
.nf
\eint_0^\einfty x^\ealpha e^{\(mix} f(x) dx
.fi
.RE
.PP
can be computed from the quadrature sum
.PP
.RS
.nf
\esum_{i=1}^N[W_i(\ealpha) f(x_i(\ealpha))]
.fi
.RE
.PP
The quadrature is exact to machine precision for f(x) of
polynomial order less than or equal to 2*\fBnquad\fP\& \(mi 2
(logarithmic) or 2*\fBnquad\fP\& \(mi 1 (nonlogarithmic).
.PP
This form of the quadrature requires only values of the
function at 2*\fBnquad\fP\& points. For a faster, and slightly more
accurate, quadrature that requires values of the function and
its derivative at \fBnquad\fP\& points, see the companion routine,
qglqfd().
.PP
On entry:
.PP
.RS
.TP \w'\fBalpha\fP\&'u+2n
\fBalpha\fP\&
Power of x in the integrand (\fBalpha\fP\& > \(mi1).
.TP
\fBnquad\fP\&
Number of quadrature points to compute. It
must be less than the limit MAXPTS defined
in the header file,
.I maxpts.inc.
The default value chosen there should be large
enough for any realistic application.
.fi
.RE
.PP
On return:
.PP
.RS
.TP \w'\fBwxm1\fP\&(1.\|.\fBnquad\fP\&)'u+2n
x(1.\|.\fBnquad\fP\&)
Nodes of the first part of the quadrature,
denoted x_i(\ealpha) above.
.TP
\fBw\fP\&(1.\|.\fBnquad\fP\&)
Weights of the first part of the quadrature,
denoted W_i(\ealpha) above.
.TP
\fBwxm1\fP\&(1.\|.\fBnquad\fP\&)
Scaled weights of the first part of the
quadrature, \fBwxm1\fP\&(i) = \fBw\fP\&(i)*(x(i) \(mi 1).
.TP
\fBy\fP\&(1.\|.\fBnquad\fP\&)
Nodes of the second part of the quadrature,
denoted y_i(\ealpha) above.
.TP
\fBz\fP\&(1.\|.\fBnquad\fP\&)
Weights of the second part of the quadrature,
denoted \(miZ_i(\ealpha) above.
.TP
\fBierr\fP\&
Error indicator:
.nf
= 0 (success),
1 (eigensolution could not be obtained),
2 (destructive overflow),
3 (\fBnquad\fP\& out of range),
4 (\fBalpha\fP\& out of range).
.fi
.RE
.PP
The logarithmic integral can then be computed by code like this:
.PP
.RS
.nf
\fC      sum = 0.0q+00
      do 10 i = 1,nquad
          sum = sum + wxm1(i)*f(x(i)) - z(i)*f(y(i))
   10 continue\fP
.fi
.RE
.PP
The nonlogarithmic integral can be computed by:
.PP
.RS
.nf
\fC      sum = 0.0q+00
      do 20 i = 1,nquad
          sum = sum + w(i)*f(x(i))
   20 continue\fP
.fi
.RE
.PP
.\"=====================================================================
.SH "SEE ALSO"
.BR qglqfd (3),
.BR qglqrc (3).
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Fast Gaussian Quadrature for Two Classes of Logarithmic Weight Functions"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 20xx, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
