.TH QGJQFD 3 "04 November 2003" "Version 1.00"
.\" WARNING: This file was produced automatically from file jacobi/qgjqfd.f
.\" by fortran-to-man-page.awk on Tue Nov  4 07:39:19 MST 2003.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
qgjqfd \- Gauss-Jacobi logarithmic Quadrature with Function and Derivative values
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "SUBROUTINE qgjqfd(x, w, deltaw, deltax, alpha, beta, nquad, ierr)"
.B "INTEGER             ierr,        nquad"
.B "REAL*16             alpha,       beta,        deltaw(*)"
.B "REAL*16             deltax(*),   w(*),        x(*)"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gjl.h>"
.RE
to get this prototype:
.RS
.nf
.B "void qgjqfd(fortran_quadruple_precision x_[],"
.B "            fortran_quadruple_precision w_[],"
.B "            fortran_quadruple_precision deltaw_[],"
.B "            fortran_quadruple_precision deltax_[],"
.B "            const fortran_quadruple_precision * alpha_,"
.B "            const fortran_quadruple_precision * beta_,"
.B "            const fortran_integer * nquad_,"
.B "            fortran_integer * ierr_);"
.fi
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.\"=====================================================================
.SH DESCRIPTION
.PP
Compute the nodes and weights for the evaluation of the integral
.PP
.RS
.nf
\eint_{\(mi1}^{1} (1\(mix)^\ealpha (1+x)^\ebeta \eln(1+x) f(x) dx
            (\ealpha > \(mi1, \ebeta > \(mi1)
.fi
.RE
.PP
as the quadrature sum
.PP
.RS
.nf
\esum_{i=1}^{N}[\edeltaW_i(\ealpha,\ebeta) f(x_i(\ealpha,\ebeta))
            + \edeltax_i(\ealpha,\ebeta) f'(x_i(\ealpha,\ebeta))]
.fi
.RE
.PP
The nonlogarithmic integral
.PP
.RS
.nf
\eint_{\(mi1}^{1} (1\(mix)^\ealpha (1+x)^\ebeta f(x) dx
            (\ealpha > \(mi1, \ebeta > \(mi1)
.fi
.RE
.PP
can be computed from the quadrature sum
.PP
.RS
.nf
\esum_{i=1}^{N}W_i(\ealpha, \ebeta) f(x_i(\ealpha, \ebeta)).
.fi
.RE
.PP
The quadrature is exact to machine precision for f(x) of
polynomial order less than or equal to 2*\fBnquad\fP\& \(mi 1.
.PP
This form of the quadrature requires values of the function 
.I "and its derivative"
at N (== \fBnquad\fP\&) points. For a derivative-free
quadrature at 2N points, see the companion routine, qgjqf().
.PP
On entry:
.PP
.RS
.TP \w'\fBalpha\fP\&'u+2n
\fBalpha\fP\&
Power of (1\(mix) in the integrand (\fBalpha\fP\& > \(mi1).
.TP
\fBbeta\fP\&
Power of (1+x) in the integrand (\fBbeta\fP\& > \(mi1).
.TP
\fBnquad\fP\&
Number of quadrature points to compute. It
must be less than the limit MAXPTS defined
in the header file,
.I maxpts.inc.
The default value chosen there should be large
enough for any realistic application.
.fi
.RE
.PP
On return:
.PP
.RS
.TP \w'\fBdeltax\fP\&(1.\|.\fBnquad\fP\&)'u+2n
\fBx\fP\&(1.\|.\fBnquad\fP\&)
Nodes of the Jacobi quadrature, denoted
x_i(\ealpha,\ebeta) above.
.TP
\fBw\fP\&(1.\|.\fBnquad\fP\&)
Weights of the Jacobi quadrature, denoted
W_i(\ealpha,\ebeta) above.
.TP
\fBdeltaw\fP\&(1.\|.\fBnquad\fP\&)
Weights of the quadrature, denoted
\edeltaW_i(\ealpha,\ebeta) above.
.TP
\fBdeltax\fP\&(1.\|.\fBnquad\fP\&)
Weights of the quadrature, denoted
\edeltax_i(\ealpha,\ebeta) above.
.TP
\fBierr\fP\&
Error indicator:
.nf
= 0 (success),
1 (eigensolution could not be obtained),
2 (destructive overflow),
3 (\fBnquad\fP\& out of range),
4 (\fBalpha\fP\& out of range),
5 (\fBbeta\fP\& out of range).
.fi
.RE
.PP
The logarithmic integral can then be computed by code like this:
.PP
.RS
.nf
\fC      sum = 0.0q+00
      do 10 i = 1,nquad
          sum = sum + deltaw(i)*f(x(i)) + deltax(i)*fprime(x(i))
   10 continue\fP
.fi
.RE
.PP
where \fCfprime(x(i))\fP\& is the derivative of the function f(x) with
respect to x, evaluated at x = \fCx(i)\fP\&.
.PP
The nonlogarithmic integral can be computed by:
.PP
.RS
.nf
\fC      sum = 0.0q+00
      do 20 i = 1,nquad
          sum = sum + w(i)*f(x(i))
   20 continue\fP
.fi
.RE
.PP
.\"=====================================================================
.SH "SEE ALSO"
.BR qgjqf (3),
.BR qgjqrc (3).
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Fast Gaussian Quadrature for Two Classes of Logarithmic Weight Functions"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 20xx, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
