.TH DPSI 3 "03 August 2000" "Version 1.00"
.\" WARNING: This file was produced automatically from file common/dpsi.f
.\" by fortran-to-man-page.awk on Sun Dec 31 09:02:08 MST 2000.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
dpsi \- Double-precision psi(x)
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "DOUBLE PRECISION FUNCTION dpsi(x)"
.B "DOUBLE PRECISION    x"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gampsi.h>"
.RE
to get this prototype:
.RS
.B "fortran_double_precision dpsi(const fortran_double_precision * x_);"
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.PP
Last code modification: 03-Aug-2000
.\"=====================================================================
.SH DESCRIPTION
Compute and return the value of the psi(\fBx\fP\&) function for
double-precision \fBx\fP\&.
.PP
The psi(\fBx\fP\&) function is the logarithmic derivative of the
Gamma(\fBx\fP\&) function:
.PP
.RS
.nf
psi(\fBx\fP\&) = d/dx (Gamma(\fBx\fP\&)) / Gamma(\fBx\fP\&) = d/dx (ln Gamma(\fBx\fP\&))
.fi
.RE
.PP
This code correctly handles the case where \fBx\fP\& is NaN, for which
psi(NaN) is a NaN, and the case where \fBx\fP\& is sufficiently large
and positive, or takes one of the integer values 0, -1, -2, -3,
\&.\|.\|., for which psi(\fBx\fP\&) = +Infinity, a special value in IEEE 754
arithmetic.
.PP
This code is derived from code given by
.PP
.RS
.nf
W. J. Cody
Algorithm 715: SPECFUN --- A Portable FORTRAN
Package of Special Function Routines and Test Drivers
ACM Trans. Math. Software 19(1) 22--32, March 1993.
.fi
.RE
.PP
but has been augmented for support of IEEE 754 arithmetic.
.\"=====================================================================
.SH "SEE ALSO"
.BR dgamma (3),
.BR dpsiln (3),
.BR gamma (3),
.BR psi (3),
.BR psiln (3),
.BR qgamma (3),
.BR qpsi (3),
.BR qpsiln (3).
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Algorithm xxx: Quadruple-Precision Gamma(x) and psi(x) Functions for Real Arguments"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 2001, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
