      SUBROUTINE ZZGETP ( UNIT,   PNUM,  FNUM,  PNAME, FNAME, DESC,
     -                    SOLNS,  INTS,  ORDER, LOOPX, LOOPC, X0,
     -                    NAMES,  PRECNO, ERRFLG,  *              )

C## A R G U M E N T S:
      INTEGER           UNIT,      PNUM,          FNUM,     ERRFLG
      INTEGER           INTS( * ), PRECNO( 3,* ), ORDER( * ), LOOPX( * )
      DOUBLE PRECISION  LOOPC( * ), X0( * ), SOLNS(*)
C!!!! REAL              LOOPC( * ), X0( * ), SOLNS(*)

      CHARACTER * ( * ) PNAME, FNAME, DESC, NAMES

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   D O U B L E   PRECISION.
C!!!!           THIS VERSION IS IN   S I N G L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: GETP.F,V 1.10 91/11/20 10:52:56 BUCKLEY EXP $
C>RCS $LOG:     GETP.F,V $
C>RCS REVISION 1.10  91/11/20  10:52:56  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.9  89/06/30  13:38:17  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  16:42:50  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  12:20:39  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:47:57  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:50:10  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C     THIS SUBROUTINE READS INFORMATION CONCERNING PROBLEM PNUM FROM
C     THE GIVEN FILE AND FROM THE ARRAYS 'NAMES' AND 'PRECNO'.
C
C     PARAMETER DESCRIPTION:
C
C     ON ENTRY:
C         UNIT   - INPUT UNIT NUMBER FOR DAUF
C         PNUM   - PROBLEM NUMBER--SET ON INPUT TO SELECT PROBLEM
C         NAMES  - AN ARRAY OF CHARACTERS THAT CONTAINS THE PROBLEM NAME
C                  AND THE FUNCTION NAME FOR EACH PROBLEM
C         PRECNO - AN INTEGER ARRAY THAT CONTAINS MINIMUM DIMENSION,
C                    THE FUNCTION NUMBER, AND THE RECORD NUMBER
C                    ( OF THE DAUF FILE ) FOR EACH PROBLEM
C
C     ON EXIT:
C         FNUM   - FUNCTION NUMBER
C         PNAME  - PROBLEM NAME
C         FNAME  - FUNCTION NAME
C         DESC   - STRING TO BE FILLED WITH THE PROBLEM DESCRIPTION
C         INTS   - ARRAY TO BE FILLED WITH THE INTEGERS RELATED TO
C                    THE PROBLEM
C         ORDER, LOOPX, LOOPC - ARRAYS TO BE FILLED WITH THE INNER
C                    LOOP DATA
C         X0     - AN ARRAY TO BE FILLED WITH THE STARTING POINT
C
C         ERRFLG - AN ERROR RETURN. IT IS SET TO
C                       0  IF NO ERRORS OCCURRED
C                       1  IF THE PROBLEM NUMBER IS OUT OF RANGE
C                       2  IF NO SUCH PROBLEM NUMBER IS CURRENTLY
C                               DEFINED.
C
C## E N T R Y   P O I N T S:
C
C          ZZGETP - THE NATURAL ENTRY POINT
C          ZZGDEF - DEFINES THE SIZE OF RECORDS IN THE DAUF FILE
C                     AND SOME OTHER CONSTANTS
C
C## S U B R O U T I N E S:
C
C          DBLE(REAL)   ... INTRINSIC
C          RDCH   ... TO READ CHARACTERS FROM DIRECT ACCESS UNF. FILE
C          RDIN   ... TO READ INTEGERS FROM DIRECT ACCESS UNF. FILE
C          RDRL   ... TO READ REALS FROM DIRECT ACCESS UNF. FILE
C          ZZERRM ... OUTPUTS ERROR MESSAGES
C          RD     ... STATEMENT FUNCTION TO CONVERT INTEGERS TO REALS
C
C## P A R A M E T E R S:

      INTEGER     CTOUPP,     CTOLOW,     CTOCAP
      PARAMETER ( CTOUPP = 1, CTOLOW = 2, CTOCAP = 3 )

      CHARACTER*(*) BLANK,        QUOTE,        HASH
      PARAMETER (   BLANK  = ' ', QUOTE  = '"', HASH   = '#' )

      CHARACTER*(*) PERIOD,       COMMA,        SEMICN
      PARAMETER (   PERIOD = '.', COMMA  = ',', SEMICN = ';' )

      CHARACTER*(*) COLON,        DASH,         EQUALS
      PARAMETER (   COLON  = ':', DASH   = '-', EQUALS = '=' )

      CHARACTER*(*) OBRACE,       CBRACE,       UNDERS
      PARAMETER (   OBRACE = '{', CBRACE = '}', UNDERS = '_' )

      CHARACTER*(*) PLUS,         MINUS,        EXCLAM
      PARAMETER (   PLUS   = '+', MINUS  = '-', EXCLAM = '!' )

      CHARACTER*(*) GTHAN,        LTHAN,        QUESMK
      PARAMETER (   GTHAN  = '>', LTHAN  = '<', QUESMK = '?' )

      CHARACTER*(*) SLASH,        BSLASH,       PERCNT
      PARAMETER (   SLASH  = '/', BSLASH = '\\',PERCNT = '%' )

      CHARACTER*(*) CARAT,        ATSIGN,       TILDE
      PARAMETER (   CARAT  = '^', ATSIGN = '@', TILDE = '~' )

      LOGICAL     T,          F
      PARAMETER ( T = .TRUE., F = .FALSE. )

      CHARACTER*(*) TRUE,          QT,       FALSE,           QF
      PARAMETER (   TRUE = 'TRUE', QT = 'T', FALSE = 'FALSE', QF = 'F' )

      INTEGER     ITRUE,     IFALSE
      PARAMETER ( ITRUE = 1, IFALSE = 0 )

      DOUBLE PRECISION  RTRUE,        RFALSE
C!!!! REAL              RTRUE,        RFALSE
      PARAMETER      (  RTRUE = 1.D0, RFALSE = 0.D0 )

C----                    POSITION FLAGS FOR ENTRIES IN PRECNO ARRAY
C   DEFINITIONS OF THE ROWS IN THE ARRAY PRECNO. ( PRECNO HOLDS THE
C   RECORD NUMBER IN THE DAUF FILE, THE MINIMUM DIMENSION, AND THE
C   FUNCTION NUMBER OF EACH PROBLEM. )

      INTEGER     RECN,     DIMN,     FNO1
      PARAMETER ( RECN = 1, DIMN = 2, FNO1 = 3 )
C----                    POSITION FLAGS FOR ENTRIES IN INTS ARRAY

      INTEGER     PPTMAX,     PPTIX0,     PPTDES
      PARAMETER ( PPTMAX = 1, PPTIX0 = 2, PPTDES = 3 )

      INTEGER     PPTORD,     PPTLPX,     PPTLPC,     PPTSOL
      PARAMETER ( PPTORD = 4, PPTLPX = 5, PPTLPC = 6, PPTSOL = 7 )

      INTEGER     NPNTS
      PARAMETER ( NPNTS  = 7 )

C## L O C A L   D E C L:

C----                      STATEMENT FUNCTION
      DOUBLE PRECISION  RD
C!!!! REAL              RD

C---- DECLARE THE NUMBER OF ELEMENTS PER LINE OF UNIT

      INTEGER   CPERLN,  IPERLN,  RPERLN
      INTEGER   SCPRLN,  SIPRLN,  SRPRLN

C----                     PROBLEM AND FUNCTION NAME LENGTHS

      INTEGER     PNAMLN,     FNAMLN,          GNAMLN
      PARAMETER ( PNAMLN = 8, FNAMLN = PNAMLN, GNAMLN = PNAMLN )

      INTEGER     TITLEN,      PDESCL
      PARAMETER ( TITLEN = 72, PDESCL = 72 )
C----                     MAXIMUM NUMBER OF PROBLEMS

      INTEGER     NOFNS,      DFPRBS,       MXGRPS,      MXGSZ
      PARAMETER ( NOFNS = 80, DFPRBS = 450, MXGRPS = 50, MXGSZ = 200 )

C----                     MISC VARIABLES
      INTEGER  I, J, K, RECNO

C## S A V E:
             SAVE   CPERLN, IPERLN, RPERLN

C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
C----                DEFINE STATEMENT FUNCTION
      RD(I) = DBLE(I)
C!!!! RD(I) = REAL(I)

C---- CHECK PROBLEM NUMBER

      ERRFLG = 0

      IF ( PNUM .LE. 0  .AND. PNAME .EQ. BLANK ) THEN
         PNUM = 0
      ELSE IF ( PNUM .LE. 0 ) THEN
         CALL ZZCASE(PNAME,CTOUPP)
         PNUM = 0
         CALL ZZSRCH(PNAME,PNAMLN,NAMES,DFPRBS,PNAMLN+FNAMLN,PNUM,F,T)
      ENDIF

      IF ( PNUM .LT. 1 .OR. PNUM .GT. DFPRBS ) THEN
         ERRFLG = 1
         CALL ZZERRM( RD(PNUM), *91000, 'IT ILLEGAL PROBLEM NUMBER, #' )
         GOTO 90000
      ENDIF

C---- GET INFO FROM THE PRECNO ARRAY.

      FNUM  = PRECNO( FNO1, PNUM )
      RECNO = PRECNO( RECN, PNUM )

      IF ( RECNO .EQ. -1 ) THEN
         ERRFLG = 2
         CALL ZZERRM( RD(PNUM), *91000,'IT HAVE NOT DEFINED PROBLEM #' )
         GOTO 90000
      ENDIF

C---- GET THE NAMES FROM THE NAME ARRAY.

         I = ( PNUM-1 ) * ( FNAMLN+PNAMLN ) + 1
         J = I + PNAMLN - 1
         K = J + FNAMLN
         PNAME = NAMES( I : J )
         FNAME = NAMES( J+1 : K )

C---- READ INTS ARRAY.

         CALL ZZRDIN( UNIT, INTS, NPNTS, IPERLN, RECNO )

C---- READ DESCRIPTION

         CALL ZZRDCH( UNIT, DESC,  INTS(PPTDES), CPERLN, RECNO )

C---- READ INTEGER ARRAYS

         CALL ZZRDIN( UNIT, ORDER, INTS(PPTORD), IPERLN, RECNO )
         CALL ZZRDIN( UNIT, LOOPX, INTS(PPTLPX), IPERLN, RECNO )

C---- READ REAL ARRAY(S)

         CALL ZZRDRL( UNIT, LOOPC, INTS(PPTLPC), RPERLN, RECNO )

         IF ( INTS(PPTIX0) .GT. 0 ) THEN
            CALL ZZRDRL( UNIT, X0, INTS(PPTIX0), RPERLN, RECNO )
         ENDIF

         IF ( INTS(PPTSOL) .GT. 0 ) THEN
            CALL ZZRDRL( UNIT, SOLNS, INTS(PPTSOL), RPERLN, RECNO )
         ENDIF
      GOTO 90000

C## E N T R Y  ZZGDEF:
                     ENTRY ZZGDEF ( SCPRLN, SIPRLN, SRPRLN )
      CPERLN = SCPRLN
      IPERLN = SIPRLN
      RPERLN = SRPRLN
      RETURN

C## E X I T
90000      RETURN
91000      RETURN1

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZGETP.
                    END
