      SUBROUTINE ZZWRIN ( UNIT, LIST, NDATA, NPERLN, RECNO )

C## A R G U M E N T S:
                       INTEGER  UNIT, LIST(*), NDATA, NPERLN, RECNO

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION:        NOT REQUIRED.
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: WRIN.F,V 1.10 91/11/19 16:19:02 BUCKLEY EXP $
C>RCS $LOG:     WRIN.F,V $
C>RCS REVISION 1.10  91/11/19  16:19:02  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.9  89/06/30  13:29:10  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  13:39:44  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  14:27:00  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:44:54  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:30:11  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C     THIS ROUTINE WRITES THE INFORMATION IN THE ARRAY LIST INTO THE
C     TEMPORARY  'UNIT' USING DIRECT ACCESS UNFORMATTED OUTPUT. AFTER
C     WRITING EACH LINE, I.E. RECORD, RECNO IS INCREMENTED BY 1. THUS,
C     ON RETURN, RECNO IS ONE MORE THAN THE NUMBER IF THE LAST RECORD
C     WRITTEN.
C
C     UNIT    - THE UNIT ON WHICH THE INFORMATION IS TO BE WRITTEN.
C     LIST    - THE ARRAY WHICH CONTAINS THE INFORMATION.
C     NDATA   - THE NUMBER OF ELEMENTS IN LIST.
C     NPERLN  - THE MAXIMUM NUMBER OF ELEMENTS ALLOWED FOR EACH RECORD.
C     RECNO   - THE FIRST RECORD NUMBER INTO WHICH THE DATA IS TO BE
C               WRITTEN.
C
C## E N T R Y   P O I N T S: THE NATURAL ENTRY ZZWRIN.
C## S U B R O U T I N E S:   MOD ... INTRINSIC
C## P A R A M E T E R S:     NONE ARE DEFINED.
C## L O C A L   D E C L:
                             INTEGER          I, J, L

C## S A V E:                 NONE SELECTED.
C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
      I = 1

      DO 100 J = 1, NDATA/NPERLN
         WRITE ( UNIT, REC = RECNO ) (LIST(L), L = I, J * NPERLN)
         RECNO = RECNO + 1
         I = I + NPERLN
  100 CONTINUE

      IF ( MOD(NDATA, NPERLN) .NE. 0) THEN
           WRITE ( UNIT, REC = RECNO ) (LIST(L), L = I, NDATA)
           RECNO = RECNO + 1
      ENDIF
      GOTO 90000

C## E X I T
90000      RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZWRIN.
                    END
