      SUBROUTINE BBNOCE ( H, V, HV, N, ITER, M, IDENTY, ARO,
     -                                   INNER, IW, RW, DW   )

C## A R G U M E N T S:
                      INTEGER          N, ITER, M, IW(*)
                      LOGICAL          IDENTY

                      DOUBLE PRECISION H(*), V(N), HV(N), ARO(N)
C!!!!                 REAL             H(*), V(N), HV(N), ARO(N)

                      EXTERNAL                INNER
                      DOUBLE PRECISION DW(*), INNER
                      REAL             RW(*)

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   D O U B L E   PRECISION.
C!!!!           THIS VERSION IS IN   S I N G L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: NOCE.F,V 1.12 91/12/31 14:53:06 BUCKLEY EXP $
C>RCS $LOG:     NOCE.F,V $
C>RCS REVISION 1.12  91/12/31  14:53:06  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.11  91/11/22  11:32:22  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.10  90/07/31  10:50:07  BUCKLEY
C>RCS ADDED REVISED BLAS.
C>RCS
C>RCS REVISION 1.9  89/06/30  13:27:37  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  17:15:35  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  12:39:25  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:55:35  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:54:29  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C     GIVEN THE QUASI NEWTON UPDATE MATRIX  H (IN PRODUCT FORM) AND
C     GIVEN THE VECTOR V, THIS ROUTINE COMPUTES
C
C               HV = H * V  .
C
C     IT IS BASED ON THE SUM FORM VERSION OF THIS ROUTINE, BBMULT.
C
C-----NOTE THAT A NUMBER OF PARAMETERS WHICH WILL BE THE SAME
C     FOR EACH CALL TO BBNOCE DURING ANY PARTICULAR MINIMIZATION
C     PROBLEM ARE SET JUST ONCE THROUGH AN ENTRY POINT.
C
C------EACH UPDATE TERM OF H REQUIRES 2N+1 ENTRIES OF H. THE ORDER IS
C
C                   ETA(I),  S(I) AND  Y(I).
C
C      EACH BLOCK OF 2N+1 ENTRIES IS CALLED A "TERM" OF THE UPDATE.
C
C      HERE    N    = THE DIMENSION OF THE PROBLEM
C              S    = X[I] - X[I-1] = ALPHA * D
C              Y    = G[I] - G[I-1]
C              ETA  = S' * Y
C      THESE UPDATES ARE STORED IN CIRCULAR, I.E. WRAPAROUND, FASHION
C      IN THE AVAILABLE STORAGE.
C
C      SEE BBMULT REGARDING THE USE OF INNER AND FOR OTHER COMMENTS.
C      SOME SUPPLEMENTARY COMMENTS TO THOSE IN BBMULT FOLLOW.
C
C--ITER   ITERATION NUMBER OF CURRENT POINT X[ITER]
C--M      NUMBER OF UPDATES WHICH CAN BE STORED
C--ARO    A SCRATCH VECTOR
C
C--BETA   IS THE PARAMETER DEFINING THE BROYDEN FAMILY
C         OF UPDATES. BETA MUST BE 1 FOR PRODUCT UPDATES.
C
C--SCGAMM THE VALUE GAMALL IS NOT ALLOWED WITH PRODUCT FORM UPDATES,
C         ALTHOUGH THE VALUE GAMONE IS PERMITTED.
C
C--CMPALL IS NOT IMPLEMENTED.
C
C--INCR   IS THE CONSTANT 2N+1, THE LENGTH OF EACH TERM.
C
C--TRACES TURN ON TR TO SEE  HV. THIS WILL BE ON THE UNIT TRACUN.
C         NOTE THAT TRV SEPARATELY CONTROLS TRACING OF VECTORS.
C         VECTORS ARE TRACED ONLY IF TRV IS TRUE AS WELL.
C
C## E N T R Y   P O I N T S: BBNOCE  THE NATURAL ENTRY POINT.
C                            BBSNOC   SET FIXED PARAMETERS.
C## S U B R O U T I N E S:   MOD, MIN INTRINSICS
C## P A R A M E T E R S:

      LOGICAL     DONORM,          NONORM
      PARAMETER ( DONORM = .TRUE., NONORM = .FALSE. )

      INTEGER     GAMOFF,     GAMONE,     GAMALL
      PARAMETER ( GAMOFF = 0, GAMONE = 1, GAMALL = 2 )

C## L O C A L   D E C L:

      INTEGER          COUNT,  K, IS, I, IY, IETA, LAST

      DOUBLE PRECISION SV, BETAK, NU
C!!!! REAL             SV, BETAK, NU

C-----VARIABLES FOR THE ENTRY POINT.

      LOGICAL     TR,  TRV,  SCDIAG
      LOGICAL    STR,  STRV, SSCDAG

      INTEGER     SCGAMM,  INCR,  BASE, TRACUN
      INTEGER     SSCGAM, SINCR, SBASE, STRACN

C## S A V E:
            SAVE   TR, TRV, SCDIAG, SCGAMM, INCR, BASE, TRACUN

C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NO VALUES ARE SET.
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
      IF ( TR ) WRITE (TRACUN,*) ' ***[NOCE ENTERED]***'

C     INITIALIZE COUNTERS.

      COUNT = MIN (ITER,M)

      IF ( ITER .GT. 0 ) THEN

C        DO THE FIRST ITERATION OF THE FIRST HALF OF NOCEDAL'S RECURSION.

         LAST = MOD(ITER-1,M)
         IETA = BASE + LAST*INCR +1
         IS   = IETA + 1
         IY   = IS   + N - 1
         LAST = LAST + 1

         SV = INNER ( N, H(IS), V, NONORM, IW, RW, DW )
         ARO(LAST) =  SV / H(IETA)

         CALL ZZCOPY ( N, V, 1, HV, 1 )
         CALL ZZAXPY ( N, -ARO(LAST), H(IY+1), 1, HV, 1 )

C           DO THE REMAINING ITERATIONS OF THE FIRST HALF.

         DO 200 I = 1,COUNT-1
            IETA = IETA - INCR
            IF ( IETA .LE. BASE ) IETA = IETA + M*INCR
            IS   = IETA + 1
            IY   = IS   + N - 1

            LAST = LAST - 1
            IF ( LAST .EQ. 0 ) LAST = M

            SV = INNER ( N, H(IS), HV, NONORM, IW, RW, DW )
            ARO(LAST) = SV/H(IETA)

            CALL ZZAXPY ( N, -ARO(LAST), H(IY+1), 1, HV, 1 )
  200    CONTINUE
      ENDIF

C     SET HV = H0 * HV, WHERE H0 IS THE INITIAL POSITIVE
C     DEFINITE MATRIX, WHICH MAY BE EITHER THE IDENTITY
C     OR A DIAGONAL SCALING MATRIX.

      IF ( ITER .GT. 0 ) THEN
         IF (SCDIAG .AND. .NOT. IDENTY) THEN
            DO 220 K=1,N
               HV(K) = H(K) * HV(K)
  220       CONTINUE
         ENDIF
         IF ( SCGAMM .EQ. GAMONE ) THEN
            NU = INNER ( N, H(IY+1), H(IY+1), NONORM, IW, RW, DW )
            CALL ZZSCAL ( N, H(IETA)/NU, HV, 1 )

         ENDIF
      ELSE IF ( SCDIAG .AND. .NOT. IDENTY ) THEN
         DO 230 K=1,N
            HV(K) = H(K) * V(K)
  230    CONTINUE
      ELSE
         CALL ZZCOPY ( N, V, 1, HV, 1 )
      ENDIF

C               COMPUTE THE TERMS OF THE SECOND HALF OF THE PRODUCT.
      IS = IS - 1
      IY = IY + 1
      DO  4000 I= 1, COUNT
         BETAK = INNER ( N, H(IY), HV, NONORM, IW, RW, DW )
         CALL ZZAXPY( N, (ARO(LAST) - BETAK/H(IETA)), H(IS+1), 1, HV, 1)
         LAST = MOD(LAST,M) + 1
         IETA = IETA + INCR
         IF ( IETA .GT. BASE+M*INCR ) IETA = BASE + 1
         IS = IETA
         IY = IS + N + 1
 4000 CONTINUE
      IF ( TRV .AND. TR ) WRITE (TRACUN, * ) ' [NOCE] H*V->',HV
      GOTO 90000

C## E N T R Y  BBSNOC:
                      ENTRY  BBSNOC ( STR,      STRV,    SSCDAG,
     -                             SSCGAM, STRACN, SBASE, SINCR )
      TR     = STR
      TRV    = STRV
      SCDIAG = SSCDAG
      SCGAMM = SSCGAM
      TRACUN = STRACN
      BASE   = SBASE
      INCR   = SINCR
      RETURN

C## E X I T

90000        IF ( TR ) WRITE (TRACUN,*) ' ===[LEAVING NOCE].'
      RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF BBNOCE.
                    END
