      SUBROUTINE BBVSCG( FUNCNM, N, X, F, G, ACCT, STATUS, ITERS, FNCCT,
     -                   WORK, LWORK                                 )

C## A R G U M E N T S:
                      EXTERNAL  FUNCNM
                      INTEGER   N, STATUS, ITERS,  FNCCT, LWORK

              DOUBLE PRECISION X(N),F,G(N),ACCT,WORK(LWORK+1), FUNCNM
C!!!!         REAL             X(N),F,G(N),ACCT,WORK(LWORK+1), FUNCNM

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION: NEEDED (SEE CONVRT).
C
C               IGNORE LINES BEGINNING WITH  "C!!!!" .
C
C               THIS VERSION IS IN   D O U B L E   PRECISION.
C!!!!           THIS VERSION IS IN   S I N G L E   PRECISION.
C
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: VSCG.F,V 1.12 91/11/22 11:34:51 BUCKLEY EXP $
C>RCS $LOG:     VSCG.F,V $
C>RCS REVISION 1.12  91/11/22  11:34:51  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.11  90/07/31  10:50:25  BUCKLEY
C>RCS ADDED REVISED BLAS.
C>RCS
C>RCS REVISION 1.10  90/06/25  16:27:07  BUCKLEY
C>RCS WORKING REVISION; CHECKING OUT TOMS VERSION FOR FIX
C>RCS
C>RCS REVISION 1.9  89/06/30  13:27:53  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.2  89/05/15  14:55:43  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:54:31  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C    THIS ROUTINE ACTS AS AN INTERMEDIARY BETWEEN THE CALLING ROUTINE
C    AND THE ACTUAL MINIMIZATION ROUTINE  BBLNIR.  IT JUST SERVES TO
C    SIMPLIFY THE CALLING SEQUENCE A LITTLE FOR THE USER, TO SIMPLIFY
C    THE ARRAY REFERENCING WITHIN THE ALGORITHM BBLNIR AND TO SET ALL
C    DEFAULTS AND DO INITIALIZATION FOR ROUTINES ZZEVAL, ZZPRNT AND
C    ZZTERM USED BY BBLNIR, AS WELL AS FOR BBLNIR ITSELF.
C
C    THE PARAMETERS ARE EXPLAINED IN THE DESCRIPTION SECTION OF BBLNIR,
C    WITH THE EXCEPTION OF THE ARRAY WORK.  IT IS A REAL (OR DOUBLE
C    PRECISION) ARRAY WHICH IS SPLIT UP INTO SUBARRAYS TO PASS TO
C    BBLNIR.
C
C    NOTE THAT  LWORK  IS THE TOTAL AMOUNT OF STORAGE AVAILABLE AS
C    PASSED TO BBVSCG;  HDIM IS PASSED TO BBLNIR AS THE WORKING STOR-
C    AGE AVAILABLE FOR THE ARRAY H.  THUS LWORK MUST BE OF SIZE
C    HDIM + 3*N, WHERE  HDIM IS THE AMOUNT REQUIRED FOR BBLNIR.
C    THE MINIMUM REQUIREMENT FOR  LWORK IS  3N, BUT THAT LEAVES
C    NONE FOR HDIM.  SEE  "METH" IN BBLNIR FOR FURTHER INFORMATION
C    ABOUT THE DIMENSION OF WORK.  WE RECOMMEND A MINIMUM OF 5N+2
C    FOR LWORK.

C N.B.
C    WORK MUST CONTAIN AT LEAST 1 ELEMENT MORE THAN THE VALUE
C    GIVEN BY LWORK. THIS IS BECAUSE THE BALANCE IS USED FOR
C    THE RW/DW ARRAY. SEE THE EXTERNAL DOCUMENTATION.
C
C## E N T R Y   P O I N T S: BBVSCG   THE NATURAL ENTRY POINT.
C                            BBVIDF   REDEFINE ENTRY STATUS CODES.
C                            BBVSDF   REDEFINE EXIT STATUS CODES.
C
C## S U B R O U T I N E S:
C
C     BBLNIR ...THE MAIN MINIMIZATION ALGORITHM.
C     BBDFLT ...TO SET UP ZZPRNT, ZZEVAL, ZZTERM AND BBLNIR.
C     BBEGET ...TO GET DATA FROM ZZEVAL.
C     BBPGET ...TO GET DATA FROM ZZPRNT.
C     ZZINNR ...FOR COMPUTING EUCLIDEAN INNER PRODUCTS.
C     ZZSECS ...FOR TIME.
C
C## P A R A M E T E R S:

C--ON ENTRY:
      INTEGER     CNORML,     CRCSTR,     CRCRPT,     CRCNFG
      PARAMETER ( CNORML = 0, CRCSTR = 1, CRCRPT = 2, CRCNFG = 3 )

      INTEGER     CNRMFG,      CPSTHR
      PARAMETER ( CNRMFG = -1, CPSTHR = -2 )

C--ON EXIT:
      INTEGER     CDONE,     CRCF,     CRCFG,     CRCG
      PARAMETER ( CDONE = 0, CRCF = 1, CRCFG = 2, CRCG = 3 )

      INTEGER     CNSTOR,      CIPMIN,      CIPUNF,      CBDMTH
      PARAMETER ( CNSTOR = -1, CIPMIN = -2, CIPUNF = -3, CBDMTH = -4 )

      INTEGER     CLSFAL,      CNODSC,      CXSFNC,      CPSBCK
      PARAMETER ( CLSFAL = -5, CNODSC = -6, CXSFNC = -7, CPSBCK = -8  )

      INTEGER     CRABRT,      CUSERV
      PARAMETER ( CRABRT = -9, CUSERV = -10 )
      DOUBLE PRECISION  ZERO,       ONE,       TWO,       THREE
C!!!! REAL              ZERO,       ONE,       TWO,       THREE
      PARAMETER (       ZERO = 0D0, ONE = 1D0, TWO = 2D0, THREE = 3D0)

      DOUBLE PRECISION  FOUR,       FIVE,      SIX,       SEVEN
C!!!! REAL              FOUR,       FIVE,      SIX,       SEVEN
      PARAMETER (       FOUR = 4D0, FIVE = 5D0,SIX = 6D0, SEVEN = 7D0)

      DOUBLE PRECISION  EIGHT,         NINE,          TEN
C!!!! REAL              EIGHT,         NINE,          TEN
      PARAMETER (       EIGHT = 8D0,   NINE = 9D0,    TEN = 10D0     )

C## L O C A L   D E C L:

      INTEGER   HDIM, ID,   IX,    IG,    IH, IW(1), FNCT, GRCT, ITCT

      INTEGER SNRMFG, SNORML, SRCSTR, SRCRPT, SRCNFG, SPSTHR
      INTEGER NORMFG, NORMAL, RCSTRT,  RCRPT, RCNOFG, PSTHRU

      INTEGER SDONE,  SRCF,   SRCFG,    SRCG, SNSTOR, SIPMIN, SPSBCK
      INTEGER DONE,   RCF,    RCFG,     RCG,  NOSTOR, IPMIN,  PSBACK
      INTEGER SIPUNF, SBDMTH, SLSFAL, SNODSC, SXSFNC, SRABRT, SUSERV
      INTEGER IPUNDF, BDMETH, LSFAIL, NODESC, XSFUNC, RABORT, USERV

C *** NOTE THAT THESE DECLARATIONS ARE **DELIBERATELY** REVERSED FROM
C *** THE NORMAL REAL/DOUBLE PRECISION PAIRS!
      REAL               RW(1)
C!!!! DOUBLE PRECISION   DW(1)

      EXTERNAL           ZZINNR
      DOUBLE PRECISION   ZZINNR

      DOUBLE PRECISION   DECRF, TT, TIME
C!!!! REAL               DECRF, TT, TIME

C## S A V E:

      SAVE  HDIM, ID, IX, IG, IH, DECRF, TT
      SAVE  NORMFG, NORMAL, RCSTRT, RCRPT, RCNOFG, PSTHRU
      SAVE  DONE,   RCF,    RCFG,   RCG,  NOSTOR,  IPMIN, IPUNDF, BDMETH
      SAVE  LSFAIL, NODESC, RABORT, XSFUNC, USERV, PSBACK

C## C O M M O N:             NONE IS DEFINED.
C## D A T A:

      DATA  NORMFG/CNRMFG/, NORMAL/CNORML/, RCSTRT/CRCSTR/,
     -      RCRPT /CRCRPT/, RCNOFG/CRCNFG/, PSTHRU/CPSTHR/

      DATA  DONE  /CDONE/,  RCF   /CRCF/,   RCFG  /CRCFG/,  RCG/CRCG/
     -      NOSTOR/CNSTOR/, IPMIN /CIPMIN/, IPUNDF/CIPUNF/,
     -      BDMETH/CBDMTH/, LSFAIL/CLSFAL/, NODESC/CNODSC/,
     -      RABORT/CRABRT/, XSFUNC/CXSFNC/, USERV /CUSERV/,
     -      PSBACK/CPSBCK/
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
      IF ( STATUS .EQ. NORMAL .OR. STATUS .EQ. NORMFG
     -                        .OR. STATUS .EQ. RCSTRT ) THEN
C        START TIMING.
         CALL ZZSECS (TT)

C        SET DEFAULTS.
         CALL BBDFLT ( ITERS,  FNCCT )

C        DEFINE POINTERS TO SUBDIVIDE WORK.
         ID = 1
         IX = ID + N
         IG = IX + N
         IH = IG + N

C        DETERMINE REMAINING STORAGE AVAILABLE FOR  H.
         HDIM = LWORK - 3*N

C        SET EXPECTED DECREASE IN F TO BE UNKNOWN.
         DECRF = -ONE
      ENDIF

C-----CALL ROUTINE FOR ACTUAL MINIMIZATION.

      CALL BBLNIR( FUNCNM, N, X, F, DECRF, G, ACCT, STATUS, ZZINNR,
     - WORK(ID), WORK(IX), WORK(IG), WORK(IH),HDIM,IW,RW,WORK(LWORK+1))
C!!!!- WORK(ID), WORK(IX), WORK(IG), WORK(IH),HDIM,IW,WORK(LWORK+1),DW)

C-----RESET TIME, ITERATION COUNT AND FUNCTION COUNT BEFORE RETURN.

      IF (     STATUS .NE. RCF .AND. STATUS .NE. RCFG
     -   .AND. STATUS .NE. RCG .AND. STATUS .NE. PSBACK ) THEN

         IF ( STATUS .EQ. NOSTOR .OR. STATUS .EQ. IPMIN .OR.
     -        STATUS .EQ. IPUNDF .OR. STATUS .EQ. BDMETH ) THEN
            FNCCT  = 0
            ITERS  = 0
         ELSE
            CALL ZZEGET( FNCT,  GRCT, TIME )
            CALL ZZPGET( TIME, ITCT )
            FNCCT  = FNCT
            ITERS  = ITCT
         ENDIF
         CALL ZZSECS( TIME )
         ACCT   = TIME - TT
      ENDIF
      GOTO 90000

C## E N T R Y  BBVIDF: SET VALUES FOR STATUS *PASSED INTO* BBLNIR.
                    ENTRY  BBVIDF ( SNRMFG, SNORML, SRCSTR, SRCRPT,
     -                              SRCNFG, SPSTHR )
      NORMFG = SNRMFG
      NORMAL = SNORML
      RCSTRT = SRCSTR
      RCRPT  = SRCRPT
      RCNOFG = SRCNFG
      PSTHRU = SPSTHR
      RETURN

C## E N T R Y  BBVSDF:
C                   SET VALUES FOR STATUS *RETURNED BY* BBLNIR.

      ENTRY  BBVSDF ( SDONE,  SRCF,   SRCFG,    SRCG, SNSTOR, SIPMIN,
     -        SIPUNF, SBDMTH, SLSFAL, SNODSC, SXSFNC, SRABRT, SUSERV,
     -        SPSBCK )
      DONE   = SDONE
      RCF    = SRCF
      RCFG   = SRCFG
      RCG    = SRCG
      NOSTOR = SNSTOR
      IPMIN  = SIPMIN
      IPUNDF = SIPUNF
      BDMETH = SBDMTH
      LSFAIL = SLSFAL
      NODESC = SNODSC
      XSFUNC = SXSFNC
      RABORT = SRABRT
      USERV  = SUSERV
      PSBACK = SPSBCK
      RETURN

C## E X I T
90000       RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF BBVSCG.
                    END
