      SUBROUTINE ZZRDIN ( UNIT, LIST, NDATA, NPERLN, RECNO )

C## A R G U M E N T S:
                      INTEGER  UNIT, LIST(*), NDATA, NPERLN, RECNO

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION:        NOT REQUIRED.
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: RDIN.F,V 1.10 91/11/19 16:17:13 BUCKLEY EXP $
C>RCS $LOG:     RDIN.F,V $
C>RCS REVISION 1.10  91/11/19  16:17:13  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.9  89/06/30  13:29:03  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  13:39:38  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  14:26:50  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:44:42  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:30:09  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C     THIS ROUTINE READS THE INFORMATION FROM THE 'UNIT' INTO THE
C     ARRAY LIST USING DIRECT ACCESS UNFORMATTED INPUT. AFTER
C     READING EACH LINE, I.E. EACH RECORD, RECNO IS INCREMENTED BY 1.
C     THUS, ON RETURN, RECNO IS ONE MORE THAN THE NUMBER OF THE LAST
C     RECORD READ.
C
C     UNIT    - THE UNIT ON WHICH THE INFORMATION RESIDES.
C     LIST    - THE ARRAY INTO WHICH THE INFORMATION IS TO BE READ.
C     NDATA   - THE NUMBER OF ELEMENTS TO BE READ FROM UNIT.
C     NPERLN  - THE MAXIMUM NUMBER OF ELEMENTS IN EACH RECORD OF UNIT.
C     RECNO   - THE FIRST RECORD NUMBER ON UNIT FROM WHICH THE
C               INFORMATION CAN BE READ.
C
C## E N T R Y   P O I N T S: THE NATURAL ENTRY ZZRDIN.
C## S U B R O U T I N E S:   MOD ... INTRINSIC
C## P A R A M E T E R S:     NONE ARE DEFINED.
C## L O C A L   D E C L:
                             INTEGER          I, J, L

C## S A V E:                 NONE SELECTED.
C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
      I = 1

      DO 100 J = 1, NDATA/NPERLN
         READ ( UNIT, REC = RECNO ) ( LIST(L), L = I, J * NPERLN )
         RECNO = RECNO + 1
         I = I + NPERLN
  100 CONTINUE

      IF ( MOD(NDATA, NPERLN) .NE. 0) THEN
           READ ( UNIT, REC = RECNO ) ( LIST(L), L = I, NDATA )
           RECNO = RECNO + 1
      ENDIF
      GOTO 90000

C## E X I T
90000       RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZRDIN.
                    END
