function [A,L,D] = agl5
%  agl5 --> Ashcraft-Grimes-Lewis 5-times-5 test problem for LDL' factorization
%
%  <Synopsis>
%    [A,L,D] = agl5
%
%  <Description>
%    Generates a 5-times-5 test problem for the LDL' factorization, such that
%    L has a large entry when partial pivoting (Bunch-Kaufman) is used.

%  <References>
%  [1] C. Ashcraft, R.G. Grimes and J.G. Lewis, "Accurate symmetric indefinite
%      linear equation solvers," SIAM J. Matrix Anal. Appl., 20 (1999),
%      pp. 513-561.
%
%  <Revision>
%    Per Christian Hansen, IMM, Technical University of Denmark
%
%    Last revised: March 5, 2000
%------------------------------------------------------------------------------

L = [1      0     0  0  0;
     1      1     0  0  0;
     1      0     1  0  0;
     1 -20/13 -8/17  1  0;
     1 6e6/13 -1/17  0  1];
  
D = [1       0        0        0     0;
     0 1e-19/3   6e-7/7        0     0;
     0  6e-7/7 -3e-6/13        0     0;
     0       0        0 -4e-5/17   2/7;
     0       0        0      2/7 1/300];
    
A = L*D*L';
A = triu(A) + triu(A,1)'; % Ensures that A is exactly symmetric.

%-----------------------------------------------------------------------
% End of function agl5
%-----------------------------------------------------------------------