% UTV Expansion Pack.
% Version 1.0  February 3, 2005.
%
% Demonstration.
%   lsvdrrdemo  - Demo of lsvdrr routine for NMR data.
%   ullivdemo   - Demo of ulliv for noise and interference reduction.
%   vsviddemo   - Demo of symmetric indefinite VSV computations.
%
% VSV-Based Solver.
%   tvsv        - Solves a symmetric numerically rank-deficient system of equations.
%
% High-Rank Revealing VSV Algorithms.
%   hvsvid_L    - Decomposition of symmetric indefinite matrix, L version.
%   hvsvid_R    - Decomposition of symmetric indefinite matrix, R version.
%   hvsvsd      - Decomposition of symmetric semidefinite matrix.
%
% Low-Rank Revealing VSV Algorithms.
%   lvsvid      - Decomposition of symmetric indefinite matrix.
%   lvsvsd      - Decomposition of symmetric semidefinite matrix.
%
% Block QR Refinement.
%   vsv_qrit    - Refinement of VSV decomposition by block QR iterations.
%
% VSV Up- and Downdating.
%   vsvid_L_mod - Rank-one modification of indef. VSV decomposition, L version.
%   vsvid_R_mod - Rank-one modification of indef. VSV decomposition, R version.
%   vsvsd_up    - Rank-one update of semidefinite VSV decomposition.
%
% QLP Factorizations.
%   hqlp        - High-rank gap-revealing QLP factorization.
%   lqlp        - Compute a QLP matrix approximation of a low-rank matrix.
%
% ULLIV Algorithms.
%   ulliv       - Rank-revealing ULLV decomposition, B has full row rank.
%   ulliv_up_A  - Update the A-matrix in the ULLV decomposition.
%   ulliv_up_B  - Update the B-matrix in the ULLV decomposition.
%
% Lanczos SVD algorithm.
%   lsvsrr      - Lanczos SVD algorithm with reorthogonalization and expl. restarts.
%   getrtzp     - Compute Ritz pairs for a cross-product matrix (for lsvdrr).
%   tprod       - Toeplitz matrix-vector multiplication via FFT.
%   tprodinit   - Initialization routine for tprod.
%
% Misc. Tools.
%   agl5        - Ashcraft-Grimes-Lewis 5-times-5 test matrix for LDL' factorization.
%   app_hyp     - Apply a stabilized hyperbolic rotation.
%   app_qrot    - Apply a quadratic rotation.
%   csi-10-10   - math-file with NMR data for lsvdrrdemo (from BioSource data base).
%   gen_hyp     - Generate a hyperbolic rotation.
%   gen_qrot    - Generate a quadratic rotation.
%   hvsvid_cdef - Column deflation of upper triangular matrix in indef. VSV decomp.
%   hvsvid_rdef - Row deflation of lower triangular matrix in indef. VSV decomp.
%   lvsvid_cdef - Column deflation of lower triangular matrix in indef. VSV decomp.
%   TOTinviter  - Inverse iterations applied to T'*Omega*T.
%   TOTlanczos  - Lanczos method applied to T'*Omega*T.
%   TOTpowiter  - Power iterations applied to T'*Omega*T.
%   vsvid_ip    - Interim processor for indefinite VSV decomposition.
%
% Functions from the Matrix Computation Toolbox by N.J. Higham.
%   cholp       - Pivoted Cholesky factorization.
%   ldlt_symm   - LDL' factorization with symmetric or rook pivoting.

%  <Revision>
%    Ricardo D. Fierro, California State University San Marcos
%    Per Christian Hansen, IMM, Technical University of Denmark
%
%    Last revised: January 2, 2005.
%-----------------------------------------------------------------------