function [u1,u2,dd1,dd2] = app_qrot(v1,v2,c,s,d1,d2,sgn)
%  app_qrot --> Apply a quadratic rotation (left/right).
%
%  <Synopsis>
%    [u1,u2,dd1,dd2] = app_qrot(v1,v2,c,s,d1,d2,sgn)
%
%  <Description>
%    Apply a quadratic rotation H, defined by the parameters c and s,
%    from the left to the row vectors v1 and v2 such that
%
%                   [u1] = H [v1]
%                   [u2]     [v2]
%
%    or from the right to the column vectors v1 and v2 such that
%
%                [u1 u2] = [u1 u2] H'
%
%    Also update the signature matrix:
%
%                [dd1  0 ] = sgn*[d1  0 ]
%                [ 0  dd2]       [ 0  d2]
%
%    where sgn is determined by the rotation.
%
%  <See Also>
%    gen_qrot --> Determine a 2-by-2 quadratic rotation.

%  <Revision>
%    Per Christian Hansen, IMM, Technical University of Denmark
%
%    Last revised: February 28, 1999
%-----------------------------------------------------------------------

if (d1*d2 == 1)
  % Givens rotation.
  u1 = c*v1 + s*v2;
  u2 = c*v2 - s*v1;
  dd1 = d1;
  dd2 = d2;
else
  % Stabilized hyperbolic rotation.
  [u1,u2] = app_hyp(v1,v2,c,s,sgn);
  dd1 = sgn*d1;
  dd2 = sgn*d2;
end

%-----------------------------------------------------------------------
% End of function app_qrot
%-----------------------------------------------------------------------