function [c,s,r,sgn] = gen_qrot(a,b,d1,d2)
%  gen_qrot --> Determine a 2-by-2 quadratic rotation matrix.
%
%  <Synopsis>
%    [c,s,r,sgn] = gen_qrot(a,b,d1,d2)
%
%  <Description>
%    Compute a real quadratic (Givens or hyperbolic) rotation H to
%    annihilate b using a, i.e., compute c, s, and r such that
%
%        H [a] = [r]   with   H' S H = sgn*S
%          [b]   [0]
%
%    where the signature matrix S is
%
%        S = [ d1  0 ] ,   d1,d2 = +1,-1 .
%            [ 0  d2 ]
%
%  <See Also>
%    app_qrot --> Apply a quadratic rotation.

%  <Revision>
%    Per Christian Hansen, IMM, Technical University of Denmark
%
%    Last revised: February 28, 1999
%-----------------------------------------------------------------------

if (d1*d2 == 1)
  [c,s,r] = gen_giv(a,b);
  sgn = 1;
else
  [c,s,r,sgn] = gen_hyp(a,b);
end

%-----------------------------------------------------------------------
% End of function gen_qrot
%-----------------------------------------------------------------------